
(* ---------------------------------------------------------------
Title         Space Reserver
Notes
Bugs
Wish List

--------------------------------------------------------------- *)

MODULE Reserve;

IMPORT Lib;
IMPORT Str;
IMPORT SYSTEM;
IMPORT FIO;

FROM IO IMPORT WrLn,WrStr;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XsupportLFN;

(* ------------------------------------------------------------ *)

CONST
    exclam        = "!";
    star          = "*";
    colon         = ":";
    dot           = ".";
    hbar          = "|"; (* DOS pipe symbol cannot belong to a filename *)
    backslash     = "\";
    charnull      = 0C;
    msg           = "Filling, please wait...";
CONST
    HUGEMAXSIZE   = MAX(LONGINT);
    sMAXGB        = "2 Gb";
    sMAXBYTES     = "2147483647"; (* match HUGEMAXSIZE *)
CONST
    ProgEXEname   = "RESERVE";
    ProgTitle     = "Q&D Space Reserver";
    ProgVersion   = "v1.1b";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone             = 0;
    errHelp             = 1;
    errOption           = 2;
    errSyntax           = 3;
    errFillerValue      = 4;
    errJoker            = 5;
    errUnit             = 6;
    errSizeValue        = 7;
    errExists           = 8;
    errGetFree          = 9;
    errCreate           = 10;
    errZeroLeft         = 11;
    errNoExtension      = 12;
    errAborted          = 13;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr = CHR(13);
    lf = CHR(10);
    nl = cr+lf;
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msgHelp =
Banner+nl+
nl+
"Syntax 1 : "+ProgEXEname+" <size> <file> [value] [option]..."+nl+
"Syntax 2 : "+ProgEXEname+" <"+star+"> <file> [value] [option]..."+nl+
"Syntax 3 : "+ProgEXEname+" <"+exclam+"> <file> [value] [option]..."+nl+
nl+
"  -o overwrite existing <file>"+nl+
"  -x disable FAT32 support even if available"+nl+
"  -v verbose"+nl+
nl+
"With syntax 1, <file> is created with specified <size>."+nl+
"With syntax 2, <file> is created using free space size."+nl+
"With syntax 3, program creates as many files as needed to fill free space"+nl+
"(extension will be incremented from .001 upwards)."+nl+
nl+
"Optional value specifies what (hexa)decimal byte value fills created file(s),"+nl+
'"'+star+'" specifying random values.'+nl+
nl+
"Whatever the syntax, unit is either default or unit specified in <file> name."+nl+
"Note <file> MUST be a short-form DOS name."+nl+
nl+
"Maximum filesize is limited to "+sMAXBYTES+" bytes ("+sMAXGB+")."+nl+
nl+
"From Win 9X, program calls interrupt $21 with AX=$7303 ;"+nl+
"if -x option was specified, it uses regular AH=$36 DOS call."+nl+
nl+
"Examples : "+ProgEXEname+" 2048 filler.dat *"+nl+
"           "+ProgEXEname+" * filler.bin 255"+nl+
"           "+ProgEXEname+" ! filler $ff"+nl;

VAR
    S : str128;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msgHelp);
    | errOption :
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errSyntax:
        S := "Syntax error, check help screen !";
    | errFillerValue:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," filler byte value !");
    | errJoker:
        Str.Concat(S,"At least one illogical joker in ",einfo);Str.Append(S," !");
    | errUnit:
        Str.Concat(S,"Illegal unit in ",einfo);Str.Append(S," !");
    | errSizeValue:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," size value !");
    | errExists:
        Str.Concat(S,einfo," already exists !");
    | errGetFree:
        Str.Concat(S,"Could not get ",einfo);Str.Append(S,": available free space !");
    | errCreate:
        (* name|got|wanted *)
        Str.Subst(einfo,hbar," is ");
        Str.Subst(einfo,hbar," bytes long while expected size is ");
        Str.Concat(S,einfo," !");
    | errZeroLeft:
        Str.Concat(S,"No free space left on ",einfo);Str.Append(S,": unit !");
    | errNoExtension:
        S:="No extension allowed with syntax 3 !";
    | errAborted:
        S:="Aborted by user !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp :
        ;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

TYPE
    HUGECARD    = LONGREAL; (* it's useless but we fake > 4Gb support *)
CONST
    HUGEZERO    = LONGREAL(0.0);
TYPE
    extendedFreeSpaceType = RECORD
        strucsize                : CARDINAL;
        version                  : CARDINAL; (* called with 0 *)
        sectorsPerCluster        : LONGCARD; (* adjusted for compression *)
        bytesPerSector           : LONGCARD;
        freeClusters             : LONGCARD; (* availableClusters *)
        totalClusters            : LONGCARD;
        physicalSectorsAvailable : LONGCARD; (* not adjusted for compression *)
        physicalTotalSectors     : LONGCARD; (* not adjusted for compression *)
        realAvailableUnits       : LONGCARD; (* not adjusted for compression *)
        totalUnits               : LONGCARD; (* not adjusted for compression *)
        reserved                 : ARRAY [1..8] OF BYTE;
    END;

(* u should be UPPERCASE but we handle it anyway *)

PROCEDURE getUnitFreeTotal (assumeFAT32:BOOLEAN; u:CHAR;
                           VAR freebytes,totalbytes:HUGECARD):BOOLEAN;
VAR
    r : SYSTEM.Registers;
    sectorsPerCluster, freeClusters, bytesPerSector, totalClusters,v : LONGCARD;
    S           : str128;
    i           : CARDINAL;
    strucFAT32  : extendedFreeSpaceType;
    unitFAT32   : str16; (* oversized *)
BEGIN
    u:=CAP(u);
    freebytes  :=HUGEZERO;
    totalbytes :=HUGEZERO;

    IF assumeFAT32 THEN
        Str.Concat(unitFAT32,u,colon+backslash);
        unitFAT32[Str.Length(unitFAT32)]:=charnull; (* safety for ASCIZ *)
        strucFAT32.version:=0;

        r.AX := 07303H;  (* FAT32 - GET EXTENDED FREE SPACE ON DRIVE *)
        r.DS := Seg( unitFAT32 );
        r.DX := Ofs( unitFAT32 );
        r.ES := Seg( strucFAT32 );
        r.DI := Ofs( strucFAT32 );
        r.CX := SIZE(strucFAT32);
        Lib.Dos(r);
        IF (SYSTEM.CarryFlag IN r.Flags) THEN RETURN FALSE; END;
        sectorsPerCluster := strucFAT32.sectorsPerCluster;
        freeClusters      := strucFAT32.freeClusters;
        bytesPerSector    := strucFAT32.bytesPerSector;
        totalClusters     := strucFAT32.totalClusters;

        freebytes := HUGECARD(bytesPerSector);
        totalbytes:= HUGECARD(bytesPerSector);
        freebytes := freebytes  * HUGECARD(strucFAT32.physicalSectorsAvailable);
        totalbytes:= totalbytes * HUGECARD(strucFAT32.physicalTotalSectors);
    ELSE
        r.AH := 036H;  (* DOS 2+ - GET FREE DISK SPACE *)
        r.DL := BYTE( ORD(u)-ORD("A")+1 ); (* $00=default, $01=A:, etc. *)
        Lib.Dos(r);
        IF r.AX = 0FFFFH THEN RETURN FALSE; END;
        sectorsPerCluster := LONGCARD(r.AX); (* IF $FFFF, invalid drive *)
        freeClusters      := LONGCARD(r.BX);
        bytesPerSector    := LONGCARD(r.CX);
        totalClusters     := LONGCARD(r.DX);

        freebytes  := HUGECARD(sectorsPerCluster) * HUGECARD(bytesPerSector);
        totalbytes := HUGECARD(sectorsPerCluster) * HUGECARD(bytesPerSector);
        freebytes  := freebytes  * HUGECARD(freeClusters);
        totalbytes := totalbytes * HUGECARD(totalClusters);
    END;
    RETURN TRUE;
END getUnitFreeTotal;

(* ------------------------------------------------------------ *)

CONST
    IObufferSize      = (8 * 512) + FIO.BufferOverhead;
    firstIObufferByte = 1;
    lastIObufferByte  = IObufferSize;
VAR
    IObuffer : ARRAY [firstIObufferByte..lastIObufferByte] OF BYTE;

CONST
    databuffersize  = 8 * 512;
    firstdatabuffer = 0;
    lastdatabuffer  = databuffersize-1;
VAR
    databuffer : ARRAY [firstdatabuffer..lastdatabuffer] OF BYTE;

(* ------------------------------------------------------------ *)

PROCEDURE strToByte (VAR filler:BYTE; S:ARRAY OF CHAR   ):BOOLEAN;
VAR
    ok : BOOLEAN;
    base,len:CARDINAL;
    v:LONGCARD;
BEGIN
    len:=Str.Length(S); (* cannot be 0 *)
    IF S[0]="$" THEN
        base:=16; Str.Delete(S,0,1);
    ELSIF ( (S[0]="0") AND (S[1]="X") ) THEN
        base:=16; Str.Delete(S,0,2);
    ELSIF S[len-1]="H" THEN
        base:=16; Str.Delete(S,len-1,1);
    ELSE
        base:=10;
    END;
    v:=Str.StrToCard(S,base,ok);
    IF ( (ok = FALSE) OR (v < MIN(BYTE)) OR (v > MAX(BYTE)) ) THEN
        ok:=FALSE;
    ELSE
        filler:=BYTE(v);
        ok:=TRUE;
    END;
    RETURN ok;
END strToByte;

PROCEDURE strToFsize (VAR fsize : LONGCARD;S:ARRAY OF CHAR ):BOOLEAN;
VAR
    ok:BOOLEAN;
    base:CARDINAL;
BEGIN
    IF S[0]="$" THEN
        base:=16; Str.Delete(S,0,1);
    ELSE
        base:=10;
    END;
    fsize:=Str.StrToCard(S,base,ok);
    RETURN ok;
END strToFsize;

PROCEDURE fmtval (v:LONGCARD;wi,base:CARDINAL;pad:CHAR):str16;
VAR
    ok:BOOLEAN;
    i:CARDINAL;
    R:str16;
BEGIN
    Str.CardToStr(v,R,base,ok);
    FOR i:=(Str.Length(R)+1) TO wi DO Str.Prepend(R,pad);END;
    IF base=16 THEN Str.Lows(R);END;
    RETURN R;
END fmtval;

PROCEDURE buildname (VAR R:ARRAY OF CHAR;v:LONGCARD;S:ARRAY OF CHAR);
BEGIN
    Str.Concat(R,S,dot);
    Str.Append(R,fmtval(v,3,10,"0"));
END buildname;

(* ------------------------------------------------------------ *)

VAR
    slen,sname,sbyte,basename:str128;
    hnd:FIO.File;
    forced,assumeFAT32,overwrite,verbose:BOOLEAN;
    fillmode:(none,random,user);
    filler:BYTE;
    fsize:LONGCARD;
    freespace,totalspace: HUGECARD;
    hugefsize:HUGECARD;
    unit:CHAR;
    currext:LONGCARD;
VAR
    parmcount,i,opt:CARDINAL;
    S,R:str128;
    state:(waiting,gotsize,gotfile,gotvalue);
    pos:LONGCARD;
    count:CARDINAL;
    opmode:(fixedsize,tryone,trymany);
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    WrLn;

    fillmode  := none;
    overwrite := FALSE;
    verbose   := FALSE;
    assumeFAT32:=TRUE;

    state:=waiting;
    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);
        cleantabs(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "V"+delim+"VERBOSE"+delim+
                                  "O"+delim+"OVERWRITE"+delim+
                                  "X"+delim+"NOFAT32"
                              );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5:    verbose:=TRUE;
            | 6,7:    overwrite:=TRUE;
            | 8,9 :   assumeFAT32:=FALSE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            CASE state OF
            | waiting:  Str.Copy(slen,R);
            | gotsize:  Str.Copy(sname,R); (* keep uppercase *)
            | gotfile:  Str.Copy(sbyte,R);
            | gotvalue: abort(errSyntax,"");
            END;
            INC(state);
        END;
    END;
    CASE state OF
    | waiting: abort(errHelp,"");
    | gotsize: abort(errSyntax,"");
    | gotfile: ; (* ok *)
    | gotvalue:
        IF same(sbyte,star) THEN
            fillmode:=random;
        ELSE
            IF strToByte(filler,sbyte)=FALSE THEN abort(errFillerValue,sbyte); END;
            fillmode:=user;
        END;
    END;

    IF chkJoker(sname) THEN abort(errJoker,sname);END;

    assumeFAT32 := assumeFAT32 AND w9XsupportLFN();

    i:=Str.CharPos(sname,colon);
    CASE i OF
    | 1 :            unit:=sname[0];
    | MAX(CARDINAL): unit:=CHR(  FIO.GetDrive()-1+ORD("A") );
    ELSE
                     abort(errUnit,sname);
    END;

    IF same(slen,star) THEN
        opmode:=tryone;
    ELSIF same(slen,exclam) THEN
        IF Str.RCharPos(sname,dot) # MAX(CARDINAL) THEN abort(errNoExtension,"");END;
        Str.Copy(basename,sname);
        currext:=1;
        opmode:=trymany;
    ELSE
        IF strToFsize(fsize,slen)=FALSE THEN abort(errSizeValue,slen);END;
        IF fsize = 0 THEN abort(errSizeValue,slen);END;
        IF fsize > HUGEMAXSIZE THEN
            fsize:=HUGEMAXSIZE; forced:=TRUE;
        END;
        opmode:=fixedsize;
    END;

    forced:=FALSE;
    CASE opmode OF
    | fixedsize:
        ;
    | tryone,trymany:
        IF getUnitFreeTotal(assumeFAT32,unit, freespace,totalspace)=FALSE THEN
            abort(errGetFree,unit);
        END;
        IF freespace = HUGEZERO THEN abort(errZeroLeft,unit);END;
        IF freespace > HUGECARD(HUGEMAXSIZE) THEN
            fsize:=HUGEMAXSIZE; forced:=TRUE;
        ELSE
            fsize:=LONGCARD(freespace);
        END;
    END;

    LOOP
        IF opmode=trymany THEN buildname(sname,currext,basename); END;

        IF FIO.Exists(sname) THEN
            IF overwrite=FALSE THEN abort(errExists,sname);END;
        END;

        IF verbose THEN
            IF ( (opmode=trymany) AND (currext > 1) ) THEN WrLn;END;
            WrStr("Unit   : "); WrStr(unit);WrStr(":");WrLn;
            WrStr("File   : "); WrStr(sname);WrLn;
            WrStr("Size   : "); WrStr(fmtval(fsize,1,10,"0"));
                                IF forced THEN WrStr(" (adjusted)");END;
                                WrLn;
            WrStr("Filler : ");
            CASE fillmode OF
            | none:   S:="undefined";
            | random: S:="random";
            | user:   Str.Concat(S,"$",fmtval(LONGCARD(filler),2,16,"0"));
            END;
            WrStr(S);WrLn;
            WrLn;
        END;

        hnd := FIO.Create(sname);
        FIO.Seek (hnd,1); (* try and fix DOS bug reported by intlist *)
        FIO.Truncate(hnd);
        FIO.Close(hnd);

        hnd := FIO.Open(sname);
        FIO.Seek (hnd,fsize);
        FIO.Truncate (hnd);
        FIO.Close(hnd);

        pos:=getFileSize(sname);
        IF pos # fsize THEN
            Str.Concat(S,hbar,fmtval(pos,1,10,"0"));
            Str.Prepend(S,sname);
            Str.Append(S,hbar);Str.Append(S,slen);
            abort(errCreate,S);
        END;

        Str.Concat(S,"::: ",sname);Str.Append(S," has been created with ");
        Str.Append(S,fmtval(fsize,1,10,"0")); IF forced THEN Str.Append(S," adjusted"); END;
        Str.Append(S," size.");
        WrStr(S);WrLn;

        IF ( (fillmode # none) AND (fsize # 0) ) THEN
            video(msg,TRUE);
            CASE fillmode OF
            | random:
                Lib.RANDOMIZE();
                FOR i:=firstdatabuffer TO lastdatabuffer DO
                    filler:=BYTE( Lib.RANDOM(256) ); (* 0..255 *)
                    databuffer[i]:=filler;
                END;
            | user:
                Lib.Fill(ADR(databuffer),databuffersize,filler);
            END;

            hnd := FIO.Open(sname);
            FIO.AssignBuffer(hnd,IObuffer);
            pos := 0;
            LOOP
                IF pos >= fsize THEN EXIT; END;
                count := CARDINAL ( (fsize-pos) MOD databuffersize );
                IF count = 0 THEN count := databuffersize; END;
                FIO.WrBin(hnd,databuffer,count);
                INC(pos,LONGCARD(count));
                IF fillmode=random THEN
                    FOR i:=firstdatabuffer TO lastdatabuffer DO
                        filler:=BYTE( Lib.RANDOM(256) ); (* 0..255 *)
                        databuffer[i]:=filler;
                    END;
                END;
            END;
            FIO.Flush(hnd);
            FIO.Close(hnd);
            video(msg,FALSE);
        END;

        CASE opmode OF
        | fixedsize,tryone:
            EXIT;
        | trymany:
            IF getUnitFreeTotal(assumeFAT32,unit, freespace,totalspace)=FALSE THEN
                abort(errGetFree,unit);
            END;
            IF freespace = HUGEZERO THEN EXIT; END; (* we're done *)
            IF freespace > HUGECARD(HUGEMAXSIZE) THEN
                fsize:=HUGEMAXSIZE; forced:=TRUE;
            ELSE
                fsize:=LONGCARD(freespace);
            END;
            INC(currext);
            IF ChkEscape() THEN abort(errAborted,"");END;
        END;
    END;

    abort(errNone,"");
END Reserve.



(*
--------D-2142-------------------------------
INT 21 - DOS 2+ - "LSEEK" - SET CURRENT FILE POSITION
        AH = 42h
        AL = origin of move
            00h start of file
            01h current file position
            02h end of file
        BX = file handle
        CX:DX = (signed) offset from origin of new file position
Return: CF clear if successful
            DX:AX = new file position in bytes from start of file
        CF set on error
            AX = error code (01h,06h) (see #01680 at AH=59h/BX=0000h)
Notes:  for origins 01h and 02h, the pointer may be positioned before the
          start of the file; no error is returned in that case (except under
          Windows NT), but subsequent attempts at I/O will produce errors
        if the new position is beyond the current end of file, the file will
          be extended by the next write (see AH=40h); for FAT32 drives, the
          file must have been opened with AX=6C00h with the "extended size"
          flag in order to expand the file beyond 2GB
BUG:    using this method to grow a file from zero bytes to a very large size
          can corrupt the FAT in some versions of DOS; the file should first
          be grown from zero to one byte and then to the desired large size
SeeAlso: AH=24h,INT 2F/AX=1228h
*)
