(* ---------------------------------------------------------------
Title         Q&D MousePause
Author        PhG
Overview      wait keypress or mousebutton to exit
Notes         yes, we could use MsMouse library
Bugs
Wish List     are you kidding ? ;-)

--------------------------------------------------------------- *)

MODULE Mpause;

IMPORT SYSTEM;
IMPORT Lib;
IMPORT BiosIO;
IMPORT IO;
IMPORT Str;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString;

(* ------------------------------------------------------------ *)

CONST
    space = " ";
    tab   = CHR(9);
    esc   = CHR(27);
CONST
    ProgEXEname   = "MPAUSE";
    ProgTitle     = "Q&D MousePause";
    ProgVersion   = "v1.0e";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone       = 0;
    errHelp       = 1;
    errWaitRange  = 2;
    errNum        = 3;
    errEscape     = 255;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr = CHR(13);
    lf = CHR(10);
    nl = cr+lf;
CONST
(*
     00000000011111111112222222222333333333344444444445555555555666666666677777777778
     1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msgHelp =
    Banner+nl+
    nl+
    "Syntax : "+ProgEXEname+" [-wait:#] [-escape] [-mouse] [-terse] [message]"+nl+
    nl+
    "    -w:#  maximum pause in seconds ([1..900])"+nl+
    "    -e    do not interpret right-click as Escape"+nl+
    "    -m    ignore mouse if present"+nl+
    "    -t    terse mode (display [message] without prompt)"+nl+
    "    -tt   terser mode (display [message] without prompt then erase it)"+nl+
    nl+
    "This enhanced PAUSE command monitors keypresses and mouse clicks."+nl+
    "Optional message will be displayed verbatim. Try and keep it short !"+nl+
    "Escape key forces return code 255, as right-click does (unless -e was used)."+nl+
    "If maximum pause is outside valid range, it is set to minimum value."+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrLn;
        WrStr(msgHelp);
    | errWaitRange :
        Str.Concat(S,"Maximum pause must be in the [",einfo);
        Str.Append(S,"] range !");
    | errNum:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," value !");
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp, errEscape :
        ;
    ELSE
        WrLn;
        WrStr(ProgEXEname+" : ");
        WrStr(S);
        WrLn;
    END;

    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

CONST
    MouseInt   = 033H;
TYPE
    mousebuttonstype = SET OF (leftbutton,rightbutton,middlebutton);

PROCEDURE MouseDriverHere ( ) : BOOLEAN;
CONST
    InstallChk = 00000H;
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AX := InstallChk;
    Lib.Intr(R,MouseInt);
    RETURN (R.AX # 0);
END MouseDriverHere;

PROCEDURE ShowMouseCursor (  );
CONST
    ShowCursor = 00001H;
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AX := ShowCursor;
    Lib.Intr(R,MouseInt);
END ShowMouseCursor;

PROCEDURE HideMouseCursor (  );
CONST
    HideCursor = 00002H;
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AX := HideCursor;
    Lib.Intr(R,MouseInt);
END HideMouseCursor;

PROCEDURE ButtonPressed (VAR whatbuttons:mousebuttonstype) : BOOLEAN;
CONST
    GetStatus = 00003H;
VAR
    R : SYSTEM.Registers;
    flags : CARDINAL;
BEGIN
    R.AX := GetStatus;
    Lib.Intr(R,MouseInt);
    (* RETURN ( (R.BX AND 007H) # 0 ); (* 00000111 binary mask *) *)

    flags := R.BX;
    whatbuttons:=mousebuttonstype{}; (* check %001, %010, %100 *)
    IF (flags AND 001H) # 0 THEN INCL(whatbuttons,leftbutton);END;
    IF (flags AND 002H) # 0 THEN INCL(whatbuttons,rightbutton);END;
    IF (flags AND 004H) # 0 THEN INCL(whatbuttons,middlebutton);END;

    RETURN ( whatbuttons # mousebuttonstype{} );
END ButtonPressed;

(* ------------------------------------------------------------ *)

PROCEDURE fmtcard (v : CARDINAL; field:INTEGER ) : str80;
CONST
    pad = " ";
    sep = "";
VAR
    S,R   : str80;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.CardToStr(LONGCARD(v),S,10,ok);
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmtcard;

PROCEDURE getCommandLine (VAR S : ARRAY OF CHAR);
VAR
    i : CARDINAL;
BEGIN
    i := 0;
    LOOP
        S[i] := Lib.CommandLine^[i];
        IF S[i] = CHR(0) THEN EXIT; END; (* $00 is kept *)
        INC(i);
    END;
END getCommandLine;

(* ------------------------------------------------------------ *)

CONST
    unlimited= 0;
    minpause = 1;
    maxpause = 60*15; (* seconds *)
    defaultprompt        = "Strike a key or click a mouse button when ready . . . ";
    defaultpromptnomouse = "Strike a key when ready . . . ";
    wicountdown = -4; (* -1 is possible but as we're far from 80 chars... *)
VAR
    cli : str128;
    R   : str128;
    opt : CARDINAL;
    pause : CARDINAL;
    okmouse : BOOLEAN;
    ch : CHAR;

    h,m,s,ss:CARDINAL;
    start,now,previous : LONGINT;
    remaining : CARDINAL;
    whatbuttons:mousebuttonstype;
    debug,usemouse,mouseESC,showprompt,autoclean:BOOLEAN;
    rcEscape : BOOLEAN;
    prompt : str128;
    lc:LONGCARD;
BEGIN
    Lib.EnableBreakCheck; (* was disable *)

    debug    := FALSE;
    usemouse := TRUE;
    mouseESC := TRUE;
    showprompt:=TRUE;
    autoclean:=FALSE;
    pause    := unlimited;

    getCommandLine(cli);

    LOOP
        LtrimBlanks(cli);
        IF isOption(cli) THEN (* command line starts with "-" or "/" *)
            isoleItemS(R,cli,space+tab,0);
            UpperCase(R);
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+

                                  "W:"+delim+"WAIT:"+delim+
                                  "D:"+delim+"DELAY:"+delim+
                                  "P:"+delim+"PAUSE:"+delim+

                                  "E"+delim+"ESCAPE"+delim+
                                  "M"+delim+"MOUSE"+delim+
                                  "T"+delim+"TERSE"+delim+
                                  "TT"+delim+"TERSER"+delim+
                                  "DEBUG"
                                  );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4..9 :
                IF GetLongCard(R,lc)=FALSE THEN abort(errNum,R);END;
                IF ( (lc < LONGCARD(minpause)) OR (lc > LONGCARD(maxpause)) ) THEN
                    (* abort(errWaitRange,"1..900"); *)
                    pause := minpause; (* do not abort but set minimum pause *)
                ELSE
                    pause:= CARDINAL(lc);
                END;
            | 10,11:  mouseESC:=FALSE;
            | 12,13:  usemouse:=FALSE;
            | 14,15:  showprompt:=FALSE;
            | 16,17:  showprompt:=FALSE; autoclean:=TRUE;
            | 18:     debug:=TRUE;
            ELSE
                EXIT; (* unknown option may be message ! *)
            END;
        ELSE
            EXIT; (* not an option *)
        END;
        Str.Delete(cli,0,Str.Length(R)); (* remove frontal option *)
    END;
    RtrimBlanks(cli);
    IF Str.Length(cli) # 0 THEN
        IF autoclean THEN
            IF showprompt THEN
                WrStr(cli);WrLn; (* should never happen ! *)
            ELSE
                IF pause = unlimited THEN
                    Str.Append(cli," "); (* do not glue cursor to message *)
                ELSE
                    Str.Append(cli," "); (* user will add " :" *)
                END;
                video(cli,TRUE);
            END;
        ELSE
            WrStr(cli);WrLn;
        END;
    END;

    okmouse := (usemouse AND MouseDriverHere() );
    IF okmouse THEN
        Str.Copy(prompt,defaultprompt);
    ELSE
        Str.Copy(prompt,defaultpromptnomouse);
    END;
    WHILE BiosIO.KeyPressed() DO
        ch := BiosIO.RdKey();
        IF ch = CHR(0) THEN ch:=BiosIO.RdKey();END;
    END;

    CASE pause OF
    | unlimited:

        IF showprompt THEN video(prompt,TRUE); END;

        LOOP
            IF okmouse THEN
                IF ButtonPressed(whatbuttons) THEN
                    rcEscape:=(mouseESC AND (rightbutton IN whatbuttons) );
                    EXIT;
                END;
            END;
            IF BiosIO.KeyPressed() THEN
                rcEscape:=FALSE;
                ch := BiosIO.RdKey();
                CASE ch OF
                | esc : rcEscape:=TRUE;
                | CHR(0) : ch:=BiosIO.RdKey(); (* we don't care about function keys *)
                END;
                EXIT;
            END;
        END;
    ELSE
        remaining := pause;
        Lib.GetTime(h,m,s,ss);
        start := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);

        previous := start;
        Str.Copy(R,fmtcard(remaining,wicountdown));

        IF showprompt THEN video(prompt,TRUE); END;

        video(R,TRUE);

        LOOP
            IF okmouse THEN
                IF ButtonPressed(whatbuttons) THEN
                    rcEscape:=(mouseESC AND (rightbutton IN whatbuttons) );
                    EXIT;
                END;
            END;
            IF BiosIO.KeyPressed() THEN
                rcEscape:=FALSE;
                ch := BiosIO.RdKey();
                CASE ch OF
                | esc: rcEscape:=TRUE;
                | CHR(0) : ch:=BiosIO.RdKey(); (* we don't care about function keys *)
                END;
                EXIT;
            END;
            Lib.GetTime(h,m,s,ss);
            now := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);

            IF now > previous THEN
                video(R,FALSE);
                previous := now;
                DEC(remaining);
                Str.Copy(R,fmtcard(remaining,wicountdown));
                video(R,TRUE);
            END;

            IF ABS(now-start) >= LONGINT(pause) THEN EXIT; END;
        END;
        video(R,FALSE);
    END;

    IF showprompt THEN video(prompt,FALSE); END;

    IF autoclean THEN
        IF showprompt=FALSE THEN video(cli,FALSE); END;
    END;

    IF debug THEN
        CASE rcEscape OF
        | FALSE: WrStr("Go ahead, make my day !"); (* those were the Clint days... *)
        | TRUE:  WrStr("Escape from Alcatraz !");
        END;
        WrLn;
    END;

    CASE rcEscape OF
    | FALSE : abort(errNone,"");
    | TRUE :  abort(errEscape,"");
    END;
END Mpause.
