
(* ---------------------------------------------------------------
Title         Q&D Check I/O Ports
Overview      Yet Another Completely Useless Program
Usage         see help
Notes
   
              DISCLAIMER : this program CAN be dangerous ! use with CAUTION !
              I'm NOT responsible for ANYTHING that can happen when using it !
              besides, you've got source code !

Bugs
Wish List     command line exclude range option ?

--------------------------------------------------------------- *)

MODULE chkPorts;

IMPORT Lib;
IMPORT Str;
IMPORT SYSTEM;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

(* ------------------------------------------------------------ *)

CONST
    cr          = CHR(13);
    lf          = CHR(10);
    nl          = cr+lf;
    sCharsetDefault= "_.#!";
CONST
    progEXEname   = "CHKPORTS";
    progTitle     = "Q&D Check I/O Ports";
    progVersion   = "v1.1";
    progCopyright = "by PhG";
    banner        = progTitle+" "+progVersion+" "+progCopyright;
CONST
    errNone            = 0;
    errHelp            = 1;
    errUnknownOption   = 2;
    errTooManyParms    = 3;
    errSyntax          = 4;
    errNum             = 5;
    errCard            = 6;
    errIOrange         = 7;
    errCharset         = 8;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)

errmsg =
banner+nl+
nl+
"Syntax : "+progEXEname+" <[$]port [[$]count]]|-free|-used|-map> [option]..."+nl+
nl+
"This program checks whether a port address ([$0000..$03ff]) is free or not."+nl+
"Even though valid range for post scanning is [$0000..$03ff],"+nl+
"note [$0000..$01FF] range should be avoided (or tested with extreme caution)."+nl+
"Note, too, that port reading MAY hang computer : BEWARE and BE CAUTIOUS !"+nl+
nl+
"  -free    show possibly free ports map in the [$0200..$03ff] range"+nl+
"  -used    show possibly used ports map in the [$0200..$03ff] range"+nl+
"  -map     show merged -free and -used maps"+nl+
"  -m#      scan method (defaut is 1)"+nl+
"           1 = word @ port                -- free if value is $ffff"+nl+
"           2 = word @ port, word @ port   -- free if values are different"+nl+
"           3 = byte @ port, byte @ port   -- free if values are $ff"+nl+
"           4 = byte @ port, byte @ port   -- free if values are different"+nl+
"           5 = byte @ port, byte @ port+1 -- free is values are $ff"+nl+
"           6 = byte @ port, byte @ port+1 -- free if values are different"+nl+
"  -w#      map display width ({1,2,4}, default is 4)"+nl+
'  -c:$     map character set (untested,free,used,skipped), default is "'+sCharsetDefault+'"'+nl+
"  -unsafe  allow program to scan dangerous ports :"+nl+
"           -- [$0320..$032f] (hard disk controller)"+nl+
"           -- [$03f0..$03f7] (floppy disk controller)"+nl+
"           WARNING ! DATA LOSS MAY HAPPEN IF THESE PORTS ARE SCANNED !"+nl+
nl+
"Examples : "+progEXEname+" $220 16"+nl+
"           "+progEXEname+" -free -w2"+nl;

VAR
    S  : str128;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(errmsg);
    | errUnknownOption:
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errTooManyParms:
        Str.Concat(S,einfo," is one parameter too many !");
    | errSyntax:
        S := "Syntax error !";
    | errNum:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," value !");
    | errCard:
        Str.Concat(S,einfo," is out of [$0000..$ffff] range !");
    | errIOrange:
        Str.Concat(S,einfo," is out of [$0000..$03ff] range !");
    | errCharset:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," map character set !");
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE fmtbignum (v:LONGCARD; base:CARDINAL;wi:INTEGER; pad:CHAR ):str16;
VAR
    S:str16;
    ok:BOOLEAN;
    i : CARDINAL;
BEGIN
    Str.CardToStr( v, S, base,ok);
    FOR i:=Str.Length(S)+1 TO ABS(wi) DO
         IF wi < 0 THEN
             Str.Append(S,pad);
         ELSE
             Str.Prepend(S,pad);
         END;
    END;
    IF base=16 THEN Str.Lows(S);END;
    RETURN S;
END fmtbignum;

PROCEDURE fmtnum ( v:CARDINAL; base:CARDINAL;wi:INTEGER; pad:CHAR ):str16;
BEGIN
    RETURN fmtbignum( LONGCARD(v),base,wi,pad);
END fmtnum;

PROCEDURE strToNum (VAR v: LONGCARD ; S:ARRAY OF CHAR ):BOOLEAN ;
VAR
    base:CARDINAL;
    ok:BOOLEAN;
BEGIN
    IF S[0]="$" THEN
        base:=16; Str.Delete(S,0,1);
    ELSE
        base:=10;
    END;
    v:=Str.StrToCard(S,base,ok);
    RETURN ok;
END strToNum;

PROCEDURE inrange (v:LONGCARD;mini,maxi:CARDINAL):BOOLEAN;
BEGIN
    IF CARDINAL(v) < mini THEN RETURN FALSE;END;
    RETURN ( CARDINAL(v) <= maxi );
END inrange;

PROCEDURE chkCharset (VAR R:ARRAY OF CHAR;S:ARRAY OF CHAR ):BOOLEAN ;
VAR
    T : str128;
    i,len:CARDINAL;
BEGIN
    len:=Str.Length(sCharsetDefault);
    GetString(S, T);
    IF Str.Length(T) # len THEN RETURN FALSE;END;
    Str.Copy(R,T);
    FOR i:=1 TO len DO
        IF CharCount(R,R[i-1]) # 1 THEN RETURN FALSE; END;
    END;
    RETURN TRUE;
END chkCharset;

(* ------------------------------------------------------------ *)

CONST
    firstPort        = 0000H;
    lastPort         = 0400H-1;
    defaultFirstport = 0200H;
    defaultLastport  = lastPort;
    firstHD          = 0320H; (* hard disk controller *)
    lastHD           = firstHD+0FH;
    firstFD          = 03F0H; (* floppy disk controller *)
    lastFD           = firstFD+07H;
TYPE
    portstatetype = (untested,portfree,portused,portskipped);
CONST
    firstportstate = ORD(untested);
    lastportstate  = ORD(portskipped);
VAR (* globerk *)
    portstate : ARRAY[firstPort..lastPort] OF portstatetype;

(* ------------------------------------------------------------ *)

PROCEDURE initscan (  );
VAR
    i:CARDINAL;
BEGIN
    FOR i:=firstPort TO lastPort DO
        portstate[i]:=untested;
    END;
END initscan;

PROCEDURE scanport (addr,scanmethod:CARDINAL;safemode,DEBUG:BOOLEAN);
CONST
    bfree = SHORTCARD(000FFH);
    wfree = CARDINAL (0FFFFH);
VAR
    b1,b2:SHORTCARD;
    w1,w2:CARDINAL;
    y:BOOLEAN;
    S:str128;
BEGIN
    portstate[addr]:=untested; (* double safety ! *)
    IF safemode THEN
        CASE addr OF
        | firstHD..lastHD : portstate[addr]:=portskipped;
        | firstFD..lastFD : portstate[addr]:=portskipped;
        END;
        IF portstate[addr]=portskipped THEN
            IF DEBUG THEN
                Str.Concat(S,"::: ",fmtnum(addr,16,4,"0"));
                Str.Append(S," was not tested out of safety"+nl);
                WrStr(S);
            END;
            RETURN;
        END;
    END;
    CASE scanmethod OF
    | 1: w1:=SYSTEM.InW(addr); (* the only valid one ! *)
    | 2: w1:=SYSTEM.InW(addr); w2:=SYSTEM.InW(addr);
    | 3: b1:=SYSTEM.In (addr); b2:=SYSTEM.In (addr);
    | 4: b1:=SYSTEM.In (addr); b2:=SYSTEM.In (addr);
    | 5: b1:=SYSTEM.In (addr); b2:=SYSTEM.In (addr+1);
    | 6: b1:=SYSTEM.In (addr); b2:=SYSTEM.In (addr+1);
    END;

    CASE scanmethod OF
    | 1: y := (w1=wfree);
    | 2: y := (w1 # w2);
    | 3: y := ( (b1 = bfree) AND (b2=bfree) );
    | 4: y := ( b1 # b2 );
    | 5: y := ( (b1 = bfree) AND (b2=bfree) );
    | 6: y := ( b1 # b2 );
    END;

    IF y THEN
        portstate[addr]:=portfree;
    ELSE
        portstate[addr]:=portused;
    END;

    IF DEBUG THEN
        CASE scanmethod OF
        | 1:   Str.Concat(S,fmtnum(addr,16,4,"0")," = ");
               Str.Append(S,fmtnum(w1,16,4,"0"));
        | 2:   Str.Concat(S,fmtnum(addr,16,4,"0")," = ");
               Str.Append(S,fmtnum(w1,16,4,"0"));
               Str.Append(S," then ");
               Str.Append(S,fmtnum(w2,16,4,"0"));
        | 3,4: Str.Concat(S,fmtnum(addr,16,4,"0")," = ");
               Str.Append(S,fmtnum(CARDINAL(b1),16,2,"0"));
               Str.Append(S," then ");
               Str.Append(S,fmtnum(CARDINAL(b2),16,2,"0"));
        | 5,6: Str.Concat(S,fmtnum(addr,16,4,"0")," = ");
               Str.Append(S,fmtnum(CARDINAL(b1),16,2,"0"));
               Str.Append(S," and ");
               Str.Append(S,fmtnum(addr+1,16,4,"0"));
               Str.Append(S," = ");
               Str.Append(S,fmtnum(CARDINAL(b2),16,2,"0"));
        END;
        Str.Append(S," i.e. ");
        CASE portstate[addr] OF
        | portfree: Str.Append(S,"free");
        | portused: Str.Append(S,"used");
        END;
        WrStr("::: ");WrStr(S);WrLn;
    END;
END scanport;

(* ------------------------------------------------------------ *)

CONST
    firstparm = 1;
    maxparm   = 2;
VAR
    parm : ARRAY[firstparm..maxparm] OF str128;
    lastparm,i,opt,parmcount:CARDINAL;
    S,R:str128;
    cmd:(unspecified,cmdscan,cmdmap,cmdfree,cmdused);
    DEBUG,safemode:BOOLEAN;
    scanmethod:CARDINAL;
    firstio,lastio:CARDINAL;
    v:LONGCARD;
    hcount,ndx,j:CARDINAL;
    ch:CHAR;
    charset:ARRAY [firstportstate..lastportstate] OF CHAR;
BEGIN
    WrLn;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    lastparm    := firstparm-1;
    cmd         := unspecified;
    safemode    := TRUE;
    scanmethod  := 1;
    hcount      := 4;
    charset     := sCharsetDefault;
    DEBUG:=FALSE;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "UNSAFE"+delim+
                                  "F"+delim+"FREE"+delim+
                                  "U"+delim+"USED"+delim+
                                  "M"+delim+"MAP"+delim+
                                  "M1"+delim+
                                  "M2"+delim+
                                  "M3"+delim+
                                  "M4"+delim+
                                  "M5"+delim+
                                  "M6"+delim+
                                  "W1"+delim+"1"+delim+
                                  "W2"+delim+"2"+delim+
                                  "W4"+delim+"4"+delim+
                                  "C:"+delim+"SET:"+delim+
                                  "DEBUG"
                              );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4     : safemode := FALSE;
            | 5,6   : cmd:=cmdfree;
            | 7,8   : cmd:=cmdused;
            | 9,10  : cmd:=cmdmap;
            | 11    : scanmethod := 1;
            | 12    : scanmethod := 2;
            | 13    : scanmethod := 3;
            | 14    : scanmethod := 4;
            | 15    : scanmethod := 5;
            | 16    : scanmethod := 6;
            | 17,18 : hcount:=1;
            | 19,20 : hcount:=2;
            | 21,22 : hcount:=4;
            | 23,24 : IF chkCharset(charset,S)=FALSE THEN
                          abort(errCharset,S);
                      END;
            | 25    : DEBUG:=TRUE;
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errTooManyParms,S);END;
            Str.Copy(parm[lastparm],R);
        END;
    END;
    CASE cmd OF
    | unspecified:
        IF firstparm < firstparm THEN abort(errSyntax,"");END;

        S:=parm[firstparm];
        IF strToNum(v,S)=FALSE THEN abort(errNum,S);END;
        IF inrange(v,MIN(CARDINAL),MAX(CARDINAL))=FALSE  THEN abort(errCard,S);END;
        IF inrange(v,firstPort,lastPort)=FALSE THEN abort(errIOrange,"port");END;
        firstio:=CARDINAL(v);

        IF lastparm > firstparm THEN
            S:=parm[firstparm+1];
            IF strToNum(v,S)=FALSE THEN abort(errNum,S);END;
            IF inrange(v,MIN(CARDINAL),MAX(CARDINAL))=FALSE THEN abort(errCard,S);END;
            INC(v,LONGCARD(firstio));
            DEC(v);
            IF inrange(v,firstPort,lastPort)=FALSE THEN abort(errIOrange,"port+count-1");END;
            lastio:=CARDINAL(v);
        ELSE
            lastio:=firstio;
        END;

        cmd:=cmdscan;

    | cmdfree,cmdused,cmdmap:
        IF lastparm < firstparm THEN
            firstio := defaultFirstport;
            lastio  := defaultLastport;
        ELSE
            abort(errSyntax,"");
        END;
    END;

    initscan();
    FOR i:=firstio TO lastio DO
        scanport(i,scanmethod,safemode,DEBUG);
    END;

    CASE cmd OF
    | cmdscan:
        FOR i:=firstio TO lastio DO
            Str.Concat(S,"I/O port $",fmtnum(i,16,4,"0"));
            CASE portstate[i] OF
            | untested:    R:=" was not even tested : how did you get HERE ?";
            | portfree:    R:=" is probably free";
            | portused:    R:=" is probably used";
            | portskipped: R:=" was not tested out of safety";
            END;
            WrStr(S);WrStr(R);WrLn;
        END;
    | cmdfree,cmdused,cmdmap:
        Str.Concat(S,";   ","   ");
        Str.Append(S,'Numbers are hexadecimal, "');
        Str.Append(S,charset[ORD(portfree)]);Str.Append(S,'"=free, "');
        Str.Append(S,charset[ORD(portused)]);Str.Append(S,'"=used, "');
        Str.Append(S,charset[ORD(portskipped)]);Str.Append(S,'"=skipped');
        Str.Append(S,nl+nl);
        WrStr(S);
        Str.Concat(S,";   ","  ");
        FOR i:=1 TO hcount DO
            Str.Append(S," ");
            FOR j:=1 TO 16 DO
                Str.Append(S,fmtnum(j-1,16,1,"0"));
            END;
        END;
        WrStr(S);WrLn;
        WrLn;

        ndx:=firstio;
        LOOP
            IF ndx > lastio THEN EXIT; END;
            Str.Concat(S,fmtnum(ndx,16,4,"0")," :");
            FOR i:=1 TO hcount DO
                Str.Append(S," ");
                FOR j:=1 TO 16 DO
                    CASE portstate[ndx] OF
                    | portfree:    ch:=charset[ORD(portfree)];
                    | portused:    ch:=charset[ORD(portused)];
                    | portskipped: ch:=charset[ORD(portskipped)];
                    | untested:    ch:=charset[ORD(untested)]; (* never ! *)
                    END;
                    CASE cmd OF
                    | cmdfree:
                        IF portstate[ndx] = portused THEN ch:=charset[ORD(untested)]; END;
                    | cmdused:
                        IF portstate[ndx] = portfree THEN ch:=charset[ORD(untested)]; END;
                    END;
                    Str.Append(S,ch);
                    INC(ndx);
                END;
            END;
            WrStr(S);WrLn;
        END;
    END;

    abort(errNone,"");
END chkPorts.
