(* ---------------------------------------------------------------
Title         Q&D Base Converter
Overview
Notes
Bugs
Wish List

--------------------------------------------------------------- *)

MODULE BaseConv;

IMPORT Str;
IMPORT Lib;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs,
completedInit, completedShow, completedSHOW, completedEnd, completed;

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "BASECONV";
    ProgTitle     = "Q&D Base Converter";
    ProgVersion   = "v1.0c";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errTooManyNumbers=3;
    errNoNumber     = 4;
    errBadNumber    = 5;
    errBadLC        = 6;
    errFmt          = 7;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" <[$|%|0x|_]number>... [option]..."+nl+
nl+
"This program displays LONGCARD numbers in decimal, hexadecimal and binary."+nl+
'Although octal "_" prefix is handled, octal display still requires -o option.'+nl+
nl+
"    -a[a] dump each base value on its own line (-aa = -a -o)"+nl+
"    -o|-b show octal (-a forced)"+nl+
"    -f[r] increase values readability (French-style)"+nl+
"    -u[s] increase values readability (English-style)"+nl+
"    -i    show maximum values (all parameters ignored)"+nl+
nl+
"Example : "+ProgEXEname+" %00000001 0x2 1963 $19 _45 -o"+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errOption :
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," option !");
    | errTooManyNumbers:
        S := "Too many numbers !";
    | errNoNumber:
        S := "No number was specified !";
    | errBadNumber:
        Str.Concat(S,'Illegal "',einfo);Str.Append(S,'" value !');
    | errBadLC:
        Str.Concat(S,'Illegal "',einfo);Str.Append(S,'" LONGCARD value !');
    | errFmt:
        S := "-fr and -us options are mutually exclusive !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp : ;
    ELSE
        WrStr(ProgEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

CONST
    null      = CHR(0);
    comma     = ",";
    dot       = ".";
    hexprefix = "$"; (* hex prefix *)
    binprefix = "%"; (* bin prefix *)
    octprefix = "_";
    bindigits = "01";
    decdigits = "0123456789";
    hexdigits = decdigits+"ABCDEF"; (* uppercase *)
    octdigits = "01234567";

PROCEDURE chkNumber (S:ARRAY OF CHAR):BOOLEAN;
VAR
    rc:BOOLEAN;
BEGIN
    IF Str.Match(S,"0X*") THEN (* case does not matter *)
        Str.Delete(S,0,2);
        Str.Prepend(S,hexprefix);
    END;

    CASE S[0] OF
    | hexprefix:
        Str.Delete(S,0,1);
        rc:=verifyString(S,hexdigits);
    | binprefix:
        Str.Delete(S,0,1);
        rc:=verifyString(S,bindigits);
    | octprefix:
        Str.Delete(S,0,1);
        rc:=verifyString(S,octdigits);
    ELSE
        rc:=verifyString(S,decdigits);
    END;
    rc := (rc AND (Str.Length(S) > 0) );
    RETURN rc;
END chkNumber;

PROCEDURE legalLC (VAR v:LONGCARD; S:ARRAY OF CHAR):BOOLEAN;
VAR
    base:CARDINAL;
    ok:BOOLEAN;
BEGIN
    IF Str.Match(S,"0X*") THEN (* case does not matter *)
        Str.Delete(S,0,2);
        Str.Prepend(S,hexprefix);
    END;

    CASE S[0] OF
    | hexprefix:
        Str.Delete(S,0,1);
        base:=16;
    | binprefix:
        Str.Delete(S,0,1);
        base:=2;
    | octprefix:
        Str.Delete(S,0,1);
        base:=8;
    ELSE
        base:=10;
    END;
    v:=Str.StrToCard(S,base,ok);
    RETURN ok;
END legalLC;

PROCEDURE pad (padchar:CHAR;wi:CARDINAL;VAR R:ARRAY OF CHAR);
VAR
    i:CARDINAL;
BEGIN
    FOR i:=(Str.Length(R)+1) TO wi DO
        Str.Prepend(R,padchar);
    END;
END pad;

PROCEDURE using (padchar,sepch:CHAR;wi,wigroup:CARDINAL;VAR R:ARRAY OF CHAR);
VAR
    i,len:CARDINAL;
    R2:str80;
BEGIN
    IF padchar # " " THEN pad(padchar,wi,R); END;
    IF sepch # null THEN
        len:=Str.Length(R);
        Str.Copy(R2,"");
        FOR i := 1 TO len DO
            Str.Prepend(R2,R[len-i]);
            IF i < len THEN
                IF (i MOD wigroup) = 0 THEN
                    Str.Prepend(R2,sepch);
                END;
            END;
        END;
        Str.Copy(R,R2);
    END;
    IF padchar = " " THEN pad(padchar,wi+(wi DIV wigroup),R); END;
END using;

PROCEDURE fmtNum (v:LONGCARD;base:CARDINAL;padchar,decfmt:CHAR; VAR R:ARRAY OF CHAR);
CONST
    (* $ffffffff = 4294967295 = %11111111111111111111111111111111 *)
    wibin = 32; (* $ffffffff x 4 *)
    wihex = 8;  (* $ffffffff *)
    widec = 10; (* 4.294.697.295 *)
    wioct = 11; (* 37.777.777.777 *)
VAR
    ok:BOOLEAN;
BEGIN
    CASE base OF
    | 2,10,16,8:
        Str.CardToStr(v,R,base,ok); (* ok should always be TRUE now *)
    ELSE
        Str.Copy(R,"???");
    END;
    CASE base OF
    | 2:  using(padchar,decfmt,wibin,4,R);
          Str.Prepend(R,binprefix);
    | 10: using(padchar,decfmt,widec,3,R);
    | 16: using(padchar,decfmt,wihex,2,R);
          Str.Prepend(R,hexprefix);
          Str.Lows(R);
    | 8:  using(padchar,decfmt,wioct,3,R);
          Str.Prepend(R,octprefix);
    END;

END fmtNum;

(* ------------------------------------------------------------ *)

CONST
    sepequ   = " = ";
    sep      = " : ";
    sDec     = "Decimal    "+sep; (* account for hex/bin one-char prefix ? bah... *)
    sHex     = "Hexadecimal"+sep;
    sBin     = "Binary     "+sep;
    sOct     = "Octal      "+sep;
    firstnum = 1;
    maxnum   = 20; (* more than enough *)
VAR
    snum : ARRAY [firstnum..maxnum] OF str80; (* oversized *)
    num  : ARRAY [firstnum..maxnum] OF LONGCARD;
    lastnum:CARDINAL;
    parmcount,i,opt:CARDINAL;
    S,R:str128;
    oneline,showoctal,showmax:BOOLEAN;
    decfmt:CHAR;
    sD,sH,sB,sO:str80; (* oversized *)
BEGIN
    WrLn;

    parmcount := Lib.ParamCount();
    (* IF parmcount=0 THEN abort(errHelp,"");END; *)

    lastnum:=firstnum-1;
    oneline:=TRUE;
    showoctal:=FALSE;
    showmax:=FALSE;
    decfmt :=null;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "A"+delim+"ALTERNATE"+delim+
                                   "F"+delim+"FR"+delim+
                                   "U"+delim+"US"+delim+"UK"+delim+
                                   "O"+delim+"OCTAL"+delim+"B"+delim+
                                   "AA"+delim+
                                   "I"+delim+"LIMITS"+delim+"RANGES"
                               );
            CASE opt OF
            | 1,2,3 :    abort(errHelp,"");
            | 4,5   :    oneline:=FALSE;
            | 6,7   :    CASE decfmt OF
                         | null,dot:decfmt:=dot;
                         ELSE
                             abort(errFmt,"");
                         END;
            | 8,9,10:    CASE decfmt OF
                         | null,comma:decfmt:=comma;
                         ELSE
                             abort(errFmt,"");
                         END;
            | 11,12,13:  showoctal := TRUE; oneline := FALSE;
            | 14:        showoctal := TRUE; oneline := FALSE;
            | 15,16,17:  showmax := TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            INC(lastnum);
            IF lastnum > maxnum THEN abort(errTooManyNumbers,"");END;
            Str.Copy(snum[lastnum],R); (* uppercased string *)
        END;
    END;

    IF showmax THEN
        lastnum:=firstnum;
        num[lastnum]:=MAX(LONGCARD);
        INC(lastnum);
        num[lastnum]:=MAX(LONGINT);
        WrStr("::: Maximum values :");WrLn;
        WrLn;
    ELSE
        IF lastnum < firstnum THEN  abort(errNoNumber,"");END; (* won't happen *)

        FOR i:=firstnum TO lastnum DO
            IF chkNumber( snum[i] )=FALSE THEN abort(errBadNumber,snum[i]);END;
            IF legalLC( num[i],snum[i] )=FALSE THEN abort(errBadLC,snum[i]);END;
        END;
    END;

    FOR i:=firstnum TO lastnum DO
        fmtNum(num[i],10," ",decfmt,sD);
        fmtNum(num[i],16,"0",decfmt,sH);
        fmtNum(num[i], 2,"0",decfmt,sB);
        fmtNum(num[i], 8,"0",decfmt,sO);

        IF oneline THEN
            WrStr(sD);WrStr(sepequ);WrStr(sH);WrStr(sepequ);WrStr(sB);WrLn;
        ELSE
            LtrimBlanks(sD);
            WrStr(sDec);WrStr(sD);WrLn;
            WrStr(sHex);WrStr(sH);WrLn;
            WrStr(sBin);WrStr(sB);WrLn;
            IF showoctal THEN
            WrStr(sOct);WrStr(sO);WrLn;
            END;
            IF i < lastnum THEN WrLn; END;
        END;
    END;

    IF showmax THEN
        WrLn;
        WrStr("::: MAX(LONGCARD) and MAX(LONGINT).");WrLn;
    END;

    abort(errNone,"");
END BaseConv.
