(* ---------------------------------------------------------------
Title         Q&D New VGA font
Overview      self-explanatory !
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
              assume a VGA card (Graph lib test is too costly,
              and after all, everyone is supposed to have a SVGA now !)

              xlarge model REQUIRED !
              when adding a font, besides command line options,
              remember to change legalkeys string !

              for M2HEXFON.BAS utility to work with .def files,
              original filename must be in line before FontDef(

              recheck resetCharGen with previous code
              132x43 does not like font redefinition : matrox or vesa ?

Bugs          in squash, method2 is ugly and method3 not done yet
              options error checking could be better... but what for ?
Wish List     a better squashing method

--------------------------------------------------------------- *)

MODULE NewFont;

IMPORT Lib;
IMPORT Str;
IMPORT IO;
IMPORT FIO;
IMPORT SYSTEM;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetString, CharCount, same,
aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, cleantabs,str16;

FROM IO IMPORT WrStr, WrLn;

FROM NewFontA IMPORT firstdata, FontDef,
FontCELTIC, FontHEBREW,
FontDEFAULT, FontIBM,
FontVGA, FontELEGANT,
FontROUND, FontMODERN,
FontSANS, FontREADABLE, FontNOVA;

FROM NewFontB IMPORT
FontCOMPUTER, FontDIGITAL,
FontOLDENGLISH, FontGREEK,
FontGREEKSANS, FontREVERSED,
FontHELVETIC, FontHELVBOLD,
FontISO, FontTHIN, FontSCRIPT, FontAWARD;

FROM NewFontC IMPORT
FontSWISS, FontSWISSLARGE,
FontMUCHERY, FontMUCHERYLARGE,
FontMODERNITY, FontMODERNITYLARGE,
FontBLOCKS, FontPLAIN,
FontAPPLE, FontWIN9X, FontARIAL;

FROM NewFontD IMPORT
FontROMAN, FontROMANLARGE,
FontTEKTITE, FontCLOUDS,
FontHAL, FontFAT,
FontBLOOD, FontSERIF,
FontHACKER, FontAMBASSAD,
FontAPPLE2;

FROM NewFontE IMPORT smallFontDef,
smallFontAPPLE,smallFontCOMPAQ,
smallFontSYS,smallFontSYSLINE,smallFontSYSGL,
smallFontWIN9X;

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "NEWFONT";
    ProgTitle     = "Q&D New VGA font";
    ProgVersion   = "v1.1d";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
    esc= CHR(27);
    cr = CHR(13);
    lf = CHR(10);
    nl = cr+lf;
    bs = CHR(8);
    blank=" ";
    extFON        = ".FON";
    fontsize25      = 4096; (* 16 bytes per char pattern : 25/28 rows *)
    fontsize50      = 2048;

(* ------------------------------------------------------------ *)

(* for now, we have defined these fonts -- must be uppercase *)
CONST
    maxfontnamelen=10; (* 9 would be even better now we offer 41 fonts *)
CONST             (* 1234567890 *)
    sCOMPUTER     = "COMPUTER";
    sDIGITAL      = "DIGITAL";
    sOLDENGLISH   = "OLDENGLISH";
    sGREEK        = "GREEK";
    sGREEKSANS    = "GREEKSANS";
    sREVERSED     = "REVERSED"; (* 26 Feb 04 : no longer used  *)
    sELEGANT      = "ELEGANT";
    sROUND        = "ROUND";
    sMODERN       = "MODERN";
    sSANS         = "SANS";
    sREADABLE     = "READABLE";
    sDEFAULT      = "DEFAULT";
    sIBM          = "IBM";
    sVGA          = "VGA";
    sCELTIC       = "CELTIC";
    sHEBREW       = "HEBRAIC"; (* was "HEBREW" *)
    sROMAN        = "ROMAN";
    sROMANLARGE   = "ROMANL";
    sTEKTITE      = "TEKTITE";
    sCLOUDS       = "CLOUDS";
    sSWISS        = "SWISS";
    sSWISSLARGE   = "SWISSL";
    sMUCHERY      = "CHERY";      (* removed "MU" for help screen *)
    sMUCHERYLARGE = "CHERYL";     (* the same ! *)
    sMODERNITY    = "MODERNITY";
    sMODERNITYLARGE="MODERNITYL"; (* 10 chars ! *)
    sBLOCKS       = "BLOCKS";
    sPLAIN        = "PLAIN";
    sHELVETIC     = "HELVETIC";
    sHELVBOLD     = "HELVBOLD";
    sISO          = "ISO";
    sHAL          = "HAL";
    sFAT          = "FAT";
    sBLOOD        = "BLOOD";
    sSERIF        = "SERIF";
    sHACKER       = "HACKER";
    sAPPLE        = "APPLE";
    sAMBASSAD     = "AMBASSAD";
    sTHIN         = "THIN";
    sSCRIPT       = "SCRIPT";
    sARIAL        = "ARIAL";
    sAPPLE2       = "APPLE2";
    sWIN9X        = "WIN";
    sNOVA         = "NOVA";
    sAWARD        = "AWARD";
CONST
    errNone                 = 0;
    errHelp                 = 1;
    errParameter            = 2;
    errOption               = 3;
    errTooManyParms         = 4;
    errCard                 = 5;
    errIllogical            = 6;
    errBadLineCount         = 7;
    errUseless              = 8;
    errEitherOr1            = 9;
    errEitherOr2            = 10;
    errNonsenseWithFile     = 11;
    errNotFound             = 12;
    errBadSize              = 13;
    errInternalNonsenseWithFile=14;
    errBadSizeForCurrentRows= 15;
    errSetMode              = 16;
    errNoAuto               = 17;
    errEither25or50         = 18;
    errNotWithFile          = 19;
    errGenWithFile          = 20;
    errEitherOr3            = 21;
    errObsolete             = 22;
    errUnexpected           = 23;
    errMissingFont          = 24;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
00000000011111111112222222222333333333344444444445555555555666666666677777777778
1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
nl+
Banner+nl+
nl+
"Syntax 1 : "+ProgEXEname+" <font> [-verbose] [-autolines] [-25|-50] [-squash]"+nl+
"Syntax 2 : "+ProgEXEname+" <-preview|-pp> [-clear] [-25|-50]"+nl+
"Syntax 3 : "+ProgEXEname+" <-reset> [-clear] [-25|-50]"+nl+
"Syntax 4 : "+ProgEXEname+" <-file:font["+extFON+"]> [-verbose] [-autolines]"+nl+
"Syntax 5 : "+ProgEXEname+" <-binary>"+nl+
"Syntax 6 : "+ProgEXEname+" <-256>"+nl+
nl+
"<font> is either [1..44] or a font name : "+sCOMPUTER+", "+sDIGITAL+", "+sOLDENGLISH+", "+sGREEK+","+nl+
sGREEKSANS+", "+sAWARD+", "+sELEGANT+", "+sROUND+", "+sMODERN+", "+sSANS+", "+sREADABLE+", "+sDEFAULT+", "+sIBM+", "+sVGA+","+nl+
sCELTIC+", "+sHEBREW+", "+sROMAN+", "+sROMANLARGE+", "+sTEKTITE+", "+sCLOUDS+", "+sSWISS+", "+sSWISSLARGE+", "+sMUCHERY+", "+sMUCHERYLARGE+","+nl+
sMODERNITY+", "+sMODERNITYLARGE+", "+sBLOCKS+", "+sPLAIN+", "+sISO+", "+sHELVETIC+", "+sHELVBOLD+", "+sHAL+", "+sFAT+", "+sBLOOD+","+nl+
sSERIF+", "+sHACKER+", "+sAMBASSAD+", "+sTHIN+", "+sSCRIPT+", "+sARIAL+", "+sAPPLE+", "+sAPPLE2+", "+sWIN9X+" or "+sNOVA+"."+nl+
nl+
"Internal VGA fonts are for 80x25 or 80x28 (not recommanded) text modes."+nl+
"Program will try and resize internal fonts if forced to set 50-lines mode :"+nl+
"however, results will not be a pretty sight, except for a few predefined fonts"+nl+
"("+sSANS+", "+sIBM+", "+sVGA+", "+sTHIN+", "+sAPPLE+", "+sAPPLE2+" and "+sWIN9X+")."+nl+
"External VGA fonts may be 80x25, 80x28, 80x50 or 80x43 text modes."+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errParameter :
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," parameter !");
    | errOption :
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," option !");
    | errTooManyParms :
        S := "Too many parameters !";
    | errCard :
        S := "This program requires a VGA card !";
    | errIllogical :
        S := "You must chose either to load one font or to preview all fonts !";
    | errBadLineCount:
        (* S := "According to BIOS data area, number of rows is neither 25 nor 28 !"; *)
        S := "Unsupported current number of rows !";
    | errUseless:
        S := "-verbose option is useless with -preview command !";
    | errEitherOr1:
        S := "-preview, -reset, -binary and -256 commands are mutually exclusive !";
    | errEitherOr2:
        S := "Specifying a font is a nonsense with -reset option !";
    | errNonsenseWithFile:
        S := "-binary, -reset and -clear are a nonsense with -file option !";
    | errNotFound :
        Str.Concat(S,einfo," font file does not exist !");
    | errBadSize :
        Str.Concat(S,einfo," font file should be 4096 or 2048 bytes long !");
    | errInternalNonsenseWithFile:
        S:="Specifying an internal font is a nonsense with -file option !";
    | errBadSizeForCurrentRows :
        Str.Concat(S,"Current number of rows forbids ",einfo);
        Str.Append(S," loading !");
    | errSetMode:
        Str.Concat(S,einfo,"-lines video mode would not initialize !");
    | errNoAuto:
        S:="-reset and -binary are a nonsense with -auto option !";
    | errEither25or50:
        S:="-25 and -50 options are mutually exclusive !";
    | errNotWithFile:
        S:="-25 and -50 options are a nonsense with -file option !";
    | errGenWithFile:
        S:="-binary is a nonsense with -file option !";
    | errEitherOr3:
        S := "Specifying a font is a nonsense with -256 option !";
    | errObsolete:
        S := "Monochrome mode is so obsolete it's no longer supported ! ;-)";
    | errUnexpected:
        Str.Concat(S,"Unexpected value for ",einfo);Str.Append(S," !");
    | errMissingFont:
        S := "No font was specified !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp :
        ;
    ELSE
        WrStr(nl+ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

PROCEDURE sound (freq,duration:CARDINAL);
BEGIN
    Lib.Sound(freq);
    Lib.Delay(duration);
    Lib.NoSound();
END sound;

(* screen adapted from CHARSET utility *)
(* removed : $00 $01 $02 $03 $04 $07 $08 $09 $0A $0D $1A $1B *)

PROCEDURE showCharSet ();
CONST
    all = nl+
"These codes are NOT displayed : [$00..$04], [$07..$0A], $0D, [$1A..$1B]"+nl+
nl+
"            * The quick brown fox jumped over the lazy dogs. * (,.;!?:) *"+nl+
"    Misc     :   Arrows  :                     "+nl+
' !"'+
   "#$%&'()*+,-./  Currency : $   Figures : 0123456789                FF  "+nl+
"0123456789:;<=>?  Dots     : .    Blocks  :                      VT  "+nl+
"@ABCDEFGHIJKLMNO  Fill     :                                          DEL  "+nl+
"PQRSTUVWXYZ[\]^_  Business Graphic :                                          "+nl+
"`abcdefghijklmno  Ŀͻ ͸ķ  Math: xdx   xx  "+nl+
"pqrstuvwxyz{|}~   A    B     C    D                     "+nl+
"  Ĵ͹ ͵Ķ      Ŀ         "+nl+
"  ͼ ;Ľ      ۳   "+nl+
"                                         ۳         "+nl+
"  Other drawing chars:                      "+nl+
"                   "+nl+
"    1   2 3 4 5 6  7 8 9 0 $   "+nl+
"                   "+nl+
"                    "+nl+

         nl;

BEGIN
    WrStr(all);
END showCharSet;

(* ------------------------------------------------------------ *)

CONST
    segBIOSdata      = 0040H;
    legallinecount25 = BYTE(25-1); (* do not forget BYTE and the minus 1 ! *)
    legallinecount28 = BYTE(28-1);
    legallinecount43 = BYTE(43-1);
    legallinecount50 = BYTE(50-1);
VAR
    rowsOnScreen [segBIOSdata:0084H] : BYTE; (* minus 1 *)

PROCEDURE allowablelinecount (current: BYTE;only25:BOOLEAN ):BOOLEAN ;
BEGIN
    CASE current OF
    | legallinecount25,legallinecount28:RETURN TRUE;
    | legallinecount50,legallinecount43:RETURN (only25=FALSE);
    ELSE
        RETURN FALSE;
    END;
END allowablelinecount;

PROCEDURE modeAlreadySet (wanted:BYTE):BOOLEAN;
BEGIN
    CASE wanted OF
    | 25,28:
        CASE rowsOnScreen OF
        | legallinecount25,legallinecount28:RETURN TRUE;
        ELSE
            RETURN FALSE;
        END;
    | 50,43:
        CASE rowsOnScreen OF
        | legallinecount50,legallinecount43:RETURN TRUE;
        ELSE
            RETURN FALSE;
        END;
    ELSE
        RETURN FALSE;
    END;
END modeAlreadySet;

PROCEDURE allowableFontSize (v:CARDINAL ):BOOLEAN ;
BEGIN
    CASE v OF
    | fontsize25,fontsize50:
        RETURN TRUE;
    ELSE
        RETURN FALSE;
    END;
END allowableFontSize;

(* ------------------------------------------------------------ *)

(* clear screen then reset chargen *)

PROCEDURE resetCharGen (lines : BYTE;fullreset:BOOLEAN );
CONST
    videoBIOS = 10H;
    block     = 00H; (* block to load must be 0, else ugly results ! *)
VAR
    R : SYSTEM.Registers;
    columns,displaymode,activepage:SHORTCARD;
    cursorstart,cursorend,cursorcolumn,cursorrow:SHORTCARD;
    fontheight [0040H:0085H] : CARDINAL;

    oldscanlines : CARDINAL;
    newscanlines : CARDINAL;
    newcursorstart,newcursorend:CARDINAL;
    setpattern:CARDINAL;
BEGIN
    CASE lines OF
    | legallinecount50, legallinecount43 :
        setpattern := 1112H; (* 8x8 ROM DBL-dot patterns EGA/VGA *)
    | legallinecount28 :
        setpattern := 1111H; (* 8x14 ROM monochrome patterns EGA/VGA *)
    | legallinecount25 :
        setpattern := 1114H; (* 8x16 ROM VGA *)
    ELSE
        RETURN;
    END;

    (* pattern MUST be $111x because $110x does NOT work : Matrox strikes again ! *)
    (* block other than 0 is a no-no *)

IF fullreset THEN
    oldscanlines := fontheight;

    R.AH := 0FH;           (* get current video mode *)
    Lib.Intr(R,videoBIOS);
    columns     := R.AH;
    displaymode := R.AL;   (* bit 7 can be ON if previous mode setting was so *)
    activepage  := R.BH;

    R.AH := 03H;           (* get cursor position and size *)
    R.BH := activepage;
    Lib.Intr(R,videoBIOS);
    cursorstart := R.CH;
    cursorend   := R.CL;
    cursorcolumn:= R.DL;
    cursorrow   := R.DH;

    R.AH := 00H;           (* set video mode *)
    R.AL := displaymode;
    Lib.Intr(R,videoBIOS);
END;

    R.AX := setpattern;
    R.BL := SHORTCARD(block);
    Lib.Intr(R,videoBIOS);

    (*
    R.AX := 1130H;         (* get font information *)
    R.BL := 00H;           (* dummy, just in case : get int $1F pointer *)
    Lib.Intr(R,videoBIOS);
    scanlines := SHORTCARD(R.CX);  (* pixels per char, same as $0040:0085 (word) *)
    *)
IF fullreset THEN
    newscanlines := fontheight;

    newcursorstart := (newscanlines * CARDINAL(cursorstart)) DIV oldscanlines;
    newcursorend   := (newscanlines * CARDINAL(cursorend  )) DIV oldscanlines;

    R.AH := 01H;           (* set text-mode cursor shape *)
    R.CH := SHORTCARD(newcursorstart);
    R.CL := SHORTCARD(newcursorend);
    Lib.Intr(R,videoBIOS);
END;
END resetCharGen;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    CO80 = BYTE(3); (* color 80x25 *)
    MONO = BYTE(7); (* monochrome *)
CONST
    iv = 010H; (* video interrupt is $10 *)
    sb = 040H; (* segBiosData *)
VAR
    biosCurrentVideoMode  [sb:049H] : BYTE;

PROCEDURE isMonoMode ():BOOLEAN;
BEGIN
    RETURN (biosCurrentVideoMode = MONO);
END isMonoMode;

PROCEDURE set25LineMode () : BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    (* select vertical resolution vga *)
    R.AH := 12H;
    R.BL := 30H;
    R.AL := 02H;        (* 0=200, 1=350, 2=400 *)
    Lib.Intr(R,iv);     (* al=$12 if function supported *)
    IF R.AL # 12H THEN RETURN FALSE; END;
    (* set video mode *)
    R.AH := 00H;
    R.AL := CO80;
    Lib.Intr(R,iv);
    RETURN TRUE;
END set25LineMode;

PROCEDURE set50LineMode (  ) : BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    IF isMonoMode() THEN RETURN FALSE; END;
    (* select vertical resolution vga *)
    R.AH := 12H;
    R.BL := 30H;
    R.AL := 02H;        (* 0=200, 1=350, 2=400 *)
    Lib.Intr(R,iv);     (* al=$12 if function supported *)
    IF R.AL # 12H THEN RETURN FALSE; END;
    (* set video mode *)
    R.AH := 00H;
    R.AL := CO80;
    Lib.Intr(R,iv);
    (* load rom 8x8 dbl-dot patterns *)
    R.AH := 11H;
    R.AL := 12H;
    R.BL := 00H;        (* load block 0 *)
    Lib.Intr(R,iv);
    RETURN TRUE;
END set50LineMode;

PROCEDURE resetMode (force25,force50:BOOLEAN;VAR R:ARRAY OF CHAR):BOOLEAN;
BEGIN
    (* don't reset if we're already in mode *)
    IF force25 THEN
        Str.Copy(R,"25");
        IF modeAlreadySet(25) THEN
            RETURN TRUE;
        ELSE
            RETURN set25LineMode();
        END;
    ELSIF force50 THEN
        Str.Copy(R,"50");
        IF modeAlreadySet(50) THEN
            RETURN TRUE;
        ELSE
            RETURN set50LineMode();
        END;
    END;
    Str.Copy(R,"???");
    RETURN TRUE; (* no change ! *)
END resetMode;

(* ------------------------------------------------------------ *)

PROCEDURE getFontParms (i:CARDINAL;
                       VAR internalSmallFont:CARDINAL;
                       VAR S:ARRAY OF CHAR;
                       VAR fontdata:FontDef):BOOLEAN;
VAR
    fontname:str128;
BEGIN
    internalSmallFont:=MAX(CARDINAL);
    CASE i OF
    |  1 : fontdata := FontCOMPUTER;      fontname := sCOMPUTER;
    |  2 : fontdata := FontDIGITAL;       fontname := sDIGITAL;
    |  3 : fontdata := FontOLDENGLISH;    fontname := sOLDENGLISH;
    |  4 : fontdata := FontGREEK;         fontname := sGREEK;
    |  5 : fontdata := FontGREEKSANS;     fontname := sGREEKSANS;
    |  6 : fontdata := FontAWARD;         fontname := sAWARD;
    |  7 : fontdata := FontELEGANT;       fontname := sELEGANT;
    |  8 : fontdata := FontROUND;         fontname := sROUND;
    |  9 : fontdata := FontMODERN;        fontname := sMODERN;
    | 10 : fontdata := FontSANS;          fontname := sSANS;  internalSmallFont:=i;
    | 11 : fontdata := FontREADABLE;      fontname := sREADABLE;
    | 12 : fontdata := FontDEFAULT;       fontname := sDEFAULT;
    | 13 : fontdata := FontIBM;           fontname := sIBM;   internalSmallFont:=i;
    | 14 : fontdata := FontVGA;           fontname := sVGA;   internalSmallFont:=i;
    | 15 : fontdata := FontCELTIC;        fontname := sCELTIC;
    | 16 : fontdata := FontHEBREW;        fontname := sHEBREW;
    | 17 : fontdata := FontROMAN;         fontname := sROMAN;
    | 18 : fontdata := FontROMANLARGE;    fontname := sROMANLARGE;
    | 19 : fontdata := FontTEKTITE;       fontname := sTEKTITE;
    | 20 : fontdata := FontCLOUDS;        fontname := sCLOUDS;
    | 21 : fontdata := FontSWISS;         fontname := sSWISS;
    | 22 : fontdata := FontSWISSLARGE;    fontname := sSWISSLARGE;
    | 23 : fontdata := FontMUCHERY;       fontname := sMUCHERY;
    | 24 : fontdata := FontMUCHERYLARGE;  fontname := sMUCHERYLARGE;
    | 25 : fontdata := FontMODERNITY;     fontname := sMODERNITY;
    | 26 : fontdata := FontMODERNITYLARGE;fontname := sMODERNITYLARGE;
    | 27 : fontdata := FontBLOCKS;        fontname := sBLOCKS;
    | 28 : fontdata := FontPLAIN;         fontname := sPLAIN;
    | 29 : fontdata := FontISO;           fontname := sISO;
    | 30 : fontdata := FontHELVETIC;      fontname := sHELVETIC;
    | 31 : fontdata := FontHELVBOLD;      fontname := sHELVBOLD;
    | 32 : fontdata := FontHAL;           fontname := sHAL;
    | 33 : fontdata := FontFAT;           fontname := sFAT;
    | 34 : fontdata := FontBLOOD;         fontname := sBLOOD;
    | 35 : fontdata := FontSERIF;         fontname := sSERIF;
    | 36 : fontdata := FontHACKER;        fontname := sHACKER;
    | 37 : fontdata := FontAMBASSAD;      fontname := sAMBASSAD;
    | 38 : fontdata := FontTHIN;          fontname := sTHIN;   internalSmallFont:=i;
    | 39 : fontdata := FontSCRIPT;        fontname := sSCRIPT;
    | 40 : fontdata := FontARIAL;         fontname := sARIAL;
    | 41 : fontdata := FontAPPLE;         fontname := sAPPLE;  internalSmallFont:=i;
    | 42 : fontdata := FontAPPLE2;        fontname := sAPPLE2; internalSmallFont:=i;
    | 43 : fontdata := FontWIN9X;         fontname := sWIN9X;  internalSmallFont:=i;
    | 44 : fontdata := FontNOVA;          fontname := sNOVA;
    ELSE
        RETURN FALSE;
    END;
    Str.Copy(S,fontname);
    RETURN TRUE;
END getFontParms;

CONST
    method1 = 1;
    method2 = 2;
    method3 = 3;
    method4 = 4;
    method5 = 5;
    method6 = 6;

(* see 25to50.bas and no, won't bother to write a cleaner bit-manipulating version ! *)

PROCEDURE squash (forcesquash:BOOLEAN; internalSmallFont, squashmethod:CARDINAL;
                  VAR fontbuff:FontDef);
TYPE
    ktype     = ARRAY [1..3] OF CARDINAL;
    matrixtype= ARRAY [1..4] OF ktype;
CONST
    transfo1 = matrixtype ( ktype(0,1,0),
                            ktype(1,2,1),
                            ktype(1,2,1),
                            ktype(0,1,0));
    divisor1 = 2+2+1+1+1+1+1+1-1;
    transfo2 = matrixtype ( ktype(0,0,0),
                            ktype(0,2,0),
                            ktype(0,2,0),
                            ktype(0,0,0));
    divisor2 = 2+2-1;
    transfo3 = matrixtype ( ktype(0,0,0),
                            ktype(0,2,0),
                            ktype(0,2,0),
                            ktype(0,0,0));
    divisor3 = 2+2-1-1;
    transfo4 = matrixtype ( ktype(1,0,1),
                            ktype(0,2,0),
                            ktype(0,2,0),
                            ktype(1,0,1));
    divisor4 = 1+1+2+2+1+1-1;
TYPE
    str8 = ARRAY [1..8] OF CHAR;
CONST
    blanc = "00000000"; (* 8 blanks *)
    combi1= "0"+delim+"1";
    combi2= "00"+delim+"10"+delim+"01"+delim+"11";
VAR
    old : ARRAY [1..16] OF str8;
    now : ARRAY [1..8] OF str8;
    R,a,b : str8;
    ca,cb,c:CHAR;
    sa,sb,sc:str2;
    psrc,pto,n,i,w,j,y,x : CARDINAL;
    v:BYTE;
    lv:LONGCARD;
    ok:BOOLEAN;
    ii,jj,sigma,k,bval,divisor:CARDINAL;
    transfo:matrixtype;
BEGIN
    IF forcesquash THEN internalSmallFont:=MAX(CARDINAL);END;
    CASE internalSmallFont OF (* see GetFontParms values *)
    | 10: (* SANS *)
        Lib.FarMove(FarADR(smallFontSYSGL ) ,FarADR(fontbuff),SIZE(smallFontAPPLE));
        RETURN;
    | 13: (* IBM *)
        Lib.FarMove(FarADR(smallFontCOMPAQ) ,FarADR(fontbuff),SIZE(smallFontAPPLE));
        RETURN;
    | 14: (* VGA *)
        Lib.FarMove(FarADR(smallFontSYS)    ,FarADR(fontbuff),SIZE(smallFontAPPLE));
        RETURN;
    | 38: (* THIN *)
        Lib.FarMove(FarADR(smallFontSYSLINE),FarADR(fontbuff),SIZE(smallFontAPPLE));
        RETURN;
    | 41: (* APPLE *)
        Lib.FarMove(FarADR(smallFontAPPLE)  ,FarADR(fontbuff),SIZE(smallFontAPPLE));
        RETURN;
    | 42: (* APPLE2 *)
        Lib.FarMove(FarADR(smallFontAPPLE)  ,FarADR(fontbuff),SIZE(smallFontAPPLE));
        RETURN;
    | 43: (* WIN *)
        Lib.FarMove(FarADR(smallFontWIN9X)  ,FarADR(fontbuff),SIZE(smallFontWIN9X));
        RETURN;
    END;
    psrc := firstdata;
    pto  := firstdata;
    FOR n := 0 TO 255 DO
        FOR i:=1 TO 16 DO
            v:=fontbuff[psrc];
            Str.CardToStr( LONGCARD(v),R,2,ok);
            FOR w:=Str.Length(R)+1 TO 8 DO Str.Prepend(R,"0");END;
            old[i]:=R;
            INC(psrc);
        END;
        FOR i:=1 TO 8 DO
            now[i]:=blanc;
        END;

        CASE squashmethod OF
        | method1: (* raw squashing considering 2 dots (x,y x,y+1) *)
            j:=1;
            FOR y:=1 TO 16 BY 2 DO
		        a:=old[y];
		        b:=old[y+1];
                R:="";
		        FOR x:=1 TO 8 DO
        	        ca:=a[x];
                    cb:=b[x];
                    CASE getStrIndex(delim,ca,  combi1) OF
                    | 1:
                        CASE getStrIndex(delim,cb, combi1) OF
                        | 1: c:="0";
                        | 2: c:="1";
                        END;
                    | 2:
                         CASE getStrIndex(delim,cb, combi1) OF
                        | 1: c:="1";
                        | 2: c:="1";
                        END;
                    END;
                    Str.Append(R,c);
                END;
                now[j]:=R;
                INC(j);
            END;
        | method2: (* raw squashing considering 4 dots (x,y x,y+1 x+1,y x+1,y+1) *)
            j:=1;
            FOR y:=1 TO 16 BY 2 DO
		        a:=old[y];
                b:=old[y+1];
		        R:="";
		        FOR x:=1 TO 8 BY 2 DO
        	        Str.Slice (sa, a, x,2);
                    Str.Slice (sb, b, x,2);
                    CASE getStrIndex(delim,sa,  combi2) OF
                    | 1 :
                        CASE getStrIndex(delim,sb,  combi2) OF
                        | 1 : sc:="00";
                        | 2 : sc:="10";sc:="00";
                        | 3 : sc:="01";sc:="00";
                        | 4 : sc:="11";
                        END;
                    | 2 :
                        CASE getStrIndex(delim,sb,  combi2) OF
                        | 1 : sc:="10";sc:="00";
                        | 2 : sc:="10";
                        | 3 : sc:="01";
                        | 4 : sc:="11";
                        END;
                    | 3 :
                        CASE getStrIndex(delim,sb,  combi2) OF
                        | 1 : sc:="01"; sc:="00";
                        | 2 : sc:="10";
                        | 3 : sc:="01";
                        | 4 : sc:="11";
                        END;
                    | 4 :
                        CASE getStrIndex(delim,sb,  combi2) OF
                        | 1 : sc:="11";
                        | 2 : sc:="11";
                        | 3 : sc:="11";
                        | 4 : sc:="11";
                        END;
                    END;
                    Str.Append(R,sc);
                END;
                now[j]:=R;
                INC(j);
            END;
        | method3,method4,method5,method6:
            CASE squashmethod OF
            | method3 : transfo:=transfo1; divisor:=divisor1;
            | method4 : transfo:=transfo2; divisor:=divisor2;
            | method5 : transfo:=transfo3; divisor:=divisor3;
            | method6 : transfo:=transfo4; divisor:=divisor4;
            END;
            j:=1;
            FOR y:=1+1 TO 16-1 BY 2 DO
                a:=old[y];
                R:="";
		        FOR x:=1 TO 8 DO
		            CASE a[x] OF
		            | "0": bval:=0;
		            | "1": bval:=1;
		            END;
		            sigma:=0;
		            FOR jj:=1 TO 4 DO
		                CASE (y+jj-1-1) OF
		                | 1..16:
		                    FOR ii:=1 TO 3 DO
		                        CASE (x+ii-1-1) OF
		                        | 1..8:
		                            k:=transfo[jj][ii];
		                            INC(sigma,bval*k);
		                        END;
		                    END;
		                END;
		            END;
		            sigma:=sigma DIV divisor;
		            IF sigma=0 THEN
		                Str.Append(R,"0");
		            ELSE
		                Str.Append(R,"1");
		            END;
		        END;
		        now[j]:=R;
		        INC(j);
            END;
        END;

        (* update *)
        FOR i:=1 TO 8 DO
            R:=now[i];
            lv:=Str.StrToCard(R,2,ok);
            fontbuff[pto]:=BYTE(lv);
            INC(pto);
        END;
    END;
END squash;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

VAR
    bioscols  [00040H:004AH] : CARDINAL;
    biosrows  [00040H:0084H] : SHORTCARD; (* add 1 *)

CONST
    minCol    = 1;
    maxCol    = 132;
    minRow    = 1;
    maxRow    = 60;
    firstcell = 0;
    maxcell   = (maxCol * maxRow) -1;
TYPE
    vcell = RECORD
        ch   : CHAR;
        attr : SHORTCARD;
    END;
TYPE
    scrtype = ARRAY [firstcell..maxcell] OF vcell;
VAR
    Ybase     : ARRAY [minRow..maxRow] OF CARDINAL;
    vidscr [0B800H:0000H] : scrtype; (* hard-coded : monochrome is dead ! *)

PROCEDURE initYbase (lastrow,lastcol:CARDINAL);
VAR
    i,p:CARDINAL;
BEGIN
    p := 0;
    FOR i := minRow TO lastrow DO
        Ybase[i]:=p;
        INC(p,lastcol);
    END;
END initYbase;

PROCEDURE vradarAttr (x,y:CARDINAL):SHORTCARD;
VAR
    p : CARDINAL;
BEGIN
    p := Ybase[y]+x-minCol;    (* remember first column is 1, not 0 *)
    RETURN vidscr[p].attr;
END vradarAttr;

PROCEDURE vplot (x,y:CARDINAL;attr:SHORTCARD;ch:CHAR);
VAR
    p : CARDINAL;
BEGIN
    p := Ybase[y]+x-minCol;    (* remember first column is 1, not 0 *)
    vidscr[p].ch   := ch;
    vidscr[p].attr := attr;
END vplot;

PROCEDURE vplotnl (VAR x,y:CARDINAL; attr:SHORTCARD;  S:ARRAY OF CHAR);
VAR
    i,p : CARDINAL;
BEGIN
    p := Ybase[y]+x-minCol;    (* remember first column is 1, not 0 *)
    FOR i:=1 TO Str.Length(S) DO
        vidscr[p].ch   := S[i-1];
        vidscr[p].attr := attr;
        INC(p);
    END;
    INC(y);
    x:=minCol;
END vplotnl;

PROCEDURE vcls (attr:SHORTCARD; ch:CHAR; lastrow,lastcol:CARDINAL);
VAR
    x,y : CARDINAL;
BEGIN
        FOR y := minRow TO lastrow DO
            FOR x := minCol TO lastcol DO
                vplot(x,y,attr,ch);
            END;
        END;
END vcls;

PROCEDURE dumpToScreen (VAR R:ARRAY OF CHAR):BOOLEAN ;
VAR
    i,lastcol,lastrow,lastcell,x,y,count,ypos:CARDINAL;
    attr:SHORTCARD;
BEGIN
    lastcol  := bioscols;
    lastrow  := CARDINAL(biosrows)+1;
    lastcell := (lastcol * lastrow) -1;

    IF lastcol > maxCol THEN Str.Copy(R,"columns");RETURN FALSE;END;
    IF lastrow > maxRow THEN Str.Copy(R,"rows");RETURN FALSE;  END;
    IF lastcell > maxcell THEN Str.Copy(R,"cells");RETURN FALSE;END;

    IF lastcol >= 132 THEN Str.Copy(R,"VESA columns");RETURN FALSE; END; (* handle 132x43 quirks *)

    initYbase (lastrow,lastcol);

    count:=lastrow+2;

    FOR i:=minRow TO count DO
        WrLn;                   (* this is sooo brutal *)
    END;
    attr:=vradarAttr(minCol,lastrow);

    vcls(attr,blank,lastrow,lastcol);

    ypos:=minRow+(lastrow-16-1); (* account for text and newline at program exit *)

    x:=minCol;
    y:=ypos;
    FOR i:=0 TO 4 DO
        vplot(x,y,attr,CHR(i));
        INC(x);
    END;

vplotnl(x,y,attr,""+CHR(7H)+CHR(8H)+CHR(9H)+CHR(0AH)+""+CHR(0DH)+"  * The quick brown fox jumped over the lazy dogs. * (,.;!?:) *");
vplotnl(x,y,attr,""+CHR(1AH)+CHR(1BH)+"  Misc     :   Arrows  :                     ");
vplotnl(x,y,attr,' !"'+"#$%&'()*+,-./  Currency : $   Figures : 0123456789                FF  ");
vplotnl(x,y,attr,"0123456789:;<=>?  Dots     : .    Blocks  :                      VT  ");
vplotnl(x,y,attr,"@ABCDEFGHIJKLMNO  Fill     :                                          DEL  ");
vplotnl(x,y,attr,"PQRSTUVWXYZ[\]^_  Business Graphic :                                          ");
vplotnl(x,y,attr,"`abcdefghijklmno  Ŀͻ ͸ķ  Math: xdx   xx  ");
vplotnl(x,y,attr,"pqrstuvwxyz{|}~   A    B     C    D                     ");
vplotnl(x,y,attr,"  Ĵ͹ ͵Ķ      Ŀ         ");
vplotnl(x,y,attr,"  ͼ ;Ľ      ۳   ");
vplotnl(x,y,attr,"                                         ۳         ");
vplotnl(x,y,attr,"  Other drawing chars:                      ");
vplotnl(x,y,attr,"                   ");
vplotnl(x,y,attr,"    1   2 3 4 5 6  7 8 9 0 $   ");
vplotnl(x,y,attr,"                   ");
vplotnl(x,y,attr,"                    ");

    RETURN TRUE;
END dumpToScreen;


(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    videoBIOS = 10H;
    legalkeys = "&"+
                  '"'+
                   "'(-_)=azertyuiopqsdfghjklm*wxcvbn,;:!";
    prompt = "["+legalkeys+"] [+-] [Enter] : "; (* " : " was "=font " *)
    promptshortcut = " - ";
    minndxkey = 1; (* first char in legalkeys string +1 *)
VAR
    fontdata : FontDef;
    Reg : SYSTEM.Registers;
VAR
    parmcount,i,opt : CARDINAL;
    S,R         : str128;
    state     : (waiting,gotfont);
VAR
    preview   : BOOLEAN;
    verbose   : BOOLEAN;
    c1c2      : str2;
    shortcut  : str16;
    ch        : CHAR;
    validkey  : BOOLEAN;
    fontname  : str128;
    len       : CARDINAL;
    ndxkey    : CARDINAL;
    maxndxkey : CARDINAL;
    reset,fullreset,autoset,forcefile,force25,force50:BOOLEAN;
    recreate,directshow: BOOLEAN;
    method    : CARDINAL;
    forcesquash:BOOLEAN;
    internalSmallFont : CARDINAL;
    hnd       : FIO.File;
    fontfile  : str128;
    fsize,bytesPerChar : CARDINAL;
    ok:BOOLEAN;
    action : (loadfile,videoreset,genfonts,loadinternal,previewfonts,showcharset);
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    preview := FALSE;
    verbose := FALSE;
    reset   := FALSE;
    fullreset:=FALSE;
    forcefile:=FALSE;
    autoset :=FALSE;
    recreate:=FALSE;
    directshow:=FALSE;
    force25 :=FALSE;
    force50 :=FALSE;
    method  := method1;
    forcesquash       := FALSE;
    internalSmallFont := MAX(CARDINAL); (* not really required here... *)

    state   := waiting;

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;

    FOR i := 1 TO parmcount DO (* for future extension ! *)
        Lib.ParamStr(S,i);
        cleantabs(S); (* yet another silly TopSpeed bug ! *)
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "P"+delim+"PREVIEW"+delim+
                                 "V"+delim+"VERBOSE"+delim+
                                 "R"+delim+"RESET"+delim+"DEFAULT"+delim+"BIOS"+delim+
                                 "C"+delim+"CLEAR"+delim+"CLS"+delim+"FULL"+delim+
                                 "F:"+delim+"FILE:"+delim+
                                 "A"+delim+"AUTOLINES"+delim+"AUTO"+delim+
                                 "25"+delim+"2"+delim+
                                 "50"+delim+"5"+delim+
                                 "S"+delim+"SQUASH"+delim+
                                 "B"+delim+"BINARY"+delim+
                                 "M1"+delim+
                                 "M2"+delim+
                                 "M3"+delim+
                                 "M4"+delim+
                                 "M5"+delim+
                                 "M6"+delim+
                                 "256"+delim+"SET"+delim+
                                 "PP"+delim+"PREVIEWVIDEO"
                              );
            CASE opt OF
            | 1,2,3 :       abort(errHelp,"");
            | 4,5 :         preview   := TRUE;
            | 6,7 :         verbose   := TRUE;
            | 8,9,10,11:    reset     := TRUE;
            | 12,13,14,15:  fullreset := TRUE;
            | 16,17:        GetString(R,fontfile); forcefile:=TRUE;
            | 18,19,20:     autoset   :=TRUE;
            | 21,22:        force25   :=TRUE;
            | 23,24:        force50   :=TRUE;
            | 25,26:        forcesquash:=TRUE;
            | 27,28:        recreate  :=TRUE;
            | 29:           method    :=method1;
            | 30:           method    :=method2;
            | 31:           method    :=method3;
            | 32:           method    :=method4;
            | 33:           method    :=method5;
            | 34:           method    :=method6;
            | 35,36:        directshow:=TRUE;
            | 37,38:        preview   :=TRUE; directshow:=TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            CASE state OF
            | waiting :
                opt := getStrIndex(delim,R,
                                   "1"+delim+sCOMPUTER+delim+
                                   "2"+delim+sDIGITAL+delim+
                                   "3"+delim+sOLDENGLISH+delim+
                                   "4"+delim+sGREEK+delim+
                                   "5"+delim+sGREEKSANS+delim+
                                   "6"+delim+sAWARD+delim+
                                   "7"+delim+sELEGANT+delim+
                                   "8"+delim+sROUND+delim+
                                   "9"+delim+sMODERN+delim+
                                  "10"+delim+sSANS+delim+
                                  "11"+delim+sREADABLE+delim+
                                  "12"+delim+sDEFAULT+delim+
                                  "13"+delim+sIBM+delim+
                                  "14"+delim+sVGA+delim+
                                  "15"+delim+sCELTIC+delim+
                                  "16"+delim+sHEBREW+delim+
                                  "17"+delim+sROMAN+delim+
                                  "18"+delim+sROMANLARGE+delim+
                                  "19"+delim+sTEKTITE+delim+
                                  "20"+delim+sCLOUDS+delim+
                                  "21"+delim+sSWISS+delim+
                                  "22"+delim+sSWISSLARGE+delim+
                                  "23"+delim+sMUCHERY+delim+
                                  "24"+delim+sMUCHERYLARGE+delim+
                                  "25"+delim+sMODERNITY+delim+
                                  "26"+delim+sMODERNITYLARGE+delim+
                                  "27"+delim+sBLOCKS+delim+
                                  "28"+delim+sPLAIN+delim+
                                  "29"+delim+sISO+delim+
                                  "30"+delim+sHELVETIC+delim+
                                  "31"+delim+sHELVBOLD+delim+
                                  "32"+delim+sHAL+delim+
                                  "33"+delim+sFAT+delim+
                                  "34"+delim+sBLOOD+delim+
                                  "35"+delim+sSERIF+delim+
                                  "36"+delim+sHACKER+delim+
                                  "37"+delim+sAMBASSAD+delim+
                                  "38"+delim+sTHIN+delim+
                                  "39"+delim+sSCRIPT+delim+
                                  "40"+delim+sARIAL+delim+
                                  "41"+delim+sAPPLE+delim+
                                  "42"+delim+sAPPLE2+delim+
                                  "43"+delim+sWIN9X+delim+
                                  "44"+delim+sNOVA
                                  );
                IF getFontParms( ((opt+1) DIV 2),internalSmallFont,fontname,fontdata)=FALSE THEN
                    abort(errParameter,S);
                END;
                INC(state);
            | gotfont :
                abort(errTooManyParms,S);
            END;
        END;
    END;

    IF (force25 AND force50) THEN abort(errEither25or50,"");END;

    CASE state OF
    | waiting :
        IF preview THEN
            IF (reset OR recreate) THEN abort(errEitherOr1,"");END;
        ELSIF reset THEN
            IF (preview OR recreate OR directshow) THEN abort(errEitherOr1,"");END;
        ELSIF recreate THEN
            IF (reset OR preview OR directshow) THEN abort(errEitherOr1,"");END;
        ELSIF directshow THEN
            IF (reset OR recreate) THEN abort(errEitherOr1,"");END;
        END;
        IF (force25 OR force50) THEN abort(errMissingFont,"");END;
    | gotfont:
        IF reset THEN abort(errEitherOr2,"");END;
        IF forcefile THEN abort(errInternalNonsenseWithFile,"");END;
        IF recreate THEN abort(errGenWithFile,"");END;
        IF directshow THEN abort(errEitherOr3,"");END;
    END;

    IF allowablelinecount(rowsOnScreen,FALSE)=FALSE THEN abort(errBadLineCount,""); END;

    IF forcefile THEN
        action:=loadfile;
    ELSIF reset THEN
        action:=videoreset;
    ELSIF recreate THEN
        action:=genfonts;
    ELSIF preview THEN
        action:=previewfonts;
    ELSIF directshow THEN
        action:=showcharset;
    ELSE
        action:=loadinternal;
    END;

    CASE action OF
    | loadfile:
        IF (force25 OR force50) THEN abort(errNotWithFile,"");END;

        IF (reset OR fullreset OR recreate) THEN abort(errNonsenseWithFile,"");END;
        IF Str.CharPos(fontfile,".")=MAX(CARDINAL) THEN
            Str.Append(fontfile,extFON);
        END;
        IF FIO.Exists(fontfile)=FALSE  THEN abort(errNotFound,fontfile); END;
        hnd := FIO.OpenRead(fontfile);
        IF FIO.Size (hnd) > MAX(CARDINAL) THEN
            FIO.Close(hnd);
            abort(errBadSize,fontfile); (* stop even if we're in a loop *)
        END;
        fsize:=CARDINAL(FIO.Size(hnd));
        IF allowableFontSize( fsize )=FALSE  THEN
            FIO.Close(hnd);
            abort(errBadSize,fontfile); (* stop even if we're in a loop *)
        END;
        opt := FIO.RdBin(hnd,fontdata, fsize );
        FIO.Close(hnd);

        CASE fsize OF
        | fontsize25:
            CASE rowsOnScreen OF
            | legallinecount25,legallinecount28: bytesPerChar := 16;
            ELSE
                IF autoset THEN
                    IF set25LineMode()=FALSE THEN abort(errSetMode,"25");END;
                    bytesPerChar := 16;
                ELSE
                    abort(errBadSizeForCurrentRows,fontfile); (* stop even if we're in a loop *)
                END;
            END;
        | fontsize50:
            CASE rowsOnScreen OF
            | legallinecount50,legallinecount43: bytesPerChar := 8;
            ELSE
                IF autoset THEN
                    IF set50LineMode()=FALSE THEN abort(errSetMode,"50");END;
                    bytesPerChar := 8;
                ELSE
                    abort(errBadSizeForCurrentRows,fontfile); (* stop even if we're in a loop *)
                END;
            END;
        END;

        Reg.AX := 1100H;
        Reg.ES := Seg(FarADDRESS(fontdata)); (* es:bp -> user table *)
        Reg.BP := Ofs(FarADDRESS(fontdata));
        Reg.CX := 256; (* count of patterns to store *)
        Reg.DX := 0;   (* character offset into map 2 block *)
        Reg.BL := 0;   (* block to load in map 2 *)
        Reg.BH := BYTE(bytesPerChar);  (* number of bytes per character pattern : here 16 for VGA 80x25 *)
        Lib.Intr(Reg,videoBIOS);
        IF preview THEN
            showCharSet;
        END;
        IF verbose THEN
            WrLn;
            WrStr(fontfile); WrStr(" file loaded !"); WrLn;
        END;
    | videoreset:
        IF (autoset OR recreate) THEN abort(errNoAuto,"");END;
        IF resetMode(force25,force50,S)=FALSE THEN abort(errSetMode,S);END;
        resetCharGen(rowsOnScreen,fullreset);
    | genfonts:
        WrLn;
        forcesquash := FALSE; (* we'll dump only stored internal small fonts *)
        method      := method1; (* useless here but... *)
        FOR opt:=1 TO 2 DO
            CASE opt OF
            | 1: fsize:=4096;
            | 2: fsize:=2048;
            END;

            i:=1;
            LOOP
                IF getFontParms( i,internalSmallFont,fontname,fontdata)=FALSE THEN
                    EXIT;
                END;
                Str.CardToStr( LONGCARD(i),fontfile,10,ok);
                IF i < 10 THEN Str.Prepend(fontfile,"0");END; (* assume 01..99 ! *)
                CASE opt OF
                | 1:
                    ok:=TRUE;
                | 2:
                    IF internalSmallFont = MAX(CARDINAL) THEN
                        ok:=FALSE;
                    ELSE
                        squash(forcesquash,internalSmallFont,method,fontdata);
                        Str.Append(fontfile,"_");
                        ok:=TRUE;
                    END;
                END;
                IF ok THEN
                    Str.Append(fontfile,extFON);
                    WrStr("Creating ");WrStr(fontfile);
                    WrStr(" (");WrStr(fontname);WrStr(")...");
                    hnd := FIO.Create(fontfile);
                    FIO.WrBin (hnd,fontdata,fsize);
                    FIO.Flush(hnd);
                    FIO.Close(hnd);
                    WrStr(" Done !");WrLn;
                END;
                INC(i);
            END;

        END;
    | previewfonts: (* we'll use an internal 80x25 font here, squashed if required *)        IF resetMode(force25,force50,S)=FALSE THEN abort(errSetMode,S);END;
        IF modeAlreadySet(25) THEN
            bytesPerChar:=16;
        ELSIF modeAlreadySet(50) THEN
            bytesPerChar:=8;
            squash(forcesquash,internalSmallFont,method,fontdata);
        ELSE
            abort(errBadLineCount,"");
        END;

        IF state=gotfont THEN abort(errIllogical,"");END;
        IF verbose THEN abort(errUseless,"");END;
        (* IF autoset THEN abort(errNoAuto,"-preview");END; *)

        maxndxkey := Str.Length(legalkeys);
        ndxkey    := maxndxkey+1; (* if next key is "+" then min, if it's "-" then max *)

        fontname := "<none>";

        IF directshow THEN
            IF isMonoMode() THEN abort(errObsolete,"");END; (* yuck ! *)
            IF dumpToScreen(R)=FALSE THEN abort(errUnexpected,R);END;
            WrLn;
        ELSE
            showCharSet();
        END;
        WrStr(prompt);
        LOOP
            IF ndxkey = (maxndxkey+1) THEN
                shortcut:="";
            ELSE
                Str.Concat(shortcut,legalkeys[ndxkey-1],promptshortcut);
            END;
            WrStr(shortcut);

            len := Str.Length(fontname);
            WrStr(fontname);
            FOR i := len+1 TO maxfontnamelen DO
                WrStr(" "); (* erase possible previous chars *)
            END;
            FOR i := 1 TO maxfontnamelen+Str.Length(shortcut) DO
                IO.WrChar(bs);
            END;
            Flushkey();
            c1c2:=Waitkey();
            ch := c1c2[0];
            IF ch= esc THEN resetCharGen(rowsOnScreen,fullreset);EXIT; END;
            IF ch= cr  THEN EXIT; END;
            Str.Lows(ch);

            (* simulate key entry *)
            CASE ch OF
            | "+" :
                INC(ndxkey);
                IF ndxkey > maxndxkey THEN ndxkey := minndxkey;END;
                ch := legalkeys[ndxkey-1];
            | "-" :
                DEC(ndxkey);
                IF ndxkey < minndxkey THEN ndxkey := maxndxkey;END;
                ch := legalkeys[ndxkey-1];
            END;

            validkey := TRUE;
            i:=Str.CharPos(legalkeys,ch);
            IF i # MAX(CARDINAL) THEN INC(i);END;
            IF getFontParms(i,internalSmallFont,fontname,fontdata)=FALSE THEN
                sound(55,50);
                BiosFlushkey();
                validkey := FALSE;
            END;
            IF validkey THEN
                IF bytesPerChar=8 THEN squash(forcesquash,internalSmallFont,method,fontdata);END;

                (* update ndxkey using ch *)
                ndxkey := Str.CharPos(legalkeys,ch)+1;

                Reg.AX := 1100H;
                Reg.ES := Seg(FarADDRESS(fontdata)); (* es:bp -> user table *)
                Reg.BP := Ofs(FarADDRESS(fontdata));
                Reg.CX := 256; (* count of patterns to store *)
                Reg.DX := 0;   (* character offset into map 2 block *)
                Reg.BL := 0;   (* block to load in map 2 *)
                Reg.BH := BYTE(bytesPerChar);  (* number of bytes per character pattern : here 16 for VGA 80x25 *)
                Lib.Intr(Reg,videoBIOS);
            END;
        END;
        WrStr(shortcut);
        WrStr(fontname); WrLn;
    | loadinternal: (* we'll use an internal 80x25 font here, squashed if required *)
        IF resetMode(force25,force50,S)=FALSE THEN abort(errSetMode,S);END;
        IF modeAlreadySet(25) THEN
            bytesPerChar:=16;
        ELSIF modeAlreadySet(50) THEN
            bytesPerChar:=8;
            squash(forcesquash,internalSmallFont,method,fontdata);
        ELSE
            abort(errBadLineCount,"");
        END;

        Reg.AX := 1100H;
        Reg.ES := Seg(FarADDRESS(fontdata)); (* es:bp -> user table *)
        Reg.BP := Ofs(FarADDRESS(fontdata));
        Reg.CX := 256; (* count of patterns to store *)
        Reg.DX := 0;   (* character offset into map 2 block *)
        Reg.BL := 0;   (* block to load in map 2 *)
        Reg.BH := BYTE(bytesPerChar);  (* number of bytes per character pattern : here 16 for VGA 80x25 *)
        Lib.Intr(Reg,videoBIOS);

        IF verbose THEN
            WrLn;
            WrStr(fontname); WrStr(" definition loaded !");WrLn;
        END;
    | showcharset:
        IF isMonoMode() THEN abort(errObsolete,"");END; (* yuck ! *)
        IF dumpToScreen(R)=FALSE THEN abort(errUnexpected,R);END;
    END;
    abort(errNone,"");
END NewFont.

