(* ---------------------------------------------------------------
Title         Q&D Display Data Channel infos
Author        PhG
Overview      self-explanatory !
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
              really ugly code...
              any Vindoze may force wrong results : real-mode DOS advised !
Bugs
Wish List     specify output file instead of default ? bah...

--------------------------------------------------------------- *)

MODULE DDC;

IMPORT Lib;
IMPORT Str;
IMPORT IO;
IMPORT FIO;
IMPORT SYSTEM;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM IO IMPORT WrStr, WrLn;

(* ------------------------------------------------------------ *)

CONST
    extEXE  = ".EXE";
    extDDC  = ".DDC";
    dquote  = '"';
CONST
    progEXEname   = "DDC";
    progTitle     = "Q&D Display Data Channel infos";
    progVersion   = "v1.0c";
    progCopyright = "by PhG";
    banner        = progTitle+" "+progVersion+" "+progCopyright;

CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errParameterOverflow = 3;
    errNoDDC        = 4;
    errQueryDDC     = 5;
    errConflict     = 6;
    errNotFound     = 7;
    errBadSize      = 8;
    errSyntaxList   = 9;

    rcDDChere       = 128;
    rcDDChereNoEDID = 192;
    rcDDCnotHere    = 255;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    cr = CHR(13);
    lf = CHR(10);
    nl = cr+lf;
(*
    00000000011111111112222222222333333333344444444445555555555666666666677777777778
    1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msgHelp =
    banner+nl+
    nl+
    "Syntax 1 : "+progEXEname+" <-show|-view>"+nl+
    "Syntax 2 : "+progEXEname+" <-dump|-write>"+nl+
    "Syntax 3 : "+progEXEname+" <-test|-check>"+nl+
    "Syntax 4 : "+progEXEname+" <file> [-list]"+nl+
    nl+
    "This program displays monitor DDC data (syntax 1),"+nl+
    "saves monitor DDC data to "+progEXEname+extDDC+" file (syntax 2),"+nl+
    "tests DDC support (syntax 3), or list data from a saved file (syntax 4)."+nl+
    nl+
    "a) Note most accurate results require running from real-mode DOS."+nl+
    "b) With syntax 3, program returns an error code :"+nl+
    "    - 128 (DDC and EDID supported) ;"+nl+
    "    - 192 (DDC supported but not EDID) ;"+nl+
    "    - 255 (DDC not supported)."+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msgHelp);
    | errOption :
        Str.Concat(S,"Unknown ",einfo); Str.Append(S," option !");
    | errParameterOverflow :
        Str.Concat(S,"Useless ",einfo); Str.Append(S," parameter !");
    | errNoDDC:
        S:="VESA VBE Display Data Channel not supported !";
    | errQueryDDC:
        S:="VESA VBE Display Data Channel READ EDID function failed !";
    | errConflict:
        S:="-show, -dump, -test and -list options are mutually exclusive !";
    | errNotFound:
        Str.Concat(S,einfo," does not exist !");
    | errBadSize:
        Str.Concat(S,einfo," does not have expected size !");
    | errSyntaxList:
        S:="-list option requires <file> parameter !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp : ;
    | rcDDChere,rcDDCnotHere,rcDDChereNoEDID: ;
    ELSE
        WrStr(progEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* ripped from QD_Box *)

PROCEDURE chkVindoze ( VAR win9x, winxp : BOOLEAN );
CONST
    Win9xMajor        = 7;
    WinXPconsoleMajor = 5;
    WinXPconsoleMinor = 50;
VAR
    major,minor:CARDINAL;
BEGIN
    win9x:=FALSE;
    winxp:=FALSE;
    w9XgetTrueDOSversion (major,minor);
    CASE major OF
    | Win9xMajor :
         win9x := TRUE; (* 95 or 98 *)
    | WinXPconsoleMajor :
         winxp := (minor = WinXPconsoleMinor); (* risky business ! *)
    END;
END chkVindoze;

(* ------------------------------------------------------------ *)

PROCEDURE padhex (v : LONGCARD; digits : CARDINAL): str16;
CONST
    padStr = "0000000000000000"; (* 16 digits *)
VAR
    S : str16;
    R : str16;
    ok : BOOLEAN;
    len,delta : CARDINAL;
BEGIN
    digits := digits MOD 16; (* better safe than sorry! *)
    Str.CardToStr (v,S,16,ok);
    len := Str.Length(S);
    IF len > digits THEN digits := len; END;
    delta := digits - len;
    Str.Slice (R,padStr,0,delta);
    Str.Append (R,S);
    RETURN R;
END padhex;

PROCEDURE paddec (v : LONGCARD; digits : CARDINAL ) : str16;
CONST
    padStr = "                "; (* 16 digits *)
VAR
    S : str16;
    R : str16;
    ok : BOOLEAN;
    len,delta : CARDINAL;
BEGIN
    digits := digits MOD 16; (* better safe than sorry! *)
    Str.CardToStr (v,S,10,ok);

    IF digits=0 THEN RETURN S; END;

    len := Str.Length(S);
    IF len > digits THEN digits := len; END;
    delta := digits - len;
    Str.Slice (R,padStr,0,delta);
    Str.Append (R,S);
    RETURN R;
END paddec;

PROCEDURE cardAND(a,b : CARDINAL) : CARDINAL;
BEGIN
    RETURN CARDINAL(BITSET(a) * BITSET(b));
END cardAND;

PROCEDURE testbit(Target, BitNum : CARDINAL) : BOOLEAN;
BEGIN
    RETURN ( (BitNum MOD 16) IN BITSET(Target) );
END testbit;

(* ------------------------------------------------------------ *)

TYPE
    arrayofpads       = ARRAY [0..7] OF SHORTCARD;
    arrayoftimings    = ARRAY [1..8] OF CARDINAL;
    arrayofinfos      = ARRAY [1..4],[0..17] OF SHORTCARD;

    (* DDCEDIDbufferType = ARRAY [0..127] OF BYTE; (* 128 bytes *) *)
    DDCEDIDbufferType = RECORD
        padding       : arrayofpads; (* all $FF, or $00 $FF..$FF $00 *)
        manufacturer  : CARDINAL; (* big endian *)
        monitormodel  : CARDINAL;
        serialnumber  : LONGCARD; (* may be $FFFFFFFF *)
        builtweek     : SHORTCARD;
        builtyear     : SHORTCARD; (* add 1990 *)
        version       : SHORTCARD; (* EDID *)
        revision      : SHORTCARD; (* EDID *)
        videoinputtype: SHORTCARD;
        horizmaxsize  : SHORTCARD; (* cm *)
        vertmaxsize   : SHORTCARD; (* cm *)
        gammafactor   : SHORTCARD; (* gamma = 1+factor/100 *)
        DPMSflags     : SHORTCARD;
        chrominfoGR   : SHORTCARD;
        chrominfoWB   : SHORTCARD;
        chrominfoRy   : SHORTCARD;
        chrominfoRx   : SHORTCARD;
        chrominfoGy   : SHORTCARD;
        chrominfoGx   : SHORTCARD;
        chrominfoBy   : SHORTCARD;
        chrominfoBx   : SHORTCARD;
        chrominfoWy   : SHORTCARD;
        chrominfoWx   : SHORTCARD;
        timings1      : SHORTCARD;
        timings2      : SHORTCARD;
        reservedtiming: SHORTCARD; (* $00=none, bit 7=Macintoy *)
        stdtiming     : arrayoftimings;
        moreinfo      : arrayofinfos;
        unused        : SHORTCARD;
        checksum      : SHORTCARD; (* 256-low byte of 16-bit sum of 00h-7Eh *)
    END;

(* ------------------------------------------------------------ *)

PROCEDURE dmppadding (S:ARRAY OF CHAR;b : ARRAY OF SHORTCARD);
VAR
    i : CARDINAL;
    R : str16;
BEGIN
    WrStr(S);
    FOR i := 0 TO 7 DO
        WrStr(" ");
        R := padhex( LONGCARD(b[i]),2);
        WrStr(R);
    END;
    WrLn;
END dmppadding;

PROCEDURE dmpmanufacturer (S:ARRAY OF CHAR;idcode:CARDINAL);
CONST
    k          = ORD("A")-1;
    allidcodes =
    "AOC|AOC International (USA) Ltd.|"+
    "API|Acer|"+
    "APP|Apple Computer, Inc.|"+
    "AST|AST Research|"+
    "CPL|ALFA|"+
    "CPQ|COMPAQ|"+
    "CTX|CTX - Chuntex Electronic|"+
    "DEC|Digital Equipment Corporation|"+
    "DEL|Dell Computer Corp.|"+
    "DPC|Delta Electronics, Inc.|"+
    "DWE|Daewoo|"+
    "ECS|ELITEGROUP Computer Systems|"+
    "EIZ|EIZO|"+
    "GSM|LG Electronics Inc.|"+
    "HEI|Hyundai Electronics Industries Co., Ltd.|"+
    "HIT|Hitachi|"+
    "HSL|Hansol Electronics|"+
    "HTC|Hitachi Ltd.|"+
    "HWP|Hewlett Packard|"+
    "IBM|IBM PC Company|"+
    "ICL|Fujitsu ICL|"+
    "IVM|Idek Iiyama North America, Inc.|"+
    "LKM|AZALEA|"+
    "LNK|LINK Technologies, Inc.|"+
    "MAG|MAG Technology Co., Ltd.|"+
    "MAX|Maxdata Computer GmbH|"+
    "MEI|Panasonic Comm. & Systems Co.|"+
    "MEL|Mitsubishi Electronics|"+
    "MIR|miro Computer Products AG|"+
    "MTC|MITAC|"+
    "NAN|NANAO|"+
    "NEC|NEC Technologies, Inc.|"+
    "NOK|Nokia|"+
    "OQI|OPTIQUEST|"+
    "PGS|Princeton Graphic Systems|"+
    "PHL|Philips Consumer Electronics Co.|"+
    "REL|Relisys|"+
    "SAM|Samsung|"+
    "SDI|Samtron|"+
    "SNI|Siemens Nixdorf|"+
    "SNY|Sony Corporation|"+
    "TAT|Tatung Co. of America, Inc.|"+
    "TRL|Royal Information Company|"+
    "UNM|Unisys Corporation|"+
    "VSC|ViewSonic Corporation|"+
    "___|Targa";
VAR
    id : str16;
    v  : CARDINAL;
    R  : str128;
BEGIN
    WrStr(S);
    (* reverse lo and hi *)
    v := ((idcode AND 0FF00H) >>  8) + ((idcode AND 000FFH) << 8);
    idcode := v;

    v := (idcode AND 07C00H) >> 10;  (* 0111110000000000 *)
    Str.Copy  (id,CHR(k+v));
    v := (idcode AND 003E0H) >>  5;  (* 0000001111100000 *)
    Str.Append(id,CHR(k+v));
    v := (idcode AND 0001FH)       ; (* 0000000000011111 *)
    Str.Append(id,CHR(k+v));

    v := getStrIndex("|",id,allidcodes);
    IF v = 0 THEN
        R := "unknown !!!";
    ELSE
        isoleItemS(R,allidcodes,"|",v);
    END;

    WrStr(R);
    WrLn;
END dmpmanufacturer;

PROCEDURE dmpval (S:ARRAY OF CHAR;v:LONGCARD;digits:CARDINAL);
VAR
    R : str16;
BEGIN
    WrStr(S);
    R := padhex(v,digits);
    WrStr(R);
    WrLn;
END dmpval;

PROCEDURE dmpvaldec (S:ARRAY OF CHAR;v:SHORTCARD;digits:CARDINAL);
VAR
    R : str16;
BEGIN
    WrStr(S);
    R := paddec(LONGCARD(v),digits );
    WrStr(R);
    WrLn;
END dmpvaldec;

PROCEDURE dmpvaldecLC (S:ARRAY OF CHAR;v:LONGCARD;digits:CARDINAL);
VAR
    R : str16;
BEGIN
    WrStr(S);
    R := paddec(v,digits);
    WrStr(R);
    WrLn;
END dmpvaldecLC;

PROCEDURE dmpvideotype (S:ARRAY OF CHAR;f:SHORTCARD);
VAR
    flags,i : CARDINAL;
    R       : str128;
BEGIN
    WrStr(S);

    Str.Copy(R,"");
    FOR i:=1 TO Str.Length(S)-2 DO
        Str.Append(R," ");
    END;
    Str.Append(R,": ");

    flags := CARDINAL(f);

    IF testbit(flags,7) THEN
        WrStr("digital signal");
    ELSE
        WrStr("analog signal");
    END;
    WrLn;
    IF testbit(flags,2) THEN WrStr(R);WrStr("sync on screen");WrLn;END;
    IF testbit(flags,1) THEN WrStr(R);WrStr("composite sync");WrLn;END;
    IF testbit(flags,0) THEN WrStr(R);WrStr("separate sync");WrLn;END;
    WrStr(R);
    IF testbit(flags,6) THEN
        IF testbit(flags,5) THEN
            WrStr("reserved voltage level");
        ELSE
            WrStr("0.100V/0.400V");
        END;
    ELSE
        IF testbit(flags,5) THEN
            WrStr("0.714V/0.286V");
        ELSE
            WrStr("0.700V/0.300V (1.00 Vp-p)");
        END;
    END;
    WrLn;
END dmpvideotype;

PROCEDURE dmpgamma (S:ARRAY OF CHAR;factor:SHORTCARD   );
VAR
    gamma : CARDINAL;
    R     : str16;
BEGIN
    WrStr(S);
    gamma := 100+ CARDINAL(factor); (* 1.0+factor/100 so max is 3.55 *)
    R := paddec ( LONGCARD(gamma),3);
    Str.Insert(R,".",1);
    WrStr(R);
    WrLn;
END dmpgamma;

PROCEDURE dmpdpmsflags (S:ARRAY OF CHAR;f:SHORTCARD);
VAR
    flags,i : CARDINAL;
    R       : str128;
BEGIN
    WrStr(S);

    Str.Copy(R,"");
    FOR i:=1 TO Str.Length(S)-2 DO
        Str.Append(R," ");
    END;
    Str.Append(R,": ");

    flags := CARDINAL(f);

    IF testbit(flags,3) THEN
        WrStr("RGB color display");
    ELSE
        WrStr("non-RGB multicolor display");
    END;
    WrLn;
    IF testbit(flags,5) THEN WrStr(R);WrStr("active off supported");WrLn;END;
    IF testbit(flags,6) THEN WrStr(R);WrStr("suspend supported");WrLn;END;
    IF testbit(flags,7) THEN WrStr(R);WrStr("standby supported");WrLn;END;
END dmpdpmsflags;

PROCEDURE dmpit (msg,header:ARRAY OF CHAR;VAR counter:CARDINAL);
BEGIN
    IF counter > 0 THEN WrStr(header); END;
    WrStr(msg);
    WrLn;
    INC(counter);
END dmpit;

PROCEDURE dmptimings (S:ARRAY OF CHAR;f:SHORTCARD;number:CARDINAL);
VAR
    flags,i,j:CARDINAL;
    R : str128;
BEGIN
    WrStr(S);

    Str.Copy(R,"");
    FOR i:=1 TO Str.Length(S)-2 DO
        Str.Append(R," ");
    END;
    Str.Append(R,": ");

    flags := CARDINAL(f);
    j     := 0;

    CASE number OF
    | 0:
        IF flags=0 THEN
            WrStr("none");
        ELSE
            IF testbit(flags,7) THEN
                WrStr("1152x870 @ 75 Hz (Mac II, Apple)");
            ELSE
                WrStr("unexpected !!!");
            END;
        END;
        WrLn;
    | 1:
        IF testbit(flags,0) THEN dmpit("720x400 @ 70 Hz (VGA 640x400, IBM)",R,j);END;
        IF testbit(flags,1) THEN dmpit("720x400 @ 88 Hz (XGA2)",R,j);END;
        IF testbit(flags,2) THEN dmpit("640x480 @ 60 Hz (VGA)",R,j);END;
        IF testbit(flags,3) THEN dmpit("640x480 @ 67 Hz (Mac II, Apple)",R,j);END;
        IF testbit(flags,4) THEN dmpit("640x480 @ 72 Hz (VESA)",R,j);END;
        IF testbit(flags,5) THEN dmpit("640x480 @ 75 Hz (VESA)",R,j);END;
        IF testbit(flags,6) THEN dmpit("800x600 @ 56 Hz (VESA)",R,j);END;
        IF testbit(flags,7) THEN dmpit("800x600 @ 60 Hz (VESA)",R,j);END;
    | 2:
        IF testbit(flags,0) THEN dmpit("800x600 @ 72 Hz (VESA)",R,j);END;
        IF testbit(flags,1) THEN dmpit("800x600 @ 75 Hz (VESA)",R,j);END;
        IF testbit(flags,2) THEN dmpit("832x624 @ 75 Hz (Mac II)",R,j);END;
        IF testbit(flags,3) THEN dmpit("1024x768 @ 87 Hz interlaced (8514A)",R,j);END;
        IF testbit(flags,4) THEN dmpit("1024x768 @ 60 Hz (VESA)",R,j);END;
        IF testbit(flags,5) THEN dmpit("1024x768 @ 70 Hz (VESA)",R,j);END;
        IF testbit(flags,6) THEN dmpit("1024x768 @ 75 Hz (VESA)",R,j);END;
        IF testbit(flags,7) THEN dmpit("1280x1024 @ 75 Hz (VESA)",R,j);END;
    END;
END dmptimings;

PROCEDURE dmpstdtimings (S:ARRAY OF CHAR;value:arrayoftimings);
VAR
    i,resolution,frequency,j,xres,yres,verticalrefresh,aspectratio:CARDINAL;
    R,msg:str128;
    sx,sy,sf,sXY:str16;
    k:REAL;
BEGIN
    WrStr(S);

    Str.Copy(R,"");
    FOR i:=1 TO Str.Length(S)-2 DO
        Str.Append(R," ");
    END;
    Str.Append(R,": ");

    j:=0;
    FOR i := 1 TO 8 DO
        IF ( (value[i]=00000H) OR (value[i]=00101H) ) THEN
            (* dmpit("no standard timing",R,j); *)
        ELSE
            resolution      := (value[i] AND 000FFH);
            frequency       := (value[i] AND 0FF00H) >> 8;
            xres            := ( resolution + 31 ) * 8;
            sx              := paddec(LONGCARD(xres),0);

            verticalrefresh := (frequency AND 03FH) + 60; (* Hz *)
            sf              := paddec(LONGCARD(verticalrefresh),0);

            aspectratio     := (frequency AND 0C0H) >> 6;
            CASE aspectratio OF
            | 0: sXY:="undefined !!!"; k:=0.0;
            | 1: sXY:="0.75";          k:=0.75;
            | 2: sXY:="0.8";           k:=0.8;
            | 3: sXY:="0.5625";        k:=0.5625;
            END;
            yres:=CARDINAL( REAL(xres) * k);
            sy              := paddec(LONGCARD(yres),0);

            Str.Concat(msg, sx,"x");
            Str.Append(msg, sy);
            Str.Append(msg, " (ratio ");
            Str.Append(msg, sXY);
            Str.Append(msg,") @ ");
            Str.Append(msg,sf);
            Str.Append(msg," Hz");
            dmpit(msg,R,j);
        END;
    END;
END dmpstdtimings;

PROCEDURE dmpcs (S:ARRAY OF CHAR;b:DDCEDIDbufferType);
VAR
    R:str16;
    i,sum:CARDINAL;
    databuffer : ARRAY [0..127] OF SHORTCARD;
BEGIN
    WrStr(S);
    R := padhex( LONGCARD( b.checksum ),2);
    Str.Prepend(R,"$");
    Str.Lows(R);
    WrStr(R);

    Lib.Move(ADR(b),ADR(databuffer),SIZE(b));
    sum:=0;
    FOR i := 00H TO 07EH DO
        INC(sum, CARDINAL(databuffer[i]) );
    END;

    sum:=256-(sum AND 000FFH);
    IF sum = CARDINAL(b.checksum) THEN
        WrStr(" -- OK");
    ELSE
        WrStr(" -- MISMATCH !!!");
    END;

    WrLn;
END dmpcs;

(* ------------------------------------------------------------ *)

PROCEDURE dmpinf (S1:ARRAY OF CHAR;v:SHORTCARD;S2:ARRAY OF CHAR);
VAR
    R : str16;
    S : str128;
BEGIN
    R := paddec(LONGCARD(v), 0 );
    Str.Concat(S,R," ");
    Str.Append(S,S2);
    WrStr(S1);WrStr(S);WrLn;
END dmpinf;

PROCEDURE dmpmoreinfo (STEXT,SINFO:ARRAY OF CHAR;inf:arrayofinfos;holder:CHAR );
CONST
    four = 5; (* //V10C fix ;-) "should pi value change..." etc. *)
VAR
    i,p,sum,j:CARDINAL;
    R,R2:str128;
    smin,smax:str16;
    ndxchar:CHAR;
BEGIN

    Str.Copy(R,"");
    FOR i:=1 TO Str.Length(STEXT)-2 DO
        Str.Append(R," ");
    END;
    Str.Append(R,": ");

    FOR i := 1 TO 4 DO
        ndxchar:=CHR( ORD("0")+i);
        sum  := CARDINAL (inf[i][0]);
        INC(sum,CARDINAL (inf[i][1]) );
        INC(sum,CARDINAL (inf[i][2]) );
        IF sum = 0 THEN
            Str.Copy(R2,STEXT);
            Str.Subst(R2,holder,ndxchar);
            WrStr(R2);
            CASE inf[i][3] OF
            | 0FDH: R2:="";
            | 0FFH: R2:="serial number";
            | 0FEH: R2:="vendor name";
            | 0FCH: R2:="model name";
            END;
            IF inf[i][3] = 0FDH THEN
                j:=0;
                smin:=paddec(LONGCARD(inf[i][5]),0);
                smax:=paddec(LONGCARD(inf[i][6]),0);
                Str.Concat(R2,smin,"..");
                Str.Append(R2,smax);
                Str.Append(R2," (vertical refresh frequency in Hz)");
                dmpit(R2,R,j);

                smin:=paddec(LONGCARD(inf[i][7]),0);
                smax:=paddec(LONGCARD(inf[i][8]),0);
                Str.Concat(R2,smin,"..");
                Str.Append(R2,smax);
                Str.Append(R2," (horizontal frequency in kHz)");
                dmpit(R2,R,j);
            ELSE
                WrStr(R2);
                R2:=dquote;
                p:=four;
                LOOP
                    CASE inf[i][p] OF
                    | 00H,0AH: EXIT;
                    ELSE
                        Str.Append(R2,CHR(inf[i][p]) );
                    END;
                    INC(p);
                    IF p >= (four+14) THEN EXIT; END;
                END;
                RtrimBlanks(R2);
                WrStr(" is ");
                Str.Append(R2,dquote);
                WrStr(R2);
                WrLn;
            END;
        ELSE
            Str.Copy(R2,SINFO);
            Str.Subst(R2,holder,ndxchar);
            dmpinf(R2   ,inf[i][0] ,"hor. freq. in kHz");
            dmpinf(R    ,inf[i][1] ,"vert. freq. in Hz");
            dmpinf(R    ,inf[i][2] ,"hor. active time in pixels and X res.");
            dmpinf(R    ,inf[i][3] ,"hor. blanking time in pixels");
            dmpinf(R    ,inf[i][4] ,"hor. active time 2 / hor. blanking time 2");
            dmpinf(R    ,inf[i][5] ,"vert. active time in lines and Y res.");
            dmpinf(R    ,inf[i][6] ,"vert. blanking time in lines");
            dmpinf(R    ,inf[i][7] ,"vert. active time 2 / vert. blanking time 2");
            dmpinf(R    ,inf[i][8] ,"hor. sync offset in pixels");
            dmpinf(R    ,inf[i][9] ,"hor. sync pulsewidth in pixels");
            dmpinf(R    ,inf[i][10],"v. sync offset / v. sync pulsewidth");
            dmpinf(R    ,inf[i][11],"v./h. sync offset 2 / v./h. sync pulsewidth 2");
            dmpinf(R    ,inf[i][12],"hor. image size in mm");
            dmpinf(R    ,inf[i][13],"vert. image size in mm");
            dmpinf(R    ,inf[i][14],"hor. image size 2 / vert. image size 2");
            dmpinf(R    ,inf[i][15],"hor. border in pixels");
            dmpinf(R    ,inf[i][16],"vert. border in lines");

            dmpinf(R    ,inf[i][17],"type of display");

        END;
    END;
END dmpmoreinfo;

(* ------------------------------------------------------------ *)

PROCEDURE dumpEDIDinfos (b:DDCEDIDbufferType);
BEGIN
    WrStr("DDC monitor data");WrLn;
    WrLn;
    (* dmppadding      ("Padding bytes              :" ,b.padding); *)
    dmpmanufacturer ("Manufacturer               : ",b.manufacturer);
    dmpval          ("Monitor model              : ",LONGCARD(b.monitormodel),8);
    dmpval          ("Serial number              : ",b.serialnumber,8);
    dmpvaldec       ("Week manufactured          : ",b.builtweek,0);
    dmpvaldecLC     ("Year manufactured          : ",LONGCARD(b.builtyear)+1990,0);
    dmpvaldec       ("EDID version               : ",b.version,0);
    dmpvaldec       ("EDID revision              : ",b.revision,0);
    dmpvideotype    ("DPMS input signal          : ",b.videoinputtype);
    dmpvaldec       ("Maximum hor. size (cm)     : ",b.horizmaxsize,0);
    dmpvaldec       ("Maximum vert. size (cm)    : ",b.vertmaxsize,0);
    dmpgamma        ("Gamma                      : ",b.gammafactor);
    dmpdpmsflags    ("DPMS EDID flags            : ",b.DPMSflags);
    dmpvaldec       ("green X'/Y' and red X'/Y'  : ",b.chrominfoGR,0);
    dmpvaldec       ("white X'/Y' and blue X'/Y' : ",b.chrominfoWB,0);
    dmpvaldec       ("red Y                      : ",b.chrominfoRy,0);
    dmpvaldec       ("red X                      : ",b.chrominfoRx,0);
    dmpvaldec       ("green Y                    : ",b.chrominfoGy,0);
    dmpvaldec       ("green X                    : ",b.chrominfoGx,0);
    dmpvaldec       ("blue Y                     : ",b.chrominfoBy,0);
    dmpvaldec       ("blue X                     : ",b.chrominfoBx,0);
    dmpvaldec       ("white Y                    : ",b.chrominfoWy,0);
    dmpvaldec       ("white X                    : ",b.chrominfoWx,0);
    dmptimings      ("DPMS established timings 1 : ",b.timings1,1);
    dmptimings      ("DPMS established timings 2 : ",b.timings2,2);
    dmptimings      ("Reserved timing            : ",b.reservedtiming,0);
    dmpstdtimings   ("DPMS standard timings      : ",b.stdtiming);
    dmpmoreinfo     ("EDID text informations #$  : ",
                     "Detailed timing data #$    : ",b.moreinfo,"$");
    dmpcs           ("Checksum                   : ",b);
END dumpEDIDinfos;

(* ------------------------------------------------------------ *)

CONST
    iv = 010H; (* video interrupt is $10 *)

PROCEDURE checkDDC (  ):BOOLEAN ;
VAR
    R : SYSTEM.Registers;
BEGIN
    (* INT 10 - VESA VBE/DC (Display Data Channel) - INSTALLATION CHECK / CAPABILITIES *)
    R.AX := 04F15H;
    R.BL :=   000H;
    Lib.Intr(R,iv);
    IF R.AL = 04FH THEN
        RETURN (R.AH = 00H); (* safety : if 01H, function failed *)
    ELSE
        RETURN FALSE; (* function NOT supported *)
    END;
END checkDDC;

PROCEDURE queryDDC (VAR buffer : DDCEDIDbufferType):BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    (* INT 10 - VESA VBE/DC (Display Data Channel) - READ EDID *)
    R.AX := 04F15H;
    R.BL :=   001H;
    R.CX := 00000H;
    R.DX := 00000H;
    R.ES := Seg(buffer);
    R.DI := Ofs(buffer);
    Lib.Intr(R,iv);
    IF R.AL = 04FH THEN
        RETURN (R.AH = 00H); (* safety : if 01H, function failed *)
    ELSE
        RETURN FALSE; (* function NOT supported *)
    END;
END queryDDC;

PROCEDURE strippath (VAR S : ARRAY OF CHAR);
VAR
    u,d,n,e:str128;
BEGIN
    Lib.SplitAllPath(S,u,d,n,e);
    Lib.MakeAllPath(S,"","",n,e);
END strippath;

TYPE
    cmdtype = SET OF (showdata,showwrite,checksupport,listcontent);

PROCEDURE onlyone (current,wantedalone:cmdtype ):BOOLEAN;
BEGIN
    RETURN ( current = wantedalone );
END onlyone;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

VAR
    EDIDbuffer : DDCEDIDbufferType;
VAR
    parmcount,i,opt : CARDINAL;
    S,R,datafile    : str128;
    rc              : CARDINAL;
    hnd             : FIO.File;
    state           : (waiting,gotparm);
    cmd             : cmdtype;
    is9X,isXP       : BOOLEAN;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck:=FALSE;
    WrLn;

    cmd       := cmdtype{};

    state     := waiting;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "D"+delim+"DUMP"+delim+"W"+delim+"WRITE"+delim+
                                  "T"+delim+"TEST"+delim+"C"+delim+"CHECK"+delim+
                                  "S"+delim+"SHOW"+delim+"V"+delim+"VIEW"+delim+
                                  "L"+delim+"LIST");
            CASE opt OF
            | 1,2,3 :       abort(errHelp,"");
            | 4,5,6,7:      INCL(cmd,showwrite);
            | 8,9,10,11:    INCL(cmd,checksupport);
            | 12,13,14,15 : INCL(cmd,showdata);
            | 16,17  :      INCL(cmd,listcontent);
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            CASE state OF
            | waiting:
                INCL(cmd,listcontent);
                Str.Copy(datafile,R);
            ELSE
                abort(errParameterOverflow,S);
            END;
            INC(state);
        END;
    END;

    (* ------------------------------------------------------------ *)

    chkVindoze(is9X,isXP);
    IF is9X THEN
        S:="::: Please note results may not be accurate from Windows 9X !";
    ELSIF isXP THEN
        S:="::: Please note results may not be accurate from Windows XP !";
    ELSE
        S:="";
    END;
    IF same(S,"") = FALSE THEN
        WrStr(S);WrLn;
        WrLn;
    END;

    (* ------------------------------------------------------------ *)

    CASE state OF
    | gotparm :
        IF onlyone(cmd,cmdtype{}) THEN INCL(cmd,listcontent);END;
        IF onlyone(cmd,cmdtype{listcontent})=FALSE THEN abort(errConflict,""); END;
        IF FIO.Exists(datafile)=FALSE THEN abort(errNotFound,datafile);END;
        IF getFileSize(datafile) <> SIZE(EDIDbuffer) THEN
            abort(errBadSize,datafile);
        END;
        hnd:=FIO.OpenRead(datafile);
        i:=FIO.RdBin(hnd,EDIDbuffer,SIZE(EDIDbuffer) );
        FIO.Close(hnd);

        dumpEDIDinfos(EDIDbuffer);

        abort(errNone,"");
    ELSE
        IF onlyone(cmd,cmdtype{}) THEN abort(errSyntaxList,"");END;
        IF ( listcontent IN cmd ) THEN abort(errConflict,"");END;
    END;

    (* ------------------------------------------------------------ *)

    IF (checksupport IN cmd) THEN
        IF cmd # cmdtype{checksupport} THEN abort(errConflict,"");END;
        IF checkDDC() THEN
            IF queryDDC(EDIDbuffer) THEN
                S:="+++ Monitor is DDC-compliant with EDID support.";
                rc:=rcDDChere;
            ELSE
                S:="-+- Monitor seems DDC-compliant but without EDID support.";
                rc:=rcDDChereNoEDID;
            END;
        ELSE
            S:="--- Monitor does not seem DDC-compliant.";
            rc:=rcDDCnotHere;
        END;
        WrStr(S);WrLn;
        abort(rc,"");
    END;

    (* ------------------------------------------------------------ *)

    (* -show or -write *)

    IF onlyone(cmd,cmdtype{showdata}) THEN
        ;
    ELSIF onlyone (cmd,cmdtype{showwrite}) THEN
        ;
    ELSE
        abort(errConflict,"");
    END;


    IF checkDDC()=FALSE THEN abort(errNoDDC,"");END;
    IF queryDDC(EDIDbuffer)=FALSE THEN abort(errQueryDDC,"");END;

    dumpEDIDinfos(EDIDbuffer);

    IF (showwrite IN cmd) THEN
        Lib.ParamStr(S,0);
        Str.Subst(S,extEXE,extDDC);
        strippath(S);
        hnd:=FIO.Create(S);
        FIO.WrBin(hnd,EDIDbuffer,SIZE(EDIDbuffer) );
        FIO.Close(hnd);

        WrLn;
        WrStr(S);WrStr(" contains DDC infos !");WrLn;
    END;

    abort(errNone,"");
END DDC.





(*

Format of Detailed Timing Description:
 11h	BYTE	type of display (see #00134)


Bitfields for EDID detailed display type:
Bit(s)	Description	(Table 00134)
 7	interlaced
 6-5	stereo mode
	00 normal display (no stereo)
	01 stereo, right stereo sync high
	10 stereo, left stereo sync high
	11 undefined
 4-3	sync type
	00 sync analog composite
	01 sync bipolar analog composite
	10 sync digital composite
	11 sync digital separate
---sync digital separate---
 2	vertical sync polarity (0 = negative, 1 = positive)
 1	horizontal sync polarity (0 = negative, 1 = positive)
---other sync types---
 2	serrate
 1	sync location (0 = on green, 1 = on RGB)
------
 0	not used???	

*)

