(* ---------------------------------------------------------------
Title         Q&D file FIO helper library
Author        PhG
Overview
Notes

Bugs          fileIsDirectorySpec() assumes a spec without any joker :
              for now, if given "*." pattern,
              it returns true if there are both dirs and files without extension

              Yet Another TopSpeed one (sounds too familiar) :
              FIO.Exists() won't find existing file(s) if spec has joker !
              ergo, we've added fileExistsAlt()
Wish List

--------------------------------------------------------------- *)

IMPLEMENTATION MODULE QD_File;

IMPORT SYSTEM;
IMPORT Lib;
IMPORT Str;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

(* ------------------------------------------------------------ *)

PROCEDURE fileOpenRead (useLFN:BOOLEAN;S:pathtype):FIO.File;
VAR
    shortform:pathtype; (* eh eh, str128 *)
    rc:CARDINAL;
    h:FIO.File;
BEGIN
    IF useLFN THEN
        IF w9XlongToShort(S,rc,shortform) THEN
            Str.Copy(S,shortform);
        END;
    END;
    FIO.EOF := FALSE; (* damn topspeed who did not thought of an individual variable ! *)
    h:=FIO.OpenRead(S);
    RETURN h;
END fileOpenRead;

PROCEDURE fileOpen (useLFN:BOOLEAN;S:pathtype):FIO.File;
VAR
    shortform:pathtype; (* eh eh, str128 *)
    rc:CARDINAL;
    h:FIO.File;
BEGIN
    IF useLFN THEN
        IF w9XlongToShort(S,rc,shortform) THEN
            Str.Copy(S,shortform);
        END;
    END;
    FIO.EOF := FALSE; (* damn topspeed who did not thought of an individual variable ! *)
    h:=FIO.Open(S);
    RETURN h;
END fileOpen;

PROCEDURE w9Xexists (S:pathtype):BOOLEAN;
VAR
    found:BOOLEAN;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    w9Xhandle,errcode:CARDINAL;
    rc : BOOLEAN;
BEGIN
    found := w9XfindFirst (S,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                           unicodeconversion,w9Xentry,w9Xhandle,errcode);
    rc:=w9XfindClose(w9Xhandle,errcode);
    RETURN found;
END w9Xexists;

PROCEDURE fileExists (useLFN:BOOLEAN;S:pathtype):BOOLEAN;
BEGIN
    IF useLFN THEN
        RETURN w9Xexists(S);
    ELSE
        RETURN FIO.Exists(S);
    END;
END fileExists;

(* this one handles jokers from plain jane DOS *)

PROCEDURE fileExistsAlt (useLFN:BOOLEAN;S:pathtype):BOOLEAN;
VAR
    rc:BOOLEAN;
    entry:FIO.DirEntry;
BEGIN
    IF useLFN THEN
        rc:= w9Xexists(S);
    ELSE
        rc:=                 ( Str.CharPos(S,"*") # MAX(CARDINAL) );
        IF NOT(rc) THEN rc:= ( Str.CharPos(S,"?") # MAX(CARDINAL) ); END;
        IF rc THEN (* spec has a joker *)
            rc:= FIO.ReadFirstEntry(S,allfiles,entry); (* files only *)
        ELSE
            rc:= FIO.Exists(S);
        END;
    END;
    RETURN rc;
END fileExistsAlt;

PROCEDURE fileIsRO (useLFN:BOOLEAN;S:pathtype  ):BOOLEAN;
VAR
    shortform:pathtype;
    rc : CARDINAL;
BEGIN
    IF useLFN THEN
        IF w9XlongToShort(S,rc,shortform) THEN
            Str.Copy(S,shortform);
        END;
    END;
    RETURN isReadOnly(S);
END fileIsRO;

PROCEDURE fileSetRW (useLFN:BOOLEAN;S:pathtype);
VAR
    shortform:pathtype;
    rc : CARDINAL;
BEGIN
    IF useLFN THEN
        IF w9XlongToShort(S,rc,shortform) THEN
            Str.Copy(S,shortform);
        END;
    END;
    setReadWrite(S);
END fileSetRW;

PROCEDURE fileSetRO (useLFN:BOOLEAN;S:pathtype);
VAR
    shortform:pathtype;
    rc : CARDINAL;
BEGIN
    IF useLFN THEN
        IF w9XlongToShort(S,rc,shortform) THEN
            Str.Copy(S,shortform);
        END;
    END;
    setReadOnly(S);
END fileSetRO;

PROCEDURE fileErase (useLFN:BOOLEAN;S:pathtype );
VAR
    shortform:pathtype;
    rc : CARDINAL;
BEGIN
    IF useLFN THEN
        IF w9XlongToShort(S,rc,shortform) THEN
            Str.Copy(S,shortform);
        END;
    END;
    FIO.Erase(S);
END fileErase;

(* ugly hack *)

PROCEDURE fileCreate (useLFN:BOOLEAN;S:pathtype):FIO.File;
VAR
    hnd:FIO.File; (* a CARDINAL in fact *)
    shortform : pathtype;
    (* lfn,u,d,n,e:pathtype; *)
    ok:BOOLEAN;
    handle,rc:CARDINAL;
BEGIN
    IF useLFN THEN

        (*
        IF FIO.Exists(dummyDOSname) THEN
            IF isReadOnly(dummyDOSname) THEN setReadWrite(dummyDOSname);END;
        END;
        hnd:=FIO.Create(dummyDOSname);
        FIO.Close(hnd);

        Lib.SplitAllPath(S, u,d,n,e); (* fortunately, it handles internal spaces and long names *)
        Lib.MakeAllPath(lfn,"","",n,e);
        Str.Copy(n,dummyDOSname);
        ok:=w9Xrename (n,lfn,rc);
        hnd:=fileOpen(useLFN,lfn);
        *)

        ok:=w9XopenFile(TRUE,S, handle,rc);
        w9XcloseFile(handle);

        IF w9XlongToShort(S,rc,shortform) THEN
            Str.Copy(S,shortform);
        END;
        hnd:=FIO.Open(S);
    ELSE
        hnd:=FIO.Create(S);
    END;
    RETURN hnd;
END fileCreate;

(* assume everything went fine *)

PROCEDURE fileRename (useLFN:BOOLEAN;oldname,newname:pathtype);
VAR
    ok:BOOLEAN;
    rc:CARDINAL;
BEGIN
    IF useLFN THEN
        ok:= w9Xrename (oldname,newname,  rc);
    ELSE
        FIO.Rename(oldname,newname);
    END;
END fileRename;

PROCEDURE fileGetFileSize (useLFN:BOOLEAN;S:pathtype):LONGCARD;
VAR
    h:FIO.File;
    fsize:LONGCARD;
BEGIN
    h:= fileOpenRead (useLFN,S);
    fsize:=FIO.Size(h);
    FIO.Close(h);
    RETURN fsize;
END fileGetFileSize;

PROCEDURE fileGetFileStamp (useLFN:BOOLEAN;S:pathtype):LONGCARD;
VAR
    h:FIO.File;
    stamp:LONGCARD;
BEGIN
    h:= fileOpenRead (useLFN,S);
    stamp:=FIO.GetFileDate(h); (* packed DOS format *)
    FIO.Close(h);
    RETURN stamp;
END fileGetFileStamp;

PROCEDURE w9XisDirectory (S : pathtype) : BOOLEAN;
CONST
    colon     = ":";
    backslash = "\";
VAR
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    w9Xhandle,errcode:CARDINAL;
    found,rc : BOOLEAN;
    dosattr:FIO.FileAttr;
BEGIN
    unfixDirectory(S);
    CASE Str.Length(S) OF
    | 2 : (* avoid "u:" alone ! *)
        IF S[1]=colon THEN RETURN TRUE; END; (* always but we do not check for its real life *)
    | 3 : (* avoid "u:\" alone ! *)
        IF S[1]=colon THEN
            IF S[2]=backslash THEN RETURN TRUE; END; (* always but we do not check for its real life *)
        END;
    END;
    found := w9XfindFirst (S,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                          unicodeconversion,w9Xentry,w9Xhandle,errcode);
    rc:=w9XfindClose(w9Xhandle,errcode);
    IF found = FALSE THEN RETURN FALSE; END;
    dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
    RETURN (aD IN dosattr);
END w9XisDirectory;

(* assume u: is already checked for existence *)

PROCEDURE fileIsDirectorySpec ( useLFN:BOOLEAN;dirspec:pathtype):BOOLEAN;
BEGIN
    IF useLFN THEN
        RETURN w9XisDirectory(dirspec);
    ELSE
        RETURN isDirectory(dirspec);
    END;
END fileIsDirectorySpec;

PROCEDURE fileClose (useLFN:BOOLEAN;hnd:FIO.File);
BEGIN
    IF useLFN THEN
        FIO.Close(hnd); (* seems to work fine *)
    ELSE
        FIO.Close(hnd);
    END;
END fileClose;

(* avoid importing qd_lfn for this mere function *)

PROCEDURE fileSupportLFN (  ):BOOLEAN;
BEGIN
    RETURN w9XsupportLFN();
END fileSupportLFN;

(* ------------------------------------------------------------ *)

BEGIN

END QD_File.
