(* ---------------------------------------------------------------
Title         Q&D Matrix
Overview      animate text screen the Matrix way
Notes         assume VGA and page 0
              132x43 does not like font redefinition : matrox or vesa ?
Bugs
Wish List     just kidding...
              a better scrolling ? other scrollings than falling ? bah...
              save/restore original font data (for now, we just reinit ROM set)
              allow individual character enabled/disabled state
              allow external font ?

--------------------------------------------------------------- *)

MODULE Matrix;

IMPORT IO;
IMPORT SYSTEM;
IMPORT Lib;
IMPORT Str;
IMPORT MsMouse;
IMPORT BiosIO;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs,
completedInit, completedShow, completedSHOW, completedEnd, completed;

FROM QD_rand IMPORT InitRnd, GetRnd,
GetRndCardRange, GetRndLngCardRange,
GetRndLngRealRange, GetRndRealRange;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE waitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END waitVGAretrace;

PROCEDURE pause (n:CARDINAL);
VAR
    i:CARDINAL;
BEGIN
    FOR i := 1 TO n DO
        waitVGAretrace();
    END;
END pause;

(* ------------------------------------------------------------ *)

VAR
    bioscols  [00040H:004AH] : CARDINAL;
    biosrows  [00040H:0084H] : SHORTCARD; (* add 1 *)

CONST
    minCol    = 1;
    maxCol    = 132;
    minRow    = 1;
    maxRow    = 60;
    firstcell = 0;
    maxcell   = (maxCol * maxRow) -1;
TYPE
    vcell = RECORD
        ch   : CHAR;
        attr : SHORTCARD;
    END;
TYPE
    scrtype = ARRAY [firstcell..maxcell] OF vcell;
VAR
    Ybase     : ARRAY [minRow..maxRow] OF CARDINAL;
    vidscr [0B800H:0000H] : scrtype; (* hard-coded : monochrome is dead ! *)
    savscr                : scrtype;
    wrkscr                : scrtype;

PROCEDURE initYbase (lastrow,lastcol:CARDINAL);
VAR
    i,p:CARDINAL;
BEGIN
    p := 0;
    FOR i := minRow TO lastrow DO
        Ybase[i]:=p;
        INC(p,lastcol);
    END;
END initYbase;

PROCEDURE plot (x,y:CARDINAL;ch:CHAR;attr:SHORTCARD);
VAR
    p : CARDINAL;
BEGIN
    p := Ybase[y]+x-minCol;    (* remember first column is 1, not 0 *)
    wrkscr[p].ch   := ch;
    wrkscr[p].attr := attr;
END plot;

PROCEDURE plotch (x,y:CARDINAL;ch:CHAR);
VAR
    p : CARDINAL;
BEGIN
    p := Ybase[y]+x-minCol;    (* remember first column is 1, not 0 *)
    wrkscr[p].ch   := ch;
END plotch;

PROCEDURE radar (x,y:CARDINAL):CHAR;
VAR
    p : CARDINAL;
BEGIN
    p := Ybase[y]+x-minCol;    (* remember first column is 1, not 0 *)
    RETURN wrkscr[p].ch;
END radar;

PROCEDURE vradar (x,y:CARDINAL):vcell;
VAR
    p : CARDINAL;
BEGIN
    p := Ybase[y]+x-minCol;    (* remember first column is 1, not 0 *)
    RETURN wrkscr[p];
END vradar;

(* force far here ! *)
(* avoid  alternate "screentype:=screentype" form because of dynamic size *)

PROCEDURE vid2sav (lastcell:CARDINAL);
BEGIN
    Lib.FarWordMove(FarADR(vidscr),FarADR(savscr),lastcell); (* each cell is a WORD *)
END vid2sav;

PROCEDURE sav2vid (lastcell:CARDINAL);
BEGIN
    Lib.FarWordMove(FarADR(savscr),FarADR(vidscr),lastcell); (* each cell is a WORD *)
END sav2vid;

PROCEDURE sav2vidATTR (lastcell:CARDINAL);
VAR
    i:CARDINAL;
BEGIN
    FOR i := firstcell TO lastcell DO
        vidscr[i].attr := vidscr[i].attr OR ((savscr[i].attr AND 0FH));
    END;
END sav2vidATTR;

PROCEDURE wrk2vid (lastcell:CARDINAL);
BEGIN
    Lib.FarWordMove(FarADR(wrkscr),FarADR(vidscr),lastcell); (* each cell is a WORD *)
END wrk2vid;

PROCEDURE plotstring (x,y:CARDINAL;attr:SHORTCARD;len:CARDINAL; S:ARRAY OF CHAR);
VAR
    i,p : CARDINAL;
BEGIN
    p := Ybase[y]+x-minCol;    (* remember first column is 1, not 0 *)
    FOR i:=1 TO len DO
        vidscr[p].ch   := S[i-1];
        vidscr[p].attr := attr;
        INC(p);
    END;
END plotstring;

(* ------------------------------------------------------------ *)

TYPE
    inktype = (black,blue,green,cyan,red,magenta,brown,white,
               gray,bblue,bgreen,bcyan,bred,bmagenta,yellow,bwhite);
CONST
    mincolor = ORD(black);
    maxcolor = ORD(bwhite);
    darker   = ORD(white)-ORD(black)+1;
    brightest= ORD(bwhite);
CONST
    minspeed = 0;
    maxspeed = 32-1;
    minink   = ORD(gray);
    maxink   = ORD(bwhite);
    minpaper = ORD(black);
    maxpaper = ORD(white);
    minproba        =   0; (* was 1 *)
    maxproba        = 100;
    minchar         = 0;
    maxchar         = 255;
    minvelocity     = 1;
    maxvelocity     = 8;
CONST
    defaultspeed=1;
    defaultink=ORD(bgreen);
    defaultpaper=ORD(black);
    defseuilbirth   =  90;
    defseuiltwinkle =  20; (* was 99 *)
    defseuileraser  =  80;
    defseuilink     =  50;
    deflowerchar    =  minchar;
    defupperchar    =  maxchar-1; (* avoid 255 looking like space ! *)
    defuppervelocity=  4;

(* ------------------------------------------------------------ *)

PROCEDURE paperink (color:inktype) : SHORTCARD;
BEGIN
    RETURN SHORTCARD(ORD(color));
END paperink;

TYPE
    cleartype = (normal);

(* cls handles wrk2vid *)

PROCEDURE cls (char : CHAR; paper,ink : CARDINAL; clear : cleartype;
               lastcell,lastrow,lastcol,delay : CARDINAL);
VAR
    x,y : CARDINAL;
    attribute : SHORTCARD;
BEGIN
    attribute := paperink(inktype(paper)) << 4 OR SHORTCARD(inktype(ink));
    CASE clear OF
    | normal :
        FOR y := minRow TO lastrow DO
            FOR x := minCol TO lastcol DO
                plot(x,y,char,attribute);
            END;
        END;
    END;
    wrk2vid(lastcell);
END cls;

CONST
    blank    = " ";
    eraser   = ORD(blank);

PROCEDURE genchar (lower,upper:CARDINAL; avoid:CHAR):CHAR;
VAR
    i,code:CARDINAL;
BEGIN
    i:=0;
    LOOP
        code:=GetRndCardRange(lower,upper);
        IF code # eraser THEN
            IF CHAR(code) # avoid THEN EXIT; END;
        END;
        INC(i);
        IF i =MAX(CARDINAL) THEN code:=eraser+1;EXIT; END;
    END;
    RETURN CHAR(code);
END genchar;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    defaultFmtFR  = "$dd !d $mm $yyyy  0hh 0mmn 0ss";
    defaultFmtUS  = "$dd, $mm $d, $yyyy at 0h:0m:0s";
TYPE
    languagetype = (french,english);

PROCEDURE substring (S1,S2:ARRAY OF CHAR) : BOOLEAN;
BEGIN
    Str.Caps(S2);
    IF Str.Pos(S1,S2) # MAX(CARDINAL) THEN RETURN TRUE; END;
    Str.Lows(S2);
    IF Str.Pos(S1,S2) # MAX(CARDINAL) THEN RETURN TRUE; END;
    RETURN FALSE;
END substring;

PROCEDURE newstring (VAR R:ARRAY OF CHAR; old,new:ARRAY OF CHAR);
BEGIN
    Str.Caps(old);
    IF Str.Pos(R,old) # MAX(CARDINAL) THEN
        Str.Subst(R,old,new);
    ELSE
        Str.Lows(old);
        IF Str.Pos(R,old) = MAX(CARDINAL) THEN RETURN; END;
        Str.Subst(R,old,new);
    END;
END newstring;

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str80;
VAR
    ok   : BOOLEAN;
    v    : LONGCARD;
    len  : CARDINAL;
    S    : str80;
BEGIN
    v := LONGCARD(n);
    Str.CardToStr(v,S,10,ok);
    IF pad="" THEN RETURN S; END;
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    RETURN S;
END using;

TYPE
    datetype = RECORD
        day   : CARDINAL;
        month : CARDINAL;
        year  : CARDINAL;
        dayOfWeek  : Lib.DayType;
    END;
    timetype = RECORD
        hours   : CARDINAL;
        minutes : CARDINAL;
        seconds : CARDINAL;
    END;

PROCEDURE getDateNow (VAR d : datetype);
VAR
    dayOfWeek : Lib.DayType;
BEGIN
    Lib.GetDate(d.year,d.month,d.day,d.dayOfWeek);
END getDateNow;

PROCEDURE getTimeNow (VAR t : timetype);
VAR
    hundredth : CARDINAL;
BEGIN
    Lib.GetTime(t.hours,t.minutes,t.seconds,hundredth);
END getTimeNow;

CONST
    jours = "dimanche lundi mardi mercredi jeudi vendredi samedi";
    mois  = "janvier fvrier mars avril mai juin "+
            "juillet aot septembre octobre novembre dcembre";
    joursUS = "Sunday Monday Tuesday Wednesday Thursday Friday Saturday";
    moisUS  = "January February March April May June "+
              "July August September October November December";

(* ------------------------------------------------------------ *)

PROCEDURE oldnew (sOld,sNew:ARRAY OF CHAR;VAR R:ARRAY OF CHAR);
BEGIN
    LOOP
        IF substring(R,sOld)=FALSE THEN EXIT;END;
        newstring(R,sOld,sNew);
    END;
END oldnew;

(*
    $dd     lundi..dimanche / monday..sunday
    $d      1..31 (ordinal)
    $0d     01..31
    $mm     janvier..dcembre / january..december
    $m      1..12
    $0m     01..12

    $yyyy   ####
    $yy     00..99

    !d      1er..31 (cardinal)
    !0d     1er..31

    h      0..23
    0h     00..23
    m      0..59
    0m     00..59
    s      0..59
    0s     00..59
*)

PROCEDURE formatNowFormat (format:ARRAY OF CHAR;language:languagetype;
                           VAR ss:CARDINAL; VAR R : ARRAY OF CHAR  );
VAR
    dmy : datetype;
    hms : timetype;
    S,T    : str16;
    pad    : CHAR;
    v      : CARDINAL;
BEGIN
    Str.Copy(R,format);
    getDateNow(dmy);

    v := ORD(dmy.dayOfWeek);
    CASE language OF
    | french:   Str.ItemS(T,jours," ",v);
    | english:  Str.ItemS(T,joursUS," ",v);
    END;
    oldnew("$dd",T,R);

    v:=dmy.day;
    pad := "";   oldnew("$d",    using(v,2,pad), R);
    pad := "0";  oldnew("$0d",   using(v,2,pad), R);

    IF v=1 THEN
    pad := "";   oldnew("!d",    "1er"         , R);
    pad := "0";  oldnew("!0d",   "1er"         , R);
    ELSE
    pad := "";   oldnew("!d",    using(v,2,pad), R);
    pad := "0";  oldnew("!0d",   using(v,2,pad), R);
    END;

    v := dmy.month-1;
    CASE language OF
    | french:   Str.ItemS(T,mois," ",v);
    | english:  Str.ItemS(T,moisUS," ",v);
    END;
    oldnew("$mm",T,R);

    v := dmy.month;
    pad := "";  oldnew("$m",    using(v,2,pad), R);
    pad := "0"; oldnew("$0m",   using(v,2,pad), R);

    v := dmy.year;
    pad := "";  oldnew("$yyyy", using(v,4,pad), R);
    pad := "0";
    IF v >= 1900 THEN (* always here *)
        v  := dmy.year - 1900;IF v > 100 THEN DEC(v,100);END;
    END;
                oldnew("$yy",   using(v,2,pad), R);

    getTimeNow(hms); (* let's hope we don't cross midnight ! ;-) maybe we should reread date ! *)

    v := hms.hours;
    pad := "";   oldnew("h",    using(v,2,pad), R);
    pad := "0";  oldnew("0h",   using(v,2,pad), R);

    v := hms.minutes;
    pad := "";   oldnew("m",    using(v,2,pad), R);
    pad := "0";  oldnew("0m",   using(v,2,pad), R);

    v := hms.seconds;
    pad := "";   oldnew("s",    using(v,2,pad), R);
    pad := "0";  oldnew("0s",   using(v,2,pad), R);

    ss := v;

END formatNowFormat;

CONST
    minshowmefor = 1; (* 0 would be a frenzy ! *)
    maxshowmefor = 30;
    defaultshowmefor=10;
    initoldseconds=MAX(CARDINAL);
CONST
    reservedBase = 205;
    reservedSet  = "0123456789:abcdefghijklmnopqrstuvwxyz,-'.";
VAR                             (* q&d globerks for ease of programming *)
    format:str128;
    language:languagetype;
    showhtab,showvtab,showmefor,showoldseconds:CARDINAL;

(* assume [1.. *)

PROCEDURE calcpos (mini,maxi,len:CARDINAL;centered:BOOLEAN):CARDINAL;
VAR
    wi,v:CARDINAL;
BEGIN
    wi:=maxi-mini+1;
    IF wi > len THEN
        IF centered THEN
            v:=( (wi-len) DIV 2 ) + mini;
        ELSE
            v:=GetRndCardRange(mini,wi-len);
        END;
    ELSE
        v:=mini;
    END;
    (* IF v=0 THEN HALT;END; (* test with minshowmefor=0 *) *)
    RETURN v;
END calcpos;

PROCEDURE showInfoString (myfont,wideframe,centered:BOOLEAN;
                         lastcol,lastrow:CARDINAL;attr:SHORTCARD );
VAR
    S,S0 : str128;
    he,i,p,len,currseconds:CARDINAL;
    delta:INTEGER;
    ch:CHAR;
    pad:str16;
BEGIN
    formatNowFormat(format,language,currseconds,S);
    IF wideframe THEN
        pad:=blank+blank;
        he :=2+1+2;
    ELSE
        pad:=blank;
        he :=1+1+1;
    END;
    Str.Prepend(S,pad);Str.Append(S,pad);
    len:=Str.Length(S);
    IF myfont THEN
        FOR i:=1 TO len DO
            ch:=S[i-1];
            p:=Str.CharPos( reservedSet, ch );
            IF p # MAX(CARDINAL) THEN
                S[i-1]:=CHR (reservedBase+p);
            ELSE
                LowerCase(ch);
                p:=Str.CharPos( reservedSet, ch );
                IF p # MAX(CARDINAL) THEN
                    S[i-1]:=CHR (reservedBase+p);
                END;
            END;
        END;
    END;
    Str.Copy(S0,S);
    FOR i:=1 TO len DO
        S0[i-1]:=blank;
    END;
    IF showoldseconds=initoldseconds THEN
        delta:=INTEGER(showmefor+1);
    ELSE
        delta:=INTEGER(currseconds)-INTEGER(showoldseconds);
        IF delta < 0 THEN INC(delta,60);END;
    END;
    IF delta >= INTEGER(showmefor) THEN
        showhtab:=calcpos(minCol,lastcol,len,centered);
        showvtab:=calcpos(minRow,lastrow,he,centered);
        showoldseconds:=currseconds;
    END;
    IF wideframe THEN
        plotstring (showhtab,showvtab+0, attr, len,S0);
        plotstring (showhtab,showvtab+1, attr, len,S0);
        plotstring (showhtab,showvtab+2, attr, len,S);
        plotstring (showhtab,showvtab+3, attr, len,S0);
        plotstring (showhtab,showvtab+4, attr, len,S0);
    ELSE
        plotstring (showhtab,showvtab+0, attr, len,S0);
        plotstring (showhtab,showvtab+1, attr, len,S);
        plotstring (showhtab,showvtab+2, attr, len,S0);
    END;
END showInfoString;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    motiontype=(downwards,upwards,leftwards,rightwards);
    cmdtype  = (init,update,terminate);
    infotype= RECORD
        action : (waiting,filling,erasing);
        x,y:CARDINAL;
        ch:CHAR;
        ink:SHORTCARD;
        velocity:CARDINAL;
        currstep:CARDINAL;
        done:BOOLEAN;
    END;
VAR
    info : ARRAY [minCol..maxCol] OF infotype;

(* ------------------------------------------------------------ *)

PROCEDURE rainV (motion:motiontype;cmd:cmdtype;
                lastrow,lastcol,
                ink,inkfade,paper,speed,lastcell,
                seuilbirth,seuiltwinkle,seuileraser,seuilink,
                lower,upper,velocity:CARDINAL;
                scroll,showstring,wideframe,centered,myfont:BOOLEAN);
VAR
    i,x,y,changed,currstep,yy,oldy:CARDINAL;
    aink,afade,apaper,ahead,currink:SHORTCARD;
    ch:CHAR;
    mycell:vcell;
    beyond,within:BOOLEAN;
BEGIN
    apaper:=SHORTCARD(paper) << 4;
    aink:=SHORTCARD(ink) + apaper;
    afade:=SHORTCARD(inkfade) + apaper;
    ahead:=SHORTCARD(brightest) + apaper;
    CASE cmd OF
    | init:
        CASE motion OF
        | downwards: y:=minRow;
        | upwards:   y:=lastrow;
        END;
        FOR i:=minCol TO lastcol DO
            info[i].action:=waiting;
            info[i].x:=i;
            info[i].y:=y;
        END;
    | update:
        FOR i:=minCol TO lastcol DO
            x:=info[i].x;
            y:=info[i].y;
            CASE info[i].action OF
            | waiting:
                IF GetRndCardRange(minproba,maxproba) > seuilbirth THEN
                    IF GetRndCardRange(minproba,maxproba) > seuilink THEN
                        currink:=aink;
                    ELSE
                        currink:=afade;
                    END;
                    info[i].ink:=currink;
                    ch:=genchar( lower,upper,blank );
                    info[i].ch:=ch;
                    CASE motion OF
                    | downwards: y:=minRow;
                    | upwards:   y:=lastrow;
                    END;
                    info[i].y:=y;
                    plot (x,y,ch,ahead);
                    info[i].velocity:=GetRndCardRange(minvelocity,velocity);
                    info[i].currstep:=minvelocity;
                    info[i].action:=filling;
                ELSE
                    IF scroll THEN
                        currstep:=info[i].currstep;
                        INC(currstep);
                        IF currstep < info[i].velocity THEN
                            info[i].currstep:=currstep;
                            CASE motion OF
                            | downwards:
                                FOR yy:=lastrow-1 TO minRow BY -1 DO
                                    mycell:=vradar(x,yy);
                                    plot(x,yy+1,mycell.ch,mycell.attr);
                                END;
                                y:=minRow;
                            | upwards:
                                FOR yy:=minRow+1 TO lastrow DO
                                    mycell:=vradar(x,yy);
                                    plot(x,yy-1,mycell.ch,mycell.attr);
                                END;
                                y:=lastrow;
                            END;
                            ch:=genchar(lower,upper,blank );
                            plot(x,y,ch,mycell.attr);
                        ELSE
                            info[i].currstep:=minvelocity;
                        END;
                    END;
                END;
            | filling:
              currstep:=info[i].currstep;
              INC(currstep);
              IF currstep < info[i].velocity THEN
                info[i].currstep:=currstep;
              ELSE
                info[i].currstep:=minvelocity;
                ch:=info[i].ch;
                currink:=info[i].ink;
                plot(x,y,ch,currink); (* was aink *)

                IF scroll THEN
                    CASE motion OF
                    | downwards:
                        FOR yy:=lastrow-1 TO minRow BY -1 DO
                            mycell:=vradar(x,yy);
                            plot(x,yy+1,mycell.ch,mycell.attr);
                        END;
                        y:=minRow;
                    | upwards:
                        FOR yy:=minRow+1 TO lastrow DO
                            mycell:=vradar(x,yy);
                            plot(x,yy-1,mycell.ch,mycell.attr);
                        END;
                        y:=lastrow;
                    END;
                    ch:=genchar( lower,upper,blank );
                    plot(x,y,ch,currink);
                END;

                y:=info[i].y;
                CASE motion OF
                | downwards:
                    INC(y);
                    beyond:=( y > lastrow );
                    IF beyond THEN y:=minRow;END;
                | upwards:
                    DEC(y);
                    beyond:=( y < minRow );
                    IF beyond THEN y:=lastrow;END;
                END;

                IF beyond THEN
                    IF GetRndCardRange(minproba,maxproba) > seuileraser THEN
                        info[i].y:=y;
                        ch:=radar(x,y);
                        plot (x,y,ch,afade);
                        info[i].velocity:=GetRndCardRange(minvelocity,velocity);
                        info[i].currstep:=minvelocity;
                        info[i].action:=erasing;
                    ELSE
                        info[i].action:=waiting;
                    END;
                ELSE
                    ch:=genchar( lower,upper,blank );
                    info[i].y:=y;
                    info[i].ch:=ch;
                    plot (x,y,ch,ahead);
                END;
              END;
            | erasing:
              currstep:=info[i].currstep;
              INC(currstep);
              IF currstep < info[i].velocity THEN
                info[i].currstep:=currstep;
              ELSE
                info[i].currstep:=minvelocity;

                oldy:=y;
                CASE motion OF
                | downwards:
                    INC(y);
                    within:=( y <= lastrow );
                | upwards:
                    DEC(y);
                    within:=( y >= minRow );
                END;

                IF within THEN
                    info[i].y:=y;
                    ch:=radar(x,y);
                    plot (x,y,ch,afade);
                ELSE
                    info[i].action:=waiting;
                END;

                IF scroll THEN
                    CASE motion OF
                    | downwards:
                        FOR yy:=lastrow-1 TO minRow BY -1 DO
                            mycell:=vradar(x,yy);
                            plot(x,yy+1,mycell.ch,mycell.attr);
                        END;
                        y:=minRow;
                    | upwards:
                        FOR yy:=minRow+1 TO lastrow DO
                            mycell:=vradar(x,yy);
                            plot(x,yy-1,mycell.ch,mycell.attr);
                        END;
                        y:=lastrow;
                    END;
                    plot (x,y,blank,apaper);
                ELSE
                    plot (x,oldy,blank,apaper);
                END;

              END;
            END;

                (* twinkle *)

                IF GetRndCardRange(minproba,maxproba) > seuiltwinkle THEN
                    oldy:=info[i].y;
                    IF GetRndCardRange(0,1)=0 THEN
                        y:=GetRndCardRange(minRow,oldy-1);
                    ELSE
                        y:=GetRndCardRange(oldy+1,lastrow);
                    END;
                    ch:=radar(x,y);
                    IF ch # blank THEN
                        ch:=genchar( lower,upper,ch );
                        plotch (x,y,ch);
                    END;
                END;
        END;
        wrk2vid(lastcell);
        IF showstring THEN
            showInfoString(myfont,wideframe,centered,lastcol,lastrow,ahead); (* was aink *)
        END;
        pause(speed);

    | terminate:
      FOR i:=minCol TO lastcol DO
          info[i].done:=FALSE;
      END;
      LOOP
        FOR i:=minCol TO lastcol DO
            x:=info[i].x;
            y:=info[i].y;
            CASE info[i].action OF
            | waiting:
                    IF GetRndCardRange(minproba,maxproba) > seuilink THEN
                        currink:=aink;
                    ELSE
                        currink:=afade;
                    END;
                    info[i].ink:=currink;
                    ch:=genchar( lower,upper,blank );
                    info[i].ch:=ch;
                    CASE motion OF
                    | downwards: y:=minRow;
                    | upwards:   y:=lastrow;
                    END;
                    info[i].y:=y;
                    plot (x,y,ch,ahead);
                    info[i].velocity:=GetRndCardRange(minvelocity,velocity);
                    info[i].currstep:=minvelocity;
                    info[i].action:=filling;
            | filling:
              currstep:=info[i].currstep;
              INC(currstep);
              IF currstep < info[i].velocity THEN
                info[i].currstep:=currstep;
              ELSE
                info[i].currstep:=minvelocity;
                ch:=info[i].ch;
                currink:=info[i].ink;
                plot(x,y,ch,currink); (* was aink *)

                CASE motion OF
                | downwards:
                    INC(y);
                    beyond:=( y > lastrow );
                    IF beyond THEN y:=minRow; END;
                | upwards:
                    DEC(y);
                    beyond:=( y < minRow );
                    IF beyond THEN y:=lastrow; END;
                END;

                IF beyond THEN
                        info[i].y:=y;
                        ch:=radar(x,y);
                        plot (x,y,ch,afade);
                        info[i].velocity:=GetRndCardRange(minvelocity,velocity);
                        info[i].currstep:=minvelocity;
                        info[i].action:=erasing;
                ELSE

                    ch:=genchar( lower,upper,blank );
                    info[i].y:=y;
                    info[i].ch:=ch;
                    plot (x,y,ch,ahead);
                END;
              END;
            | erasing:
              currstep:=info[i].currstep;
              INC(currstep);
              IF currstep < info[i].velocity THEN
                info[i].currstep:=currstep;
              ELSE
                info[i].currstep:=minvelocity;

                oldy:=y;
                CASE motion OF
                | downwards:
                    INC(y);
                    within:=( y <= lastrow );
                | upwards:
                    DEC(y);
                    within:=( y >= minRow );
                END;

                IF within THEN
                    info[i].y:=y;
                    ch:=radar(x,y);
                    plot (x,y,ch,afade);
                ELSE
                    info[i].done:=TRUE;
                END;
                plot (x,oldy,blank,apaper);
              END;
            END;

                (* twinkle *)

                IF GetRndCardRange(minproba,maxproba) > seuiltwinkle THEN
                    oldy:=info[i].y;
                    IF GetRndCardRange(0,1)=0 THEN
                        y:=GetRndCardRange(minRow,oldy-1);
                    ELSE
                        y:=GetRndCardRange(oldy+1,lastrow);
                    END;
                    ch:=radar(x,y);
                    IF ch # blank THEN
                        ch:=genchar( lower,upper,ch );
                        plotch (x,y,ch);
                    END;
                END;
        END;
        wrk2vid(lastcell);
        pause(speed);
        changed:=0;
        FOR i:=minCol TO lastcol DO
            IF info[i].done THEN INC(changed);END;
        END;
        IF changed >= lastcol THEN EXIT; END;
      END;
    END;
END rainV;

(* ------------------------------------------------------------ *)

PROCEDURE rainH (motion:motiontype;cmd:cmdtype;
                lastrow,lastcol,
                ink,inkfade,paper,speed,lastcell,
                seuilbirth,seuiltwinkle,seuileraser,seuilink,
                lower,upper,velocity:CARDINAL;
                scroll,showstring,wideframe,centered,myfont:BOOLEAN);
VAR
    i,x,y,changed,currstep,xx,oldx:CARDINAL;
    aink,afade,apaper,ahead,currink:SHORTCARD;
    ch:CHAR;
    mycell:vcell;
    beyond,within:BOOLEAN;
BEGIN
    apaper:=SHORTCARD(paper) << 4;
    aink:=SHORTCARD(ink) + apaper;
    afade:=SHORTCARD(inkfade) + apaper;
    ahead:=SHORTCARD(brightest) + apaper;
    CASE cmd OF
    | init:
        CASE motion OF
        | leftwards: x:=minCol;
        | rightwards:   x:=lastcol;
        END;
        FOR i:=minRow TO lastrow DO
            info[i].action:=waiting;
            info[i].x:=x;
            info[i].y:=i;
        END;
    | update:
        FOR i:=minRow TO lastrow DO
            x:=info[i].x;
            y:=info[i].y;
            CASE info[i].action OF
            | waiting:
                IF GetRndCardRange(minproba,maxproba) > seuilbirth THEN
                    IF GetRndCardRange(minproba,maxproba) > seuilink THEN
                        currink:=aink;
                    ELSE
                        currink:=afade;
                    END;
                    info[i].ink:=currink;
                    ch:=genchar( lower,upper,blank );
                    info[i].ch:=ch;
                    CASE motion OF
                    | leftwards: x:=minCol;
                    | rightwards:   x:=lastcol;
                    END;
                    info[i].x:=x;
                    plot (x,y,ch,ahead);
                    info[i].velocity:=GetRndCardRange(minvelocity,velocity);
                    info[i].currstep:=minvelocity;
                    info[i].action:=filling;
                ELSE
                    IF scroll THEN
                        currstep:=info[i].currstep;
                        INC(currstep);
                        IF currstep < info[i].velocity THEN
                            info[i].currstep:=currstep;
                            CASE motion OF
                            | leftwards:
                                FOR xx:=lastcol-1 TO minCol BY -1 DO
                                    mycell:=vradar(xx,y);
                                    plot(xx+1,y,mycell.ch,mycell.attr);
                                END;
                                x:=minCol;
                            | rightwards:
                                FOR xx:=minCol+1 TO lastcol DO
                                    mycell:=vradar(xx,y);
                                    plot(xx-1,y,mycell.ch,mycell.attr);
                                END;
                                x:=lastcol;
                            END;
                            ch:=genchar(lower,upper,blank );
                            plot(x,y,ch,mycell.attr);
                        ELSE
                            info[i].currstep:=minvelocity;
                        END;
                    END;
                END;
            | filling:
              currstep:=info[i].currstep;
              INC(currstep);
              IF currstep < info[i].velocity THEN
                info[i].currstep:=currstep;
              ELSE
                info[i].currstep:=minvelocity;
                ch:=info[i].ch;
                currink:=info[i].ink;
                plot(x,y,ch,currink); (* was aink *)

                IF scroll THEN
                    CASE motion OF
                    | leftwards:
                        FOR xx:=lastcol-1 TO minCol BY -1 DO
                            mycell:=vradar(xx,y);
                            plot(xx+1,y,mycell.ch,mycell.attr);
                        END;
                        x:=minCol;
                    | rightwards:
                        FOR xx:=minCol+1 TO lastcol DO
                            mycell:=vradar(xx,y);
                            plot(xx-1,y,mycell.ch,mycell.attr);
                        END;
                        x:=lastcol;
                    END;
                    ch:=genchar( lower,upper,blank );
                    plot(x,y,ch,currink);
                END;

                x:=info[i].x;
                CASE motion OF
                | leftwards:
                    INC(x);
                    beyond:=( x > lastcol );
                    IF beyond THEN x:=minCol;END;
                | rightwards:
                    DEC(x);
                    beyond:=( x < minCol );
                    IF beyond THEN x:=lastcol;END;
                END;

                IF beyond THEN
                    IF GetRndCardRange(minproba,maxproba) > seuileraser THEN
                        info[i].x:=x;
                        ch:=radar(x,y);
                        plot (x,y,ch,afade);
                        info[i].velocity:=GetRndCardRange(minvelocity,velocity);
                        info[i].currstep:=minvelocity;
                        info[i].action:=erasing;
                    ELSE
                        info[i].action:=waiting;
                    END;
                ELSE
                    ch:=genchar( lower,upper,blank );
                    info[i].x:=x;
                    info[i].ch:=ch;
                    plot (x,y,ch,ahead);
                END;
              END;
            | erasing:
              currstep:=info[i].currstep;
              INC(currstep);
              IF currstep < info[i].velocity THEN
                info[i].currstep:=currstep;
              ELSE
                info[i].currstep:=minvelocity;

                oldx:=x;
                CASE motion OF
                | leftwards:
                    INC(x);
                    within:=( x <= lastcol );
                | rightwards:
                    DEC(x);
                    within:=( x >= minCol );
                END;

                IF within THEN
                    info[i].x:=x;
                    ch:=radar(x,y);
                    plot (x,y,ch,afade);
                ELSE
                    info[i].action:=waiting;
                END;

                IF scroll THEN
                    CASE motion OF
                    | leftwards:
                        FOR xx:=lastcol-1 TO minCol BY -1 DO
                            mycell:=vradar(xx,y);
                            plot(xx+1,y,mycell.ch,mycell.attr);
                        END;
                        x:=minCol;
                    | rightwards:
                        FOR xx:=minCol+1 TO lastcol DO
                            mycell:=vradar(xx,y);
                            plot(xx-1,y,mycell.ch,mycell.attr);
                        END;
                        x:=lastcol;
                    END;
                    plot (x,y,blank,apaper);
                ELSE
                    plot (oldx,y,blank,apaper);
                END;

              END;
            END;

                (* twinkle *)

                IF GetRndCardRange(minproba,maxproba) > seuiltwinkle THEN
                    oldx:=info[i].x;
                    IF GetRndCardRange(0,1)=0 THEN
                        x:=GetRndCardRange(minCol,oldx-1);
                    ELSE
                        x:=GetRndCardRange(oldx+1,lastcol);
                    END;
                    ch:=radar(x,y);
                    IF ch # blank THEN
                        ch:=genchar( lower,upper,ch );
                        plotch (x,y,ch);
                    END;
                END;
        END;
        wrk2vid(lastcell);
        IF showstring THEN
            showInfoString(myfont,wideframe,centered,lastcol,lastrow,ahead); (* was aink *)
        END;
        pause(speed);

    | terminate:
      FOR i:=minRow TO lastrow DO
          info[i].done:=FALSE;
      END;
      LOOP
        FOR i:=minRow TO lastrow DO
            x:=info[i].x;
            y:=info[i].y;
            CASE info[i].action OF
            | waiting:
                    IF GetRndCardRange(minproba,maxproba) > seuilink THEN
                        currink:=aink;
                    ELSE
                        currink:=afade;
                    END;
                    info[i].ink:=currink;
                    ch:=genchar( lower,upper,blank );
                    info[i].ch:=ch;
                    CASE motion OF
                    | leftwards: x:=minCol;
                    | rightwards:   x:=lastcol;
                    END;
                    info[i].x:=x;
                    plot (x,y,ch,ahead);
                    info[i].velocity:=GetRndCardRange(minvelocity,velocity);
                    info[i].currstep:=minvelocity;
                    info[i].action:=filling;
            | filling:
              currstep:=info[i].currstep;
              INC(currstep);
              IF currstep < info[i].velocity THEN
                info[i].currstep:=currstep;
              ELSE
                info[i].currstep:=minvelocity;
                ch:=info[i].ch;
                currink:=info[i].ink;
                plot(x,y,ch,currink); (* was aink *)

                CASE motion OF
                | leftwards:
                    INC(x);
                    beyond:=( x > lastcol );
                    IF beyond THEN x:=minCol; END;
                | rightwards:
                    DEC(x);
                    beyond:=( x < minCol );
                    IF beyond THEN x:=lastcol; END;
                END;

                IF beyond THEN
                        info[i].x:=x;
                        ch:=radar(x,y);
                        plot (x,y,ch,afade);
                        info[i].velocity:=GetRndCardRange(minvelocity,velocity);
                        info[i].currstep:=minvelocity;
                        info[i].action:=erasing;
                ELSE

                    ch:=genchar( lower,upper,blank );
                    info[i].x:=x;
                    info[i].ch:=ch;
                    plot (x,y,ch,ahead);
                END;
              END;
            | erasing:
              currstep:=info[i].currstep;
              INC(currstep);
              IF currstep < info[i].velocity THEN
                info[i].currstep:=currstep;
              ELSE
                info[i].currstep:=minvelocity;

                oldx:=x;
                CASE motion OF
                | leftwards:
                    INC(x);
                    within:=( x <= lastcol );
                | rightwards:
                    DEC(x);
                    within:=( x >= minCol );
                END;

                IF within THEN
                    info[i].x:=x;
                    ch:=radar(x,y);
                    plot (x,y,ch,afade);
                ELSE
                    info[i].done:=TRUE;
                END;
                plot (oldx,y,blank,apaper);
              END;
            END;

                (* twinkle *)

                IF GetRndCardRange(minproba,maxproba) > seuiltwinkle THEN
                    oldx:=info[i].x;
                    IF GetRndCardRange(0,1)=0 THEN
                        x:=GetRndCardRange(minCol,oldx-1);
                    ELSE
                        x:=GetRndCardRange(oldx+1,lastcol);
                    END;
                    ch:=radar(x,y);
                    IF ch # blank THEN
                        ch:=genchar( lower,upper,ch );
                        plotch (x,y,ch);
                    END;
                END;
        END;
        wrk2vid(lastcell);
        pause(speed);
        changed:=0;
        FOR i:=minRow TO lastrow DO
            IF info[i].done THEN INC(changed);END;
        END;
        IF changed >= lastrow THEN EXIT; END;
      END;
    END;
END rainH;

(* ------------------------------------------------------------ *)

(* all rain procedures handle wrk2vid *)

PROCEDURE rain (motion:motiontype;cmd:cmdtype;
                lastrow,lastcol,
                ink,inkfade,paper,speed,lastcell,
                seuilbirth,seuiltwinkle,seuileraser,seuilink,
                lower,upper,velocity:CARDINAL;
                scroll,showstring,wideframe,centered,myfont:BOOLEAN);
BEGIN
    CASE motion OF
    | downwards,upwards:
        rainV (motion,cmd,
                lastrow,lastcol,
                ink,inkfade,paper,speed,lastcell,
                seuilbirth,seuiltwinkle,seuileraser,seuilink,
                lower,upper,velocity,
                scroll,showstring,wideframe,centered,myfont);
    | leftwards,rightwards:
        rainH (motion,cmd,
                lastrow,lastcol,
                ink,inkfade,paper,speed,lastcell,
                seuilbirth,seuiltwinkle,seuileraser,seuilink,
                lower,upper,velocity,
                scroll,showstring,wideframe,centered,myfont);
    END;
END rain;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE msg2 (VAR R: ARRAY OF CHAR; S1,S2:ARRAY OF CHAR);
BEGIN
    Str.Concat(R,S1,S2);
END msg2;

PROCEDURE msg3 (VAR R: ARRAY OF CHAR; S1,S2,S3:ARRAY OF CHAR);
BEGIN
    Str.Concat(R,S1,S2);Str.Append(R,S3);
END msg3;

CONST
    ProgEXEname   = "MATRIX";
    ProgTitle     = "Q&D AniMatrix (over-rated Z-movie !)";
    ProgVersion   = "v1.1d";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errParameter    = 3;
    errNumber       = 4;
    errUnexpected   = 5;
    errEither25or50 = 6;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    nl = CHR(13)+CHR(10);
    helpmsg =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" [option]..."+nl+
nl+
"-m:#  motion type (0=downwards, 1=upwards, 2=leftwards, 3=rightwards)"+nl+
"-p:#  paper [0..7], default is 0"+nl+
"-i:#  ink [8..15], default is 10"+nl+
"-s:#  speed [0..31], default is 1"+nl+
"-m    exit on mouseclick too (default is on Escape or Return keys)"+nl+
"-b:#  threshold for trail creation [0..100], default is 90"+nl+
"-t:#  threshold for twinkling [0..100], default is 20"+nl+
"-e:#  threshold for eraser [0..100], default is 80"+nl+
"-c:#  threshold for normal trail color [0..100], default is 50"+nl+
"-v:#  upper velocity [1..8], default is 4"+nl+
"-s    scroll"+nl+
"-l:#  lower character [0..255], default is 48"+nl+
"-u:#  upper character [0..255], default is 49"+nl+
"-u    upper case characters [65..90]"+nl+
"-l    lower case characters [97..122]"+nl+
"-d    digits case characters [48..57]"+nl+
"-b    binary [48..49]"+nl+
"-a    ascii set [0..254], excluding (normally) invisible 255 code"+nl+
"-f[?] use private VGA font (mode must be 80x25, 80x50, 80x28 or 80x43)"+nl+
"      A=hebrew [0..26], B=runes [48..57], C=runes [65..90], D=kata [91..148],"+nl+
"      E=hebrew [151..177], F=dots [178..204]"+nl+
"-i[i] show info string (-ii = smaller blank border)"+nl+
"-w:#  info string same position persistence [1..30], default is 10 seconds"+nl+
"-c    center info string (default is random)"+nl+
'-f:$  format string "$[0]<d|m>", "$dd", "$mm", "$yy", "$yyyy", "[0]<h|m|s>"'+nl+
'      French default is "$dd !d $mm $yyyy  0hh 0mmn 0ss"'+nl+
'      English default is "$dd, $mm $d, $yyyy at 0h:0m:0s"'+nl+
"-us   English (default is French)"+nl+
"-r    reset cursor at program exit (probably useless and valid with -f option)"+nl+
"-k    do not fix cursor shape"+nl+
"-2    force 25 lines mode"+nl+
"-5    force 50 lines mode"+nl+
"-v    show current parameters at program exit"+nl+
nl+
"[Space]-single step, [Escape|Return]-exit to DOS, [+-]-charset, [S]-scroll"+nl+
"[PageUp|PageDown]-speed, [I]-info, [C]-centered, [W]-border, [arrows]-motion"+nl+
"Effect for the following (normal or shifted) keys will be progressive :"+nl+
"[F1]-ink, [F2]-paper, [F3]-trail normal color threshold, [F4]-upper velocity"+nl+
"[F5]-trail creation threshold, [F6]-twinkling threshold, [F7]-eraser threshold"+nl+
"[^R]-restore factory settings modified by function keys, including speed"+nl+
nl+
"Dark [0..7] : black, blue, green, cyan, red, magenta, brown and gray."+nl+
"Bright [8..15] : gray, blue, green, cyan, red, magenta, yellow and white.";

VAR
    S : str128;
BEGIN
    CASE e OF
    | errOption:
        msg3 (S,"Unknown ",einfo," option !");
    | errParameter:
        msg3 (S,"Uneeded ",einfo," parameter !");
    | errNumber:
        msg3 (S,"Illegal or out of range ",einfo," number !");
    | errUnexpected:
        msg3 (S,"Unexpected number of ",einfo," !");
    | errEither25or50:
        S := "-25 and -50 options are mutually exclusive !";
    ELSE
        S := "This is illogical, Captain !!!";
    END;
    CASE e OF
    | errNone:
        ;
    | errHelp:
        WrLn;
        WrStr(helpmsg);WrLn;
    ELSE
        WrLn;
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

PROCEDURE getCard (lower,upper:CARDINAL;S:ARRAY OF CHAR;VAR n : CARDINAL):BOOLEAN;
VAR
    v:LONGCARD;
BEGIN
    IF GetLongCard(S,v)=FALSE THEN RETURN FALSE;END;
    IF v > MAX(CARDINAL) THEN RETURN FALSE; END;
    n:=CARDINAL(v);
    IF n < lower THEN RETURN FALSE; END;
    IF n > upper THEN RETURN FALSE; END;
    RETURN TRUE;
END getCard;

PROCEDURE getfaded (ink,darker:CARDINAL   ):CARDINAL ;
BEGIN
    RETURN (ink-darker);
END getfaded;

PROCEDURE newvar (lower,upper:CARDINAL;decmode:BOOLEAN;VAR v:CARDINAL);
BEGIN
    IF decmode THEN
        IF v > lower THEN DEC(v);END;
    ELSE
        IF v < upper THEN INC(v);END;
    END;
END newvar;

(* ------------------------------------------------------------ *)

PROCEDURE dmp (S:ARRAY OF CHAR;v:CARDINAL);
BEGIN
    WrStr(S);IO.WrCard(v,-3);WrLn;
END dmp;

PROCEDURE dumpParms (motion:motiontype;
                ink,inkfade,paper,speed,
                seuilbirth,seuiltwinkle,seuileraser,seuilink,
                lower,upper,velocity,showmefor:CARDINAL;
                scroll,showtime,centered:BOOLEAN;
                language:languagetype;format:str128);
VAR
    S : str128;
BEGIN
    dmp("-m:",ORD(motion));
    dmp("-i:",ink);
    dmp("-p:",paper);
    dmp("-s:",speed);
    dmp("-b:",seuilbirth);
    dmp("-t:",seuiltwinkle);
    dmp("-e:",seuileraser);
    dmp("-c:",seuilink);
    dmp("-v:",velocity);
    IF scroll THEN WrStr("-s");WrLn;END;
    IF showtime THEN WrStr("-i");WrLn;END;
    dmp("-w:",showmefor);
    IF centered THEN WrStr("-c");WrLn;END;
    IF language=english THEN WrStr("-us");WrLn;END;
    IF same(format,"") THEN
        CASE language OF
        | french  : Str.Copy(S,defaultFmtFR);
        | english : Str.Copy(S,defaultFmtUS);
        END;
    ELSE
        Str.Copy(S,format);
    END;
    WrStr('-f:"');WrStr(S);WrStr('"');WrLn;
END dumpParms;

(* ------------------------------------------------------------ *)

CONST
    keyEscape  = 01B00H;
    keySpace   = 02000H;
    keyCR      = 00D00H;
    keyPlus    = ORD("+") << 8;
    keyMinus   = ORD("-") << 8;
    keyUpperS  = ORD("S") << 8;
    keyLowerS  = ORD("s") << 8;
    keyUpperI  = ORD("I") << 8;
    keyLowerI  = ORD("i") << 8;
    keyUpperC  = ORD("C") << 8;
    keyLowerC  = ORD("c") << 8;
    keyUpperW  = ORD("W") << 8;
    keyLowerW  = ORD("w") << 8;
    keyPgUp    = 00049H;
    keyPgDn    = 00051H;
    keyCtrlR   = 01200H;

    keyF1      = 0003BH;
    keyF2      = 0003CH;
    keyF3      = 0003DH;
    keyF4      = 0003EH;
    keyF5      = 0003FH;
    keyF6      = 00040H;
    keyF7      = 00041H;

    skeyF1      = 84;
    skeyF2      = 85;
    skeyF3      = 86;
    skeyF4      = 87;
    skeyF5      = 88;
    skeyF6      = 89;
    skeyF7      = 90;

    keyUp      = 0048H;
    keyDown    = 0050H;
    keyLeft    = 004DH;
    keyRight   = 004BH;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL;VAR shifted:BOOLEAN ):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;

    c2:=CHR(0); (* better safe than sorry here for our silly keycode format *)

    BiosWaitkeyShifted (c1,c2, shifted);

    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstdata        = 0;
    fontsize25       = 4096; (* 16 *)
    fontsize50       = 2048; (* 8 *)
VAR
    fontbuffer : ARRAY [0..fontsize25-1] OF BYTE; (* largest *)
TYPE
    FontDef25 = ARRAY [firstdata..fontsize25-1] OF BYTE;
    FontDef50 = ARRAY [firstdata..fontsize50-1] OF BYTE;
CONST
    (*
    savagely built from many fonts :

    000..026    hbreu
         032    espace (obligatoire !)
    048..057    chiffres runiques
    065..090    lettres runiques
    091..148    katakana
    151..177    hbreu
    178..204    dots
    205..254    apple ][ chars :
                "0123456789:abcdefghijklmnopqrstuvwxyz,-'."
    *)

    Font25 = FontDef25(
    000H,000H,000H,086H,0C6H,066H,036H,0D8H,
    0CCH,0C6H,0C2H,000H,000H,000H,000H,000H,
    000H,000H,000H,0FCH,0FCH,00CH,00CH,00CH,
    00CH,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,000H,000H,03CH,03CH,00CH,00CH,07CH,
    07CH,06CH,06CH,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,00CH,00CH,00CH,
    00CH,00CH,00CH,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,006H,006H,0C6H,
    0C6H,0C6H,0C6H,000H,000H,000H,000H,000H,
    000H,000H,000H,078H,078H,018H,018H,018H,
    018H,018H,018H,000H,000H,000H,000H,000H,
    000H,000H,000H,07EH,07EH,018H,018H,018H,
    018H,018H,018H,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,0C6H,0C6H,0C6H,
    0C6H,0C6H,0C6H,000H,000H,000H,000H,000H,
    000H,000H,000H,0DEH,0DEH,0D6H,0C6H,0C6H,
    0C6H,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,000H,000H,07CH,07CH,00CH,00CH,00CH,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,006H,006H,006H,
    006H,006H,006H,006H,006H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,006H,006H,006H,
    006H,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,0C0H,0C0H,0FEH,0FEH,006H,006H,00CH,
    018H,030H,030H,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,0C6H,0C6H,0C6H,
    0C6H,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,000H,000H,0DEH,0FEH,066H,0C6H,0C6H,
    0C6H,0DEH,0DEH,000H,000H,000H,000H,000H,
    000H,000H,000H,03CH,03CH,00CH,00CH,00CH,
    00CH,00CH,00CH,00CH,00CH,000H,000H,000H,
    000H,000H,000H,03CH,03CH,00CH,00CH,00CH,
    00CH,07CH,07CH,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,0C6H,0C6H,0C6H,
    0C6H,0FEH,07CH,000H,000H,000H,000H,000H,
    000H,000H,000H,066H,066H,066H,066H,066H,
    066H,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,0C6H,0E6H,0E6H,
    006H,006H,006H,006H,006H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,0C6H,0E6H,006H,
    006H,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,000H,000H,066H,066H,066H,06CH,078H,
    070H,060H,060H,060H,060H,000H,000H,000H,
    000H,000H,000H,0C6H,0C6H,066H,03CH,018H,
    00CH,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,006H,0C6H,0C6H,
    0CEH,0CEH,0C0H,0C0H,0C0H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,006H,006H,006H,
    006H,006H,006H,000H,000H,000H,000H,000H,
    000H,000H,000H,0D6H,0D6H,0D6H,0D6H,0D6H,
    0D6H,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,000H,000H,07EH,07EH,066H,066H,066H,
    066H,0E6H,0E6H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,07CH,0FEH,0FEH,0FEH,0FEH,0FEH,0FEH,
    0FEH,0FEH,0FEH,0FEH,07CH,000H,000H,000H,
    000H,018H,018H,018H,018H,018H,018H,018H,
    018H,018H,018H,018H,018H,000H,000H,000H,
    000H,066H,066H,066H,066H,066H,066H,066H,
    066H,066H,066H,066H,066H,000H,000H,000H,
    000H,0DBH,0DBH,0DBH,0DBH,0DBH,0DBH,0DBH,
    0DBH,0DBH,0DBH,0DBH,0DBH,000H,000H,000H,
    000H,0A5H,0A5H,0A5H,0A5H,0A5H,0A5H,0A5H,
    0A5H,0A5H,0A5H,0A5H,0A5H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,0FFH,
    0FFH,0FFH,0FFH,07EH,03CH,000H,000H,000H,
    000H,018H,018H,018H,018H,018H,018H,0FFH,
    0FFH,0FFH,0FFH,07EH,03CH,000H,000H,000H,
    000H,066H,066H,066H,066H,066H,066H,0FFH,
    0FFH,0FFH,0FFH,07EH,03CH,000H,000H,000H,
    000H,0DBH,0DBH,0DBH,0DBH,0DBH,0DBH,0FFH,
    0FFH,0FFH,0FFH,07EH,03CH,000H,000H,000H,
    000H,0A5H,0A5H,0A5H,0A5H,0A5H,0A5H,0FFH,
    0FFH,0FFH,0FFH,07EH,03CH,000H,000H,000H,
    000H,07CH,0FEH,0FEH,0FEH,0FEH,0FEH,0FEH,
    0FEH,0FEH,0FEH,0FEH,07CH,000H,000H,000H,
    000H,018H,018H,018H,018H,018H,018H,018H,
    018H,018H,018H,018H,018H,000H,000H,000H,
    000H,066H,066H,066H,066H,066H,066H,066H,
    066H,066H,066H,066H,066H,000H,000H,000H,
    000H,0DBH,0DBH,0DBH,0DBH,0DBH,0DBH,0DBH,
    0DBH,0DBH,0DBH,0DBH,0DBH,000H,000H,000H,
    000H,0A5H,0A5H,0A5H,0A5H,0A5H,0A5H,0A5H,
    0A5H,0A5H,0A5H,0A5H,0A5H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,0FFH,
    0FFH,0FFH,0FFH,07EH,03CH,000H,000H,000H,
    000H,018H,018H,018H,018H,018H,018H,0FFH,
    0FFH,0FFH,0FFH,07EH,03CH,000H,000H,000H,
    000H,066H,066H,066H,066H,066H,066H,0FFH,
    0FFH,0FFH,0FFH,07EH,03CH,000H,000H,000H,
    000H,0DBH,0DBH,0DBH,0DBH,0DBH,0DBH,0FFH,
    0FFH,0FFH,0FFH,07EH,03CH,000H,000H,000H,
    000H,0A5H,0A5H,0A5H,0A5H,0A5H,0A5H,0FFH,
    0FFH,0FFH,0FFH,07EH,03CH,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,0E0H,0F0H,0D8H,0CCH,0E6H,0F0H,0D8H,
    0CCH,0C0H,0C0H,0C0H,0C0H,000H,000H,000H,
    000H,0E0H,0F0H,0D8H,0CCH,0D8H,0F0H,0F0H,
    0D8H,0CCH,0D8H,0F0H,0E0H,000H,000H,000H,
    000H,006H,00CH,018H,030H,060H,0C0H,0C0H,
    060H,030H,018H,00CH,006H,000H,000H,000H,
    000H,0C3H,0C3H,0A5H,0A5H,0A5H,099H,099H,
    099H,0A5H,0A5H,0E7H,0C3H,000H,000H,000H,
    000H,0E7H,0E7H,0DBH,0DBH,0DBH,0C3H,0C3H,
    0C3H,0C3H,0C3H,0C3H,0C3H,000H,000H,000H,
    000H,0CCH,0D8H,0F3H,0E6H,0CCH,0D8H,0F0H,
    0C0H,0C0H,0C0H,0C0H,0C0H,000H,000H,000H,
    000H,000H,0C3H,0C3H,0C3H,066H,03CH,018H,
    03CH,066H,0C3H,0C3H,0C3H,000H,000H,000H,
    000H,0C3H,0C3H,0E3H,0F3H,0DBH,0CFH,0C7H,
    0C3H,0C3H,0C3H,0C3H,0C3H,000H,000H,000H,
    000H,018H,018H,018H,018H,018H,018H,018H,
    018H,018H,018H,018H,018H,000H,000H,000H,
    000H,018H,01CH,01EH,01BH,019H,018H,018H,
    098H,0D8H,078H,038H,018H,000H,000H,000H,
    000H,006H,00CH,018H,030H,060H,0C6H,0C6H,
    060H,030H,018H,00CH,006H,000H,000H,000H,
    000H,0E0H,0F0H,0D8H,0CCH,0C6H,0C3H,0C1H,
    0C0H,0C0H,0C0H,0C0H,0C0H,000H,000H,000H,
    000H,0C3H,0E7H,0BDH,099H,0BDH,0E7H,0C3H,
    0C3H,0C3H,0C3H,0C3H,0C3H,000H,000H,000H,
    000H,018H,098H,0D8H,078H,038H,01CH,01EH,
    01BH,019H,018H,018H,018H,000H,000H,000H,
    000H,03CH,066H,0C3H,0C3H,0C3H,0C3H,066H,
    03CH,018H,03CH,066H,0C3H,000H,000H,000H,
    000H,0C3H,0E6H,0FCH,0D8H,0C0H,0C0H,0C0H,
    0C0H,0D8H,0FCH,0E6H,0C3H,000H,000H,000H,
    000H,03CH,066H,0C3H,0C3H,0C3H,0C3H,0C3H,
    0C3H,0CBH,0CFH,07EH,03CH,006H,007H,000H,
    000H,0F0H,0D8H,0CCH,0C6H,0CCH,0D8H,0F0H,
    0F0H,0D8H,0CCH,0C6H,0C0H,000H,000H,000H,
    000H,00CH,018H,030H,060H,0C0H,0FFH,003H,
    006H,00CH,018H,030H,060H,000H,000H,000H,
    000H,018H,03CH,07EH,0DBH,099H,018H,018H,
    018H,018H,018H,018H,018H,000H,000H,000H,
    000H,0F0H,0F8H,0DCH,0CEH,0C7H,0C3H,0C3H,
    0C3H,0C3H,0C3H,0C3H,0C0H,000H,000H,000H,
    000H,0C6H,0C6H,0C6H,0C6H,0C6H,0C6H,0C6H,
    0C6H,0C6H,07CH,038H,010H,000H,000H,000H,
    000H,0E0H,0F0H,0D8H,0CCH,0C6H,0CCH,0D8H,
    0F0H,0E0H,0C0H,0C0H,0C0H,000H,000H,000H,
    000H,0C6H,0C6H,06CH,06CH,038H,038H,038H,
    038H,06CH,06CH,0C6H,0C6H,000H,000H,000H,
    000H,030H,018H,00CH,006H,033H,066H,0CCH,
    0C0H,060H,030H,018H,00CH,000H,000H,000H,
    000H,0DBH,0DBH,0DBH,07EH,018H,018H,018H,
    018H,018H,018H,018H,018H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,040H,020H,020H,
    000H,000H,000H,000H,000H,000H,000H,018H,
    018H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,07EH,002H,002H,002H,07EH,002H,
    006H,004H,00CH,008H,018H,030H,000H,000H,
    000H,000H,000H,000H,000H,000H,07EH,002H,
    016H,014H,010H,010H,010H,010H,030H,020H,
    000H,000H,000H,000H,000H,002H,004H,004H,
    008H,018H,068H,008H,008H,008H,008H,008H,
    000H,000H,000H,000H,000H,010H,010H,07EH,
    042H,042H,002H,004H,004H,008H,010H,020H,
    000H,000H,000H,000H,000H,000H,000H,07CH,
    010H,010H,010H,010H,010H,010H,07EH,000H,
    000H,000H,000H,000H,000H,008H,008H,008H,
    07EH,018H,018H,028H,028H,048H,008H,018H,
    000H,000H,000H,000H,000H,020H,022H,016H,
    01AH,032H,048H,008H,008H,004H,004H,004H,
    000H,000H,000H,000H,000H,000H,000H,038H,
    008H,008H,008H,008H,008H,008H,07EH,000H,
    000H,000H,000H,000H,000H,000H,03CH,004H,
    004H,004H,03CH,004H,004H,004H,03CH,000H,
    000H,000H,000H,000H,000H,000H,010H,052H,
    04AH,022H,004H,004H,008H,008H,010H,020H,
    000H,000H,000H,000H,000H,000H,000H,03CH,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,0FFH,001H,012H,014H,014H,010H,
    010H,010H,010H,010H,020H,020H,040H,000H,
    000H,002H,002H,004H,004H,008H,018H,028H,
    0C8H,008H,008H,008H,008H,008H,008H,000H,
    010H,010H,010H,07EH,042H,042H,042H,042H,
    002H,002H,004H,004H,008H,010H,020H,000H,
    000H,000H,000H,07EH,010H,010H,010H,010H,
    010H,010H,010H,010H,0FFH,000H,000H,000H,
    008H,008H,008H,008H,0FFH,008H,018H,018H,
    028H,028H,048H,048H,088H,008H,018H,000H,
    010H,010H,010H,010H,07EH,012H,012H,012H,
    012H,012H,022H,022H,022H,042H,04EH,000H,
    020H,020H,020H,016H,018H,030H,0D0H,013H,
    00CH,038H,068H,008H,004H,004H,004H,004H,
    010H,010H,010H,01EH,012H,022H,022H,044H,
    004H,004H,008H,008H,010H,020H,040H,000H,
    020H,020H,020H,020H,03FH,044H,044H,084H,
    004H,008H,008H,008H,010H,010H,020H,000H,
    000H,000H,000H,07EH,002H,002H,002H,002H,
    002H,002H,002H,002H,002H,07EH,000H,000H,
    000H,024H,024H,024H,0FFH,024H,024H,024H,
    024H,004H,004H,008H,008H,010H,020H,000H,
    000H,000H,020H,030H,010H,000H,041H,061H,
    022H,002H,004H,008H,010H,020H,040H,000H,
    000H,000H,07CH,004H,004H,004H,004H,008H,
    008H,018H,014H,024H,022H,042H,081H,000H,
    000H,020H,020H,020H,02EH,032H,0E2H,024H,
    020H,020H,020H,020H,020H,03EH,000H,000H,
    000H,000H,042H,042H,042H,022H,022H,002H,
    004H,004H,004H,008H,008H,010H,020H,000H,
    010H,010H,010H,01EH,012H,022H,032H,04AH,
    004H,004H,008H,008H,010H,020H,040H,000H,
    000H,002H,004H,078H,008H,008H,008H,0FFH,
    008H,008H,010H,010H,010H,020H,040H,000H,
    000H,000H,020H,0A1H,091H,051H,052H,042H,
    002H,004H,004H,008H,008H,010H,020H,000H,
    000H,000H,07EH,000H,000H,000H,0FFH,008H,
    008H,008H,010H,010H,010H,020H,040H,000H,
    000H,010H,010H,010H,010H,010H,018H,014H,
    012H,010H,010H,010H,010H,010H,010H,000H,
    000H,008H,008H,008H,008H,0FFH,008H,008H,
    008H,008H,010H,010H,010H,020H,040H,000H,
    000H,000H,000H,000H,07EH,000H,000H,000H,
    000H,000H,000H,000H,0FFH,000H,000H,000H,
    000H,000H,07EH,002H,002H,004H,024H,028H,
    018H,008H,014H,012H,022H,020H,040H,000H,
    010H,010H,010H,07EH,002H,004H,008H,018H,
    034H,052H,091H,010H,010H,010H,010H,000H,
    000H,000H,002H,002H,004H,004H,004H,008H,
    008H,008H,010H,010H,020H,020H,040H,000H,
    000H,000H,000H,024H,024H,024H,022H,022H,
    022H,022H,042H,041H,041H,081H,000H,000H,
    000H,040H,040H,040H,046H,048H,070H,040H,
    040H,040H,040H,040H,020H,01EH,000H,000H,
    000H,000H,07EH,002H,002H,002H,004H,004H,
    004H,008H,008H,010H,020H,040H,000H,000H,
    000H,000H,000H,020H,030H,030H,048H,048H,
    044H,084H,002H,002H,001H,000H,000H,000H,
    000H,010H,010H,010H,0FFH,010H,010H,054H,
    052H,052H,052H,091H,091H,010H,030H,000H,
    000H,000H,000H,0FFH,001H,002H,004H,028H,
    010H,018H,008H,008H,004H,004H,000H,000H,
    000H,020H,018H,004H,000H,000H,020H,010H,
    00CH,000H,000H,020H,010H,008H,004H,000H,
    000H,010H,010H,010H,010H,010H,020H,024H,
    024H,024H,022H,04EH,072H,081H,000H,000H,
    000H,002H,002H,002H,004H,024H,024H,018H,
    008H,01CH,014H,022H,020H,040H,080H,000H,
    000H,000H,07EH,010H,010H,010H,010H,0FEH,
    010H,010H,010H,010H,010H,01EH,000H,000H,
    000H,020H,020H,023H,02DH,031H,0D2H,012H,
    010H,008H,008H,008H,008H,008H,008H,000H,
    000H,000H,000H,07CH,004H,004H,004H,004H,
    004H,004H,004H,004H,0FFH,000H,000H,000H,
    000H,000H,07EH,002H,002H,002H,002H,07EH,
    002H,002H,002H,002H,002H,07EH,000H,000H,
    000H,000H,07EH,000H,000H,000H,07EH,002H,
    002H,002H,004H,004H,008H,010H,020H,000H,
    000H,022H,022H,022H,022H,022H,022H,022H,
    022H,002H,004H,004H,004H,008H,010H,000H,
    000H,008H,028H,028H,028H,028H,028H,029H,
    029H,029H,02AH,04AH,04CH,088H,000H,000H,
    000H,000H,020H,020H,020H,020H,020H,021H,
    021H,022H,022H,024H,028H,030H,000H,000H,
    000H,000H,000H,07EH,042H,042H,042H,042H,
    042H,042H,042H,042H,07EH,000H,000H,000H,
    000H,000H,07EH,042H,042H,042H,002H,002H,
    002H,004H,004H,008H,010H,020H,000H,000H,
    000H,000H,040H,020H,010H,001H,002H,002H,
    004H,004H,008H,010H,020H,040H,000H,000H,
    028H,028H,028H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    010H,028H,028H,010H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,086H,0C6H,066H,036H,0D8H,
    0CCH,0C6H,0C2H,000H,000H,000H,000H,000H,
    000H,000H,000H,0FCH,0FCH,00CH,00CH,00CH,
    00CH,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,000H,000H,03CH,03CH,00CH,00CH,07CH,
    07CH,06CH,06CH,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,00CH,00CH,00CH,
    00CH,00CH,00CH,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,006H,006H,0C6H,
    0C6H,0C6H,0C6H,000H,000H,000H,000H,000H,
    000H,000H,000H,078H,078H,018H,018H,018H,
    018H,018H,018H,000H,000H,000H,000H,000H,
    000H,000H,000H,07EH,07EH,018H,018H,018H,
    018H,018H,018H,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,0C6H,0C6H,0C6H,
    0C6H,0C6H,0C6H,000H,000H,000H,000H,000H,
    000H,000H,000H,0DEH,0DEH,0D6H,0C6H,0C6H,
    0C6H,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,000H,000H,07CH,07CH,00CH,00CH,00CH,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,006H,006H,006H,
    006H,006H,006H,006H,006H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,006H,006H,006H,
    006H,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,0C0H,0C0H,0FEH,0FEH,006H,006H,00CH,
    018H,030H,030H,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,0C6H,0C6H,0C6H,
    0C6H,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,000H,000H,0DEH,0FEH,066H,0C6H,0C6H,
    0C6H,0DEH,0DEH,000H,000H,000H,000H,000H,
    000H,000H,000H,03CH,03CH,00CH,00CH,00CH,
    00CH,00CH,00CH,00CH,00CH,000H,000H,000H,
    000H,000H,000H,03CH,03CH,00CH,00CH,00CH,
    00CH,07CH,07CH,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,0C6H,0C6H,0C6H,
    0C6H,0FEH,07CH,000H,000H,000H,000H,000H,
    000H,000H,000H,066H,066H,066H,066H,066H,
    066H,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,0C6H,0E6H,0E6H,
    006H,006H,006H,006H,006H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,0C6H,0E6H,006H,
    006H,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,000H,000H,066H,066H,066H,06CH,078H,
    070H,060H,060H,060H,060H,000H,000H,000H,
    000H,000H,000H,0C6H,0C6H,066H,03CH,018H,
    00CH,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,006H,0C6H,0C6H,
    0CEH,0CEH,0C0H,0C0H,0C0H,000H,000H,000H,
    000H,000H,000H,0FEH,0FEH,006H,006H,006H,
    006H,006H,006H,000H,000H,000H,000H,000H,
    000H,000H,000H,0D6H,0D6H,0D6H,0D6H,0D6H,
    0D6H,0FEH,0FEH,000H,000H,000H,000H,000H,
    000H,000H,000H,07EH,07EH,066H,066H,066H,
    066H,0E6H,0E6H,000H,000H,000H,000H,000H,

    (* dots *)

    000H,000H,0E0H,0A0H,0E0H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,0E0H,0A0H,0E0H,000H,0E0H,0A0H,
    0E0H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,0EEH,0AAH,0EEH,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,0EEH,0AAH,0EEH,000H,00EH,00AH,
    00EH,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,0E0H,0A0H,0E0H,000H,00EH,00AH,
    00EH,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,0EEH,0AAH,0EEH,000H,0E0H,0A0H,
    0E0H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,0EEH,0AAH,0EEH,000H,0EEH,0AAH,
    0EEH,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,0E0H,0A0H,0E0H,000H,0EEH,0AAH,
    0EEH,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,00EH,00AH,00EH,000H,0E0H,0A0H,
    0E0H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,00EH,00AH,00EH,000H,0EEH,0AAH,
    0EEH,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,0E0H,0A0H,0E0H,000H,000H,000H,
    000H,000H,0E0H,0A0H,0E0H,000H,000H,000H,
    000H,000H,0E0H,0A0H,0E0H,000H,0E0H,0A0H,
    0E0H,000H,0E0H,0A0H,0E0H,000H,000H,000H,
    000H,000H,0EEH,0AAH,0EEH,000H,000H,000H,
    000H,000H,0E0H,0A0H,0E0H,000H,000H,000H,
    000H,000H,0EEH,0AAH,0EEH,000H,00EH,00AH,
    00EH,000H,0E0H,0A0H,0E0H,000H,000H,000H,
    000H,000H,0E0H,0A0H,0E0H,000H,00EH,00AH,
    00EH,000H,0E0H,0A0H,0E0H,000H,000H,000H,
    000H,000H,0EEH,0AAH,0EEH,000H,0E0H,0A0H,
    0E0H,000H,0E0H,0A0H,0E0H,000H,000H,000H,
    000H,000H,0EEH,0AAH,0EEH,000H,0EEH,0AAH,
    0EEH,000H,0E0H,0A0H,0E0H,000H,000H,000H,
    000H,000H,0E0H,0A0H,0E0H,000H,0EEH,0AAH,
    0EEH,000H,0E0H,0A0H,0E0H,000H,000H,000H,
    000H,000H,00EH,00AH,00EH,000H,0E0H,0A0H,
    0E0H,000H,0E0H,0A0H,0E0H,000H,000H,000H,
    000H,000H,00EH,00AH,00EH,000H,0EEH,0AAH,
    0EEH,000H,0E0H,0A0H,0E0H,000H,000H,000H,
    000H,000H,0E0H,0A0H,0E0H,000H,000H,000H,
    000H,000H,0EEH,0AAH,0EEH,000H,000H,000H,
    000H,000H,0E0H,0A0H,0E0H,000H,0E0H,0A0H,
    0E0H,000H,0EEH,0AAH,0EEH,000H,000H,000H,
    000H,000H,00EH,00AH,00EH,000H,0EEH,0AAH,
    0EEH,000H,00EH,00AH,00EH,000H,000H,000H,
    000H,000H,0EEH,0AAH,0EEH,000H,000H,000H,
    000H,000H,0EEH,0AAH,0EEH,000H,000H,000H,
    000H,000H,0EEH,0AAH,0EEH,000H,00EH,00AH,
    00EH,000H,0EEH,0AAH,0EEH,000H,000H,000H,
    000H,000H,0E0H,0A0H,0E0H,000H,00EH,00AH,
    00EH,000H,0EEH,0AAH,0EEH,000H,000H,000H,
    000H,000H,0EEH,0AAH,0EEH,000H,0EEH,0AAH,
    0EEH,000H,0EEH,0AAH,0EEH,000H,000H,000H,

    (* selected chars from apple16_.fon *)

    000H,038H,044H,044H,044H,04CH,054H,054H,
    054H,064H,044H,044H,044H,038H,000H,000H,
    000H,010H,010H,030H,010H,010H,010H,010H,
    010H,010H,010H,010H,010H,038H,000H,000H,
    000H,038H,044H,044H,004H,004H,004H,018H,
    020H,020H,040H,040H,040H,07CH,000H,000H,
    000H,07CH,004H,004H,004H,008H,008H,018H,
    004H,004H,044H,044H,044H,038H,000H,000H,
    000H,008H,008H,018H,028H,028H,048H,048H,
    048H,07CH,008H,008H,008H,008H,000H,000H,
    000H,07CH,040H,040H,040H,078H,004H,004H,
    004H,004H,044H,044H,044H,038H,000H,000H,
    000H,01CH,020H,020H,040H,040H,040H,078H,
    044H,044H,044H,044H,044H,038H,000H,000H,
    000H,07CH,004H,004H,008H,008H,010H,010H,
    020H,020H,020H,020H,020H,020H,000H,000H,
    000H,038H,044H,044H,044H,044H,044H,038H,
    044H,044H,044H,044H,044H,038H,000H,000H,
    000H,038H,044H,044H,044H,044H,044H,03CH,
    004H,004H,004H,008H,008H,070H,000H,000H,
    000H,000H,000H,000H,010H,010H,000H,000H,
    010H,010H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,038H,004H,004H,
    004H,03CH,044H,044H,044H,03CH,000H,000H,
    000H,040H,040H,040H,040H,078H,044H,044H,
    044H,044H,044H,044H,044H,078H,000H,000H,
    000H,000H,000H,000H,000H,03CH,040H,040H,
    040H,040H,040H,040H,040H,03CH,000H,000H,
    000H,004H,004H,004H,004H,03CH,044H,044H,
    044H,044H,044H,044H,044H,03CH,000H,000H,
    000H,000H,000H,000H,000H,038H,044H,044H,
    044H,07CH,040H,040H,040H,03CH,000H,000H,
    000H,018H,024H,024H,020H,020H,020H,078H,
    020H,020H,020H,020H,020H,020H,000H,000H,
    000H,000H,000H,000H,000H,038H,044H,044H,
    044H,044H,044H,03CH,004H,004H,038H,000H,
    000H,040H,040H,040H,040H,078H,044H,044H,
    044H,044H,044H,044H,044H,044H,000H,000H,
    000H,010H,000H,000H,000H,030H,010H,010H,
    010H,010H,010H,010H,010H,038H,000H,000H,
    000H,008H,000H,000H,000H,018H,008H,008H,
    008H,008H,008H,008H,048H,048H,030H,000H,
    000H,040H,040H,040H,044H,044H,048H,048H,
    048H,070H,048H,048H,044H,044H,000H,000H,
    000H,030H,010H,010H,010H,010H,010H,010H,
    010H,010H,010H,010H,010H,038H,000H,000H,
    000H,000H,000H,000H,000H,06CH,054H,054H,
    054H,054H,054H,054H,044H,044H,000H,000H,
    000H,000H,000H,000H,000H,078H,044H,044H,
    044H,044H,044H,044H,044H,044H,000H,000H,
    000H,000H,000H,000H,000H,038H,044H,044H,
    044H,044H,044H,044H,044H,038H,000H,000H,
    000H,000H,000H,000H,000H,078H,044H,044H,
    044H,044H,044H,078H,040H,040H,040H,000H,
    000H,000H,000H,000H,000H,03CH,044H,044H,
    044H,044H,044H,03CH,004H,004H,004H,000H,
    000H,000H,000H,000H,000H,05CH,060H,040H,
    040H,040H,040H,040H,040H,040H,000H,000H,
    000H,000H,000H,000H,000H,03CH,040H,040H,
    040H,038H,004H,004H,004H,078H,000H,000H,
    000H,020H,020H,020H,020H,078H,020H,020H,
    020H,020H,024H,024H,024H,018H,000H,000H,
    000H,000H,000H,000H,000H,044H,044H,044H,
    044H,044H,044H,04CH,04CH,034H,000H,000H,
    000H,000H,000H,000H,000H,044H,044H,044H,
    044H,044H,028H,028H,010H,010H,000H,000H,
    000H,000H,000H,000H,000H,044H,044H,044H,
    054H,054H,054H,054H,054H,06CH,000H,000H,
    000H,000H,000H,000H,000H,044H,028H,028H,
    010H,010H,028H,028H,044H,044H,000H,000H,
    000H,000H,000H,000H,000H,044H,044H,044H,
    044H,044H,044H,03CH,004H,004H,038H,000H,
    000H,000H,000H,000H,000H,07CH,008H,008H,
    010H,010H,020H,020H,020H,07CH,000H,000H,
    000H,000H,000H,000H,000H,03CH,040H,040H,
    040H,040H,040H,040H,040H,03CH,008H,000H,
    000H,038H,044H,000H,000H,038H,004H,004H,
    004H,03CH,044H,044H,044H,03CH,000H,000H,
    000H,060H,018H,000H,000H,038H,004H,004H,
    004H,03CH,044H,044H,044H,03CH,000H,000H,
    000H,00CH,030H,000H,000H,038H,044H,044H,
    044H,07CH,040H,040H,040H,03CH,000H,000H,
    000H,038H,044H,000H,000H,038H,044H,044H,
    044H,07CH,040H,040H,040H,03CH,000H,000H,
    000H,060H,018H,000H,000H,038H,044H,044H,
    044H,07CH,040H,040H,040H,03CH,000H,000H,
    000H,038H,044H,000H,000H,030H,010H,010H,
    010H,010H,010H,010H,010H,038H,000H,000H,
    000H,038H,044H,000H,000H,044H,044H,044H,
    044H,044H,044H,04CH,04CH,034H,000H,000H,
    000H,060H,018H,000H,000H,044H,044H,044H,
    044H,044H,044H,04CH,04CH,034H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    010H,010H,010H,010H,020H,020H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,07CH,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,010H,010H,010H,010H,010H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,010H,010H,000H,000H,

    0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,
    0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
    );

    (* built from squashed Font25, using katakana from alternate *)

    Font50 = FontDef50(
    000H,086H,0E6H,0FEH,0CEH,0C2H,000H,000H,
    000H,0FCH,0FCH,00CH,0FEH,0FEH,000H,000H,
    000H,03CH,03CH,07CH,07CH,06CH,000H,000H,
    000H,0FEH,0FEH,00CH,00CH,00CH,000H,000H,
    000H,0FEH,0FEH,0C6H,0C6H,0C6H,000H,000H,
    000H,078H,078H,018H,018H,018H,000H,000H,
    000H,07EH,07EH,018H,018H,018H,000H,000H,
    000H,0FEH,0FEH,0C6H,0C6H,0C6H,000H,000H,
    000H,0DEH,0DEH,0C6H,0FEH,0FEH,000H,000H,
    000H,07CH,07CH,00CH,000H,000H,000H,000H,
    000H,0FEH,0FEH,006H,006H,006H,006H,000H,
    000H,0FEH,0FEH,006H,0FEH,0FEH,000H,000H,
    0C0H,0FEH,0FEH,00EH,038H,030H,000H,000H,
    000H,0FEH,0FEH,0C6H,0FEH,0FEH,000H,000H,
    000H,0DEH,0FEH,0C6H,0DEH,0DEH,000H,000H,
    000H,03CH,03CH,00CH,00CH,00CH,00CH,000H,
    000H,03CH,03CH,00CH,07CH,07CH,000H,000H,
    000H,0FEH,0FEH,0C6H,0FEH,07CH,000H,000H,
    000H,066H,066H,066H,0FEH,0FEH,000H,000H,
    000H,0FEH,0FEH,0E6H,006H,006H,006H,000H,
    000H,0FEH,0FEH,0E6H,0FEH,0FEH,000H,000H,
    000H,066H,066H,07CH,070H,060H,060H,000H,
    000H,0C6H,0E6H,03CH,0FEH,0FEH,000H,000H,
    000H,0FEH,0FEH,0C6H,0CEH,0C0H,0C0H,000H,
    000H,0FEH,0FEH,006H,006H,006H,000H,000H,
    000H,0D6H,0D6H,0D6H,0FEH,0FEH,000H,000H,
    000H,07EH,07EH,066H,0E6H,0E6H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    07CH,0FEH,0FEH,0FEH,0FEH,0FEH,07CH,000H,
    018H,018H,018H,018H,018H,018H,018H,000H,
    066H,066H,066H,066H,066H,066H,066H,000H,
    0DBH,0DBH,0DBH,0DBH,0DBH,0DBH,0DBH,000H,
    0A5H,0A5H,0A5H,0A5H,0A5H,0A5H,0A5H,000H,
    000H,000H,000H,0FFH,0FFH,0FFH,03CH,000H,
    018H,018H,018H,0FFH,0FFH,0FFH,03CH,000H,
    066H,066H,066H,0FFH,0FFH,0FFH,03CH,000H,
    0DBH,0DBH,0DBH,0FFH,0FFH,0FFH,03CH,000H,
    0A5H,0A5H,0A5H,0FFH,0FFH,0FFH,03CH,000H,
    07CH,0FEH,0FEH,0FEH,0FEH,0FEH,07CH,000H,
    018H,018H,018H,018H,018H,018H,018H,000H,
    066H,066H,066H,066H,066H,066H,066H,000H,
    0DBH,0DBH,0DBH,0DBH,0DBH,0DBH,0DBH,000H,
    0A5H,0A5H,0A5H,0A5H,0A5H,0A5H,0A5H,000H,
    000H,000H,000H,0FFH,0FFH,0FFH,03CH,000H,
    018H,018H,018H,0FFH,0FFH,0FFH,03CH,000H,
    066H,066H,066H,0FFH,0FFH,0FFH,03CH,000H,
    0DBH,0DBH,0DBH,0FFH,0FFH,0FFH,03CH,000H,
    0A5H,0A5H,0A5H,0FFH,0FFH,0FFH,03CH,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,000H,
    0E0H,0F8H,0EEH,0F8H,0CCH,0C0H,0C0H,000H,
    0E0H,0F8H,0DCH,0F0H,0DCH,0F8H,0E0H,000H,
    006H,01CH,070H,0C0H,070H,01CH,006H,000H,
    0C3H,0E7H,0A5H,099H,0BDH,0E7H,0C3H,000H,
    0E7H,0FFH,0DBH,0C3H,0C3H,0C3H,0C3H,000H,
    0CCH,0FBH,0EEH,0F8H,0C0H,0C0H,0C0H,000H,
    000H,0C3H,0E7H,03CH,07EH,0C3H,0C3H,000H,
    0C3H,0E3H,0FBH,0CFH,0C3H,0C3H,0C3H,000H,
    018H,018H,018H,018H,018H,018H,018H,000H,
    018H,01EH,01BH,018H,0D8H,078H,018H,000H,
    006H,01CH,070H,0C6H,070H,01CH,006H,000H,
    0E0H,0F8H,0CEH,0C3H,0C0H,0C0H,0C0H,000H,
    0C3H,0FFH,0BDH,0E7H,0C3H,0C3H,0C3H,000H,
    018H,0D8H,078H,01EH,01BH,018H,018H,000H,
    03CH,0E7H,0C3H,0E7H,03CH,07EH,0C3H,000H,
    0C3H,0FEH,0D8H,0C0H,0D8H,0FEH,0C3H,000H,
    03CH,0E7H,0C3H,0C3H,0CBH,0FFH,03EH,007H,
    0F0H,0DCH,0CEH,0F8H,0F8H,0CEH,0C0H,000H,
    00CH,038H,0E0H,0FFH,00EH,038H,060H,000H,
    018H,07EH,0DBH,018H,018H,018H,018H,000H,
    0F0H,0FCH,0CFH,0C3H,0C3H,0C3H,0C0H,000H,
    0C6H,0C6H,0C6H,0C6H,0C6H,07CH,010H,000H,
    0E0H,0F8H,0CEH,0DCH,0F0H,0C0H,0C0H,000H,
    0C6H,0EEH,07CH,038H,07CH,0EEH,0C6H,000H,
    030H,01CH,037H,0EEH,0E0H,038H,00CH,000H,
    0DBH,0DBH,07EH,018H,018H,018H,018H,000H,
    000H,000H,000H,000H,000H,000H,040H,020H,
    000H,000H,000H,018H,018H,000H,000H,000H,
    000H,03EH,002H,03EH,004H,00CH,030H,000H,
    000H,000H,000H,03EH,014H,010H,010H,030H,
    000H,000H,000H,004H,008H,008H,008H,008H,
    000H,000H,000H,03CH,042H,000H,008H,020H,
    000H,000H,000H,03CH,010H,010H,010H,03CH,
    000H,000H,000H,008H,03CH,028H,008H,008H,
    000H,000H,000H,012H,032H,008H,004H,004H,
    000H,000H,000H,030H,008H,008H,008H,03CH,
    000H,000H,000H,03CH,004H,03CH,004H,03CH,
    000H,000H,000H,010H,002H,004H,008H,020H,
    000H,000H,000H,03CH,000H,000H,000H,000H,
    000H,0FFH,010H,010H,010H,010H,020H,000H,
    000H,000H,008H,028H,0C8H,008H,008H,000H,
    010H,03CH,042H,042H,002H,004H,000H,000H,
    000H,03CH,010H,010H,010H,010H,0FFH,000H,
    008H,008H,0FFH,018H,028H,048H,008H,000H,
    010H,010H,03EH,012H,012H,022H,002H,00CH,
    020H,010H,030H,0D3H,03CH,008H,004H,004H,
    010H,01CH,022H,000H,004H,008H,020H,000H,
    020H,020H,03FH,084H,008H,008H,010H,000H,
    000H,03CH,002H,002H,002H,002H,03EH,000H,
    000H,024H,0FFH,024H,004H,008H,000H,000H,
    000H,030H,000H,041H,002H,008H,020H,000H,
    000H,03CH,004H,008H,008H,024H,002H,000H,
    000H,020H,03EH,0E0H,020H,020H,03CH,000H,
    000H,042H,002H,002H,004H,008H,000H,000H,
    010H,01CH,022H,032H,004H,008H,020H,000H,
    000H,038H,008H,0FFH,008H,010H,020H,000H,
    000H,020H,051H,042H,000H,008H,000H,000H,
    000H,03CH,000H,0FFH,008H,010H,020H,000H,
    000H,010H,010H,014H,010H,010H,010H,000H,
    000H,008H,0FFH,008H,008H,010H,020H,000H,
    000H,000H,03CH,000H,000H,000H,0FFH,000H,
    000H,03EH,000H,028H,008H,010H,020H,000H,
    010H,03CH,000H,008H,030H,010H,010H,000H,
    000H,002H,004H,008H,008H,010H,020H,000H,
    000H,000H,024H,022H,022H,041H,081H,000H,
    000H,040H,048H,070H,040H,040H,01CH,000H,
    000H,03EH,002H,004H,008H,000H,000H,000H,
    000H,000H,030H,048H,084H,002H,000H,000H,
    000H,010H,0FFH,010H,052H,091H,010H,030H,
    000H,0FFH,002H,008H,010H,008H,004H,000H,
    000H,004H,000H,010H,00CH,000H,000H,000H,
    000H,010H,010H,020H,024H,00EH,0B1H,000H,
    000H,002H,004H,018H,00CH,020H,000H,000H,
    000H,03CH,010H,0FCH,010H,010H,01CH,000H,
    000H,023H,03DH,0D2H,000H,008H,008H,000H,
    000H,03CH,004H,004H,004H,004H,0FFH,000H,
    000H,03EH,002H,03EH,002H,002H,03EH,000H,
    000H,03CH,000H,03EH,002H,004H,000H,000H,
    000H,022H,022H,022H,002H,004H,008H,000H,
    000H,028H,028H,028H,029H,00AH,08CH,000H,
    000H,020H,020H,020H,022H,020H,030H,000H,
    000H,03CH,042H,042H,042H,042H,03CH,000H,
    000H,07EH,042H,002H,000H,008H,020H,000H,
    000H,000H,000H,002H,004H,000H,000H,000H,
    028H,000H,000H,000H,000H,000H,000H,000H,
    020H,010H,000H,000H,000H,000H,000H,000H,
    000H,086H,0E6H,0FEH,0CEH,0C2H,000H,000H,
    000H,0FCH,0FCH,00CH,0FEH,0FEH,000H,000H,
    000H,03CH,03CH,07CH,07CH,06CH,000H,000H,
    000H,0FEH,0FEH,00CH,00CH,00CH,000H,000H,
    000H,0FEH,0FEH,0C6H,0C6H,0C6H,000H,000H,
    000H,078H,078H,018H,018H,018H,000H,000H,
    000H,07EH,07EH,018H,018H,018H,000H,000H,
    000H,0FEH,0FEH,0C6H,0C6H,0C6H,000H,000H,
    000H,0DEH,0DEH,0C6H,0FEH,0FEH,000H,000H,
    000H,07CH,07CH,00CH,000H,000H,000H,000H,
    000H,0FEH,0FEH,006H,006H,006H,006H,000H,
    000H,0FEH,0FEH,006H,0FEH,0FEH,000H,000H,
    0C0H,0FEH,0FEH,00EH,038H,030H,000H,000H,
    000H,0FEH,0FEH,0C6H,0FEH,0FEH,000H,000H,
    000H,0DEH,0FEH,0C6H,0DEH,0DEH,000H,000H,
    000H,03CH,03CH,00CH,00CH,00CH,00CH,000H,
    000H,03CH,03CH,00CH,07CH,07CH,000H,000H,
    000H,0FEH,0FEH,0C6H,0FEH,07CH,000H,000H,
    000H,066H,066H,066H,0FEH,0FEH,000H,000H,
    000H,0FEH,0FEH,0E6H,006H,006H,006H,000H,
    000H,0FEH,0FEH,0E6H,0FEH,0FEH,000H,000H,
    000H,066H,066H,07CH,070H,060H,060H,000H,
    000H,0C6H,0E6H,03CH,0FEH,0FEH,000H,000H,
    000H,0FEH,0FEH,0C6H,0CEH,0C0H,0C0H,000H,
    000H,0FEH,0FEH,006H,006H,006H,000H,000H,
    000H,0D6H,0D6H,0D6H,0FEH,0FEH,000H,000H,
    000H,07EH,07EH,066H,0E6H,0E6H,000H,000H,

    (* dots *)

    0A0H,000H,000H,000H,000H,000H,000H,000H,
    000H,0A0H,000H,0A0H,000H,000H,000H,000H,
    000H,0AAH,000H,000H,000H,000H,000H,000H,
    000H,0AAH,000H,00AH,000H,000H,000H,000H,
    000H,0A0H,000H,00AH,000H,000H,000H,000H,
    000H,0AAH,000H,0A0H,000H,000H,000H,000H,
    000H,0AAH,000H,0AAH,000H,000H,000H,000H,
    000H,0A0H,000H,0AAH,000H,000H,000H,000H,
    000H,00AH,000H,0A0H,000H,000H,000H,000H,
    000H,00AH,000H,0AAH,000H,000H,000H,000H,
    000H,0A0H,000H,000H,000H,0A0H,000H,000H,
    000H,0A0H,000H,0A0H,000H,0A0H,000H,000H,
    000H,0AAH,000H,000H,000H,0A0H,000H,000H,
    000H,0AAH,000H,00AH,000H,0A0H,000H,000H,
    000H,0A0H,000H,00AH,000H,0A0H,000H,000H,
    000H,0AAH,000H,0A0H,000H,0A0H,000H,000H,
    000H,0AAH,000H,0AAH,000H,0A0H,000H,000H,
    000H,0A0H,000H,0AAH,000H,0A0H,000H,000H,
    000H,00AH,000H,0A0H,000H,0A0H,000H,000H,
    000H,00AH,000H,0AAH,000H,0A0H,000H,000H,
    000H,0A0H,000H,000H,000H,0AAH,000H,000H,
    000H,0A0H,000H,0A0H,000H,0AAH,000H,000H,
    000H,00AH,000H,0AAH,000H,00AH,000H,000H,
    000H,0AAH,000H,000H,000H,0AAH,000H,000H,
    000H,0AAH,000H,00AH,000H,0AAH,000H,000H,
    000H,0A0H,000H,00AH,000H,0AAH,000H,000H,
    000H,0AAH,000H,0AAH,000H,0AAH,000H,000H,

	(* selected apple8.fon characters *)

    038H,044H,04CH,054H,064H,044H,038H,000H,
    010H,030H,010H,010H,010H,010H,038H,000H,
    038H,044H,004H,018H,020H,040H,07CH,000H,
    07CH,004H,008H,018H,004H,044H,038H,000H,
    008H,018H,028H,048H,07CH,008H,008H,000H,
    07CH,040H,078H,004H,004H,044H,038H,000H,
    01CH,020H,040H,078H,044H,044H,038H,000H,
    07CH,004H,008H,010H,020H,020H,020H,000H,
    038H,044H,044H,038H,044H,044H,038H,000H,
    038H,044H,044H,03CH,004H,008H,070H,000H,
    000H,000H,010H,000H,010H,000H,000H,000H,
    000H,000H,038H,004H,03CH,044H,03CH,000H,
    040H,040H,078H,044H,044H,044H,078H,000H,
    000H,000H,03CH,040H,040H,040H,03CH,000H,
    004H,004H,03CH,044H,044H,044H,03CH,000H,
    000H,000H,038H,044H,07CH,040H,03CH,000H,
    018H,024H,020H,078H,020H,020H,020H,000H,
    000H,000H,038H,044H,044H,03CH,004H,038H,
    040H,040H,078H,044H,044H,044H,044H,000H,
    010H,000H,030H,010H,010H,010H,038H,000H,
    008H,000H,018H,008H,008H,008H,048H,030H,
    040H,040H,044H,048H,070H,048H,044H,000H,
    030H,010H,010H,010H,010H,010H,038H,000H,
    000H,000H,06CH,054H,054H,054H,044H,000H,
    000H,000H,078H,044H,044H,044H,044H,000H,
    000H,000H,038H,044H,044H,044H,038H,000H,
    000H,000H,078H,044H,044H,078H,040H,040H,
    000H,000H,03CH,044H,044H,03CH,004H,004H,
    000H,000H,05CH,060H,040H,040H,040H,000H,
    000H,000H,03CH,040H,038H,004H,078H,000H,
    020H,020H,078H,020H,020H,024H,018H,000H,
    000H,000H,044H,044H,044H,04CH,034H,000H,
    000H,000H,044H,044H,044H,028H,010H,000H,
    000H,000H,044H,044H,054H,054H,06CH,000H,
    000H,000H,044H,028H,010H,028H,044H,000H,
    000H,000H,044H,044H,044H,03CH,004H,038H,
    000H,000H,07CH,008H,010H,020H,07CH,000H,
    000H,000H,03CH,040H,040H,040H,03CH,008H,
    07CH,000H,038H,004H,03CH,044H,03CH,000H,
    060H,000H,038H,004H,03CH,044H,03CH,000H,
    00CH,000H,038H,044H,07CH,040H,03CH,000H,
    07CH,000H,038H,044H,07CH,040H,03CH,000H,
    060H,000H,038H,044H,07CH,040H,03CH,000H,
    07CH,000H,030H,010H,010H,010H,038H,000H,
    07CH,000H,044H,044H,044H,04CH,034H,000H,
    060H,000H,044H,044H,044H,04CH,034H,000H,
    000H,000H,000H,000H,010H,010H,020H,000H,
    000H,000H,000H,07CH,000H,000H,000H,000H,
    010H,010H,010H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,010H,000H,

    0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH,0FFH
    );

(* adapted from LOADFONT *)

CONST
    legallinecount25 = 25;
    legallinecount28 = 28;
    legallinecount43 = 43;
    legallinecount50 = 50;
    legallinecount30 = 30;

PROCEDURE allowablelinecount (current: CARDINAL ):CARDINAL ; (* return bytesPerChar *)
BEGIN
    CASE current OF
    | legallinecount25,legallinecount28,legallinecount30:RETURN 16;
    | legallinecount50,legallinecount43:RETURN 8;
    ELSE
        RETURN MAX(CARDINAL);
    END;
END allowablelinecount;

(* clear screen then reset chargen *)

CONST
    videoBIOS = 10H;

PROCEDURE resetCharGen (lines : CARDINAL;fullreset:BOOLEAN );
CONST
    block     = 00H; (* block to load must be 0, else ugly results ! *)
VAR
    R : SYSTEM.Registers;
    columns,displaymode,activepage:SHORTCARD;
    cursorstart,cursorend,cursorcolumn,cursorrow:SHORTCARD;
    fontheight [0040H:0085H] : CARDINAL;

    oldscanlines : CARDINAL;
    newscanlines : CARDINAL;
    newcursorstart,newcursorend:CARDINAL;
    setpattern:CARDINAL;
BEGIN
    CASE lines OF
    | legallinecount50, legallinecount43 :
        setpattern := 1112H; (* 8x8 ROM DBL-dot patterns EGA/VGA *)
    | legallinecount28,legallinecount30 :
        setpattern := 1111H; (* 8x14 ROM monochrome patterns EGA/VGA *)
    | legallinecount25 :
        setpattern := 1114H; (* 8x16 ROM VGA *)
    ELSE
        RETURN;
    END;

    (* pattern MUST be $111x because $110x does NOT work : Matrox strikes again ! *)
    (* block other than 0 is a no-no *)

IF fullreset THEN
    oldscanlines := fontheight;

    R.AH := 0FH;           (* get current video mode *)
    Lib.Intr(R,videoBIOS);
    columns     := R.AH;
    displaymode := R.AL;   (* bit 7 can be ON if previous mode setting was so *)
    activepage  := R.BH;

    R.AH := 03H;           (* get cursor position and size *)
    R.BH := activepage;
    Lib.Intr(R,videoBIOS);
    cursorstart := R.CH;
    cursorend   := R.CL;
    cursorcolumn:= R.DL;
    cursorrow   := R.DH;

    R.AH := 00H;           (* set video mode *)
    R.AL := displaymode;
    Lib.Intr(R,videoBIOS);
END;

    R.AX := setpattern;
    R.BL := SHORTCARD(block);
    Lib.Intr(R,videoBIOS);

    (*
    R.AX := 1130H;         (* get font information *)
    R.BL := 00H;           (* dummy, just in case : get int $1F pointer *)
    Lib.Intr(R,videoBIOS);
    scanlines := SHORTCARD(R.CX);  (* pixels per char, same as $0040:0085 (word) *)
    *)
IF fullreset THEN
    newscanlines := fontheight;

    newcursorstart := (newscanlines * CARDINAL(cursorstart)) DIV oldscanlines;
    newcursorend   := (newscanlines * CARDINAL(cursorend  )) DIV oldscanlines;

    R.AH := 01H;           (* set text-mode cursor shape *)
    R.CH := SHORTCARD(newcursorstart);
    R.CL := SHORTCARD(newcursorend);
    Lib.Intr(R,videoBIOS);
END;
END resetCharGen;

PROCEDURE setCharGen (bytesPerChar:CARDINAL);
VAR
    R : SYSTEM.Registers;
BEGIN
    CASE bytesPerChar OF (* now using FarMove just in case even though it should be useless ! *)
    | 8:
        Lib.FarMove(FarADR(Font50),FarADR(fontbuffer),fontsize50);
    | 16:
        Lib.FarMove(FarADR(Font25),FarADR(fontbuffer),fontsize25);
    ELSE
        RETURN;
    END;
    R.AX := 1100H;
    R.ES := Seg(FarADDRESS(fontbuffer)); (* es:bp -> user table *)
    R.BP := Ofs(FarADDRESS(fontbuffer));
    R.CX := 256; (* count of patterns to store *)
    R.DX := 0;   (* character offset into map 2 block *)
    R.BL := 0;   (* block to load in map 2 *)
    R.BH := BYTE(bytesPerChar); (* number of bytes per character pattern *)
    Lib.Intr(R,videoBIOS);
END setCharGen;

PROCEDURE getFontParms (n:CARDINAL;VAR lowerchar,upperchar,currfont:CARDINAL);
VAR
    rc:BOOLEAN;
BEGIN
    CASE n OF
    | 0:  lowerchar:= 000;upperchar:=026;
    | 1:  lowerchar:= 048;upperchar:=057;
    | 2:  lowerchar:= 065;upperchar:=090;
    | 3:  lowerchar:= 091;upperchar:=148;
    | 4:  lowerchar:= 151;upperchar:=177;
    | 5:  lowerchar:= 178;upperchar:=204;
    | 100:lowerchar:=deflowerchar;upperchar:=defupperchar;
    | 101:lowerchar:=ORD("A"); upperchar:=ORD("Z");
    | 102:lowerchar:=ORD("a"); upperchar:=ORD("z");
    | 103:lowerchar:=ORD("0"); upperchar:=ORD("9");
    | 104:lowerchar:=ORD("0"); upperchar:=ORD("1");
    ELSE
          lowerchar:=deflowerchar;upperchar:=defupperchar;
    END;
    CASE n OF
    | 0..5     : currfont:=n;
    | 100..104 : currfont:=n;
    ELSE
        currfont:=MAX(CARDINAL);
    END;
END getFontParms;

(* ------------------------------------------------------------ *)

CONST
    CO80 = BYTE(3); (* color 80x25 *)
    MONO = BYTE(7); (* monochrome *)
CONST
    iv = 010H; (* video interrupt is $10 *)
    sb = 040H; (* segBiosData *)
VAR
    biosCurrentVideoMode  [sb:049H] : BYTE;

PROCEDURE isMonoMode ():BOOLEAN;
BEGIN
    RETURN (biosCurrentVideoMode = MONO);
END isMonoMode;

PROCEDURE set25LineMode () : BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    (* select vertical resolution vga *)
    R.AH := 12H;
    R.BL := 30H;
    R.AL := 02H;        (* 0=200, 1=350, 2=400 *)
    Lib.Intr(R,iv);     (* al=$12 if function supported *)
    IF R.AL # 12H THEN RETURN FALSE; END;
    (* set video mode *)
    R.AH := 00H;
    R.AL := CO80;
    Lib.Intr(R,iv);
    RETURN TRUE;
END set25LineMode;

PROCEDURE set50LineMode (  ) : BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    IF isMonoMode() THEN RETURN FALSE; END;
    (* select vertical resolution vga *)
    R.AH := 12H;
    R.BL := 30H;
    R.AL := 02H;        (* 0=200, 1=350, 2=400 *)
    Lib.Intr(R,iv);     (* al=$12 if function supported *)
    IF R.AL # 12H THEN RETURN FALSE; END;
    (* set video mode *)
    R.AH := 00H;
    R.AL := CO80;
    Lib.Intr(R,iv);
    (* load rom 8x8 dbl-dot patterns *)
    R.AH := 11H;
    R.AL := 12H;
    R.BL := 00H;        (* load block 0 *)
    Lib.Intr(R,iv);
    RETURN TRUE;
END set50LineMode;

(* ------------------------------------------------------------ *)

VAR
    oldCursorShape : CARDINAL;

PROCEDURE setTextCursorShape (scanlines:CARDINAL );
VAR
    R : SYSTEM.Registers;
BEGIN
    R.CX := scanlines;
    R.AH := 01H; (* set text-mode cursor shape *)
    Lib.Intr(R,iv);
END setTextCursorShape;

TYPE
    cursorshapetype = (saveoldcursor, invisiblecursor, oldcursor);

PROCEDURE setCursorShape (shape:cursorshapetype);
VAR
    biosCursorType [sb:060H] : WORD;
    scanlines : CARDINAL;
BEGIN
    CASE shape OF
    | invisiblecursor: (* bits 6,5 : 01 *)
        IF isMonoMode () THEN
            scanlines := 02D0EH; (* 2b0c *)
        ELSE
            scanlines := 02607H;
        END;
    | oldcursor:
        scanlines := oldCursorShape;
    | saveoldcursor:
        oldCursorShape := biosCursorType;
        RETURN; (* force it here *)    END;
    setTextCursorShape(scanlines);
END setCursorShape;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    UNDEFINED = 0;
VAR
    ink,paper,speed,inkfade,uppervelocity:CARDINAL;
    seuilbirth,seuiltwinkle,seuileraser,seuilink:CARDINAL;
    motion:motiontype;

PROCEDURE restoremostdefaults (  );
BEGIN
    ink:=defaultink;
    paper:=defaultpaper;
    speed:=defaultspeed;
    seuilbirth:=defseuilbirth;
    seuiltwinkle:=defseuiltwinkle;
    seuileraser:=defseuileraser;
    seuilink:=defseuilink;
    uppervelocity:=defuppervelocity;
    inkfade:=getfaded(ink,darker);
    motion:=downwards;
END restoremostdefaults;

VAR
    lowerchar,upperchar,currfont:CARDINAL;
    stopmouse,myfont,scroll,fixcursor,showstring,wideframe,centered:BOOLEAN;
    lastcol,lastrow,lastcell : CARDINAL;
    chk:BOOLEAN;
    keycode:CARDINAL;
    bytesPerChar:CARDINAL;
    fullreset:BOOLEAN;
    forcedlines:CARDINAL;
    singlestep:BOOLEAN;
    verbose:BOOLEAN;
    newmotion:motiontype;
    motioncode:CARDINAL;
VAR
    shifted:BOOLEAN;
    parmcount, i, opt : CARDINAL;
    S,R : str128;
BEGIN
    Lib.DisableBreakCheck();
    (* WrLn; not here ! *)

    restoremostdefaults;

    stopmouse:=FALSE;
    myfont:=FALSE;
    getFontParms(104,lowerchar,upperchar,currfont); (* default is binary rain *)
    fullreset:=FALSE;
    forcedlines:=UNDEFINED;
    scroll:=FALSE;
    showstring:=FALSE;
    wideframe:=TRUE;
    centered:=FALSE;
    Str.Copy(format,"");
    language := french;
    showmefor:=defaultshowmefor;
    fixcursor:=TRUE;
    verbose:=FALSE;

    parmcount := Lib.ParamCount();
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S); Str.Copy(R,S); UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "I:"+delim+"INK:"+delim+
                                   "P:"+delim+"PAPER:"+delim+
                                   "S:"+delim+"SPEED:"+delim+
                                   "M"+delim+"MOUSE"+delim+
                                   "B:"+delim+"BIRTH:"+delim+
                                   "T:"+delim+"TWINLING:"+delim+
                                   "E:"+delim+"ERASER:"+delim+
                                   "L:"+delim+"LOWER:"+delim+
                                   "U:"+delim+"UPPER:"+delim+
                                   "U"+delim+"UPPER"+delim+
                                   "L"+delim+"LOWER"+delim+
                                   "D"+delim+"DIGITS"+delim+
                                   "B"+delim+"BINARY"+delim+
                                   "V:"+delim+"VELOCITY:"+delim+
                                   "C:"+delim+"COLOR:"+delim+
                                   "F"+delim+"FONT"+delim+
                                   "R"+delim+"RESET"+delim+
                                   "FA"+delim+
                                   "FB"+delim+
                                   "FC"+delim+
                                   "FD"+delim+
                                   "FE"+delim+
                                   "FF"+delim+
                                   "FF"+delim+ (* trick *)
                                   "2"+delim+"25"+delim+
                                   "5"+delim+"50"+delim+
                                   "S"+delim+"SCROLL"+delim+
                                   "A"+delim+"ASCII"+delim+
                                   "K"+delim+"CURSOR"+delim+
                                   "V"+delim+"VERBOSE"+delim+
                                   "I"+delim+"SHOW"+delim+
                                   "US"+delim+"UK"+delim+"ENGLISH"+delim+
                                   "F:"+delim+"FORMAT:"+delim+
                                   "C"+delim+"CENTER"+delim+
                                   "W:"+delim+"WAIT:"+delim+
                                   "M:"+delim+"MOTION:"+delim+
                                   "II"+delim+"SHOWDOUBLE"
                               );
            CASE opt OF
            | 1,2,3 :abort(errHelp,"");
            | 4,5: IF getCard(minink,maxink,S,ink)=FALSE THEN abort(errNumber,S); END;
            | 6,7: IF getCard(minpaper,maxpaper,S,paper)=FALSE THEN abort(errNumber,S); END;
            | 8,9: IF getCard(minspeed,maxspeed,S,speed)=FALSE THEN abort(errNumber,S); END;
            | 10,11:stopmouse:=TRUE;
            | 12,13:IF getCard(minproba,maxproba,S,seuilbirth)=FALSE THEN abort(errNumber,S); END;
            | 14,15:IF getCard(minproba,maxproba,S,seuiltwinkle)=FALSE THEN abort(errNumber,S); END;
            | 16,17:IF getCard(minproba,maxproba,S,seuileraser)=FALSE THEN abort(errNumber,S); END;
            | 18,19:IF getCard(minchar,maxchar,S,lowerchar)=FALSE THEN abort(errNumber,S); END;
                    currfont:=MAX(CARDINAL);
            | 20,21:IF getCard(minchar,maxchar,S,upperchar)=FALSE THEN abort(errNumber,S); END;
                    currfont:=MAX(CARDINAL);
            | 22,23: getFontParms(101,lowerchar,upperchar,currfont);
            | 24,25: getFontParms(102,lowerchar,upperchar,currfont);
            | 26,27: getFontParms(103,lowerchar,upperchar,currfont);
            | 28,29: getFontParms(104,lowerchar,upperchar,currfont);
            | 30,31:IF getCard(minvelocity,maxvelocity,S,uppervelocity)=FALSE THEN abort(errNumber,S); END;
            | 32,33:IF getCard(minproba,maxproba,S,seuilink)=FALSE THEN abort(errNumber,S); END;
            | 34,35:myfont:=TRUE;
            | 36,37:fullreset := TRUE; (* should be useless but... *)
            | 38: myfont:=TRUE;getFontParms(0,lowerchar,upperchar,currfont);
            | 39: myfont:=TRUE;getFontParms(1,lowerchar,upperchar,currfont);
            | 40: myfont:=TRUE;getFontParms(2,lowerchar,upperchar,currfont);
            | 41: myfont:=TRUE;getFontParms(3,lowerchar,upperchar,currfont);
            | 42: myfont:=TRUE;getFontParms(4,lowerchar,upperchar,currfont);
            | 43,44: myfont:=TRUE;getFontParms(5,lowerchar,upperchar,currfont);
            | 45,46:
                CASE forcedlines OF
                | 0,25: forcedlines:=25;
                | 50  : abort(errEither25or50,"");
                END;
            | 47,48:
                CASE forcedlines OF
                | 0,50: forcedlines:=50;
                | 25  : abort(errEither25or50,"");
                END;
            |49,50:
                scroll:=TRUE;
            |51,52: getFontParms(100,lowerchar,upperchar,currfont);
            |53,54: fixcursor := FALSE;
            |55,56: verbose:=TRUE;
            |57,58: showstring:=TRUE;wideframe:=TRUE;
            |59,60,61: language:=english;
            |62,63: GetString(S,format); (* keep CASE *)
            |64,65: centered:=TRUE;
            |66,67: IF getCard(minshowmefor,maxshowmefor,S,showmefor)=FALSE THEN abort(errNumber,S); END;
            |68,69: IF getCard(ORD(downwards),ORD(rightwards),S,motioncode)=FALSE THEN abort(errNumber,S); END;
                    motion:=motiontype(motioncode);
            |70,71: showstring:=TRUE;wideframe:=FALSE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            abort(errParameter,S);
        END;
    END;

    lastcol  := bioscols;
    lastrow  := CARDINAL(biosrows)+1;
    lastcell := (lastcol * lastrow);

    IF lastcol > maxCol THEN abort(errUnexpected,"columns");END;
    IF lastrow > maxRow THEN abort(errUnexpected,"rows");END;
    IF lastcell > (maxcell+1) THEN abort(errUnexpected,"cells");END;

    IF forcedlines # UNDEFINED THEN
       IF forcedlines # lastrow THEN  (* we'll ignore result *)
           CASE forcedlines OF
           | 25: chk:= set25LineMode ();
           | 50: chk:= set50LineMode ();
           END;
           (* reload them ! *)
           lastcol  := bioscols;
           lastrow  := CARDINAL(biosrows)+1;
           lastcell := (lastcol * lastrow);
           (* retest them ! *)
           IF lastcol > maxCol THEN abort(errUnexpected,"columns");END;
           IF lastrow > maxRow THEN abort(errUnexpected,"rows");END;
           IF lastcell > (maxcell+1) THEN abort(errUnexpected,"cells");END;
        END;
    END;

    IF upperchar < lowerchar THEN
       i:=upperchar;
       upperchar:=lowerchar;
       lowerchar:=i;
    END;
    INC(uppervelocity);

    inkfade:=getfaded(ink,darker);
    initYbase(lastrow,lastcol);

    IF fixcursor THEN
        setCursorShape (saveoldcursor);
        setCursorShape (invisiblecursor);
    END;

    IF myfont THEN
        bytesPerChar := allowablelinecount (lastrow);
        IF bytesPerChar = MAX(CARDINAL) THEN
            myfont:=FALSE;
        ELSE
            setCharGen(bytesPerChar);
        END;
    END;

    IF same(format,"") THEN
        CASE language OF
        | french  : Str.Copy(format,defaultFmtFR);
        | english : Str.Copy(format,defaultFmtUS);
        END;
    END;

    vid2sav(lastcell);

    cls(blank,paper,ink,normal,lastcell,lastrow,lastcol,0);

    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;

    showoldseconds:=initoldseconds;
    InitRnd;
    rain (motion,init,lastrow,lastcol,ink,inkfade,paper,speed,lastcell,
          seuilbirth,seuiltwinkle,seuileraser,seuilink,
          lowerchar,upperchar,uppervelocity,scroll,showstring,wideframe,centered,myfont);
    flushKeyboard;
    singlestep:=FALSE;
    LOOP
        rain (motion,update,lastrow,lastcol,ink,inkfade,paper,speed,lastcell,
              seuilbirth,seuiltwinkle,seuileraser,seuilink,
              lowerchar,upperchar,uppervelocity,scroll,showstring,wideframe,centered,myfont);

        (* read and process key *)
        IF singlestep THEN
            WHILE getKeyboardCode(keycode,shifted)=FALSE DO
            END;
            chk:=(keycode # keySpace);
            singlestep:=NOT(chk);
        ELSE
            chk:=getKeyboardCode(keycode,shifted);
        END;
        IF chk THEN
            CASE keycode OF
            | keyEscape : EXIT;
            | keyCR     : EXIT;
            | keySpace  : singlestep:=NOT (singlestep);
            | keyPlus :
                CASE currfont OF
                | 0..4:     INC(currfont); getFontParms(currfont,lowerchar,upperchar,currfont);
                | 5:        currfont:=0;   getFontParms(currfont,lowerchar,upperchar,currfont);
                | 100..103: INC(currfont); getFontParms(currfont,lowerchar,upperchar,currfont);
                | 104:      currfont:=100; getFontParms(currfont,lowerchar,upperchar,currfont);
                END;
                (* yes, we should reinit display... *)
            | keyMinus:
                CASE currfont OF
                | 1..5:     DEC(currfont); getFontParms(currfont,lowerchar,upperchar,currfont);
                | 0:        currfont:=5;   getFontParms(currfont,lowerchar,upperchar,currfont);
                | 101..104: DEC(currfont); getFontParms(currfont,lowerchar,upperchar,currfont);
                | 100:      currfont:=104; getFontParms(currfont,lowerchar,upperchar,currfont);
                END;
                (* yes, we should reinit display... *)
            | keyUpperS,keyLowerS : scroll    :=NOT(scroll);
            | keyUpperI,keyLowerI : showstring:=NOT(showstring);   showoldseconds:=initoldseconds;
            | keyUpperC,keyLowerC : centered  :=NOT(centered);     showoldseconds:=initoldseconds;
            | keyUpperW,keyLowerW : wideframe:=NOT(wideframe); showoldseconds:=initoldseconds;
            | keyPgDn:  IF speed < maxspeed THEN INC(speed);END;
            | keyPgUp:  IF speed > minspeed THEN DEC(speed);END;
            | keyCtrlR : restoremostdefaults;
                         cls(blank,paper,ink,normal,lastcell,lastrow,lastcol,0);
                         rain (motion,init,lastrow,lastcol,ink,inkfade,paper,speed,lastcell,
                         seuilbirth,seuiltwinkle,seuileraser,seuilink,
                         lowerchar,upperchar,uppervelocity,scroll,showstring,wideframe,centered,myfont);

            (* remember shifted codes are different here ! *)

            | keyF1,skeyF1 : newvar(minink,maxink,shifted,ink); inkfade:=getfaded(ink,darker);
            | keyF2,skeyF2 : newvar(minpaper,maxpaper,shifted,paper);
            | keyF3,skeyF3 : newvar(minproba,maxproba,shifted,seuilink);
            | keyF4,skeyF4 : newvar(minvelocity,maxvelocity,shifted,uppervelocity);
            | keyF5,skeyF5 : newvar(minproba,maxproba,shifted,seuilbirth);
            | keyF6,skeyF6 : newvar(minproba,maxproba,shifted,seuiltwinkle);
            | keyF7,skeyF7 : newvar(minproba,maxproba,shifted,seuileraser);

            (* not too pretty but who cares ? *)

            | keyDown  : newmotion:=downwards;
                         IF newmotion # motion THEN
                             cls(blank,paper,ink,normal,lastcell,lastrow,lastcol,0);
                             rain (newmotion,init,lastrow,lastcol,ink,inkfade,paper,speed,lastcell,
                             seuilbirth,seuiltwinkle,seuileraser,seuilink,
                             lowerchar,upperchar,uppervelocity,scroll,showstring,wideframe,centered,myfont);
                             motion:=newmotion;
                         END;
            | keyUp    : newmotion:=upwards;
                         IF newmotion # motion THEN
                             cls(blank,paper,ink,normal,lastcell,lastrow,lastcol,0);
                             rain (newmotion,init,lastrow,lastcol,ink,inkfade,paper,speed,lastcell,
                             seuilbirth,seuiltwinkle,seuileraser,seuilink,
                             lowerchar,upperchar,uppervelocity,scroll,showstring,wideframe,centered,myfont);
                             motion:=newmotion;
                         END;
            | keyRight : newmotion:=rightwards;
                         IF newmotion # motion THEN
                             cls(blank,paper,ink,normal,lastcell,lastrow,lastcol,0);
                             rain (newmotion,init,lastrow,lastcol,ink,inkfade,paper,speed,lastcell,
                             seuilbirth,seuiltwinkle,seuileraser,seuilink,
                             lowerchar,upperchar,uppervelocity,scroll,showstring,wideframe,centered,myfont);
                             motion:=newmotion;
                         END;
            | keyLeft  : newmotion:=leftwards;
                         IF newmotion # motion THEN
                             cls(blank,paper,ink,normal,lastcell,lastrow,lastcol,0);
                             rain (newmotion,init,lastrow,lastcol,ink,inkfade,paper,speed,lastcell,
                             seuilbirth,seuiltwinkle,seuileraser,seuilink,
                             lowerchar,upperchar,uppervelocity,scroll,showstring,wideframe,centered,myfont);
                             motion:=newmotion;
                         END;
            END;
        END;
        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;
    END;
  IF keycode=keyEscape THEN
    cls(blank,paper,ink,normal,lastcell,lastrow,lastcol,0);
  ELSE
    rain (motion,terminate,lastrow,lastcol,ink,inkfade,paper,speed,lastcell,
         seuilbirth,seuiltwinkle,seuileraser,seuilink,
         lowerchar,upperchar,uppervelocity,scroll,showstring,wideframe,centered,myfont);
  END;
    (* sav2vidATTR(lastcell); (* restore blinking cursor now *) *)
    sav2vid(lastcell);

    IF fixcursor THEN setCursorShape (oldcursor);END;

    IF myfont THEN resetCharGen(lastrow,fullreset); END;

    IF verbose THEN dumpParms( motion,ink,inkfade,paper,speed,
                               seuilbirth,seuiltwinkle,seuileraser,seuilink,
                               lowerchar,upperchar,uppervelocity,showmefor,
                               scroll,showstring,centered,
                               language,format);
    END;

    abort(errNone,"");
END Matrix.

