(* ---------------------------------------------------------------
Title         Q&D Grid Run
Overview      animate text screen with blinking lights
Notes         assume VGA and page 0
              not very pretty after all... just Yet Another Real Waste Of Time !
Bugs          genTrail had to be patched as not to lock program in an infinite loop
              weird visual artifact even though we wait for retrace :
              blurred and doubled dots (persistence of vision ?)
              still here whatever we've tried : cycle erase/update,
              force clear screen, redraw motionless... bah, after all...
Wish List     just kidding...

--------------------------------------------------------------- *)

MODULE GridRun;

IMPORT IO;
IMPORT SYSTEM;
IMPORT Lib;
IMPORT Str;
IMPORT MsMouse;
IMPORT BiosIO;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs,
completedInit, completedShow, completedSHOW, completedEnd, completed;

FROM QD_rand IMPORT InitRnd, GetRnd,
GetRndCardRange, GetRndLngCardRange,
GetRndLngRealRange, GetRndRealRange;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    minspeed          = 0;
    maxspeed          = 32-1;
    minpercent        = 0;
    maxpercent        = 100;
    minvelocity       = 1;
    maxvelocity       = 8;
    defaultpercent    = 50;
    defaultuppervelocity = 2;

PROCEDURE msg2 (VAR R: ARRAY OF CHAR; S1,S2:ARRAY OF CHAR);
BEGIN
    Str.Concat(R,S1,S2);
END msg2;

PROCEDURE msg3 (VAR R: ARRAY OF CHAR; S1,S2,S3:ARRAY OF CHAR);
BEGIN
    Str.Concat(R,S1,S2);Str.Append(R,S3);
END msg3;

CONST
    ProgEXEname   = "GRIDRUN";
    ProgTitle     = "Q&D GridRun";
    ProgVersion   = "v1.0b";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errParameter    = 3;
    errNumber       = 4;
    errUnexpected   = 5;
    errEither25or50 = 6;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    nl = CHR(13)+CHR(10);
    helpmsg =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" [option]..."+nl+
nl+
"-p:#  paper [0..7], default is 0"+nl+
"-i:#  ink [8..15], default is 10"+nl+
"-s:#  speed [0..31], default is 1"+nl+
"-m    exit on mouseclick too (default is on Escape or Return keys)"+nl+
"-b    block characters (default is BIOS dots)"+nl+
"-f?   use private redefined VGA font (fd=dots, fs=squares)"+nl+
"      mode must be 80x25, 80x50, 80x28 or 80x43"+nl+
"-t:#  trail mode (0=normal, 1=long normal, 2=pulse, 3=small dot, 4=big dot)"+nl+
"-f:#  percentage filled [0..100], default is 50"+nl+
"-v:#  upper velocity [1..8], default is 2"+nl+
"-s    background filled with spaces"+nl+
"-o    random colors"+nl+
"-r    reset cursor at program exit (probably useless and valid with -f option)"+nl+
"-k    do not fix cursor shape"+nl+
"-2    force 25 lines mode"+nl+
"-5    force 50 lines mode"+nl+
"-v    show parameters at program exit"+nl+
nl+
"[Space]-step, [Escape|Return]-exit"+nl+
"[PageUp|PageDown]-speed, [+|-]-percentage, [C]-color, [T]-trail"+nl+
nl+
"Dark [0..7] : black, blue, green, cyan, red, magenta, brown and gray."+nl+
"Bright [8..15] : gray, blue, green, cyan, red, magenta, yellow and white.";

VAR
    S : str128;
BEGIN
    CASE e OF
    | errOption:       msg3 (S,"Unknown ",einfo," option !");
    | errParameter:    msg3 (S,"Uneeded ",einfo," parameter !");
    | errNumber:       msg3 (S,"Illegal or out of range ",einfo," number !");
    | errUnexpected:   msg3 (S,"Unexpected number of ",einfo," !");
    | errEither25or50: S := "-25 and -50 options are mutually exclusive !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone:
        ;
    | errHelp:
        WrLn;
        WrStr(helpmsg);WrLn;
    ELSE
        WrLn;
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

PROCEDURE getCard (lower,upper:CARDINAL;S:ARRAY OF CHAR;VAR n : CARDINAL):BOOLEAN;
VAR
    v:LONGCARD;
BEGIN
    IF GetLongCard(S,v)=FALSE THEN RETURN FALSE;END;
    IF v > MAX(CARDINAL) THEN RETURN FALSE; END;
    n:=CARDINAL(v);
    IF n < lower THEN RETURN FALSE; END;
    IF n > upper THEN RETURN FALSE; END;
    RETURN TRUE;
END getCard;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE waitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END waitVGAretrace;

PROCEDURE pause (n:CARDINAL);
VAR
    i:CARDINAL;
BEGIN
    FOR i := 1 TO n DO
        waitVGAretrace();
    END;
END pause;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := (ORD(c1) << 8) + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

(* ------------------------------------------------------------ *)

CONST
    sb = 040H; (* segBiosData *)
VAR
    bioscols  [sb:004AH] : CARDINAL;
    biosrows  [sb:0084H] : SHORTCARD; (* add 1 *)

CONST
    minCol    = 1;
    maxCol    = 132;
    minRow    = 1;
    maxRow    = 60;
    firstcell = 0;
    maxcell   = (maxCol * maxRow) -1;
TYPE
    vcell = RECORD
        ch   : CHAR;
        attr : SHORTCARD;
    END;
VAR
    screen [0B800H:0000H] : ARRAY [firstcell..maxcell] OF vcell;
    savscr                : ARRAY [firstcell..maxcell] OF vcell;
    workscr               : ARRAY [firstcell..maxcell] OF vcell;
    Ybase     : ARRAY [minRow..maxRow] OF CARDINAL;

PROCEDURE initYbase (lastrow,lastcol:CARDINAL);
VAR
    i,p:CARDINAL;
BEGIN
    p := 0;
    FOR i := minRow TO lastrow DO
        Ybase[i]:=p;
        INC(p,lastcol);
    END;
END initYbase;

PROCEDURE plot (x,y:CARDINAL;ch:CHAR;attr:SHORTCARD);
VAR
    p : CARDINAL;
BEGIN
    p := Ybase[y]+x-minCol;    (* remember first column is 1, not 0 *)
    screen[p].ch   := ch;
    screen[p].attr := attr;
END plot;

PROCEDURE plotch (x,y:CARDINAL;ch:CHAR);
VAR
    p : CARDINAL;
BEGIN
    p := Ybase[y]+x-minCol;    (* remember first column is 1, not 0 *)
    screen[p].ch   := ch;
END plotch;

PROCEDURE radar (x,y:CARDINAL):CHAR;
VAR
    p : CARDINAL;
BEGIN
    p := Ybase[y]+x-minCol;    (* remember first column is 1, not 0 *)
    RETURN screen[p].ch;
END radar;

PROCEDURE vradar (x,y:CARDINAL):vcell;
VAR
    p : CARDINAL;
BEGIN
    p := Ybase[y]+x-minCol;    (* remember first column is 1, not 0 *)
    RETURN screen[p];
END vradar;

(* force far here ! *)

PROCEDURE pushscreen (lastcell:CARDINAL);
BEGIN
    Lib.FarWordMove(FarADR(screen),FarADR(savscr),lastcell); (* each cell is a WORD *)
END pushscreen;

PROCEDURE popscreen (lastcell:CARDINAL);
BEGIN
    Lib.FarWordMove(FarADR(savscr),FarADR(screen),lastcell); (* each cell is a WORD *)
END popscreen;

PROCEDURE popattributes (lastcell:CARDINAL);
VAR
    i:CARDINAL;
BEGIN
    FOR i := firstcell TO lastcell DO
        screen[i].attr := screen[i].attr OR ((savscr[i].attr AND 0FH));
    END;
END popattributes;

PROCEDURE work2screen (lastcell:CARDINAL);
BEGIN
    Lib.FarWordMove(FarADR(workscr),FarADR(screen),lastcell); (* each cell is a WORD *)
END work2screen;

PROCEDURE wplot (x,y:CARDINAL;ch:CHAR;attr:SHORTCARD);
VAR
    p : CARDINAL;
BEGIN
    p := Ybase[y]+x-minCol;    (* remember first column is 1, not 0 *)
    workscr[p].ch   := ch;
    workscr[p].attr := attr;
END wplot;

(* ------------------------------------------------------------ *)

TYPE
    inktype = (black,blue,green,cyan,red,magenta,brown,white,
               gray,bblue,bgreen,bcyan,bred,bmagenta,yellow,bwhite);
CONST
    mincolor = ORD(black);
    maxcolor = ORD(bwhite);
    minink   = ORD(gray);
    maxink   = ORD(bwhite);
    minpaper = ORD(black);
    maxpaper = ORD(white);
    darker   = ORD(white)-ORD(black)+1;
    brightest= ORD(bwhite);

PROCEDURE paperink (color:inktype) : SHORTCARD;
BEGIN
    RETURN SHORTCARD(ORD(color));
END paperink;

CONST
    blank = " ";
TYPE
    cleartype = (normal);

PROCEDURE cls (char : CHAR; paper,ink : CARDINAL; clear : cleartype; lastrow,lastcol,delay : CARDINAL);
VAR
    x,y : CARDINAL;
    attribute : SHORTCARD;
BEGIN
    attribute := paperink( inktype(paper)) << 4 OR SHORTCARD(inktype(ink));
    CASE clear OF
    | normal :
        FOR y := minRow TO lastrow DO
            FOR x := minCol TO lastcol DO
                plot(x,y,char,attribute);
            END;
        END;
    END;
END cls;

PROCEDURE wcls (char : CHAR; paper,ink : CARDINAL; clear : cleartype; lastrow,lastcol,delay : CARDINAL);
VAR
    x,y : CARDINAL;
    attribute : SHORTCARD;
BEGIN
    attribute := paperink( inktype(paper)) << 4 OR SHORTCARD(inktype(ink));
    CASE clear OF
    | normal :
        FOR y := minRow TO lastrow DO
            FOR x := minCol TO lastcol DO
                wplot(x,y,char,attribute);
            END;
        END;
    END;
END wcls;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    CO80 = BYTE(3); (* color 80x25 *)
    MONO = BYTE(7); (* monochrome *)
CONST
    iv = 010H; (* video interrupt is $10 *)
VAR
    biosCurrentVideoMode  [sb:049H] : BYTE;

PROCEDURE isMonoMode ():BOOLEAN;
BEGIN
    RETURN (biosCurrentVideoMode = MONO);
END isMonoMode;

PROCEDURE set25LineMode () : BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    (* select vertical resolution vga *)
    R.AH := 12H;
    R.BL := 30H;
    R.AL := 02H;        (* 0=200, 1=350, 2=400 *)
    Lib.Intr(R,iv);     (* al=$12 if function supported *)
    IF R.AL # 12H THEN RETURN FALSE; END;
    (* set video mode *)
    R.AH := 00H;
    R.AL := CO80;
    Lib.Intr(R,iv);
    RETURN TRUE;
END set25LineMode;

PROCEDURE set50LineMode (  ) : BOOLEAN;
VAR
    R : SYSTEM.Registers;
BEGIN
    IF isMonoMode() THEN RETURN FALSE; END;
    (* select vertical resolution vga *)
    R.AH := 12H;
    R.BL := 30H;
    R.AL := 02H;        (* 0=200, 1=350, 2=400 *)
    Lib.Intr(R,iv);     (* al=$12 if function supported *)
    IF R.AL # 12H THEN RETURN FALSE; END;
    (* set video mode *)
    R.AH := 00H;
    R.AL := CO80;
    Lib.Intr(R,iv);
    (* load rom 8x8 dbl-dot patterns *)
    R.AH := 11H;
    R.AL := 12H;
    R.BL := 00H;        (* load block 0 *)
    Lib.Intr(R,iv);
    RETURN TRUE;
END set50LineMode;

(* ------------------------------------------------------------ *)

VAR
    oldCursorShape : CARDINAL;

PROCEDURE setTextCursorShape (scanlines:CARDINAL );
VAR
    R : SYSTEM.Registers;
BEGIN
    R.CX := scanlines;
    R.AH := 01H; (* set text-mode cursor shape *)
    Lib.Intr(R,iv);
END setTextCursorShape;

TYPE
    cursorshapetype = (saveoldcursor, invisiblecursor, oldcursor);

PROCEDURE setCursorShape (shape:cursorshapetype);
VAR
    biosCursorType [sb:060H] : WORD;
    scanlines : CARDINAL;
BEGIN
    CASE shape OF
    | invisiblecursor: (* bits 6,5 : 01 *)
        IF isMonoMode () THEN
            scanlines := 02D0EH; (* 2b0c *)
        ELSE
            scanlines := 02607H;
        END;
    | oldcursor:
        scanlines := oldCursorShape;
    | saveoldcursor:
        oldCursorShape := biosCursorType;
        RETURN; (* force it here *)    END;
    setTextCursorShape(scanlines);
END setCursorShape;

(* ------------------------------------------------------------ *)

(* adapted from LOADFONT *)

CONST
    legallinecount25 = 25;
    legallinecount28 = 28;
    legallinecount43 = 43;
    legallinecount50 = 50;
    legallinecount30 = 30;

PROCEDURE allowablelinecount (current: CARDINAL ):CARDINAL ; (* return bytesPerChar *)
BEGIN
    CASE current OF
    | legallinecount25,legallinecount28,legallinecount30:RETURN 16;
    | legallinecount50,legallinecount43:RETURN 8;
    ELSE
        RETURN MAX(CARDINAL);
    END;
END allowablelinecount;

(* clear screen then reset chargen *)

CONST
    videoBIOS = 10H;

PROCEDURE resetCharGen (lines : CARDINAL;fullreset:BOOLEAN );
CONST
    block     = 00H; (* block to load must be 0, else ugly results ! *)
VAR
    R : SYSTEM.Registers;
    columns,displaymode,activepage:SHORTCARD;
    cursorstart,cursorend,cursorcolumn,cursorrow:SHORTCARD;
    fontheight [0040H:0085H] : CARDINAL;

    oldscanlines : CARDINAL;
    newscanlines : CARDINAL;
    newcursorstart,newcursorend:CARDINAL;
    setpattern:CARDINAL;
BEGIN
    CASE lines OF
    | legallinecount50, legallinecount43 :
        setpattern := 1112H; (* 8x8 ROM DBL-dot patterns EGA/VGA *)
    | legallinecount28,legallinecount30 :
        setpattern := 1111H; (* 8x14 ROM monochrome patterns EGA/VGA *)
    | legallinecount25 :
        setpattern := 1114H; (* 8x16 ROM VGA *)
    ELSE
        RETURN;
    END;

    (* pattern MUST be $111x because $110x does NOT work : Matrox strikes again ! *)
    (* block other than 0 is a no-no *)

IF fullreset THEN
    oldscanlines := fontheight;

    R.AH := 0FH;           (* get current video mode *)
    Lib.Intr(R,videoBIOS);
    columns     := R.AH;
    displaymode := R.AL;   (* bit 7 can be ON if previous mode setting was so *)
    activepage  := R.BH;

    R.AH := 03H;           (* get cursor position and size *)
    R.BH := activepage;
    Lib.Intr(R,videoBIOS);
    cursorstart := R.CH;
    cursorend   := R.CL;
    cursorcolumn:= R.DL;
    cursorrow   := R.DH;

    R.AH := 00H;           (* set video mode *)
    R.AL := displaymode;
    Lib.Intr(R,videoBIOS);
END;

    R.AX := setpattern;
    R.BL := SHORTCARD(block);
    Lib.Intr(R,videoBIOS);

    (*
    R.AX := 1130H;         (* get font information *)
    R.BL := 00H;           (* dummy, just in case : get int $1F pointer *)
    Lib.Intr(R,videoBIOS);
    scanlines := SHORTCARD(R.CX);  (* pixels per char, same as $0040:0085 (word) *)
    *)
IF fullreset THEN
    newscanlines := fontheight;

    newcursorstart := (newscanlines * CARDINAL(cursorstart)) DIV oldscanlines;
    newcursorend   := (newscanlines * CARDINAL(cursorend  )) DIV oldscanlines;

    R.AH := 01H;           (* set text-mode cursor shape *)
    R.CH := SHORTCARD(newcursorstart);
    R.CL := SHORTCARD(newcursorend);
    Lib.Intr(R,videoBIOS);
END;
END resetCharGen;

(* ------------------------------------------------------------ *)

CONST
    firstredefined    = 0; (* use control chars from CHR(0) *)
    privatecount      = 6; (* 3 dots from large to small, then 3 squares *)
    charsize25        = 16; (* 4096/256 *)
    charsize50        = 8;  (* 2048/256 *)
    charsizemax       = charsize25; (* largest *)
    firstdata         = 0;
    maxdata           = privatecount*charsizemax-1;
TYPE
    set25type = ARRAY [firstdata..(privatecount*charsize25)-1] OF BYTE;
    set50type = ARRAY [firstdata..(privatecount*charsize50)-1] OF BYTE;
VAR
    fontbuffer : ARRAY [firstdata..maxdata] OF BYTE;
CONST
    set25 = set25type (
    000H,000H,000H,000H,000H,03CH,07EH,07EH,
    07EH,07EH,03CH,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,018H,03CH,
    03CH,018H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,018H,
    018H,000H,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,07EH,07EH,07EH,
    07EH,07EH,07EH,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,03CH,03CH,
    03CH,03CH,000H,000H,000H,000H,000H,000H,
    000H,000H,000H,000H,000H,000H,000H,018H,
    018H,000H,000H,000H,000H,000H,000H,000H);
    set50 = set50type (
    000H,03CH,07EH,07EH,07EH,07EH,03CH,000H,
    000H,000H,018H,03CH,03CH,018H,000H,000H,
    000H,000H,000H,018H,018H,000H,000H,000H,
    000H,07EH,07EH,07EH,07EH,07EH,07EH,000H,
    000H,000H,03CH,03CH,03CH,03CH,000H,000H,
    000H,000H,000H,018H,018H,000H,000H,000H);

PROCEDURE privateChars (bytesPerChar:CARDINAL);
VAR
    R : SYSTEM.Registers;
BEGIN
    CASE bytesPerChar OF (* FarMove while it should be useless ! *)
    | charsize50:
        Lib.FarMove(FarADR(set50),FarADR(fontbuffer),SIZE(set50));
    | charsize25:
        Lib.FarMove(FarADR(set25),FarADR(fontbuffer),SIZE(set25));
    ELSE
        RETURN;
    END;
    R.AX := 1100H;
    R.ES := Seg(FarADDRESS(fontbuffer)); (* es:bp -> user table *)
    R.BP := Ofs(FarADDRESS(fontbuffer));
    R.CX := privatecount;     (* count of patterns to store *)
    R.DX := firstredefined;   (* character offset into map 2 block *)
    R.BL := 0;   (* block to load in map 2 *)
    R.BH := BYTE(bytesPerChar); (* number of bytes per character pattern *)
    Lib.Intr(R,videoBIOS);
END privateChars;

(* ------------------------------------------------------------ *)

(*
    white,blue,cyan,bblue,bcyan,bwhite
    blue,white,...
*)

CONST
    head       = 0;
    headlong   = 1;
    pulse      = 2;
    single     = 3;
    singleblock= 4;
CONST
    mintrailmode=head;
    maxtrailmode=singleblock;
TYPE
    cmdtype     = (init,update,terminate);
    charsettype = (bios,biosblocks,dots,squares);
CONST
    ndxBig    = 0;
    ndxMedium = 1;
    ndxSmall  = 2;
    ndxEraser = 3;
TYPE
    s4 = ARRAY [ndxBig..ndxEraser] OF CHAR; (* big,medium,small,eraser *)

PROCEDURE initCharString (winactive,blankit:BOOLEAN; charset:charsettype;VAR R:s4);
VAR
    c0,c1,c2,c3:CHAR;
BEGIN
    CASE charset OF
    | bios:
        c0:=CHR(7);   (* 254 was not pretty *)
      IF winactive THEN
        c1:=CHR(250);
        c2:=CHR(250);
      ELSE
        c1:=CHR(249);
        c2:=CHR(249); (* 250 was not pretty either *)
      END;
    | biosblocks:
        c0:=CHR(219);
        c1:=CHR(177);
        c2:=CHR(176);
    | dots:
        c0:=CHR(firstredefined+1); (* +0 is too big *)
        c1:=CHR(firstredefined+1);
        c2:=CHR(firstredefined+2);
    | squares:
        c0:=CHR(firstredefined+4); (* +3 is too big *)
        c1:=CHR(firstredefined+4);
        c2:=CHR(firstredefined+5);
    END;
    IF (blankit OR (charset=biosblocks)) THEN
        c3:=blank;
    ELSE
        c3:=c2;
    END;
    R[ndxBig]    :=c0;
    R[ndxMedium] :=c1;
    R[ndxSmall]  :=c2;
    R[ndxEraser] :=c3;
END initCharString;

(* ------------------------------------------------------------ *)

CONST
    minndx=minCol;
    maxndx=maxCol+(maxRow-minRow+1) +1; (* useless safety just in case... *)
TYPE
    motiontype = (up,down,left,right);
    trailtype = RECORD
        active:BOOLEAN;
        x,y:INTEGER;        (* allow coords < 0 *)
        velocity:CARDINAL;
        currstep:CARDINAL;
        motion:motiontype;
        ink,inkfade:CARDINAL;
    END;
VAR
    trail : ARRAY [minndx..maxndx] OF trailtype;

PROCEDURE genFreeTrail (p,lastndx,lastrow,lastcol,uppervelocity,ink:CARDINAL;
                       multicolor:BOOLEAN);
VAR
    mv:motiontype;
    x,y,already,i,inkfade:CARDINAL;
BEGIN
    LOOP
        x:=GetRndCardRange(minCol,lastcol);
        y:=GetRndCardRange(minRow,lastrow);
        CASE GetRndCardRange(1,4) OF
        | 1: mv:=up;
        | 2: mv:=down;
        | 3: mv:=left;
        | 4: mv:=right;
        END;

        already:=0;
        (* prevent program being locked in an infinite loop ! check it later...
        FOR i:=minndx TO lastndx DO
            IF trail[i].active THEN
                CASE trail[i].motion OF
                | up,down:
                    IF trail[i].x=INTEGER(x) THEN INC(already);END;
                | left,right:
                    IF trail[i].y=INTEGER(y) THEN INC(already);END;
                END;
            END;
        END;
        *)
        IF already=0 THEN EXIT; END;
    END;

    IF multicolor THEN ink:=GetRndCardRange(minink,maxink); END;
    inkfade:=ink-darker;
    trail[p].ink:=ink;
    trail[p].inkfade:=inkfade;

    trail[p].x:=x;
    trail[p].y:=y;
    trail[p].motion:=mv;
    trail[p].velocity :=GetRndCardRange(minvelocity,uppervelocity);
    trail[p].currstep :=minvelocity;
    trail[p].active   :=TRUE;
END genFreeTrail;

PROCEDURE grid (cmd:cmdtype;
                lastrow,lastcol,ink,inkfade,paper,
                percent,uppervelocity,
                speed,trailmode:CARDINAL;
                blankit,multicolor:BOOLEAN; c:s4):BOOLEAN;
VAR
    str:ARRAY[1..16] OF vcell;
    lastndx,p,i,alive:CARDINAL;
    aink,afade,apaper,ahead,afadebk:SHORTCARD;
    ix,iy,lentrail,dx,dy:INTEGER;
    plotit,ok,movit:BOOLEAN;
    mv:motiontype;
BEGIN
    lastndx:=( (lastrow+lastcol)*percent) DIV 100;
    apaper:=SHORTCARD(paper) << 4;
    afadebk:=SHORTCARD(inkfade) + apaper;
    ahead:=SHORTCARD(brightest) + apaper;
    CASE cmd OF
    | init:
        FOR p:=minndx TO lastndx DO
            genFreeTrail(p,lastndx,lastrow,lastcol,uppervelocity,ink,multicolor);
        END;
        RETURN TRUE;
    | update,terminate:
        CASE trailmode OF
        | head:
            lentrail:=3;
            str[1].ch:=c[ndxBig];
            str[2].ch:=c[ndxMedium];
            str[3].ch:=c[ndxSmall];
        | headlong:
            lentrail:=6;
            str[1].ch:=c[ndxBig];
            str[2].ch:=c[ndxBig];
            str[3].ch:=c[ndxMedium];
            str[4].ch:=c[ndxMedium];
            str[5].ch:=c[ndxSmall];
            str[6].ch:=c[ndxSmall];
        | pulse:
            lentrail:=5;
            str[1].ch:=c[ndxSmall];
            str[2].ch:=c[ndxMedium];
            str[3].ch:=c[ndxBig];
            str[4].ch:=c[ndxMedium];
            str[5].ch:=c[ndxSmall];
        | single:
            lentrail:=1;
            str[1].ch:=c[ndxMedium];
        | singleblock:
            lentrail:=1;
            str[1].ch:=c[ndxBig];
        END;
        str[lentrail+1].ch:=c[ndxEraser]; str[lentrail+1].attr:=afadebk;

        (* pause(speed); *)

        wcls(c[ndxEraser],paper,inkfade,normal,lastrow,lastcol,0);

        alive:=0;
        FOR p:=minndx TO lastndx DO
            IF trail[p].active THEN
                INC(alive);
                INC( trail[p].currstep );
                IF trail[p].currstep > trail[p].velocity THEN
                    trail[p].currstep:=minvelocity;
                    movit := TRUE;
                ELSE
                    movit := FALSE;
                END;
                    plotit:=TRUE;
                    ix:=trail[p].x;
                    iy:=trail[p].y;
                    mv:=trail[p].motion;

                    CASE mv OF
                    | up:    dx:= 0; dy:= 1;
                    | down:  dx:= 0; dy:=-1;
                    | left:  dx:= 1; dy:= 0;
                    | right: dx:=-1; dy:= 0;
                    END;
                  IF movit THEN
                    CASE mv OF
                    | up:    DEC(iy);
                             IF iy < (minRow-lentrail) THEN plotit:=FALSE;END;
                    | down:  INC(iy);
                             IF iy > (INTEGER(lastrow)+lentrail) THEN plotit:=FALSE;END;
                    | left:  DEC(ix);
                             IF ix < (minCol-lentrail) THEN plotit:=FALSE;END;
                    | right: INC(ix);
                             IF ix > (INTEGER(lastcol)+lentrail) THEN plotit:=FALSE;END;
                    END;
                  END;
                    IF plotit THEN

                        aink:=SHORTCARD( trail[p].ink) + apaper;
                        afade:=SHORTCARD(trail[p].inkfade) + apaper;
                        CASE trailmode OF
                        | head:
                                        str[1].attr:=aink; (* ahead; *)
                                        str[2].attr:=aink;
                                        str[3].attr:=aink;
                        | headlong:
                                        str[1].attr:=aink; (* ahead; *)
                                        str[2].attr:=aink;
                                        str[3].attr:=aink;
                                        str[4].attr:=aink;
                                        str[5].attr:=aink;
                                        str[6].attr:=afade;
                        | pulse:
                                        str[1].attr:=aink;
                                        str[2].attr:=aink;
                                        str[3].attr:=aink; (* ahead; *)
                                        str[4].attr:=aink;
                                        str[5].attr:=aink;
                        | single:
                                        str[1].attr:=aink;
                        | singleblock:
                                        str[1].attr:=aink;
                        END;

                        trail[p].x:=CARDINAL(ix);
                        trail[p].y:=CARDINAL(iy);
                        FOR i:=1 TO CARDINAL(lentrail)+1 DO
                            ok:=TRUE;
                            IF ((ix<minCol) OR (ix > INTEGER(lastcol))) THEN ok:=FALSE; END;
                            IF ((iy<minRow) OR (iy > INTEGER(lastrow))) THEN ok:=FALSE; END;
                            IF ok THEN wplot (ix,iy,str[i].ch,str[i].attr); END;
                            INC(ix,dx);
                            INC(iy,dy);
                        END;
                    ELSE
                        trail[p].active:=FALSE; (* die before you're born again... perhaps ! *)
                        CASE cmd OF
                        | update :
                            (* always replace dead trail, and make trails appear from borders *)
                            genFreeTrail (p,lastndx,lastrow,lastcol,
                                         uppervelocity,ink,multicolor); (* always replace dead dot ! *)
                            CASE trail[p].motion OF
                            | up:    trail[p].y:=lastrow;
                            | down:  trail[p].y:=minRow;
                            | left:  trail[p].x:=lastcol;
                            | right: trail[p].x:=minCol;
                            END;
                        |terminate:
                            ;
                        END;
                    END;
                (* END; *)
            END;
        END;

        work2screen( (lastcol * lastrow) -1 );

        pause(speed);

        CASE cmd OF
        |update: RETURN TRUE;
        |terminate: RETURN (alive=0);
        END;
    END;
END grid;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    keyEscape  = 01B00H;
    keySpace   = 02000H;
    keyCR      = 00D00H;
    keyPgUp    = 00049H;
    keyPgDn    = 00051H;
    keyTab     = 00900H;
    keyShiftTab= 08F00H;
    keyUpperC  = ORD("C") << 8;
    keyLowerC  = ORD("c") << 8;
    keyUpperT  = ORD("T") << 8;
    keyLowerT  = ORD("t") << 8;
    keyPlus    = ORD("+") << 8;
    keyMinus   = ORD("-") << 8;
VAR
    ink,paper,speed,forcedlines,inkfade,trailmode:CARDINAL;
    percent,uppervelocity:CARDINAL;
    stopmouse,fixcursor,fullreset,myfont,blankit,multicolor,verbose:BOOLEAN;
    chk,singlestep,done:BOOLEAN;
    charset:charsettype;
VAR
    bytesPerChar,lastcol,lastrow,lastcell,keycode : CARDINAL;
    used:s4;
    winactive : BOOLEAN;
VAR
    parmcount, i, opt : CARDINAL;
    S,R : str128;
BEGIN
    Lib.DisableBreakCheck();
    (* WrLn; not here ! *)

    ink         :=ORD(bgreen);
    paper       :=ORD(black);
    speed       :=1;
    stopmouse   :=FALSE;
    forcedlines :=0;
    fixcursor   :=TRUE;
    fullreset   :=FALSE;
    myfont      :=FALSE;
    blankit     :=FALSE;
    multicolor  :=FALSE;
    trailmode   :=singleblock; (* was head *)
    charset     :=bios;
    percent     :=defaultpercent;
    uppervelocity:=defaultuppervelocity;
    verbose     :=FALSE;

    parmcount := Lib.ParamCount();
    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S); Str.Copy(R,S); UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "I:"+delim+"INK:"+delim+
                                   "P:"+delim+"PAPER:"+delim+
                                   "S:"+delim+"SPEED:"+delim+
                                   "M"+delim+"MOUSE"+delim+
                                   "2"+delim+"25"+delim+
                                   "5"+delim+"50"+delim+
                                   "K"+delim+"CURSOR"+delim+
                                   "R"+delim+"RESET"+delim+
                                   "FD"+delim+"DOTS"+delim+
                                   "FS"+delim+"SQUARES"+delim+
                                   "T:"+delim+"TRAILS:"+delim+
                                   "S"+delim+"SPACES"+delim+
                                   "B"+delim+"BLOCKS"+delim+
                                   "F:"+delim+"FILLED:"+delim+
                                   "V:"+delim+"VELOCITY:"+delim+
                                   "O"+delim+"MULTICOLOR"+delim+
                                   "V"+delim+"VERBOSE"
                               );
            CASE opt OF
            | 1,2,3 :abort(errHelp,"");
            | 4,5: IF getCard(minink,maxink,S,ink)=FALSE THEN abort(errNumber,S); END;
            | 6,7: IF getCard(minpaper,maxpaper,S,paper)=FALSE THEN abort(errNumber,S); END;
            | 8,9: IF getCard(minspeed,maxspeed,S,speed)=FALSE THEN abort(errNumber,S); END;
            | 10,11:stopmouse:=TRUE;
            | 12,13:
                CASE forcedlines OF
                | 0,25: forcedlines:=25;
                | 50  : abort(errEither25or50,"");
                END;
            | 14,15:
                CASE forcedlines OF
                | 0,50: forcedlines:=50;
                | 25  : abort(errEither25or50,"");
                END;
            | 16,17: fixcursor := FALSE;
            | 18,19: fullreset := TRUE;
            | 20,21: myfont    := TRUE; charset:=dots;
            | 22,23: myfont    := TRUE; charset:=squares;
            | 24,25: IF getCard(mintrailmode,maxtrailmode,S,trailmode)=FALSE THEN abort(errNumber,S); END;
            | 26,27: blankit:=TRUE;
            | 28,29: charset:=biosblocks;
            | 30,31:IF getCard(minpercent,maxpercent,S,percent)=FALSE THEN abort(errNumber,S); END;
            | 32,33:IF getCard(minvelocity,maxvelocity,S,uppervelocity)=FALSE THEN abort(errNumber,S); END;
            | 34,35:multicolor:=TRUE;
            | 36,37: verbose:=TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            abort(errParameter,S);
        END;
    END;

    lastcol  := bioscols;
    lastrow  := CARDINAL(biosrows)+1;
    lastcell := (lastcol * lastrow);

    IF lastcol > maxCol THEN abort(errUnexpected,"columns");END;
    IF lastrow > maxRow THEN abort(errUnexpected,"rows");END;
    IF lastcell > (maxcell+1) THEN abort(errUnexpected,"cells");END;

    IF forcedlines # lastrow THEN  (* we'll ignore result *)
       CASE forcedlines OF
       | 25: chk:= set25LineMode ();
       | 50: chk:= set50LineMode ();
       END;
       (* reload them ! *)
       lastcol  := bioscols;
       lastrow  := CARDINAL(biosrows)+1;
       lastcell := (lastcol * lastrow);
    END;

    inkfade:=ink-darker;
    initYbase(lastrow,lastcol);

    IF fixcursor THEN
        setCursorShape (saveoldcursor);
        setCursorShape (invisiblecursor);
    END;

    IF myfont THEN
        bytesPerChar := allowablelinecount (lastrow);
        IF bytesPerChar = MAX(CARDINAL) THEN
            myfont:=FALSE;
        ELSE
            privateChars(bytesPerChar);
        END;
    END;

    winactive := (runningWindows() OR warning95() );

    pushscreen(lastcell);

    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;

    InitRnd;

    initCharString(winactive,blankit,charset,used);
    IF blankit THEN
        cls(blank,paper,inkfade,normal,lastrow,lastcol,0);
    ELSE
        cls(used[ndxEraser],paper,inkfade,normal,lastrow,lastcol,0);
    END;
    done:=grid (init,lastrow,lastcol,ink,inkfade,paper,
         percent,uppervelocity,
         speed,trailmode,blankit,multicolor,used);

    flushKeyboard;
    singlestep:=FALSE;
    LOOP
        done:=grid (update,lastrow,lastcol,ink,inkfade,paper,
             percent,uppervelocity,
             speed,trailmode,blankit,multicolor,used);
        (* read and process key *)
        IF singlestep THEN
            WHILE getKeyboardCode(keycode)=FALSE DO
            END;
            chk:=(keycode # keySpace);
            singlestep:=NOT(chk);
        ELSE
            chk:=getKeyboardCode(keycode);
        END;
        IF chk THEN
            CASE keycode OF
            | keyEscape : EXIT;
            | keyCR     : EXIT;
            | keySpace  : singlestep:=NOT (singlestep);
            | keyPgDn   : IF speed < maxspeed THEN INC(speed);END;
            | keyPgUp   : IF speed > minspeed THEN DEC(speed);END;
            | keyUpperC,keyLowerC: multicolor:=NOT(multicolor);
            | keyUpperT,keyLowerT:
                IF trailmode < maxtrailmode THEN
                    INC(trailmode);
                ELSE
                    trailmode:=mintrailmode;
                END;
                IF blankit THEN
                    cls(blank,paper,inkfade,normal,lastrow,lastcol,0);
                ELSE
                    initCharString(winactive,blankit,charset,used);
                    cls(used[ndxEraser],paper,inkfade,normal,lastrow,lastcol,0);
                END;

            | keyMinus,keyPlus:
                CASE keycode OF
                | keyMinus: IF percent < maxpercent THEN INC(percent);END;
                | keyPlus:  IF percent > minpercent THEN DEC(percent);END;
                END;
                IF blankit THEN
                    cls(blank,paper,inkfade,normal,lastrow,lastcol,0);
                ELSE
                    initCharString(winactive,blankit,charset,used);
                    cls(used[ndxEraser],paper,inkfade,normal,lastrow,lastcol,0);
                END;
                done:=grid (init,lastrow,lastcol,ink,inkfade,paper,
                           percent,uppervelocity,
                           speed,trailmode,blankit,multicolor,used);
            END;
        END;
        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;
    END;
    IF keycode=keyEscape THEN
        cls(blank,paper,inkfade,normal,lastrow,lastcol,0);
    ELSE
        REPEAT
            done:=grid (terminate,lastrow,lastcol,ink,inkfade,paper,
                       percent,uppervelocity,
                       speed,trailmode,blankit,multicolor,used);
        UNTIL done;
        cls(blank,paper,inkfade,normal,lastrow,lastcol,0);
    END;
    (* popattributes(lastcell); (* restore blinking cursor now *) *)
    popscreen(lastcell);

    IF fixcursor THEN setCursorShape (oldcursor);END;

    IF myfont THEN resetCharGen(lastrow,fullreset); END;

    IF verbose THEN
        WrLn;
        WrStr("Speed      : ");IO.WrCard(speed,-2);WrLn;
        WrStr("Trail mode : ");IO.WrCard(trailmode,-1);WrLn;
        WrStr("Percentage : ");IO.WrCard(percent,-3);WrLn;
        WrStr("Multicolor : ");IF multicolor THEN WrStr("Yes") ELSE WrStr("No");END;
        WrLn;
    END;

    abort(errNone,"");
END GridRun.
