
$CPU 8086

$OPTIMIZE SIZE
$COMPILE EXE

$DEBUG MAP OFF
$DEBUG PBDEBUG OFF

$LIB COM        OFF
$LIB CGA        ON              ' ON required by SCREEN 2 & 0
$LIB EGA        OFF
$LIB VGA        OFF
$LIB HERC       OFF
$LIB LPT        OFF
$LIB IPRINT     OFF
$LIB FULLFLOAT  OFF

$ERROR BOUNDS   OFF
$ERROR NUMERIC  OFF
$ERROR OVERFLOW OFF
$ERROR STACK    OFF

$FLOAT PROCEDURE

$COM    0
$STRING 16
$STACK  2048
$SOUND  1

$DIM ARRAY

$DYNAMIC
' $STATIC

$OPTION CNTLBREAK OFF

'--------------------------------------------------------------------

DEFINT A-Z
OPTION BINARY BASE 0

%False = 0
%True  = NOT %False

$LINK 	 "QDRAND.PBU" ' for mouse detection
$INCLUDE "QDRAND.DEF"
$LINK 	 "QDBOX.PBU" ' for mouse detection
$INCLUDE "QDBOX.DEF"

%FLAGS = 0
%AX    = 1
%BX    = 2
%CX    = 3
%DX    = 4
%SI    = 5
%DI    = 6
%BP    = 7
%DS    = 8
%ES    = 9

%eNone      = 0
%eNeedVGA   = 1
%eBadRange  = 2
%eWrongNumber=3

%Video          = &H10

%MinColor       = &H00
%MaxColor       = &HFF

%redpal 	    = 0
%greenpal 		= 1
%bluepal 		= 2

%defaultpal     = %bluepal

%DACWriteIndex  = &H03C8
%DACDataRegister= &H03C9

%Xpixels    = 320
%Ypixels    = 200

%xmin=0
%xmax=%xpixels-1
%ymin=0
%ymax=%ypixels-1

%firstcolor = &h00?
%lastcolor  = &h7F?

%minstepdrops=1
%maxstepdrops=50
%firstround	=1

%firstdrop = 1
%maxdrop   = 10000

%defaultlastdrop=2000

%smallincrement=50
%bigincrement  =200


%mingrav=1
%maxgrav=1000

%defaultgrav=7

%gravsmallincrement=1
%gravbigincrement=20

%minwind=-500
%maxwind=+500

%defaultwind=0

%windsmallincrement=1
%windbigincrement=10


%mindensity=0
%maxdensity=1
%defaultdensity=0

%minBrightness=0
%maxBrightness=1
%defaultBrightness=%minBrightness

%useMouse=%true

%pageup=73
%pagedn=81
%uparrow=72
%downarrow=80
%leftarrow=75
%rightarrow=77
%homekey=71
%endkey=79

type droptype
	x   as single
    y	as single
    xm 	as single
    ym	as single
end type

dim huge drop(%firstdrop:%maxdrop) as shared droptype

%hidden=1

DIM V(%xmin:%xmax,%ymin:%ymax+%hidden) AS shared BYTE

'--------------------------------------------------------------------

DECLARE SUB GetStrLoc() ' PowerBasic runtime library

SUB StdOut ( BYVAL Text AS STRING )
! push DS                    ; save DS FOR PowerBASIC
! push WORD Ptr Text         ; push STRING handle ON stack
! CALL GetStrLoc
! jcxz ExitStdOut
! mov  DS, DX
! mov  DX, AX
! mov  AH, &H40              ; DOS WRITE TO file
! mov  BX, 1                 ; file handle 1 is CONS
! INT  &H21
ExitStdOut:
! pop  DS
END SUB

SUB StdOutLn( BYVAL s as string )
CALL StdOut (s + CHR$(13, 10) )
END SUB

'--------------------------------------------------------------------

SUB ResetMode
SCREEN 2
SCREEN 0
END SUB

SUB SetMode13h              ' 320x200x256
REG %AX,&H13
CALL INTERRUPT %Video
END SUB

SUB WaitVGARetrace
!   mov dx,&h3DA
l1:
!   in al,dx
!   and al,&h08
!   jnz l1
l2:
!   in al,dx
!   and al,&h08
!   jz  l2
END SUB

FUNCTION IsVGA
IF BIT (pbvScrnCard,5) = 0 THEN
    IsVGA = %False
ELSE
    IsVGA = %True
END IF
END FUNCTION

'--------------------------------------------------------------------

sub setdac(byval index,red,green,blue)
OUT %DACWriteIndex,index
OUT %DACDataRegister, red
OUT %DACDataRegister, green
OUT %DACDataRegister, blue
end sub

sub makepal (byval n)
select case n
case %redpal
	FOR i = 0 TO 63
		call setdac(i   ,i ,0 ,0)
	next
	FOR i = 0 TO 63
		call setdac(i+64,63,i ,0)
	next
case %greenpal
	FOR i = 0 TO 63
		call setdac(i   ,0 ,i ,0)
	next
	FOR i = 0 TO 63
		call setdac(i+64,i ,63,0)
	next
case %bluepal
	FOR i = 0 TO 63
		call setdac(i   ,0 ,0 ,i)
	next
	FOR i = 0 TO 63
		call setdac(i+64,0 ,i ,63)
	next
end select
end sub

sub changedrop(count, byval value)
count=count+value
if count < %firstdrop then count=%firstdrop
if count > %maxdrop then count=%maxdrop
end sub

sub changegrav(count, byval value)
count=count+value
if count < %mingrav then count=%mingrav
if count > %maxgrav then count=%maxgrav
end sub

sub changewind(count, byval value)
count=count+value
if count < %minwind then count=%minwind
if count > %maxwind then count=%maxwind
end sub

sub initdrop(byval n)
for i=%firstdrop to n
	drop(i).y=%ymin
next
end sub

'--------------------------------------------------------------------

sub anim (byval lastdrop, byval grav, byval wind)
    FOR i = %firstdrop TO lastdrop
		x=drop(i).x
        y=drop(i).y
        IF x <%xmin or x > %xmax OR y <= %ymin or y >= %ymax THEN
            drop(i).x  = %xpixels \ 2  + getrndrange#(-2,2)
            drop(i).y  = %ymax-1
            drop(i).xm = getrndrange#( -1000, +1000) / 1000
            drop(i).ym = getrndrange#(  2000,  5000) / 1000
        ELSE
            xpos=x
            ypos=y
            V?(xpos,ypos)=%lastcolor

            incr drop(i).x,  drop(i).xm
            decr drop(i).y,  drop(i).ym ' we go UP
            decr drop(i).ym, GRAV / 100 ' we go UP
            incr drop(i).xm, WIND / 100
        END IF
    NEXT

end sub

SUB Show
s??=VARSEG(V?(%xmin,%ymin))
o??=VARPTR(V?(%xmin,%ymin))

! pushf                             ; old silly habit...
! push es
! push si
! push ds
! push di
! mov ax,s??
! mov es,ax
! mov si,o??                        ;es:si = source

! mov ax,&HA000
! mov ds,ax
! mov di,&H0000                     ;ds:di = destination

! mov dx,%ypixels                      ;dx = y
hline:
! mov cx,%xpixels                      ;cx = x

hlinefill:
! mov al,es:[si]
! mov ds:[di],al
! inc si
! inc di
! dec cx
! jnz hlinefill

! dec dx
! jnz hline

! pop di
! pop ds
! pop si
! pop es
! popf

END SUB

$if 0

sub smooth (byval density)
ax??=0
bx??=0
for y=%ymax to %ymin step -1
	for x=%xmax-1 to %xmin+1 step -1
        bx??=(bx?? and &hff00) +v?(x,y)
        ax??=ax??+bx??
        bx??=(bx?? and &hff00) +v?(x,y+1)
        ax??=ax??+bx??
        bx??=(bx?? and &hff00) +v?(x-1,y)
        ax??=ax??+bx??

        shift right ax??,2
        c?=ax?? and &h00ff
        v?(x,y)=c?
    next
next
end sub

$else

sub smooth(byval density)
count??=%xpixels * %ypixels
select case density
case %mindensity
	s??=VARSEG(V(%xmin,%ymin))
	! pushf                             ; old silly habit...
	! push es
	! push si
	! push ds
	! push di
    ! mov es, s??
    ! Mov di, count??
	! xor ax, ax
    ! Xor bx, bx
goon:
    ! Mov bl, es:[di]       ;x,y
    ! Add ax, bx

    ! Mov bl, es:[di + %xpixels] ;x,y+1
    ! Add ax, bx

    ! Mov bl, es:[di - 1]   ;x-1,y
    ! Add ax, bx

	! shr ax,1
	! shr ax,1
    ! Mov es:[di], al
    ! Dec di
    ! Jnz goon
	! pop di
	! pop ds
	! pop si
    ! pop es
	! popf
case %maxdensity
	s??=VARSEG(V(%xmin,%ymin))
	! pushf                             ; old silly habit...
	! push es
	! push si
	! push ds
	! push di
    ! mov es, s??
    ! Mov di, count??
zgoon:
	! xor bx,bx
    ! xor ax,ax

    ! Mov bl, es:[di]       ;x,y
    ! Add ax, bx

    ! Mov bl, es:[di + %xpixels] ;x,y+1
    ! Add ax, bx

    ! Mov bl, es:[di - 1]   ;x-1,y
    ! Add ax, bx

	! shr ax,1
	! shr ax,1
    ! Mov es:[di], al
    ! Dec di
    ! Jnz zgoon
	! pop di
	! pop ds
	! pop si
    ! pop es
	! popf
end select
end sub

$endif

'--------------------------------------------------------------------


exe$="FOUNTAIN"
stdoutln ""

density=%defaultdensity
lastdrop=%defaultlastdrop
grav=%defaultgrav
wind=%defaultwind ' < 0 = vers la gauche

IF IsVGA = %False THEN
    StdOut exe$+" : VGA card required !"
    END %eNeedVGA
END IF

cli$=UCASE$(COMMAND$)
REPLACE CHR$(9) WITH " " IN cli$
cli$=RTRIM$(LTRIM$(cli$))
select case cli$
case "?","-?","/?","-H","/H"
	stdoutln "Usage #1 : "+exe$
	stdoutln "Usage #2 : "+exe$+" <density> <wind> <gravity> <drops> <brightness>"
	stdoutln "Usage #3 : "+exe$+" <density> <wind> <gravity>"
    stdout   "           "+space$(len(exe$))
    stdoutln                    " <minDrops> <maxDrops> <stepDrops> <rounds> <brightness>"
    stdoutln ""
    stdoutln "    [R|G|B] to change color, [*] to reset defaults, [D|I] to change brightness,"
    stdoutln "    [+|-|PageUp|PageDown] to change number of drops, [W|X|C|V] to change wind,"
    stdoutln "    [Left|Right|Up|Down] to change gravity, and [Home|End] to change density"
    stdoutln ""
    stdout   "    Density range is from"+str$(%mindensity)+" to"+str$(%maxdensity)
    stdoutln ", default is"+str$(%defaultdensity)
    stdout   "    Wind range is from "+str$(%minWind)+" to"+str$(%maxWind)
    stdoutln ", default is"+str$(%defaultWind)
    stdout   "    Gravity range is from"+str$(%minGrav)+" to"+str$(%maxgrav)
    stdoutln ", default is"+str$(%defaultgrav)
    stdout   "    Drops range is from"+str$(%firstdrop)+" to"+str$(%maxdrop)
    stdoutln ", default is"+str$(%defaultlastdrop)
    stdoutln "    StepDrops is from"+str$(%minstepdrops)+" to"+str$(%maxstepdrops)

	end %eNone
case else
	parmcount=argC(cli$)
    select case parmcount
    case 0
		density=%defaultdensity
		lastdrop=%defaultlastdrop
		grav=%defaultgrav
		wind=%defaultwind ' < 0 = vers la gauche
		looping=%false
    	brightness=%defaultBrightness
    case 5
		density=val(argV$(cli$,1))
		IF density < %mindensity OR density > %Maxdensity THEN
		    stdoutln exe$+" : density is out of range !"
	    	END %eBadRange
    	end if
        wind =val(argV$(cli$,2))
		IF wind < %Minwind OR wind > %Maxwind THEN
		    stdoutln exe$+" : wind is out of range !"
	    	END %eBadRange
        end if
        grav=val(argV$(cli$,3))
		IF grav < %Mingrav OR grav > %Maxgrav THEN
		    stdoutln exe$+" : gravity is out of range !"
	    	END %eBadRange
        end if
		lastdrop=val(argV$(cli$,4))
		IF lastdrop < %firstdrop OR lastdrop > %Maxdrop THEN
		    stdoutln exe$+" : number of drops is out of range !"
	    	END %eBadRange
    	end if
		brightness=val(argV$(cli$,5))
		IF brightness < %minBrightness OR brightness > %MaxBrightness THEN
		    stdoutln exe$+" : brightness is out of range !"
	    	END %eBadRange
    	end if

        looping=%false

    case 8
		density=val(argV$(cli$,1))
		IF density < %mindensity OR density > %Maxdensity THEN
		    stdoutln exe$+" : density is out of range !"
	    	END %eBadRange
    	end if
        wind =val(argV$(cli$,2))
		IF wind < %Minwind OR wind > %Maxwind THEN
		    stdoutln exe$+" : wind is out of range !"
	    	END %eBadRange
        end if
        grav=val(argV$(cli$,3))
		IF grav < %Mingrav OR grav > %Maxgrav THEN
		    stdoutln exe$+" : gravity is out of range !"
	    	END %eBadRange
        end if
		vlower=val(argV$(cli$,4))
		IF vlower < %firstdrop OR vlower > %Maxdrop THEN
		    stdoutln exe$+" : minimum number of drops is out of range !"
	    	END %eBadRange
    	end if
        vupper=val(argV$(cli$,5))
		IF vupper < %firstdrop OR vupper > %Maxdrop THEN
		    stdoutln exe$+" : maximum number of drops is out of range !"
	    	END %eBadRange
        end if
        vstep=val(argV$(cli$,6))
		IF vstep < %Minstepdrops OR vstep > %Maxstepdrops THEN
		    stdoutln exe$+" : step is out of range !"
	    	END %eBadRange
        end if
        vrounds=val(argV$(cli$,7))
		IF vrounds < %firstround THEN
            stdoutln exe$+" : rounds must be more than"+str$(%firstround)+" !"
	    	END %eBadRange
        end if
        if vupper < vlower then swap vlower,vupper ' eh eh...

		brightness=val(argV$(cli$,8))
		IF brightness < %minBrightness OR brightness > %MaxBrightness THEN
		    stdoutln exe$+" : brightness is out of range !"
	    	END %eBadRange
    	end if

        looping=%true
        lastdrop=vlower

    case else
		stdoutln exe$+" : wrong number of parameters !"
        end %eWrongNumber
    end select

end select

call initrnd
CALL SetMode13h
call makepal(%defaultpal)

call initdrop(lastdrop)

flagMouse=%false
IF %useMouse = %True THEN
	flagMouse=MouseHere
END IF

if looping = %true then
	lastdrop=vlower
    num=%firstround
end if

DO
	if instat then
    	c$=inkey$
		bye=%false
        select case c$

        case "R","r"
        	call makepal(%redpal)
        case "G","g"
			call makepal(%greenpal)
        case "B","b"
			call makepal(%bluepal)

        case "D","d"
        	brightness=%minBrightness
        case "I","i"
			brightness=%maxBrightness

        case "+"
			if looping=%false then call changedrop(lastdrop,+%smallincrement)
            bye=looping
        case "-"
            if looping=%false then call changedrop(lastdrop,-%smallincrement)
            bye=looping
        case chr$(0,%pageup)
			if looping=%false then call changedrop(lastdrop,+%bigincrement)
            bye=looping
        case chr$(0,%pagedn)
			if looping=%false then call changedrop(lastdrop,-%bigincrement)
            bye=looping


        case "C","c" ' <
			call changewind(wind,+%windsmallincrement)
        case "X","x" ' >
			call changewind(wind,-%windsmallincrement)
        case "V","v" ' <<<
			call changewind(wind,+%windbigincrement)
        case "W","w" ' >>>
			call changewind(wind,-%windbigincrement)

        case "*"
        	if looping=%false then
				call makepal(%defaultpal)
            	density=%defaultdensity
	            lastdrop=%defaultlastdrop
    	    	grav=%defaultgrav
        	    wind=%defaultwind
            end if
            bye=looping

    	case chr$(0,%homekey)
        	density=%mindensity
        case chr$(0,%endkey)
        	density=%maxdensity

        case chr$(0,%uparrow)
			call changegrav(grav,+%gravsmallincrement)
        case chr$(0,%downarrow)
			call changegrav(grav,-%gravsmallincrement)
        case chr$(0,%leftarrow)
			call changegrav(grav,+%gravbigincrement)
        case chr$(0,%rightarrow)
			call changegrav(grav,-%gravbigincrement)
        case else
        	exit loop
        end select
        if bye=%true then exit loop
    end if

    IF ( (%useMouse=%True) AND (flagMouse = %True) ) THEN
    	IF MouseButtonClicked=%True THEN EXIT LOOP
    END IF

    if looping=%true then
    	incr num
        if num > vrounds then
        	incr lastdrop,vstep
            select case vstep
    		case < 0
            	if lastdrop < vlower then lastdrop=vlower:vstep=-vstep
        	case else
            	if lastdrop > vupper then lastdrop=vupper:vstep=-vstep
        	end select
            num=%firstround

        end if
    end if


    select case brightness
    case %minBrightness
		call anim(lastdrop,grav,wind)
    	call smooth(density)
    case %maxBrightness
    	' if smooth is done before anim, brighter dots
    	call smooth(density)
		call anim(lastdrop,grav,wind)
    end select

    ' call waitVGAretrace
	call show

LOOP

CALL ResetMode
stdoutln ""
stdoutln "Density         :"+str$(density)
stdout   "Wind            :"
if wind<0 then stdout " "
stdoutln str$(wind)
stdoutln "Gravity         :"+str$(grav)
stdoutln "Number of drops :"+str$(lastdrop)
stdoutln "Brightness      :"+str$(brightness)
stdoutln ""
stdout   "Command line    : "+exe$+str$(density)
stdoutln str$(wind)+str$(grav)+str$(lastdrop)+str$(brightness)
END %eNone



