'------------------------------------------------------------------
'Title         Q&D Atomic Particles Clock mode X
'Overview	   Yet Another Useless Clock
'Usage         see help
'Notes
'Bugs          weird : display refreshed very 2 turns ! (i.e. 0, 2 for mn)
'Wish List     set generation parms by command line options... but why ? ,-)
'              change colors thanks to palette and not through BFI ! :)
'			   do not change palette but position of screen !
'------------------------------------------------------------------

$CPU 			80386 ' modeX lib needs it anyway

$OPTIMIZE 		SIZE
$COMPILE 		EXE

$DEBUG MAP 		OFF
$DEBUG PBDEBUG 	OFF

$LIB COM        OFF
$LIB CGA        ON ' required for screen %cga (but not for screen %text)
$LIB EGA        OFF
$LIB VGA        OFF
$LIB HERC       OFF
$LIB LPT        OFF
$LIB IPRINT     OFF
$LIB FULLFLOAT  ON

$ERROR BOUNDS   OFF
$ERROR NUMERIC  OFF
$ERROR OVERFLOW OFF
$ERROR STACK    OFF

$FLOAT 			PROCEDURE

$COM    		0
$STRING 		16
$STACK  		8192 ' big stack for big local array in SUB
$SOUND  		1

$DIM 			ARRAY

$DYNAMIC

$OPTION CNTLBREAK OFF ' OFF in final EXE

'--------------------------------------------------------------------
' required here

DEFINT A-Z
OPTION ARRAY BASE 	0
OPTION BINARY BASE 	0

' %False = 0
' %True  = NOT %False

'--------------------------------------------------------------------
' external functions

$LINK 		"QDBOX.PBU"
$INCLUDE 	"QDBOX.DEF"

$LINK 		"MODEX.PBL"
$INCLUDE 	"MODEX.INC"

$LINK	    "QDRAND.PBU"
$INCLUDE	"QDRAND.DEF"

'--------------------------------------------------------------------
' internal functions

DECLARE SUB GetStrLoc() ' PowerBasic runtime library

'--------------------------------------------------------------------
' constants

%hires	= %mode320x240 ' 320x240 = 1:1 aspect ratio
%xpixels= 320
%ypixels= 240

%page1	= 0
%page2	= 1

%firstDot = 0
%lastDot  = 400 ' was 200

%maxvelocity=3 ' was 5 then 4
%birthdensity=3  ' was 4 : concentration around center at birth

%maxcount=10 ' was 10 : density for burst
%maxperiod=60*2 ' will be just 60 seconds

%cx = %xpixels \ 2
%cy = %ypixels \ 2

%inkrange=3 ' was 4 but narrower 3 seems better
%inkHH=27 ' was 24 grey   $18..$1E 27
%inkMM=55 ' was 55 blue   $34..$3A 55
%inkSS=41 ' was 40 red    $26..$2C 41

%minink=&h00
%maxink=&hFF
%modink=256
%mininkrange=&h00
%maxinkrange=&hFF ' ah !

%circleink1 = %c.red
%circleink2 = %c.green

'--------------------------------------------------------------------
' global variables

SHARED einfo$ ' error info
SHARED viewpage,workpage
shared pi#
shared hmsink,hmsperiod
shared flagSlow ' for pentium and the like...
shared MYinkHH,MYinkMM,MYinkSS,MYinkRange ' global by lazyness !
shared maxiperiod

dim hms$(%page1:%page2)
shared hms$()

%free 		=0
%alive		=1
%freeagain	=2

type dotentry
	status as integer
	x  	  as integer
    y 	  as integer
    ink   as integer
    vx    as integer
    vy	  as integer
    star  as integer
    limit as integer
end type

dim dot(%firstDot:%lastDot) as dotentry
shared dot()

type coorentry
	x as integer
    y as integer
    keepx as integer
    keepy as integer
end type

dim oldpos(%firstDot:%lastDot,%page1:%page2) as coorentry
shared oldpos()

'--------------------------------------------------------------------
' program start

EXEName$	="ACLOCK"
ProgramName$="Q&D Atomic Particles (!) Clock Mode X"
Version$	="v1.0i"
Copyright$	="by PhG"
Banner$		=ProgramName$+" "+Version$+" "+Copyright$
credit$ = "(public domain Mode X v1.04 library by Matt Pritchard)"

ON ERROR GOTO Abort

GOTO Start: ' jump to main() ;-)

'--------------------------------------------------------------------

SUB StdOut ( BYVAL Text AS STRING )
! push DS                    ; save DS FOR PowerBASIC
! push WORD Ptr Text         ; push STRING handle ON stack
! CALL GetStrLoc
! jcxz ExitStdOut
! mov  DS, DX
! mov  DX, AX
! mov  AH, &H40              ; DOS WRITE TO file
! mov  BX, 1                 ; file handle 1 is CONS
! INT  &H21
ExitStdOut:
! pop  DS
END SUB

SUB StdOutLn( BYVAL s as string )
CALL StdOut (s + CHR$(13, 10) )
END SUB

'--------------------------------------------------------------------
' error handling

%eNone 		= 100
%eHelp 		= 101
%eUnknownOpt= 102
%eUnknownParm=103
%eNeedVGA   = 104
%eMode      = 105
%eRange     = 106

'--------------------------------------------------------------------

Abort:
SELECT CASE ERR
CASE %eNone
	END ERR-%eNone
CASE %eHelp
	stdoutln ""
	stdoutln Banner$
    stdoutln ""
    stdoutln credit$
    stdoutln ""
	stdoutln "Syntax : "+ExeName$+" [option]..."
    stdoutln ""
'    stdoutln "In good old Apple ][ days, I had created my own FAST graphics library."
'    stdoutln "Nowadays, I'm just using an external library. :-("
'	stdoutln ""
	stdoutln "  This clock displays time thanks to rays of atomic particles. ;-)"
    stdoutln "  (HH= grey particles, MM=blue particles, SS=yellow particles)"
    stdoutln "  Display is not very accurate, but it does look rather nice..."
    stdoutln "  Remember hours and minutes are exactly set without progressive change :"
    stdoutln "  they are refreshed only AFTER they have changed. In other words,"
    stdoutln "  06:50 MAY look like 05:50 but it is really 06:50 ! ;-)"
    stdoutln ""
    stdoutln "  Colors must be in the [$00..$FF] range. '$' prefix stands for hex value."
    stdoutln ""
    stdoutln "  -m    abort program not only with key but with mouseclick too"
    stdoutln "  -v    show time too"
    stdoutln "  -t    transition for hours"
    stdoutln "  -s    slowdown for any processor superior to my good old... i486 DX33 ;-)"
    stdoutln "  -n    normal (less realistic) display"
    stdoutln "  -p    display current palette and quit"
    stdoutln "  -h:#  main color for hours particles (default = $"+hex$(%inkHH)+")"
    stdoutln "  -m:#  main color for minutes particles (default = $"+hex$(%inkMM)+")"
    stdoutln "  -s:#  main color for seconds particles (default = $"+hex$(%inkSS)+")"
    stdoutln "  -i:#  increment (default = $"+hex$(%inkRange)+")"
    stdoutln "  -f    finer resolution"
    END ERR-%eNone
CASE %eUnknownOpt
	e$=einfo$+" is not a legal option !"
CASE %eUnknownParm
	e$=einfo$+" is not a legal parameter !"
case %eNeedVGA
	e$="This program requires a VGA card !"
case %eMode
	e$="Unable to set required graphics mode !"
case %eRange
    e$="Color must be in the [$00..$FF] range !"
CASE ELSE
    e$=HEX$(ERADR) ' ERADR is a longint (7fFFffFF)
    e$=MID$("00000000",1,8-LEN(e$))+e$
    e$= "Unexpected error #"+MID$(STR$(ERR),2)+" at $"+e$
END SELECT
e$=EXEName$+" : "+e$
stdoutln ""
stdoutln e$
END ERR-%eNone

'--------------------------------------------------------------------

%PagesVirtual	= 2 ' request only two pages
%xMaxVirtual	= %xpixels
%yMaxVirtual	= %ypixels

function hiresOn
IF Set.VGA.ModeX%(%hires,%xMaxVirtual,%yMaxVirtual,%PagesVirtual) = 0 THEN
	hiresOff
	hiresOn = %false
else
	hiresOn = %true
END IF
end function

%text	= 0
%cga	= 2 ' 640x200 CGA

SUB hiresOff
CALL Set.Video.Mode (3)
SCREEN %cga ' reset width to 80
SCREEN %text,,0,0 ' reset work and view text pages to 0 by default
END SUB

%VGAhere = 5

FUNCTION IsVGA
  IF BIT (pbvScrnCard,%VGAhere) = 0 THEN
  	IsVGA = %False
  ELSE
  	IsVGA = %True
  END IF
END FUNCTION

%myblack=255

function fixblack(byval colornum)
if colornum=%c.black then
	fixblack=%myblack
else
	fixblack=colornum
end if
end function

'--------------------------------------------------------------------

sub flushkeyboard
do until inkey$ = ""
loop
end sub

function chkAbort(byval useMouse)
IF INSTAT THEN
	chkAbort=%true
else
	if useMouse=%true then
    	chkAbort=MouseButtonClicked
    else
    	chkAbort=%false
	end if
end if
end function

'--------------------------------------------------------------------

sub initTrigo
pi# = 4# * atn(1#)
end sub

function deg2rad#(byval alpha#)
deg2rad#=alpha#*pi#/180#
end function

sub p2r (byval alf#, byval radius, dx, dy)
alpha#=deg2rad#(alf#)
dx=radius*sin(alpha#)
dy=radius*cos(alpha#)
end sub

'--------------------------------------------------------------------

sub plot8 (byval cx,byval cy,byval xcrd,byval ycrd,byval ink)
    call set.point (cx+ycrd,cy+xcrd,ink)
    call set.point (cx-ycrd,cy+xcrd,ink)
    call set.point (cx-ycrd,cy-xcrd,ink)
    call set.point (cx+ycrd,cy-xcrd,ink)
    call set.point (cx+xcrd,cy-ycrd,ink)
    call set.point (cx+xcrd,cy+ycrd,ink)
    call set.point (cx-xcrd,cy+ycrd,ink)
    call set.point (cx-xcrd,cy-ycrd,ink)
END sub

sub circleX(byval xcenter,byval ycenter,byval radius,byval ink)
    xcrd=radius
    ycrd=0
    a	=-2*(xcrd+1)
    b	=1
    f	=0
    do
        plot8 xcenter,ycenter,xcrd,ycrd,ink
        INCR ycrd
        INCR f,b
        IF f > radius THEN
            INCr f,a
            INCr a,2
            DECr xcrd
        END if
        INCr b,2
    loop UNTIL not( b <= (-a) )
end sub

$if 0

sub circleX(byval cx,byval cy,byval radius,byval ink)
segments=180 ' line from 0 to 2, from 2 to 4, etc.
alpha#=0#
call p2r(alpha#,radius,dx1,dy1)
i=1
do until i > segments
	alpha#=i * 360# / segments
    call p2r(alpha#,radius,dx2,dy2)
	call draw.line(cx+dx1,cy+dy1,cx+dx2,cy+dy2,ink)
    dx1=dx2
    dy1=dy2
    incr i
loop
end sub

$endif



sub graphPrint (byval x,byval y,byval ink, byval s$) ' x,y in pixels
ink=fixblack(ink)
segment=strseg(s$)
offset=strptr(s$)
slen=len(s$)
if slen > 0 then call tprint.str(segment,offset,slen,x,y,ink)
end sub

sub graphCenterPrint (byval y,byval ink, byval s$) ' x,y in pixels
' each char is 8x8 pixels
ink=fixblack(ink)
segment=strseg(s$)
offset=strptr(s$)
slen=len(s$)
if slen > 0 then
	x=(%xpixels-8*slen) \ 2
	call tprint.str(segment,offset,slen,x,y,ink)
end if
end sub

sub marks(byval cx,byval cy,byval radius,byval ink)
ink=newink(ink)
for alpha# = 30 to 360 step 30
	call p2r(alpha#,radius,dx1,dy1)
	call set.point(cx+dx1,cy+dy1,ink)

	call p2r(alpha#-1,radius,dx1,dy1) ' .5 is ugly
	call set.point(cx+dx1,cy+dy1,ink)
	call p2r(alpha#+1,radius,dx1,dy1)
	call set.point(cx+dx1,cy+dy1,ink)

next
end sub

'--------------------------------------------------------------------

SUB WaitVGARetrace
!   mov dx,&h3DA
l1:
!   in al,dx
!   and al,&h08
!   jnz l1
l2:
!   in al,dx
!   and al,&h08
!   jz  l2
END SUB

sub clearScreen(byval page, byval paper)
paper=fixblack(paper)
CALL Set.Active.Page (page)
CALL Clear.VGA.Screen (paper)
end sub

sub viewwork
CALL Set.Active.Page (workpage)
CALL Set.Display.Page(viewpage)
' call WaitVGAretrace ' must be after and then no longer flicker ! useless with modeX
if flagSlow=%true then
	call waitVGAretrace
    call waitVGAretrace ' force a double delay here for faster PCs
end if
end sub

sub swappages
swap viewpage,workpage
viewwork
end sub

%hhPer360=360 \ 12 ' 12hours=360 !
%mmPer360=360 \ 60
%ssPer360=360 \ 60

sub hms2angles(byval hms$, hh#,mm#,ss#, byval flagTransition)
select case flagTransition
case %false
	s$=left$(hms$,2)
	hh#=val(s$)
	if hh# >= 12 then decr hh#,12
	hh#=hh#*%hhPer360
	s$=mid$(hms$,4,2)
	mm#=val(s$)*%mmPer360
	s$=mid$(hms$,7)
	ss#=val(s$)*%ssPer360
case %true ' here we compute partial angle for hours ONLY
	s$=left$(hms$,2)
	hh#=val(s$)
	if hh# >= 12 then decr hh#,12
	s$=mid$(hms$,4,2)
	mm#=val(s$)
	s$=mid$(hms$,7)
	ss#=val(s$)
    'mm#=mm#+ss#/60  ugly move so don't care !
	hh#=hh#+(mm#+ss#/60)/60
    ss#=ss#*%ssPer360
    mm#=mm#*%mmPer360
    hh#=hh#*%hhPer360
end select
end sub

'--------------------------------------------------------------------

sub initDots
for i =%firstDot to %lastDot
	dot(i).status=%free
next
end sub

sub generation(byval hms$,byval flagTransition,byval radius, byval radiusH,byval radiusM)
call hms2angles(hms$,hh#,mm#,ss#,flagTransition)
call gendots(hh#,MYinkHH,radiusH)
call gendots(mm#,MYinkMM,radiusM)
call gendots(ss#,MYinkSS,radius)
end sub

sub genDots(byval alpha#,byval ink,byval radius)
limit=radius*radius
if GetRnd > 0.5 then ' 1 out of 3 ! was 0.5
	angle#=deg2rad#(alpha#)
	vx#=+%maxvelocity * sin(angle#)
	vy#=-%maxvelocity * cos(angle#)
    count = 1
	for i = %firstDot to %lastDot
    	if dot(i).status = %free then
			dot(i).status=%alive
            dot(i).x= getRndRange(-%birthdensity,+%birthdensity)
            dot(i).y= getRndRange(-%birthdensity,+%birthdensity)
            dot(i).ink=( ink + getRndRange(0,MYinkrange) ) mod %modink ' safety
			dot(i).vx=vx# + getRnd * vx#
            dot(i).vy=vy# + getRnd * vy#
            dot(i).limit=limit
            if getRnd > 0.5 then
            	dot(i).star=%true
            else
            	dot(i).star=%false
            end if
            incr count
        end if
        if count > %maxcount then exit for
    next
end if
end sub

sub drawdots(byval page,byval cx,byval cy)
for i = %firstDot to %lastDot
	if dot(i).status=%alive then
		x=cx+dot(i).x
        y=cy+dot(i).y
        ink=dot(i).ink
        call set.point (x,y,ink)
		if dot(i).star = %true then
        	call set.point(x-1,y,ink)
        	call set.point(x+1,y,ink)
        	call set.point(x,y-1,ink)
        	call set.point(x,y+1,ink)
        end if
        oldpos(i,page).x=x
        oldpos(i,page).y=y
	end if
next
end sub

sub erasedots(byval page)
for i = %firstDot to %lastDot
	if dot(i).status=%freeagain then
		x=oldpos(i,page).keepx
        y=oldpos(i,page).keepy
        ink=%myblack
        call set.point (x,y,ink)
		if dot(i).star = %true then
        	call set.point(x-1,y,ink)
        	call set.point(x+1,y,ink)
        	call set.point(x,y-1,ink)
        	call set.point(x,y+1,ink)
        end if
        dot(i).status=%free
	end if
next
for i = %firstDot to %lastDot
	if dot(i).status=%alive then
		x=oldpos(i,page).x
        y=oldpos(i,page).y
        ink=%myblack
        call set.point (x,y,ink)
		if dot(i).star = %true then
        	call set.point(x-1,y,ink)
        	call set.point(x+1,y,ink)
        	call set.point(x,y-1,ink)
        	call set.point(x,y+1,ink)
        end if
	end if
next
end sub

sub update()
for i = %firstDot to %lastDot
	if dot(i).status=%alive then
		x=dot(i).x+dot(i).vx
        y=dot(i).y+dot(i).vy
        dot(i).x=x
        dot(i).y=y
        distance=x*x+y*y
        if distance > dot(i).limit then
        	dot(i).status=%freeagain
        	oldpos(i,viewpage).keepx=oldpos(i,viewpage).x
        	oldpos(i,viewpage).keepy=oldpos(i,viewpage).y
        end if
    end if
next
end sub

'--------------------------------------------------------------------

%outer=2

sub setradii(byval showHMS, zradius,zradiusH,zradiusM,zradiusC,zytime)
if showHMS=%false then
    zradius=%cy-8
	zradiusC=zradius+4
    zytime=0 ' useless here
else
	zradius=%cy-8-8
    zradiusC=zradius+4
    zytime=%cy+zradiusC+4
end if
zradiusH=zradius * 6 \ 10 ' hours circle
zradiusM=zradius * 8 \ 10 ' minutes circle
end sub

sub initDisplay(byval showHMS, byval flagTransition,byval flagRealistic,byval flagFiner)
call setradii(showHMS,zradius,zradiusH,zradiusM,zradiusC,zytime)
if flagRealistic=%false then
	zradiusH=zradius
    zradiusM=zradius
end if
call initRnd
call initTrigo
' weird : %c.black won't erase (is %c.nil), so force this kludge
CALL SET.DAC.REGISTER (%MyBLACK, 0,0,0)
call clearScreen(%page1,%c.black)
call clearScreen(%page2,%c.black)

'hmsperiod=0

hmsink=%circleink1

' init view and work
viewpage=%page1
workpage=%page2
viewwork

if flagFiner=%true then
	currtime$=getsystemtime$ 'hh:mm:ss.t
	' init here hmsperiod
	hmsperiod=2*val(mid$(currtime$,7,2))
    maxiperiod=%maxperiod * 10 ' display being updated every tenth of second...
else
	currtime$=time$
	' init here hmsperiod
	hmsperiod=2*val(right$(currtime$,2))
	maxiperiod=%maxperiod
end if

' draw
hms$(workpage)=currtime$
if showHMS=%true then call graphCenterPrint(zytime,hmsink,hms$(workpage))
call circlex(%cx,%cy,zradiusC,hmsink)
call marks(%cx,%cy,zradiusC+%outer,hmsink)

call initdots
call generation(currtime$,flagTransition,zradius,zradiusH,zradiusM)
call drawdots(workpage,%cx,%cy)
' show
call swappages
' set new work page to be identical to old work page
hms$(workpage)=currtime$
if showHMS=%true then call graphCenterPrint(zytime,hmsink,hms$(workpage))
call circlex(%cx,%cy,zradiusC,hmsink)
call marks(%cx,%cy,zradiusC+%outer,hmsink)

call drawdots(workpage,%cx,%cy)
' now both pages are identical, we may go on
flushkeyboard
end sub

'--------------------------------------------------------------------

function newink(byval ink)
select case ink
case %circleink1
  	newink=%circleink2
case %circleink2
    newink=%circleink1
end select
end function

sub refreshDisplay (byval showHMS,byval flagTransition,byval flagRealistic, byval flagFiner)
call setradii(showHMS,zradius,zradiusH,zradiusM,zradiusC,zytime)
if flagRealistic=%false then
	zradiusH=zradius
    zradiusM=zradius
end if
if hmsperiod=maxiperiod then
	hmsperiod=0
    hmsink=newink(hmsink)
end if
' show
call swappages
if flagFiner=%true then
    currtime$=getsystemtime$ 'hh:mm:ss:t
else
    currtime$=time$
end if

' erase
if currtime$ <> hms$(workpage) then ' most probably, seconds have changed
	if showHMS=%true then call graphCenterPrint(zytime,%c.black,hms$(workpage))
    incr hmsperiod
end if

call erasedots(workpage) ' erase old work
' draw
hms$(workpage)=currtime$
if showHMS=%true then call graphCenterPrint(zytime,hmsink,hms$(workpage))
call circlex(%cx,%cy,zradiusC,hmsink)
call marks(%cx,%cy,zradiusC+%outer,hmsink)

call update
call generation(currtime$,flagTransition,zradius,zradiusH,zradiusM)
call drawdots(workpage,%cx,%cy)
end sub

'--------------------------------------------------------------------

sub getval(byval value$,byval minval, byval maxval, result,ok)
if left$(value$,1)="$" then
   value$="&h"+mid$(value$,2)
end if
v&=val(value$)
if (v& < minval) or (v& > maxval) then
    ok=%false
else
    result=v&
    ok=%true
end if
end sub

'--------------------------------------------------------------------
' program code begins here : main() ;-)

Start:

mousePresent=mouseHere
abortOnClick=%false
showHMS=%false
flagTransition=%false
flagSlow=%false ' global by lazyness
flagRealistic=%true
flagFiner=%false
MYinkHH=%inkHH ' idem !
MYinkMM=%inkMM ' idem !
MYinkSS=%inkSS ' idem !
MYinkRange=%inkRange ' idem !

cli$=ltrim$(rtrim$(COMMAND$))
for i=1 to argc(cli$)
	einfo$=argV$(cli$,i)
    s$=upper$(einfo$)
    select case left$(s$,1)
    case "-","/"
    	s$=mid$(s$,2)
        if instr(s$,any ":=") > 1 then ' -x:# or -x=#
			replace ":" with "=" in s$ ' safety ! but don't use this code with filenames as parms ! ;-)
            p=instr(s$,"=")
            value$=mid$(s$,p+1) ' keep #
            s$=left$(s$,p) 		' keep -x=
        end if
        select case s$
        case "?","H","HELP"
        	error %eHelp
        case "M"
        	abortOnClick=%true
        case "V"
        	showHMS=%true
        case "T"
        	flagTransition=%true
        case "S"
        	flagSlow=%true
        case "N"
        	flagRealistic=%false
        case "P"
            cmdShowPalette
        case "H="
			getval value$,%minink,%maxink,MYinkHH,ok
            if ok=%false then error %eRange
        case "M="
			getval value$,%minink,%maxink,MYinkMM,ok
            if ok=%false then error %eRange
        case "S="
			getval value$,%minink,%maxink,MYinkSS,ok
            if ok=%false then error %eRange
        case "I="
			getval value$,%mininkrange,%maxinkRange,MYinkRange,ok
            if ok=%false then error %eRange
        case "F"
        	flagFiner=%true
        case else
        	error %eUnknownOpt
        end select
    case else
    	select case s$
        case "?"
        	error %eHelp
        case else
			error %eUnknownParm
        end select
    end select
next
if isVGA = %false then error %eNeedVGA
if mousePresent=%false then
	if abortOnClick=%true then
       	stdoutln ""
        stdoutln "Warning ! "+einfo$+" option ignored for no mouse driver is here !"
        stdoutln ""
        stdout   "Restarting within next 3 seconds anyway"
        for k=1 to 3
        	stdout "."
            delay 1
        next
        stdoutln ""
    end if
end if
if hiresOn =%false then error %eMode ' message won't be visible if not 25 lines

call initDisplay(showHMS,flagTransition,flagRealistic,flagFiner)
DO
	call refreshDisplay(showHMS,flagTransition,flagRealistic,flagFiner)
    if chkAbort(abortOnClick)=%true then exit loop
LOOP
hiresOff
error %eNone

'--------------------------------------------------------------------
'--------------------------------------------------------------------
'--------------------------------------------------------------------
' constants

%palhires	= %mode360x480
%palxpixels= 360
%palypixels= 480
%palxmin=0
%palxmax=%palxpixels-1
%palymin=0
%palymax=%palypixels-1

'--------------------------------------------------------------------

%palPagesVirtual	= 1
%palxMaxVirtual	= %palxpixels
%palyMaxVirtual	= %palypixels

function palhiresOn
IF Set.VGA.ModeX%(%palhires,%palxMaxVirtual,%palyMaxVirtual,%palPagesVirtual) = 0 THEN
	hiresOff
	palhiresOn = %false
else
	palhiresOn = %true
END IF
end function

'--------------------------------------------------------------------

sub waitkey (c$)
do
	c$=inkey$
    if c$ <> "" then exit loop
loop
if c$=chr$(0) then c$=c$+inkey$
end sub

sub palclearScreen(byval page, byval paper)
CALL Set.Active.Page (page)
CALL Clear.VGA.Screen (paper)
CALL Set.Display.Page(page)
end sub

'--------------------------------------------------------------------

sub cmdShowPalette
if isVGA = %false then error %eNeedVGA
if palhiresOn =%false then error %eMode ' message won't be visible if not 25 lines
for ink=0 to 255 step 16
	palclearScreen %page1, 0
	for i=0 to 15
        x=i*20
        theink=ink+i
        s$=hex$(theink)
        if theink < &h10 then s$="0"+s$
        graphprint x,0,15,s$
        for w=0 to 19
			draw.line x+w,%palymin+16,x+w,%palymax,theink
        next
    next
    flushkeyboard
    waitkey c$
    if c$=chr$(27) then exit for
next
hiresOff
error %eNone
end sub

'--------------------------------------------------------------------

'INT 21 - DOS 1+ - GET SYSTEM TIME
'        AH = 2Ch
'Return: CH = hour
'        CL = minute
'        DH = second
'        DL = 1/100 seconds
'Note:   on most systems, the resolution of the system clock is about 5/100sec,
'          so returned times generally do not increment by 1
'        on some systems, DL may always return 00h

function getsystemtime$()
hh%=0
mm%=0
sc%=0
hs%=0
! mov ah,&h2C
! int &h21
! mov hh%,ch
! mov mm%,cl
! mov sc%,dh
! mov hs%,dl
hs%=hs% \ 10 ' smooth using tenths of second
h$=mid$(str$(hh%),2):if hh%<10 then h$="0"+h$
m$=mid$(str$(mm%),2):if mm%<10 then m$="0"+m$
s$=mid$(str$(sc%),2):if ss%<10 then s$="0"+s$
c$=mid$(str$(hs%),2)':if hs%<10 then c$="0"+c$
function = h$+":"+m$+":"+s$+"."+c$
end function
