(* -----------------------------------------------------------

------------------------------------------------------------ *)

MODULE unpath;

IMPORT Lib;
IMPORT Str;
IMPORT FIO;
IMPORT IO;

FROM IO IMPORT WrStr, WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits;


CONST
    exe        = "UNPATH";
    version    = "v1.0c";
    banner     = "Q&D Unpath "+version+" by PhG";
    cr         = CHR(13);
    lf         = CHR(10);
    nl         = cr+lf;
    minwi      = 1;
    maxwi      = 256;
    dquote     = '"';
    SEP        = " +++ ";
    TOOLONG    = "::: ";
    REM1       = ';';
    REM2       = '#';
    antislash  = '\';
    minus      = '-';
    AUTOWIDTH  = '*';
    passOne    = 1;
    passTwo    = 2;
    msgOne     = "Looking for longest length, please wait...";
    msgTwo     = "Processing, please wait...";
    errNone    = 0;
    errHelp    = 1;
CONST
    help = banner+nl+
nl+
"Syntax : "+exe+" <[-]"+AUTOWIDTH+"|[-|+]width> <file> [-keep]"+nl+
nl+
"This program reformats each line in <file> :"+nl+
"it extracts filename from trailing path, pads it (left or right) to <width>,"+nl+
'then prepends it to original line with "'+SEP+'" separator.'+nl+
nl+
'a) Without -k option, lines beginning with "'+REM1+'" or "'+REM2+'" are filtered out ;'+nl+
'   other lines not matching "*\*" are filtered out.'+nl+
'b) If first parameter is "'+AUTOWIDTH+'", program will use longest length.'+nl+
"c) If filename is longer than specified <width>,"+nl+
'   original line is dumped with "'+TOOLONG+'" prefix.'+nl+
"d) If original path was delimited with double quotes, split parts will be too."+nl+
"e) Extensions are not beautified."+nl+
"f) Each line entries should not be longer than 4096 characters."+nl;

PROCEDURE pad (wi:INTEGER;padchar:CHAR;VAR R:ARRAY OF CHAR):BOOLEAN;
VAR
    k,len,i:CARDINAL;
    wasenclosed:BOOLEAN;
BEGIN
    wasenclosed:= ( Str.RCharPos(R,dquote) # MAX(CARDINAL) );
    IF wasenclosed THEN Str.Prepend(R,dquote); INC(wi); END; (* handle added quote *)
    len:=Str.Length(R);
    FOR i:= (len+1) TO ABS(wi) DO
        IF wi < 0 THEN
            Str.Prepend(R,padchar);
        ELSE
            Str.Append(R,padchar);
        END;
    END;
    RETURN wasenclosed;
END pad;

PROCEDURE abort (e:CARDINAL;S:ARRAY OF CHAR);
BEGIN
    CASE e OF
    | errNone: ;
    | errHelp: WrStr(help);
    ELSE
        WrStr(exe+" : ");WrStr(S);WrStr(" !");WrLn;
    END;
    Lib.SetReturnCode( SHORTCARD(e) );
    HALT;
END abort;

VAR
    scanmode : (user,autoleft,autoright);
    hin:FIO.File;
    F,msg,Z:str128;
    v:LONGINT;
    wasenclosed,ok,warn:BOOLEAN;
    wi,len:INTEGER;
    pb,p,pass,i:CARDINAL;
    S,R:str4096;
    parmcount:CARDINAL;
    wasremark,keepremarks:BOOLEAN;
BEGIN
    FIO.IOcheck:=FALSE;
    WrLn;

    keepremarks := FALSE;

    parmcount:=Lib.ParamCount();
    CASE parmcount OF
    | 2,3 : ;
    ELSE
        abort(errHelp,"");
    END;

    Lib.ParamStr(Z,1); cleantabs(S);
    IF same(Z,AUTOWIDTH) THEN
        wi:=0;
        scanmode := autoright;
        pass:=passOne;
    ELSIF same(Z,minus+AUTOWIDTH) THEN
        wi:=0;
        scanmode := autoleft;
        pass:=passOne;
    ELSE
        v:=Str.StrToInt(Z,10,ok);
        IF ok=FALSE THEN v:=MAX(LONGINT);END;
        IF ( (ABS(v) < minwi) OR (ABS(v) > maxwi) ) THEN
            abort(2,"<width> illegal or out of [1..256] range");
        END;
        wi:=INTEGER(v);
        scanmode:=user;
        pass:=passTwo; (* skip analysis *)
    END;

    Lib.ParamStr(F,2); cleantabs(S);
    IF FIO.Exists(F)=FALSE THEN abort(3,"<file> not found");END;

    IF parmcount = 3 THEN
        Lib.ParamStr(Z,3); cleantabs(S);
        IF isOption(Z) THEN
            UpperCase(Z);
            Str.Delete(Z,0,1); (* remove - OR / *)
            IF same(Z,"K") OR same(Z,"KEEP") THEN
                keepremarks:=TRUE;
            ELSE
                abort(4,"unknown option");
            END;
        ELSE
            abort(5,"unexpected parameter");
        END;
    END;

    FOR i:=pass TO passTwo DO
        CASE i OF
        | passOne: msg:=msgOne;
        | passTwo: msg:=msgTwo;
        END;
        warn:= (IsRedirected() OR (i=passOne));
        IF warn THEN video(msg,TRUE); END;
        FIO.EOF := FALSE; (* required safety -- else, pass 2 would not run *)
        hin:=FIO.OpenRead(F);
        WHILE NOT (FIO.EOF) DO
            FIO.RdStr(hin,S);
            pb:=0;
            IF S[0] = REM1 THEN INC(pb); END;
            IF S[0] = REM2 THEN INC(pb); END;

            wasremark:= ( pb # 0 );

            p:=Str.RCharPos(S,antislash);
            IF p = MAX(CARDINAL) THEN INC(pb); END;
            IF pb = 0 THEN
                Str.Copy(R,S);
                Str.Delete(R,0,p+1); (* delete antislash too *)
                S[p+1]:=0C;          (* keep antislash -- brutal, huh ?! ;-) *)
                len:=INTEGER( Str.Length(R) );

                CASE i OF
                | passOne:
                    IF ABS(len) > ABS(wi) THEN wi:=ABS(len);END;
                    CASE scanmode OF
                    | autoright:
                        ;
                    | autoleft:
                        wi:=-wi;
                    END;
                | passTwo:
                    IF ABS(len) > ABS(wi) THEN
                        WrStr(TOOLONG);
                        WrStr(S);WrStr(R);WrLn;
                    ELSE
                        wasenclosed:=pad(wi," ",R);
                        WrStr(R);WrStr(SEP);WrStr(S);
                        IF wasenclosed THEN WrStr(dquote);END;
                        WrLn;
                    END;
                END;
            END;

            IF wasremark THEN
                IF i=passTwo THEN
                    IF keepremarks THEN WrStr(S);WrLn; END;
                END;
            END;

            IF ChkEscape() THEN
                FIO.Close(hin);
                IF warn THEN video(msg,FALSE); END;
                abort(255,"aborted by user");
            END;
        END;
        FIO.Close(hin);
        IF warn THEN video(msg,FALSE); END;
    END;
    abort(errNone,"");
END unpath.

