(* ---------------------------------------------------------------
Title         see help !
Author        who cares ?
Overview      see help !
Usage         see help !
Notes         yes, we know, this is merely an oversized
              "copy f1+f2+f3..." then rename and delete
              but who cares ?

              an option to force concatenating of first matching files
              (with or without deleting them) ?

Bugs          Yet Another TopSpeed Bug : FIO.Append does not like binary !
              (seems to reposition at last ctrl-Z !)

--------------------------------------------------------------- *)

MODULE concat;

IMPORT Str;
IMPORT Lib;
IMPORT FIO;

IMPORT IO;

FROM IO IMPORT WrLn,WrStr;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose;

(* ------------------------------------------------------------ *)


CONST
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;
    dot           = ".";
    dotdot        = dot+dot;
    nullchar      = CHR(0);
    slash         = "/";
    slashslash    = slash+slash;
    M2line        = "(* //------------------------------------------------------------// *)";
    ctrlZ         = CHR(26); (* silly legacy ! *)
    msgCreated    = "::: Created   : ";
    msgUpdated    = "::: Updated   : ";
    msgProcessed  = "::: Processed : ";
    sINFO         = "::: ";
    sPLUS         = "+ ";
    extBAK        = ".BK!";
    extCOM        = ".COM";
    extEXE        = ".EXE";
    extDLL        = ".DLL";
    extOVR        = ".OVR";
    extOVL        = ".OVL";
    extDRV        = ".DRV";
    extZIP        = ".ZIP";
    extARJ        = ".ARJ";
    extLZH        = ".LZH";
    extensions    = extBAK+delim+extCOM+delim+extEXE+delim+
                    extDLL+delim+extOVR+delim+extOVL+delim+extDRV+delim+
                    extZIP+delim+extARJ+delim+extLZH;
CONST
    progEXEname   = "CONCAT";
    progTitle     = "Q&D Concatenate files";
    progVersion   = "v1.0l";
    progCopyright = "by PhG";
    banner        = progTitle+" "+progVersion+" "+progCopyright;
CONST
    errNone             = 0;
    errHelp             = 1;
    errOption           = 2;
    errParm             = 3;
    errExpected         = 4;
    errJoker            = 5;
    errNotFound         = 6;
    errExtension        = 7;
    errROmain           = 8;
    errRO               = 9;
    errBinaryNonsense   = 10;
    errTooManyMatches   = 11;
    errExtensionMatch   = 12;
    errNonsenseSyntax1  = 13;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
banner+nl+
nl+
"Syntax 1 : "+progEXEname+" <mainfile> <file>... [option]..."+nl+
"Syntax 2 : "+progEXEname+" <mainfile> <file(s)> [option]..."+nl+
nl+
"This program appends <file>... to <mainfile>."+nl+
nl+
'    -l[l]  separate individual files with "'+slashslash+'" (-ll = M2 remark)'+nl+
"    -n     do not add CR+LF separator after each concatenated file"+nl+
"    -k     do not create backup for existing <mainfile>"+nl+
"    -s     do not update existing <mainfile> date/time stamp"+nl+
"    -d     delete <file>... when copy is done"+nl+
"    -o     ignore read-only status"+nl+
"    -c     create a new <mainfile> instead of appending data to existing one"+nl+
"    -z     do not filter out Ctrl-Z (code 26 = $1A) from files"+nl+
"    -b     binary mode (forced : -n and -z ; ignored : -l[l] and -k)"+nl+
"    -m     ignore missing file(s)"+nl+
"    -p     preview matching files processing order for syntax 2 (no action)"+nl+
"    -x     disable LFN support even if available"+nl+
nl+
"a) "+extensions+" extensions are not allowed"+nl+
"   (unless -b was specified)."+nl+
"b) When filtering out Ctrl-Z, <mainfile> will lose its trailing Ctrl-Z only."+nl+
"c) Contrarily to syntax 2, syntax 1 does not support jokers."+nl+
"d) Syntax 2 will process files in directory order (see -p option supra) ;"+nl+
"   it will not process more than 240 matching files."+nl; (* 250 but... *)

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errOption :
        Str.Concat(S,"Unknown ",einfo); Str.Append(S," option !");
    | errParm :
        Str.Concat(S,"Uneeded ",einfo); Str.Append(S," parameter !");
    | errExpected:
        Str.Concat(S,"Missing ",einfo); Str.Append(S," parameter !");
    | errJoker:
        Str.Concat(S,einfo," should not contain any joker !");
    | errNotFound:
        Str.Concat(S,einfo," does not exist !");
    | errExtension:
        Str.Concat(S,"Reserved extension in ",einfo);Str.Append(S," !");
    | errROmain:
        Str.Concat(S,einfo," <mainfile> is Read-Only !");
    | errRO:
        Str.Concat(S,einfo," <file> is Read-Only !");
    | errBinaryNonsense:
        Str.Concat(S,einfo," is a nonsense with -binary !");
    | errTooManyMatches:
        Str.Concat(S,"Too many files match ",einfo);Str.Append(S," !");
    | errExtensionMatch:
        Str.Concat(S,"Reserved extension in expanded ",einfo);Str.Append(S," !");
    | errNonsenseSyntax1 :
        Str.Concat(S,einfo," option is a nonsense with syntax 1 !");
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ; (* nada *)
    ELSE
        WrStr(progEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    ioBufferIn,ioBufferOut : ioBufferType;

(* ------------------------------------------------------------ *)

CONST
    dataBufferSize = 32*512;
    firstDataByte  = 1-1;
    lastDataByte   = dataBufferSize-1;
TYPE
    dataBufferType = ARRAY [firstDataByte..lastDataByte] OF BYTE;
VAR
    dataBuffer : dataBufferType;

(* ------------------------------------------------------------ *)

TYPE
    fileoptype = (opCopy,opAppend);

(* assume target already exists for append file operation *)

PROCEDURE doFileOp (cmd:fileoptype;useLFN,addcr,addsep,M2remark,filterEOF,DEBUG:BOOLEAN;
                   source,target:pathtype);
CONST
    msgWorking = "Processing, please wait...";
VAR
    hin,hout:FIO.File;
    got,count,p,mult:CARDINAL;
    curreof:BOOLEAN;
    S:str128;
    wanted:BYTE;
    whereto,wherefrom:ADDRESS;
    verbose:BOOLEAN;
    fsize:LONGCARD;
BEGIN
        mult:=0;
        verbose:=TRUE;
IF DEBUG THEN verbose:=FALSE;END;
        curreof:=FIO.EOF; (* almost certainly useless but cannot harm *)

        IF verbose THEN video(msgWorking,TRUE); END;

        hin:=fileOpenRead(useLFN,source);
        FIO.AssignBuffer(hin,ioBufferIn);

        CASE cmd OF
        | opCopy:
            hout:=fileCreate(useLFN,target);
        | opAppend:
            (*
            hout:=FIO.Append(target); YATB !!! TS library positions at last ctrl-Z !
            *)
            hout:=fileOpen(useLFN,target);
        END;
        FIO.AssignBuffer(hout,ioBufferOut);

        (* v1.0g fix for FIO.Append and possibly FIO.Create ! *)
        fsize:=FIO.Size(hout);
        FIO.Seek(hout,fsize);

IF DEBUG THEN
WrStr("target fpos            = ");IO.WrLngCard( FIO.GetPos(hout),0);WrLn;
WrStr("source filesize        = ");IO.WrLngCard( FIO.Size(hin) ,0);WrLn;
END;

        (* allow another separator ? bah... *)
        (* -1 required to avoid trailing $00 ! we could use Str.Length, though *)
        IF addcr THEN FIO.WrBin(hout,nl,SIZE(nl)-1); END;
        IF addsep THEN
            IF M2remark THEN
                FIO.WrBin(hout,M2line+nl,SIZE(M2line+nl)-1);
            ELSE
                FIO.WrBin(hout,slashslash+nl,SIZE(slashslash+nl)-1);
            END;
        END;

        FIO.EOF:=FALSE;
        LOOP
            got:=FIO.RdBin(hin,dataBuffer,dataBufferSize);
            IF got = 0 THEN EXIT; END;

IF DEBUG THEN
IF got = dataBufferSize THEN
    INC(mult);
ELSE
    WrStr("last got               = ");IO.WrCard(got,0);WrLn;
END;
END;

            IF filterEOF THEN
                (* we know buffer is not empty *)
                wanted:=ORD(ctrlZ);
IF DEBUG THEN WrStr("wanted    = ");IO.WrShtCard(wanted,0);WrLn; END;
                count:=got;
                LOOP
                    wherefrom := ADR(dataBuffer);
IF DEBUG THEN
WrStr("wherefrom = ");IO.WrLngHex( LONGCARD(wherefrom),8);WrLn;
WrStr("count     = ");IO.WrCard(count,0);WrLn;
END;
                    p:=Lib.ScanR( wherefrom,count,wanted);
IF DEBUG THEN WrStr("p         = ");IO.WrCard(p,0);WrLn; END;
                    IF p = count THEN
IF DEBUG THEN WrStr("no ctrlz, we quit loop");WrLn; END;
                         EXIT;
                    END;
                    whereto   := ADR( dataBuffer[p]);
                    wherefrom := ADR( dataBuffer[p+1]);
IF DEBUG THEN
WrStr("whereto   = ");IO.WrLngHex( LONGCARD(whereto),8);WrLn;
WrStr("wherefrom = ");IO.WrLngHex( LONGCARD(wherefrom),8);WrLn;
WrStr("n         = ");IO.WrCard(count-(p+1),0);WrLn;
WrStr("move n bytes from wherefrom to whereto");WrLn;
END;
                    Lib.Move(wherefrom,whereto,count-p);
                    DEC(count);
IF DEBUG THEN WrStr("new count = ");IO.WrCard(count,0);WrLn; END;
                    IF count=0 THEN
IF DEBUG THEN WrStr("empty buffer, we quit loop");WrLn; END;
                        EXIT;
                    END;
                END;
                FIO.WrBin(hout,dataBuffer,count);
            ELSE
                FIO.WrBin(hout,dataBuffer,got);
            END;

            IF got # dataBufferSize THEN EXIT; END;
        END;

IF DEBUG THEN
WrStr("dataBufferSize multiple= ");IO.WrCard(mult,0);WrStr(" * ");IO.WrCard(dataBufferSize,0); WrLn;
WrStr("target fpos now        = ");IO.WrLngCard( FIO.GetPos(hout),0);WrLn;
END;
        FIO.Flush(hout);
        fileClose(useLFN,hout);
        fileClose(useLFN,hin);

        IF verbose THEN video(msgWorking,FALSE); END;

        FIO.EOF := curreof;
END doFileOp;

(* ------------------------------------------------------------ *)

PROCEDURE fixTrailingEOF (filterEOF,useLFN:BOOLEAN; S:pathtype);
VAR
    hin : FIO.File;
    curreof : BOOLEAN;
    fsize : LONGCARD;
    b : SHORTCARD; (* byte *)
    got:CARDINAL;
BEGIN
    IF NOT(filterEOF) THEN RETURN; END;

    curreof:=FIO.EOF; (* almost certainly useless but cannot harm *)

    hin:=fileOpen(useLFN,S);
    FIO.AssignBuffer(hin,ioBufferIn);
    fsize:=FIO.Size(hin);
    IF fsize # 0 THEN
        FIO.Seek(hin,fsize-1);
        got:=FIO.RdBin(hin,b,SIZE(b));
        IF b = ORD(ctrlZ) THEN
            FIO.Seek(hin,fsize-1);
            FIO.Truncate(hin);
        END;
    END;
    fileClose(useLFN,hin);

    FIO.EOF := curreof;
END fixTrailingEOF;

(* ------------------------------------------------------------ *)

TYPE
    dtoptype = (dtget,dtset);

PROCEDURE doStampOp (VAR stamp:LONGCARD; cmd:dtoptype;useLFN:BOOLEAN;S:pathtype);
VAR
    hnd:FIO.File;
BEGIN
    hnd:=fileOpenRead(useLFN,S);
    CASE cmd OF
    | dtget:
        stamp:=FIO.GetFileDate(hnd);
    | dtset:
        FIO.SetFileDate(hnd,stamp);
    END;
    fileClose(useLFN,hnd);
END doStampOp;

PROCEDURE createEmptyFile (useLFN:BOOLEAN;S:pathtype);
VAR
    hnd:FIO.File;
BEGIN
    hnd:=fileCreate(useLFN,S);
    fileClose(useLFN,hnd);
END createEmptyFile;

(* assume S is already uppercased and yes we know it's not bullet-proof *)

PROCEDURE legalextension (S:ARRAY OF CHAR):BOOLEAN;
VAR
    e3 : str16;
    n:CARDINAL;
    rc:BOOLEAN;
BEGIN

    Str.Caps(S); (* ah, lowercase LFNs... *)

    rc:=TRUE;
    n:=0;
    LOOP
        isoleItemS(e3, extensions,delim,n);
        IF same(e3,"") THEN EXIT; END;
        IF Str.Pos(S,e3) # MAX(CARDINAL) THEN rc:=FALSE;EXIT; END;
        INC(n);
    END;
    RETURN rc;
END legalextension;

(* return TRUE if no dot in \f8.e3 part -- overkill ! *)

PROCEDURE needTrailingDot (S:ARRAY OF CHAR):BOOLEAN;
VAR
    u,d,n,e,ne:str128;
BEGIN
    Lib.SplitAllPath(S,u,d,n,e);
    Lib.MakeAllPath(ne,"","",n,e);
    RETURN Str.CharPos(ne,dot)=MAX(CARDINAL);
END needTrailingDot;

PROCEDURE buildBakName (VAR newname:ARRAY OF CHAR;
                       currentname,ext:ARRAY OF CHAR);
VAR
    p : CARDINAL;
BEGIN
    Str.Copy(newname,currentname);
    p:=Str.CharPos(newname,dot);
    newname[p]:=nullchar; (* brutal ! *)
    Str.Append(newname,ext);
END buildBakName;

(* ------------------------------------------------------------ *)

CONST
    firstparm = 1;
    maxparm   = 250; (* was 32 until v1.0k why not 28, 6, 11, 100, 127 ? eh eh... *)
VAR
    parm:ARRAY [firstparm..maxparm] OF pathtype;
    useme:ARRAY[firstparm..maxparm] OF BOOLEAN;

PROCEDURE isReservedEntry (S : ARRAY OF CHAR) : BOOLEAN; (* assume uppercase *)
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    IF same(S,dotdot) THEN RETURN TRUE; END;
    RETURN FALSE;
END isReservedEntry;

(* yet another buildMatchList() variation but using parm[] *)

CONST
    TOOMANYMATCHES     = MAX(CARDINAL);
    RESERVEDEXTENSION  = MAX(CARDINAL)-1;

PROCEDURE expandMe (VAR lastparm:CARDINAL;
                   useLFN,binary,preview:BOOLEAN;spec:pathtype);
VAR
    S,dirbase,u,d,n,e:pathtype;
    rc,found:BOOLEAN;
    unicodeconversion:unicodeConversionFlagType;
    w9Xentry : findDataRecordType;
    w9Xhandle,errcode:CARDINAL;
    DOSentry     : FIO.DirEntry;
    dosattr:FIO.FileAttr;
BEGIN
    DEC(lastparm); (* required here ! *)

    Lib.SplitAllPath(spec,u,d,n,e);
    Lib.MakeAllPath(dirbase,u,d,"","");
    fixDirectory(dirbase);
    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,everything,DOSentry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(S,w9Xentry.fullfilename);
        ELSE
            Str.Copy(S,DOSentry.Name);
        END;
        IF isReservedEntry(S) THEN (* skip "." ".." *)
            ; (* silently ignore this spec *)
        ELSE
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=DOSentry.attr;
            END;
            IF NOT (aD IN dosattr) THEN
                INC(lastparm);
                IF lastparm > maxparm THEN
                    lastparm:= TOOMANYMATCHES;
                    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN;
                END;
                IF binary=FALSE THEN
                     IF legalextension(S)=FALSE THEN
                         lastparm := RESERVEDEXTENSION;
                         IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
                         RETURN;
                     END;
                END;
                IF preview THEN
                    WrStr(sPLUS);WrStr(S);WrLn;
                END;
                Str.Prepend(S,dirbase);
                parm[lastparm]:=S;
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(DOSentry);
        END;
    END;
    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
END expandMe;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

VAR
    S,R : pathtype;
    i,opt,parmcount:CARDINAL;
    lastparm:CARDINAL;
    useLFN,targetcreated,flagcr,flagsep,M2remark:BOOLEAN;
    verbose,addcr,keepbackup,keepstamp,killglued,binary,mustexist:BOOLEAN;
    ignoreRO,useseparator,recreatemain,bornagain,filterEOF,preview:BOOLEAN;
    DEBUG : BOOLEAN;
    optK:BOOLEAN;
    stamp:LONGCARD;
    target,backup:pathtype;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;
    WrLn;

    useLFN     := TRUE;

    keepbackup :=TRUE;  optK:=FALSE;
    keepstamp  :=FALSE;
    killglued  :=FALSE;
    ignoreRO   :=FALSE;
    addcr      :=TRUE;
    verbose    :=TRUE;
    useseparator :=FALSE;
    M2remark     :=FALSE;
    targetcreated:=FALSE;
    recreatemain :=FALSE;
    binary       :=FALSE;
    mustexist    :=TRUE;
    filterEOF    :=TRUE;
    preview      :=FALSE;
    DEBUG        :=FALSE; (* TRUE to check damn Lib.Scan/Lib.Move which doesn't like small model ! *)

    lastparm := firstparm-1; (* 1.. *)

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "K"+delim+"BACKUP"+delim+
                                  "S"+delim+"STAMP"+delim+
                                  "D"+delim+"DELETE"+delim+
                                  "O"+delim+"OVERWRITE"+delim+
                                  "N"+delim+"CRLF"+delim+"NEWLINE"+delim+
                                  "Q"+delim+"QUIET"+delim+
                                  "L"+delim+"DASH"+delim+
                                  "C"+delim+"CREATE"+delim+
                                  "Z"+delim+"EOF"+delim+"CTRLZ"+delim+
                                  "B"+delim+"BINARY"+delim+
                                  "M"+delim+"MISSING"+delim+
                                  "X"+delim+"LFN"+delim+
                                  "LL"+delim+
                                  "P"+delim+"PREVIEW"+delim+
                                  "DEBUG"
                              );
            CASE opt OF
            | 1,2,3:    abort(errHelp,"");
            | 4,5:      keepbackup   :=FALSE; (* -K *) optK:=TRUE;
            | 6,7:      keepstamp    :=TRUE;
            | 8,9:      killglued    :=TRUE;
            | 10,11:    ignoreRO     :=TRUE;
            | 12,13,14: addcr        :=FALSE; (* -N *)
            | 15,16:    verbose      :=FALSE;
            | 17,18:    useseparator :=TRUE;  (* -L[L] *)
            | 19,20:    recreatemain :=TRUE;
            | 21,22,23: filterEOF    :=FALSE; (* -Z *)
            | 24,25:    binary       :=TRUE;
            | 26,27:    mustexist    :=FALSE;
            | 28,29:    useLFN       :=FALSE;
            | 30:       useseparator :=TRUE;  M2remark:=TRUE; (* -LL *)
            | 31,32:    preview      :=TRUE;
            | 33:       DEBUG        :=TRUE;
            ELSE
                abort(errOption,S);
            END;
        ELSE
            INC(lastparm); IF lastparm > maxparm THEN abort(errParm,S);END;
            Str.Copy(parm[lastparm],R); (* keep uppercased parm *)
        END;
    END;

    CASE lastparm OF
    | firstparm-1 : abort(errHelp,"");
    | firstparm   : abort(errExpected,"<file>...");
    | firstparm+1 : Str.Copy(S,parm[lastparm]);
                    IF chkJoker (S) THEN
                        IF preview THEN
                            WrStr(sINFO+"File ");
                            WrStr(parm[firstparm]);WrLn;
                            WrStr(sINFO+"would be created from concatenating these files :");WrLn;
                            WrLn;
                        END;
                        expandMe(lastparm,useLFN,binary,preview,S);
                        CASE lastparm OF
                        | TOOMANYMATCHES : abort(errTooManyMatches,S);
                        | RESERVEDEXTENSION: abort(errExtensionMatch,S);
                        END;
                        IF preview THEN
                            WrLn;
                            WrStr(sINFO+"Because of preview mode, no file was modified.");WrLn;
                            abort(errNone,"");
                        END;
                    END;
    ELSE
        IF preview THEN abort(errNonsenseSyntax1,"-p");END;
    END;

    useLFN := ( useLFN AND w9XsupportLFN() );

    bornagain:=FALSE;
    FOR i:= firstparm TO lastparm DO
        useme[i]:=TRUE;
        Str.Copy(S,parm[i]);
        IF needTrailingDot(S) THEN Str.Append(S,dot);END;
        IF chkJoker(S) THEN abort(errJoker,S);END;
        IF binary=FALSE THEN
            IF legalextension(S)=FALSE THEN abort(errExtension,S);END;
        END;
        CASE fileExists(useLFN,S) OF
        | TRUE:
            CASE i OF
            | firstparm:
                IF recreatemain THEN
                    IF fileIsRO(useLFN,S) THEN
                        IF ignoreRO THEN
                            fileSetRW(useLFN,S);
                        ELSE
                            abort(errROmain,S);
                        END;
                    END;
                    bornagain:=TRUE;
                END;
                fixTrailingEOF(filterEOF,useLFN,S); (* v1.0j ugly fix *)
            END;
            IF fileIsRO(useLFN,S) THEN
                CASE i OF
                | firstparm:
                    IF ignoreRO THEN
                        fileSetRW(useLFN,S);
                    ELSE
                        abort(errROmain,S);
                    END;
                ELSE
                    IF killglued THEN
                        IF ignoreRO THEN
                            fileSetRW(useLFN,S);
                        ELSE
                            abort(errRO,S);
                        END;
                    END;
                END;
            END;
        | FALSE:
            CASE i OF
            | firstparm :
                createEmptyFile(useLFN,S); (* 0-length *)
                targetcreated := TRUE;
                keepbackup :=FALSE;
                keepstamp  :=FALSE;
            ELSE
                IF mustexist THEN
                    abort(errNotFound,S);
                ELSE
                    useme[i]:=FALSE;
                END;
            END;
        END;
    END;

    (* ok, let's go now *)

    IF binary THEN
        IF optK        =TRUE THEN abort(errBinaryNonsense,"-k"); END;
        IF useseparator=TRUE THEN abort(errBinaryNonsense,"-l[l]"); END;

        keepbackup   := TRUE;   (* -K ignored *)
        addcr        := FALSE;  (* -N forced *)
        useseparator := FALSE;  (* -L[L] ignored *)
        filterEOF    := FALSE;  (* -Z forced *)
    END;

    Str.Copy(target,parm[firstparm]);

    IF (keepstamp OR keepbackup) THEN doStampOp(stamp,dtget,useLFN,target);END;
    IF keepbackup THEN
        buildBakName(backup, target,extBAK);
        doFileOp(opCopy,useLFN,FALSE,FALSE,FALSE,FALSE,DEBUG,target, backup); (* backup must not change here ! *)
        doStampOp(stamp,dtset,useLFN,backup);
    END;

    IF bornagain THEN
        createEmptyFile(useLFN,target);
        targetcreated:=TRUE;
    END;

    FOR i:=firstparm+1 TO lastparm DO
        IF useme[i] THEN
            Str.Copy(S,parm[i]);

            CASE i OF
            | firstparm+1 :
                IF targetcreated THEN
                    flagcr :=FALSE; (* don't prepend first file with useless separator *)
                    flagsep:=FALSE;
                ELSE
                    flagcr :=addcr;
                    flagsep:=useseparator;
                END;
            ELSE
                flagcr :=addcr;
                flagsep:=useseparator;
            END;

            doFileOp(opAppend,useLFN,flagcr,flagsep,M2remark,filterEOF,DEBUG,S, target);

            IF verbose THEN WrStr(msgProcessed);WrStr(S);WrLn; END;
            IF killglued THEN fileErase(useLFN,S); END; (* RO flag already cared for *)
        END;
    END;

    IF keepstamp THEN doStampOp(stamp,dtset,useLFN,target);END;

    IF verbose THEN
        IF targetcreated THEN
            WrStr(msgCreated);
        ELSE
            WrStr(msgUpdated);
        END;
        WrStr(target);WrLn;
    END;

    abort(errNone,"");
END concat.






(*

@echo off
if "%1" == "" goto help
if "%2" == "" goto help
if "%3" == "" goto help
if not "%4" == "" goto help
goto ok
:help
echo Syntax : %0 fsize1 fsize2 value ( *=random )
goto end
:ok
call fill -o %1 bin1 %3
call fill -o %2 bin2 %3
concat /c /b /debug bin0 bin1 bin2
concat /c /z /n /debug txt0 bin1 bin2
if exist *.Bk! del *.bk!
call ls bin*
call ls txt*
:end

*)



