/*
        Copyright (C) 1994,2006 Matthias Nott <mn@mnsoft.org>

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

/*ÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍ*\
 º         PowerBatch - der ultimative Batch-Enhancer         º
 ÇÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄÄ¶
 º        (c) 1994,2006 Matthias Nott - mn@mnsoft.org   º
\*ÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍÍ*/

#include <dos.h>
#include <conio.h>
#include <ctype.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>

char myname[] = "PowerBatch V1.3 Copyright (C) 1994,2006 Matthias Nott <mn@mnsoft.org>\n\rThis is free software. You may redistribute copies of it under the terms of\n\rthe GNU General Public License <http://www.gnu.org/licenses/gpl.html>.\n\rThere is NO WARRANTY, to the extent permitted by law.\n\r\n\rIf you find this software useful, please consider sending a postcard or an\n\repostcard to the author.\n\r";

/*------------------------------------------------------------*\
 |                Deklaration der Unterprogramme:             |
\*------------------------------------------------------------*/

unsigned char Checkargval(unsigned char argv, unsigned char max);
void Exit(unsigned char errorlevel);
void Fenster(void);
unsigned char Getargval(char argv[]);
void Getscreen(char bool);
int  Input(char x, char y, char l, char numeric, char *target);
void Maus_an(void);
void Maus_aus(void);
void Maus_pos(void);
void Maus_reset(void);
void Menu(void);
void Readdata(char infile[]);
void Screensave_1(void);
void Screensave_2(void);
void Text(void);


/*------------------------------------------------------------*\
 |             Voreinstellung der Programmparameter:          |
\*------------------------------------------------------------*/

struct Parameter
{
 unsigned char b;                                      // Bildschirmschoner
 unsigned char bt;                                     // Zeit fr Bildschirmschoner
 unsigned char fh;                                     // Hintergrund
 unsigned char fk;                                     // Tastenkrzel
 unsigned char fm;                                     // Menbalken
 unsigned char fn;                                     // Schrift unter Menbalken
 unsigned char fr;                                     // Rahmen
 unsigned char fs;                                     // Subline
 unsigned char ft;                                     // Text
 unsigned char fu;                                     // šberschrift
 unsigned char f;                                      // Farben setzen
 unsigned char x;                                      // Horizontaler Anfangspunkt
 unsigned char y;                                      // Vertikaler Anfangspunkt
 unsigned char m;                                      // Men erstellen
 unsigned char mk;                                     // Tastenkrzelsteuerung
 unsigned char mm;                                     // Mausverwendung
 unsigned char ml;                                     // Leerzeilenbehandlung
 unsigned char mx;                                     // StartPosition-x Maus
 unsigned char my;                                     // StartPosition-y Maus
 unsigned char r;                                      // Rahmenart
 unsigned char s;                                      // Schattenart
 unsigned char p;                                      // Piepston
 unsigned char u;                                      // Headline/Subline
 unsigned char ap;                                     // Auswahlautomatik
 unsigned char az;                                     // Wartezeit vor autom. Auswahl
 unsigned char aw;                                     // Wartezeit (Textfenster)
 unsigned char c;                                      // Bildschirm l”schen
 unsigned char o;                                      // Warten auf Tastendruck
 unsigned char i;                                      // Benutzereingabe
} p = {2,  3,  1, 14, 15,  1, 11,  9, 11, 14,0, 0, 0,0, 1, 0, 0, 0, 0,4,2,  0,0,  0,  5,  0,0,0, 0},
 m = {3,255,255,255,255,255,255,255,255,255,1,80,25,1, 1, 2, 1,80,25,5,3,255,3,255,255,255,1,1,80};
//    {b, bt, fh, fk, fm, fn, fr, fs, ft, fu,f, x, y,m,mk,mm,ml,mx,my,r,s,  p,u, ap, az, aw,c,o, i};

/*------------------------------------------------------------*\
 |           Definition der verschiedenen Rahmenarten:        |
\*------------------------------------------------------------*/

struct Rahmen
{
 unsigned char ol;                                     // oben links
 unsigned char or;                                     // oben rechts
 unsigned char ml;                                     // mitte links
 unsigned char mr;                                     // mitte rechts
 unsigned char ul;                                     // unten links
 unsigned char ur;                                     // unten rechts
 unsigned char h;                                      // horizontal
 unsigned char v;                                      // vertikal
 unsigned char t;                                      // Trennstrich fr Men
} r[5] = {{218, 191, 195, 180, 192, 217, 196, 179, 196},
         {201, 187, 199, 182, 200, 188, 205, 186, 196},
         { 32,  32,  32,  32,  32,  32,  32,  32,  32},
         {213, 184, 195, 180, 212, 190, 205, 179, 196},
         {214, 183, 199, 182, 211, 189, 196, 186, 196}};


/*------------------------------------------------------------*\
 |           Deklaration weiterer globaler Variablen:         |
\*------------------------------------------------------------*/

char **str;                                             // Zeilen, die aus der Eingabedatei gelesen werden
char **ctr;                                             // Menkontrolltabelle
char actmen = 0;                                        // Aktiver Menpunkt
char buffer[4096];                                      // Sichern des Fensterhintergrundes
char lines = 0;                                         // Anzahl der Zeilen in der Eingabedatei
char existfile = 0;                                     // "1" == 1. Parameter ist Eingabedatei
char textbreite = 0;                                    // Maximale Zeilenl„nge
char zeilen;                                            // Effektive Textzeilen (ohne Head-/Subline)
char zeile1;                                            // Erste Textzeile in der Eingabedatei
char zeile2;                                            // Letzte Textzeile in der Eingabedatei
char emptyline[81];                                     // Leerzeile
char fensterb = 0;                                      // Fensterbreite
char fensterh = 0;                                      // was sonst.
char offset = 0;                                        // Textversatz mit/ohne Rahmen
char zeile, spalte;                                     // Cursorposition vor Programmbeginn
char MAUS = 0;                                          // Maus oder nicht?
char xpos, ypos, mkey, push;                            // Mausposition
time_t zeit;                                            // -> Bildschirmschoner


/*------------------------------------------------------------*\
 |                     Das Hauptprogramm:                     |
\*------------------------------------------------------------*/

void main(int argc, char **argv)
{
 /*----------------------------------------------------------*\
  |               Deklaration der Variablen:                 |
 \*----------------------------------------------------------*/

 char i;                                               // Laufvariable
 char *target;                                         // Variable fr Input
 char *environment;                                    // Environmentvariable
 char n = strlen(argv[1]) - 1;

 /*----------------------------------------------------------*\
  |     Cursor & Hardcopy sowie Zeilenumbruch abschalten:    |
 \*----------------------------------------------------------*/

 _setcursortype(_NOCURSOR);
 poke(0x50, 0, 1);
 _wscroll = 0;
 zeile = wherey();
 spalte = wherex();
 Getscreen(1);

 /*----------------------------------------------------------*\
  |              Ausgabe des Hilfebildschirmes:              |
 \*----------------------------------------------------------*/


 if((argv[1][n] == 'h') || (argv[1][n] == 'H') || (argv[1][n] == '?') || (argc < 2))
 {
   cprintf("\n\r%s\n\n\r", myname);
   cprintf("Bitte lesen Sie die Programmbeschreibung fr die zugeh”rigen Parameter,\n\r");
   cprintf("mit denen dieses Programm aufgerufen werden muá.\n\r");
   Exit(0);
 }


 /*----------------------------------------------------------*\
  |           Auswerten der Befehlszeilen-Parameter:         |
 \*----------------------------------------------------------*/

 if(argc > 1)
   for (i = existfile; i <= argc; i++)
   {
     if(toupper(argv[i][1]) == 'B')
     {
       if(toupper(argv[i][2]) == 'T') p.bt = Checkargval(Getargval(argv[i]), m.bt);
       if(isdigit(argv[i][2]))        p.b  = Checkargval(Getargval(argv[i]), m.b);
     }
     if(toupper(argv[i][1]) == 'F')
     {
       if(toupper(argv[i][2]) == 'H') p.fh = Checkargval(Getargval(argv[i]), m.fh);
       if(toupper(argv[i][2]) == 'K') p.fk = Checkargval(Getargval(argv[i]), m.fk);
       if(toupper(argv[i][2]) == 'M') p.fm = Checkargval(Getargval(argv[i]), m.fm);
       if(toupper(argv[i][2]) == 'N') p.fn = Checkargval(Getargval(argv[i]), m.fn);
       if(toupper(argv[i][2]) == 'R') p.fr = Checkargval(Getargval(argv[i]), m.fr);
       if(toupper(argv[i][2]) == 'S') p.fs = Checkargval(Getargval(argv[i]), m.fs);
       if(toupper(argv[i][2]) == 'T') p.ft = Checkargval(Getargval(argv[i]), m.ft);
       if(toupper(argv[i][2]) == 'U') p.fu = Checkargval(Getargval(argv[i]), m.fu);
       if(isdigit(argv[i][2]))        p.f  = Checkargval(Getargval(argv[i]), m.f);
     }
     if(toupper(argv[i][1]) == 'X')   p.x  = Checkargval(Getargval(argv[i]), m.x);
     if(toupper(argv[i][1]) == 'Y')   p.y  = Checkargval(Getargval(argv[i]), m.y);
     if(toupper(argv[i][1]) == 'M')
     {
       if(toupper(argv[i][2]) == 'K') p.mk = Checkargval(Getargval(argv[i]), m.mk);
       if(toupper(argv[i][2]) == 'M') p.mm = Checkargval(Getargval(argv[i]), m.mm);
       if(toupper(argv[i][2]) == 'L') p.ml = Checkargval(Getargval(argv[i]), m.ml);
       if(toupper(argv[i][2]) == 'X') p.mx = Checkargval(Getargval(argv[i]), m.mx);
       if(toupper(argv[i][2]) == 'Y') p.my = Checkargval(Getargval(argv[i]), m.my);
       if(isdigit(argv[i][2]))        p.m  = Checkargval(Getargval(argv[i]), m.m);
     }
     if(toupper(argv[i][1]) == 'R')   p.r  = Checkargval(Getargval(argv[i]), m.r);
     if(toupper(argv[i][1]) == 'S')   p.s  = Checkargval(Getargval(argv[i]), m.s);
     if(toupper(argv[i][1]) == 'P')   p.p  = Checkargval(Getargval(argv[i]), m.p);
     if(toupper(argv[i][1]) == 'U')   p.u  = Checkargval(Getargval(argv[i]), m.u);
     if(toupper(argv[i][1]) == 'A')
     {
       if(toupper(argv[i][2]) == 'P') p.ap = Checkargval(Getargval(argv[i]), m.ap);
       if(toupper(argv[i][2]) == 'Z') p.az = Checkargval(Getargval(argv[i]), m.az);
       if(toupper(argv[i][2]) == 'W') p.aw = Checkargval(Getargval(argv[i]), m.aw);
     }
     if(toupper(argv[i][1]) == 'C')   p.c  = Checkargval(Getargval(argv[i]), m.c);
     if(toupper(argv[i][1]) == 'O')   p.o  = Checkargval(Getargval(argv[i]), m.o);
   }

 if((argv[1][0] != '/') && (argv[1][0] != '-') && (!p.i))
 {
   existfile = 1;
   Readdata(argv[1]);
 }


 /*----------------------------------------------------------*\
  |  Fenster anzeigen und Verzweigen zur Text-/Menanzeige:  |
 \*----------------------------------------------------------*/

 if(p.mm == 2)
   Maus_reset();

 if(p.i)          /* -------> Funktioniert noch nicht. <------- */
 {
   if(!p.x)
     p.x = 1;
   if(!p.y)
     p.y = 1;

   if((target = (char *) malloc(p.i*sizeof(char))) == NULL)
     Exit(255);
   if((environment = (char *) malloc((p.i + strlen(argv[i]) + 1) * sizeof(char))) == NULL)
     Exit(255);


   if(Input(p.x, p.y, p.i, 0, target))
   {
     clrscr();
     strcpy(environment, "SET ");
     strcat(environment, argv[1]);
     strcat(environment, "=");
     strcat(environment, target);
     putenv(environment);
     Exit(1);
   }
   else
     Exit(255);
 }


 Fenster();

 if(p.m)
   Menu();
 else
   Text();
 Exit(255);
}


/*------------------------------------------------------------*\
 |                     Program verlassen:                     |
\*------------------------------------------------------------*/

void Exit(unsigned char errorlevel)
{
 /*----------------------------------------------------------*\
  |     Cursor & Hardcopy sowie Zeilenumbruch anschalten:    |
 \*----------------------------------------------------------*/

 _setcursortype(_NORMALCURSOR);
 poke(0x50, 0, 0);
 _wscroll = 1;
 if(errorlevel)
   gotoxy(spalte, zeile);
 Maus_aus();
 if((p.m && !p.o) || (!p.m && p.o) || (!p.m && p.aw))
   Getscreen(0);
 exit(errorlevel);
}


/*------------------------------------------------------------*\
 |                     Parameter checken:                     |
\*------------------------------------------------------------*/

unsigned char Checkargval(unsigned char argv, unsigned char max)
{
 if (argv > max)
 {
   cprintf("\n\r%s\n\n\r", myname);
   cprintf("Fehler: Parameter mit Wert \"%d\" nicht definiert.\n\r", argv);
   cprintf("Maximaler fr diesen Parameter definierter Wert: \"%d\".\r\n", max);
   cprintf("\n\n\rBitte eine Taste drcken!");
   if(!getch())                                        // 2 * getch(), um auch erweiterte
     getch();                                          // Tasten zu erwischen (die bestehen
   Exit(255);                                          // aus 2 Bytes: z.B. Pfeiltasten).
 }
 return(argv);
}


/*------------------------------------------------------------*\
 |                     Einlesen der Daten:                    |
\*------------------------------------------------------------*/

void Readdata(char infile[])
{
 /*----------------------------------------------------------*\
  |               Deklaration der Variablen:                 |
 \*----------------------------------------------------------*/

 char readline[82];                                    // Aktuell gelesene Zeile
 char ctrline[4] = {0, 0, 0, 0};                       // Kontrolltabelle
 FILE *fp;                                             // Eingabedatei
 char i, j, k;                                         // Laufvariablen


 if ((fp = fopen(infile, "r")) == NULL)                // Test, ob es die Eingabedatei gibt
 {
   fclose(fp);
   cprintf("\n\r%s\n\n\r", myname);
   cprintf("Eingabedatei nicht vorhanden!\n\r");
   if(!getch())
     getch();
   Exit(255);
 }

 if((str=(char **)malloc(sizeof(char*))) == NULL)      // Speicher fr **str allokieren
   Exit(255);                                          // (a ;-) to IRC-Danielsi)

 if((ctr=(char **)malloc(sizeof(char*))) == NULL)      // Speicher fr **ctr allokieren
   Exit(255);

 while((fgets(readline, 82, fp) != NULL))              // Maximale Zeilenbreite 82 Zeichen.
 {                                                     // Sonst wird die Zeile NICHT gelesen.
   str[lines]   = strdup(readline);
   ctr[lines++] = strdup(ctrline);
   str=(char **)realloc(str, sizeof(char *)*(lines + 1));
   ctr=(char **)realloc(ctr, sizeof(char *)*(lines + 1));
 }
 fclose(fp);                                           // Datei schlieáen
 lines--;                                              // Weil lines++ implizit verwendet wurde.

 if(p.mk)                                              // Hotkeys einlesen
   for(i = 0; i <= lines; i++)
   {
     for(j = 0; j <= strlen(str[i]); j++)
       if(str[i][j] == '~')
       {
         for(k = j; k < strlen(str[i]); k++)           // Die Hotkeyzeichen '~' sollen nicht
           str[i][k] = str[i][k + 1];                  // angezeigt werden.
         ctr[i][0] = j + 1;                            // Nummer des Hotkeys merken.
         break;                                        // Nur einen Hotkey pro Zeile merken.
       }
     ctr[i][1] = 0;
   }
 else                                                  // Keine Hotkeys?
   for(i = 0; i <= lines; i++)                         // Kontrolltabelle nullen.
     ctr[i][0] = ctr[i][1] = 0;
}


/*------------------------------------------------------------*\
 |          šbernahme von Werten aus der Befehlszeile:        |
\*------------------------------------------------------------*/

unsigned char Getargval(char argv[])
{                                                       // Prinzip: Die Zahlen stehen als Text-
 int  i, f = 1, tmp = 0;                               // String am ENDE eine Argumentes und
 for (i = strlen(argv) - 1; i >= 2; i--)               // werden daher von HINTEN zusammengesetzt
 {                                                     // (255 == 5 * 1 + 5 * 10 + 2 * 100).
   if ((argv[i] >= '0') && (argv[i] <= '9'))
   {
     tmp += (argv[i] - '0') * f;
     if (tmp > 255)                                    // Wir bleiben bei Char-Variablen.
     {                                                 // Ist aber prinzipiell nicht zwingend.
       cprintf("\n\r%s\n\n\r", myname);
       cprintf("Fehler bei \"%s\"\n\r", argv);
       cprintf("Kommandozeilenargumente mssen Betr„ge <= 255 haben!\r\n");
       Exit(255);
     }
     f *= 10;
   }
 }
 return((unsigned char) tmp);
}


/*--------------------------------------------------------------------*\
 |                 Bildschirm speichern/wiederherstellen:             |
\*--------------------------------------------------------------------*/

void Getscreen(char bool)
{
 if(bool)
   gettext(1, 1, 80, 25, buffer);
 else
   puttext(1, 1, 80, 25, buffer);
}


/*------------------------------------------------------------*\
 |                  Erstellen des Fensters:                   |
\*------------------------------------------------------------*/

void Fenster(void)
{
 /*----------------------------------------------------------*\
  |               Deklaration der Variablen:                 |
 \*----------------------------------------------------------*/

 char i, j;                                            // Laufvariablen
 char schatten[3];                                     // Nicht einfach schwarz...!


 /*----------------------------------------------------------*\
  |         Bildschirm l”schen / Piepston ausgeben:          |
 \*----------------------------------------------------------*/

 if(p.c)                                               // Bildschirm l”schen?
   clrscr();

 if(p.p)                                               // Piepston ausgeben?
 {
   sound(5 * p.p);                                     // Frequenzraster 5 Hz.
   delay(100);                                         // Dauer 1/10 Sekunde.
   nosound();
 }

 if((p.f) || (!existfile))                             // Sollen nur Farben gesetzt werden?
 {
   textbackground(p.fh);                               // Hintergrundsfarbe
   textcolor(p.ft);                                    // Vordergrundsfarbe = Textfarbe
   clrscr();                                           // Farbeinstellungen aktivieren.
   Exit(255);                                          // Und tschá.
 }


 /*----------------------------------------------------------*\
  |           Bestimmung der Breite des Fensters:            |
 \*----------------------------------------------------------*/

 for(i = 0; i <= lines; i++)
   textbreite = (textbreite > strlen(str[i])) ? textbreite : strlen(str[i]);
 textbreite--;                                         // Abschlieáendes Return ignorieren.


 /*----------------------------------------------------------*\
  |      Bestimmung der Fensterbreite und Fensterh”he:       |
 \*----------------------------------------------------------*/

 zeile1 = 1;                                           // Erstmal keine šberschrift.
 zeile2 = zeilen = lines + 1;                          // Auch keine Subline.

 fensterb = textbreite;                                // Minimalbreite
 fensterh = lines + 1;                                 // Minimalh”he
 textbreite--;
 if(p.r)                                               // Rahmen?
 {
   textbreite++;
   fensterb += 2;                                      // Rahmen tritt an beiden Seiten
   fensterh += 2;                                      // und oben und unten auf.
 }

 if(p.s)                                               // Schatten?
 {
   fensterb += p.s;                                    // Schattentiefe ist variablel.
   fensterh += 1;                                      // Schattenh”he ist fest (1 Zeichen).
 }

 if((p.u == 1) || (p.u == 3))                          // šberschrift?
 {
   zeile1 = 2;                                         // Erste Textzeile ist die zweite.

   if(p.r)                                             // Auch noch Rahmen?
   {
     fensterh -= 1;                                    // šberschrift ist im Rahmen.
     zeilen -= 1;                                      // Es gibt eine Leerzeile weniger.
   }
 }

 if(p.u > 1)                                           // Subline?
 {
   zeile2 = lines;                                     // letzte Textzeile ist die vorletzte.

   if(p.r)                                             // Auch noch Rahmen?
   {
     fensterh -= 1;                                    // Subline steht im Rahmen.
     zeilen -= 1;                                      // Es gibt eine Leerzeile weniger.
   }
 }


 /*----------------------------------------------------------*\
  |      Bestimmung der oberen linke Ecke des Fensters:      |
 \*----------------------------------------------------------*/

 if(!p.x)                                              // Linker Fensterrand nicht definiert?
   p.x = (80 - fensterb) / 2 + 1;                      // Dann horizontal zentrieren.

 if(!p.y)                                              // Oberer Fensterrand nicht definiert?
   if(!(fensterh == 25))
     p.y = (25 - fensterh) / 2 + 2;                    // Dann vertikal zentrieren.
   else
     p.y = (25 - fensterh) / 2 + 1;                    // (Mit oder ohne Positionskorrektur).


 /*----------------------------------------------------------*\
  |     Test auf korrekte Koordinaten (Fenster zu groá?):    |
 \*----------------------------------------------------------*/

 if((p.x + fensterb > 81) || (p.y + fensterh > 26))
 {
   textcolor(7);                                       // Farben zurcksetzen
   textbackground(0);                                  // (Dos-Normalfarben)
   clrscr();                                           // und aktivieren.
   cprintf("\n\r%s\n\n\r", myname);
   cprintf("Koordinatenfehler! Das Fenster liegt teilweise auáerhalb des Bildschirms!\n\r");

   if(p.x + fensterb > 81)                             // Ist's die Breite?
   {
     if(fensterb > 81)                                 // Ist's wirklich nur die Breite?
       cprintf("Das Fenster ist insgesamt zu breit. Verkrzen Sie die Textzeilen!\n\r");

     if(fensterb <= 81)                                // Oder ist's eine falsche Koordinate?
     {
       cprintf("Das Fenster paát im Prinzip, aber der Anfangspunkt ist zuweit rechts gew„hlt!\n\r");
       cprintf("Weiter rechts als bei /x%d kann das Fenster nicht anfangen.\n\r", (81 - fensterb));
     }
   }

   if(p.y + fensterh > 26)                             // Das ist doch die H”he?
   {
     if(fensterh > 26)                                 // Ist's wirklich nur die H”he?
       cprintf("Das Fenster ist insgesamt zu hoch. Zuviele Textzeilen!\n\r");

     if(fensterh <= 26)                                // Oder ist's eine falsche Koordinate?
     {
       cprintf("Das Fenster paát im Prinzip, aber der Anfangspunkt ist zuweit unten gew„hlt!\n\r");
       cprintf("Weiter unten als bei /y%d kann das Fenster nicht anfangen.\n\n\r", (26 - fensterh));
     }
   }
   cprintf("\n\n\rFolgende Werte wurden gefunden:\n\r");
   cprintf("\n\rBerechneter horizontaler Anfangspunkt (/x):   %d", p.x);
   cprintf("\n\rBerechneter vertikaler   Anfangspunkt (/y):   %d", p.y);
   cprintf("\n\rTextbreite:         %d", textbreite);
   cprintf("\n\rZeilen:             %d", zeilen);
   cprintf("\n\rErste  Textzeile:   %d", zeile1);
   cprintf("\n\rLetzte Textzeile:   %d", zeile2);
   cprintf("\n\rFensterbreite:      %d", fensterb);
   cprintf("\n\rFensterh”he:        %d", fensterh);
   cprintf("\n\n\rBitte eine Taste drcken!");

   if(!getch())
     getch();

   Exit(255);
 }


 /*----------------------------------------------------------*\
  |             Ausgabe des Fensterhintergrundes:            |
 \*----------------------------------------------------------*/

 if(p.mm)
   Maus_aus();

 textbackground(p.fh);                                 // Hintergrundsfarbe w„hlen

 if(p.r)                                               // Wenn ein Rahmen existiert...
   offset = 1;                                         // ... soll er nicht berschrieben werden.

 for(i = 0; i <= textbreite; i++)                      // Schnelle Textausgabe (Aufbau des Fensters):
   emptyline[i] = ' ';                                 // Ausgabe erfolgt zeilenweise, nicht durch
 emptyline[i] = '\0';                                  // for(;x;)for(;y;)!

 for(i = 0; i < zeilen; i++)                           // Und Ausgabe der erst im Speicher erstellten
 {                                                     // Leerzeichen (d.h. Erstellung des Fenster-
   gotoxy(p.x + offset, p.y + offset + i);             // Hintergrundes.
   cprintf("%s", emptyline);
 }


 /*----------------------------------------------------------*\
  |                 Ausgabe des Fensterrahmens:              |
 \*----------------------------------------------------------*/

 if(p.r)
 {
   textcolor(p.fr);                                    // Rahmenfarbe einstellen
   gotoxy(p.x, p.y);                                   // Linke obere Ecke lokalisieren
   cprintf("%c", r[p.r - 1].ol);                       // Rahmenzeichen hinschreiben.
   gotoxy(p.x, p.y + zeilen + 1);                      // Linke untere Ecke...
   cprintf("%c", r[p.r - 1].ul);                       // dto.
   gotoxy(p.x + textbreite + 1, p.y);                  // Obere rechte Ecke...
   cprintf("%c", r[p.r - 1].or);                       // dto.
   gotoxy(p.x + textbreite + 1, p.y + zeilen + 1);     // Untere rechte Ecke...
   cprintf("%c", r[p.r - 1].ur);                       // dto.
   for(i = 1; i < textbreite + 1; i++)                 // Horizontale Striche:
   {
     gotoxy(p.x + i, p.y);                             // Oberer Rand und...
     cprintf("%c", r[p.r - 1].h);
     gotoxy(p.x + i, p.y + zeilen + 1);                // ... unterer Rand
     cprintf("%c", r[p.r - 1].h);
   }
   for(i = 1; i < zeilen + 1; i++)                     // Vertikale Striche:
   {
     gotoxy(p.x, p.y + i);                             // Linker Rand und ...
     cprintf("%c", r[p.r - 1].v);
     gotoxy(p.x + textbreite + 1, p.y + i);            // ... rechter Rand
     cprintf("%c", r[p.r - 1].v);
   }
 }


 /*----------------------------------------------------------*\
  |                Ausgabe des Fensterschattens:             |
 \*----------------------------------------------------------*/

 if(p.s)                                               // Wenn Schatten ausgegeben werden soll
 {
   textcolor(8);                                       // -> Feste Schattenfarbe!
   textbackground(0);                                  // Hintergrund fest schwarz!
   for(i = p.x + p.s; i <= p.x + fensterb - 1; i++)    // Horizontaler Teil...
   {                                                   // Nur ein Zeichen tief...
     j = fensterh + p.y - 1;
     gotoxy(i, j);
     gettext(i, j, i, j, schatten);
     cprintf("%c", schatten[0]);
   }
   for(i = p.x + fensterb - p.s; i <= p.x - 1 + fensterb; i++)
     for(j = p.y + 1; j <= p.y + fensterh - 1; j++)
     {                                                 // Vertikaler Teil...
       gotoxy(i, j);                                   // p.s Zeichen tief...
       gettext(i, j, i, j, schatten);                  // Schattierung, falls etwas im Schatten
       cprintf("%c", schatten[0]);                     // steht, ber gettext()!
     }
 }
}


/*------------------------------------------------------------*\
 |                   Ausgabe des Textes:                      |
\*------------------------------------------------------------*/

void Text(void)
{
 /*----------------------------------------------------------*\
  |               Deklaration der Variablen:                 |
 \*----------------------------------------------------------*/

 char i, j;                                            // Laufvariablen
 char x;                                               // x-Koordinate
 char y;                                               // y-Koordinate

 textbackground(p.fh);                                 // Hintergrundsfarbe einstellen
 textcolor(p.ft);                                      // Textfarbe einstellen


 /*----------------------------------------------------------*\
  |               Ausgabe des Fenstertextes:                 |
 \*----------------------------------------------------------*/

 for(i = zeile1 - 1; i < zeile2; i++)                  // Jetzt werden alle Textzeilen behandelt.
 {
   if(p.y + i + offset == 25)                             // Wenn Bildschirmzeile 25 dran ist, evtl.
     str[i][strlen(str[i])-1] = str[i][strlen(str[i])-2]; // Zeilenschaltung beseitigen (Verhindert
                                                          // Scrollen in Zeile 25, kommt durch fgets).

   x = p.x + offset;                                   // Koordinaten berechnen
   y = p.y + i + 1 - zeile1 + offset;

   if((str[i][1] == '\0') && (p.m) && (p.r) && (!p.ml))
   {                                                   // Ausgabe von Trennstrichen:
     textcolor(p.fr);                                  // Rahmenfarbe setzen
     gotoxy(x - 1, y);                                 // Linken Rahmen lokalisieren
     cprintf("%c", r[p.r - 1].ml);                     // Linker Anschluá an den Rahmen
     for(j = 1; j <= textbreite; j++)                  // Hier werden die Trennstriche
     {                                                 // ausgegeben (von links nach
       gotoxy(x - 1 + j, y);                           // rechts. Verwendet wird das rahmenart-
       cprintf("%c", r[p.r - 1].t);                    // spezifische Trennstrichzeichen r.t
     }
     gotoxy(x + textbreite, y);                        // Rechten Rahmen lokalisieren
     cprintf("%c", r[p.r - 1].mr);                     // Rechter Anschluá an den Rahmen
     textcolor(p.ft);                                  // Und wieder Textfarbe einstellen.
   }
   else
     if(p.m && ctr[i][1])
     {
       textbackground(p.fm);
       textcolor(p.fn);
       gotoxy(x, y);
       cprintf("%s", str[i]);
       for(j = strlen(str[i]); j <= textbreite + 1 - offset; j++)
       {
         gotoxy(x + j - 1, y);
         cprintf(" ");
       }
       textbackground(p.fh);
       textcolor(p.ft);
     }
     else
     {
       gotoxy(x, y);
       cprintf("%s", str[i]);
       if(y == 25)
       {
         gotoxy(1, y);
         cprintf("%c", str[i][0]);
       }

       for(j = strlen(str[i]); j <= textbreite + 1 - offset; j++)
       {
         gotoxy(x + j - 1, y);
         cprintf(" ");
       }
     }

   if((ctr[i][0]) && !(ctr[i][1]) && (p.mk))           // Ausgabe der Tastenkrzel
   {
     gotoxy(x + ctr[i][0] - 1, y);                     // Tastenkrzel lokalisieren
     textcolor(p.fk);                                  // Krzelfarbe einstellen
     cprintf("%c", str[i][ctr[i][0] - 1]);             // Krzel hinschreiben
     textcolor(p.ft);                                  // Und wieder normale Textfarbe.
   }
 }



 /*----------------------------------------------------------*\
  |              Ausgabe der šberschrift/Subline:            |
 \*----------------------------------------------------------*/

 if((p.u == 1) || (p.u == 3))                          // Wenn šberschrift
 {
   textcolor(p.fu);                                    // Textfarbe der šberschrift
   x = p.x - 1 + (textbreite - strlen(str[0])) / 2 + 3;
   y = p.y;
   gotoxy(x, y);
   cprintf("%s", str[0]);                              // Und die šberschrift hinschreiben.
 }


 if(p.u > 1)                                           // Wenn Subline
 {
   textcolor(p.fs);                                    // Textfarbe der Subline
   x = p.x - 1 + (textbreite - strlen(str[lines])) / 2 + 3;

   if(p.r)
     y = p.y + zeilen + 1;
   else
     y = p.y + zeilen - 1;

   if(y == 25)
     str[lines][strlen(str[lines]) - 1] = '\0';        // Verhindert Scrollen in Zeile 25.

   gotoxy(x, y);
   cprintf("%s", str[lines]);                          // Und die Subline hinschreiben.
 }


 /*----------------------------------------------------------*\
  |        Warten auf Tastendruck / PC schalfen legen..      |
 \*----------------------------------------------------------*/

 if(p.aw)
   delay(1000 * p.aw);

 if((p.o) && !(p.m))                                   // Warten auf Tastendruck: aber nur
 {                                                     // bei Textfenstern, nicht in Mens.

   MAUS = p.mm;                                        // Maus einschalten?
   Maus_an();                                          // Wenn ja, dann ja.
   Maus_pos();                                         // Und Maus positionieren.

   zeit = time(NULL);                                  // Zeit auslesen

   while(!kbhit())                                     // Solange keine Taste...
   {
     if(p.b && (difftime(time(NULL), zeit) >= p.bt * 60))  // Bildschirmschoner
       if(p.b <= 2)
         Screensave_1();
       else
         Screensave_2();

     if(!MAUS)                                         // Alles Folgende nur mit Maus
       continue;

     _AX=0x03;                                         // Mausstatus abfragen
     asm INT 0x33

     xpos = (_CX >> 3) + 1;                            // X-Koordinate
     ypos = (_DX >> 3) + 1;                            // Y-Koordinate
     mkey = _BX;                                       // Gedrckte Maustaste

     if(mkey)                                          // Wenn gedrckt
     {
       do                                              // Warten auf Loslassen.
       {
         _AX=0x03;
         asm INT 0x33
         push = _BX;
       } while(push);
       Maus_aus();                                     // Maus abschalten
       return;                                         // und tschá!
     }
   }
   if(!getch())                                        // Tastaturabfrage
     getch();                                          // Sondertasten abfangen
   Maus_aus();                                         // Maus abschalten
 }
}


/*------------------------------------------------------------*\
 |                      Mensteuerung:                        |
\*------------------------------------------------------------*/

void Menu(void)
{
 /*----------------------------------------------------------*\
  |               Deklaration der Variablen:                 |
 \*----------------------------------------------------------*/

 char i;                                               // Laufvariable
 char l;                                               // Gedrckte Taste

 /*----------------------------------------------------------*\
  |                 Maus-/Tastaturabfrage:                   |
 \*----------------------------------------------------------*/

 Maus_pos();                                           // Maus positionieren

 if(p.ap)
 {
   ctr[actmen][1] = 0;
   ctr[p.ap - 1][1] = 1;
   actmen = p.ap - 1;
   Maus_aus();
   Text();
   Maus_an();
 }

 Menu:
 l = 0;                                                // Keine Taste gedrckt!
 Maus_aus();                                           // Maus abschalten zum Menaufbau
 ctr[actmen][1] = 1;                                   // Aktuellen Menpunkt setzen
 Text();                                               // Mentext aufbauen
 Maus_an();                                            // Maus einschalten

 zeit = time(NULL);                                    // Zeit auslesen

 while(!kbhit())
 {
   if(p.b && (difftime(time(NULL), zeit) >= p.bt * 60))   // Bildschirmschoner
     if(p.b <= 2)
       Screensave_1();
     else
       Screensave_2();

   if(p.ap && (difftime(time(NULL), zeit) >= p.az))
     Exit(p.ap);

   if(!MAUS)                                           // Bis hierher ohne Maus
     continue;

   _AX=0x03;                                           // Mausstatus abfragen
   asm INT 0x33

   xpos = (_CX >> 3) + 1;                              // Maus-x-Koordinate
   ypos = (_DX >> 3) + 1;                              // Maus-y-Koordinate
   mkey = _BX;                                         // Gedrckte Maustaste

   if(mkey)                                            // Wenn Maustaste gedrckt...
   {
     do                                                // ... Warten auf Loslassen.
     {
       _AX=0x03;
       asm INT 0x33
       push = _BX;
     } while(push);
   }

   if(mkey == 1)                                       // Wenn linke Maustaste...
   {
     for(i = 0; i <= lines; i ++)
     {
       if((xpos >= p.x + offset) &&                    // Koordinatenvergleich
          (xpos <= p.x + textbreite) &&
          (ypos == p.y + offset + i) &&
          (str[i][1] != '\0'))
       {                                               // Wenn's ein Menpunkt war...
         ctr[actmen][1] = 0;                           // alten deaktivieren
         ctr[i][1] = 1;                                // neuen aktivieren
         actmen = i;                                   // aktivierten merken
         Maus_aus();                                   // Maus abschalten
         Text();                                       // Mentext neu aufbauen
         Maus_an();                                    // Maus anschalten
         Exit(i + 1);                                  // und Menpunkt (Zeile) in Errorlevel.
       }                                               // (und tschá).
     }
   }

   if(mkey == 2)
     Exit(255);
 }

 p.ap = 0;

 switch(l = getch())
 {
   case 0:
     switch(l = getch())
     {
       case 72:
         ctr[actmen][1] = 0;
         for(i = actmen; i >= 0; i--)
           if((str[i][1] != '\0') && (i != actmen))
           {
             actmen = i;
             goto Menu;
           }
         for(i = lines; i >= actmen; i--)
           if((str[i][1] != '\0') && (i != actmen))
           {
             actmen = i;
             goto Menu;
           }
         goto Menu;

       case 80:
         ctr[actmen][1] = 0;
         for(i = actmen; i <= lines; i++)
           if((str[i][1] != '\0') && (i != actmen))
           {
             actmen = i;
             goto Menu;
           }
         for(i = 0; i <= actmen; i++)
           if((str[i][1] != '\0') && (i != actmen))
           {
             actmen = i;
             goto Menu;
           }
         goto Menu;

       default:
         goto Menu;
     }

   case 13:
     Exit(actmen + 1);

   case 27:
     Exit(255);
 }

 for(i = 0; i <= lines; i++)
 {
   if((toupper(l) == toupper(str[i][ctr[i][0] - 1])) && (str[i][1] != '\0'))
   {
     ctr[actmen][1] = 0;
     ctr[i][1] = 1;
     actmen = i;
     goto Menu;
   }
 }
 goto Menu;
}


/*--------------------------------------------------------------------*\
 |                          Maus abschalten:                          |
\*--------------------------------------------------------------------*/

void Maus_aus(void)
{
 if(!p.mm || !MAUS)
   return;

 _AX=0x02;
 asm INT 0x33
 MAUS = 0;
}


/*--------------------------------------------------------------------*\
 |                          Maus anschalten:                          |
\*--------------------------------------------------------------------*/

void Maus_an(void)
{
 if(!p.mm)
   return;

 _AX=0x01;
 asm INT 0x33
 MAUS = 1;

 _AX=0x03;                                             // Mausstatus abfragen
 asm INT 0x33

 xpos = (_CX >> 3) + 1;                                // Maus-x-Koordinate
 ypos = (_DX >> 3) + 1;                                // Maus-y-Koordinate
 mkey = _BX;                                           // Gedrckte Maustaste

 if(mkey)                                              // Wenn Maustaste gedrckt...
 {
   do                                                  // ... Warten auf Loslassen.
   {
     _AX=0x03;
     asm INT 0x33
     push = _BX;
   } while(push);
 }
}


/*--------------------------------------------------------------------*\
 |                          Maus positionieren:                       |
\*--------------------------------------------------------------------*/

void Maus_pos(void)
{
 unsigned int x;
 unsigned int y;
 if(!p.mx || !p.my)
 {
   p.mx = p.x + (textbreite + offset)/2;
   p.my = p.y + (lines + offset*2)/2;
 }

 x = (unsigned int) (p.mx - 1) * 8;
 y = (unsigned int) (p.my - 1) * 8;

 if(p.mm)
 {
   _AX = 0x04;
   _BX = 0;
   _CX = x;
   _DX = y;
   asm INT 0x33
 }
}


/*--------------------------------------------------------------------*\
 |                             Maus Reset:                            |
\*--------------------------------------------------------------------*/

void Maus_reset(void)
{

 int x, y;

 if(!p.mm)
   return;

 _AX = 0x03;
 asm INT 0x33

 x = _CX;
 y = _DX;

 _AX=0x00;
 asm INT 0x33

 _AX = 0x21;
 asm INT 0x33

 _AX = 0x01;
 asm INT 0x33

 _AX = 0x04;
 _BX = 0;
 _CX = x;
 _DX = y;
 asm INT 0x33
 MAUS = 1;
}


/*--------------------------------------------------------------------*\
 |                          Bildschirmschoner:                        |
\*--------------------------------------------------------------------*/

void Screensave_1(void)
{
 time_t t;
 char i;
 char now[26];
 char puffer[4096];
 Maus_aus();
 gettext(1, 1, 80, 25, puffer);
 textcolor(0);
 textbackground(0);
 clrscr();

 do
 {
   if(p.b == 2)
   {
     textcolor(7);
     time(&t);
     strcpy(now, ctime(&t));
     for(i = 11; i <= 18; i++)
       now[i - 11] = now[i];
     now[2] = '.';
     now[8] = '\0';
     gotoxy(73, 25);
     cprintf("%s", now);
   }
 }
 while(!kbhit());

 if(!getch())
  getch();
 zeit = time(NULL);
 textcolor(p.ft);
 textbackground(p.fh);
 puttext(1, 1, 80, 25, puffer);
 Maus_an();
}


void Screensave_2(void)
{
 char i, y = 25;
 char buffer[25][200];
 char bufferlist[26];
 char puffer[4096];

 Maus_aus();

 for(i = 1; i <= 25; i++)
   gettext(1, i, 80, i, buffer[i-1]);
 gettext(1, 1, 80, 25, puffer);

 do
 {
   if ( y-- == 1 ) y = 25;

   for ( i = y; i <= 25; i++ )
     bufferlist[i] = i - y + 1;

   for ( i = 1; i < y; i++ )
     bufferlist[i] = 25 - y + i + 1;

   for ( i = 1; i <= 25; i++)
     puttext(1, i, 80, i, buffer[bufferlist[i]-1]);
   delay(25);

 }while(!kbhit());
 if(!getch())
   getch();
 zeit = time(NULL);
 puttext(1, 1, 80, 25, puffer);
 Maus_an();
}


/*-------------------------------------------------------------------*\
 |             Eingaberoutine zur Eingabe von Textstrings:           |
 |                                                                   |
 |      Parameter:    x, y:   Position am Bildschirm;                |
 |                       l:   L„nge des einzugebenden Strings.       |
 |                 numeric:   0 = Zahlen und Buchstaben;             |
 |                            1 = nur Zahlen;                        |
 |                 *target:   Zielarray.                             |
\*-------------------------------------------------------------------*/

int  Input(char x, char y, char l, char numeric, char *target)
{
 /*-----------------------------------------------------------------*\
  |                     Deklaration der Variablen:                  |
 \*-----------------------------------------------------------------*/

 int  i;
 char t;
 char *clear;
 textcolor(p.ft);
 textbackground(p.fh);
 _setcursortype(_NORMALCURSOR);


 /*-----------------------------------------------------------------*\
  |                  Initialisierung des Zielstrings:               |
 \*-----------------------------------------------------------------*/

 clear = target;
 for(i = 1; i <= l; i++)
   *clear++ = ' ';
 *clear++ = '\0';

 for(i = 0; i <  l; i++)
 {
   gotoxy(x + i, y);
   cprintf(" ");
 }

 i = 0;

 /*-----------------------------------------------------------------*\
  |                          Eingaberoutine:                        |
 \*-----------------------------------------------------------------*/

 while (i <= l)
 {
   // Eingabe:
   gotoxy(x + i, y);


   /*--------------------------------------------------------------*\
    |                   Abfrage der Tastatur/Maus:                 |
   \*--------------------------------------------------------------*/

   t=getch();


   // Enter?
   if ((t == 13) && (numeric == 2))
   {
     *target++ = '\0';
     _setcursortype(_NOCURSOR);
     return(1);
   }

   // Enter und volle Zeichenzahl?
   // -> Abschlieáen und tschá!
   if ((i == l) && (t == 13))
   {
     *target++ = '\0';
     _setcursortype(_NOCURSOR);
     return(1);
   }

   // ESC? -> Abbrechen!
   if (t == 27)
   {
     _setcursortype(_NOCURSOR);
     return(0);
   }

   // Nicht volle Zeichenzahl, nicht Backspace, nicht nur numerisch?
   // -> Ein neues Zeichen!
   // Aufschreiben und weiter im Text...
   if ((i < l) && (t != '\b') && (!numeric))
   {
     gotoxy(x + i++, y); cprintf("%c", *target++ = t);
     continue;
   }

   // Nicht volle Zeichenzahl, numerisch?
   // -> Eine neue Zahl!
   // Aufschreiben und weiter im Text...
   if ((i < l) && (t >= '0') && (t <= '9'))
   {
     gotoxy(x + i++, y); cprintf("%c", *target++ = t);
     continue;
   }

   // War es nichts von alledem? Und wurde berhaupt schon
   // etwas eingegeben? -> L”sche die letzte Stelle.
   if (i > 0)
   {
     gotoxy(x + --i, y); cprintf(" ");
     *target--;
     *target = ' ';
   }
 }
 return(0);                                            // Just to tease compiler...
}
