/*
 * This file is part of the FDNPKG project.
 * 
 * Provides a simplistic HTTP downloader.
 */

#include "net.h"

#define buffer_max 4096

/* returns 0 on success, non-zero otherwise
   Warning: Requires net_init() to be run before! */
int http_get(char *orgurl, char *outputfile) {
  char *host = NULL;
  char *path = NULL;
  char *buffer = NULL;
  int port, result = -1;
  unsigned long ipaddr;
  int x;
  int reslength = 0, fdlen = 0;
  struct net_tcpsocket *socket;

  /* valide input data */
  if ((orgurl == NULL) || (outputfile == NULL)) return(-1);

  for (;;) { /* not a real loop, just a container allowing to break out easily */
    x = strlen(orgurl) + 1;
    host = malloc(x);
    if (host == NULL) return(-1);
    path = malloc(x);
    if (path == NULL) break;
    buffer = malloc(buffer_max);
    if (buffer == NULL) break;

    x = parseurl(orgurl, host, &port, path);
    if (x != PARSEURL_PROTO_HTTP) break;

    ipaddr = net_dnsresolve(host);
    if (ipaddr == 0) break;

    socket = net_connect(ipaddr, port);

    if (socket == NULL) break;

    sprintf(buffer, "GET /%s HTTP/1.0\r\nHOST: %s\r\nUSER-AGENT: FDNPKG\r\n\r\n");

    if (net_send(socket, buffer, strlen(buffer)) != (int)strlen(buffer)) {
      net_abort(sock);
      break;
    }
  
    fd = fopen(filename, "wb"); /* try to open for read - this should fail */
    if (fd == NULL) { /* this should not fail */
      fclose(fd);
      net_abort(sock);
      break;
    }
    for (;;) {
      byteread = net_recv(sock, buffer + (reslength - fdlen), buffer_max + fdlen - reslength);
      curtime = time(NULL);
      if (byteread < 0) break; /* end of connection */
      if (byteread > 0) {
        if (headersdone == 0) {
            int i;
            for (i = 0; i < reslength - 2; i++) {
              if (buffer[i] == '\n') {
                if (buffer[i + 1] == '\r') i++; /* skip CR if following */
                if (buffer[i + 1] == '\n') {
                  i += 2;
                  headersdone = reslength;
                  for (reslength = 0; i < headersdone; i++) buffer[reslength++] = buffer[i];
                  break;
                }
              }
            }
          } else {
            printf("Downloading... %ld bytes                ", reslength);
            if (reslength - fdlen > 1024) { /* write stuff to disk when needed */
              int writeres = fwrite(buffer, 1, reslength - fdlen, fd);
              if (writeres < 0) writeres = 0;
              fdlen += writeres;
            }
        }
      }
    }
    if (reslength >= 0) { /* close the connection nicely */
        net_close(sock);
      } else { /* abort asap on error */
        net_abort(sock);
    }
    /* finish the buffer */
    if (reslength - fdlen > 0) { /* if anything left in the buffer, write it now */
      fdlen += fwrite(buffer, 1, reslength - fdlen, fd);
    }
    fclose(fd);
    printf("Saved %ld bytes on disk                ", fdlen);
    break;
  }
  if (host != NULL) free(host);
  if (host != NULL) free(path);
  if (host != NULL) free(buffer);
  return(result);
}
