/*
    JPC: A x86 PC Hardware Emulator for a pure Java Virtual Machine
    Release Version 2.0

    A project from the Physics Dept, The University of Oxford

    Copyright (C) 2007 Isis Innovation Limited

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as published by
    the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 
    Details (including contact information) can be found at: 

    www.physics.ox.ac.uk/jpc
*/

package org.jpc.sourcecompiler;

import java.io.Serializable;
import org.jpc.emulator.memory.codeblock.*;
import org.jpc.emulator.processor.*;

public class RealModeCodeBlockBytes implements RealModeCodeBlock, Serializable
{
    transient CodeBlock block = null;
    byte[] classBytes = null;
    String className;

    public RealModeCodeBlockBytes() {}

    public void setClassName(String name)
    {
        this.className = name;
    }

    public String className()
    {
        return className;
    }

    public void setBlock(CodeBlock block)
    {
        this.block = block;
    }

    public CodeBlock getBlock()
    {
        return block;
    }

    public void setBytes(byte[] bytes)
    {
        this.classBytes = bytes;
    }

    public byte[] getBytes()
    {
        return classBytes;
    }

    public int getX86Length()
    {
        return block.getX86Length();
    }

    public int getX86Count()
    {
        return block.getX86Count();
    }

    // Returns the number of equivalent x86 instructions executed. Negative results indicate an error
    public int execute(Processor cpu)
    {
        return block.execute(cpu);
    }

    public boolean handleMemoryRegionChange(int startAddress, int endAddress)
    {
        return false;
    }

    public String getDisplayString()
    {
        return block.getDisplayString();
    }
}

