/*
    JPC: A x86 PC Hardware Emulator for a pure Java Virtual Machine
    Release Version 2.0

    A project from the Physics Dept, The University of Oxford

    Copyright (C) 2007 Isis Innovation Limited

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as published by
    the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 
    Details (including contact information) can be found at: 

    www.physics.ox.ac.uk/jpc
*/

package org.jpc.emulator.memory.codeblock.optimised;

public interface MicrocodeSet
{
    //Rough Frequency Ordered Microcodes
    public static final int MEM_RESET = 0;
    public static final int ADDR_MASK16 = 1;
    public static final int EIP_UPDATE = 2;
    public static final int ADDR_IB = 3;
    public static final int PUSH_O16_A16 = 4;
    public static final int LOAD_SEG_SS = 5;
    public static final int LOAD0_AX = 6;
    public static final int ADDR_BP = 7;
    public static final int LOAD0_IB = 8;
    public static final int LOAD0_MEM_WORD = 9;

    public static final int STORE1_ESP = 10;
    public static final int POP_O16_A16 = 11;
    public static final int STORE0_AX = 12;
    public static final int LOAD0_IW = 13;
    public static final int LOAD_SEG_DS = 14;
    public static final int STORE0_BX = 15;
    public static final int SUB = 16;
    public static final int STORE0_BP = 17;
    public static final int ADDR_BX = 18;
    public static final int LOAD0_SP = 19;

    public static final int ADD = 20;
    public static final int STORE0_MEM_WORD = 21;
    public static final int LOAD0_MEM_BYTE = 22;
    public static final int JNZ_O8 = 23;
    public static final int STORE0_AL = 24;
    public static final int LOAD0_BX = 25;
    public static final int LOAD1_IB = 26;
    public static final int LOAD1_IW = 27;
    public static final int CALL_O16_A16 = 28;
    public static final int STORE0_CX = 29;

    public static final int LOAD0_CX = 30;
    public static final int LOAD0_BP = 31;
    public static final int RET_O16_A16 = 32;
    public static final int STORE0_SP = 33;
    public static final int LOAD0_AL = 34;
    public static final int ADD_O16_FLAGS = 35;
    public static final int SUB_O16_FLAGS = 36;
    public static final int STORE0_DS = 37;
    public static final int LOAD0_DX = 38;
    public static final int BITWISE_FLAGS_O8 = 39;

    public static final int STORE0_SI = 40;
    public static final int XOR = 41;
    public static final int STORE0_DX = 42;
    public static final int ADDR_SI = 43;
    public static final int SUB_O8_FLAGS = 44;
    public static final int JZ_O8 = 45;
    public static final int LOAD0_AH = 46;
    public static final int STORE0_DI = 47;
    public static final int LOAD0_SI = 48;
    public static final int ADDR_IW = 49;

    public static final int BITWISE_FLAGS_O16 = 50;
    public static final int LOAD0_DS = 51;
    public static final int LOAD1_MEM_WORD = 52;
    public static final int LOAD0_DI = 53;
    public static final int INC = 54;
    public static final int STORE0_ES = 55;
    public static final int INC_O16_FLAGS = 56;
    public static final int AND = 57;
    public static final int STORE0_BH = 58;
    public static final int LOAD_SEG_ES = 59;

    public static final int STORE0_AH = 60;
    public static final int LOAD1_CX = 61;
    public static final int ADD_O8_FLAGS = 62;
    public static final int LOAD1_AX = 63;
    public static final int LOAD1_BH = 64;
    public static final int LOAD0_BH = 65;
    public static final int STORE0_MEM_BYTE = 66;
    public static final int LOAD0_ES = 67;
    public static final int LOAD1_AH = 68;
    public static final int ADC = 69;

    public static final int JUMP_O8 = 70;
    public static final int JNC_O8 = 71;
    public static final int JC_O8 = 72;
    public static final int LOAD1_AL = 73;
    public static final int ADC_O16_FLAGS = 74;
    public static final int JUMP_O16 = 75;
    public static final int LOAD_SEG_CS = 76;
    public static final int DEC = 77;
    public static final int DEC_O16_FLAGS = 78;
    public static final int LOAD0_ADDR = 79;

    public static final int SHL = 80;
    public static final int STORE0_BL = 81;
    public static final int SHL_O16_FLAGS = 82;
    public static final int LOAD1_BX = 83;
    public static final int OR = 84;
    public static final int STORE1_ES = 85;
    public static final int STORE1_AX = 86;
    public static final int LOAD1_DI = 87;
    public static final int LOAD1_MEM_BYTE = 88;
    public static final int JCXZ = 89;

    public static final int LOAD1_SI = 90;
    public static final int STORE1_DS = 91;
    public static final int LOAD1_CL = 92;
    public static final int JUMP_ABS_O16 = 93;
    public static final int STORE0_CL = 94;
    public static final int ADDR_DI = 95;
    public static final int SHR = 96;
    public static final int SHR_O16_FLAGS = 97;
    public static final int JA_O8 = 98;
    public static final int JNA_O8 = 99;

    public static final int INT_O16_A16 = 100;
    public static final int STI = 101;
    public static final int ADC_O8_FLAGS = 102;
    public static final int OUT_O8 = 103;
    public static final int JZ_O16 = 104;
    public static final int JL_O8 = 105;
    public static final int IRET_O16_A16 = 106;
    public static final int PUSHF_O16_A16 = 107;
    public static final int IMULA_O16 = 108;
    public static final int LOAD1_DX = 109;

    public static final int CLD = 110;
    public static final int LOAD0_DL = 111;
    public static final int SIGN_EXTEND_8_16 = 112;
    public static final int MOVSB_A16 = 113;
    public static final int LOOP_CX = 114;
    public static final int RET_IW_O16_A16 = 115;
    public static final int STORE0_DL = 116;
    public static final int IN_O8 = 117;
    public static final int SBB = 118;
    public static final int POPF_O16_A16 = 119;

    public static final int SBB_O16_FLAGS = 120;
    public static final int LODSB_A16 = 121;
    public static final int POPA_A16 = 122;
    public static final int PUSHA_A16 = 123;
    public static final int LOAD1_DL = 124;
    public static final int REP_MOVSB_A16 = 125;
    public static final int NOT = 126;
    public static final int LOAD1_BP = 127;
    public static final int REP_MOVSW_A16 = 128;
    public static final int LOAD0_BL = 129;

    public static final int DIV_O16 = 130;
    public static final int MUL_O16 = 131;
    public static final int LOAD0_SS = 132;
    public static final int CLI = 133;
    public static final int JNZ_O16 = 134;
    public static final int LOAD0_CL = 135;
    public static final int JG_O8 = 136;
    public static final int CALL_FAR_O16_A16 = 137;
    public static final int RET_FAR_O16_A16 = 138;
    public static final int STORE0_SS = 139;

    public static final int JUMP_FAR_O16 = 140;
    public static final int CWD = 141;
    public static final int STORE0_CH = 142;
    public static final int LOAD1_CH = 143;
    public static final int LOAD0_CH = 144;
    public static final int IDIV_O16 = 145;
    public static final int STOSB_A16 = 146;
    public static final int JNL_O8 = 147;
    public static final int DEC_O8_FLAGS = 148;
    public static final int INC_O8_FLAGS = 149;

    public static final int LOAD0_EAX = 150;
    public static final int RET_FAR_IW_O16_A16 = 151;
    public static final int LOAD1_BL = 152;
    public static final int STORE0_EAX = 153;
    public static final int JNG_O8 = 154;
    public static final int LODSW_A16 = 155;
    public static final int REPE_CMPSB_A16 = 156;
    public static final int ENTER_O16_A16 = 157;
    public static final int LEAVE_O16_A16 = 158;
    public static final int STORE0_MEM_DWORD = 159;

    public static final int ROR_O8_FLAGS = 160;
    public static final int ROR_O8 = 161;
    public static final int POP_O32_A16 = 162;
    public static final int PUSH_O32_A16 = 163;
    public static final int REPNE_SCASB_A16 = 164;
    public static final int SUB_O32_FLAGS = 165;
    public static final int LOAD1_ID = 166;
    public static final int LOAD0_MEM_DWORD = 167;
    public static final int INC_O32_FLAGS = 168;
    public static final int LOAD0_CS = 169;

    public static final int STORE1_DI = 170;
    public static final int LAHF = 171;
    public static final int STORE0_DH = 172;
    public static final int LOAD0_DH = 173;
    public static final int LOAD1_DH = 174;
    public static final int CALL_ABS_O16_A16 = 175;
    public static final int JC_O16 = 176;
    public static final int REP_STOSW_A16 = 177;
    public static final int STORE1_CL = 178;
    public static final int SBB_O8_FLAGS = 179;

    public static final int NEG = 180;
    public static final int NEG_O16_FLAGS = 181;
    public static final int SHL_O8_FLAGS = 182;
    public static final int JNC_O16 = 183;
    public static final int STOSW_A16 = 184;
    public static final int MUL_O8 = 185;
    public static final int DIV_O8 = 186;
    public static final int LOAD1_SP = 187;
    public static final int STORE1_MEM_WORD = 188;
    public static final int BITWISE_FLAGS_O32 = 189;

    public static final int LOAD1_EAX = 190;
    public static final int NOOP = 191;
    public static final int STC = 192;
    public static final int CLC = 193;
    public static final int LOOPZ_CX = 194;
    public static final int SAR_O16_FLAGS = 195;
    public static final int SAR_O16 = 196;
    public static final int LOAD0_EBX = 197;
    public static final int STORE0_EBX = 198;
    public static final int JNS_O8 = 199;

    public static final int ADD_O32_FLAGS = 200;
    public static final int LOAD0_ECX = 201;
    public static final int LOAD0_ESI = 202;
    public static final int STORE0_ECX = 203;
    public static final int STORE0_EDI = 204;
    public static final int STORE0_ESI = 205;
    public static final int LOAD0_EDI = 206;
    public static final int STORE0_EDX = 207;
    public static final int SHR_O32_FLAGS = 208;
    public static final int SHR_O8_FLAGS = 209;

    public static final int RCL_O16_FLAGS = 210;
    public static final int RCL_O16 = 211;
    public static final int JA_O16 = 212;
    public static final int LOAD1_MEM_DWORD = 213;
    public static final int SHL_O32_FLAGS = 214;
    public static final int LOAD1_EDX = 215;
    public static final int STORE1_AL = 216;
    public static final int LOAD1_ECX = 217;
    public static final int LOAD0_EDX = 218;
    public static final int MOVSW_A16 = 219;

    public static final int LOAD1_EBX = 220;
    public static final int LOAD1_EDI = 221;
    public static final int LOAD0_CR0 = 222;
    public static final int STORE0_CR0 = 223;
    public static final int NEG_O8_FLAGS = 224;
    public static final int LGDT_O16 = 225;
    public static final int SMSW = 226;
    public static final int ADDR_ID = 227;
    public static final int OUT_O16 = 228;
    public static final int POPAD_A16 = 229;

    public static final int PUSHAD_A16 = 230;
    public static final int STORE1_SI = 231;
    public static final int STORE1_MEM_BYTE = 232;
    public static final int MUL_O32 = 233;
    public static final int SETC = 234;

    //Operand Microcodes
    public static final int LOAD0_ESP = 235;
    public static final int LOAD0_EBP = 236;

    public static final int LOAD0_FS = 237;
    public static final int LOAD0_GS = 238;

    public static final int LOAD0_CR2 = 239;
    public static final int LOAD0_CR3 = 240;
    public static final int LOAD0_CR4 = 241;

    public static final int LOAD0_DR0 = 242;
    public static final int LOAD0_DR1 = 243;
    public static final int LOAD0_DR2 = 244;
    public static final int LOAD0_DR3 = 245;
    public static final int LOAD0_DR6 = 246;
    public static final int LOAD0_DR7 = 247;

    public static final int LOAD0_MEM_QWORD = 248;

    public static final int LOAD0_ID = 249;

    public static final int STORE0_ESP = 250;
    public static final int STORE0_EBP = 251;

    public static final int STORE0_CS = 252;
    public static final int STORE0_FS = 253;
    public static final int STORE0_GS = 254;

    public static final int STORE0_CR2 = 255;
    public static final int STORE0_CR3 = 256;
    public static final int STORE0_CR4 = 257;

    public static final int STORE0_DR0 = 258;
    public static final int STORE0_DR1 = 259;
    public static final int STORE0_DR2 = 260;
    public static final int STORE0_DR3 = 261;
    public static final int STORE0_DR6 = 262;
    public static final int STORE0_DR7 = 263;


    public static final int LOAD1_ESP = 264;
    public static final int LOAD1_EBP = 265;
    public static final int LOAD1_ESI = 266;

    public static final int STORE1_EAX = 267;
    public static final int STORE1_ECX = 268;
    public static final int STORE1_EDX = 269;
    public static final int STORE1_EBX = 270;
    public static final int STORE1_EBP = 271;
    public static final int STORE1_ESI = 272;
    public static final int STORE1_EDI = 273;

    public static final int STORE1_CX = 274;
    public static final int STORE1_DX = 275;
    public static final int STORE1_BX = 276;
    public static final int STORE1_SP = 277;
    public static final int STORE1_BP = 278;

    public static final int STORE1_DL = 279;
    public static final int STORE1_BL = 280;
    public static final int STORE1_AH = 281;
    public static final int STORE1_CH = 282;
    public static final int STORE1_DH = 283;
    public static final int STORE1_BH = 284;

    public static final int STORE1_CS = 285;
    public static final int STORE1_SS = 286;
    public static final int STORE1_FS = 287;
    public static final int STORE1_GS = 288;

    public static final int STORE1_MEM_DWORD = 289;

    public static final int LOAD2_EAX = 290;
    public static final int LOAD2_AX = 291;
    public static final int LOAD2_AL = 292;
    public static final int LOAD2_CL = 293;
    public static final int LOAD2_IB = 294;

    public static final int LOAD_SEG_FS = 295;
    public static final int LOAD_SEG_GS = 296;

    public static final int ADDR_REG1 = 297;
    public static final int ADDR_2REG1 = 298;
    public static final int ADDR_4REG1 = 299;
    public static final int ADDR_8REG1 = 300;

    public static final int ADDR_EAX = 301;
    public static final int ADDR_ECX = 302;
    public static final int ADDR_EDX = 303;
    public static final int ADDR_EBX = 304;
    public static final int ADDR_ESP = 305;
    public static final int ADDR_EBP = 306;
    public static final int ADDR_ESI = 307;
    public static final int ADDR_EDI = 308;

    public static final int ADDR_AX = 309;
    public static final int ADDR_CX = 310;
    public static final int ADDR_DX = 311;
    public static final int ADDR_SP = 312;

    public static final int ADDR_2EAX = 313;
    public static final int ADDR_2ECX = 314;
    public static final int ADDR_2EDX = 315;
    public static final int ADDR_2EBX = 316;
    public static final int ADDR_2ESP = 317;
    public static final int ADDR_2EBP = 318;
    public static final int ADDR_2ESI = 319;
    public static final int ADDR_2EDI = 320;

    public static final int ADDR_4EAX = 321;
    public static final int ADDR_4ECX = 322;
    public static final int ADDR_4EDX = 323;
    public static final int ADDR_4EBX = 324;
    public static final int ADDR_4ESP = 325;
    public static final int ADDR_4EBP = 326;
    public static final int ADDR_4ESI = 327;
    public static final int ADDR_4EDI = 328;

    public static final int ADDR_8EAX = 329;
    public static final int ADDR_8ECX = 330;
    public static final int ADDR_8EDX = 331;
    public static final int ADDR_8EBX = 332;
    public static final int ADDR_8ESP = 333;
    public static final int ADDR_8EBP = 334;
    public static final int ADDR_8ESI = 335;
    public static final int ADDR_8EDI = 336;

    public static final int ADDR_uAL = 337;

    //Operation Microcodes
    public static final int JUMP_FAR_O32 = 338;

    public static final int JUMP_ABS_O32 = 339;

    public static final int CALL_FAR_O32_A16 = 340;
    public static final int CALL_FAR_O16_A32 = 341;
    public static final int CALL_FAR_O32_A32 = 342;

    public static final int CALL_ABS_O32_A16 = 343;
    public static final int CALL_ABS_O16_A32 = 344;
    public static final int CALL_ABS_O32_A32 = 345;

    public static final int IMUL_O16 = 346;
    public static final int IMUL_O32 = 347;

    public static final int IMULA_O8 = 348;
    public static final int IMULA_O32 = 349;

    public static final int DIV_O32 = 350;

    public static final int IDIV_O8 = 351;
    public static final int IDIV_O32 = 352;

    public static final int SAR_O8 = 353;
    public static final int SAR_O32 = 354;

    public static final int ROL_O8 = 355;
    public static final int ROL_O16 = 356;
    public static final int ROL_O32 = 357;

    public static final int ROR_O16 = 358;
    public static final int ROR_O32 = 359;

    public static final int RCL_O8 = 360;
    public static final int RCL_O32 = 361;

    public static final int RCR_O8 = 362;
    public static final int RCR_O16 = 363;
    public static final int RCR_O32 = 364;

    public static final int SHLD_O16 = 365;
    public static final int SHLD_O32 = 366;

    public static final int SHRD_O16 = 367;
    public static final int SHRD_O32 = 368;

    public static final int BT_MEM = 369;
    public static final int BT_O16 = 370;
    public static final int BT_O32 = 371;

    public static final int BTS_MEM = 372;
    public static final int BTS_O16 = 373;
    public static final int BTS_O32 = 374;

    public static final int BTR_MEM = 375;
    public static final int BTR_O16 = 376;
    public static final int BTR_O32 = 377;

    public static final int BTC_MEM = 378;
    public static final int BTC_O16 = 379;
    public static final int BTC_O32 = 380;

    public static final int BSF = 381;
    public static final int BSR = 382;

    public static final int CDQ = 383;

    public static final int SAHF = 384;

    public static final int OUT_O32 = 385;

    public static final int IN_O16 = 386;
    public static final int IN_O32 = 387;

    public static final int CMPXCHG = 388;

    public static final int BSWAP = 389;

    public static final int JO_O8 = 390;
    public static final int JNO_O8 = 391;
    public static final int JS_O8 = 392;
    public static final int JP_O8 = 393;
    public static final int JNP_O8 = 394;

    public static final int JO_O16 = 395;
    public static final int JNO_O16 = 396;
    public static final int JNA_O16 = 397;
    public static final int JS_O16 = 398;
    public static final int JNS_O16 = 399;
    public static final int JP_O16 = 400;
    public static final int JNP_O16 = 401;
    public static final int JL_O16 = 402;
    public static final int JNL_O16 = 403;
    public static final int JNG_O16 = 404;
    public static final int JG_O16 = 405;

    public static final int JO_O32 = 406;
    public static final int JNO_O32 = 407;
    public static final int JC_O32 = 408;
    public static final int JNC_O32 = 409;
    public static final int JZ_O32 = 410;
    public static final int JNZ_O32 = 411;
    public static final int JNA_O32 = 412;
    public static final int JA_O32 = 413;
    public static final int JS_O32 = 414;
    public static final int JNS_O32 = 415;
    public static final int JP_O32 = 416;
    public static final int JNP_O32 = 417;
    public static final int JL_O32 = 418;
    public static final int JNL_O32 = 419;
    public static final int JNG_O32 = 420;
    public static final int JG_O32 = 421;

    public static final int JECXZ = 422;

    public static final int JUMP_O32 = 423;

    public static final int SETO = 424;
    public static final int SETNO = 425;
    public static final int SETNC = 426;
    public static final int SETZ = 427;
    public static final int SETNZ = 428;
    public static final int SETNA = 429;
    public static final int SETA = 430;
    public static final int SETS = 431;
    public static final int SETNS = 432;
    public static final int SETP = 433;
    public static final int SETNP = 434;
    public static final int SETL = 435;
    public static final int SETNL = 436;
    public static final int SETNG = 437;
    public static final int SETG = 438;

    public static final int CMOVO = 439;
    public static final int CMOVNO = 440;
    public static final int CMOVC = 441;
    public static final int CMOVNC = 442;
    public static final int CMOVZ = 443;
    public static final int CMOVNZ = 444;
    public static final int CMOVNA = 445;
    public static final int CMOVA = 446;
    public static final int CMOVS = 447;
    public static final int CMOVNS = 448;
    public static final int CMOVP = 449;
    public static final int CMOVNP = 450;
    public static final int CMOVL = 451;
    public static final int CMOVNL = 452;
    public static final int CMOVNG = 453;
    public static final int CMOVG = 454;
   
    public static final int STD = 455;
    public static final int CMC = 456;

    public static final int AAA = 457;
    public static final int AAD = 458;
    public static final int AAM = 459;
    public static final int AAS = 460;

    public static final int DAA = 461;
    public static final int DAS = 462;

    public static final int CALL_O32_A16 = 463;
    public static final int CALL_O16_A32 = 464;
    public static final int CALL_O32_A32 = 465;

    public static final int RET_O32_A16 = 466;
    public static final int RET_O16_A32 = 467;
    public static final int RET_O32_A32 = 468;

    public static final int RET_IW_O32_A16 = 469;
    public static final int RET_IW_O16_A32 = 470;
    public static final int RET_IW_O32_A32 = 471;

    public static final int RET_FAR_O32_A16 = 472;
    public static final int RET_FAR_O16_A32 = 473;
    public static final int RET_FAR_O32_A32 = 474;

    public static final int RET_FAR_IW_O32_A16 = 475;
    public static final int RET_FAR_IW_O16_A32 = 476;
    public static final int RET_FAR_IW_O32_A32 = 477;

    public static final int ENTER_O32_A16 = 478;
    public static final int ENTER_O16_A32 = 479;
    public static final int ENTER_O32_A32 = 480;

    public static final int LEAVE_O32_A16 = 481;
    public static final int LEAVE_O16_A32 = 482;
    public static final int LEAVE_O32_A32 = 483;

    public static final int INT_O32_A16 = 484;
    public static final int INT_O16_A32 = 485;
    public static final int INT_O32_A32 = 486;

    public static final int INT3_O16_A16 = 487;
    public static final int INT3_O32_A16 = 488;
    public static final int INT3_O16_A32 = 489;
    public static final int INT3_O32_A32 = 490;

    public static final int INTO_O16_A16 = 491;
    public static final int INTO_O32_A16 = 492;
    public static final int INTO_O16_A32 = 493;
    public static final int INTO_O32_A32 = 494;

    public static final int IRET_O32_A16 = 495;
    public static final int IRET_O16_A32 = 496;
    public static final int IRET_O32_A32 = 497;

    public static final int HALT = 498;
    public static final int WAIT = 499;

    public static final int BOUND_O16 = 500;
    public static final int BOUND_O32 = 501;

    public static final int LOOP_ECX = 502;
    public static final int LOOPZ_ECX = 503;
    public static final int LOOPNZ_ECX = 504;
    public static final int LOOPNZ_CX = 505;

    public static final int PUSH_O16_A32 = 506;
    public static final int PUSH_O32_A32 = 507;

    public static final int POP_O16_A32 = 508;
    public static final int POP_O32_A32 = 509;

    public static final int PUSHF_O32_A16 = 510;
    public static final int PUSHF_O16_A32 = 511;
    public static final int PUSHF_O32_A32 = 512;

    public static final int POPF_O32_A16 = 513;
    public static final int POPF_O16_A32 = 514;
    public static final int POPF_O32_A32 = 515;

    public static final int PUSHA_A32 = 516;
    public static final int PUSHAD_A32 = 517;

    public static final int POPA_A32 = 518;
    public static final int POPAD_A32 = 519;

    public static final int SIGN_EXTEND_8_32 = 520;
    public static final int SIGN_EXTEND_16_32 = 521;

    public static final int CMPSB_A16 = 522;
    public static final int CMPSB_A32 = 523;
    public static final int CMPSW_A16 = 524;
    public static final int CMPSW_A32 = 525;
    public static final int CMPSD_A16 = 526;
    public static final int CMPSD_A32 = 527;

    public static final int REPE_CMPSB_A32 = 528;
    public static final int REPE_CMPSW_A16 = 529;
    public static final int REPE_CMPSW_A32 = 530;
    public static final int REPE_CMPSD_A16 = 531;
    public static final int REPE_CMPSD_A32 = 532;

    public static final int REPNE_CMPSB_A16 = 533;
    public static final int REPNE_CMPSB_A32 = 534;
    public static final int REPNE_CMPSW_A16 = 535;
    public static final int REPNE_CMPSW_A32 = 536;
    public static final int REPNE_CMPSD_A16 = 537;
    public static final int REPNE_CMPSD_A32 = 538;

    public static final int INSB_A16 = 539;
    public static final int INSB_A32 = 540;
    public static final int INSW_A16 = 541;
    public static final int INSW_A32 = 542;
    public static final int INSD_A16 = 543;
    public static final int INSD_A32 = 544;

    public static final int REP_INSB_A16 = 545;
    public static final int REP_INSB_A32 = 546;
    public static final int REP_INSW_A16 = 547;
    public static final int REP_INSW_A32 = 548;
    public static final int REP_INSD_A16 = 549;
    public static final int REP_INSD_A32 = 550;

    public static final int LODSB_A32 = 551;
    public static final int LODSW_A32 = 552;
    public static final int LODSD_A16 = 553;
    public static final int LODSD_A32 = 554;

    public static final int REP_LODSB_A16 = 555;
    public static final int REP_LODSB_A32 = 556;
    public static final int REP_LODSW_A16 = 557;
    public static final int REP_LODSW_A32 = 558;
    public static final int REP_LODSD_A16 = 559;
    public static final int REP_LODSD_A32 = 560;

    public static final int MOVSB_A32 = 561;
    public static final int MOVSW_A32 = 562;
    public static final int MOVSD_A16 = 563;
    public static final int MOVSD_A32 = 564;

    public static final int REP_MOVSB_A32 = 565;
    public static final int REP_MOVSW_A32 = 566;
    public static final int REP_MOVSD_A16 = 567;
    public static final int REP_MOVSD_A32 = 568;

    public static final int OUTSB_A16 = 569;
    public static final int OUTSB_A32 = 570;
    public static final int OUTSW_A16 = 571;
    public static final int OUTSW_A32 = 572;
    public static final int OUTSD_A16 = 573;
    public static final int OUTSD_A32 = 574;

    public static final int REP_OUTSB_A16 = 575;
    public static final int REP_OUTSB_A32 = 576;
    public static final int REP_OUTSW_A16 = 577;
    public static final int REP_OUTSW_A32 = 578;
    public static final int REP_OUTSD_A16 = 579;
    public static final int REP_OUTSD_A32 = 580;

    public static final int SCASB_A16 = 581;
    public static final int SCASB_A32 = 582;
    public static final int SCASW_A16 = 583;
    public static final int SCASW_A32 = 584;
    public static final int SCASD_A16 = 585;
    public static final int SCASD_A32 = 586;

    public static final int REPE_SCASB_A16 = 587;
    public static final int REPE_SCASB_A32 = 588;
    public static final int REPE_SCASW_A16 = 589;
    public static final int REPE_SCASW_A32 = 590;
    public static final int REPE_SCASD_A16 = 591;
    public static final int REPE_SCASD_A32 = 592;

    public static final int REPNE_SCASB_A32 = 593;
    public static final int REPNE_SCASW_A16 = 594;
    public static final int REPNE_SCASW_A32 = 595;
    public static final int REPNE_SCASD_A16 = 596;
    public static final int REPNE_SCASD_A32 = 597;

    public static final int STOSB_A32 = 598;
    public static final int STOSW_A32 = 599;
    public static final int STOSD_A16 = 600;
    public static final int STOSD_A32 = 601;

    public static final int REP_STOSB_A16 = 602;
    public static final int REP_STOSB_A32 = 603;
    public static final int REP_STOSW_A32 = 604;
    public static final int REP_STOSD_A16 = 605;
    public static final int REP_STOSD_A32 = 606;

    public static final int CPUID = 607;

    public static final int WRMSR = 608;
    public static final int RDMSR = 609;
    public static final int RDTSC = 610;

    public static final int SYSENTER = 611;
    public static final int SYSEXIT = 612;

    public static final int CLTS = 613;

    public static final int STR = 614;
    public static final int LTR = 615;

    public static final int SLDT = 616;
    public static final int LLDT = 617;

    public static final int SGDT_O32 = 618;
    public static final int SGDT_O16 = 619;
    public static final int SIDT_O32 = 620;
    public static final int SIDT_O16 = 621;
    public static final int LGDT_O32 = 622;
    public static final int LIDT_O32 = 623;
    public static final int LIDT_O16 = 624;

    public static final int LMSW = 625;

    public static final int VERR = 626;
    public static final int VERW = 627;

    public static final int INVLPG = 628;

    //Flag Operations
    public static final int DEC_O32_FLAGS = 629;

    public static final int ADC_O32_FLAGS = 630;

    public static final int SBB_O32_FLAGS = 631;
      
    public static final int SAR_O8_FLAGS = 632;
    public static final int SAR_O32_FLAGS = 633;
    
    public static final int RCL_O8_FLAGS = 634;
    public static final int RCL_O32_FLAGS = 635;
    
    public static final int RCR_O8_FLAGS = 636;
    public static final int RCR_O16_FLAGS = 637;
    public static final int RCR_O32_FLAGS = 638;
    
    public static final int ROL_O8_FLAGS = 639;
    public static final int ROL_O16_FLAGS = 640;
    public static final int ROL_O32_FLAGS = 641;
    
    public static final int ROR_O16_FLAGS = 642;
    public static final int ROR_O32_FLAGS = 643;

    public static final int NEG_O32_FLAGS = 644;

    public static final int CMPXCHG_O8_FLAGS = 645;
    public static final int CMPXCHG_O16_FLAGS = 646;
    public static final int CMPXCHG_O32_FLAGS = 647;

    public static final int UNDEFINED = 648;

    public static final int MICROCODE_LIMIT = 649;
}
