/*
    JPC: A x86 PC Hardware Emulator for a pure Java Virtual Machine
    Release Version 2.0

    A project from the Physics Dept, The University of Oxford

    Copyright (C) 2007 Isis Innovation Limited

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License version 2 as published by
    the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 
    Details (including contact information) can be found at: 

    www.physics.ox.ac.uk/jpc
*/

package org.jpc.emulator.memory.codeblock.basic;

import org.jpc.emulator.memory.codeblock.*;

public interface FirstStageOperandSet
{
    //OPERANDS
    public static final int AL = 0;
    public static final int CL = 1;
    public static final int DL = 2;
    public static final int BL = 3;
    public static final int AH = 4;
    public static final int CH = 5;
    public static final int DH = 6;
    public static final int BH = 7;

    public static final int AX = 8;
    public static final int CX = 9;
    public static final int DX = 10;
    public static final int BX = 11;
    public static final int SP = 12;
    public static final int BP = 13;
    public static final int SI = 14;
    public static final int DI = 15;

    public static final int EAX = 16;
    public static final int ECX = 17;
    public static final int EDX = 18;
    public static final int EBX = 19;
    public static final int ESP = 20;
    public static final int EBP = 21;
    public static final int ESI = 22;
    public static final int EDI = 23;

    public static final int ES = 24;
    public static final int CS = 25;
    public static final int SS = 26;
    public static final int DS = 27;
    public static final int FS = 28;
    public static final int GS = 29;

    public static final int CR0 = 30;
    public static final int CR1 = 31;
    public static final int CR2 = 32;
    public static final int CR3 = 33;
    public static final int CR4 = 34;
    
    public static final int DR0 = 35;
    public static final int DR1 = 36;
    public static final int DR2 = 37;
    public static final int DR3 = 38;
    public static final int DR6 = 39;
    public static final int DR7 = 40;

    public static final int IB = 41;
    public static final int IW = 42;
    public static final int ID = 43;

    public static final int IA32 = 44;
    public static final int IA48 = 45;

    public static final int IWIB = 46;

    public static final int CONSTANT_1 = 47;

    public static final int FPU_ST0 = 48;
    public static final int FPU_ST1 = 49;
    public static final int FPU_ST2 = 50;
    public static final int FPU_ST3 = 51;
    public static final int FPU_ST4 = 52;
    public static final int FPU_ST5 = 53;
    public static final int FPU_ST6 = 54;
    public static final int FPU_ST7 = 55;

    public static final int M_ES_EAX = 56;
    public static final int M_ES_ECX = 57;
    public static final int M_ES_EDX = 58;
    public static final int M_ES_EBX = 59;
    public static final int M_ES_ID = 60;
    public static final int M_ES_ESI = 61;
    public static final int M_ES_EDI = 62;
    public static final int M_ES_EAX_IB = 63;
    public static final int M_ES_ECX_IB = 64;
    public static final int M_ES_EDX_IB = 65;
    public static final int M_ES_EBX_IB = 66;
    public static final int M_ES_EBP_IB = 67;
    public static final int M_ES_ESI_IB = 68;
    public static final int M_ES_EDI_IB = 69;
    public static final int M_ES_EAX_ID = 70;
    public static final int M_ES_ECX_ID = 71;
    public static final int M_ES_EDX_ID = 72;
    public static final int M_ES_EBX_ID = 73;
    public static final int M_ES_EBP_ID = 74;
    public static final int M_ES_ESI_ID = 75;
    public static final int M_ES_EDI_ID = 76;

    public static final int M_CS_EAX = 77;
    public static final int M_CS_ECX = 78;
    public static final int M_CS_EDX = 79;
    public static final int M_CS_EBX = 80;
    public static final int M_CS_ID = 81;
    public static final int M_CS_ESI = 82;
    public static final int M_CS_EDI = 83;
    public static final int M_CS_EAX_IB = 84;
    public static final int M_CS_ECX_IB = 85;
    public static final int M_CS_EDX_IB = 86;
    public static final int M_CS_EBX_IB = 87;
    public static final int M_CS_EBP_IB = 88;
    public static final int M_CS_ESI_IB = 89;
    public static final int M_CS_EDI_IB = 90;
    public static final int M_CS_EAX_ID = 91;
    public static final int M_CS_ECX_ID = 92;
    public static final int M_CS_EDX_ID = 93;
    public static final int M_CS_EBX_ID = 94;
    public static final int M_CS_EBP_ID = 95;
    public static final int M_CS_ESI_ID = 96;
    public static final int M_CS_EDI_ID = 97;

    public static final int M_SS_EAX = 98;
    public static final int M_SS_ECX = 99;
    public static final int M_SS_EDX = 100;
    public static final int M_SS_EBX = 101;
    public static final int M_SS_ID = 102;
    public static final int M_SS_ESI = 103;
    public static final int M_SS_EDI = 104;
    public static final int M_SS_EAX_IB = 105;
    public static final int M_SS_ECX_IB = 106;
    public static final int M_SS_EDX_IB = 107;
    public static final int M_SS_EBX_IB = 108;
    public static final int M_SS_EBP_IB = 109;
    public static final int M_SS_ESI_IB = 110;
    public static final int M_SS_EDI_IB = 111;
    public static final int M_SS_EAX_ID = 112;
    public static final int M_SS_ECX_ID = 113;
    public static final int M_SS_EDX_ID = 114;
    public static final int M_SS_EBX_ID = 115;
    public static final int M_SS_EBP_ID = 116;
    public static final int M_SS_ESI_ID = 117;
    public static final int M_SS_EDI_ID = 118;

    public static final int M_DS_EAX = 119;
    public static final int M_DS_ECX = 120;
    public static final int M_DS_EDX = 121;
    public static final int M_DS_EBX = 122;
    public static final int M_DS_ID = 123;
    public static final int M_DS_ESI = 124;
    public static final int M_DS_EDI = 125;
    public static final int M_DS_EAX_IB = 126;
    public static final int M_DS_ECX_IB = 127;
    public static final int M_DS_EDX_IB = 128;
    public static final int M_DS_EBX_IB = 129;
    public static final int M_DS_EBP_IB = 130;
    public static final int M_DS_ESI_IB = 131;
    public static final int M_DS_EDI_IB = 132;
    public static final int M_DS_EAX_ID = 133;
    public static final int M_DS_ECX_ID = 134;
    public static final int M_DS_EDX_ID = 135;
    public static final int M_DS_EBX_ID = 136;
    public static final int M_DS_EBP_ID = 137;
    public static final int M_DS_ESI_ID = 138;
    public static final int M_DS_EDI_ID = 139;

    public static final int M_FS_EAX = 140;
    public static final int M_FS_ECX = 141;
    public static final int M_FS_EDX = 142;
    public static final int M_FS_EBX = 143;
    public static final int M_FS_ID = 144;
    public static final int M_FS_ESI = 145;
    public static final int M_FS_EDI = 146;
    public static final int M_FS_EAX_IB = 147;
    public static final int M_FS_ECX_IB = 148;
    public static final int M_FS_EDX_IB = 149;
    public static final int M_FS_EBX_IB = 150;
    public static final int M_FS_EBP_IB = 151;
    public static final int M_FS_ESI_IB = 152;
    public static final int M_FS_EDI_IB = 153;
    public static final int M_FS_EAX_ID = 154;
    public static final int M_FS_ECX_ID = 155;
    public static final int M_FS_EDX_ID = 156;
    public static final int M_FS_EBX_ID = 157;
    public static final int M_FS_EBP_ID = 158;
    public static final int M_FS_ESI_ID = 159;
    public static final int M_FS_EDI_ID = 160;

    public static final int M_GS_EAX = 161;
    public static final int M_GS_ECX = 162;
    public static final int M_GS_EDX = 163;
    public static final int M_GS_EBX = 164;
    public static final int M_GS_ID = 165;
    public static final int M_GS_ESI = 166;
    public static final int M_GS_EDI = 167;
    public static final int M_GS_EAX_IB = 168;
    public static final int M_GS_ECX_IB = 169;
    public static final int M_GS_EDX_IB = 170;
    public static final int M_GS_EBX_IB = 171;
    public static final int M_GS_EBP_IB = 172;
    public static final int M_GS_ESI_IB = 173;
    public static final int M_GS_EDI_IB = 174;
    public static final int M_GS_EAX_ID = 175;
    public static final int M_GS_ECX_ID = 176;
    public static final int M_GS_EDX_ID = 177;
    public static final int M_GS_EBX_ID = 178;
    public static final int M_GS_EBP_ID = 179;
    public static final int M_GS_ESI_ID = 180;
    public static final int M_GS_EDI_ID = 181;

    public static final int M_ES_BX_SI = 182;
    public static final int M_ES_BX_DI = 183;
    public static final int M_ES_BP_SI = 184;
    public static final int M_ES_BP_DI = 185;
    public static final int M_ES_SI = 186;
    public static final int M_ES_DI = 187;
    public static final int M_ES_IW = 188;
    public static final int M_ES_BX = 189;
    public static final int M_ES_BX_SI_IB = 190;
    public static final int M_ES_BX_DI_IB = 191;
    public static final int M_ES_BP_SI_IB = 192;
    public static final int M_ES_BP_DI_IB = 193;
    public static final int M_ES_SI_IB = 194;
    public static final int M_ES_DI_IB = 195;
    public static final int M_ES_BP_IB = 196;
    public static final int M_ES_BX_IB = 197;
    public static final int M_ES_BX_SI_IW = 198;
    public static final int M_ES_BX_DI_IW = 199;
    public static final int M_ES_BP_SI_IW = 200;
    public static final int M_ES_BP_DI_IW = 201;
    public static final int M_ES_SI_IW = 202;
    public static final int M_ES_DI_IW = 203;
    public static final int M_ES_BP_IW = 204;
    public static final int M_ES_BX_IW = 205;
    public static final int M_CS_BX_SI = 206;
    public static final int M_CS_BX_DI = 207;
    public static final int M_CS_BP_SI = 208;
    public static final int M_CS_BP_DI = 209;
    public static final int M_CS_SI = 210;
    public static final int M_CS_DI = 211;
    public static final int M_CS_IW = 212;
    public static final int M_CS_BX = 213;
    public static final int M_CS_BX_SI_IB = 214;
    public static final int M_CS_BX_DI_IB = 215;
    public static final int M_CS_BP_SI_IB = 216;
    public static final int M_CS_BP_DI_IB = 217;
    public static final int M_CS_SI_IB = 218;
    public static final int M_CS_DI_IB = 219;
    public static final int M_CS_BP_IB = 220;
    public static final int M_CS_BX_IB = 221;
    public static final int M_CS_BX_SI_IW = 222;
    public static final int M_CS_BX_DI_IW = 223;
    public static final int M_CS_BP_SI_IW = 224;
    public static final int M_CS_BP_DI_IW = 225;
    public static final int M_CS_SI_IW = 226;
    public static final int M_CS_DI_IW = 227;
    public static final int M_CS_BP_IW = 228;
    public static final int M_CS_BX_IW = 229;
    public static final int M_SS_BX_SI = 230;
    public static final int M_SS_BX_DI = 231;
    public static final int M_SS_BP_SI = 232;
    public static final int M_SS_BP_DI = 233;
    public static final int M_SS_SI = 234;
    public static final int M_SS_DI = 235;
    public static final int M_SS_IW = 236;
    public static final int M_SS_BX = 237;
    public static final int M_SS_BX_SI_IB = 238;
    public static final int M_SS_BX_DI_IB = 239;
    public static final int M_SS_BP_SI_IB = 240;
    public static final int M_SS_BP_DI_IB = 241;
    public static final int M_SS_SI_IB = 242;
    public static final int M_SS_DI_IB = 243;
    public static final int M_SS_BP_IB = 244;
    public static final int M_SS_BX_IB = 245;
    public static final int M_SS_BX_SI_IW = 246;
    public static final int M_SS_BX_DI_IW = 247;
    public static final int M_SS_BP_SI_IW = 248;
    public static final int M_SS_BP_DI_IW = 249;
    public static final int M_SS_SI_IW = 250;
    public static final int M_SS_DI_IW = 251;
    public static final int M_SS_BP_IW = 252;
    public static final int M_SS_BX_IW = 253;
    public static final int M_DS_BX_SI = 254;
    public static final int M_DS_BX_DI = 255;
    public static final int M_DS_BP_SI = 256;
    public static final int M_DS_BP_DI = 257;
    public static final int M_DS_SI = 258;
    public static final int M_DS_DI = 259;
    public static final int M_DS_IW = 260;
    public static final int M_DS_BX = 261;
    public static final int M_DS_BX_SI_IB = 262;
    public static final int M_DS_BX_DI_IB = 263;
    public static final int M_DS_BP_SI_IB = 264;
    public static final int M_DS_BP_DI_IB = 265;
    public static final int M_DS_SI_IB = 266;
    public static final int M_DS_DI_IB = 267;
    public static final int M_DS_BP_IB = 268;
    public static final int M_DS_BX_IB = 269;
    public static final int M_DS_BX_SI_IW = 270;
    public static final int M_DS_BX_DI_IW = 271;
    public static final int M_DS_BP_SI_IW = 272;
    public static final int M_DS_BP_DI_IW = 273;
    public static final int M_DS_SI_IW = 274;
    public static final int M_DS_DI_IW = 275;
    public static final int M_DS_BP_IW = 276;
    public static final int M_DS_BX_IW = 277;
    public static final int M_FS_BX_SI = 278;
    public static final int M_FS_BX_DI = 279;
    public static final int M_FS_BP_SI = 280;
    public static final int M_FS_BP_DI = 281;
    public static final int M_FS_SI = 282;
    public static final int M_FS_DI = 283;
    public static final int M_FS_IW = 284;
    public static final int M_FS_BX = 285;
    public static final int M_FS_BX_SI_IB = 286;
    public static final int M_FS_BX_DI_IB = 287;
    public static final int M_FS_BP_SI_IB = 288;
    public static final int M_FS_BP_DI_IB = 289;
    public static final int M_FS_SI_IB = 290;
    public static final int M_FS_DI_IB = 291;
    public static final int M_FS_BP_IB = 292;
    public static final int M_FS_BX_IB = 293;
    public static final int M_FS_BX_SI_IW = 294;
    public static final int M_FS_BX_DI_IW = 295;
    public static final int M_FS_BP_SI_IW = 296;
    public static final int M_FS_BP_DI_IW = 297;
    public static final int M_FS_SI_IW = 298;
    public static final int M_FS_DI_IW = 299;
    public static final int M_FS_BP_IW = 300;
    public static final int M_FS_BX_IW = 301;
    public static final int M_GS_BX_SI = 302;
    public static final int M_GS_BX_DI = 303;
    public static final int M_GS_BP_SI = 304;
    public static final int M_GS_BP_DI = 305;
    public static final int M_GS_SI = 306;
    public static final int M_GS_DI = 307;
    public static final int M_GS_IW = 308;
    public static final int M_GS_BX = 309;
    public static final int M_GS_BX_SI_IB = 310;
    public static final int M_GS_BX_DI_IB = 311;
    public static final int M_GS_BP_SI_IB = 312;
    public static final int M_GS_BP_DI_IB = 313;
    public static final int M_GS_SI_IB = 314;
    public static final int M_GS_DI_IB = 315;
    public static final int M_GS_BP_IB = 316;
    public static final int M_GS_BX_IB = 317;
    public static final int M_GS_BX_SI_IW = 318;
    public static final int M_GS_BX_DI_IW = 319;
    public static final int M_GS_BP_SI_IW = 320;
    public static final int M_GS_BP_DI_IW = 321;
    public static final int M_GS_SI_IW = 322;
    public static final int M_GS_DI_IW = 323;
    public static final int M_GS_BP_IW = 324;
    public static final int M_GS_BX_IW = 325;

    public static final int M_ES_BX_uAL = 326;
    public static final int M_CS_BX_uAL = 327;
    public static final int M_SS_BX_uAL = 328;
    public static final int M_DS_BX_uAL = 329;
    public static final int M_FS_BX_uAL = 330;
    public static final int M_GS_BX_uAL = 331;

    public static final int M_ES_EBX_uAL = 332;
    public static final int M_CS_EBX_uAL = 333;
    public static final int M_SS_EBX_uAL = 334;
    public static final int M_DS_EBX_uAL = 335;
    public static final int M_FS_EBX_uAL = 336;
    public static final int M_GS_EBX_uAL = 337;

    //SIB Operands
    public static final int M_DS_2EAX = 338;
    public static final int M_DS_EAX_ECX = 339;
    public static final int M_DS_EAX_EDX = 340;
    public static final int M_DS_EAX_EBX = 341;
    public static final int M_DS_EAX_ESP = 342;
    public static final int M_DS_EAX_EBP = 343;
    public static final int M_DS_EAX_ESI = 344;
    public static final int M_DS_EAX_EDI = 345;

    public static final int M_DS_2ECX = 346;
    public static final int M_DS_ECX_EDX = 347;
    public static final int M_DS_ECX_EBX = 348;
    public static final int M_DS_ECX_ESP = 349;
    public static final int M_DS_ECX_EBP = 350;
    public static final int M_DS_ECX_ESI = 351;
    public static final int M_DS_ECX_EDI = 352;

    public static final int M_DS_2EDX = 353;
    public static final int M_DS_EDX_EBX = 354;
    public static final int M_DS_EDX_ESP = 355;
    public static final int M_DS_EDX_EBP = 356;
    public static final int M_DS_EDX_ESI = 357;
    public static final int M_DS_EDX_EDI = 358;

    public static final int M_DS_2EBX = 359;
    public static final int M_DS_EBX_ESP = 360;
    public static final int M_DS_EBX_EBP = 361;
    public static final int M_DS_EBX_ESI = 362;
    public static final int M_DS_EBX_EDI = 363;

    public static final int M_DS_ESP = 364;

    public static final int M_DS_EBP_ESP = 365;
    public static final int M_DS_EBP_ESI = 366;
    public static final int M_DS_EBP_EDI = 367;

    public static final int M_DS_ESI_ESP = 368;
    public static final int M_DS_2ESI = 369;
    public static final int M_DS_ESI_EDI = 370;

    public static final int M_DS_EDI_ESP = 371;
    public static final int M_DS_2EDI = 372;

    public static final int M_DS_3EAX = 373;
    public static final int M_DS_2EAX_ECX = 374;
    public static final int M_DS_2EAX_EDX = 375;
    public static final int M_DS_2EAX_EBX = 376;
    public static final int M_DS_2EAX_ESP = 377;
    public static final int M_DS_2EAX_ID = 378;
    public static final int M_DS_2EAX_ESI = 379;
    public static final int M_DS_2EAX_EDI = 380;

    public static final int M_DS_2ECX_EAX = 381;
    public static final int M_DS_3ECX = 382;
    public static final int M_DS_2ECX_EDX = 383;
    public static final int M_DS_2ECX_EBX = 384;
    public static final int M_DS_2ECX_ESP = 385;
    public static final int M_DS_2ECX_ID = 386;
    public static final int M_DS_2ECX_ESI = 387;
    public static final int M_DS_2ECX_EDI = 388;

    public static final int M_DS_2EDX_EAX = 389;
    public static final int M_DS_2EDX_ECX = 390;
    public static final int M_DS_3EDX = 391;
    public static final int M_DS_2EDX_EBX = 392;
    public static final int M_DS_2EDX_ESP = 393;
    public static final int M_DS_2EDX_ID = 394;
    public static final int M_DS_2EDX_ESI = 395;
    public static final int M_DS_2EDX_EDI = 396;

    public static final int M_DS_2EBX_EAX = 397;
    public static final int M_DS_2EBX_ECX = 398;
    public static final int M_DS_2EBX_EDX = 399;
    public static final int M_DS_3EBX = 400;
    public static final int M_DS_2EBX_ESP = 401;
    public static final int M_DS_2EBX_ID = 402;
    public static final int M_DS_2EBX_ESI = 403;
    public static final int M_DS_2EBX_EDI = 404;

    public static final int M_DS_2EBP_EAX = 405;
    public static final int M_DS_2EBP_ECX = 406;
    public static final int M_DS_2EBP_EDX = 407;
    public static final int M_DS_2EBP_EBX = 408;
    public static final int M_DS_2EBP_ESP = 409;
    public static final int M_DS_2EBP_ID = 410;
    public static final int M_DS_2EBP_ESI = 411;
    public static final int M_DS_2EBP_EDI = 412;

    public static final int M_DS_2ESI_EAX = 413;
    public static final int M_DS_2ESI_ECX = 414;
    public static final int M_DS_2ESI_EDX = 415;
    public static final int M_DS_2ESI_EBX = 416;
    public static final int M_DS_2ESI_ESP = 417;
    public static final int M_DS_2ESI_ID = 418;
    public static final int M_DS_3ESI = 419;
    public static final int M_DS_2ESI_EDI = 420;

    public static final int M_DS_2EDI_EAX = 421;
    public static final int M_DS_2EDI_ECX = 422;
    public static final int M_DS_2EDI_EDX = 423;
    public static final int M_DS_2EDI_EBX = 424;
    public static final int M_DS_2EDI_ESP = 425;
    public static final int M_DS_2EDI_ID = 426;
    public static final int M_DS_2EDI_ESI = 427;
    public static final int M_DS_3EDI = 428;

    public static final int M_DS_5EAX = 429;
    public static final int M_DS_4EAX_ECX = 430;
    public static final int M_DS_4EAX_EDX = 431;
    public static final int M_DS_4EAX_EBX = 432;
    public static final int M_DS_4EAX_ESP = 433;
    public static final int M_DS_4EAX_ID = 434;
    public static final int M_DS_4EAX_ESI = 435;
    public static final int M_DS_4EAX_EDI = 436;

    public static final int M_DS_4ECX_EAX = 437;
    public static final int M_DS_5ECX = 438;
    public static final int M_DS_4ECX_EDX = 439;
    public static final int M_DS_4ECX_EBX = 440;
    public static final int M_DS_4ECX_ESP = 441;
    public static final int M_DS_4ECX_ID = 442;
    public static final int M_DS_4ECX_ESI = 443;
    public static final int M_DS_4ECX_EDI = 444;

    public static final int M_DS_4EDX_EAX = 445;
    public static final int M_DS_4EDX_ECX = 446;
    public static final int M_DS_5EDX = 447;
    public static final int M_DS_4EDX_EBX = 448;
    public static final int M_DS_4EDX_ESP = 449;
    public static final int M_DS_4EDX_ID = 450;
    public static final int M_DS_4EDX_ESI = 451;
    public static final int M_DS_4EDX_EDI = 452;

    public static final int M_DS_4EBX_EAX = 453;
    public static final int M_DS_4EBX_ECX = 454;
    public static final int M_DS_4EBX_EDX = 455;
    public static final int M_DS_5EBX = 456;
    public static final int M_DS_4EBX_ESP = 457;
    public static final int M_DS_4EBX_ID = 458;
    public static final int M_DS_4EBX_ESI = 459;
    public static final int M_DS_4EBX_EDI = 460;

    public static final int M_DS_4EBP_EAX = 461;
    public static final int M_DS_4EBP_ECX = 462;
    public static final int M_DS_4EBP_EDX = 463;
    public static final int M_DS_4EBP_EBX = 464;
    public static final int M_DS_4EBP_ESP = 465;
    public static final int M_DS_4EBP_ID = 466;
    public static final int M_DS_4EBP_ESI = 467;
    public static final int M_DS_4EBP_EDI = 468;

    public static final int M_DS_4ESI_EAX = 469;
    public static final int M_DS_4ESI_ECX = 470;
    public static final int M_DS_4ESI_EDX = 471;
    public static final int M_DS_4ESI_EBX = 472;
    public static final int M_DS_4ESI_ESP = 473;
    public static final int M_DS_4ESI_ID = 474;
    public static final int M_DS_5ESI = 475;
    public static final int M_DS_4ESI_EDI = 476;

    public static final int M_DS_4EDI_EAX = 477;
    public static final int M_DS_4EDI_ECX = 478;
    public static final int M_DS_4EDI_EDX = 479;
    public static final int M_DS_4EDI_EBX = 480;
    public static final int M_DS_4EDI_ESP = 481;
    public static final int M_DS_4EDI_ID = 482;
    public static final int M_DS_4EDI_ESI = 483;
    public static final int M_DS_5EDI = 484;

    public static final int M_DS_9EAX = 485;
    public static final int M_DS_8EAX_ECX = 486;
    public static final int M_DS_8EAX_EDX = 487;
    public static final int M_DS_8EAX_EBX = 488;
    public static final int M_DS_8EAX_ESP = 489;
    public static final int M_DS_8EAX_ID = 490;
    public static final int M_DS_8EAX_ESI = 491;
    public static final int M_DS_8EAX_EDI = 492;

    public static final int M_DS_8ECX_EAX = 493;
    public static final int M_DS_9ECX = 494;
    public static final int M_DS_8ECX_EDX = 495;
    public static final int M_DS_8ECX_EBX = 496;
    public static final int M_DS_8ECX_ESP = 497;
    public static final int M_DS_8ECX_ID = 498;
    public static final int M_DS_8ECX_ESI = 499;
    public static final int M_DS_8ECX_EDI = 500;

    public static final int M_DS_8EDX_EAX = 501;
    public static final int M_DS_8EDX_ECX = 502;
    public static final int M_DS_9EDX = 503;
    public static final int M_DS_8EDX_EBX = 504;
    public static final int M_DS_8EDX_ESP = 505;
    public static final int M_DS_8EDX_ID = 506;
    public static final int M_DS_8EDX_ESI = 507;
    public static final int M_DS_8EDX_EDI = 508;

    public static final int M_DS_8EBX_EAX = 509;
    public static final int M_DS_8EBX_ECX = 510;
    public static final int M_DS_8EBX_EDX = 511;
    public static final int M_DS_9EBX = 512;
    public static final int M_DS_8EBX_ESP = 513;
    public static final int M_DS_8EBX_ID = 514;
    public static final int M_DS_8EBX_ESI = 515;
    public static final int M_DS_8EBX_EDI = 516;

    public static final int M_DS_8EBP_EAX = 517;
    public static final int M_DS_8EBP_ECX = 518;
    public static final int M_DS_8EBP_EDX = 519;
    public static final int M_DS_8EBP_EBX = 520;
    public static final int M_DS_8EBP_ESP = 521;
    public static final int M_DS_8EBP_ID = 522;
    public static final int M_DS_8EBP_ESI = 523;
    public static final int M_DS_8EBP_EDI = 524;

    public static final int M_DS_8ESI_EAX = 525;
    public static final int M_DS_8ESI_ECX = 526;
    public static final int M_DS_8ESI_EDX = 527;
    public static final int M_DS_8ESI_EBX = 528;
    public static final int M_DS_8ESI_ESP = 529;
    public static final int M_DS_8ESI_ID = 530;
    public static final int M_DS_9ESI = 531;
    public static final int M_DS_8ESI_EDI = 532;
    
    public static final int M_DS_8EDI_EAX = 533;
    public static final int M_DS_8EDI_ECX = 534;
    public static final int M_DS_8EDI_EDX = 535;
    public static final int M_DS_8EDI_EBX = 536;
    public static final int M_DS_8EDI_ESP = 537;
    public static final int M_DS_8EDI_ID = 538;
    public static final int M_DS_8EDI_ESI = 539;
    public static final int M_DS_9EDI = 540;

    //SIB + IB Operands
    public static final int M_DS_2EAX_IB = 541;
    public static final int M_DS_EAX_ECX_IB = 542;
    public static final int M_DS_EAX_EDX_IB = 543;
    public static final int M_DS_EAX_EBX_IB = 544;
    public static final int M_DS_EAX_ESP_IB = 545;
    public static final int M_DS_EAX_EBP_IB = 546;
    public static final int M_DS_EAX_ESI_IB = 547;
    public static final int M_DS_EAX_EDI_IB = 548;

    public static final int M_DS_2ECX_IB = 549;
    public static final int M_DS_ECX_EDX_IB = 550;
    public static final int M_DS_ECX_EBX_IB = 551;
    public static final int M_DS_ECX_ESP_IB = 552;
    public static final int M_DS_ECX_EBP_IB = 553;
    public static final int M_DS_ECX_ESI_IB = 554;
    public static final int M_DS_ECX_EDI_IB = 555;

    public static final int M_DS_2EDX_IB = 556;
    public static final int M_DS_EDX_EBX_IB = 557;
    public static final int M_DS_EDX_ESP_IB = 558;
    public static final int M_DS_EDX_EBP_IB = 559;
    public static final int M_DS_EDX_ESI_IB = 560;
    public static final int M_DS_EDX_EDI_IB = 561;

    public static final int M_DS_2EBX_IB = 562;
    public static final int M_DS_EBX_ESP_IB = 563;
    public static final int M_DS_EBX_EBP_IB = 564;
    public static final int M_DS_EBX_ESI_IB = 565;
    public static final int M_DS_EBX_EDI_IB = 566;

    public static final int M_DS_ESP_IB = 567;

    public static final int M_DS_EBP_ESP_IB = 568;
    public static final int M_DS_2EBP_IB = 569;
    public static final int M_DS_EBP_ESI_IB = 570;
    public static final int M_DS_EBP_EDI_IB = 571;

    public static final int M_DS_ESI_ESP_IB = 572;
    public static final int M_DS_2ESI_IB = 573;
    public static final int M_DS_ESI_EDI_IB = 574;

    public static final int M_DS_EDI_ESP_IB = 575;
    public static final int M_DS_2EDI_IB = 576;

    public static final int M_DS_3EAX_IB = 577;
    public static final int M_DS_2EAX_ECX_IB = 578;
    public static final int M_DS_2EAX_EDX_IB = 579;
    public static final int M_DS_2EAX_EBX_IB = 580;
    public static final int M_DS_2EAX_ESP_IB = 581;
    public static final int M_DS_2EAX_EBP_IB = 582;
    public static final int M_DS_2EAX_ESI_IB = 583;
    public static final int M_DS_2EAX_EDI_IB = 584;

    public static final int M_DS_2ECX_EAX_IB = 585;
    public static final int M_DS_3ECX_IB = 586;
    public static final int M_DS_2ECX_EDX_IB = 587;
    public static final int M_DS_2ECX_EBX_IB = 588;
    public static final int M_DS_2ECX_ESP_IB = 589;
    public static final int M_DS_2ECX_EBP_IB = 590;
    public static final int M_DS_2ECX_ESI_IB = 591;
    public static final int M_DS_2ECX_EDI_IB = 592;

    public static final int M_DS_2EDX_EAX_IB = 593;
    public static final int M_DS_2EDX_ECX_IB = 594;
    public static final int M_DS_3EDX_IB = 595;
    public static final int M_DS_2EDX_EBX_IB = 596;
    public static final int M_DS_2EDX_ESP_IB = 597;
    public static final int M_DS_2EDX_EBP_IB = 598;
    public static final int M_DS_2EDX_ESI_IB = 599;
    public static final int M_DS_2EDX_EDI_IB = 600;

    public static final int M_DS_2EBX_EAX_IB = 601;
    public static final int M_DS_2EBX_ECX_IB = 602;
    public static final int M_DS_2EBX_EDX_IB = 603;
    public static final int M_DS_3EBX_IB = 604;
    public static final int M_DS_2EBX_ESP_IB = 605;
    public static final int M_DS_2EBX_EBP_IB = 606;
    public static final int M_DS_2EBX_ESI_IB = 607;
    public static final int M_DS_2EBX_EDI_IB = 608;

    public static final int M_DS_2EBP_EAX_IB = 609;
    public static final int M_DS_2EBP_ECX_IB = 610;
    public static final int M_DS_2EBP_EDX_IB = 611;
    public static final int M_DS_2EBP_EBX_IB = 612;
    public static final int M_DS_2EBP_ESP_IB = 613;
    public static final int M_DS_3EBP_IB = 614;
    public static final int M_DS_2EBP_ESI_IB = 615;
    public static final int M_DS_2EBP_EDI_IB = 616;

    public static final int M_DS_2ESI_EAX_IB = 617;
    public static final int M_DS_2ESI_ECX_IB = 618;
    public static final int M_DS_2ESI_EDX_IB = 619;
    public static final int M_DS_2ESI_EBX_IB = 620;
    public static final int M_DS_2ESI_ESP_IB = 621;
    public static final int M_DS_2ESI_EBP_IB = 622;
    public static final int M_DS_3ESI_IB = 623;
    public static final int M_DS_2ESI_EDI_IB = 624;

    public static final int M_DS_2EDI_EAX_IB = 625;
    public static final int M_DS_2EDI_ECX_IB = 626;
    public static final int M_DS_2EDI_EDX_IB = 627;
    public static final int M_DS_2EDI_EBX_IB = 628;
    public static final int M_DS_2EDI_ESP_IB = 629;
    public static final int M_DS_2EDI_EBP_IB = 630;
    public static final int M_DS_2EDI_ESI_IB = 631;
    public static final int M_DS_3EDI_IB = 632;

    public static final int M_DS_5EAX_IB = 633;
    public static final int M_DS_4EAX_ECX_IB = 634;
    public static final int M_DS_4EAX_EDX_IB = 635;
    public static final int M_DS_4EAX_EBX_IB = 636;
    public static final int M_DS_4EAX_ESP_IB = 637;
    public static final int M_DS_4EAX_EBP_IB = 638;
    public static final int M_DS_4EAX_ESI_IB = 639;
    public static final int M_DS_4EAX_EDI_IB = 640;

    public static final int M_DS_4ECX_EAX_IB = 641;
    public static final int M_DS_5ECX_IB = 642;
    public static final int M_DS_4ECX_EDX_IB = 643;
    public static final int M_DS_4ECX_EBX_IB = 644;
    public static final int M_DS_4ECX_ESP_IB = 645;
    public static final int M_DS_4ECX_EBP_IB = 646;
    public static final int M_DS_4ECX_ESI_IB = 647;
    public static final int M_DS_4ECX_EDI_IB = 648;

    public static final int M_DS_4EDX_EAX_IB = 649;
    public static final int M_DS_4EDX_ECX_IB = 650;
    public static final int M_DS_5EDX_IB = 651;
    public static final int M_DS_4EDX_EBX_IB = 652;
    public static final int M_DS_4EDX_ESP_IB = 653;
    public static final int M_DS_4EDX_EBP_IB = 654;
    public static final int M_DS_4EDX_ESI_IB = 655;
    public static final int M_DS_4EDX_EDI_IB = 656;

    public static final int M_DS_4EBX_EAX_IB = 657;
    public static final int M_DS_4EBX_ECX_IB = 658;
    public static final int M_DS_4EBX_EDX_IB = 659;
    public static final int M_DS_5EBX_IB = 660;
    public static final int M_DS_4EBX_ESP_IB = 661;
    public static final int M_DS_4EBX_EBP_IB = 662;
    public static final int M_DS_4EBX_ESI_IB = 663;
    public static final int M_DS_4EBX_EDI_IB = 664;

    public static final int M_DS_4EBP_EAX_IB = 665;
    public static final int M_DS_4EBP_ECX_IB = 666;
    public static final int M_DS_4EBP_EDX_IB = 667;
    public static final int M_DS_4EBP_EBX_IB = 668;
    public static final int M_DS_4EBP_ESP_IB = 669;
    public static final int M_DS_5EBP_IB = 670;
    public static final int M_DS_4EBP_ESI_IB = 671;
    public static final int M_DS_4EBP_EDI_IB = 672;

    public static final int M_DS_4ESI_EAX_IB = 673;
    public static final int M_DS_4ESI_ECX_IB = 674;
    public static final int M_DS_4ESI_EDX_IB = 675;
    public static final int M_DS_4ESI_EBX_IB = 676;
    public static final int M_DS_4ESI_ESP_IB = 677;
    public static final int M_DS_4ESI_EBP_IB = 678;
    public static final int M_DS_5ESI_IB = 679;
    public static final int M_DS_4ESI_EDI_IB = 680;

    public static final int M_DS_4EDI_EAX_IB = 681;
    public static final int M_DS_4EDI_ECX_IB = 682;
    public static final int M_DS_4EDI_EDX_IB = 683;
    public static final int M_DS_4EDI_EBX_IB = 684;
    public static final int M_DS_4EDI_ESP_IB = 685;
    public static final int M_DS_4EDI_EBP_IB = 686;
    public static final int M_DS_4EDI_ESI_IB = 687;
    public static final int M_DS_5EDI_IB = 688;

    public static final int M_DS_9EAX_IB = 689;
    public static final int M_DS_8EAX_ECX_IB = 690;
    public static final int M_DS_8EAX_EDX_IB = 691;
    public static final int M_DS_8EAX_EBX_IB = 692;
    public static final int M_DS_8EAX_ESP_IB = 693;
    public static final int M_DS_8EAX_EBP_IB = 694;
    public static final int M_DS_8EAX_ESI_IB = 695;
    public static final int M_DS_8EAX_EDI_IB = 696;

    public static final int M_DS_8ECX_EAX_IB = 697;
    public static final int M_DS_9ECX_IB = 698;
    public static final int M_DS_8ECX_EDX_IB = 699;
    public static final int M_DS_8ECX_EBX_IB = 700;
    public static final int M_DS_8ECX_ESP_IB = 701;
    public static final int M_DS_8ECX_EBP_IB = 702;
    public static final int M_DS_8ECX_ESI_IB = 703;
    public static final int M_DS_8ECX_EDI_IB = 704;

    public static final int M_DS_8EDX_EAX_IB = 705;
    public static final int M_DS_8EDX_ECX_IB = 706;
    public static final int M_DS_9EDX_IB = 707;
    public static final int M_DS_8EDX_EBX_IB = 708;
    public static final int M_DS_8EDX_ESP_IB = 709;
    public static final int M_DS_8EDX_EBP_IB = 710;
    public static final int M_DS_8EDX_ESI_IB = 711;
    public static final int M_DS_8EDX_EDI_IB = 712;

    public static final int M_DS_8EBX_EAX_IB = 713;
    public static final int M_DS_8EBX_ECX_IB = 714;
    public static final int M_DS_8EBX_EDX_IB = 715;
    public static final int M_DS_9EBX_IB = 716;
    public static final int M_DS_8EBX_ESP_IB = 717;
    public static final int M_DS_8EBX_EBP_IB = 718;
    public static final int M_DS_8EBX_ESI_IB = 719;
    public static final int M_DS_8EBX_EDI_IB = 720;

    public static final int M_DS_8EBP_EAX_IB = 721;
    public static final int M_DS_8EBP_ECX_IB = 722;
    public static final int M_DS_8EBP_EDX_IB = 723;
    public static final int M_DS_8EBP_EBX_IB = 724;
    public static final int M_DS_8EBP_ESP_IB = 725;
    public static final int M_DS_9EBP_IB = 726;
    public static final int M_DS_8EBP_ESI_IB = 727;
    public static final int M_DS_8EBP_EDI_IB = 728;

    public static final int M_DS_8ESI_EAX_IB = 729;
    public static final int M_DS_8ESI_ECX_IB = 730;
    public static final int M_DS_8ESI_EDX_IB = 731;
    public static final int M_DS_8ESI_EBX_IB = 732;
    public static final int M_DS_8ESI_ESP_IB = 733;
    public static final int M_DS_8ESI_EBP_IB = 734;
    public static final int M_DS_9ESI_IB = 735;
    public static final int M_DS_8ESI_EDI_IB = 736;
    
    public static final int M_DS_8EDI_EAX_IB = 737;
    public static final int M_DS_8EDI_ECX_IB = 738;
    public static final int M_DS_8EDI_EDX_IB = 739;
    public static final int M_DS_8EDI_EBX_IB = 740;
    public static final int M_DS_8EDI_ESP_IB = 741;
    public static final int M_DS_8EDI_EBP_IB = 742;
    public static final int M_DS_8EDI_ESI_IB = 743;
    public static final int M_DS_9EDI_IB = 744;

    //SIB + ID Operands
    public static final int M_DS_EAX_ECX_ID = 745;
    public static final int M_DS_EAX_EDX_ID = 746;
    public static final int M_DS_EAX_EBX_ID = 747;
    public static final int M_DS_EAX_ESP_ID = 748;
    public static final int M_DS_EAX_EBP_ID = 749;
    public static final int M_DS_EAX_ESI_ID = 750;
    public static final int M_DS_EAX_EDI_ID = 751;

    public static final int M_DS_ECX_EDX_ID = 752;
    public static final int M_DS_ECX_EBX_ID = 753;
    public static final int M_DS_ECX_ESP_ID = 754;
    public static final int M_DS_ECX_EBP_ID = 755;
    public static final int M_DS_ECX_ESI_ID = 756;
    public static final int M_DS_ECX_EDI_ID = 757;

    public static final int M_DS_EDX_EBX_ID = 758;
    public static final int M_DS_EDX_ESP_ID = 759;
    public static final int M_DS_EDX_EBP_ID = 760;
    public static final int M_DS_EDX_ESI_ID = 761;
    public static final int M_DS_EDX_EDI_ID = 762;

    public static final int M_DS_EBX_ESP_ID = 763;
    public static final int M_DS_EBX_EBP_ID = 764;
    public static final int M_DS_EBX_ESI_ID = 765;
    public static final int M_DS_EBX_EDI_ID = 766;

    public static final int M_DS_ESP_ID = 767;

    public static final int M_DS_EBP_ESP_ID = 768;
    public static final int M_DS_EBP_ESI_ID = 769;
    public static final int M_DS_EBP_EDI_ID = 770;

    public static final int M_DS_ESI_ESP_ID = 771;
    public static final int M_DS_ESI_EDI_ID = 772;

    public static final int M_DS_EDI_ESP_ID = 773;

    public static final int M_DS_3EAX_ID = 774;
    public static final int M_DS_2EAX_ECX_ID = 775;
    public static final int M_DS_2EAX_EDX_ID = 776;
    public static final int M_DS_2EAX_EBX_ID = 777;
    public static final int M_DS_2EAX_ESP_ID = 778;
    public static final int M_DS_2EAX_EBP_ID = 779;
    public static final int M_DS_2EAX_ESI_ID = 780;
    public static final int M_DS_2EAX_EDI_ID = 781;

    public static final int M_DS_2ECX_EAX_ID = 782;
    public static final int M_DS_3ECX_ID = 783;
    public static final int M_DS_2ECX_EDX_ID = 784;
    public static final int M_DS_2ECX_EBX_ID = 785;
    public static final int M_DS_2ECX_ESP_ID = 786;
    public static final int M_DS_2ECX_EBP_ID = 787;
    public static final int M_DS_2ECX_ESI_ID = 788;
    public static final int M_DS_2ECX_EDI_ID = 789;

    public static final int M_DS_2EDX_EAX_ID = 790;
    public static final int M_DS_2EDX_ECX_ID = 791;
    public static final int M_DS_3EDX_ID = 792;
    public static final int M_DS_2EDX_EBX_ID = 793;
    public static final int M_DS_2EDX_ESP_ID = 794;
    public static final int M_DS_2EDX_EBP_ID = 795;
    public static final int M_DS_2EDX_ESI_ID = 796;
    public static final int M_DS_2EDX_EDI_ID = 797;

    public static final int M_DS_2EBX_EAX_ID = 798;
    public static final int M_DS_2EBX_ECX_ID = 799;
    public static final int M_DS_2EBX_EDX_ID = 800;
    public static final int M_DS_3EBX_ID = 801;
    public static final int M_DS_2EBX_ESP_ID = 802;
    public static final int M_DS_2EBX_EBP_ID = 803;
    public static final int M_DS_2EBX_ESI_ID = 804;
    public static final int M_DS_2EBX_EDI_ID = 805;

    public static final int M_DS_2EBP_EAX_ID = 806;
    public static final int M_DS_2EBP_ECX_ID = 807;
    public static final int M_DS_2EBP_EDX_ID = 808;
    public static final int M_DS_2EBP_EBX_ID = 809;
    public static final int M_DS_2EBP_ESP_ID = 810;
    public static final int M_DS_3EBP_ID = 811;
    public static final int M_DS_2EBP_ESI_ID = 812;
    public static final int M_DS_2EBP_EDI_ID = 813;

    public static final int M_DS_2ESI_EAX_ID = 814;
    public static final int M_DS_2ESI_ECX_ID = 815;
    public static final int M_DS_2ESI_EDX_ID = 816;
    public static final int M_DS_2ESI_EBX_ID = 817;
    public static final int M_DS_2ESI_ESP_ID = 818;
    public static final int M_DS_2ESI_EBP_ID = 819;
    public static final int M_DS_3ESI_ID = 820;
    public static final int M_DS_2ESI_EDI_ID = 821;

    public static final int M_DS_2EDI_EAX_ID = 822;
    public static final int M_DS_2EDI_ECX_ID = 823;
    public static final int M_DS_2EDI_EDX_ID = 824;
    public static final int M_DS_2EDI_EBX_ID = 825;
    public static final int M_DS_2EDI_ESP_ID = 826;
    public static final int M_DS_2EDI_EBP_ID = 827;
    public static final int M_DS_2EDI_ESI_ID = 828;
    public static final int M_DS_3EDI_ID = 829;

    public static final int M_DS_5EAX_ID = 830;
    public static final int M_DS_4EAX_ECX_ID = 831;
    public static final int M_DS_4EAX_EDX_ID = 832;
    public static final int M_DS_4EAX_EBX_ID = 833;
    public static final int M_DS_4EAX_ESP_ID = 834;
    public static final int M_DS_4EAX_EBP_ID = 835;
    public static final int M_DS_4EAX_ESI_ID = 836;
    public static final int M_DS_4EAX_EDI_ID = 837;

    public static final int M_DS_4ECX_EAX_ID = 838;
    public static final int M_DS_5ECX_ID = 839;
    public static final int M_DS_4ECX_EDX_ID = 840;
    public static final int M_DS_4ECX_EBX_ID = 841;
    public static final int M_DS_4ECX_ESP_ID = 842;
    public static final int M_DS_4ECX_EBP_ID = 843;
    public static final int M_DS_4ECX_ESI_ID = 844;
    public static final int M_DS_4ECX_EDI_ID = 845;

    public static final int M_DS_4EDX_EAX_ID = 846;
    public static final int M_DS_4EDX_ECX_ID = 847;
    public static final int M_DS_5EDX_ID = 848;
    public static final int M_DS_4EDX_EBX_ID = 849;
    public static final int M_DS_4EDX_ESP_ID = 850;
    public static final int M_DS_4EDX_EBP_ID = 851;
    public static final int M_DS_4EDX_ESI_ID = 852;
    public static final int M_DS_4EDX_EDI_ID = 853;

    public static final int M_DS_4EBX_EAX_ID = 854;
    public static final int M_DS_4EBX_ECX_ID = 855;
    public static final int M_DS_4EBX_EDX_ID = 856;
    public static final int M_DS_5EBX_ID = 857;
    public static final int M_DS_4EBX_ESP_ID = 858;
    public static final int M_DS_4EBX_EBP_ID = 859;
    public static final int M_DS_4EBX_ESI_ID = 860;
    public static final int M_DS_4EBX_EDI_ID = 861;

    public static final int M_DS_4EBP_EAX_ID = 862;
    public static final int M_DS_4EBP_ECX_ID = 863;
    public static final int M_DS_4EBP_EDX_ID = 864;
    public static final int M_DS_4EBP_EBX_ID = 865;
    public static final int M_DS_4EBP_ESP_ID = 866;
    public static final int M_DS_5EBP_ID = 867;
    public static final int M_DS_4EBP_ESI_ID = 868;
    public static final int M_DS_4EBP_EDI_ID = 869;

    public static final int M_DS_4ESI_EAX_ID = 870;
    public static final int M_DS_4ESI_ECX_ID = 871;
    public static final int M_DS_4ESI_EDX_ID = 872;
    public static final int M_DS_4ESI_EBX_ID = 873;
    public static final int M_DS_4ESI_ESP_ID = 874;
    public static final int M_DS_4ESI_EBP_ID = 875;
    public static final int M_DS_5ESI_ID = 876;
    public static final int M_DS_4ESI_EDI_ID = 877;

    public static final int M_DS_4EDI_EAX_ID = 878;
    public static final int M_DS_4EDI_ECX_ID = 879;
    public static final int M_DS_4EDI_EDX_ID = 880;
    public static final int M_DS_4EDI_EBX_ID = 881;
    public static final int M_DS_4EDI_ESP_ID = 882;
    public static final int M_DS_4EDI_EBP_ID = 883;
    public static final int M_DS_4EDI_ESI_ID = 884;
    public static final int M_DS_5EDI_ID = 885;

    public static final int M_DS_9EAX_ID = 886;
    public static final int M_DS_8EAX_ECX_ID = 887;
    public static final int M_DS_8EAX_EDX_ID = 888;
    public static final int M_DS_8EAX_EBX_ID = 889;
    public static final int M_DS_8EAX_ESP_ID = 890;
    public static final int M_DS_8EAX_EBP_ID = 891;
    public static final int M_DS_8EAX_ESI_ID = 892;
    public static final int M_DS_8EAX_EDI_ID = 893;

    public static final int M_DS_8ECX_EAX_ID = 894;
    public static final int M_DS_9ECX_ID = 895;
    public static final int M_DS_8ECX_EDX_ID = 896;
    public static final int M_DS_8ECX_EBX_ID = 897;
    public static final int M_DS_8ECX_ESP_ID = 898;
    public static final int M_DS_8ECX_EBP_ID = 899;
    public static final int M_DS_8ECX_ESI_ID = 900;
    public static final int M_DS_8ECX_EDI_ID = 901;

    public static final int M_DS_8EDX_EAX_ID = 902;
    public static final int M_DS_8EDX_ECX_ID = 903;
    public static final int M_DS_9EDX_ID = 904;
    public static final int M_DS_8EDX_EBX_ID = 905;
    public static final int M_DS_8EDX_ESP_ID = 906;
    public static final int M_DS_8EDX_EBP_ID = 907;
    public static final int M_DS_8EDX_ESI_ID = 908;
    public static final int M_DS_8EDX_EDI_ID = 909;

    public static final int M_DS_8EBX_EAX_ID = 910;
    public static final int M_DS_8EBX_ECX_ID = 911;
    public static final int M_DS_8EBX_EDX_ID = 912;
    public static final int M_DS_9EBX_ID = 913;
    public static final int M_DS_8EBX_ESP_ID = 914;
    public static final int M_DS_8EBX_EBP_ID = 915;
    public static final int M_DS_8EBX_ESI_ID = 916;
    public static final int M_DS_8EBX_EDI_ID = 917;

    public static final int M_DS_8EBP_EAX_ID = 918;
    public static final int M_DS_8EBP_ECX_ID = 919;
    public static final int M_DS_8EBP_EDX_ID = 920;
    public static final int M_DS_8EBP_EBX_ID = 921;
    public static final int M_DS_8EBP_ESP_ID = 922;
    public static final int M_DS_9EBP_ID = 923;
    public static final int M_DS_8EBP_ESI_ID = 924;
    public static final int M_DS_8EBP_EDI_ID = 925;

    public static final int M_DS_8ESI_EAX_ID = 926;
    public static final int M_DS_8ESI_ECX_ID = 927;
    public static final int M_DS_8ESI_EDX_ID = 928;
    public static final int M_DS_8ESI_EBX_ID = 929;
    public static final int M_DS_8ESI_ESP_ID = 930;
    public static final int M_DS_8ESI_EBP_ID = 931;
    public static final int M_DS_9ESI_ID = 932;
    public static final int M_DS_8ESI_EDI_ID = 933;
    
    public static final int M_DS_8EDI_EAX_ID = 934;
    public static final int M_DS_8EDI_ECX_ID = 935;
    public static final int M_DS_8EDI_EDX_ID = 936;
    public static final int M_DS_8EDI_EBX_ID = 937;
    public static final int M_DS_8EDI_ESP_ID = 938;
    public static final int M_DS_8EDI_EBP_ID = 939;
    public static final int M_DS_8EDI_ESI_ID = 940;
    public static final int M_DS_9EDI_ID = 941;


    //SIB Operands
    public static final int M_ES_2EAX = 942;
    public static final int M_ES_EAX_ECX = 943;
    public static final int M_ES_EAX_EDX = 944;
    public static final int M_ES_EAX_EBX = 945;
    public static final int M_ES_EAX_ESP = 946;
    public static final int M_ES_EAX_EBP = 947;
    public static final int M_ES_EAX_ESI = 948;
    public static final int M_ES_EAX_EDI = 949;

    public static final int M_ES_2ECX = 950;
    public static final int M_ES_ECX_EDX = 951;
    public static final int M_ES_ECX_EBX = 952;
    public static final int M_ES_ECX_ESP = 953;
    public static final int M_ES_ECX_EBP = 954;
    public static final int M_ES_ECX_ESI = 955;
    public static final int M_ES_ECX_EDI = 956;

    public static final int M_ES_2EDX = 957;

    public static final int M_ES_EDX_EBX = 958;
    public static final int M_ES_EDX_ESP = 959;
    public static final int M_ES_EDX_EBP = 960;
    public static final int M_ES_EDX_ESI = 961;
    public static final int M_ES_EDX_EDI = 962;

    public static final int M_ES_2EBX = 963;
    public static final int M_ES_EBX_ESP = 964;
    public static final int M_ES_EBX_EBP = 965;
    public static final int M_ES_EBX_ESI = 966;
    public static final int M_ES_EBX_EDI = 967;

    public static final int M_ES_ESP = 968;

    public static final int M_ES_EBP_ESP = 969;
    public static final int M_ES_EBP_ESI = 970;
    public static final int M_ES_EBP_EDI = 971;

    public static final int M_ES_ESI_ESP = 972;
    public static final int M_ES_2ESI = 973;
    public static final int M_ES_ESI_EDI = 974;

    public static final int M_ES_EDI_ESP = 975;
    public static final int M_ES_2EDI = 976;

    public static final int M_ES_3EAX = 977;
    public static final int M_ES_2EAX_ECX = 978;
    public static final int M_ES_2EAX_EDX = 979;
    public static final int M_ES_2EAX_EBX = 980;
    public static final int M_ES_2EAX_ESP = 981;
    public static final int M_ES_2EAX_ID = 982;
    public static final int M_ES_2EAX_ESI = 983;
    public static final int M_ES_2EAX_EDI = 984;

    public static final int M_ES_2ECX_EAX = 985;
    public static final int M_ES_3ECX = 986;
    public static final int M_ES_2ECX_EDX = 987;
    public static final int M_ES_2ECX_EBX = 988;
    public static final int M_ES_2ECX_ESP = 989;
    public static final int M_ES_2ECX_ID = 990;
    public static final int M_ES_2ECX_ESI = 991;
    public static final int M_ES_2ECX_EDI = 992;

    public static final int M_ES_2EDX_EAX = 993;
    public static final int M_ES_2EDX_ECX = 994;
    public static final int M_ES_3EDX = 995;
    public static final int M_ES_2EDX_EBX = 996;
    public static final int M_ES_2EDX_ESP = 997;
    public static final int M_ES_2EDX_ID = 998;
    public static final int M_ES_2EDX_ESI = 999;
    public static final int M_ES_2EDX_EDI = 1000;

    public static final int M_ES_2EBX_EAX = 1001;
    public static final int M_ES_2EBX_ECX = 1002;
    public static final int M_ES_2EBX_EDX = 1003;
    public static final int M_ES_3EBX = 1004;
    public static final int M_ES_2EBX_ESP = 1005;
    public static final int M_ES_2EBX_ID = 1006;
    public static final int M_ES_2EBX_ESI = 1007;
    public static final int M_ES_2EBX_EDI = 1008;

    public static final int M_ES_2EBP_EAX = 1009;
    public static final int M_ES_2EBP_ECX = 1010;
    public static final int M_ES_2EBP_EDX = 1011;
    public static final int M_ES_2EBP_EBX = 1012;
    public static final int M_ES_2EBP_ESP = 1013;
    public static final int M_ES_2EBP_ID = 1014;
    public static final int M_ES_2EBP_ESI = 1015;
    public static final int M_ES_2EBP_EDI = 1016;

    public static final int M_ES_2ESI_EAX = 1017;
    public static final int M_ES_2ESI_ECX = 1018;
    public static final int M_ES_2ESI_EDX = 1019;
    public static final int M_ES_2ESI_EBX = 1020;
    public static final int M_ES_2ESI_ESP = 1021;
    public static final int M_ES_2ESI_ID = 1022;
    public static final int M_ES_3ESI = 1023;
    public static final int M_ES_2ESI_EDI = 1024;

    public static final int M_ES_2EDI_EAX = 1025;
    public static final int M_ES_2EDI_ECX = 1026;
    public static final int M_ES_2EDI_EDX = 1027;
    public static final int M_ES_2EDI_EBX = 1028;
    public static final int M_ES_2EDI_ESP = 1029;
    public static final int M_ES_2EDI_ID = 1030;
    public static final int M_ES_2EDI_ESI = 1031;
    public static final int M_ES_3EDI = 1032;

    public static final int M_ES_5EAX = 1033;
    public static final int M_ES_4EAX_ECX = 1034;
    public static final int M_ES_4EAX_EDX = 1035;
    public static final int M_ES_4EAX_EBX = 1036;
    public static final int M_ES_4EAX_ESP = 1037;
    public static final int M_ES_4EAX_ID = 1038;
    public static final int M_ES_4EAX_ESI = 1039;
    public static final int M_ES_4EAX_EDI = 1040;

    public static final int M_ES_4ECX_EAX = 1041;
    public static final int M_ES_5ECX = 1042;
    public static final int M_ES_4ECX_EDX = 1043;
    public static final int M_ES_4ECX_EBX = 1044;
    public static final int M_ES_4ECX_ESP = 1045;
    public static final int M_ES_4ECX_ID = 1046;
    public static final int M_ES_4ECX_ESI = 1047;
    public static final int M_ES_4ECX_EDI = 1048;

    public static final int M_ES_4EDX_EAX = 1049;
    public static final int M_ES_4EDX_ECX = 1050;
    public static final int M_ES_5EDX = 1051;
    public static final int M_ES_4EDX_EBX = 1052;
    public static final int M_ES_4EDX_ESP = 1053;
    public static final int M_ES_4EDX_ID = 1054;
    public static final int M_ES_4EDX_ESI = 1055;
    public static final int M_ES_4EDX_EDI = 1056;

    public static final int M_ES_4EBX_EAX = 1057;
    public static final int M_ES_4EBX_ECX = 1058;
    public static final int M_ES_4EBX_EDX = 1059;
    public static final int M_ES_5EBX = 1060;
    public static final int M_ES_4EBX_ESP = 1061;
    public static final int M_ES_4EBX_ID = 1062;
    public static final int M_ES_4EBX_ESI = 1063;
    public static final int M_ES_4EBX_EDI = 1064;

    public static final int M_ES_4EBP_EAX = 1065;
    public static final int M_ES_4EBP_ECX = 1066;
    public static final int M_ES_4EBP_EDX = 1067;
    public static final int M_ES_4EBP_EBX = 1068;
    public static final int M_ES_4EBP_ESP = 1069;
    public static final int M_ES_4EBP_ID = 1070;
    public static final int M_ES_4EBP_ESI = 1071;
    public static final int M_ES_4EBP_EDI = 1072;

    public static final int M_ES_4ESI_EAX = 1073;
    public static final int M_ES_4ESI_ECX = 1074;
    public static final int M_ES_4ESI_EDX = 1075;
    public static final int M_ES_4ESI_EBX = 1076;
    public static final int M_ES_4ESI_ESP = 1077;
    public static final int M_ES_4ESI_ID = 1078;
    public static final int M_ES_5ESI = 1079;
    public static final int M_ES_4ESI_EDI = 1080;

    public static final int M_ES_4EDI_EAX = 1081;
    public static final int M_ES_4EDI_ECX = 1082;
    public static final int M_ES_4EDI_EDX = 1083;
    public static final int M_ES_4EDI_EBX = 1084;
    public static final int M_ES_4EDI_ESP = 1085;
    public static final int M_ES_4EDI_ID = 1086;
    public static final int M_ES_4EDI_ESI = 1087;
    public static final int M_ES_5EDI = 1088;

    public static final int M_ES_9EAX = 1089;
    public static final int M_ES_8EAX_ECX = 1090;
    public static final int M_ES_8EAX_EDX = 1091;
    public static final int M_ES_8EAX_EBX = 1092;
    public static final int M_ES_8EAX_ESP = 1093;
    public static final int M_ES_8EAX_ID = 1094;
    public static final int M_ES_8EAX_ESI = 1095;
    public static final int M_ES_8EAX_EDI = 1096;

    public static final int M_ES_8ECX_EAX = 1097;
    public static final int M_ES_9ECX = 1098;
    public static final int M_ES_8ECX_EDX = 1099;
    public static final int M_ES_8ECX_EBX = 1100;
    public static final int M_ES_8ECX_ESP = 1101;
    public static final int M_ES_8ECX_ID = 1102;
    public static final int M_ES_8ECX_ESI = 1103;
    public static final int M_ES_8ECX_EDI = 1104;

    public static final int M_ES_8EDX_EAX = 1105;
    public static final int M_ES_8EDX_ECX = 1106;
    public static final int M_ES_9EDX = 1107;
    public static final int M_ES_8EDX_EBX = 1108;
    public static final int M_ES_8EDX_ESP = 1109;
    public static final int M_ES_8EDX_ID = 1110;
    public static final int M_ES_8EDX_ESI = 1111;
    public static final int M_ES_8EDX_EDI = 1112;

    public static final int M_ES_8EBX_EAX = 1113;
    public static final int M_ES_8EBX_ECX = 1114;
    public static final int M_ES_8EBX_EDX = 1115;
    public static final int M_ES_9EBX = 1116;
    public static final int M_ES_8EBX_ESP = 1117;
    public static final int M_ES_8EBX_ID = 1118;
    public static final int M_ES_8EBX_ESI = 1119;
    public static final int M_ES_8EBX_EDI = 1120;

    public static final int M_ES_8EBP_EAX = 1121;
    public static final int M_ES_8EBP_ECX = 1122;
    public static final int M_ES_8EBP_EDX = 1123;
    public static final int M_ES_8EBP_EBX = 1124;
    public static final int M_ES_8EBP_ESP = 1125;
    public static final int M_ES_8EBP_ID = 1126;
    public static final int M_ES_8EBP_ESI = 1127;
    public static final int M_ES_8EBP_EDI = 1128;

    public static final int M_ES_8ESI_EAX = 1129;
    public static final int M_ES_8ESI_ECX = 1130;
    public static final int M_ES_8ESI_EDX = 1131;
    public static final int M_ES_8ESI_EBX = 1132;
    public static final int M_ES_8ESI_ESP = 1133;
    public static final int M_ES_8ESI_ID = 1134;
    public static final int M_ES_9ESI = 1135;
    public static final int M_ES_8ESI_EDI = 1136;
    
    public static final int M_ES_8EDI_EAX = 1137;
    public static final int M_ES_8EDI_ECX = 1138;
    public static final int M_ES_8EDI_EDX = 1139;
    public static final int M_ES_8EDI_EBX = 1140;
    public static final int M_ES_8EDI_ESP = 1141;
    public static final int M_ES_8EDI_ID = 1142;
    public static final int M_ES_8EDI_ESI = 1143;
    public static final int M_ES_9EDI = 1144;

    //SIB + IB Operands
    public static final int M_ES_2EAX_IB = 1145;
    public static final int M_ES_EAX_ECX_IB = 1146;
    public static final int M_ES_EAX_EDX_IB = 1147;
    public static final int M_ES_EAX_EBX_IB = 1148;
    public static final int M_ES_EAX_ESP_IB = 1149;
    public static final int M_ES_EAX_EBP_IB = 1150;
    public static final int M_ES_EAX_ESI_IB = 1151;
    public static final int M_ES_EAX_EDI_IB = 1152;

    public static final int M_ES_2ECX_IB = 1153;
    public static final int M_ES_ECX_EDX_IB = 1154;
    public static final int M_ES_ECX_EBX_IB = 1155;
    public static final int M_ES_ECX_ESP_IB = 1156;
    public static final int M_ES_ECX_EBP_IB = 1157;
    public static final int M_ES_ECX_ESI_IB = 1158;
    public static final int M_ES_ECX_EDI_IB = 1159;

    public static final int M_ES_2EDX_IB = 1160;
    public static final int M_ES_EDX_EBX_IB = 1161;
    public static final int M_ES_EDX_ESP_IB = 1162;
    public static final int M_ES_EDX_EBP_IB = 1163;
    public static final int M_ES_EDX_ESI_IB = 1164;
    public static final int M_ES_EDX_EDI_IB = 1165;

    public static final int M_ES_2EBX_IB = 1166;
    public static final int M_ES_EBX_ESP_IB = 1167;
    public static final int M_ES_EBX_EBP_IB = 1168;
    public static final int M_ES_EBX_ESI_IB = 1169;
    public static final int M_ES_EBX_EDI_IB = 1170;

    public static final int M_ES_ESP_IB = 1171;

    public static final int M_ES_EBP_ESP_IB = 1172;
    public static final int M_ES_2EBP_IB = 1173;
    public static final int M_ES_EBP_ESI_IB = 1174;
    public static final int M_ES_EBP_EDI_IB = 1175;

    public static final int M_ES_ESI_ESP_IB = 1176;
    public static final int M_ES_2ESI_IB = 1177;
    public static final int M_ES_ESI_EDI_IB = 1178;

    public static final int M_ES_EDI_ESP_IB = 1179;
    public static final int M_ES_2EDI_IB = 1180;

    public static final int M_ES_3EAX_IB = 1181;
    public static final int M_ES_2EAX_ECX_IB = 1182;
    public static final int M_ES_2EAX_EDX_IB = 1183;
    public static final int M_ES_2EAX_EBX_IB = 1184;
    public static final int M_ES_2EAX_ESP_IB = 1185;
    public static final int M_ES_2EAX_EBP_IB = 1186;
    public static final int M_ES_2EAX_ESI_IB = 1187;
    public static final int M_ES_2EAX_EDI_IB = 1188;

    public static final int M_ES_2ECX_EAX_IB = 1189;
    public static final int M_ES_3ECX_IB = 1190;
    public static final int M_ES_2ECX_EDX_IB = 1191;
    public static final int M_ES_2ECX_EBX_IB = 1192;
    public static final int M_ES_2ECX_ESP_IB = 1193;
    public static final int M_ES_2ECX_EBP_IB = 1194;
    public static final int M_ES_2ECX_ESI_IB = 1195;
    public static final int M_ES_2ECX_EDI_IB = 1196;

    public static final int M_ES_2EDX_EAX_IB = 1197;
    public static final int M_ES_2EDX_ECX_IB = 1198;
    public static final int M_ES_3EDX_IB = 1199;
    public static final int M_ES_2EDX_EBX_IB = 1200;
    public static final int M_ES_2EDX_ESP_IB = 1201;
    public static final int M_ES_2EDX_EBP_IB = 1202;
    public static final int M_ES_2EDX_ESI_IB = 1203;
    public static final int M_ES_2EDX_EDI_IB = 1204;

    public static final int M_ES_2EBX_EAX_IB = 1205;
    public static final int M_ES_2EBX_ECX_IB = 1206;
    public static final int M_ES_2EBX_EDX_IB = 1207;
    public static final int M_ES_3EBX_IB = 1208;
    public static final int M_ES_2EBX_ESP_IB = 1209;
    public static final int M_ES_2EBX_EBP_IB = 1210;
    public static final int M_ES_2EBX_ESI_IB = 1211;
    public static final int M_ES_2EBX_EDI_IB = 1212;

    public static final int M_ES_2EBP_EAX_IB = 1213;
    public static final int M_ES_2EBP_ECX_IB = 1214;
    public static final int M_ES_2EBP_EDX_IB = 1215;
    public static final int M_ES_2EBP_EBX_IB = 1216;
    public static final int M_ES_2EBP_ESP_IB = 1217;
    public static final int M_ES_3EBP_IB = 1218;
    public static final int M_ES_2EBP_ESI_IB = 1219;
    public static final int M_ES_2EBP_EDI_IB = 1220;

    public static final int M_ES_2ESI_EAX_IB = 1221;
    public static final int M_ES_2ESI_ECX_IB = 1222;
    public static final int M_ES_2ESI_EDX_IB = 1223;
    public static final int M_ES_2ESI_EBX_IB = 1224;
    public static final int M_ES_2ESI_ESP_IB = 1225;
    public static final int M_ES_2ESI_EBP_IB = 1226;
    public static final int M_ES_3ESI_IB = 1227;
    public static final int M_ES_2ESI_EDI_IB = 1228;

    public static final int M_ES_2EDI_EAX_IB = 1229;
    public static final int M_ES_2EDI_ECX_IB = 1230;
    public static final int M_ES_2EDI_EDX_IB = 1231;
    public static final int M_ES_2EDI_EBX_IB = 1232;
    public static final int M_ES_2EDI_ESP_IB = 1233;
    public static final int M_ES_2EDI_EBP_IB = 1234;
    public static final int M_ES_2EDI_ESI_IB = 1235;
    public static final int M_ES_3EDI_IB = 1236;

    public static final int M_ES_5EAX_IB = 1237;
    public static final int M_ES_4EAX_ECX_IB = 1238;
    public static final int M_ES_4EAX_EDX_IB = 1239;
    public static final int M_ES_4EAX_EBX_IB = 1240;
    public static final int M_ES_4EAX_ESP_IB = 1241;
    public static final int M_ES_4EAX_EBP_IB = 1242;
    public static final int M_ES_4EAX_ESI_IB = 1243;
    public static final int M_ES_4EAX_EDI_IB = 1244;

    public static final int M_ES_4ECX_EAX_IB = 1245;
    public static final int M_ES_5ECX_IB = 1246;
    public static final int M_ES_4ECX_EDX_IB = 1247;
    public static final int M_ES_4ECX_EBX_IB = 1248;
    public static final int M_ES_4ECX_ESP_IB = 1249;
    public static final int M_ES_4ECX_EBP_IB = 1250;
    public static final int M_ES_4ECX_ESI_IB = 1251;
    public static final int M_ES_4ECX_EDI_IB = 1252;

    public static final int M_ES_4EDX_EAX_IB = 1253;
    public static final int M_ES_4EDX_ECX_IB = 1254;
    public static final int M_ES_5EDX_IB = 1255;
    public static final int M_ES_4EDX_EBX_IB = 1256;
    public static final int M_ES_4EDX_ESP_IB = 1257;
    public static final int M_ES_4EDX_EBP_IB = 1258;
    public static final int M_ES_4EDX_ESI_IB = 1259;
    public static final int M_ES_4EDX_EDI_IB = 1260;

    public static final int M_ES_4EBX_EAX_IB = 1261;
    public static final int M_ES_4EBX_ECX_IB = 1262;
    public static final int M_ES_4EBX_EDX_IB = 1263;
    public static final int M_ES_5EBX_IB = 1264;
    public static final int M_ES_4EBX_ESP_IB = 1265;
    public static final int M_ES_4EBX_EBP_IB = 1266;
    public static final int M_ES_4EBX_ESI_IB = 1267;
    public static final int M_ES_4EBX_EDI_IB = 1268;

    public static final int M_ES_4EBP_EAX_IB = 1269;
    public static final int M_ES_4EBP_ECX_IB = 1270;
    public static final int M_ES_4EBP_EDX_IB = 1271;
    public static final int M_ES_4EBP_EBX_IB = 1272;
    public static final int M_ES_4EBP_ESP_IB = 1273;
    public static final int M_ES_5EBP_IB = 1274;
    public static final int M_ES_4EBP_ESI_IB = 1275;
    public static final int M_ES_4EBP_EDI_IB = 1276;

    public static final int M_ES_4ESI_EAX_IB = 1277;
    public static final int M_ES_4ESI_ECX_IB = 1278;
    public static final int M_ES_4ESI_EDX_IB = 1279;
    public static final int M_ES_4ESI_EBX_IB = 1280;
    public static final int M_ES_4ESI_ESP_IB = 1281;
    public static final int M_ES_4ESI_EBP_IB = 1282;
    public static final int M_ES_5ESI_IB = 1283;
    public static final int M_ES_4ESI_EDI_IB = 1284;

    public static final int M_ES_4EDI_EAX_IB = 1285;
    public static final int M_ES_4EDI_ECX_IB = 1286;
    public static final int M_ES_4EDI_EDX_IB = 1287;
    public static final int M_ES_4EDI_EBX_IB = 1288;
    public static final int M_ES_4EDI_ESP_IB = 1289;
    public static final int M_ES_4EDI_EBP_IB = 1290;
    public static final int M_ES_4EDI_ESI_IB = 1291;
    public static final int M_ES_5EDI_IB = 1292;

    public static final int M_ES_9EAX_IB = 1293;
    public static final int M_ES_8EAX_ECX_IB = 1294;
    public static final int M_ES_8EAX_EDX_IB = 1295;
    public static final int M_ES_8EAX_EBX_IB = 1296;
    public static final int M_ES_8EAX_ESP_IB = 1297;
    public static final int M_ES_8EAX_EBP_IB = 1298;
    public static final int M_ES_8EAX_ESI_IB = 1299;
    public static final int M_ES_8EAX_EDI_IB = 1300;

    public static final int M_ES_8ECX_EAX_IB = 1301;
    public static final int M_ES_9ECX_IB = 1302;
    public static final int M_ES_8ECX_EDX_IB = 1303;
    public static final int M_ES_8ECX_EBX_IB = 1304;
    public static final int M_ES_8ECX_ESP_IB = 1305;
    public static final int M_ES_8ECX_EBP_IB = 1306;
    public static final int M_ES_8ECX_ESI_IB = 1307;
    public static final int M_ES_8ECX_EDI_IB = 1308;

    public static final int M_ES_8EDX_EAX_IB = 1309;
    public static final int M_ES_8EDX_ECX_IB = 1310;
    public static final int M_ES_9EDX_IB = 1311;
    public static final int M_ES_8EDX_EBX_IB = 1312;
    public static final int M_ES_8EDX_ESP_IB = 1313;
    public static final int M_ES_8EDX_EBP_IB = 1314;
    public static final int M_ES_8EDX_ESI_IB = 1315;
    public static final int M_ES_8EDX_EDI_IB = 1316;

    public static final int M_ES_8EBX_EAX_IB = 1317;
    public static final int M_ES_8EBX_ECX_IB = 1318;
    public static final int M_ES_8EBX_EDX_IB = 1319;
    public static final int M_ES_9EBX_IB = 1320;
    public static final int M_ES_8EBX_ESP_IB = 1321;
    public static final int M_ES_8EBX_EBP_IB = 1322;
    public static final int M_ES_8EBX_ESI_IB = 1323;
    public static final int M_ES_8EBX_EDI_IB = 1324;

    public static final int M_ES_8EBP_EAX_IB = 1325;
    public static final int M_ES_8EBP_ECX_IB = 1326;
    public static final int M_ES_8EBP_EDX_IB = 1327;
    public static final int M_ES_8EBP_EBX_IB = 1328;
    public static final int M_ES_8EBP_ESP_IB = 1329;
    public static final int M_ES_9EBP_IB = 1330;
    public static final int M_ES_8EBP_ESI_IB = 1331;
    public static final int M_ES_8EBP_EDI_IB = 1332;

    public static final int M_ES_8ESI_EAX_IB = 1333;
    public static final int M_ES_8ESI_ECX_IB = 1334;
    public static final int M_ES_8ESI_EDX_IB = 1335;
    public static final int M_ES_8ESI_EBX_IB = 1336;
    public static final int M_ES_8ESI_ESP_IB = 1337;
    public static final int M_ES_8ESI_EBP_IB = 1338;
    public static final int M_ES_9ESI_IB = 1339;
    public static final int M_ES_8ESI_EDI_IB = 1340;
    
    public static final int M_ES_8EDI_EAX_IB = 1341;
    public static final int M_ES_8EDI_ECX_IB = 1342;
    public static final int M_ES_8EDI_EDX_IB = 1343;
    public static final int M_ES_8EDI_EBX_IB = 1344;
    public static final int M_ES_8EDI_ESP_IB = 1345;
    public static final int M_ES_8EDI_EBP_IB = 1346;
    public static final int M_ES_8EDI_ESI_IB = 1347;
    public static final int M_ES_9EDI_IB = 1348;

    //SIB + ID Operands
    public static final int M_ES_EAX_ECX_ID = 1349;
    public static final int M_ES_EAX_EDX_ID = 1350;
    public static final int M_ES_EAX_EBX_ID = 1351;
    public static final int M_ES_EAX_ESP_ID = 1352;
    public static final int M_ES_EAX_EBP_ID = 1353;
    public static final int M_ES_EAX_ESI_ID = 1354;
    public static final int M_ES_EAX_EDI_ID = 1355;

    public static final int M_ES_ECX_EDX_ID = 1356;
    public static final int M_ES_ECX_EBX_ID = 1357;
    public static final int M_ES_ECX_ESP_ID = 1358;
    public static final int M_ES_ECX_EBP_ID = 1359;
    public static final int M_ES_ECX_ESI_ID = 1360;
    public static final int M_ES_ECX_EDI_ID = 1361;

    public static final int M_ES_EDX_EBX_ID = 1362;
    public static final int M_ES_EDX_ESP_ID = 1363;
    public static final int M_ES_EDX_EBP_ID = 1364;
    public static final int M_ES_EDX_ESI_ID = 1365;
    public static final int M_ES_EDX_EDI_ID = 1366;

    public static final int M_ES_EBX_ESP_ID = 1367;
    public static final int M_ES_EBX_EBP_ID = 1368;
    public static final int M_ES_EBX_ESI_ID = 1369;
    public static final int M_ES_EBX_EDI_ID = 1370;

    public static final int M_ES_ESP_ID = 1371;

    public static final int M_ES_EBP_ESP_ID = 1372;
    public static final int M_ES_EBP_ESI_ID = 1373;
    public static final int M_ES_EBP_EDI_ID = 1374;

    public static final int M_ES_ESI_ESP_ID = 1375;
    public static final int M_ES_ESI_EDI_ID = 1376;

    public static final int M_ES_EDI_ESP_ID = 1377;

    public static final int M_ES_3EAX_ID = 1378;
    public static final int M_ES_2EAX_ECX_ID = 1379;
    public static final int M_ES_2EAX_EDX_ID = 1380;
    public static final int M_ES_2EAX_EBX_ID = 1381;
    public static final int M_ES_2EAX_ESP_ID = 1382;
    public static final int M_ES_2EAX_EBP_ID = 1383;
    public static final int M_ES_2EAX_ESI_ID = 1384;
    public static final int M_ES_2EAX_EDI_ID = 1385;

    public static final int M_ES_2ECX_EAX_ID = 1386;
    public static final int M_ES_3ECX_ID = 1387;
    public static final int M_ES_2ECX_EDX_ID = 1388;
    public static final int M_ES_2ECX_EBX_ID = 1389;
    public static final int M_ES_2ECX_ESP_ID = 1390;
    public static final int M_ES_2ECX_EBP_ID = 1391;
    public static final int M_ES_2ECX_ESI_ID = 1392;
    public static final int M_ES_2ECX_EDI_ID = 1393;

    public static final int M_ES_2EDX_EAX_ID = 1394;
    public static final int M_ES_2EDX_ECX_ID = 1395;
    public static final int M_ES_3EDX_ID = 1396;
    public static final int M_ES_2EDX_EBX_ID = 1397;
    public static final int M_ES_2EDX_ESP_ID = 1398;
    public static final int M_ES_2EDX_EBP_ID = 1399;
    public static final int M_ES_2EDX_ESI_ID = 1400;
    public static final int M_ES_2EDX_EDI_ID = 1401;

    public static final int M_ES_2EBX_EAX_ID = 1402;
    public static final int M_ES_2EBX_ECX_ID = 1403;
    public static final int M_ES_2EBX_EDX_ID = 1404;
    public static final int M_ES_3EBX_ID = 1405;
    public static final int M_ES_2EBX_ESP_ID = 1406;
    public static final int M_ES_2EBX_EBP_ID = 1407;
    public static final int M_ES_2EBX_ESI_ID = 1408;
    public static final int M_ES_2EBX_EDI_ID = 1409;

    public static final int M_ES_2EBP_EAX_ID = 1410;
    public static final int M_ES_2EBP_ECX_ID = 1411;
    public static final int M_ES_2EBP_EDX_ID = 1412;
    public static final int M_ES_2EBP_EBX_ID = 1413;
    public static final int M_ES_2EBP_ESP_ID = 1414;
    public static final int M_ES_3EBP_ID = 1415;
    public static final int M_ES_2EBP_ESI_ID = 1416;
    public static final int M_ES_2EBP_EDI_ID = 1417;

    public static final int M_ES_2ESI_EAX_ID = 1418;
    public static final int M_ES_2ESI_ECX_ID = 1419;
    public static final int M_ES_2ESI_EDX_ID = 1420;
    public static final int M_ES_2ESI_EBX_ID = 1421;
    public static final int M_ES_2ESI_ESP_ID = 1422;
    public static final int M_ES_2ESI_EBP_ID = 1423;
    public static final int M_ES_3ESI_ID = 1424;
    public static final int M_ES_2ESI_EDI_ID = 1425;

    public static final int M_ES_2EDI_EAX_ID = 1426;
    public static final int M_ES_2EDI_ECX_ID = 1427;
    public static final int M_ES_2EDI_EDX_ID = 1428;
    public static final int M_ES_2EDI_EBX_ID = 1429;
    public static final int M_ES_2EDI_ESP_ID = 1430;
    public static final int M_ES_2EDI_EBP_ID = 1431;
    public static final int M_ES_2EDI_ESI_ID = 1432;
    public static final int M_ES_3EDI_ID = 1433;

    public static final int M_ES_5EAX_ID = 1434;
    public static final int M_ES_4EAX_ECX_ID = 1435;
    public static final int M_ES_4EAX_EDX_ID = 1436;
    public static final int M_ES_4EAX_EBX_ID = 1437;
    public static final int M_ES_4EAX_ESP_ID = 1438;
    public static final int M_ES_4EAX_EBP_ID = 1439;
    public static final int M_ES_4EAX_ESI_ID = 1440;
    public static final int M_ES_4EAX_EDI_ID = 1441;

    public static final int M_ES_4ECX_EAX_ID = 1442;
    public static final int M_ES_5ECX_ID = 1443;
    public static final int M_ES_4ECX_EDX_ID = 1444;
    public static final int M_ES_4ECX_EBX_ID = 1445;
    public static final int M_ES_4ECX_ESP_ID = 1446;
    public static final int M_ES_4ECX_EBP_ID = 1447;
    public static final int M_ES_4ECX_ESI_ID = 1448;
    public static final int M_ES_4ECX_EDI_ID = 1449;

    public static final int M_ES_4EDX_EAX_ID = 1450;
    public static final int M_ES_4EDX_ECX_ID = 1451;
    public static final int M_ES_5EDX_ID = 1452;
    public static final int M_ES_4EDX_EBX_ID = 1453;
    public static final int M_ES_4EDX_ESP_ID = 1454;
    public static final int M_ES_4EDX_EBP_ID = 1455;
    public static final int M_ES_4EDX_ESI_ID = 1456;
    public static final int M_ES_4EDX_EDI_ID = 1457;

    public static final int M_ES_4EBX_EAX_ID = 1458;
    public static final int M_ES_4EBX_ECX_ID = 1459;
    public static final int M_ES_4EBX_EDX_ID = 1460;
    public static final int M_ES_5EBX_ID = 1461;
    public static final int M_ES_4EBX_ESP_ID = 1462;
    public static final int M_ES_4EBX_EBP_ID = 1463;
    public static final int M_ES_4EBX_ESI_ID = 1464;
    public static final int M_ES_4EBX_EDI_ID = 1465;

    public static final int M_ES_4EBP_EAX_ID = 1466;
    public static final int M_ES_4EBP_ECX_ID = 1467;
    public static final int M_ES_4EBP_EDX_ID = 1468;
    public static final int M_ES_4EBP_EBX_ID = 1469;
    public static final int M_ES_4EBP_ESP_ID = 1470;
    public static final int M_ES_5EBP_ID = 1471;
    public static final int M_ES_4EBP_ESI_ID = 1472;
    public static final int M_ES_4EBP_EDI_ID = 1473;

    public static final int M_ES_4ESI_EAX_ID = 1474;
    public static final int M_ES_4ESI_ECX_ID = 1475;
    public static final int M_ES_4ESI_EDX_ID = 1476;
    public static final int M_ES_4ESI_EBX_ID = 1477;
    public static final int M_ES_4ESI_ESP_ID = 1478;
    public static final int M_ES_4ESI_EBP_ID = 1479;
    public static final int M_ES_5ESI_ID = 1480;
    public static final int M_ES_4ESI_EDI_ID = 1481;

    public static final int M_ES_4EDI_EAX_ID = 1482;
    public static final int M_ES_4EDI_ECX_ID = 1483;
    public static final int M_ES_4EDI_EDX_ID = 1484;
    public static final int M_ES_4EDI_EBX_ID = 1485;
    public static final int M_ES_4EDI_ESP_ID = 1486;
    public static final int M_ES_4EDI_EBP_ID = 1487;
    public static final int M_ES_4EDI_ESI_ID = 1488;
    public static final int M_ES_5EDI_ID = 1489;

    public static final int M_ES_9EAX_ID = 1490;
    public static final int M_ES_8EAX_ECX_ID = 1491;
    public static final int M_ES_8EAX_EDX_ID = 1492;
    public static final int M_ES_8EAX_EBX_ID = 1493;
    public static final int M_ES_8EAX_ESP_ID = 1494;
    public static final int M_ES_8EAX_EBP_ID = 1495;
    public static final int M_ES_8EAX_ESI_ID = 1496;
    public static final int M_ES_8EAX_EDI_ID = 1497;

    public static final int M_ES_8ECX_EAX_ID = 1498;
    public static final int M_ES_9ECX_ID = 1499;
    public static final int M_ES_8ECX_EDX_ID = 1500;
    public static final int M_ES_8ECX_EBX_ID = 1501;
    public static final int M_ES_8ECX_ESP_ID = 1502;
    public static final int M_ES_8ECX_EBP_ID = 1503;
    public static final int M_ES_8ECX_ESI_ID = 1504;
    public static final int M_ES_8ECX_EDI_ID = 1505;

    public static final int M_ES_8EDX_EAX_ID = 1506;
    public static final int M_ES_8EDX_ECX_ID = 1507;
    public static final int M_ES_9EDX_ID = 1508;
    public static final int M_ES_8EDX_EBX_ID = 1509;
    public static final int M_ES_8EDX_ESP_ID = 1510;
    public static final int M_ES_8EDX_EBP_ID = 1511;
    public static final int M_ES_8EDX_ESI_ID = 1512;
    public static final int M_ES_8EDX_EDI_ID = 1513;

    public static final int M_ES_8EBX_EAX_ID = 1514;
    public static final int M_ES_8EBX_ECX_ID = 1515;
    public static final int M_ES_8EBX_EDX_ID = 1516;
    public static final int M_ES_9EBX_ID = 1517;
    public static final int M_ES_8EBX_ESP_ID = 1518;
    public static final int M_ES_8EBX_EBP_ID = 1519;
    public static final int M_ES_8EBX_ESI_ID = 1520;
    public static final int M_ES_8EBX_EDI_ID = 1521;

    public static final int M_ES_8EBP_EAX_ID = 1522;
    public static final int M_ES_8EBP_ECX_ID = 1523;
    public static final int M_ES_8EBP_EDX_ID = 1524;
    public static final int M_ES_8EBP_EBX_ID = 1525;
    public static final int M_ES_8EBP_ESP_ID = 1526;
    public static final int M_ES_9EBP_ID = 1527;
    public static final int M_ES_8EBP_ESI_ID = 1528;
    public static final int M_ES_8EBP_EDI_ID = 1529;

    public static final int M_ES_8ESI_EAX_ID = 1530;
    public static final int M_ES_8ESI_ECX_ID = 1531;
    public static final int M_ES_8ESI_EDX_ID = 1532;
    public static final int M_ES_8ESI_EBX_ID = 1533;
    public static final int M_ES_8ESI_ESP_ID = 1534;
    public static final int M_ES_8ESI_EBP_ID = 1535;
    public static final int M_ES_9ESI_ID = 1536;
    public static final int M_ES_8ESI_EDI_ID = 1537;
    
    public static final int M_ES_8EDI_EAX_ID = 1538;
    public static final int M_ES_8EDI_ECX_ID = 1539;
    public static final int M_ES_8EDI_EDX_ID = 1540;
    public static final int M_ES_8EDI_EBX_ID = 1541;
    public static final int M_ES_8EDI_ESP_ID = 1542;
    public static final int M_ES_8EDI_EBP_ID = 1543;
    public static final int M_ES_8EDI_ESI_ID = 1544;
    public static final int M_ES_9EDI_ID = 1545;

    //SIB Operands
    public static final int M_CS_2EAX = 1546;
    public static final int M_CS_EAX_ECX = 1547;
    public static final int M_CS_EAX_EDX = 1548;
    public static final int M_CS_EAX_EBX = 1549;
    public static final int M_CS_EAX_ESP = 1550;
    public static final int M_CS_EAX_EBP = 1551;
    public static final int M_CS_EAX_ESI = 1552;
    public static final int M_CS_EAX_EDI = 1553;

    public static final int M_CS_2ECX = 1554;
    public static final int M_CS_ECX_EDX = 1555;
    public static final int M_CS_ECX_EBX = 1556;
    public static final int M_CS_ECX_ESP = 1557;
    public static final int M_CS_ECX_EBP = 1558;
    public static final int M_CS_ECX_ESI = 1559;
    public static final int M_CS_ECX_EDI = 1560;

    public static final int M_CS_2EDX = 1561;

    public static final int M_CS_EDX_EBX = 1562;
    public static final int M_CS_EDX_ESP = 1563;
    public static final int M_CS_EDX_EBP = 1564;
    public static final int M_CS_EDX_ESI = 1565;
    public static final int M_CS_EDX_EDI = 1566;

    public static final int M_CS_2EBX = 1567;
    public static final int M_CS_EBX_ESP = 1568;
    public static final int M_CS_EBX_EBP = 1569;
    public static final int M_CS_EBX_ESI = 1570;
    public static final int M_CS_EBX_EDI = 1571;

    public static final int M_CS_ESP = 1572;

    public static final int M_CS_EBP_ESP = 1573;
    public static final int M_CS_EBP_ESI = 1574;
    public static final int M_CS_EBP_EDI = 1575;

    public static final int M_CS_ESI_ESP = 1576;
    public static final int M_CS_2ESI = 1577;
    public static final int M_CS_ESI_EDI = 1578;

    public static final int M_CS_EDI_ESP = 1579;
    public static final int M_CS_2EDI = 1580;

    public static final int M_CS_3EAX = 1581;
    public static final int M_CS_2EAX_ECX = 1582;
    public static final int M_CS_2EAX_EDX = 1583;
    public static final int M_CS_2EAX_EBX = 1584;
    public static final int M_CS_2EAX_ESP = 1585;
    public static final int M_CS_2EAX_ID = 1586;
    public static final int M_CS_2EAX_ESI = 1587;
    public static final int M_CS_2EAX_EDI = 1588;

    public static final int M_CS_2ECX_EAX = 1589;
    public static final int M_CS_3ECX = 1590;
    public static final int M_CS_2ECX_EDX = 1591;
    public static final int M_CS_2ECX_EBX = 1592;
    public static final int M_CS_2ECX_ESP = 1593;
    public static final int M_CS_2ECX_ID = 1594;
    public static final int M_CS_2ECX_ESI = 1595;
    public static final int M_CS_2ECX_EDI = 1596;

    public static final int M_CS_2EDX_EAX = 1597;
    public static final int M_CS_2EDX_ECX = 1598;
    public static final int M_CS_3EDX = 1599;
    public static final int M_CS_2EDX_EBX = 1600;
    public static final int M_CS_2EDX_ESP = 1601;
    public static final int M_CS_2EDX_ID = 1602;
    public static final int M_CS_2EDX_ESI = 1603;
    public static final int M_CS_2EDX_EDI = 1604;

    public static final int M_CS_2EBX_EAX = 1605;
    public static final int M_CS_2EBX_ECX = 1606;
    public static final int M_CS_2EBX_EDX = 1607;
    public static final int M_CS_3EBX = 1608;
    public static final int M_CS_2EBX_ESP = 1609;
    public static final int M_CS_2EBX_ID = 1610;
    public static final int M_CS_2EBX_ESI = 1611;
    public static final int M_CS_2EBX_EDI = 1612;

    public static final int M_CS_2EBP_EAX = 1613;
    public static final int M_CS_2EBP_ECX = 1614;
    public static final int M_CS_2EBP_EDX = 1615;
    public static final int M_CS_2EBP_EBX = 1616;
    public static final int M_CS_2EBP_ESP = 1617;
    public static final int M_CS_2EBP_ID = 1618;
    public static final int M_CS_2EBP_ESI = 1619;
    public static final int M_CS_2EBP_EDI = 1620;

    public static final int M_CS_2ESI_EAX = 1621;
    public static final int M_CS_2ESI_ECX = 1622;
    public static final int M_CS_2ESI_EDX = 1623;
    public static final int M_CS_2ESI_EBX = 1624;
    public static final int M_CS_2ESI_ESP = 1625;
    public static final int M_CS_2ESI_ID = 1626;
    public static final int M_CS_3ESI = 1627;
    public static final int M_CS_2ESI_EDI = 1628;

    public static final int M_CS_2EDI_EAX = 1629;
    public static final int M_CS_2EDI_ECX = 1630;
    public static final int M_CS_2EDI_EDX = 1631;
    public static final int M_CS_2EDI_EBX = 1632;
    public static final int M_CS_2EDI_ESP = 1633;
    public static final int M_CS_2EDI_ID = 1634;
    public static final int M_CS_2EDI_ESI = 1635;
    public static final int M_CS_3EDI = 1636;

    public static final int M_CS_5EAX = 1637;
    public static final int M_CS_4EAX_ECX = 1638;
    public static final int M_CS_4EAX_EDX = 1639;
    public static final int M_CS_4EAX_EBX = 1640;
    public static final int M_CS_4EAX_ESP = 1641;
    public static final int M_CS_4EAX_ID = 1642;
    public static final int M_CS_4EAX_ESI = 1643;
    public static final int M_CS_4EAX_EDI = 1644;

    public static final int M_CS_4ECX_EAX = 1645;
    public static final int M_CS_5ECX = 1646;
    public static final int M_CS_4ECX_EDX = 1647;
    public static final int M_CS_4ECX_EBX = 1648;
    public static final int M_CS_4ECX_ESP = 1649;
    public static final int M_CS_4ECX_ID = 1650;
    public static final int M_CS_4ECX_ESI = 1651;
    public static final int M_CS_4ECX_EDI = 1652;

    public static final int M_CS_4EDX_EAX = 1653;
    public static final int M_CS_4EDX_ECX = 1654;
    public static final int M_CS_5EDX = 1655;
    public static final int M_CS_4EDX_EBX = 1656;
    public static final int M_CS_4EDX_ESP = 1657;
    public static final int M_CS_4EDX_ID = 1658;
    public static final int M_CS_4EDX_ESI = 1659;
    public static final int M_CS_4EDX_EDI = 1660;

    public static final int M_CS_4EBX_EAX = 1661;
    public static final int M_CS_4EBX_ECX = 1662;
    public static final int M_CS_4EBX_EDX = 1663;
    public static final int M_CS_5EBX = 1664;
    public static final int M_CS_4EBX_ESP = 1665;
    public static final int M_CS_4EBX_ID = 1666;
    public static final int M_CS_4EBX_ESI = 1667;
    public static final int M_CS_4EBX_EDI = 1668;

    public static final int M_CS_4EBP_EAX = 1669;
    public static final int M_CS_4EBP_ECX = 1670;
    public static final int M_CS_4EBP_EDX = 1671;
    public static final int M_CS_4EBP_EBX = 1672;
    public static final int M_CS_4EBP_ESP = 1673;
    public static final int M_CS_4EBP_ID = 1674;
    public static final int M_CS_4EBP_ESI = 1675;
    public static final int M_CS_4EBP_EDI = 1676;

    public static final int M_CS_4ESI_EAX = 1677;
    public static final int M_CS_4ESI_ECX = 1678;
    public static final int M_CS_4ESI_EDX = 1679;
    public static final int M_CS_4ESI_EBX = 1680;
    public static final int M_CS_4ESI_ESP = 1681;
    public static final int M_CS_4ESI_ID = 1682;
    public static final int M_CS_5ESI = 1683;
    public static final int M_CS_4ESI_EDI = 1684;

    public static final int M_CS_4EDI_EAX = 1685;
    public static final int M_CS_4EDI_ECX = 1686;
    public static final int M_CS_4EDI_EDX = 1687;
    public static final int M_CS_4EDI_EBX = 1688;
    public static final int M_CS_4EDI_ESP = 1689;
    public static final int M_CS_4EDI_ID = 1690;
    public static final int M_CS_4EDI_ESI = 1691;
    public static final int M_CS_5EDI = 1692;

    public static final int M_CS_9EAX = 1693;
    public static final int M_CS_8EAX_ECX = 1694;
    public static final int M_CS_8EAX_EDX = 1695;
    public static final int M_CS_8EAX_EBX = 1696;
    public static final int M_CS_8EAX_ESP = 1697;
    public static final int M_CS_8EAX_ID = 1698;
    public static final int M_CS_8EAX_ESI = 1699;
    public static final int M_CS_8EAX_EDI = 1700;

    public static final int M_CS_8ECX_EAX = 1701;
    public static final int M_CS_9ECX = 1702;
    public static final int M_CS_8ECX_EDX = 1703;
    public static final int M_CS_8ECX_EBX = 1704;
    public static final int M_CS_8ECX_ESP = 1705;
    public static final int M_CS_8ECX_ID = 1706;
    public static final int M_CS_8ECX_ESI = 1707;
    public static final int M_CS_8ECX_EDI = 1708;

    public static final int M_CS_8EDX_EAX = 1709;
    public static final int M_CS_8EDX_ECX = 1710;
    public static final int M_CS_9EDX = 1711;
    public static final int M_CS_8EDX_EBX = 1712;
    public static final int M_CS_8EDX_ESP = 1713;
    public static final int M_CS_8EDX_ID = 1714;
    public static final int M_CS_8EDX_ESI = 1715;
    public static final int M_CS_8EDX_EDI = 1716;

    public static final int M_CS_8EBX_EAX = 1717;
    public static final int M_CS_8EBX_ECX = 1718;
    public static final int M_CS_8EBX_EDX = 1719;
    public static final int M_CS_9EBX = 1720;
    public static final int M_CS_8EBX_ESP = 1721;
    public static final int M_CS_8EBX_ID = 1722;
    public static final int M_CS_8EBX_ESI = 1723;
    public static final int M_CS_8EBX_EDI = 1724;

    public static final int M_CS_8EBP_EAX = 1725;
    public static final int M_CS_8EBP_ECX = 1726;
    public static final int M_CS_8EBP_EDX = 1727;
    public static final int M_CS_8EBP_EBX = 1728;
    public static final int M_CS_8EBP_ESP = 1729;
    public static final int M_CS_8EBP_ID = 1730;
    public static final int M_CS_8EBP_ESI = 1731;
    public static final int M_CS_8EBP_EDI = 1732;

    public static final int M_CS_8ESI_EAX = 1733;
    public static final int M_CS_8ESI_ECX = 1734;
    public static final int M_CS_8ESI_EDX = 1735;
    public static final int M_CS_8ESI_EBX = 1736;
    public static final int M_CS_8ESI_ESP = 1737;
    public static final int M_CS_8ESI_ID = 1738;
    public static final int M_CS_9ESI = 1739;
    public static final int M_CS_8ESI_EDI = 1740;
    
    public static final int M_CS_8EDI_EAX = 1741;
    public static final int M_CS_8EDI_ECX = 1742;
    public static final int M_CS_8EDI_EDX = 1743;
    public static final int M_CS_8EDI_EBX = 1744;
    public static final int M_CS_8EDI_ESP = 1745;
    public static final int M_CS_8EDI_ID = 1746;
    public static final int M_CS_8EDI_ESI = 1747;
    public static final int M_CS_9EDI = 1748;

    //SIB + IB Operands
    public static final int M_CS_2EAX_IB = 1749;
    public static final int M_CS_EAX_ECX_IB = 1750;
    public static final int M_CS_EAX_EDX_IB = 1751;
    public static final int M_CS_EAX_EBX_IB = 1752;
    public static final int M_CS_EAX_ESP_IB = 1753;
    public static final int M_CS_EAX_EBP_IB = 1754;
    public static final int M_CS_EAX_ESI_IB = 1755;
    public static final int M_CS_EAX_EDI_IB = 1756;

    public static final int M_CS_2ECX_IB = 1757;
    public static final int M_CS_ECX_EDX_IB = 1758;
    public static final int M_CS_ECX_EBX_IB = 1759;
    public static final int M_CS_ECX_ESP_IB = 1760;
    public static final int M_CS_ECX_EBP_IB = 1761;
    public static final int M_CS_ECX_ESI_IB = 1762;
    public static final int M_CS_ECX_EDI_IB = 1763;

    public static final int M_CS_2EDX_IB = 1764;
    public static final int M_CS_EDX_EBX_IB = 1765;
    public static final int M_CS_EDX_ESP_IB = 1766;
    public static final int M_CS_EDX_EBP_IB = 1767;
    public static final int M_CS_EDX_ESI_IB = 1768;
    public static final int M_CS_EDX_EDI_IB = 1769;

    public static final int M_CS_2EBX_IB = 1770;
    public static final int M_CS_EBX_ESP_IB = 1771;
    public static final int M_CS_EBX_EBP_IB = 1772;
    public static final int M_CS_EBX_ESI_IB = 1773;
    public static final int M_CS_EBX_EDI_IB = 1774;

    public static final int M_CS_ESP_IB = 1775;

    public static final int M_CS_EBP_ESP_IB = 1776;
    public static final int M_CS_2EBP_IB = 1777;
    public static final int M_CS_EBP_ESI_IB = 1778;
    public static final int M_CS_EBP_EDI_IB = 1779;

    public static final int M_CS_ESI_ESP_IB = 1780;
    public static final int M_CS_2ESI_IB = 1781;
    public static final int M_CS_ESI_EDI_IB = 1782;

    public static final int M_CS_EDI_ESP_IB = 1783;
    public static final int M_CS_2EDI_IB = 1784;

    public static final int M_CS_3EAX_IB = 1785;
    public static final int M_CS_2EAX_ECX_IB = 1786;
    public static final int M_CS_2EAX_EDX_IB = 1787;
    public static final int M_CS_2EAX_EBX_IB = 1788;
    public static final int M_CS_2EAX_ESP_IB = 1789;
    public static final int M_CS_2EAX_EBP_IB = 1790;
    public static final int M_CS_2EAX_ESI_IB = 1791;
    public static final int M_CS_2EAX_EDI_IB = 1792;

    public static final int M_CS_2ECX_EAX_IB = 1793;
    public static final int M_CS_3ECX_IB = 1794;
    public static final int M_CS_2ECX_EDX_IB = 1795;
    public static final int M_CS_2ECX_EBX_IB = 1796;
    public static final int M_CS_2ECX_ESP_IB = 1797;
    public static final int M_CS_2ECX_EBP_IB = 1798;
    public static final int M_CS_2ECX_ESI_IB = 1799;
    public static final int M_CS_2ECX_EDI_IB = 1800;

    public static final int M_CS_2EDX_EAX_IB = 1801;
    public static final int M_CS_2EDX_ECX_IB = 1802;
    public static final int M_CS_3EDX_IB = 1803;
    public static final int M_CS_2EDX_EBX_IB = 1804;
    public static final int M_CS_2EDX_ESP_IB = 1805;
    public static final int M_CS_2EDX_EBP_IB = 1806;
    public static final int M_CS_2EDX_ESI_IB = 1807;
    public static final int M_CS_2EDX_EDI_IB = 1808;

    public static final int M_CS_2EBX_EAX_IB = 1809;
    public static final int M_CS_2EBX_ECX_IB = 1810;
    public static final int M_CS_2EBX_EDX_IB = 1811;
    public static final int M_CS_3EBX_IB = 1812;
    public static final int M_CS_2EBX_ESP_IB = 1813;
    public static final int M_CS_2EBX_EBP_IB = 1814;
    public static final int M_CS_2EBX_ESI_IB = 1815;
    public static final int M_CS_2EBX_EDI_IB = 1816;

    public static final int M_CS_2EBP_EAX_IB = 1817;
    public static final int M_CS_2EBP_ECX_IB = 1818;
    public static final int M_CS_2EBP_EDX_IB = 1819;
    public static final int M_CS_2EBP_EBX_IB = 1820;
    public static final int M_CS_2EBP_ESP_IB = 1821;
    public static final int M_CS_3EBP_IB = 1822;
    public static final int M_CS_2EBP_ESI_IB = 1823;
    public static final int M_CS_2EBP_EDI_IB = 1824;

    public static final int M_CS_2ESI_EAX_IB = 1825;
    public static final int M_CS_2ESI_ECX_IB = 1826;
    public static final int M_CS_2ESI_EDX_IB = 1827;
    public static final int M_CS_2ESI_EBX_IB = 1828;
    public static final int M_CS_2ESI_ESP_IB = 1829;
    public static final int M_CS_2ESI_EBP_IB = 1830;
    public static final int M_CS_3ESI_IB = 1831;
    public static final int M_CS_2ESI_EDI_IB = 1832;

    public static final int M_CS_2EDI_EAX_IB = 1833;
    public static final int M_CS_2EDI_ECX_IB = 1834;
    public static final int M_CS_2EDI_EDX_IB = 1835;
    public static final int M_CS_2EDI_EBX_IB = 1836;
    public static final int M_CS_2EDI_ESP_IB = 1837;
    public static final int M_CS_2EDI_EBP_IB = 1838;
    public static final int M_CS_2EDI_ESI_IB = 1839;
    public static final int M_CS_3EDI_IB = 1840;

    public static final int M_CS_5EAX_IB = 1841;
    public static final int M_CS_4EAX_ECX_IB = 1842;
    public static final int M_CS_4EAX_EDX_IB = 1843;
    public static final int M_CS_4EAX_EBX_IB = 1844;
    public static final int M_CS_4EAX_ESP_IB = 1845;
    public static final int M_CS_4EAX_EBP_IB = 1846;
    public static final int M_CS_4EAX_ESI_IB = 1847;
    public static final int M_CS_4EAX_EDI_IB = 1848;

    public static final int M_CS_4ECX_EAX_IB = 1849;
    public static final int M_CS_5ECX_IB = 1850;
    public static final int M_CS_4ECX_EDX_IB = 1851;
    public static final int M_CS_4ECX_EBX_IB = 1852;
    public static final int M_CS_4ECX_ESP_IB = 1853;
    public static final int M_CS_4ECX_EBP_IB = 1854;
    public static final int M_CS_4ECX_ESI_IB = 1855;
    public static final int M_CS_4ECX_EDI_IB = 1856;

    public static final int M_CS_4EDX_EAX_IB = 1857;
    public static final int M_CS_4EDX_ECX_IB = 1858;
    public static final int M_CS_5EDX_IB = 1859;
    public static final int M_CS_4EDX_EBX_IB = 1860;
    public static final int M_CS_4EDX_ESP_IB = 1861;
    public static final int M_CS_4EDX_EBP_IB = 1862;
    public static final int M_CS_4EDX_ESI_IB = 1863;
    public static final int M_CS_4EDX_EDI_IB = 1864;

    public static final int M_CS_4EBX_EAX_IB = 1865;
    public static final int M_CS_4EBX_ECX_IB = 1866;
    public static final int M_CS_4EBX_EDX_IB = 1867;
    public static final int M_CS_5EBX_IB = 1868;
    public static final int M_CS_4EBX_ESP_IB = 1869;
    public static final int M_CS_4EBX_EBP_IB = 1870;
    public static final int M_CS_4EBX_ESI_IB = 1871;
    public static final int M_CS_4EBX_EDI_IB = 1872;

    public static final int M_CS_4EBP_EAX_IB = 1873;
    public static final int M_CS_4EBP_ECX_IB = 1874;
    public static final int M_CS_4EBP_EDX_IB = 1875;
    public static final int M_CS_4EBP_EBX_IB = 1876;
    public static final int M_CS_4EBP_ESP_IB = 1877;
    public static final int M_CS_5EBP_IB = 1878;
    public static final int M_CS_4EBP_ESI_IB = 1879;
    public static final int M_CS_4EBP_EDI_IB = 1880;

    public static final int M_CS_4ESI_EAX_IB = 1881;
    public static final int M_CS_4ESI_ECX_IB = 1882;
    public static final int M_CS_4ESI_EDX_IB = 1883;
    public static final int M_CS_4ESI_EBX_IB = 1884;
    public static final int M_CS_4ESI_ESP_IB = 1885;
    public static final int M_CS_4ESI_EBP_IB = 1886;
    public static final int M_CS_5ESI_IB = 1887;
    public static final int M_CS_4ESI_EDI_IB = 1888;

    public static final int M_CS_4EDI_EAX_IB = 1889;
    public static final int M_CS_4EDI_ECX_IB = 1890;
    public static final int M_CS_4EDI_EDX_IB = 1891;
    public static final int M_CS_4EDI_EBX_IB = 1892;
    public static final int M_CS_4EDI_ESP_IB = 1893;
    public static final int M_CS_4EDI_EBP_IB = 1894;
    public static final int M_CS_4EDI_ESI_IB = 1895;
    public static final int M_CS_5EDI_IB = 1896;

    public static final int M_CS_9EAX_IB = 1897;
    public static final int M_CS_8EAX_ECX_IB = 1898;
    public static final int M_CS_8EAX_EDX_IB = 1899;
    public static final int M_CS_8EAX_EBX_IB = 1900;
    public static final int M_CS_8EAX_ESP_IB = 1901;
    public static final int M_CS_8EAX_EBP_IB = 1902;
    public static final int M_CS_8EAX_ESI_IB = 1903;
    public static final int M_CS_8EAX_EDI_IB = 1904;

    public static final int M_CS_8ECX_EAX_IB = 1905;
    public static final int M_CS_9ECX_IB = 1906;
    public static final int M_CS_8ECX_EDX_IB = 1907;
    public static final int M_CS_8ECX_EBX_IB = 1908;
    public static final int M_CS_8ECX_ESP_IB = 1909;
    public static final int M_CS_8ECX_EBP_IB = 1910;
    public static final int M_CS_8ECX_ESI_IB = 1911;
    public static final int M_CS_8ECX_EDI_IB = 1912;

    public static final int M_CS_8EDX_EAX_IB = 1913;
    public static final int M_CS_8EDX_ECX_IB = 1914;
    public static final int M_CS_9EDX_IB = 1915;
    public static final int M_CS_8EDX_EBX_IB = 1916;
    public static final int M_CS_8EDX_ESP_IB = 1917;
    public static final int M_CS_8EDX_EBP_IB = 1918;
    public static final int M_CS_8EDX_ESI_IB = 1919;
    public static final int M_CS_8EDX_EDI_IB = 1920;

    public static final int M_CS_8EBX_EAX_IB = 1921;
    public static final int M_CS_8EBX_ECX_IB = 1922;
    public static final int M_CS_8EBX_EDX_IB = 1923;
    public static final int M_CS_9EBX_IB = 1924;
    public static final int M_CS_8EBX_ESP_IB = 1925;
    public static final int M_CS_8EBX_EBP_IB = 1926;
    public static final int M_CS_8EBX_ESI_IB = 1927;
    public static final int M_CS_8EBX_EDI_IB = 1928;

    public static final int M_CS_8EBP_EAX_IB = 1929;
    public static final int M_CS_8EBP_ECX_IB = 1930;
    public static final int M_CS_8EBP_EDX_IB = 1931;
    public static final int M_CS_8EBP_EBX_IB = 1932;
    public static final int M_CS_8EBP_ESP_IB = 1933;
    public static final int M_CS_9EBP_IB = 1934;
    public static final int M_CS_8EBP_ESI_IB = 1935;
    public static final int M_CS_8EBP_EDI_IB = 1936;

    public static final int M_CS_8ESI_EAX_IB = 1937;
    public static final int M_CS_8ESI_ECX_IB = 1938;
    public static final int M_CS_8ESI_EDX_IB = 1939;
    public static final int M_CS_8ESI_EBX_IB = 1940;
    public static final int M_CS_8ESI_ESP_IB = 1941;
    public static final int M_CS_8ESI_EBP_IB = 1942;
    public static final int M_CS_9ESI_IB = 1943;
    public static final int M_CS_8ESI_EDI_IB = 1944;
    
    public static final int M_CS_8EDI_EAX_IB = 1945;
    public static final int M_CS_8EDI_ECX_IB = 1946;
    public static final int M_CS_8EDI_EDX_IB = 1947;
    public static final int M_CS_8EDI_EBX_IB = 1948;
    public static final int M_CS_8EDI_ESP_IB = 1949;
    public static final int M_CS_8EDI_EBP_IB = 1950;
    public static final int M_CS_8EDI_ESI_IB = 1951;
    public static final int M_CS_9EDI_IB = 1952;

    //SIB + ID Operands
    public static final int M_CS_EAX_ECX_ID = 1953;
    public static final int M_CS_EAX_EDX_ID = 1954;
    public static final int M_CS_EAX_EBX_ID = 1955;
    public static final int M_CS_EAX_ESP_ID = 1956;
    public static final int M_CS_EAX_EBP_ID = 1957;
    public static final int M_CS_EAX_ESI_ID = 1958;
    public static final int M_CS_EAX_EDI_ID = 1959;

    public static final int M_CS_ECX_EDX_ID = 1960;
    public static final int M_CS_ECX_EBX_ID = 1961;
    public static final int M_CS_ECX_ESP_ID = 1962;
    public static final int M_CS_ECX_EBP_ID = 1963;
    public static final int M_CS_ECX_ESI_ID = 1964;
    public static final int M_CS_ECX_EDI_ID = 1965;

    public static final int M_CS_EDX_EBX_ID = 1966;
    public static final int M_CS_EDX_ESP_ID = 1967;
    public static final int M_CS_EDX_EBP_ID = 1968;
    public static final int M_CS_EDX_ESI_ID = 1969;
    public static final int M_CS_EDX_EDI_ID = 1970;

    public static final int M_CS_EBX_ESP_ID = 1971;
    public static final int M_CS_EBX_EBP_ID = 1972;
    public static final int M_CS_EBX_ESI_ID = 1973;
    public static final int M_CS_EBX_EDI_ID = 1974;

    public static final int M_CS_ESP_ID = 1975;

    public static final int M_CS_EBP_ESP_ID = 1976;
    public static final int M_CS_EBP_ESI_ID = 1977;
    public static final int M_CS_EBP_EDI_ID = 1978;

    public static final int M_CS_ESI_ESP_ID = 1979;
    public static final int M_CS_ESI_EDI_ID = 1980;

    public static final int M_CS_EDI_ESP_ID = 1981;

    public static final int M_CS_3EAX_ID = 1982;
    public static final int M_CS_2EAX_ECX_ID = 1983;
    public static final int M_CS_2EAX_EDX_ID = 1984;
    public static final int M_CS_2EAX_EBX_ID = 1985;
    public static final int M_CS_2EAX_ESP_ID = 1986;
    public static final int M_CS_2EAX_EBP_ID = 1987;
    public static final int M_CS_2EAX_ESI_ID = 1988;
    public static final int M_CS_2EAX_EDI_ID = 1989;

    public static final int M_CS_2ECX_EAX_ID = 1990;
    public static final int M_CS_3ECX_ID = 1991;
    public static final int M_CS_2ECX_EDX_ID = 1992;
    public static final int M_CS_2ECX_EBX_ID = 1993;
    public static final int M_CS_2ECX_ESP_ID = 1994;
    public static final int M_CS_2ECX_EBP_ID = 1995;
    public static final int M_CS_2ECX_ESI_ID = 1996;
    public static final int M_CS_2ECX_EDI_ID = 1997;

    public static final int M_CS_2EDX_EAX_ID = 1998;
    public static final int M_CS_2EDX_ECX_ID = 1999;
    public static final int M_CS_3EDX_ID = 2000;
    public static final int M_CS_2EDX_EBX_ID = 2001;
    public static final int M_CS_2EDX_ESP_ID = 2002;
    public static final int M_CS_2EDX_EBP_ID = 2003;
    public static final int M_CS_2EDX_ESI_ID = 2004;
    public static final int M_CS_2EDX_EDI_ID = 2005;

    public static final int M_CS_2EBX_EAX_ID = 2006;
    public static final int M_CS_2EBX_ECX_ID = 2007;
    public static final int M_CS_2EBX_EDX_ID = 2008;
    public static final int M_CS_3EBX_ID = 2009;
    public static final int M_CS_2EBX_ESP_ID = 2010;
    public static final int M_CS_2EBX_EBP_ID = 2011;
    public static final int M_CS_2EBX_ESI_ID = 2012;
    public static final int M_CS_2EBX_EDI_ID = 2013;

    public static final int M_CS_2EBP_EAX_ID = 2014;
    public static final int M_CS_2EBP_ECX_ID = 2015;
    public static final int M_CS_2EBP_EDX_ID = 2016;
    public static final int M_CS_2EBP_EBX_ID = 2017;
    public static final int M_CS_2EBP_ESP_ID = 2018;
    public static final int M_CS_3EBP_ID = 2019;
    public static final int M_CS_2EBP_ESI_ID = 2020;
    public static final int M_CS_2EBP_EDI_ID = 2021;

    public static final int M_CS_2ESI_EAX_ID = 2022;
    public static final int M_CS_2ESI_ECX_ID = 2023;
    public static final int M_CS_2ESI_EDX_ID = 2024;
    public static final int M_CS_2ESI_EBX_ID = 2025;
    public static final int M_CS_2ESI_ESP_ID = 2026;
    public static final int M_CS_2ESI_EBP_ID = 2027;
    public static final int M_CS_3ESI_ID = 2028;
    public static final int M_CS_2ESI_EDI_ID = 2029;

    public static final int M_CS_2EDI_EAX_ID = 2030;
    public static final int M_CS_2EDI_ECX_ID = 2031;
    public static final int M_CS_2EDI_EDX_ID = 2032;
    public static final int M_CS_2EDI_EBX_ID = 2033;
    public static final int M_CS_2EDI_ESP_ID = 2034;
    public static final int M_CS_2EDI_EBP_ID = 2035;
    public static final int M_CS_2EDI_ESI_ID = 2036;
    public static final int M_CS_3EDI_ID = 2037;

    public static final int M_CS_5EAX_ID = 2038;
    public static final int M_CS_4EAX_ECX_ID = 2039;
    public static final int M_CS_4EAX_EDX_ID = 2040;
    public static final int M_CS_4EAX_EBX_ID = 2041;
    public static final int M_CS_4EAX_ESP_ID = 2042;
    public static final int M_CS_4EAX_EBP_ID = 2043;
    public static final int M_CS_4EAX_ESI_ID = 2044;
    public static final int M_CS_4EAX_EDI_ID = 2045;

    public static final int M_CS_4ECX_EAX_ID = 2046;
    public static final int M_CS_5ECX_ID = 2047;
    public static final int M_CS_4ECX_EDX_ID = 2048;
    public static final int M_CS_4ECX_EBX_ID = 2049;
    public static final int M_CS_4ECX_ESP_ID = 2050;
    public static final int M_CS_4ECX_EBP_ID = 2051;
    public static final int M_CS_4ECX_ESI_ID = 2052;
    public static final int M_CS_4ECX_EDI_ID = 2053;

    public static final int M_CS_4EDX_EAX_ID = 2054;
    public static final int M_CS_4EDX_ECX_ID = 2055;
    public static final int M_CS_5EDX_ID = 2056;
    public static final int M_CS_4EDX_EBX_ID = 2057;
    public static final int M_CS_4EDX_ESP_ID = 2058;
    public static final int M_CS_4EDX_EBP_ID = 2059;
    public static final int M_CS_4EDX_ESI_ID = 2060;
    public static final int M_CS_4EDX_EDI_ID = 2061;

    public static final int M_CS_4EBX_EAX_ID = 2062;
    public static final int M_CS_4EBX_ECX_ID = 2063;
    public static final int M_CS_4EBX_EDX_ID = 2064;
    public static final int M_CS_5EBX_ID = 2065;
    public static final int M_CS_4EBX_ESP_ID = 2066;
    public static final int M_CS_4EBX_EBP_ID = 2067;
    public static final int M_CS_4EBX_ESI_ID = 2068;
    public static final int M_CS_4EBX_EDI_ID = 2069;

    public static final int M_CS_4EBP_EAX_ID = 2070;
    public static final int M_CS_4EBP_ECX_ID = 2071;
    public static final int M_CS_4EBP_EDX_ID = 2072;
    public static final int M_CS_4EBP_EBX_ID = 2073;
    public static final int M_CS_4EBP_ESP_ID = 2074;
    public static final int M_CS_5EBP_ID = 2075;
    public static final int M_CS_4EBP_ESI_ID = 2076;
    public static final int M_CS_4EBP_EDI_ID = 2077;

    public static final int M_CS_4ESI_EAX_ID = 2078;
    public static final int M_CS_4ESI_ECX_ID = 2079;
    public static final int M_CS_4ESI_EDX_ID = 2080;
    public static final int M_CS_4ESI_EBX_ID = 2081;
    public static final int M_CS_4ESI_ESP_ID = 2082;
    public static final int M_CS_4ESI_EBP_ID = 2083;
    public static final int M_CS_5ESI_ID = 2084;
    public static final int M_CS_4ESI_EDI_ID = 2085;

    public static final int M_CS_4EDI_EAX_ID = 2086;
    public static final int M_CS_4EDI_ECX_ID = 2087;
    public static final int M_CS_4EDI_EDX_ID = 2088;
    public static final int M_CS_4EDI_EBX_ID = 2089;
    public static final int M_CS_4EDI_ESP_ID = 2090;
    public static final int M_CS_4EDI_EBP_ID = 2091;
    public static final int M_CS_4EDI_ESI_ID = 2092;
    public static final int M_CS_5EDI_ID = 2093;

    public static final int M_CS_9EAX_ID = 2094;
    public static final int M_CS_8EAX_ECX_ID = 2095;
    public static final int M_CS_8EAX_EDX_ID = 2096;
    public static final int M_CS_8EAX_EBX_ID = 2097;
    public static final int M_CS_8EAX_ESP_ID = 2098;
    public static final int M_CS_8EAX_EBP_ID = 2099;
    public static final int M_CS_8EAX_ESI_ID = 2100;
    public static final int M_CS_8EAX_EDI_ID = 2101;

    public static final int M_CS_8ECX_EAX_ID = 2102;
    public static final int M_CS_9ECX_ID = 2103;
    public static final int M_CS_8ECX_EDX_ID = 2104;
    public static final int M_CS_8ECX_EBX_ID = 2105;
    public static final int M_CS_8ECX_ESP_ID = 2106;
    public static final int M_CS_8ECX_EBP_ID = 2107;
    public static final int M_CS_8ECX_ESI_ID = 2108;
    public static final int M_CS_8ECX_EDI_ID = 2109;

    public static final int M_CS_8EDX_EAX_ID = 2110;
    public static final int M_CS_8EDX_ECX_ID = 2111;
    public static final int M_CS_9EDX_ID = 2112;
    public static final int M_CS_8EDX_EBX_ID = 2113;
    public static final int M_CS_8EDX_ESP_ID = 2114;
    public static final int M_CS_8EDX_EBP_ID = 2115;
    public static final int M_CS_8EDX_ESI_ID = 2116;
    public static final int M_CS_8EDX_EDI_ID = 2117;

    public static final int M_CS_8EBX_EAX_ID = 2118;
    public static final int M_CS_8EBX_ECX_ID = 2119;
    public static final int M_CS_8EBX_EDX_ID = 2120;
    public static final int M_CS_9EBX_ID = 2121;
    public static final int M_CS_8EBX_ESP_ID = 2122;
    public static final int M_CS_8EBX_EBP_ID = 2123;
    public static final int M_CS_8EBX_ESI_ID = 2124;
    public static final int M_CS_8EBX_EDI_ID = 2125;

    public static final int M_CS_8EBP_EAX_ID = 2126;
    public static final int M_CS_8EBP_ECX_ID = 2127;
    public static final int M_CS_8EBP_EDX_ID = 2128;
    public static final int M_CS_8EBP_EBX_ID = 2129;
    public static final int M_CS_8EBP_ESP_ID = 2130;
    public static final int M_CS_9EBP_ID = 2131;
    public static final int M_CS_8EBP_ESI_ID = 2132;
    public static final int M_CS_8EBP_EDI_ID = 2133;

    public static final int M_CS_8ESI_EAX_ID = 2134;
    public static final int M_CS_8ESI_ECX_ID = 2135;
    public static final int M_CS_8ESI_EDX_ID = 2136;
    public static final int M_CS_8ESI_EBX_ID = 2137;
    public static final int M_CS_8ESI_ESP_ID = 2138;
    public static final int M_CS_8ESI_EBP_ID = 2139;
    public static final int M_CS_9ESI_ID = 2140;
    public static final int M_CS_8ESI_EDI_ID = 2141;
    
    public static final int M_CS_8EDI_EAX_ID = 2142;
    public static final int M_CS_8EDI_ECX_ID = 2143;
    public static final int M_CS_8EDI_EDX_ID = 2144;
    public static final int M_CS_8EDI_EBX_ID = 2145;
    public static final int M_CS_8EDI_ESP_ID = 2146;
    public static final int M_CS_8EDI_EBP_ID = 2147;
    public static final int M_CS_8EDI_ESI_ID = 2148;
    public static final int M_CS_9EDI_ID = 2149;

    //SIB Operands
    public static final int M_SS_2EAX = 2150;
    public static final int M_SS_EAX_ECX = 2151;
    public static final int M_SS_EAX_EDX = 2152;
    public static final int M_SS_EAX_EBX = 2153;
    public static final int M_SS_EAX_ESP = 2154;
    public static final int M_SS_EAX_EBP = 2155;
    public static final int M_SS_EAX_ESI = 2156;
    public static final int M_SS_EAX_EDI = 2157;

    public static final int M_SS_2ECX = 2158;
    public static final int M_SS_ECX_EDX = 2159;
    public static final int M_SS_ECX_EBX = 2160;
    public static final int M_SS_ECX_ESP = 2161;
    public static final int M_SS_ECX_EBP = 2162;
    public static final int M_SS_ECX_ESI = 2163;
    public static final int M_SS_ECX_EDI = 2164;

    public static final int M_SS_2EDX = 2165;

    public static final int M_SS_EDX_EBX = 2166;
    public static final int M_SS_EDX_ESP = 2167;
    public static final int M_SS_EDX_EBP = 2168;
    public static final int M_SS_EDX_ESI = 2169;
    public static final int M_SS_EDX_EDI = 2170;

    public static final int M_SS_2EBX = 2171;
    public static final int M_SS_EBX_ESP = 2172;
    public static final int M_SS_EBX_EBP = 2173;
    public static final int M_SS_EBX_ESI = 2174;
    public static final int M_SS_EBX_EDI = 2175;

    public static final int M_SS_ESP = 2176;

    public static final int M_SS_EBP_ESP = 2177;
    public static final int M_SS_EBP_ESI = 2178;
    public static final int M_SS_EBP_EDI = 2179;

    public static final int M_SS_ESI_ESP = 2180;
    public static final int M_SS_2ESI = 2181;
    public static final int M_SS_ESI_EDI = 2182;

    public static final int M_SS_EDI_ESP = 2183;
    public static final int M_SS_2EDI = 2184;

    public static final int M_SS_3EAX = 2185;
    public static final int M_SS_2EAX_ECX = 2186;
    public static final int M_SS_2EAX_EDX = 2187;
    public static final int M_SS_2EAX_EBX = 2188;
    public static final int M_SS_2EAX_ESP = 2189;
    public static final int M_SS_2EAX_ID = 2190;
    public static final int M_SS_2EAX_ESI = 2191;
    public static final int M_SS_2EAX_EDI = 2192;

    public static final int M_SS_2ECX_EAX = 2193;
    public static final int M_SS_3ECX = 2194;
    public static final int M_SS_2ECX_EDX = 2195;
    public static final int M_SS_2ECX_EBX = 2196;
    public static final int M_SS_2ECX_ESP = 2197;
    public static final int M_SS_2ECX_ID = 2198;
    public static final int M_SS_2ECX_ESI = 2199;
    public static final int M_SS_2ECX_EDI = 2200;

    public static final int M_SS_2EDX_EAX = 2201;
    public static final int M_SS_2EDX_ECX = 2202;
    public static final int M_SS_3EDX = 2203;
    public static final int M_SS_2EDX_EBX = 2204;
    public static final int M_SS_2EDX_ESP = 2205;
    public static final int M_SS_2EDX_ID = 2206;
    public static final int M_SS_2EDX_ESI = 2207;
    public static final int M_SS_2EDX_EDI = 2208;

    public static final int M_SS_2EBX_EAX = 2209;
    public static final int M_SS_2EBX_ECX = 2210;
    public static final int M_SS_2EBX_EDX = 2211;
    public static final int M_SS_3EBX = 2212;
    public static final int M_SS_2EBX_ESP = 2213;
    public static final int M_SS_2EBX_ID = 2214;
    public static final int M_SS_2EBX_ESI = 2215;
    public static final int M_SS_2EBX_EDI = 2216;

    public static final int M_SS_2EBP_EAX = 2217;
    public static final int M_SS_2EBP_ECX = 2218;
    public static final int M_SS_2EBP_EDX = 2219;
    public static final int M_SS_2EBP_EBX = 2220;
    public static final int M_SS_2EBP_ESP = 2221;
    public static final int M_SS_2EBP_ID = 2222;
    public static final int M_SS_2EBP_ESI = 2223;
    public static final int M_SS_2EBP_EDI = 2224;

    public static final int M_SS_2ESI_EAX = 2225;
    public static final int M_SS_2ESI_ECX = 2226;
    public static final int M_SS_2ESI_EDX = 2227;
    public static final int M_SS_2ESI_EBX = 2228;
    public static final int M_SS_2ESI_ESP = 2229;
    public static final int M_SS_2ESI_ID = 2230;
    public static final int M_SS_3ESI = 2231;
    public static final int M_SS_2ESI_EDI = 2232;

    public static final int M_SS_2EDI_EAX = 2233;
    public static final int M_SS_2EDI_ECX = 2234;
    public static final int M_SS_2EDI_EDX = 2235;
    public static final int M_SS_2EDI_EBX = 2236;
    public static final int M_SS_2EDI_ESP = 2237;
    public static final int M_SS_2EDI_ID = 2238;
    public static final int M_SS_2EDI_ESI = 2239;
    public static final int M_SS_3EDI = 2240;

    public static final int M_SS_5EAX = 2241;
    public static final int M_SS_4EAX_ECX = 2242;
    public static final int M_SS_4EAX_EDX = 2243;
    public static final int M_SS_4EAX_EBX = 2244;
    public static final int M_SS_4EAX_ESP = 2245;
    public static final int M_SS_4EAX_ID = 2246;
    public static final int M_SS_4EAX_ESI = 2247;
    public static final int M_SS_4EAX_EDI = 2248;

    public static final int M_SS_4ECX_EAX = 2249;
    public static final int M_SS_5ECX = 2250;
    public static final int M_SS_4ECX_EDX = 2251;
    public static final int M_SS_4ECX_EBX = 2252;
    public static final int M_SS_4ECX_ESP = 2253;
    public static final int M_SS_4ECX_ID = 2254;
    public static final int M_SS_4ECX_ESI = 2255;
    public static final int M_SS_4ECX_EDI = 2256;

    public static final int M_SS_4EDX_EAX = 2257;
    public static final int M_SS_4EDX_ECX = 2258;
    public static final int M_SS_5EDX = 2259;
    public static final int M_SS_4EDX_EBX = 2260;
    public static final int M_SS_4EDX_ESP = 2261;
    public static final int M_SS_4EDX_ID = 2262;
    public static final int M_SS_4EDX_ESI = 2263;
    public static final int M_SS_4EDX_EDI = 2264;

    public static final int M_SS_4EBX_EAX = 2265;
    public static final int M_SS_4EBX_ECX = 2266;
    public static final int M_SS_4EBX_EDX = 2267;
    public static final int M_SS_5EBX = 2268;
    public static final int M_SS_4EBX_ESP = 2269;
    public static final int M_SS_4EBX_ID = 2270;
    public static final int M_SS_4EBX_ESI = 2271;
    public static final int M_SS_4EBX_EDI = 2272;

    public static final int M_SS_4EBP_EAX = 2273;
    public static final int M_SS_4EBP_ECX = 2274;
    public static final int M_SS_4EBP_EDX = 2275;
    public static final int M_SS_4EBP_EBX = 2276;
    public static final int M_SS_4EBP_ESP = 2277;
    public static final int M_SS_4EBP_ID = 2278;
    public static final int M_SS_4EBP_ESI = 2279;
    public static final int M_SS_4EBP_EDI = 2280;

    public static final int M_SS_4ESI_EAX = 2281;
    public static final int M_SS_4ESI_ECX = 2282;
    public static final int M_SS_4ESI_EDX = 2283;
    public static final int M_SS_4ESI_EBX = 2284;
    public static final int M_SS_4ESI_ESP = 2285;
    public static final int M_SS_4ESI_ID = 2286;
    public static final int M_SS_5ESI = 2287;
    public static final int M_SS_4ESI_EDI = 2288;

    public static final int M_SS_4EDI_EAX = 2289;
    public static final int M_SS_4EDI_ECX = 2290;
    public static final int M_SS_4EDI_EDX = 2291;
    public static final int M_SS_4EDI_EBX = 2292;
    public static final int M_SS_4EDI_ESP = 2293;
    public static final int M_SS_4EDI_ID = 2294;
    public static final int M_SS_4EDI_ESI = 2295;
    public static final int M_SS_5EDI = 2296;

    public static final int M_SS_9EAX = 2297;
    public static final int M_SS_8EAX_ECX = 2298;
    public static final int M_SS_8EAX_EDX = 2299;
    public static final int M_SS_8EAX_EBX = 2300;
    public static final int M_SS_8EAX_ESP = 2301;
    public static final int M_SS_8EAX_ID = 2302;
    public static final int M_SS_8EAX_ESI = 2303;
    public static final int M_SS_8EAX_EDI = 2304;

    public static final int M_SS_8ECX_EAX = 2305;
    public static final int M_SS_9ECX = 2306;
    public static final int M_SS_8ECX_EDX = 2307;
    public static final int M_SS_8ECX_EBX = 2308;
    public static final int M_SS_8ECX_ESP = 2309;
    public static final int M_SS_8ECX_ID = 2310;
    public static final int M_SS_8ECX_ESI = 2311;
    public static final int M_SS_8ECX_EDI = 2312;

    public static final int M_SS_8EDX_EAX = 2313;
    public static final int M_SS_8EDX_ECX = 2314;
    public static final int M_SS_9EDX = 2315;
    public static final int M_SS_8EDX_EBX = 2316;
    public static final int M_SS_8EDX_ESP = 2317;
    public static final int M_SS_8EDX_ID = 2318;
    public static final int M_SS_8EDX_ESI = 2319;
    public static final int M_SS_8EDX_EDI = 2320;

    public static final int M_SS_8EBX_EAX = 2321;
    public static final int M_SS_8EBX_ECX = 2322;
    public static final int M_SS_8EBX_EDX = 2323;
    public static final int M_SS_9EBX = 2324;
    public static final int M_SS_8EBX_ESP = 2325;
    public static final int M_SS_8EBX_ID = 2326;
    public static final int M_SS_8EBX_ESI = 2327;
    public static final int M_SS_8EBX_EDI = 2328;

    public static final int M_SS_8EBP_EAX = 2329;
    public static final int M_SS_8EBP_ECX = 2330;
    public static final int M_SS_8EBP_EDX = 2331;
    public static final int M_SS_8EBP_EBX = 2332;
    public static final int M_SS_8EBP_ESP = 2333;
    public static final int M_SS_8EBP_ID = 2334;
    public static final int M_SS_8EBP_ESI = 2335;
    public static final int M_SS_8EBP_EDI = 2336;

    public static final int M_SS_8ESI_EAX = 2337;
    public static final int M_SS_8ESI_ECX = 2338;
    public static final int M_SS_8ESI_EDX = 2339;
    public static final int M_SS_8ESI_EBX = 2340;
    public static final int M_SS_8ESI_ESP = 2341;
    public static final int M_SS_8ESI_ID = 2342;
    public static final int M_SS_9ESI = 2343;
    public static final int M_SS_8ESI_EDI = 2344;
    
    public static final int M_SS_8EDI_EAX = 2345;
    public static final int M_SS_8EDI_ECX = 2346;
    public static final int M_SS_8EDI_EDX = 2347;
    public static final int M_SS_8EDI_EBX = 2348;
    public static final int M_SS_8EDI_ESP = 2349;
    public static final int M_SS_8EDI_ID = 2350;
    public static final int M_SS_8EDI_ESI = 2351;
    public static final int M_SS_9EDI = 2352;

    //SIB + IB Operands
    public static final int M_SS_2EAX_IB = 2353;
    public static final int M_SS_EAX_ECX_IB = 2354;
    public static final int M_SS_EAX_EDX_IB = 2355;
    public static final int M_SS_EAX_EBX_IB = 2356;
    public static final int M_SS_EAX_ESP_IB = 2357;
    public static final int M_SS_EAX_EBP_IB = 2358;
    public static final int M_SS_EAX_ESI_IB = 2359;
    public static final int M_SS_EAX_EDI_IB = 2360;

    public static final int M_SS_2ECX_IB = 2361;
    public static final int M_SS_ECX_EDX_IB = 2362;
    public static final int M_SS_ECX_EBX_IB = 2363;
    public static final int M_SS_ECX_ESP_IB = 2364;
    public static final int M_SS_ECX_EBP_IB = 2365;
    public static final int M_SS_ECX_ESI_IB = 2366;
    public static final int M_SS_ECX_EDI_IB = 2367;

    public static final int M_SS_2EDX_IB = 2368;
    public static final int M_SS_EDX_EBX_IB = 2369;
    public static final int M_SS_EDX_ESP_IB = 2370;
    public static final int M_SS_EDX_EBP_IB = 2371;
    public static final int M_SS_EDX_ESI_IB = 2372;
    public static final int M_SS_EDX_EDI_IB = 2373;

    public static final int M_SS_2EBX_IB = 2374;
    public static final int M_SS_EBX_ESP_IB = 2375;
    public static final int M_SS_EBX_EBP_IB = 2376;
    public static final int M_SS_EBX_ESI_IB = 2377;
    public static final int M_SS_EBX_EDI_IB = 2378;

    public static final int M_SS_ESP_IB = 2379;

    public static final int M_SS_EBP_ESP_IB = 2380;
    public static final int M_SS_2EBP_IB = 2381;
    public static final int M_SS_EBP_ESI_IB = 2382;
    public static final int M_SS_EBP_EDI_IB = 2383;

    public static final int M_SS_ESI_ESP_IB = 2384;
    public static final int M_SS_2ESI_IB = 2385;
    public static final int M_SS_ESI_EDI_IB = 2386;

    public static final int M_SS_EDI_ESP_IB = 2387;
    public static final int M_SS_2EDI_IB = 2388;

    public static final int M_SS_3EAX_IB = 2389;
    public static final int M_SS_2EAX_ECX_IB = 2390;
    public static final int M_SS_2EAX_EDX_IB = 2391;
    public static final int M_SS_2EAX_EBX_IB = 2392;
    public static final int M_SS_2EAX_ESP_IB = 2393;
    public static final int M_SS_2EAX_EBP_IB = 2394;
    public static final int M_SS_2EAX_ESI_IB = 2395;
    public static final int M_SS_2EAX_EDI_IB = 2396;

    public static final int M_SS_2ECX_EAX_IB = 2397;
    public static final int M_SS_3ECX_IB = 2398;
    public static final int M_SS_2ECX_EDX_IB = 2399;
    public static final int M_SS_2ECX_EBX_IB = 2400;
    public static final int M_SS_2ECX_ESP_IB = 2401;
    public static final int M_SS_2ECX_EBP_IB = 2402;
    public static final int M_SS_2ECX_ESI_IB = 2403;
    public static final int M_SS_2ECX_EDI_IB = 2404;

    public static final int M_SS_2EDX_EAX_IB = 2405;
    public static final int M_SS_2EDX_ECX_IB = 2406;
    public static final int M_SS_3EDX_IB = 2407;
    public static final int M_SS_2EDX_EBX_IB = 2408;
    public static final int M_SS_2EDX_ESP_IB = 2409;
    public static final int M_SS_2EDX_EBP_IB = 2410;
    public static final int M_SS_2EDX_ESI_IB = 2411;
    public static final int M_SS_2EDX_EDI_IB = 2412;

    public static final int M_SS_2EBX_EAX_IB = 2413;
    public static final int M_SS_2EBX_ECX_IB = 2414;
    public static final int M_SS_2EBX_EDX_IB = 2415;
    public static final int M_SS_3EBX_IB = 2416;
    public static final int M_SS_2EBX_ESP_IB = 2417;
    public static final int M_SS_2EBX_EBP_IB = 2418;
    public static final int M_SS_2EBX_ESI_IB = 2419;
    public static final int M_SS_2EBX_EDI_IB = 2420;

    public static final int M_SS_2EBP_EAX_IB = 2421;
    public static final int M_SS_2EBP_ECX_IB = 2422;
    public static final int M_SS_2EBP_EDX_IB = 2423;
    public static final int M_SS_2EBP_EBX_IB = 2424;
    public static final int M_SS_2EBP_ESP_IB = 2425;
    public static final int M_SS_3EBP_IB = 2426;
    public static final int M_SS_2EBP_ESI_IB = 2427;
    public static final int M_SS_2EBP_EDI_IB = 2428;

    public static final int M_SS_2ESI_EAX_IB = 2429;
    public static final int M_SS_2ESI_ECX_IB = 2430;
    public static final int M_SS_2ESI_EDX_IB = 2431;
    public static final int M_SS_2ESI_EBX_IB = 2432;
    public static final int M_SS_2ESI_ESP_IB = 2433;
    public static final int M_SS_2ESI_EBP_IB = 2434;
    public static final int M_SS_3ESI_IB = 2435;
    public static final int M_SS_2ESI_EDI_IB = 2436;

    public static final int M_SS_2EDI_EAX_IB = 2437;
    public static final int M_SS_2EDI_ECX_IB = 2438;
    public static final int M_SS_2EDI_EDX_IB = 2439;
    public static final int M_SS_2EDI_EBX_IB = 2440;
    public static final int M_SS_2EDI_ESP_IB = 2441;
    public static final int M_SS_2EDI_EBP_IB = 2442;
    public static final int M_SS_2EDI_ESI_IB = 2443;
    public static final int M_SS_3EDI_IB = 2444;

    public static final int M_SS_5EAX_IB = 2445;
    public static final int M_SS_4EAX_ECX_IB = 2446;
    public static final int M_SS_4EAX_EDX_IB = 2447;
    public static final int M_SS_4EAX_EBX_IB = 2448;
    public static final int M_SS_4EAX_ESP_IB = 2449;
    public static final int M_SS_4EAX_EBP_IB = 2450;
    public static final int M_SS_4EAX_ESI_IB = 2451;
    public static final int M_SS_4EAX_EDI_IB = 2452;

    public static final int M_SS_4ECX_EAX_IB = 2453;
    public static final int M_SS_5ECX_IB = 2454;
    public static final int M_SS_4ECX_EDX_IB = 2455;
    public static final int M_SS_4ECX_EBX_IB = 2456;
    public static final int M_SS_4ECX_ESP_IB = 2457;
    public static final int M_SS_4ECX_EBP_IB = 2458;
    public static final int M_SS_4ECX_ESI_IB = 2459;
    public static final int M_SS_4ECX_EDI_IB = 2460;

    public static final int M_SS_4EDX_EAX_IB = 2461;
    public static final int M_SS_4EDX_ECX_IB = 2462;
    public static final int M_SS_5EDX_IB = 2463;
    public static final int M_SS_4EDX_EBX_IB = 2464;
    public static final int M_SS_4EDX_ESP_IB = 2465;
    public static final int M_SS_4EDX_EBP_IB = 2466;
    public static final int M_SS_4EDX_ESI_IB = 2467;
    public static final int M_SS_4EDX_EDI_IB = 2468;

    public static final int M_SS_4EBX_EAX_IB = 2469;
    public static final int M_SS_4EBX_ECX_IB = 2470;
    public static final int M_SS_4EBX_EDX_IB = 2471;
    public static final int M_SS_5EBX_IB = 2472;
    public static final int M_SS_4EBX_ESP_IB = 2473;
    public static final int M_SS_4EBX_EBP_IB = 2474;
    public static final int M_SS_4EBX_ESI_IB = 2475;
    public static final int M_SS_4EBX_EDI_IB = 2476;

    public static final int M_SS_4EBP_EAX_IB = 2477;
    public static final int M_SS_4EBP_ECX_IB = 2478;
    public static final int M_SS_4EBP_EDX_IB = 2479;
    public static final int M_SS_4EBP_EBX_IB = 2480;
    public static final int M_SS_4EBP_ESP_IB = 2481;
    public static final int M_SS_5EBP_IB = 2482;
    public static final int M_SS_4EBP_ESI_IB = 2483;
    public static final int M_SS_4EBP_EDI_IB = 2484;

    public static final int M_SS_4ESI_EAX_IB = 2485;
    public static final int M_SS_4ESI_ECX_IB = 2486;
    public static final int M_SS_4ESI_EDX_IB = 2487;
    public static final int M_SS_4ESI_EBX_IB = 2488;
    public static final int M_SS_4ESI_ESP_IB = 2489;
    public static final int M_SS_4ESI_EBP_IB = 2490;
    public static final int M_SS_5ESI_IB = 2491;
    public static final int M_SS_4ESI_EDI_IB = 2492;

    public static final int M_SS_4EDI_EAX_IB = 2493;
    public static final int M_SS_4EDI_ECX_IB = 2494;
    public static final int M_SS_4EDI_EDX_IB = 2495;
    public static final int M_SS_4EDI_EBX_IB = 2496;
    public static final int M_SS_4EDI_ESP_IB = 2497;
    public static final int M_SS_4EDI_EBP_IB = 2498;
    public static final int M_SS_4EDI_ESI_IB = 2499;
    public static final int M_SS_5EDI_IB = 2500;

    public static final int M_SS_9EAX_IB = 2501;
    public static final int M_SS_8EAX_ECX_IB = 2502;
    public static final int M_SS_8EAX_EDX_IB = 2503;
    public static final int M_SS_8EAX_EBX_IB = 2504;
    public static final int M_SS_8EAX_ESP_IB = 2505;
    public static final int M_SS_8EAX_EBP_IB = 2506;
    public static final int M_SS_8EAX_ESI_IB = 2507;
    public static final int M_SS_8EAX_EDI_IB = 2508;

    public static final int M_SS_8ECX_EAX_IB = 2509;
    public static final int M_SS_9ECX_IB = 2510;
    public static final int M_SS_8ECX_EDX_IB = 2511;
    public static final int M_SS_8ECX_EBX_IB = 2512;
    public static final int M_SS_8ECX_ESP_IB = 2513;
    public static final int M_SS_8ECX_EBP_IB = 2514;
    public static final int M_SS_8ECX_ESI_IB = 2515;
    public static final int M_SS_8ECX_EDI_IB = 2516;

    public static final int M_SS_8EDX_EAX_IB = 2517;
    public static final int M_SS_8EDX_ECX_IB = 2518;
    public static final int M_SS_9EDX_IB = 2519;
    public static final int M_SS_8EDX_EBX_IB = 2520;
    public static final int M_SS_8EDX_ESP_IB = 2521;
    public static final int M_SS_8EDX_EBP_IB = 2522;
    public static final int M_SS_8EDX_ESI_IB = 2523;
    public static final int M_SS_8EDX_EDI_IB = 2524;

    public static final int M_SS_8EBX_EAX_IB = 2525;
    public static final int M_SS_8EBX_ECX_IB = 2526;
    public static final int M_SS_8EBX_EDX_IB = 2527;
    public static final int M_SS_9EBX_IB = 2528;
    public static final int M_SS_8EBX_ESP_IB = 2529;
    public static final int M_SS_8EBX_EBP_IB = 2530;
    public static final int M_SS_8EBX_ESI_IB = 2531;
    public static final int M_SS_8EBX_EDI_IB = 2532;

    public static final int M_SS_8EBP_EAX_IB = 2533;
    public static final int M_SS_8EBP_ECX_IB = 2534;
    public static final int M_SS_8EBP_EDX_IB = 2535;
    public static final int M_SS_8EBP_EBX_IB = 2536;
    public static final int M_SS_8EBP_ESP_IB = 2537;
    public static final int M_SS_9EBP_IB = 2538;
    public static final int M_SS_8EBP_ESI_IB = 2539;
    public static final int M_SS_8EBP_EDI_IB = 2540;

    public static final int M_SS_8ESI_EAX_IB = 2541;
    public static final int M_SS_8ESI_ECX_IB = 2542;
    public static final int M_SS_8ESI_EDX_IB = 2543;
    public static final int M_SS_8ESI_EBX_IB = 2544;
    public static final int M_SS_8ESI_ESP_IB = 2545;
    public static final int M_SS_8ESI_EBP_IB = 2546;
    public static final int M_SS_9ESI_IB = 2547;
    public static final int M_SS_8ESI_EDI_IB = 2548;
    
    public static final int M_SS_8EDI_EAX_IB = 2549;
    public static final int M_SS_8EDI_ECX_IB = 2550;
    public static final int M_SS_8EDI_EDX_IB = 2551;
    public static final int M_SS_8EDI_EBX_IB = 2552;
    public static final int M_SS_8EDI_ESP_IB = 2553;
    public static final int M_SS_8EDI_EBP_IB = 2554;
    public static final int M_SS_8EDI_ESI_IB = 2555;
    public static final int M_SS_9EDI_IB = 2556;

    //SIB + ID Operands
    public static final int M_SS_EAX_ECX_ID = 2557;
    public static final int M_SS_EAX_EDX_ID = 2558;
    public static final int M_SS_EAX_EBX_ID = 2559;
    public static final int M_SS_EAX_ESP_ID = 2560;
    public static final int M_SS_EAX_EBP_ID = 2561;
    public static final int M_SS_EAX_ESI_ID = 2562;
    public static final int M_SS_EAX_EDI_ID = 2563;

    public static final int M_SS_ECX_EDX_ID = 2564;
    public static final int M_SS_ECX_EBX_ID = 2565;
    public static final int M_SS_ECX_ESP_ID = 2566;
    public static final int M_SS_ECX_EBP_ID = 2567;
    public static final int M_SS_ECX_ESI_ID = 2568;
    public static final int M_SS_ECX_EDI_ID = 2569;

    public static final int M_SS_EDX_EBX_ID = 2570;
    public static final int M_SS_EDX_ESP_ID = 2571;
    public static final int M_SS_EDX_EBP_ID = 2572;
    public static final int M_SS_EDX_ESI_ID = 2573;
    public static final int M_SS_EDX_EDI_ID = 2574;

    public static final int M_SS_EBX_ESP_ID = 2575;
    public static final int M_SS_EBX_EBP_ID = 2576;
    public static final int M_SS_EBX_ESI_ID = 2577;
    public static final int M_SS_EBX_EDI_ID = 2578;

    public static final int M_SS_ESP_ID = 2579;

    public static final int M_SS_EBP_ESP_ID = 2580;
    public static final int M_SS_EBP_ESI_ID = 2581;
    public static final int M_SS_EBP_EDI_ID = 2582;

    public static final int M_SS_ESI_ESP_ID = 2583;
    public static final int M_SS_ESI_EDI_ID = 2584;

    public static final int M_SS_EDI_ESP_ID = 2585;

    public static final int M_SS_3EAX_ID = 2586;
    public static final int M_SS_2EAX_ECX_ID = 2587;
    public static final int M_SS_2EAX_EDX_ID = 2588;
    public static final int M_SS_2EAX_EBX_ID = 2589;
    public static final int M_SS_2EAX_ESP_ID = 2590;
    public static final int M_SS_2EAX_EBP_ID = 2591;
    public static final int M_SS_2EAX_ESI_ID = 2592;
    public static final int M_SS_2EAX_EDI_ID = 2593;

    public static final int M_SS_2ECX_EAX_ID = 2594;
    public static final int M_SS_3ECX_ID = 2595;
    public static final int M_SS_2ECX_EDX_ID = 2596;
    public static final int M_SS_2ECX_EBX_ID = 2597;
    public static final int M_SS_2ECX_ESP_ID = 2598;
    public static final int M_SS_2ECX_EBP_ID = 2599;
    public static final int M_SS_2ECX_ESI_ID = 2600;
    public static final int M_SS_2ECX_EDI_ID = 2601;

    public static final int M_SS_2EDX_EAX_ID = 2602;
    public static final int M_SS_2EDX_ECX_ID = 2603;
    public static final int M_SS_3EDX_ID = 2604;
    public static final int M_SS_2EDX_EBX_ID = 2605;
    public static final int M_SS_2EDX_ESP_ID = 2606;
    public static final int M_SS_2EDX_EBP_ID = 2607;
    public static final int M_SS_2EDX_ESI_ID = 2608;
    public static final int M_SS_2EDX_EDI_ID = 2609;

    public static final int M_SS_2EBX_EAX_ID = 2610;
    public static final int M_SS_2EBX_ECX_ID = 2611;
    public static final int M_SS_2EBX_EDX_ID = 2612;
    public static final int M_SS_3EBX_ID = 2613;
    public static final int M_SS_2EBX_ESP_ID = 2614;
    public static final int M_SS_2EBX_EBP_ID = 2615;
    public static final int M_SS_2EBX_ESI_ID = 2616;
    public static final int M_SS_2EBX_EDI_ID = 2617;

    public static final int M_SS_2EBP_EAX_ID = 2618;
    public static final int M_SS_2EBP_ECX_ID = 2619;
    public static final int M_SS_2EBP_EDX_ID = 2620;
    public static final int M_SS_2EBP_EBX_ID = 2621;
    public static final int M_SS_2EBP_ESP_ID = 2622;
    public static final int M_SS_3EBP_ID = 2623;
    public static final int M_SS_2EBP_ESI_ID = 2624;
    public static final int M_SS_2EBP_EDI_ID = 2625;

    public static final int M_SS_2ESI_EAX_ID = 2626;
    public static final int M_SS_2ESI_ECX_ID = 2627;
    public static final int M_SS_2ESI_EDX_ID = 2628;
    public static final int M_SS_2ESI_EBX_ID = 2629;
    public static final int M_SS_2ESI_ESP_ID = 2630;
    public static final int M_SS_2ESI_EBP_ID = 2631;
    public static final int M_SS_3ESI_ID = 2632;
    public static final int M_SS_2ESI_EDI_ID = 2633;

    public static final int M_SS_2EDI_EAX_ID = 2634;
    public static final int M_SS_2EDI_ECX_ID = 2635;
    public static final int M_SS_2EDI_EDX_ID = 2636;
    public static final int M_SS_2EDI_EBX_ID = 2637;
    public static final int M_SS_2EDI_ESP_ID = 2638;
    public static final int M_SS_2EDI_EBP_ID = 2639;
    public static final int M_SS_2EDI_ESI_ID = 2640;
    public static final int M_SS_3EDI_ID = 2641;

    public static final int M_SS_5EAX_ID = 2642;
    public static final int M_SS_4EAX_ECX_ID = 2643;
    public static final int M_SS_4EAX_EDX_ID = 2644;
    public static final int M_SS_4EAX_EBX_ID = 2645;
    public static final int M_SS_4EAX_ESP_ID = 2646;
    public static final int M_SS_4EAX_EBP_ID = 2647;
    public static final int M_SS_4EAX_ESI_ID = 2648;
    public static final int M_SS_4EAX_EDI_ID = 2649;

    public static final int M_SS_4ECX_EAX_ID = 2650;
    public static final int M_SS_5ECX_ID = 2651;
    public static final int M_SS_4ECX_EDX_ID = 2652;
    public static final int M_SS_4ECX_EBX_ID = 2653;
    public static final int M_SS_4ECX_ESP_ID = 2654;
    public static final int M_SS_4ECX_EBP_ID = 2655;
    public static final int M_SS_4ECX_ESI_ID = 2656;
    public static final int M_SS_4ECX_EDI_ID = 2657;

    public static final int M_SS_4EDX_EAX_ID = 2658;
    public static final int M_SS_4EDX_ECX_ID = 2659;
    public static final int M_SS_5EDX_ID = 2660;
    public static final int M_SS_4EDX_EBX_ID = 2661;
    public static final int M_SS_4EDX_ESP_ID = 2662;
    public static final int M_SS_4EDX_EBP_ID = 2663;
    public static final int M_SS_4EDX_ESI_ID = 2664;
    public static final int M_SS_4EDX_EDI_ID = 2665;

    public static final int M_SS_4EBX_EAX_ID = 2666;
    public static final int M_SS_4EBX_ECX_ID = 2667;
    public static final int M_SS_4EBX_EDX_ID = 2668;
    public static final int M_SS_5EBX_ID = 2669;
    public static final int M_SS_4EBX_ESP_ID = 2670;
    public static final int M_SS_4EBX_EBP_ID = 2671;
    public static final int M_SS_4EBX_ESI_ID = 2672;
    public static final int M_SS_4EBX_EDI_ID = 2673;

    public static final int M_SS_4EBP_EAX_ID = 2674;
    public static final int M_SS_4EBP_ECX_ID = 2675;
    public static final int M_SS_4EBP_EDX_ID = 2676;
    public static final int M_SS_4EBP_EBX_ID = 2677;
    public static final int M_SS_4EBP_ESP_ID = 2678;
    public static final int M_SS_5EBP_ID = 2679;
    public static final int M_SS_4EBP_ESI_ID = 2680;
    public static final int M_SS_4EBP_EDI_ID = 2681;

    public static final int M_SS_4ESI_EAX_ID = 2682;
    public static final int M_SS_4ESI_ECX_ID = 2683;
    public static final int M_SS_4ESI_EDX_ID = 2684;
    public static final int M_SS_4ESI_EBX_ID = 2685;
    public static final int M_SS_4ESI_ESP_ID = 2686;
    public static final int M_SS_4ESI_EBP_ID = 2687;
    public static final int M_SS_5ESI_ID = 2688;
    public static final int M_SS_4ESI_EDI_ID = 2689;

    public static final int M_SS_4EDI_EAX_ID = 2690;
    public static final int M_SS_4EDI_ECX_ID = 2691;
    public static final int M_SS_4EDI_EDX_ID = 2692;
    public static final int M_SS_4EDI_EBX_ID = 2693;
    public static final int M_SS_4EDI_ESP_ID = 2694;
    public static final int M_SS_4EDI_EBP_ID = 2695;
    public static final int M_SS_4EDI_ESI_ID = 2696;
    public static final int M_SS_5EDI_ID = 2697;

    public static final int M_SS_9EAX_ID = 2698;
    public static final int M_SS_8EAX_ECX_ID = 2699;
    public static final int M_SS_8EAX_EDX_ID = 2700;
    public static final int M_SS_8EAX_EBX_ID = 2701;
    public static final int M_SS_8EAX_ESP_ID = 2702;
    public static final int M_SS_8EAX_EBP_ID = 2703;
    public static final int M_SS_8EAX_ESI_ID = 2704;
    public static final int M_SS_8EAX_EDI_ID = 2705;

    public static final int M_SS_8ECX_EAX_ID = 2706;
    public static final int M_SS_9ECX_ID = 2707;
    public static final int M_SS_8ECX_EDX_ID = 2708;
    public static final int M_SS_8ECX_EBX_ID = 2709;
    public static final int M_SS_8ECX_ESP_ID = 2710;
    public static final int M_SS_8ECX_EBP_ID = 2711;
    public static final int M_SS_8ECX_ESI_ID = 2712;
    public static final int M_SS_8ECX_EDI_ID = 2713;

    public static final int M_SS_8EDX_EAX_ID = 2714;
    public static final int M_SS_8EDX_ECX_ID = 2715;
    public static final int M_SS_9EDX_ID = 2716;
    public static final int M_SS_8EDX_EBX_ID = 2717;
    public static final int M_SS_8EDX_ESP_ID = 2718;
    public static final int M_SS_8EDX_EBP_ID = 2719;
    public static final int M_SS_8EDX_ESI_ID = 2720;
    public static final int M_SS_8EDX_EDI_ID = 2721;

    public static final int M_SS_8EBX_EAX_ID = 2722;
    public static final int M_SS_8EBX_ECX_ID = 2723;
    public static final int M_SS_8EBX_EDX_ID = 2724;
    public static final int M_SS_9EBX_ID = 2725;
    public static final int M_SS_8EBX_ESP_ID = 2726;
    public static final int M_SS_8EBX_EBP_ID = 2727;
    public static final int M_SS_8EBX_ESI_ID = 2728;
    public static final int M_SS_8EBX_EDI_ID = 2729;

    public static final int M_SS_8EBP_EAX_ID = 2730;
    public static final int M_SS_8EBP_ECX_ID = 2731;
    public static final int M_SS_8EBP_EDX_ID = 2732;
    public static final int M_SS_8EBP_EBX_ID = 2733;
    public static final int M_SS_8EBP_ESP_ID = 2734;
    public static final int M_SS_9EBP_ID = 2735;
    public static final int M_SS_8EBP_ESI_ID = 2736;
    public static final int M_SS_8EBP_EDI_ID = 2737;

    public static final int M_SS_8ESI_EAX_ID = 2738;
    public static final int M_SS_8ESI_ECX_ID = 2739;
    public static final int M_SS_8ESI_EDX_ID = 2740;
    public static final int M_SS_8ESI_EBX_ID = 2741;
    public static final int M_SS_8ESI_ESP_ID = 2742;
    public static final int M_SS_8ESI_EBP_ID = 2743;
    public static final int M_SS_9ESI_ID = 2744;
    public static final int M_SS_8ESI_EDI_ID = 2745;
    
    public static final int M_SS_8EDI_EAX_ID = 2746;
    public static final int M_SS_8EDI_ECX_ID = 2747;
    public static final int M_SS_8EDI_EDX_ID = 2748;
    public static final int M_SS_8EDI_EBX_ID = 2749;
    public static final int M_SS_8EDI_ESP_ID = 2750;
    public static final int M_SS_8EDI_EBP_ID = 2751;
    public static final int M_SS_8EDI_ESI_ID = 2752;
    public static final int M_SS_9EDI_ID = 2753;

    //SIB Operands
    public static final int M_FS_2EAX = 2754;
    public static final int M_FS_EAX_ECX = 2755;
    public static final int M_FS_EAX_EDX = 2756;
    public static final int M_FS_EAX_EBX = 2757;
    public static final int M_FS_EAX_ESP = 2758;
    public static final int M_FS_EAX_EBP = 2759;
    public static final int M_FS_EAX_ESI = 2760;
    public static final int M_FS_EAX_EDI = 2761;

    public static final int M_FS_2ECX = 2762;
    public static final int M_FS_ECX_EDX = 2763;
    public static final int M_FS_ECX_EBX = 2764;
    public static final int M_FS_ECX_ESP = 2765;
    public static final int M_FS_ECX_EBP = 2766;
    public static final int M_FS_ECX_ESI = 2767;
    public static final int M_FS_ECX_EDI = 2768;

    public static final int M_FS_2EDX = 2769;

    public static final int M_FS_EDX_EBX = 2770;
    public static final int M_FS_EDX_ESP = 2771;
    public static final int M_FS_EDX_EBP = 2772;
    public static final int M_FS_EDX_ESI = 2773;
    public static final int M_FS_EDX_EDI = 2774;

    public static final int M_FS_2EBX = 2775;
    public static final int M_FS_EBX_ESP = 2776;
    public static final int M_FS_EBX_EBP = 2777;
    public static final int M_FS_EBX_ESI = 2778;
    public static final int M_FS_EBX_EDI = 2779;

    public static final int M_FS_ESP = 2780;

    public static final int M_FS_EBP_ESP = 2781;
    public static final int M_FS_EBP_ESI = 2782;
    public static final int M_FS_EBP_EDI = 2783;

    public static final int M_FS_ESI_ESP = 2784;
    public static final int M_FS_2ESI = 2785;
    public static final int M_FS_ESI_EDI = 2786;

    public static final int M_FS_EDI_ESP = 2787;
    public static final int M_FS_2EDI = 2788;

    public static final int M_FS_3EAX = 2789;
    public static final int M_FS_2EAX_ECX = 2790;
    public static final int M_FS_2EAX_EDX = 2791;
    public static final int M_FS_2EAX_EBX = 2792;
    public static final int M_FS_2EAX_ESP = 2793;
    public static final int M_FS_2EAX_ID = 2794;
    public static final int M_FS_2EAX_ESI = 2795;
    public static final int M_FS_2EAX_EDI = 2796;

    public static final int M_FS_2ECX_EAX = 2797;
    public static final int M_FS_3ECX = 2798;
    public static final int M_FS_2ECX_EDX = 2799;
    public static final int M_FS_2ECX_EBX = 2800;
    public static final int M_FS_2ECX_ESP = 2801;
    public static final int M_FS_2ECX_ID = 2802;
    public static final int M_FS_2ECX_ESI = 2803;
    public static final int M_FS_2ECX_EDI = 2804;

    public static final int M_FS_2EDX_EAX = 2805;
    public static final int M_FS_2EDX_ECX = 2806;
    public static final int M_FS_3EDX = 2807;
    public static final int M_FS_2EDX_EBX = 2808;
    public static final int M_FS_2EDX_ESP = 2809;
    public static final int M_FS_2EDX_ID = 2810;
    public static final int M_FS_2EDX_ESI = 2811;
    public static final int M_FS_2EDX_EDI = 2812;

    public static final int M_FS_2EBX_EAX = 2813;
    public static final int M_FS_2EBX_ECX = 2814;
    public static final int M_FS_2EBX_EDX = 2815;
    public static final int M_FS_3EBX = 2816;
    public static final int M_FS_2EBX_ESP = 2817;
    public static final int M_FS_2EBX_ID = 2818;
    public static final int M_FS_2EBX_ESI = 2819;
    public static final int M_FS_2EBX_EDI = 2820;

    public static final int M_FS_2EBP_EAX = 2821;
    public static final int M_FS_2EBP_ECX = 2822;
    public static final int M_FS_2EBP_EDX = 2823;
    public static final int M_FS_2EBP_EBX = 2824;
    public static final int M_FS_2EBP_ESP = 2825;
    public static final int M_FS_2EBP_ID = 2826;
    public static final int M_FS_2EBP_ESI = 2827;
    public static final int M_FS_2EBP_EDI = 2828;

    public static final int M_FS_2ESI_EAX = 2829;
    public static final int M_FS_2ESI_ECX = 2830;
    public static final int M_FS_2ESI_EDX = 2831;
    public static final int M_FS_2ESI_EBX = 2832;
    public static final int M_FS_2ESI_ESP = 2833;
    public static final int M_FS_2ESI_ID = 2834;
    public static final int M_FS_3ESI = 2835;
    public static final int M_FS_2ESI_EDI = 2836;

    public static final int M_FS_2EDI_EAX = 2837;
    public static final int M_FS_2EDI_ECX = 2838;
    public static final int M_FS_2EDI_EDX = 2839;
    public static final int M_FS_2EDI_EBX = 2840;
    public static final int M_FS_2EDI_ESP = 2841;
    public static final int M_FS_2EDI_ID = 2842;
    public static final int M_FS_2EDI_ESI = 2843;
    public static final int M_FS_3EDI = 2844;

    public static final int M_FS_5EAX = 2845;
    public static final int M_FS_4EAX_ECX = 2846;
    public static final int M_FS_4EAX_EDX = 2847;
    public static final int M_FS_4EAX_EBX = 2848;
    public static final int M_FS_4EAX_ESP = 2849;
    public static final int M_FS_4EAX_ID = 2850;
    public static final int M_FS_4EAX_ESI = 2851;
    public static final int M_FS_4EAX_EDI = 2852;

    public static final int M_FS_4ECX_EAX = 2853;
    public static final int M_FS_5ECX = 2854;
    public static final int M_FS_4ECX_EDX = 2855;
    public static final int M_FS_4ECX_EBX = 2856;
    public static final int M_FS_4ECX_ESP = 2857;
    public static final int M_FS_4ECX_ID = 2858;
    public static final int M_FS_4ECX_ESI = 2859;
    public static final int M_FS_4ECX_EDI = 2860;

    public static final int M_FS_4EDX_EAX = 2861;
    public static final int M_FS_4EDX_ECX = 2862;
    public static final int M_FS_5EDX = 2863;
    public static final int M_FS_4EDX_EBX = 2864;
    public static final int M_FS_4EDX_ESP = 2865;
    public static final int M_FS_4EDX_ID = 2866;
    public static final int M_FS_4EDX_ESI = 2867;
    public static final int M_FS_4EDX_EDI = 2868;

    public static final int M_FS_4EBX_EAX = 2869;
    public static final int M_FS_4EBX_ECX = 2870;
    public static final int M_FS_4EBX_EDX = 2871;
    public static final int M_FS_5EBX = 2872;
    public static final int M_FS_4EBX_ESP = 2873;
    public static final int M_FS_4EBX_ID = 2874;
    public static final int M_FS_4EBX_ESI = 2875;
    public static final int M_FS_4EBX_EDI = 2876;

    public static final int M_FS_4EBP_EAX = 2877;
    public static final int M_FS_4EBP_ECX = 2878;
    public static final int M_FS_4EBP_EDX = 2879;
    public static final int M_FS_4EBP_EBX = 2880;
    public static final int M_FS_4EBP_ESP = 2881;
    public static final int M_FS_4EBP_ID = 2882;
    public static final int M_FS_4EBP_ESI = 2883;
    public static final int M_FS_4EBP_EDI = 2884;

    public static final int M_FS_4ESI_EAX = 2885;
    public static final int M_FS_4ESI_ECX = 2886;
    public static final int M_FS_4ESI_EDX = 2887;
    public static final int M_FS_4ESI_EBX = 2888;
    public static final int M_FS_4ESI_ESP = 2889;
    public static final int M_FS_4ESI_ID = 2890;
    public static final int M_FS_5ESI = 2891;
    public static final int M_FS_4ESI_EDI = 2892;

    public static final int M_FS_4EDI_EAX = 2893;
    public static final int M_FS_4EDI_ECX = 2894;
    public static final int M_FS_4EDI_EDX = 2895;
    public static final int M_FS_4EDI_EBX = 2896;
    public static final int M_FS_4EDI_ESP = 2897;
    public static final int M_FS_4EDI_ID = 2898;
    public static final int M_FS_4EDI_ESI = 2899;
    public static final int M_FS_5EDI = 2900;

    public static final int M_FS_9EAX = 2901;
    public static final int M_FS_8EAX_ECX = 2902;
    public static final int M_FS_8EAX_EDX = 2903;
    public static final int M_FS_8EAX_EBX = 2904;
    public static final int M_FS_8EAX_ESP = 2905;
    public static final int M_FS_8EAX_ID = 2906;
    public static final int M_FS_8EAX_ESI = 2907;
    public static final int M_FS_8EAX_EDI = 2908;

    public static final int M_FS_8ECX_EAX = 2909;
    public static final int M_FS_9ECX = 2910;
    public static final int M_FS_8ECX_EDX = 2911;
    public static final int M_FS_8ECX_EBX = 2912;
    public static final int M_FS_8ECX_ESP = 2913;
    public static final int M_FS_8ECX_ID = 2914;
    public static final int M_FS_8ECX_ESI = 2915;
    public static final int M_FS_8ECX_EDI = 2916;

    public static final int M_FS_8EDX_EAX = 2917;
    public static final int M_FS_8EDX_ECX = 2918;
    public static final int M_FS_9EDX = 2919;
    public static final int M_FS_8EDX_EBX = 2920;
    public static final int M_FS_8EDX_ESP = 2921;
    public static final int M_FS_8EDX_ID = 2922;
    public static final int M_FS_8EDX_ESI = 2923;
    public static final int M_FS_8EDX_EDI = 2924;

    public static final int M_FS_8EBX_EAX = 2925;
    public static final int M_FS_8EBX_ECX = 2926;
    public static final int M_FS_8EBX_EDX = 2927;
    public static final int M_FS_9EBX = 2928;
    public static final int M_FS_8EBX_ESP = 2929;
    public static final int M_FS_8EBX_ID = 2930;
    public static final int M_FS_8EBX_ESI = 2931;
    public static final int M_FS_8EBX_EDI = 2932;

    public static final int M_FS_8EBP_EAX = 2933;
    public static final int M_FS_8EBP_ECX = 2934;
    public static final int M_FS_8EBP_EDX = 2935;
    public static final int M_FS_8EBP_EBX = 2936;
    public static final int M_FS_8EBP_ESP = 2937;
    public static final int M_FS_8EBP_ID = 2938;
    public static final int M_FS_8EBP_ESI = 2939;
    public static final int M_FS_8EBP_EDI = 2940;

    public static final int M_FS_8ESI_EAX = 2941;
    public static final int M_FS_8ESI_ECX = 2942;
    public static final int M_FS_8ESI_EDX = 2943;
    public static final int M_FS_8ESI_EBX = 2944;
    public static final int M_FS_8ESI_ESP = 2945;
    public static final int M_FS_8ESI_ID = 2946;
    public static final int M_FS_9ESI = 2947;
    public static final int M_FS_8ESI_EDI = 2948;
    
    public static final int M_FS_8EDI_EAX = 2949;
    public static final int M_FS_8EDI_ECX = 2950;
    public static final int M_FS_8EDI_EDX = 2951;
    public static final int M_FS_8EDI_EBX = 2952;
    public static final int M_FS_8EDI_ESP = 2953;
    public static final int M_FS_8EDI_ID = 2954;
    public static final int M_FS_8EDI_ESI = 2955;
    public static final int M_FS_9EDI = 2956;

    //SIB + IB Operands
    public static final int M_FS_2EAX_IB = 2957;
    public static final int M_FS_EAX_ECX_IB = 2958;
    public static final int M_FS_EAX_EDX_IB = 2959;
    public static final int M_FS_EAX_EBX_IB = 2960;
    public static final int M_FS_EAX_ESP_IB = 2961;
    public static final int M_FS_EAX_EBP_IB = 2962;
    public static final int M_FS_EAX_ESI_IB = 2963;
    public static final int M_FS_EAX_EDI_IB = 2964;

    public static final int M_FS_2ECX_IB = 2965;
    public static final int M_FS_ECX_EDX_IB = 2966;
    public static final int M_FS_ECX_EBX_IB = 2967;
    public static final int M_FS_ECX_ESP_IB = 2968;
    public static final int M_FS_ECX_EBP_IB = 2969;
    public static final int M_FS_ECX_ESI_IB = 2970;
    public static final int M_FS_ECX_EDI_IB = 2971;

    public static final int M_FS_2EDX_IB = 2972;
    public static final int M_FS_EDX_EBX_IB = 2973;
    public static final int M_FS_EDX_ESP_IB = 2974;
    public static final int M_FS_EDX_EBP_IB = 2975;
    public static final int M_FS_EDX_ESI_IB = 2976;
    public static final int M_FS_EDX_EDI_IB = 2977;

    public static final int M_FS_2EBX_IB = 2978;
    public static final int M_FS_EBX_ESP_IB = 2979;
    public static final int M_FS_EBX_EBP_IB = 2980;
    public static final int M_FS_EBX_ESI_IB = 2981;
    public static final int M_FS_EBX_EDI_IB = 2982;

    public static final int M_FS_ESP_IB = 2983;

    public static final int M_FS_EBP_ESP_IB = 2984;
    public static final int M_FS_2EBP_IB = 2985;
    public static final int M_FS_EBP_ESI_IB = 2986;
    public static final int M_FS_EBP_EDI_IB = 2987;

    public static final int M_FS_ESI_ESP_IB = 2988;
    public static final int M_FS_2ESI_IB = 2989;
    public static final int M_FS_ESI_EDI_IB = 2990;

    public static final int M_FS_EDI_ESP_IB = 2991;
    public static final int M_FS_2EDI_IB = 2992;

    public static final int M_FS_3EAX_IB = 2993;
    public static final int M_FS_2EAX_ECX_IB = 2994;
    public static final int M_FS_2EAX_EDX_IB = 2995;
    public static final int M_FS_2EAX_EBX_IB = 2996;
    public static final int M_FS_2EAX_ESP_IB = 2997;
    public static final int M_FS_2EAX_EBP_IB = 2998;
    public static final int M_FS_2EAX_ESI_IB = 2999;
    public static final int M_FS_2EAX_EDI_IB = 3000;

    public static final int M_FS_2ECX_EAX_IB = 3001;
    public static final int M_FS_3ECX_IB = 3002;
    public static final int M_FS_2ECX_EDX_IB = 3003;
    public static final int M_FS_2ECX_EBX_IB = 3004;
    public static final int M_FS_2ECX_ESP_IB = 3005;
    public static final int M_FS_2ECX_EBP_IB = 3006;
    public static final int M_FS_2ECX_ESI_IB = 3007;
    public static final int M_FS_2ECX_EDI_IB = 3008;

    public static final int M_FS_2EDX_EAX_IB = 3009;
    public static final int M_FS_2EDX_ECX_IB = 3010;
    public static final int M_FS_3EDX_IB = 3011;
    public static final int M_FS_2EDX_EBX_IB = 3012;
    public static final int M_FS_2EDX_ESP_IB = 3013;
    public static final int M_FS_2EDX_EBP_IB = 3014;
    public static final int M_FS_2EDX_ESI_IB = 3015;
    public static final int M_FS_2EDX_EDI_IB = 3016;

    public static final int M_FS_2EBX_EAX_IB = 3017;
    public static final int M_FS_2EBX_ECX_IB = 3018;
    public static final int M_FS_2EBX_EDX_IB = 3019;
    public static final int M_FS_3EBX_IB = 3020;
    public static final int M_FS_2EBX_ESP_IB = 3021;
    public static final int M_FS_2EBX_EBP_IB = 3022;
    public static final int M_FS_2EBX_ESI_IB = 3023;
    public static final int M_FS_2EBX_EDI_IB = 3024;

    public static final int M_FS_2EBP_EAX_IB = 3025;
    public static final int M_FS_2EBP_ECX_IB = 3026;
    public static final int M_FS_2EBP_EDX_IB = 3027;
    public static final int M_FS_2EBP_EBX_IB = 3028;
    public static final int M_FS_2EBP_ESP_IB = 3029;
    public static final int M_FS_3EBP_IB = 3030;
    public static final int M_FS_2EBP_ESI_IB = 3031;
    public static final int M_FS_2EBP_EDI_IB = 3032;

    public static final int M_FS_2ESI_EAX_IB = 3033;
    public static final int M_FS_2ESI_ECX_IB = 3034;
    public static final int M_FS_2ESI_EDX_IB = 3035;
    public static final int M_FS_2ESI_EBX_IB = 3036;
    public static final int M_FS_2ESI_ESP_IB = 3037;
    public static final int M_FS_2ESI_EBP_IB = 3038;
    public static final int M_FS_3ESI_IB = 3039;
    public static final int M_FS_2ESI_EDI_IB = 3040;

    public static final int M_FS_2EDI_EAX_IB = 3041;
    public static final int M_FS_2EDI_ECX_IB = 3042;
    public static final int M_FS_2EDI_EDX_IB = 3043;
    public static final int M_FS_2EDI_EBX_IB = 3044;
    public static final int M_FS_2EDI_ESP_IB = 3045;
    public static final int M_FS_2EDI_EBP_IB = 3046;
    public static final int M_FS_2EDI_ESI_IB = 3047;
    public static final int M_FS_3EDI_IB = 3048;

    public static final int M_FS_5EAX_IB = 3049;
    public static final int M_FS_4EAX_ECX_IB = 3050;
    public static final int M_FS_4EAX_EDX_IB = 3051;
    public static final int M_FS_4EAX_EBX_IB = 3052;
    public static final int M_FS_4EAX_ESP_IB = 3053;
    public static final int M_FS_4EAX_EBP_IB = 3054;
    public static final int M_FS_4EAX_ESI_IB = 3055;
    public static final int M_FS_4EAX_EDI_IB = 3056;

    public static final int M_FS_4ECX_EAX_IB = 3057;
    public static final int M_FS_5ECX_IB = 3058;
    public static final int M_FS_4ECX_EDX_IB = 3059;
    public static final int M_FS_4ECX_EBX_IB = 3060;
    public static final int M_FS_4ECX_ESP_IB = 3061;
    public static final int M_FS_4ECX_EBP_IB = 3062;
    public static final int M_FS_4ECX_ESI_IB = 3063;
    public static final int M_FS_4ECX_EDI_IB = 3064;

    public static final int M_FS_4EDX_EAX_IB = 3065;
    public static final int M_FS_4EDX_ECX_IB = 3066;
    public static final int M_FS_5EDX_IB = 3067;
    public static final int M_FS_4EDX_EBX_IB = 3068;
    public static final int M_FS_4EDX_ESP_IB = 3069;
    public static final int M_FS_4EDX_EBP_IB = 3070;
    public static final int M_FS_4EDX_ESI_IB = 3071;
    public static final int M_FS_4EDX_EDI_IB = 3072;

    public static final int M_FS_4EBX_EAX_IB = 3073;
    public static final int M_FS_4EBX_ECX_IB = 3074;
    public static final int M_FS_4EBX_EDX_IB = 3075;
    public static final int M_FS_5EBX_IB = 3076;
    public static final int M_FS_4EBX_ESP_IB = 3077;
    public static final int M_FS_4EBX_EBP_IB = 3078;
    public static final int M_FS_4EBX_ESI_IB = 3079;
    public static final int M_FS_4EBX_EDI_IB = 3080;

    public static final int M_FS_4EBP_EAX_IB = 3081;
    public static final int M_FS_4EBP_ECX_IB = 3082;
    public static final int M_FS_4EBP_EDX_IB = 3083;
    public static final int M_FS_4EBP_EBX_IB = 3084;
    public static final int M_FS_4EBP_ESP_IB = 3085;
    public static final int M_FS_5EBP_IB = 3086;
    public static final int M_FS_4EBP_ESI_IB = 3087;
    public static final int M_FS_4EBP_EDI_IB = 3088;

    public static final int M_FS_4ESI_EAX_IB = 3089;
    public static final int M_FS_4ESI_ECX_IB = 3090;
    public static final int M_FS_4ESI_EDX_IB = 3091;
    public static final int M_FS_4ESI_EBX_IB = 3092;
    public static final int M_FS_4ESI_ESP_IB = 3093;
    public static final int M_FS_4ESI_EBP_IB = 3094;
    public static final int M_FS_5ESI_IB = 3095;
    public static final int M_FS_4ESI_EDI_IB = 3096;

    public static final int M_FS_4EDI_EAX_IB = 3097;
    public static final int M_FS_4EDI_ECX_IB = 3098;
    public static final int M_FS_4EDI_EDX_IB = 3099;
    public static final int M_FS_4EDI_EBX_IB = 3100;
    public static final int M_FS_4EDI_ESP_IB = 3101;
    public static final int M_FS_4EDI_EBP_IB = 3102;
    public static final int M_FS_4EDI_ESI_IB = 3103;
    public static final int M_FS_5EDI_IB = 3104;

    public static final int M_FS_9EAX_IB = 3105;
    public static final int M_FS_8EAX_ECX_IB = 3106;
    public static final int M_FS_8EAX_EDX_IB = 3107;
    public static final int M_FS_8EAX_EBX_IB = 3108;
    public static final int M_FS_8EAX_ESP_IB = 3109;
    public static final int M_FS_8EAX_EBP_IB = 3110;
    public static final int M_FS_8EAX_ESI_IB = 3111;
    public static final int M_FS_8EAX_EDI_IB = 3112;

    public static final int M_FS_8ECX_EAX_IB = 3113;
    public static final int M_FS_9ECX_IB = 3114;
    public static final int M_FS_8ECX_EDX_IB = 3115;
    public static final int M_FS_8ECX_EBX_IB = 3116;
    public static final int M_FS_8ECX_ESP_IB = 3117;
    public static final int M_FS_8ECX_EBP_IB = 3118;
    public static final int M_FS_8ECX_ESI_IB = 3119;
    public static final int M_FS_8ECX_EDI_IB = 3120;

    public static final int M_FS_8EDX_EAX_IB = 3121;
    public static final int M_FS_8EDX_ECX_IB = 3122;
    public static final int M_FS_9EDX_IB = 3123;
    public static final int M_FS_8EDX_EBX_IB = 3124;
    public static final int M_FS_8EDX_ESP_IB = 3125;
    public static final int M_FS_8EDX_EBP_IB = 3126;
    public static final int M_FS_8EDX_ESI_IB = 3127;
    public static final int M_FS_8EDX_EDI_IB = 3128;

    public static final int M_FS_8EBX_EAX_IB = 3129;
    public static final int M_FS_8EBX_ECX_IB = 3130;
    public static final int M_FS_8EBX_EDX_IB = 3131;
    public static final int M_FS_9EBX_IB = 3132;
    public static final int M_FS_8EBX_ESP_IB = 3133;
    public static final int M_FS_8EBX_EBP_IB = 3134;
    public static final int M_FS_8EBX_ESI_IB = 3135;
    public static final int M_FS_8EBX_EDI_IB = 3136;

    public static final int M_FS_8EBP_EAX_IB = 3137;
    public static final int M_FS_8EBP_ECX_IB = 3138;
    public static final int M_FS_8EBP_EDX_IB = 3139;
    public static final int M_FS_8EBP_EBX_IB = 3140;
    public static final int M_FS_8EBP_ESP_IB = 3141;
    public static final int M_FS_9EBP_IB = 3142;
    public static final int M_FS_8EBP_ESI_IB = 3143;
    public static final int M_FS_8EBP_EDI_IB = 3144;

    public static final int M_FS_8ESI_EAX_IB = 3145;
    public static final int M_FS_8ESI_ECX_IB = 3146;
    public static final int M_FS_8ESI_EDX_IB = 3147;
    public static final int M_FS_8ESI_EBX_IB = 3148;
    public static final int M_FS_8ESI_ESP_IB = 3149;
    public static final int M_FS_8ESI_EBP_IB = 3150;
    public static final int M_FS_9ESI_IB = 3151;
    public static final int M_FS_8ESI_EDI_IB = 3152;
    
    public static final int M_FS_8EDI_EAX_IB = 3153;
    public static final int M_FS_8EDI_ECX_IB = 3154;
    public static final int M_FS_8EDI_EDX_IB = 3155;
    public static final int M_FS_8EDI_EBX_IB = 3156;
    public static final int M_FS_8EDI_ESP_IB = 3157;
    public static final int M_FS_8EDI_EBP_IB = 3158;
    public static final int M_FS_8EDI_ESI_IB = 3159;
    public static final int M_FS_9EDI_IB = 3160;

    //SIB + ID Operands
    public static final int M_FS_EAX_ECX_ID = 3161;
    public static final int M_FS_EAX_EDX_ID = 3162;
    public static final int M_FS_EAX_EBX_ID = 3163;
    public static final int M_FS_EAX_ESP_ID = 3164;
    public static final int M_FS_EAX_EBP_ID = 3165;
    public static final int M_FS_EAX_ESI_ID = 3166;
    public static final int M_FS_EAX_EDI_ID = 3167;

    public static final int M_FS_ECX_EDX_ID = 3168;
    public static final int M_FS_ECX_EBX_ID = 3169;
    public static final int M_FS_ECX_ESP_ID = 3170;
    public static final int M_FS_ECX_EBP_ID = 3171;
    public static final int M_FS_ECX_ESI_ID = 3172;
    public static final int M_FS_ECX_EDI_ID = 3173;

    public static final int M_FS_EDX_EBX_ID = 3174;
    public static final int M_FS_EDX_ESP_ID = 3175;
    public static final int M_FS_EDX_EBP_ID = 3176;
    public static final int M_FS_EDX_ESI_ID = 3177;
    public static final int M_FS_EDX_EDI_ID = 3178;

    public static final int M_FS_EBX_ESP_ID = 3179;
    public static final int M_FS_EBX_EBP_ID = 3180;
    public static final int M_FS_EBX_ESI_ID = 3181;
    public static final int M_FS_EBX_EDI_ID = 3182;

    public static final int M_FS_ESP_ID = 3183;

    public static final int M_FS_EBP_ESP_ID = 3184;
    public static final int M_FS_EBP_ESI_ID = 3185;
    public static final int M_FS_EBP_EDI_ID = 3186;

    public static final int M_FS_ESI_ESP_ID = 3187;
    public static final int M_FS_ESI_EDI_ID = 3188;

    public static final int M_FS_EDI_ESP_ID = 3189;

    public static final int M_FS_3EAX_ID = 3190;
    public static final int M_FS_2EAX_ECX_ID = 3191;
    public static final int M_FS_2EAX_EDX_ID = 3192;
    public static final int M_FS_2EAX_EBX_ID = 3193;
    public static final int M_FS_2EAX_ESP_ID = 3194;
    public static final int M_FS_2EAX_EBP_ID = 3195;
    public static final int M_FS_2EAX_ESI_ID = 3196;
    public static final int M_FS_2EAX_EDI_ID = 3197;

    public static final int M_FS_2ECX_EAX_ID = 3198;
    public static final int M_FS_3ECX_ID = 3199;
    public static final int M_FS_2ECX_EDX_ID = 3200;
    public static final int M_FS_2ECX_EBX_ID = 3201;
    public static final int M_FS_2ECX_ESP_ID = 3202;
    public static final int M_FS_2ECX_EBP_ID = 3203;
    public static final int M_FS_2ECX_ESI_ID = 3204;
    public static final int M_FS_2ECX_EDI_ID = 3205;

    public static final int M_FS_2EDX_EAX_ID = 3206;
    public static final int M_FS_2EDX_ECX_ID = 3207;
    public static final int M_FS_3EDX_ID = 3208;
    public static final int M_FS_2EDX_EBX_ID = 3209;
    public static final int M_FS_2EDX_ESP_ID = 3210;
    public static final int M_FS_2EDX_EBP_ID = 3211;
    public static final int M_FS_2EDX_ESI_ID = 3212;
    public static final int M_FS_2EDX_EDI_ID = 3213;

    public static final int M_FS_2EBX_EAX_ID = 3214;
    public static final int M_FS_2EBX_ECX_ID = 3215;
    public static final int M_FS_2EBX_EDX_ID = 3216;
    public static final int M_FS_3EBX_ID = 3217;
    public static final int M_FS_2EBX_ESP_ID = 3218;
    public static final int M_FS_2EBX_EBP_ID = 3219;
    public static final int M_FS_2EBX_ESI_ID = 3220;
    public static final int M_FS_2EBX_EDI_ID = 3221;

    public static final int M_FS_2EBP_EAX_ID = 3222;
    public static final int M_FS_2EBP_ECX_ID = 3223;
    public static final int M_FS_2EBP_EDX_ID = 3224;
    public static final int M_FS_2EBP_EBX_ID = 3225;
    public static final int M_FS_2EBP_ESP_ID = 3226;
    public static final int M_FS_3EBP_ID = 3227;
    public static final int M_FS_2EBP_ESI_ID = 3228;
    public static final int M_FS_2EBP_EDI_ID = 3229;

    public static final int M_FS_2ESI_EAX_ID = 3230;
    public static final int M_FS_2ESI_ECX_ID = 3231;
    public static final int M_FS_2ESI_EDX_ID = 3232;
    public static final int M_FS_2ESI_EBX_ID = 3233;
    public static final int M_FS_2ESI_ESP_ID = 3234;
    public static final int M_FS_2ESI_EBP_ID = 3235;
    public static final int M_FS_3ESI_ID = 3236;
    public static final int M_FS_2ESI_EDI_ID = 3237;

    public static final int M_FS_2EDI_EAX_ID = 3238;
    public static final int M_FS_2EDI_ECX_ID = 3239;
    public static final int M_FS_2EDI_EDX_ID = 3240;
    public static final int M_FS_2EDI_EBX_ID = 3241;
    public static final int M_FS_2EDI_ESP_ID = 3242;
    public static final int M_FS_2EDI_EBP_ID = 3243;
    public static final int M_FS_2EDI_ESI_ID = 3244;
    public static final int M_FS_3EDI_ID = 3245;

    public static final int M_FS_5EAX_ID = 3246;
    public static final int M_FS_4EAX_ECX_ID = 3247;
    public static final int M_FS_4EAX_EDX_ID = 3248;
    public static final int M_FS_4EAX_EBX_ID = 3249;
    public static final int M_FS_4EAX_ESP_ID = 3250;
    public static final int M_FS_4EAX_EBP_ID = 3251;
    public static final int M_FS_4EAX_ESI_ID = 3252;
    public static final int M_FS_4EAX_EDI_ID = 3253;

    public static final int M_FS_4ECX_EAX_ID = 3254;
    public static final int M_FS_5ECX_ID = 3255;
    public static final int M_FS_4ECX_EDX_ID = 3256;
    public static final int M_FS_4ECX_EBX_ID = 3257;
    public static final int M_FS_4ECX_ESP_ID = 3258;
    public static final int M_FS_4ECX_EBP_ID = 3259;
    public static final int M_FS_4ECX_ESI_ID = 3260;
    public static final int M_FS_4ECX_EDI_ID = 3261;

    public static final int M_FS_4EDX_EAX_ID = 3262;
    public static final int M_FS_4EDX_ECX_ID = 3263;
    public static final int M_FS_5EDX_ID = 3264;
    public static final int M_FS_4EDX_EBX_ID = 3265;
    public static final int M_FS_4EDX_ESP_ID = 3266;
    public static final int M_FS_4EDX_EBP_ID = 3267;
    public static final int M_FS_4EDX_ESI_ID = 3268;
    public static final int M_FS_4EDX_EDI_ID = 3269;

    public static final int M_FS_4EBX_EAX_ID = 3270;
    public static final int M_FS_4EBX_ECX_ID = 3271;
    public static final int M_FS_4EBX_EDX_ID = 3272;
    public static final int M_FS_5EBX_ID = 3273;
    public static final int M_FS_4EBX_ESP_ID = 3274;
    public static final int M_FS_4EBX_EBP_ID = 3275;
    public static final int M_FS_4EBX_ESI_ID = 3276;
    public static final int M_FS_4EBX_EDI_ID = 3277;

    public static final int M_FS_4EBP_EAX_ID = 3278;
    public static final int M_FS_4EBP_ECX_ID = 3279;
    public static final int M_FS_4EBP_EDX_ID = 3280;
    public static final int M_FS_4EBP_EBX_ID = 3281;
    public static final int M_FS_4EBP_ESP_ID = 3282;
    public static final int M_FS_5EBP_ID = 3283;
    public static final int M_FS_4EBP_ESI_ID = 3284;
    public static final int M_FS_4EBP_EDI_ID = 3285;

    public static final int M_FS_4ESI_EAX_ID = 3286;
    public static final int M_FS_4ESI_ECX_ID = 3287;
    public static final int M_FS_4ESI_EDX_ID = 3288;
    public static final int M_FS_4ESI_EBX_ID = 3289;
    public static final int M_FS_4ESI_ESP_ID = 3290;
    public static final int M_FS_4ESI_EBP_ID = 3291;
    public static final int M_FS_5ESI_ID = 3292;
    public static final int M_FS_4ESI_EDI_ID = 3293;

    public static final int M_FS_4EDI_EAX_ID = 3294;
    public static final int M_FS_4EDI_ECX_ID = 3295;
    public static final int M_FS_4EDI_EDX_ID = 3296;
    public static final int M_FS_4EDI_EBX_ID = 3297;
    public static final int M_FS_4EDI_ESP_ID = 3298;
    public static final int M_FS_4EDI_EBP_ID = 3299;
    public static final int M_FS_4EDI_ESI_ID = 3300;
    public static final int M_FS_5EDI_ID = 3301;

    public static final int M_FS_9EAX_ID = 3302;
    public static final int M_FS_8EAX_ECX_ID = 3303;
    public static final int M_FS_8EAX_EDX_ID = 3304;
    public static final int M_FS_8EAX_EBX_ID = 3305;
    public static final int M_FS_8EAX_ESP_ID = 3306;
    public static final int M_FS_8EAX_EBP_ID = 3307;
    public static final int M_FS_8EAX_ESI_ID = 3308;
    public static final int M_FS_8EAX_EDI_ID = 3309;

    public static final int M_FS_8ECX_EAX_ID = 3310;
    public static final int M_FS_9ECX_ID = 3311;
    public static final int M_FS_8ECX_EDX_ID = 3312;
    public static final int M_FS_8ECX_EBX_ID = 3313;
    public static final int M_FS_8ECX_ESP_ID = 3314;
    public static final int M_FS_8ECX_EBP_ID = 3315;
    public static final int M_FS_8ECX_ESI_ID = 3316;
    public static final int M_FS_8ECX_EDI_ID = 3317;

    public static final int M_FS_8EDX_EAX_ID = 3318;
    public static final int M_FS_8EDX_ECX_ID = 3319;
    public static final int M_FS_9EDX_ID = 3320;
    public static final int M_FS_8EDX_EBX_ID = 3321;
    public static final int M_FS_8EDX_ESP_ID = 3322;
    public static final int M_FS_8EDX_EBP_ID = 3323;
    public static final int M_FS_8EDX_ESI_ID = 3324;
    public static final int M_FS_8EDX_EDI_ID = 3325;

    public static final int M_FS_8EBX_EAX_ID = 3326;
    public static final int M_FS_8EBX_ECX_ID = 3327;
    public static final int M_FS_8EBX_EDX_ID = 3328;
    public static final int M_FS_9EBX_ID = 3329;
    public static final int M_FS_8EBX_ESP_ID = 3330;
    public static final int M_FS_8EBX_EBP_ID = 3331;
    public static final int M_FS_8EBX_ESI_ID = 3332;
    public static final int M_FS_8EBX_EDI_ID = 3333;

    public static final int M_FS_8EBP_EAX_ID = 3334;
    public static final int M_FS_8EBP_ECX_ID = 3335;
    public static final int M_FS_8EBP_EDX_ID = 3336;
    public static final int M_FS_8EBP_EBX_ID = 3337;
    public static final int M_FS_8EBP_ESP_ID = 3338;
    public static final int M_FS_9EBP_ID = 3339;
    public static final int M_FS_8EBP_ESI_ID = 3340;
    public static final int M_FS_8EBP_EDI_ID = 3341;

    public static final int M_FS_8ESI_EAX_ID = 3342;
    public static final int M_FS_8ESI_ECX_ID = 3343;
    public static final int M_FS_8ESI_EDX_ID = 3344;
    public static final int M_FS_8ESI_EBX_ID = 3345;
    public static final int M_FS_8ESI_ESP_ID = 3346;
    public static final int M_FS_8ESI_EBP_ID = 3347;
    public static final int M_FS_9ESI_ID = 3348;
    public static final int M_FS_8ESI_EDI_ID = 3349;
    
    public static final int M_FS_8EDI_EAX_ID = 3350;
    public static final int M_FS_8EDI_ECX_ID = 3351;
    public static final int M_FS_8EDI_EDX_ID = 3352;
    public static final int M_FS_8EDI_EBX_ID = 3353;
    public static final int M_FS_8EDI_ESP_ID = 3354;
    public static final int M_FS_8EDI_EBP_ID = 3355;
    public static final int M_FS_8EDI_ESI_ID = 3356;
    public static final int M_FS_9EDI_ID = 3357;

    //SIB Operands
    public static final int M_GS_2EAX = 3358;
    public static final int M_GS_EAX_ECX = 3359;
    public static final int M_GS_EAX_EDX = 3360;
    public static final int M_GS_EAX_EBX = 3361;
    public static final int M_GS_EAX_ESP = 3362;
    public static final int M_GS_EAX_EBP = 3363;
    public static final int M_GS_EAX_ESI = 3364;
    public static final int M_GS_EAX_EDI = 3365;

    public static final int M_GS_2ECX = 3366;
    public static final int M_GS_ECX_EDX = 3367;
    public static final int M_GS_ECX_EBX = 3368;
    public static final int M_GS_ECX_ESP = 3369;
    public static final int M_GS_ECX_EBP = 3370;
    public static final int M_GS_ECX_ESI = 3371;
    public static final int M_GS_ECX_EDI = 3372;

    public static final int M_GS_2EDX = 3373;

    public static final int M_GS_EDX_EBX = 3374;
    public static final int M_GS_EDX_ESP = 3375;
    public static final int M_GS_EDX_EBP = 3376;
    public static final int M_GS_EDX_ESI = 3377;
    public static final int M_GS_EDX_EDI = 3378;

    public static final int M_GS_2EBX = 3379;
    public static final int M_GS_EBX_ESP = 3380;
    public static final int M_GS_EBX_EBP = 3381;
    public static final int M_GS_EBX_ESI = 3382;
    public static final int M_GS_EBX_EDI = 3383;

    public static final int M_GS_ESP = 3384;

    public static final int M_GS_EBP_ESP = 3385;
    public static final int M_GS_EBP_ESI = 3386;
    public static final int M_GS_EBP_EDI = 3387;

    public static final int M_GS_ESI_ESP = 3388;
    public static final int M_GS_2ESI = 3389;
    public static final int M_GS_ESI_EDI = 3390;

    public static final int M_GS_EDI_ESP = 3391;
    public static final int M_GS_2EDI = 3392;

    public static final int M_GS_3EAX = 3393;
    public static final int M_GS_2EAX_ECX = 3394;
    public static final int M_GS_2EAX_EDX = 3395;
    public static final int M_GS_2EAX_EBX = 3396;
    public static final int M_GS_2EAX_ESP = 3397;
    public static final int M_GS_2EAX_ID = 3398;
    public static final int M_GS_2EAX_ESI = 3399;
    public static final int M_GS_2EAX_EDI = 3400;

    public static final int M_GS_2ECX_EAX = 3401;
    public static final int M_GS_3ECX = 3402;
    public static final int M_GS_2ECX_EDX = 3403;
    public static final int M_GS_2ECX_EBX = 3404;
    public static final int M_GS_2ECX_ESP = 3405;
    public static final int M_GS_2ECX_ID = 3406;
    public static final int M_GS_2ECX_ESI = 3407;
    public static final int M_GS_2ECX_EDI = 3408;

    public static final int M_GS_2EDX_EAX = 3409;
    public static final int M_GS_2EDX_ECX = 3410;
    public static final int M_GS_3EDX = 3411;
    public static final int M_GS_2EDX_EBX = 3412;
    public static final int M_GS_2EDX_ESP = 3413;
    public static final int M_GS_2EDX_ID = 3414;
    public static final int M_GS_2EDX_ESI = 3415;
    public static final int M_GS_2EDX_EDI = 3416;

    public static final int M_GS_2EBX_EAX = 3417;
    public static final int M_GS_2EBX_ECX = 3418;
    public static final int M_GS_2EBX_EDX = 3419;
    public static final int M_GS_3EBX = 3420;
    public static final int M_GS_2EBX_ESP = 3421;
    public static final int M_GS_2EBX_ID = 3422;
    public static final int M_GS_2EBX_ESI = 3423;
    public static final int M_GS_2EBX_EDI = 3424;

    public static final int M_GS_2EBP_EAX = 3425;
    public static final int M_GS_2EBP_ECX = 3426;
    public static final int M_GS_2EBP_EDX = 3427;
    public static final int M_GS_2EBP_EBX = 3428;
    public static final int M_GS_2EBP_ESP = 3429;
    public static final int M_GS_2EBP_ID = 3430;
    public static final int M_GS_2EBP_ESI = 3431;
    public static final int M_GS_2EBP_EDI = 3432;

    public static final int M_GS_2ESI_EAX = 3433;
    public static final int M_GS_2ESI_ECX = 3434;
    public static final int M_GS_2ESI_EDX = 3435;
    public static final int M_GS_2ESI_EBX = 3436;
    public static final int M_GS_2ESI_ESP = 3437;
    public static final int M_GS_2ESI_ID = 3438;
    public static final int M_GS_3ESI = 3439;
    public static final int M_GS_2ESI_EDI = 3440;

    public static final int M_GS_2EDI_EAX = 3441;
    public static final int M_GS_2EDI_ECX = 3442;
    public static final int M_GS_2EDI_EDX = 3443;
    public static final int M_GS_2EDI_EBX = 3444;
    public static final int M_GS_2EDI_ESP = 3445;
    public static final int M_GS_2EDI_ID = 3446;
    public static final int M_GS_2EDI_ESI = 3447;
    public static final int M_GS_3EDI = 3448;

    public static final int M_GS_5EAX = 3449;
    public static final int M_GS_4EAX_ECX = 3450;
    public static final int M_GS_4EAX_EDX = 3451;
    public static final int M_GS_4EAX_EBX = 3452;
    public static final int M_GS_4EAX_ESP = 3453;
    public static final int M_GS_4EAX_ID = 3454;
    public static final int M_GS_4EAX_ESI = 3455;
    public static final int M_GS_4EAX_EDI = 3456;

    public static final int M_GS_4ECX_EAX = 3457;
    public static final int M_GS_5ECX = 3458;
    public static final int M_GS_4ECX_EDX = 3459;
    public static final int M_GS_4ECX_EBX = 3460;
    public static final int M_GS_4ECX_ESP = 3461;
    public static final int M_GS_4ECX_ID = 3462;
    public static final int M_GS_4ECX_ESI = 3463;
    public static final int M_GS_4ECX_EDI = 3464;

    public static final int M_GS_4EDX_EAX = 3465;
    public static final int M_GS_4EDX_ECX = 3466;
    public static final int M_GS_5EDX = 3467;
    public static final int M_GS_4EDX_EBX = 3468;
    public static final int M_GS_4EDX_ESP = 3469;
    public static final int M_GS_4EDX_ID = 3470;
    public static final int M_GS_4EDX_ESI = 3471;
    public static final int M_GS_4EDX_EDI = 3472;

    public static final int M_GS_4EBX_EAX = 3473;
    public static final int M_GS_4EBX_ECX = 3474;
    public static final int M_GS_4EBX_EDX = 3475;
    public static final int M_GS_5EBX = 3476;
    public static final int M_GS_4EBX_ESP = 3477;
    public static final int M_GS_4EBX_ID = 3478;
    public static final int M_GS_4EBX_ESI = 3479;
    public static final int M_GS_4EBX_EDI = 3480;

    public static final int M_GS_4EBP_EAX = 3481;
    public static final int M_GS_4EBP_ECX = 3482;
    public static final int M_GS_4EBP_EDX = 3483;
    public static final int M_GS_4EBP_EBX = 3484;
    public static final int M_GS_4EBP_ESP = 3485;
    public static final int M_GS_4EBP_ID = 3486;
    public static final int M_GS_4EBP_ESI = 3487;
    public static final int M_GS_4EBP_EDI = 3488;

    public static final int M_GS_4ESI_EAX = 3489;
    public static final int M_GS_4ESI_ECX = 3490;
    public static final int M_GS_4ESI_EDX = 3491;
    public static final int M_GS_4ESI_EBX = 3492;
    public static final int M_GS_4ESI_ESP = 3493;
    public static final int M_GS_4ESI_ID = 3494;
    public static final int M_GS_5ESI = 3495;
    public static final int M_GS_4ESI_EDI = 3496;

    public static final int M_GS_4EDI_EAX = 3497;
    public static final int M_GS_4EDI_ECX = 3498;
    public static final int M_GS_4EDI_EDX = 3499;
    public static final int M_GS_4EDI_EBX = 3500;
    public static final int M_GS_4EDI_ESP = 3501;
    public static final int M_GS_4EDI_ID = 3502;
    public static final int M_GS_4EDI_ESI = 3503;
    public static final int M_GS_5EDI = 3504;

    public static final int M_GS_9EAX = 3505;
    public static final int M_GS_8EAX_ECX = 3506;
    public static final int M_GS_8EAX_EDX = 3507;
    public static final int M_GS_8EAX_EBX = 3508;
    public static final int M_GS_8EAX_ESP = 3509;
    public static final int M_GS_8EAX_ID = 3510;
    public static final int M_GS_8EAX_ESI = 3511;
    public static final int M_GS_8EAX_EDI = 3512;

    public static final int M_GS_8ECX_EAX = 3513;
    public static final int M_GS_9ECX = 3514;
    public static final int M_GS_8ECX_EDX = 3515;
    public static final int M_GS_8ECX_EBX = 3516;
    public static final int M_GS_8ECX_ESP = 3517;
    public static final int M_GS_8ECX_ID = 3518;
    public static final int M_GS_8ECX_ESI = 3519;
    public static final int M_GS_8ECX_EDI = 3520;

    public static final int M_GS_8EDX_EAX = 3521;
    public static final int M_GS_8EDX_ECX = 3522;
    public static final int M_GS_9EDX = 3523;
    public static final int M_GS_8EDX_EBX = 3524;
    public static final int M_GS_8EDX_ESP = 3525;
    public static final int M_GS_8EDX_ID = 3526;
    public static final int M_GS_8EDX_ESI = 3527;
    public static final int M_GS_8EDX_EDI = 3528;

    public static final int M_GS_8EBX_EAX = 3529;
    public static final int M_GS_8EBX_ECX = 3530;
    public static final int M_GS_8EBX_EDX = 3531;
    public static final int M_GS_9EBX = 3532;
    public static final int M_GS_8EBX_ESP = 3533;
    public static final int M_GS_8EBX_ID = 3534;
    public static final int M_GS_8EBX_ESI = 3535;
    public static final int M_GS_8EBX_EDI = 3536;

    public static final int M_GS_8EBP_EAX = 3537;
    public static final int M_GS_8EBP_ECX = 3538;
    public static final int M_GS_8EBP_EDX = 3539;
    public static final int M_GS_8EBP_EBX = 3540;
    public static final int M_GS_8EBP_ESP = 3541;
    public static final int M_GS_8EBP_ID = 3542;
    public static final int M_GS_8EBP_ESI = 3543;
    public static final int M_GS_8EBP_EDI = 3544;

    public static final int M_GS_8ESI_EAX = 3545;
    public static final int M_GS_8ESI_ECX = 3546;
    public static final int M_GS_8ESI_EDX = 3547;
    public static final int M_GS_8ESI_EBX = 3548;
    public static final int M_GS_8ESI_ESP = 3549;
    public static final int M_GS_8ESI_ID = 3550;
    public static final int M_GS_9ESI = 3551;
    public static final int M_GS_8ESI_EDI = 3552;
    
    public static final int M_GS_8EDI_EAX = 3553;
    public static final int M_GS_8EDI_ECX = 3554;
    public static final int M_GS_8EDI_EDX = 3555;
    public static final int M_GS_8EDI_EBX = 3556;
    public static final int M_GS_8EDI_ESP = 3557;
    public static final int M_GS_8EDI_ID = 3558;
    public static final int M_GS_8EDI_ESI = 3559;
    public static final int M_GS_9EDI = 3560;

    //SIB + IB Operands
    public static final int M_GS_2EAX_IB = 3561;
    public static final int M_GS_EAX_ECX_IB = 3562;
    public static final int M_GS_EAX_EDX_IB = 3563;
    public static final int M_GS_EAX_EBX_IB = 3564;
    public static final int M_GS_EAX_ESP_IB = 3565;
    public static final int M_GS_EAX_EBP_IB = 3566;
    public static final int M_GS_EAX_ESI_IB = 3567;
    public static final int M_GS_EAX_EDI_IB = 3568;

    public static final int M_GS_2ECX_IB = 3569;
    public static final int M_GS_ECX_EDX_IB = 3570;
    public static final int M_GS_ECX_EBX_IB = 3571;
    public static final int M_GS_ECX_ESP_IB = 3572;
    public static final int M_GS_ECX_EBP_IB = 3573;
    public static final int M_GS_ECX_ESI_IB = 3574;
    public static final int M_GS_ECX_EDI_IB = 3575;

    public static final int M_GS_2EDX_IB = 3576;
    public static final int M_GS_EDX_EBX_IB = 3577;
    public static final int M_GS_EDX_ESP_IB = 3578;
    public static final int M_GS_EDX_EBP_IB = 3579;
    public static final int M_GS_EDX_ESI_IB = 3580;
    public static final int M_GS_EDX_EDI_IB = 3581;

    public static final int M_GS_2EBX_IB = 3582;
    public static final int M_GS_EBX_ESP_IB = 3583;
    public static final int M_GS_EBX_EBP_IB = 3584;
    public static final int M_GS_EBX_ESI_IB = 3585;
    public static final int M_GS_EBX_EDI_IB = 3586;

    public static final int M_GS_ESP_IB = 3587;

    public static final int M_GS_EBP_ESP_IB = 3588;
    public static final int M_GS_2EBP_IB = 3589;
    public static final int M_GS_EBP_ESI_IB = 3590;
    public static final int M_GS_EBP_EDI_IB = 3591;

    public static final int M_GS_ESI_ESP_IB = 3592;
    public static final int M_GS_2ESI_IB = 3593;
    public static final int M_GS_ESI_EDI_IB = 3594;

    public static final int M_GS_EDI_ESP_IB = 3595;
    public static final int M_GS_2EDI_IB = 3596;

    public static final int M_GS_3EAX_IB = 3597;
    public static final int M_GS_2EAX_ECX_IB = 3598;
    public static final int M_GS_2EAX_EDX_IB = 3599;
    public static final int M_GS_2EAX_EBX_IB = 3600;
    public static final int M_GS_2EAX_ESP_IB = 3601;
    public static final int M_GS_2EAX_EBP_IB = 3602;
    public static final int M_GS_2EAX_ESI_IB = 3603;
    public static final int M_GS_2EAX_EDI_IB = 3604;

    public static final int M_GS_2ECX_EAX_IB = 3605;
    public static final int M_GS_3ECX_IB = 3606;
    public static final int M_GS_2ECX_EDX_IB = 3607;
    public static final int M_GS_2ECX_EBX_IB = 3608;
    public static final int M_GS_2ECX_ESP_IB = 3609;
    public static final int M_GS_2ECX_EBP_IB = 3610;
    public static final int M_GS_2ECX_ESI_IB = 3611;
    public static final int M_GS_2ECX_EDI_IB = 3612;

    public static final int M_GS_2EDX_EAX_IB = 3613;
    public static final int M_GS_2EDX_ECX_IB = 3614;
    public static final int M_GS_3EDX_IB = 3615;
    public static final int M_GS_2EDX_EBX_IB = 3616;
    public static final int M_GS_2EDX_ESP_IB = 3617;
    public static final int M_GS_2EDX_EBP_IB = 3618;
    public static final int M_GS_2EDX_ESI_IB = 3619;
    public static final int M_GS_2EDX_EDI_IB = 3620;

    public static final int M_GS_2EBX_EAX_IB = 3621;
    public static final int M_GS_2EBX_ECX_IB = 3622;
    public static final int M_GS_2EBX_EDX_IB = 3623;
    public static final int M_GS_3EBX_IB = 3624;
    public static final int M_GS_2EBX_ESP_IB = 3625;
    public static final int M_GS_2EBX_EBP_IB = 3626;
    public static final int M_GS_2EBX_ESI_IB = 3627;
    public static final int M_GS_2EBX_EDI_IB = 3628;

    public static final int M_GS_2EBP_EAX_IB = 3629;
    public static final int M_GS_2EBP_ECX_IB = 3630;
    public static final int M_GS_2EBP_EDX_IB = 3631;
    public static final int M_GS_2EBP_EBX_IB = 3632;
    public static final int M_GS_2EBP_ESP_IB = 3633;
    public static final int M_GS_3EBP_IB = 3634;
    public static final int M_GS_2EBP_ESI_IB = 3635;
    public static final int M_GS_2EBP_EDI_IB = 3636;

    public static final int M_GS_2ESI_EAX_IB = 3637;
    public static final int M_GS_2ESI_ECX_IB = 3638;
    public static final int M_GS_2ESI_EDX_IB = 3639;
    public static final int M_GS_2ESI_EBX_IB = 3640;
    public static final int M_GS_2ESI_ESP_IB = 3641;
    public static final int M_GS_2ESI_EBP_IB = 3642;
    public static final int M_GS_3ESI_IB = 3643;
    public static final int M_GS_2ESI_EDI_IB = 3644;

    public static final int M_GS_2EDI_EAX_IB = 3645;
    public static final int M_GS_2EDI_ECX_IB = 3646;
    public static final int M_GS_2EDI_EDX_IB = 3647;
    public static final int M_GS_2EDI_EBX_IB = 3648;
    public static final int M_GS_2EDI_ESP_IB = 3649;
    public static final int M_GS_2EDI_EBP_IB = 3650;
    public static final int M_GS_2EDI_ESI_IB = 3651;
    public static final int M_GS_3EDI_IB = 3652;

    public static final int M_GS_5EAX_IB = 3653;
    public static final int M_GS_4EAX_ECX_IB = 3654;
    public static final int M_GS_4EAX_EDX_IB = 3655;
    public static final int M_GS_4EAX_EBX_IB = 3656;
    public static final int M_GS_4EAX_ESP_IB = 3657;
    public static final int M_GS_4EAX_EBP_IB = 3658;
    public static final int M_GS_4EAX_ESI_IB = 3659;
    public static final int M_GS_4EAX_EDI_IB = 3660;

    public static final int M_GS_4ECX_EAX_IB = 3661;
    public static final int M_GS_5ECX_IB = 3662;
    public static final int M_GS_4ECX_EDX_IB = 3663;
    public static final int M_GS_4ECX_EBX_IB = 3664;
    public static final int M_GS_4ECX_ESP_IB = 3665;
    public static final int M_GS_4ECX_EBP_IB = 3666;
    public static final int M_GS_4ECX_ESI_IB = 3667;
    public static final int M_GS_4ECX_EDI_IB = 3668;

    public static final int M_GS_4EDX_EAX_IB = 3669;
    public static final int M_GS_4EDX_ECX_IB = 3670;
    public static final int M_GS_5EDX_IB = 3671;
    public static final int M_GS_4EDX_EBX_IB = 3672;
    public static final int M_GS_4EDX_ESP_IB = 3673;
    public static final int M_GS_4EDX_EBP_IB = 3674;
    public static final int M_GS_4EDX_ESI_IB = 3675;
    public static final int M_GS_4EDX_EDI_IB = 3676;

    public static final int M_GS_4EBX_EAX_IB = 3677;
    public static final int M_GS_4EBX_ECX_IB = 3678;
    public static final int M_GS_4EBX_EDX_IB = 3679;
    public static final int M_GS_5EBX_IB = 3680;
    public static final int M_GS_4EBX_ESP_IB = 3681;
    public static final int M_GS_4EBX_EBP_IB = 3682;
    public static final int M_GS_4EBX_ESI_IB = 3683;
    public static final int M_GS_4EBX_EDI_IB = 3684;

    public static final int M_GS_4EBP_EAX_IB = 3685;
    public static final int M_GS_4EBP_ECX_IB = 3686;
    public static final int M_GS_4EBP_EDX_IB = 3687;
    public static final int M_GS_4EBP_EBX_IB = 3688;
    public static final int M_GS_4EBP_ESP_IB = 3689;
    public static final int M_GS_5EBP_IB = 3690;
    public static final int M_GS_4EBP_ESI_IB = 3691;
    public static final int M_GS_4EBP_EDI_IB = 3692;

    public static final int M_GS_4ESI_EAX_IB = 3693;
    public static final int M_GS_4ESI_ECX_IB = 3694;
    public static final int M_GS_4ESI_EDX_IB = 3695;
    public static final int M_GS_4ESI_EBX_IB = 3696;
    public static final int M_GS_4ESI_ESP_IB = 3697;
    public static final int M_GS_4ESI_EBP_IB = 3698;
    public static final int M_GS_5ESI_IB = 3699;
    public static final int M_GS_4ESI_EDI_IB = 3700;

    public static final int M_GS_4EDI_EAX_IB = 3701;
    public static final int M_GS_4EDI_ECX_IB = 3702;
    public static final int M_GS_4EDI_EDX_IB = 3703;
    public static final int M_GS_4EDI_EBX_IB = 3704;
    public static final int M_GS_4EDI_ESP_IB = 3705;
    public static final int M_GS_4EDI_EBP_IB = 3706;
    public static final int M_GS_4EDI_ESI_IB = 3707;
    public static final int M_GS_5EDI_IB = 3708;

    public static final int M_GS_9EAX_IB = 3709;
    public static final int M_GS_8EAX_ECX_IB = 3710;
    public static final int M_GS_8EAX_EDX_IB = 3711;
    public static final int M_GS_8EAX_EBX_IB = 3712;
    public static final int M_GS_8EAX_ESP_IB = 3713;
    public static final int M_GS_8EAX_EBP_IB = 3714;
    public static final int M_GS_8EAX_ESI_IB = 3715;
    public static final int M_GS_8EAX_EDI_IB = 3716;

    public static final int M_GS_8ECX_EAX_IB = 3717;
    public static final int M_GS_9ECX_IB = 3718;
    public static final int M_GS_8ECX_EDX_IB = 3719;
    public static final int M_GS_8ECX_EBX_IB = 3720;
    public static final int M_GS_8ECX_ESP_IB = 3721;
    public static final int M_GS_8ECX_EBP_IB = 3722;
    public static final int M_GS_8ECX_ESI_IB = 3723;
    public static final int M_GS_8ECX_EDI_IB = 3724;

    public static final int M_GS_8EDX_EAX_IB = 3725;
    public static final int M_GS_8EDX_ECX_IB = 3726;
    public static final int M_GS_9EDX_IB = 3727;
    public static final int M_GS_8EDX_EBX_IB = 3728;
    public static final int M_GS_8EDX_ESP_IB = 3729;
    public static final int M_GS_8EDX_EBP_IB = 3730;
    public static final int M_GS_8EDX_ESI_IB = 3731;
    public static final int M_GS_8EDX_EDI_IB = 3732;

    public static final int M_GS_8EBX_EAX_IB = 3733;
    public static final int M_GS_8EBX_ECX_IB = 3734;
    public static final int M_GS_8EBX_EDX_IB = 3735;
    public static final int M_GS_9EBX_IB = 3736;
    public static final int M_GS_8EBX_ESP_IB = 3737;
    public static final int M_GS_8EBX_EBP_IB = 3738;
    public static final int M_GS_8EBX_ESI_IB = 3739;
    public static final int M_GS_8EBX_EDI_IB = 3740;

    public static final int M_GS_8EBP_EAX_IB = 3741;
    public static final int M_GS_8EBP_ECX_IB = 3742;
    public static final int M_GS_8EBP_EDX_IB = 3743;
    public static final int M_GS_8EBP_EBX_IB = 3744;
    public static final int M_GS_8EBP_ESP_IB = 3745;
    public static final int M_GS_9EBP_IB = 3746;
    public static final int M_GS_8EBP_ESI_IB = 3747;
    public static final int M_GS_8EBP_EDI_IB = 3748;

    public static final int M_GS_8ESI_EAX_IB = 3749;
    public static final int M_GS_8ESI_ECX_IB = 3750;
    public static final int M_GS_8ESI_EDX_IB = 3751;
    public static final int M_GS_8ESI_EBX_IB = 3752;
    public static final int M_GS_8ESI_ESP_IB = 3753;
    public static final int M_GS_8ESI_EBP_IB = 3754;
    public static final int M_GS_9ESI_IB = 3755;
    public static final int M_GS_8ESI_EDI_IB = 3756;
    
    public static final int M_GS_8EDI_EAX_IB = 3757;
    public static final int M_GS_8EDI_ECX_IB = 3758;
    public static final int M_GS_8EDI_EDX_IB = 3759;
    public static final int M_GS_8EDI_EBX_IB = 3760;
    public static final int M_GS_8EDI_ESP_IB = 3761;
    public static final int M_GS_8EDI_EBP_IB = 3762;
    public static final int M_GS_8EDI_ESI_IB = 3763;
    public static final int M_GS_9EDI_IB = 3764;

    //SIB + ID Operands
    public static final int M_GS_EAX_ECX_ID = 3765;
    public static final int M_GS_EAX_EDX_ID = 3766;
    public static final int M_GS_EAX_EBX_ID = 3767;
    public static final int M_GS_EAX_ESP_ID = 3768;
    public static final int M_GS_EAX_EBP_ID = 3769;
    public static final int M_GS_EAX_ESI_ID = 3770;
    public static final int M_GS_EAX_EDI_ID = 3771;

    public static final int M_GS_ECX_EDX_ID = 3772;
    public static final int M_GS_ECX_EBX_ID = 3773;
    public static final int M_GS_ECX_ESP_ID = 3774;
    public static final int M_GS_ECX_EBP_ID = 3775;
    public static final int M_GS_ECX_ESI_ID = 3776;
    public static final int M_GS_ECX_EDI_ID = 3777;

    public static final int M_GS_EDX_EBX_ID = 3778;
    public static final int M_GS_EDX_ESP_ID = 3779;
    public static final int M_GS_EDX_EBP_ID = 3780;
    public static final int M_GS_EDX_ESI_ID = 3781;
    public static final int M_GS_EDX_EDI_ID = 3782;

    public static final int M_GS_EBX_ESP_ID = 3783;
    public static final int M_GS_EBX_EBP_ID = 3784;
    public static final int M_GS_EBX_ESI_ID = 3785;
    public static final int M_GS_EBX_EDI_ID = 3786;

    public static final int M_GS_ESP_ID = 3787;

    public static final int M_GS_EBP_ESP_ID = 3788;
    public static final int M_GS_EBP_ESI_ID = 3789;
    public static final int M_GS_EBP_EDI_ID = 3790;

    public static final int M_GS_ESI_ESP_ID = 3791;
    public static final int M_GS_ESI_EDI_ID = 3792;

    public static final int M_GS_EDI_ESP_ID = 3793;

    public static final int M_GS_3EAX_ID = 3794;
    public static final int M_GS_2EAX_ECX_ID = 3795;
    public static final int M_GS_2EAX_EDX_ID = 3796;
    public static final int M_GS_2EAX_EBX_ID = 3797;
    public static final int M_GS_2EAX_ESP_ID = 3798;
    public static final int M_GS_2EAX_EBP_ID = 3799;
    public static final int M_GS_2EAX_ESI_ID = 3800;
    public static final int M_GS_2EAX_EDI_ID = 3801;

    public static final int M_GS_2ECX_EAX_ID = 3802;
    public static final int M_GS_3ECX_ID = 3803;
    public static final int M_GS_2ECX_EDX_ID = 3804;
    public static final int M_GS_2ECX_EBX_ID = 3805;
    public static final int M_GS_2ECX_ESP_ID = 3806;
    public static final int M_GS_2ECX_EBP_ID = 3807;
    public static final int M_GS_2ECX_ESI_ID = 3808;
    public static final int M_GS_2ECX_EDI_ID = 3809;

    public static final int M_GS_2EDX_EAX_ID = 3810;
    public static final int M_GS_2EDX_ECX_ID = 3811;
    public static final int M_GS_3EDX_ID = 3812;
    public static final int M_GS_2EDX_EBX_ID = 3813;
    public static final int M_GS_2EDX_ESP_ID = 3814;
    public static final int M_GS_2EDX_EBP_ID = 3815;
    public static final int M_GS_2EDX_ESI_ID = 3816;
    public static final int M_GS_2EDX_EDI_ID = 3817;

    public static final int M_GS_2EBX_EAX_ID = 3818;
    public static final int M_GS_2EBX_ECX_ID = 3819;
    public static final int M_GS_2EBX_EDX_ID = 3820;
    public static final int M_GS_3EBX_ID = 3821;
    public static final int M_GS_2EBX_ESP_ID = 3822;
    public static final int M_GS_2EBX_EBP_ID = 3823;
    public static final int M_GS_2EBX_ESI_ID = 3824;
    public static final int M_GS_2EBX_EDI_ID = 3825;

    public static final int M_GS_2EBP_EAX_ID = 3826;
    public static final int M_GS_2EBP_ECX_ID = 3827;
    public static final int M_GS_2EBP_EDX_ID = 3828;
    public static final int M_GS_2EBP_EBX_ID = 3829;
    public static final int M_GS_2EBP_ESP_ID = 3830;
    public static final int M_GS_3EBP_ID = 3831;
    public static final int M_GS_2EBP_ESI_ID = 3832;
    public static final int M_GS_2EBP_EDI_ID = 3833;

    public static final int M_GS_2ESI_EAX_ID = 3834;
    public static final int M_GS_2ESI_ECX_ID = 3835;
    public static final int M_GS_2ESI_EDX_ID = 3836;
    public static final int M_GS_2ESI_EBX_ID = 3837;
    public static final int M_GS_2ESI_ESP_ID = 3838;
    public static final int M_GS_2ESI_EBP_ID = 3839;
    public static final int M_GS_3ESI_ID = 3840;
    public static final int M_GS_2ESI_EDI_ID = 3841;

    public static final int M_GS_2EDI_EAX_ID = 3842;
    public static final int M_GS_2EDI_ECX_ID = 3843;
    public static final int M_GS_2EDI_EDX_ID = 3844;
    public static final int M_GS_2EDI_EBX_ID = 3845;
    public static final int M_GS_2EDI_ESP_ID = 3846;
    public static final int M_GS_2EDI_EBP_ID = 3847;
    public static final int M_GS_2EDI_ESI_ID = 3848;
    public static final int M_GS_3EDI_ID = 3849;

    public static final int M_GS_5EAX_ID = 3850;
    public static final int M_GS_4EAX_ECX_ID = 3851;
    public static final int M_GS_4EAX_EDX_ID = 3852;
    public static final int M_GS_4EAX_EBX_ID = 3853;
    public static final int M_GS_4EAX_ESP_ID = 3854;
    public static final int M_GS_4EAX_EBP_ID = 3855;
    public static final int M_GS_4EAX_ESI_ID = 3856;
    public static final int M_GS_4EAX_EDI_ID = 3857;

    public static final int M_GS_4ECX_EAX_ID = 3858;
    public static final int M_GS_5ECX_ID = 3859;
    public static final int M_GS_4ECX_EDX_ID = 3860;
    public static final int M_GS_4ECX_EBX_ID = 3861;
    public static final int M_GS_4ECX_ESP_ID = 3862;
    public static final int M_GS_4ECX_EBP_ID = 3863;
    public static final int M_GS_4ECX_ESI_ID = 3864;
    public static final int M_GS_4ECX_EDI_ID = 3865;

    public static final int M_GS_4EDX_EAX_ID = 3866;
    public static final int M_GS_4EDX_ECX_ID = 3867;
    public static final int M_GS_5EDX_ID = 3868;
    public static final int M_GS_4EDX_EBX_ID = 3869;
    public static final int M_GS_4EDX_ESP_ID = 3870;
    public static final int M_GS_4EDX_EBP_ID = 3871;
    public static final int M_GS_4EDX_ESI_ID = 3872;
    public static final int M_GS_4EDX_EDI_ID = 3873;

    public static final int M_GS_4EBX_EAX_ID = 3874;
    public static final int M_GS_4EBX_ECX_ID = 3875;
    public static final int M_GS_4EBX_EDX_ID = 3876;
    public static final int M_GS_5EBX_ID = 3877;
    public static final int M_GS_4EBX_ESP_ID = 3878;
    public static final int M_GS_4EBX_EBP_ID = 3879;
    public static final int M_GS_4EBX_ESI_ID = 3880;
    public static final int M_GS_4EBX_EDI_ID = 3881;

    public static final int M_GS_4EBP_EAX_ID = 3882;
    public static final int M_GS_4EBP_ECX_ID = 3883;
    public static final int M_GS_4EBP_EDX_ID = 3884;
    public static final int M_GS_4EBP_EBX_ID = 3885;
    public static final int M_GS_4EBP_ESP_ID = 3886;
    public static final int M_GS_5EBP_ID = 3887;
    public static final int M_GS_4EBP_ESI_ID = 3888;
    public static final int M_GS_4EBP_EDI_ID = 3889;

    public static final int M_GS_4ESI_EAX_ID = 3890;
    public static final int M_GS_4ESI_ECX_ID = 3891;
    public static final int M_GS_4ESI_EDX_ID = 3892;
    public static final int M_GS_4ESI_EBX_ID = 3893;
    public static final int M_GS_4ESI_ESP_ID = 3894;
    public static final int M_GS_4ESI_EBP_ID = 3895;
    public static final int M_GS_5ESI_ID = 3896;
    public static final int M_GS_4ESI_EDI_ID = 3897;

    public static final int M_GS_4EDI_EAX_ID = 3898;
    public static final int M_GS_4EDI_ECX_ID = 3899;
    public static final int M_GS_4EDI_EDX_ID = 3900;
    public static final int M_GS_4EDI_EBX_ID = 3901;
    public static final int M_GS_4EDI_ESP_ID = 3902;
    public static final int M_GS_4EDI_EBP_ID = 3903;
    public static final int M_GS_4EDI_ESI_ID = 3904;
    public static final int M_GS_5EDI_ID = 3905;

    public static final int M_GS_9EAX_ID = 3906;
    public static final int M_GS_8EAX_ECX_ID = 3907;
    public static final int M_GS_8EAX_EDX_ID = 3908;
    public static final int M_GS_8EAX_EBX_ID = 3909;
    public static final int M_GS_8EAX_ESP_ID = 3910;
    public static final int M_GS_8EAX_EBP_ID = 3911;
    public static final int M_GS_8EAX_ESI_ID = 3912;
    public static final int M_GS_8EAX_EDI_ID = 3913;

    public static final int M_GS_8ECX_EAX_ID = 3914;
    public static final int M_GS_9ECX_ID = 3915;
    public static final int M_GS_8ECX_EDX_ID = 3916;
    public static final int M_GS_8ECX_EBX_ID = 3917;
    public static final int M_GS_8ECX_ESP_ID = 3918;
    public static final int M_GS_8ECX_EBP_ID = 3919;
    public static final int M_GS_8ECX_ESI_ID = 3920;
    public static final int M_GS_8ECX_EDI_ID = 3921;

    public static final int M_GS_8EDX_EAX_ID = 3922;
    public static final int M_GS_8EDX_ECX_ID = 3923;
    public static final int M_GS_9EDX_ID = 3924;
    public static final int M_GS_8EDX_EBX_ID = 3925;
    public static final int M_GS_8EDX_ESP_ID = 3926;
    public static final int M_GS_8EDX_EBP_ID = 3927;
    public static final int M_GS_8EDX_ESI_ID = 3928;
    public static final int M_GS_8EDX_EDI_ID = 3929;

    public static final int M_GS_8EBX_EAX_ID = 3930;
    public static final int M_GS_8EBX_ECX_ID = 3931;
    public static final int M_GS_8EBX_EDX_ID = 3932;
    public static final int M_GS_9EBX_ID = 3933;
    public static final int M_GS_8EBX_ESP_ID = 3934;
    public static final int M_GS_8EBX_EBP_ID = 3935;
    public static final int M_GS_8EBX_ESI_ID = 3936;
    public static final int M_GS_8EBX_EDI_ID = 3937;

    public static final int M_GS_8EBP_EAX_ID = 3938;
    public static final int M_GS_8EBP_ECX_ID = 3939;
    public static final int M_GS_8EBP_EDX_ID = 3940;
    public static final int M_GS_8EBP_EBX_ID = 3941;
    public static final int M_GS_8EBP_ESP_ID = 3942;
    public static final int M_GS_9EBP_ID = 3943;
    public static final int M_GS_8EBP_ESI_ID = 3944;
    public static final int M_GS_8EBP_EDI_ID = 3945;

    public static final int M_GS_8ESI_EAX_ID = 3946;
    public static final int M_GS_8ESI_ECX_ID = 3947;
    public static final int M_GS_8ESI_EDX_ID = 3948;
    public static final int M_GS_8ESI_EBX_ID = 3949;
    public static final int M_GS_8ESI_ESP_ID = 3950;
    public static final int M_GS_8ESI_EBP_ID = 3951;
    public static final int M_GS_9ESI_ID = 3952;
    public static final int M_GS_8ESI_EDI_ID = 3953;
    
    public static final int M_GS_8EDI_EAX_ID = 3954;
    public static final int M_GS_8EDI_ECX_ID = 3955;
    public static final int M_GS_8EDI_EDX_ID = 3956;
    public static final int M_GS_8EDI_EBX_ID = 3957;
    public static final int M_GS_8EDI_ESP_ID = 3958;
    public static final int M_GS_8EDI_EBP_ID = 3959;
    public static final int M_GS_8EDI_ESI_ID = 3960;
    public static final int M_GS_9EDI_ID = 3961;
}
