;
;  Stream viewer (text) SVTXT.COM
;    syntax: type filename | svtxt
;
;    Designed and programmed by Lo Hung Che
;    Copyright (C) BAHCL 2004
;
;  Dedicated to FreeDOS www.freedos.org
;    under the terms and license of GNU GPL version 2
;
org 100h
segment .text
            mov     sp,stackbot+512         ; stack size = 512 bytes
            mov     bx,sp
            mov     cx,4
            shr     bx,cl
            inc     bx
            mov     ax,ds
            add     ax,bx
            mov     [stream],ax           ; seg. address for data
            add     ax,1000h
            mov     [itable],ax           ; line index table

            call    HW_Setting
            call    FileType

            mov     ax,[fhandle]
            push    ax
            mov     ax,[ssize]
            push    ax
            call    Get_Data
            cmp     word [ssize],0
            jz      @0001                 ; no data at all

            call    Parse_Data
            call    Last_Line
            call    Clear_Screen
            call    Get_Scancode
            mov     bx,[fhandle]
            or      bx,bx
            jz      @0001
            mov     ax,3E00h              ; close file
            int     21h
@0001:
            call    Clear_Screen
            mov     ax,4C00h
            int     21h
;
; hardware setting
HW_Setting
            mov     ah,0Fh             ; set up display mode seg. address
            int     10h
            cmp     al,7               ; mono
            jnz     @0010
            mov     ax,0B000h
            mov     [vid_seg],ax
@0010:
            push    es
            mov     ax,40h
            mov     es,ax
            mov     ax,[es:4Ah]
            mov     [linewidth],ax
            xor     ax,ax
            mov     al,[es:84h]
            inc     ax
            mov     [lineperpage],ax
            pop     es
            ret
;
; Determine input file be stream/regular
FileType
            xor     ax,ax
            mov     si,80h                ; check command tail
            lodsb
            or      al,al
            jz      @0022                 ; stream
            mov     di,si
            add     di,ax
            xchg    ah,al
            stosb
@0020:
            lodsb
            cmp     al,20h
            jz      @0020
            dec     si
            mov     ax,3D00h              ; open file
            mov     dx,si
            int     21h
            jc      @0022
            call    File_Size                ; find file size
            push    es
            mov     ax,40h
            mov     es,ax
            mov     dx,[es:0F0h]          ; iaca intra application comm. area
            mov     cx,[es:0F2h]
            mov     ax,[es:0F4h]
            mov     [quitkey],ax
            xor     ax,ax
            mov     [es:0F0h],ax          ; clear iaca
            mov     [es:0F2h],ax
            mov     [es:0F4h],ax
            pop     es
            cmp     cx,[filesize+2]
            jb      @0021
            cmp     dx,[filesize]
            jb      @0021
            xor     cx,cx
            xor     dx,dx
@0021:
            mov     [fileptr],dx          ; store top line file offset
            mov     [fileptr+2],cx
            mov     [initpos0],dx         ; store top line file offset
            mov     [initpos1],cx
            mov     ax,fileptr
            push    ax
            call    Move_Ptr
@0022:
            ret
;
; get data from stream
Get_Data
            push    bp
            mov     bp,sp
            mov     ax,4201h
            mov     bx,[bp+6]                ; file handle
            xor     cx,cx
            xor     dx,dx
            int     21h
            mov     [fileptr],ax
            mov     [fileptr+2],dx

            push    ds
            mov     cx,[bp+4]
            mov     ax,[stream]
            mov     ds,ax
            mov     ax,3F00h                 ; read file
            xor     dx,dx
            mov     bx,[bp+6]                ; file handle
            int     21h

            mov     bx,ax
            mov     dl,LF
            mov     byte [bx],dl

            pop     ds
            mov     [ssize],ax
            pop     bp
            ret     4
;
; Parse data from stream                        ; find offset of each line
Parse_Data
            push    es
            push    ds
            mov     ax,[itable]
            mov     es,ax
            mov     cx,[ssize]
            mov     ax,[stream]
            mov     ds,ax
            xor     bx,bx
            xor     di,di
            xor     si,si
            xor     ax,ax
            stosw
@0030:
            lodsb
            cmp     si,cx
            jae     @0035
            cmp     al,CR
            jz      @0030
            cmp     al,TAB
            jnz     @0031
            call    Do_TAB
            jmp     @0033
@0031:
            cmp     al,LF
            jnz     @0032
            call    DO_LFCR
            jmp     @0033
@0032:
            inc     bx
@0033:
            mov     ax,[cs:linewidth]
            sub     ax,bx
            jnz     @0034
            mov     ax,si
            stosw
            xor     bx,bx
@0034:
            jmp     @0030
@0035:
            or      bx,bx                 ; data in last line
            jz      @0036
            stosw
@0036:
            pop     ds
            pop     es
            mov     ax,di
            shr     ax,1
            mov     [totlines],ax
            ret
;
;  Decide the last line
Last_Line
            mov    ax,[totlines]
            cmp    ax,[lineperpage]
            jna    @0040
            sub    ax,[lineperpage]
            dec    ax
            mov    [lastline],ax
@0040:
            ret
;
; clear the screen, send cursor home
Clear_Screen
            push    es
            mov     ax,[vid_seg]
            mov     es,ax
            xor     di,di
            mov     ax,0720h
            mov     cx,[lineperpage]
.loop       push    cx
            mov     cx,[linewidth]
            rep     stosw
            pop     cx
            loop    .loop
            pop     es
            mov     ah,2
            xor     bx,bx
            xor     dx,dx
            int     10h
            ret
;
; user interface
; get keyboard scancode
Get_Scancode
            mov     ax,[oldline]
            cmp     ax,[linenum]
            je      @0051
            mov     ax,[totlines]
            cmp     ax,[lineperpage]
            jb      @0050
            mov     ax,[lineperpage]
@0050:
            push    ax
            mov     ax,[linenum]
            mov     [oldline],ax
            push    ax
            call    Show_Data
            push    es
            mov     ax,40h
            mov     es,ax
            xor     ax,ax
            mov     [es:0F0h],ax
            pop     es
@0051:
            mov     ah,1
            int     16h
            jz      @0052
            xor     ax,ax
            int     16h
            cmp     ax,[quitkey]
            jne     @0053
            ret
@0052:
            push    es                       ; what mouse event?
            mov     ax,40h
            mov     es,ax
            mov     ax,[es:0F0h]
            pop     es
@0053:
            mov     cx,KEYS
            inc     cx
            mov     di,scancode
            mov     si,di
            repne   scasw
            jcxz    @0051
            mov     ax,di
            sub     ax,si
            dec     ax
            dec     ax

            mov     bx,procnames
            add     bx,ax
            call    [bx]
            cmp     ax,1
            jnz     Get_Scancode
            ret
;
; Display data to screen
Show_Data
            push    bp
            mov     bp,sp
            mov     cx,[bp+6]               ; lines to print
            xor     di,di
@nextline:
            mov     ax,[totlines]
            dec     ax
            cmp     ax,[bp+4]
            jbe     @0060
            push    cx
            mov     ax,[bp+4]               ; line# to print
            call    Make_String
            inc     word [bp+4]
            push    es
            mov     ax,[vid_seg]
            mov     es,ax
            mov     cx,[linewidth]           ; line size
            mov     si,buffer
            mov     ah,07
@nextbyte:
            lodsb
            stosw
            loop    @nextbyte
            pop     es
            pop     cx
            loop    @nextline
@0060:

            mov     ax,[bp+4]
            pop     bp
            ret     4
;
;
; format a string for display
Make_String
            push    di
            mov     si,ax
            shl     si,1
            mov     di,buffer
            mov     cx,[linewidth]           ; clear the line
            mov     al,20h
            rep     stosb
            mov     di,buffer
            xor     dx,dx
            push    ds
            mov     ax,[itable]
            mov     ds,ax
            lodsw
            pop     ds
            mov     si,ax
            push    ds
            mov     ax,[stream]
            mov     ds,ax
            xor     bx,bx
@nextchar:
            lodsb
            cmp     al,CR
            jz      @nextchar
            cmp     al,LF
            jz      @eoline                  ; End of line

            cmp     al,TAB
            jnz     @0070
            call    Do_TAB
            add     di,ax
            jmp     @0071
@0070:
            stosb
            inc     bx
@0071:
            cmp     bx,[cs:linewidth]
            jae     @eoline
            jmp     @nextchar
@eoline
            pop     ds
            pop     di
            ret
;
; handle TAB
Do_TAB
            push    bx
            mov     al,bl
            xor     ah,ah
            mov     bl,TABSTOP
            div     bl
            mov     al,TABSTOP
            sub     al,ah
            xor     ah,ah
            pop     bx
            add     bx,ax
            ret
;
; handles LF CR
DO_LFCR
            mov     bx,[cs:linewidth]
            ret
;
; key = escape
K_Esc
            mov     ax,1
            ret
;
; key = up
K_Up
            mov     ax,[linenum]
            sub     ax,1
            jns     @0202
            mov     ax,[fileptr]
            add     ax,[fileptr+2]
            jz      @0202
            mov     ax,[linenum]
            add     ax,[lineperpage]
            dec     ax
            push    ax
            call    Up_Pup
            cmp     byte[bof],1
            jne     @0202
            sub     ax,[lineperpage]
@0202:
            mov     [linenum],ax
            xor     ax,ax
            ret
;
; key = page up
K_P_Up
            mov     ax,[linenum]
            sub     ax,[lineperpage]
            jns     @0210
            mov     ax,[fileptr]
            add     ax,[fileptr+2]
            jz      @0210
            mov     ax,[linenum]
            push    ax
            call    Up_Pup
            cmp     byte[bof],1
            jne     @0210
            sub     ax,[lineperpage]
@0210:
            mov     [linenum],ax
            xor     ax,ax
            ret
;
; key = down
K_Dn
            mov     ax,[linenum]
            add     ax,1
            cmp     ax,[lastline]
            jbe     @0220
            call    Test_EOF
            cmp     byte[eof],1
            jne     @0221
            mov     ax,[oldline]
            jmp     @0220
@0221:
            call    Dn_Pdn
            mov     ax,1
@0220:
            mov     [linenum],ax
            xor     ax,ax
            ret
;
; key = page down
K_P_Dn
            mov     ax,[linenum]
            add     ax,[lineperpage]
            cmp     ax,[lastline]
            jb      @0231
            call    Test_EOF
            cmp     byte[eof],1
            jne     @0230
            mov     ax,[lastline]
            jmp     @0231
@0230:
            call    Dn_Pdn
            mov     ax,[lineperpage]
@0231:
            mov     [linenum],ax
            xor     ax,ax
            ret
;
; key = home
K_Home
            mov     ax,bofaddr
            call    Read_File
            mov     word[oldline],1
            mov     word[linenum],0
            xor     ax,ax
            ret
;
; key = end
K_End
            mov     ax,eofaddr
            call    Read_File
            mov     word[oldline],1
            mov     word[linenum],ax
            xor     ax,ax
            ret
;
; key = Alt-1
K_A1
            mov     ax,initpos0
            call    Read_File
            xor     ax,ax
            mov     word[oldline],1
            mov     word[linenum],ax
            xor     ax,ax
            ret
;
;  find the file size
File_Size
            mov     [fhandle],ax
            mov     ax,4202h
            mov     bx,[fhandle]
            xor     cx,cx
            xor     dx,dx
            int     21h
            mov     [filesize],ax
            mov     [filesize+2],dx
            sub     ax,MAXSIZE
            jnc     @0300
            sbb     dx,0
            jc      @0301
@0300:
            mov     [eofaddr],ax
            mov     [eofaddr+2],dx
@0301:
            ret
;
;
; move file pointer to cx:dx
Move_Ptr
            push    bp
            mov     bp,sp
            mov     bx,[bp+4]
            mov     ax,4200h
            mov     cx,[bx+2]
            mov     dx,[bx]
            mov     bx,[fhandle]
            int     21h
            pop     bp
            ret     2
;
; get the offset address of a line number within a chunk of memory
Mem_Tell
            push    bp
            mov     bp,sp
            push    es
            mov     ax,[itable]           ; index table
            mov     es,ax
            mov     di,[bp+4]             ; the line number
            shl     di,1
            mov     ax,[es:di]
            pop     es
            pop     bp
            ret     2
;
;
; for up/page up
Up_Pup
            push    bp
            mov     bp,sp
            mov     byte[bof],0
            mov     word [ssize],MAXSIZE
            mov     ax,[bp+4]
            push    ax
            call    Mem_Tell
            mov     dx,[fileptr+2]
            add     ax,[fileptr]
            adc     dx,0
            sub     ax,MAXSIZE
            sbb     dx,0
            jns     @0343
@0342:
            mov     byte[bof],1
            add     ax,MAXSIZE
            mov     [residual],ax
            xor     ax,ax
            xor     dx,dx
@0343:
            mov     [fileptr],ax
            mov     [fileptr+2],dx
            mov     ax,fileptr
            call    Read_File
@0344:
            cmp     byte[bof],1
            jne     @0345
            call    Look_up
@0345:
            pop     bp
            ret     2
;
;
; for down/page down
Dn_Pdn
            mov     word [ssize],MAXSIZE
            mov     ax,[linenum]
            push    ax
            call    Mem_Tell
            mov     dx,[fileptr+2]
            add     ax,[fileptr]
            adc     dx,0
            cmp     dx,[filesize+2]
            jb      @0350
            cmp     ax,[filesize]
            jb      @0350
            mov     ax,[lastline]
            jmp     @0351
@0350:
            mov     [fileptr],ax
            mov     [fileptr+2],dx
            mov     ax,fileptr
            call    Read_File
@0351:
            ret
;
; Read file
Read_File
            push    ax
            call    Move_Ptr
            mov     ax,[fhandle]
            push    ax
            mov     ax,MAXSIZE
            push    ax
            call    Get_Data
            call    Parse_Data
            call    Last_Line
            ret
;
;
; find line number
; When up/pageup key hit bof file access in reverse fashion
Look_up
            mov   ax,[itable]
            push  es
            mov   es,ax
            mov   cx,[totlines]
            xor   di,di
            mov   ax,[residual]
            repne scasw
            pop   es
            shr   di,1
            dec   di
            mov   ax,di
            ret
;
;  eof - When file pointer + stream size = file size
Test_EOF
            mov   byte [eof],0
            mov   ax,[fileptr]
            mov   dx,[fileptr+2]
            add   ax,[ssize]
            adc   dx,0
            cmp   dx,[filesize+2]
            jb    @0400
            cmp   ax,[filesize]
            jb    @0400
            mov   byte [eof],1
@0400:
            ret
;
segment .data
TABSTOP        EQU     8
TAB            EQU     9
CR             EQU     0Dh
LF             EQU     0Ah
MAXSIZE        EQU     0FFF0h
fhandle        dw      0
vid_seg        dw      0B800h          ; color
lineperpage    dw      0
linewidth      dw      0
scancode       dw      011Bh,4800h,4900h,5000h,5100h,4700h,4F00h,7800h
procnames      dw      K_Esc,K_Up,K_P_Up,K_Dn,K_P_Dn,K_Home,K_End,K_A1
KEYS           equ     (procnames-scancode)/2
quitkey        dw      0
stream         dw      0               ; stream segment address
ssize          dw      MAXSIZE         ; stream size
residual       dw      0               ;
itable         dw      0               ; line index segment address
oldline        dw      7               ; original display line
linenum        dw      0               ; line number
totlines       dw      0               ; total lines in a single read
lastline       dw      0               ; last top line
bofaddr        dd      0
eofaddr        dd      0
fileptr        dd      0               ; file pointer
filesize       dd      0
initpos0       dw      0
initpos1       dw      0
bof            db      0               ; begin of file
eof            db      0               ; end of file
buffer         db      'Designed and programmed by Lo Hung Che.',0
               db      'Copyright (C) BAHCL 2005, all rights reserved.',0
stackbot
;
;
