;
;  This file and its related programs are freewares distributed
;  under the terms of GNU GPL version 2.
;
;  Assembly language subroutines callable by pg.c
;  Originally, some routines resided in pg.c are
;     extracted here to make pg easier to debug.
;
;  Author:
;  (c) 1995-1998 Bill Weinman, wew@bearnet.com
;  Maintainer:
;  2004 BAHCL  e-mail:
;
;  Assemble:
;     nasm16 -f obj pgasm.asm -o pgasm.obj
;     The object file is linkable with tlink
;
; ***** Always save si,di if ever used in asm subroutine *****
;

; global = assembly language function names
        global  _getbiosinfo, _mvaddch, _getstr, _scroll_up, _scroll_down,
        global  _kbget, _read_infile, _move, _iaca

; extern = variables defined in caller C program
        extern  _vidrow, _vidcol, _vidchar, _vidattr, _VideoRegen
        extern  _DispRows, _DispCols, _DispMode
        extern  _infilename, _lineaddr, _groups, _numlines, _lpg
;
;
;
; Moved here from pg.h
%define BIOS_DATA_SEG 40h
%define DISP_MODE     49h
%define DISP_COLS     4Ah
%define DISP_ROWS     84h
%define CURSOR        50h
%define MAXSIZELINE   256

segment _TEXT   CLASS=CODE

;
; Get BIOS information
;   moved here from pg.c
_getbiosinfo    ;
        push    es
        mov ax, BIOS_DATA_SEG
        mov es, ax
        mov al, [es:DISP_MODE]
        mov [_DispMode], al
        mov ax, [es:DISP_COLS]
        mov [_DispCols], ax
        mov al, [es:DISP_ROWS]         ; actually last row
        inc al
        mov [_DispRows], al
        pop     es
        ret
;
;
; Move cursor then print a char with attribute
;   moved here from pg.c
;   with some modification
_mvaddch        ; parm : vidrow, vidcol, vidchar, vidattr
        push    bp
        mov     bp,sp
        push    di
        push es
        mov ax, BIOS_DATA_SEG
        mov es, ax
        mov al, [bp+6]          ; col
        mov ah, [bp+4]          ; row
        mov [es:CURSOR], ax
        push ax
        mov al, ah
        xor ah, ah
        mov bx, [_DispCols]     ; offset = vidrow * DispCols + vidrow
        mul bl
        pop bx
        xor bh, bh              ; add in the col
        add ax, bx
        shl ax, 1               ; * 2 for word based
        mov di, ax              ; zero origin for regen
        mov ax, [_VideoRegen]
        mov es, ax
        mov ah, [bp+10]         ; attr
        mov al, [bp+8]          ; char
        stosw
        pop es
        pop     di
        pop     bp
        ret
;
; Move cursor to row, column, page 0
_move
                push    bp
                mov     bp,sp
                mov     ah, 2
                xor     bh, bh
                mov     dh, byte [bp+4]         ; row
                mov     dl, byte [bp+6]         ; column
                int     10h
                pop     bp
                ret
;
; Intra application communication area 40:F0..FF
_iaca
                push    bp
                mov     bp,sp
                push    ds
                mov     ax,40h
                mov     ds,ax
                mov     bx,0F0h
                mov     ax,[bp+4]
                mov     [bx],ax                 ; offset lsw
                mov     ax,[bp+6]
                mov     [bx+2],ax               ; offset msw
                mov     ax,[bp+8]
                mov     [bx+4],ax               ; exit key
                pop     ds
                pop     bp
                ret
;
;
; get a string into buffer
_getstr         ; parm : buffer addr
                push    bp
                mov     bp,sp
                push    si
                mov     ah,0Ah                  ; get a string into buffer
                mov     dx,[bp+4]               ; buffer address
                int     21h

                mov     si,dx                   ; make a string null terminated
                inc     si                      ; actual number of chars entered
                lodsb
                cbw
                add     si,ax                   ; get end of string position
                xor     ax,ax
                mov     [si],al                 ; null terminated
                pop     si
                pop     bp
                ret
;
;
;   Scroll up an area of the screen
_scroll_up       ; parm : x1,y1,x2,y2,lines
                push    bp
                mov     bp,sp
                mov     bh,07
                mov     cl,[bp+4]                 ; x1
                mov     ch,[bp+6]                 ; y1
                mov     dl,[bp+8]                 ; x2
                mov     dh,[bp+10]                ; y2
                mov     al,[bp+12]                ; lines
                mov     ah,06
                int     10h
                pop     bp
                ret
;
;  Get keyboard scan code(AH) and char code(AL)
;  wait until a keypressed
_kbget
                xor     ax,ax
                int     16h
                ret
;
;
get_memory
                mov     ax,4800h                ; get memory
                mov     bx,1000h                ; = 64k = 65536 bytes
                int     21h
                mov     [fbuffer],ax            ; the allocated memory seg addr
                ret
;
;
free_memory
                mov     ax,[fbuffer]            ; release memory
                push    es
                mov     es,ax
                mov     ax,4900h
                int     21h
                pop     es
                ret
;
;
; breaks the heap limit
; Supercharger
_read_infile  ; read the infile
                xor     ax,ax
                mov     word [linidx],ax
                mov     word [grpidx],ax
                mov     word [tfmsw],ax
                mov     word [tflsw],ax
                push    si                      ; save important registers
                push    di
                call    get_memory
                mov     ax,3D00h                ; open file
                mov     dx,[_infilename]        ; file name
                int     21h
                mov     [fhandle],ax            ; save file handle

@0001:
                call    Move_file_ptr           ; move file pointer to
                mov     ax,3F00h                ; read file
                mov     bx,[fhandle]            ; file handle
                mov     cx,0FFF0h
                mov     dx,[fbuffer]
                push    ds                      ; save ds
                mov     ds,dx
                xor     dx,dx
                int     21h
                pop     ds                      ; restore ds
                jc      @eofile                 ; read error
                and     ax,ax                   ; read nothing?
                jz      @eofile
                mov     [bytesread],ax          ; bytes read

                call    Scan_CRLF               ; Scan all chars = LF = 0Ah

                mov     ax,[bytesread]
                cmp     ax,0FFF0h               ; is it eof?
                jz      @0001                   ; not yet
@eofile:
                call    free_memory
                mov     ax,3E00h                ; close infile
                mov     bx,[fhandle]
                int     21h
                pop     di
                pop     si
                cmp     byte [lastbyte],LF
                jz      @0002
                add     word [_numlines],1      ; last line
                jnc     @0002
                inc     word [_numlines+2]
@0002:
                ret
;
; Move file pointer
Move_file_ptr  ; move file pointer to specific position
                mov     ah,42h
                mov     al,0                    ; 0 = Set, 1=Cur 2=End
                mov     bx,[fhandle]
                mov     cx,[tfmsw]              ; most sig word
                mov     dx,[tflsw]              ; least sig word
                int     21h
                ret
;
;
;
; Scan the Carriage Return char in buffer
Scan_CRLF   ; scan a byte = LF
                push    es
                mov     ax,[fbuffer]
                mov     es,ax
                xor     di,di
                call    Load_index
                mov     cx,[bytesread]
@again:
                mov     [counter],cx
                mov     al,LF
                repnz   scasb
                jz      @LF_found
                jcxz    @exhaust
@LF_found:
                push    cx
                mov     ax,[counter]            ; calc line length
                sub     ax,cx
                call    Add_Line
                xchg    dx,ax
                or      ax,ax
                jz      @0008
                call    New_Line                ; update file offset
@0008:
                pop     cx
                or      cx,cx
                jnz     @again

@exhaust:       ; end of buffer but no LF
                mov     ax,[counter]
                cmp     ax,MAXSIZELINE
                jb      @0007
                call    Add_Line
@0007:          mov     al,[es:di-1]
                mov     [lastbyte],al
                pop     es
                ret
;
; Loading indexes to array _lineaddr, _group
Load_index
                push    bx
                push    ax
                push    dx
                mov     ax,word [linidx]        ; linidx { 0..1023 }
                xor     dx,dx
                mov     bx,word [_lpg]          ; lines per group
                div     bx
                add     word [grpidx],ax
                mov     word [linidx],dx
                mov     bx,[grpidx]
                or      bx,bx
                ja      @0003
                xchg    ax,dx
                mov     bx,_lineaddr
                shl     ax,1                    ; mult by 4
                shl     ax,1
                add     bx,ax                   ; calc line array index
                mov     ax,[tflsw]              ; low order word
                mov     [bx],ax                 ; store in line array
                mov     ax,[tfmsw]              ; high order word
                mov     [bx+2],ax               ; makes a long integer
@0003:
                mov     ax,word [linidx]
                or      ax,ax
                jnz     @0004                   ; same group
; new group
                mov     bx,_groups
                mov     ax,word [grpidx]        ; get group id
                shl     ax,1                    ; mult by 4
                shl     ax,1
                add     bx,ax                   ; calc group array index
                mov     ax,[tflsw]              ; low order word
                mov     [bx],ax                 ; store in group array
                mov     ax,[tfmsw]              ; high order word
                mov     [bx+2],ax               ; makes a long integer
@0004:
                pop     dx
                pop     ax
                pop     bx
                ret
;
Add_Line
                mov     bx,MAXSIZELINE
                xor     dx,dx
                div     bx
                push    dx
                or      ax,ax
                jz      @0009
                mov     cx,ax
.loop           push    cx
                mov     ax,MAXSIZELINE
                call    New_Line                ; update file offset
                pop     cx
                loop    .loop
@0009
                pop     dx
                ret

;
; Test if file pointer in low order word overflows?
New_Line
                add     ax,[tflsw]
                jnc     @0005
                inc     word [tfmsw]            ; overflow
                clc
@0005:
                mov     [tflsw],ax
                add     word [_numlines],1
                jnc     @0006
                inc     word [_numlines+2]
@0006:
                inc     word [linidx]
                call    Load_index
                ret
;
;
segment _DATA   CLASS=DATA
LF              EQU     0Ah
tflsw           dw      0
tfmsw           dw      0
fhandle         dw      0                       ; infile handle
fbuffer         dw      0                       ; Seg addr of alloc memory
bytesread       dw      0                       ; # of bytes read last attempt
counter         dw      0                       ; byte count
linidx          dw      0                       ; line count
grpidx          dw      0                       ; group count
lastbyte        db      0
