/** HEXED.C     - HexEd 
 ** ------------- (c) 2013 Christopher Robert Evans; axiomfinity@ymail.com
 **
 ** This program is protected by the General Public License version 3.0
 ** -------------------------------------------------------------------------
     This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 ** -------------------------------------------------------------------------
 ** v1.0a      FEB - 10 - 2013       Hex Viewer/Editor for FreeDOS using Borland C 3.1
 ** v1.0c      FEB - 12 - 2013       Added dosmem free check, wont load if document
 **                                  is greater than ramavail.
 ** v1.0e      FEB - 13 - 2013       Added loadcolorcfg() as per request from freedos-user
 **                                  list.
 ** v1.0g      FEB - 17 - 2013       Made this compile on linux, 
 ** v1.1a                            Fixed ramfreeink.. so it works on linux 
 ** v1.1b                       9:57p Why is pgup/pgdn/arrows not working in linux?    
 ** v1.1c      FEB - 18 - 2013 10:31  added argc == 0 to fix coredump issue.    
 ** v1.1d                      13:00  Now reads multibyte terminal keyboard codes on linux
 ** v1.1f                      14:43  Set color to 7,0 make sure clrscr in dos works right    
 ** -------------------------------------------------------------------------
 **/

#ifdef __TURBOC__
#define FAR far
#define MSDOS 1
#else
#define FAR _far
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#ifdef MSDOS 
#include <conio.h>
#include <dos.h>
#include <bios.h>
#include <mem.h>
#else 
#include <sys/types.h>
#include <dirent.h>
#include <termios.h>
#include <unistd.h>
#include "/home/chris/nxdos/src/toolbox.h"
#endif

#define PNAME "hexed"
#define TITLE "HEXED"
#define COPYR "(c) 2013 Christopher Robert Evans"
#define VERSION "1.1g"
#define VTEXT "11g"
#define RULERTEXT "          0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15"
#define DISPROWS 21 
#define DISPCOLS 16

char * buffer;
long fpos;
long docusize = 0;
int changes = 0;
char *text[32];
long sect;
int getdisksect = 0;
int drivenum;
int done = 0;
long pd;
long ramkb = 0;
// ---------------- 
int bkcolor = 0;
int addrcolor = 4;
int numbcolor = 11;
int texcolor = 9;
int ctrlcolor = 1;
int highasciicolor = 13;

void help(void) {
	printf("HEXED [filename.ext]\n\n");
	printf("Views a file");
#ifdef MSDOS
        printf(" or drive sector");
#endif
        printf(" as hexadecimal.\n");
#ifdef MSDOS
        printf("HEXED -s [sector=0] [drive=128=C:] to read a disk sector from current disk.\n");
#endif
}

void notice(void) {
printf("\n\n");
printf("The software included in this product contains copyrighted software that is\n"); 
printf("licensed under the GPL. A copy of that license is included in the archive.\n");
printf("You may obtain the complete Corresponding Source code from us by downloading\n");
printf("the source code distribution archive at : \n\n");
printf("	        http://digitalatoll.com/pub/DMSOFT/"); 
printf(PNAME); printf(VTEXT); printf(".zip\n\n");
printf("Also, if you find this program of use then please consider contributing to\n");
printf("the source code and or sending a donation of atleast $5.00 to Chris Evans. \n");
printf("You can use the PayPal donate button on the digitalatoll.com.\n");
}

int RAMFreeInK(void) {
int xx = 0;

    xx = 511;  

#ifdef MSDOS
 asm{
     mov  ax, 0x4800
     mov  bx, 0xFFFF
     int  0x21
     mov  cl, 6
     shr  bx, cl
     mov  ax, bx
     mov  xx, ax
    }
#endif
 return(xx);
}

long filesize(const char* fname[]) {
long fsize;
FILE *fs;

     fs = fopen(fname, "rb");
     if (fs) {
	fseek(fs, 0, SEEK_END);
	fsize = ftell(fs);
	fclose(fs);
     }
  return(fsize);
}

void setcolors(char cc) {      
#ifdef MSDOS
      if ((cc >= '0') && (cc <= '9')) {
	 textcolor(numbcolor);
	 }
      if ((cc >= 'A') && (cc <= 'Z')) {
	 textcolor(texcolor);
	 }
      if (cc <= 0x1f) {
	 textcolor(ctrlcolor);
	 }
      if (cc > 127) {
         textcolor(highasciicolor);
         }
#endif
}

void showhex(long hn) {
long ptr;
int i;
int j;
#ifdef MSDOS 
short char ch;
short char cc;
#else 
char ch;
char cc;
#endif

/*
XXXXX : XX XX XX XX XX XX XX XX XX XX XX XX XX XX XX XX ................ 
*/

#ifdef MSDOS
     textbackground(bkcolor);
#endif
     for (i=0; i<DISPROWS; i++) {
      ptr = hn;
#ifdef MSDOS
      textcolor(addrcolor);
#endif
      printf("%6X",ptr);
      printf(" : ");
      for (j=0; j<DISPCOLS; j++) {
	ch = buffer[ptr+j];
	cc = toupper(ch);
      /*  printhex(ch); */
	// printf("%02x ", 0xFF & ((char*)mem)[i]);
	if (ptr+j <= docusize) {
              setcolors(cc);
	      printf("%02X",(0xff & ch));
	      printf(" ");
	   } else {
#ifdef MSDOS
              textcolor(8);
#endif
	      printf("00 ");
	   }
      }
      
      printf(" ");
      for (j=0; j<DISPCOLS; j++) {
	if (ptr+j <= docusize) {
	    ch = buffer[ptr+j];
            cc = toupper(ch);
            setcolors(cc); 
	    if (ch > 0x1f) {
	       printf("%c",ch); } else { printf("."); }
	   } else {
	     printf(".");
	   }
      }
      hn = hn + DISPCOLS;
      printf("\n");
     } // For
}

int savefile(char *ss[]) {
FILE *sf;
char c;
int saveerror;

    sf = fopen(ss, "w+");
    saveerror = -4;
    if (sf != NULL) {
      saveerror = 0;
      while (fpos <= docusize) {
	     c = buffer[fpos];
	     fputc(c, sf);
	     fpos++;
	     if (fpos>docusize) { break; } else {
		 /* printf("reading %d %c", fpos, c); */
		}
	    }
     fflush(sf);
     fclose(sf);
    }
 return(saveerror);
}

long findtext(unsigned char *buf, long posd, size_t len, const char *s) {
long i, j;
int  slen = strlen(s);
long imax = len - slen - 1;
long ret = -1;
int match;

     /* x = strlen s, copy x and compare to s if found return fpos... */
     for (i=0; i<imax; i++) {
	 match = 1;
	 for (j=0; j<slen; j++) {
	     if (buf[posd+i+j] != s[j]) {
		 match = 0;
		 break;
		}
	 }
       if (match) {
	   ret = i;
	   break;
	  }
     }
 return(ret);
}

void setinputpos(void) {
#ifdef MSDOS
     gotoxy(62, 24);
#else 
     my_gotoxy(62, 24);
#endif
}

void removestr(char *s, const char *remove_str) {
 while (s=strstr(s,remove_str))
    memmove(s,s+strlen(remove_str),1+strlen(s+strlen(remove_str)));
}

void _cut(void) {
long k;
long startcut;
long endcut;
long xpos;
long spos;
long cutlen;
long nsize;

     setinputpos();
     printf("START CUT?");
     scanf("%x",&startcut);
     setinputpos();
     printf("END CUT?");
     scanf("%x",&endcut);
     cutlen = (endcut - startcut);
     if (cutlen) {
         xpos = endcut + 1;
	 spos = startcut;
	 nsize = (docusize - startcut);
	 nsize = (nsize - cutlen);
	 for (k=0; (k<=nsize); k++) {
	      buffer[spos++] = buffer[xpos++];
	 }
	 docusize = (docusize - cutlen);
	 changes = 1;
     }   
}

void _edit(void) { 
int location = 0;
int value = 0;

     setinputpos();
     printf("LOC (HEX)?");
     scanf("%x",&location);
     printf(" VALUE (HEX)?");     
     scanf("%x",&value);
     buffer[location] = value;
     changes = 1;
} 

void _find(void) {
     setinputpos();
     printf("Find? ");
     scanf("%s",text);
     if (fpos < docusize) { 
         // fpos stay current 
         } else {
         fpos = 0;
         } 
 fpos = findtext(buffer, fpos, docusize, text);
}

char _getchar(void) {
char cx;

     /* get key */
#ifdef MSDOS
     cx = getch();
#else 
     // c = getchar();
     cx = mygetch();
#endif
 return(cx);
}

void userinterface(void) {
char  c;   
int i;
char kk[9];

     c = _getchar();
#ifndef MSDOS
     switch (c) {
        case 27 : {
              c = _getchar();
              switch (c) {
                case 79 : {
                      // first four F keys and HOME and END
                      c = _getchar();
                      if (c == 70) { c = 79; } //END  
                      if (c == 72) { c = 71; } //HOME  
                      break;  
                  }
                case '[' : {
                for (i=0; (c != -1 && c != 27 && i < 5); i++) {
                    c = _getchar();
                    kk[i] = c; 
                    }
                switch (kk[0]) {
                    case 65: { // UP
                         c = 72;
                         break; }
                    case 66: { // DOWN
                         c = 80;
                         break; }
                    case 53: { // PGUP
                         c = 73;
                         break; }
                    case 54: { // PGDN
                         c = 81;
                         break; }
                }     
                break; 
                } 
              }                
                  break;  
                  } 
     }                 
#endif
     c = toupper(c);
     switch (c) {
	case 27: { /* ESC */
		  done = 1;
	    break;
	    }
	case 'C': { /* C */
                 _cut();
            break;
            }
        case 'E': { /* E */
                  _edit();
            break;
            }
        case 'F': { /* F */
                 _find();
            break;
            }
        case 'J': { /* J */
            setinputpos();
            printf("Jump (HEX)? ");
            scanf("%x",&fpos);
            break;
            }  
        case 71: { /* HOME */
                if (fpos >= DISPCOLS) { 
		    fpos = 0;
                   } 
            break; 
            } 
        case 72: { /* UP AR */
                if (fpos >= DISPCOLS) { 
                    fpos = (fpos - DISPCOLS);
                   } 
            break; 
            } 
        case 73: { /* PGUP */
                  if (fpos >= (DISPCOLS*DISPROWS))  { 
                        fpos = (fpos - (DISPCOLS*DISPROWS));
                     } 
            break;
            }
        case 79: { /* END */
                 fpos = (docusize - (DISPCOLS*DISPROWS)); 
            break;
            } 
        case 80: { /* DN AR */
                  if (fpos <= docusize) {
                       fpos = (fpos + DISPCOLS);
                    }  
            break; 
            } 
        case 81: { /* PGDN */
                  if (fpos <= docusize) {
                        fpos = (fpos + (DISPCOLS*DISPROWS));  // 16*23 = 368
                     }
            break; 
            }
        default: {

            break;
	    }
        }
}

int hexed(char *str[]) {
int err = 0;
FILE *f;
char c;

/*
   load file
 :top
   display hex contents one screen at a time
   get input
   if arrow keys  dec/inc  ptr by 35
   if pgup or pgdn dec/inc ptr 35*20
   loop top
*/
    ramkb = RAMFreeInK();
    ramkb = ramkb * 1024;
    if (getdisksect) {
	 /* LOAD DISK SECTOR INTO BUFFER */
	 docusize = 512;
#ifdef MSDOS
	 // biosdisk(int cmd, int drive, int head, int track, int sector, int nsects, void *buffer);
	 if (biosdisk(2, drivenum, 0, 0, sect, 1, buffer)) {
	     err = -5;
	     return(err);
	    }
#else
         err = -5;
         return(err);  
#endif
      } else {
    f = fopen(str, "r+");
    if (f != NULL) {
      docusize = filesize(str);
      if (docusize >= ramkb) {
	  err = -8;
	  return(err);
	 }
      buffer = (char *) malloc(docusize+1);
      if (buffer==NULL) {
	  err = -2;
	  fclose(f);
	  return(err);
	 }
      while (!(feof(f))) {
	     c = fgetc(f);
	     buffer[fpos] = c;
	     fpos++;
	     if (fpos>docusize) { break; }
	    }
      } else {
	err = -2;
	return(err);
      }
     }

     fpos = 0;
     pd = 0;
     while (!done) {
#ifdef MSDOS
     textcolor(7);
     textbackground(0); 
     clrscr();   // this is causing the screen to blank out !
     gotoxy(1,1);
#else 
     _clrscr();
     my_gotoxy(1,1);
#endif
     printf(TITLE);
     printf(" ");
     printf(VERSION);
     printf(" | (C)ut");
     printf(" | %lu",docusize);
     printf(" | RAM : %lu",ramkb);
#ifdef MSDOS
     gotoxy(1,2);
#else
     my_gotoxy(1,2);
#endif
     printf(RULERTEXT);
#ifdef MSDOS
     gotoxy(1,3);
#else
     my_gotoxy(1,3);
#endif

     c = 0;
     showhex(fpos);

#ifdef MSDOS
     gotoxy(1,24);
#else
     my_gotoxy(1,24);
#endif
     printf("ESC | (E)DIT (F)IND (J)ump | HOME/END/PGUP/PGDN/ARROWS | --> ");

     userinterface();
     } // While

     if (!getdisksect) {
	  fclose(f);
	 }

    return(err);
}

void loadcolorcfg(void) {
FILE *cfgf;
char *str[10];

     cfgf = fopen("hexed.cfg","r+");
     if (cfgf) {
          fgets(str, 2, cfgf);
          bkcolor = atoi(str);
          fgets(str, 2, cfgf);
          addrcolor = atoi(str);
          fgets(str, 2, cfgf);
          numbcolor = atoi(str);
          fgets(str, 2, cfgf);
          texcolor = atoi(str);
          fgets(str, 2, cfgf);
          ctrlcolor = atoi(str);
          fgets(str, 2, cfgf);
          highasciicolor = atoi(str);
	  fclose(cfgf);
     }
}

int main(int argc, char *argv[]) {
int error = 0;
char *s[120];

    printf(TITLE);
    printf(" v.");
    printf(VERSION);
    printf("\n");
    printf(COPYR);
    printf("\n\n");

    if (argc == 1) {
       help();
       error = -1;
       return(error); 
    } 
    strcpy(s, argv[1]);
    if (strcmp(s,"/?")==0) {
	help();
	error = -1;
       } else {
        loadcolorcfg(); 
        getdisksect = 0;
	if (strcmp(s,"-s")==0) {
            getdisksect = 1; 
            sect = atoi(argv[2]);
            drivenum = atoi(argv[3]);
           }
	error = hexed(s);
#ifdef MSDOS
        textcolor(7);
        textbackground(0); 
	clrscr();
#else 
        _clrscr();
#endif
	if (changes) {
	   if (getdisksect) {
		// write buffer to disk sector
#ifdef MSDOS
		if (biosdisk(3, drivenum, 0, 0, sect, 1, buffer)) {
		    printf("WARNING: Cannot write to disksector!\n");
		   }
#else 
                printf("Linux version doesnt allow direct write to disk.\n");
                promptuser();
#endif
	      } else {
		error = savefile(s);
		}
	   }
	if (error == -2) {
	     printf("File %s does not exist.\n",s);
	   }
	if (error == -3) {
	     printf("Memory Allocation error!\n");
	   }
	if (error == -4) {
	     printf("File %s save error\n",s);
	   }
	if (error == -5) {
	     printf("Drive read sector error\n",s);
	   }
	if (error == -8) {
	     printf("Out of memory error! [%d]\n",ramkb);
	   }
	free(buffer);

       }
 notice();
 return(error); 
}
