;TSCDOS 1.1 by Falcosoft

.386
TSC SEGMENT PUBLIC USE16
assume cs:TSC,ds:TSC,es:TSC,ss:TSC
org 100h
START:


mov ah,06    ;clear screen
mov bh,07
xor cx,cx
mov dx,184fh
int 10h

xor bx,bx    ;cursor position
xor dx,dx
mov ah,02
int 10h

mov ax,offset prog
call show
mov ax,offset eol
call show
mov ax,offset eol
call show

mov ax,0F000h ;386+ detect
push ax
popf
pushf
pop ax
and ah,0F0h
sti
jz @@nosupport

pushfd       ;cpuid detect
pop eax
mov ebx,eax
btc eax,21
push eax
popfd
pushfd
pop eax
cmp eax,ebx
jz @@nosupport

mov eax,1    ;rdtsc detect
DB 0Fh,0A2h  ;cpuid
mov eax,4
bt edx,eax
jnc @@nosupport

mov ax,offset cpu
call show
@@start:
mov ax,0040h  ;ensure precise timing
mov es,ax
mov di,006ch
xor edx,edx
mov eax,dword ptr es:[di]
add eax,1
mov ecx,1800B0h ;make sure no timing overflow
div ecx
test eax,eax
jnz @@start  ;if overflow then restart
mov eax,edx
@@preloop:
cmp eax,dword ptr es:[di]
ja @@preloop

DB 0Fh,0A2h   ;cpuid
DB 0Fh,31h    ;rdtsc

mov dword ptr [eax1],eax
mov dword ptr [edx1],edx

xor edx,edx
mov eax,dword ptr es:[di]
add eax,20
mov ecx,1800B0h   ;make sure no timing overflow
div ecx
test eax,eax
jnz @@start    ;if overflow then restart
mov eax,edx
@@tstloop:
cmp eax,dword ptr es:[di]
ja @@tstloop

DB 0Fh,0A2h   ;cpuid
DB 0Fh,31h    ;rdtsc

sub eax, dword ptr [eax1]
sbb edx, dword ptr [edx1]

mov ecx,1098500
div ecx

call PrintNumber
mov ax,offset mhz
call show
mov ax,offset eol
call show

jmp @@end

@@nosupport:
mov ax,offset nosup
call show
mov ax,offset eol
call show

@@end:
xor ax,ax
int 16h
mov ax,4c00h
int 21h

show proc
 mov dx,ax
 mov ah,9
 int 21h
 ret
show endp

PrintNumber proc
    mov ecx, 0
    mov ebx, 10
@@loophere:
    mov edx, 0
    div ebx                          ;divide by ten

                                     ; now eax <-- eax/10
                                     ;     edx <-- eax % 10

                                     ; this is one digit we have to convert to ASCII
    push eax
    add dl, '0'                     ;convert dl to ascii

    pop eax
    push edx                         ;digits are in reversed order
    inc ecx                          ;remember how many digits we pushed to stack
    cmp eax, 0
jnz @@loophere

    ;ecx is already set
    mov ah, 2
@@loophere2:
    pop edx                          ;restore digits from last to first
    int 21h
    loop @@loophere2

    ret
PrintNumber endp



eax1    DD ?
edx1    DD ?
nosup   DB "CPU is not supported!","$"
cpu     DB "CPU Speed is ","$"
mhz     DB " Mhz","$"
eol     DB 10,13,"$"
prog    DB "TSCDOS 1.1 by Falcosoft","$"


TSC ENDS
END START