{A64LOWP 1.0 by Falcosoft
usage: A64LOWP [multiplier] [voltage] -without parameters shows CPU info}

program A64LOWP;
{$G+,N+,E-}
var
  geax, gedx: longint;
  pfid: byte;
  pdblvid: double;
  pvid, code: integer;

function fvpending(reax: longint): boolean;
begin
  fvpending := boolean((reax shr 31) and 1);
end;

function makefidvid(fid, vid: byte): longint;
begin
  makefidvid := fid or (vid shl 8) or $10000;
end;

function curfid(reax: longint): byte;
begin
  curfid := reax and $3F;
end;

function curvid(redx: longint): byte;
begin
  curvid := redx and $1F;
end;

function startfid(reax: longint): byte;
begin
  startfid := (reax shr 8) and $3F;
end;

function startvid(redx: longint): byte;
begin
  startvid := (redx shr 8) and $1F;
end;

function maxfid(reax: longint): byte;
begin
  maxfid := (reax shr 16) and $3F;
end;

function maxvid(redx: longint): byte;
begin
  maxvid := (redx shr 16) and $1F;
end;

function x2fid(x: byte): byte;
begin
  x2fid := (x - 4) * 2;
end;

function fid2x(fid: byte): byte;
begin
  fid2x := (fid div 2) + 4;
end;

function vid2volt(vid: byte): integer;
begin
  vid2volt := 1550 - (vid * 25);
end;

function volt2vid(volt: integer): byte;
begin
  volt2vid := (1550 - volt) div 25;
end;

procedure writefidvid(reax, redx: longint);
var
  recx: longint;
begin
  recx := $C0010041;
  asm
  DB $66
  mov ax,word ptr [reax]
  DB $66
  mov dx,word ptr [redx]
  DB $66
  mov cx,word ptr [recx]
  DB $0F,$30 {wrmsr}
  end;
end;

procedure readfidvid(var reax: longint; var redx: longint);
var
  recx: longint;
begin
  recx := $C0010042;
  asm
 DB $66
 mov cx,word ptr [recx]
 DB $0F,$32 {rdmsr}
 les di,reax
 DB $66
 mov word ptr es:[di],ax
 les di,redx
 DB $66
 mov word ptr es:[di],dx
  end;
end;

function checksupport: boolean;
var
  support: boolean;
begin
  asm
            mov support,true
            mov ax,0F000h       {386+ detect }
            push ax
	    popf
	    pushf
	    pop ax
	    and ah,0F0h
	    sti
	    jz @nosupport

            DB $66
            pushf               {cpuid detect}
            DB $66
            pop ax
            DB $66
            mov bx,ax
            DB $66,$0F,$BA,$F8,$15 {btc eax,15h}
            DB $66
            push ax
            DB $66
            popf
            DB $66
            pushf
            DB $66
            pop ax
            DB $66
            cmp ax,bx
            jz @nosupport
            DB $66,$B8,$00,$00,$00,$80      {mov eax,80000000h required extended function detect}
            DB $0F,$A2                      {cpuid}
            DB $66,$3D,$07,$00,$00,$80	    {cmp eax,80000007h}
            jb @nosupport

	    DB $66,$B8,$07,$00,$00,$80 	    {mov eax,80000007h}
            DB $0F,$A2                      {cpuid}

            DB $66,$F7,$C2,$06,$00,$00,$00  {test edx,06h FID,VID detect}
            jz @nosupport
            jmp @exit
    @nosupport:
            mov support,false
    @exit:
  end;
  checksupport := support;
end;

begin
  writeln('A64LOWP 1.0 by Falcosoft');
  writeln('usage: A64LOWP [multiplier] [voltage] -without parameters shows CPU info');
  if not checksupport then
  begin
    writeln('CPU is not supported!');
    exit;
  end;
  if paramcount <> 2 then
  begin
    writeln('CPU info:');
    readfidvid(geax, gedx);
    write('CurFid:', fid2x(curfid(geax)), 'x  ');
    writeln('CurVid:', vid2volt(curvid(gedx)) / 1000: 1: 3, 'v ');
    write('StartFid:', fid2x(startfid(geax)), 'x  ');
    writeln('StartVid:', vid2volt(startvid(gedx)) / 1000: 1: 3, 'v ');
    write('MaxFid:', fid2x(maxfid(geax)), 'x  ');
    writeln('MaxVid:', vid2volt(maxvid(gedx)) / 1000: 1: 3, 'v  ');
  end
  else
  begin
    val(paramstr(1), pfid, code);
    if code <> 0 then
      val(copy(paramstr(1), 1, code - 1), pfid, code);
    val(paramstr(2), pdblvid, code);
    if code <> 0 then
      val(copy(paramstr(2), 1, code - 1), pdblvid, code);
    pvid := round(pdblvid * 1000);
    readfidvid(geax, gedx);
    if pfid > fid2x(curfid(geax)) then
    begin
      writefidvid(makefidvid(curfid(geax), volt2vid(pvid)), $7D0);
      repeat
        readfidvid(geax, gedx);
      until fvpending(geax) = false;
      writefidvid(makefidvid(x2fid(pfid), curvid(gedx)), $7D0);
      repeat
        readfidvid(geax, gedx);
      until fvpending(geax) = false;
    end
    else
    begin
      writefidvid(makefidvid(x2fid(pfid), curvid(gedx)), $7D0);
      repeat
        readfidvid(geax, gedx);
      until fvpending(geax) = false;
      writefidvid(makefidvid(curfid(geax), volt2vid(pvid)), $7D0);
      repeat
        readfidvid(geax, gedx);
      until fvpending(geax) = false;
    end;
    write('CurFid:', fid2x(curfid(geax)), 'x  ');
    writeln('CurVid:', vid2volt(curvid(gedx)) / 1000: 1: 3, 'v ');
  end;
end.

