; ****************************************************************************
; `partdef' - Definitions of (more popular) known partition types
;   Written by Michal H. Tyc
;
; This file is part of `BOOTMGR - multi-BOOT ManaGeR'.
;
; Copyright (c) 1997-2006 BTTR Software.  All rights reserved.
;
; This program is free software; you can redistribute it and/or modify it
; under the terms of the `MODIFIED' BSD LICENSE.  Please see `legal.txt'
; for details.
; ****************************************************************************


; First define a table of names and indices into it:

%macro DEFPT 2
  PT%1 Equ CURRPT
    Db %2, 0
  %assign CURRPT CURRPT + 1
%endmacro
%assign CURRPT 0

ptypes
  DEFPT UNKNOWN,   'unknown'     ; unknow partition ID
  DEFPT UNUSED,    'empty'       ; empty partition
  DEFPT FAT12,     'FAT12'       ; DOS FAT12
  DEFPT FAT16,     'FAT16'       ; DOS FAT16
  DEFPT FAT16B,    'FAT16B'      ; DOS 3.30+ `big' FAT16 (over 32 Mbytes)
  DEFPT FAT32,     'FAT32'       ; DOS 7.10+ FAT32
  DEFPT FAT16X,    'FAT16X'      ; DOS 7.10+ LBA-addressed FAT16
  DEFPT FAT32X,    'FAT32X'      ; DOS 7.10+ LBA-addressed FAT32
  DEFPT EXT,       'Extended'    ; extended partition (`container' for others)
  DEFPT EXTLBA,    'Extend.LBA'  ; LBA-addressed extended partition
  DEFPT OS2NT@,    'HPFS,NTFS,'  ; OS/2 HPFS, WinNT NTFS or other
  DEFPT DYNEXT@,   'Dyn.Ext.,?'  ; Dynamic extended or other
  DEFPT OS2BOOT,   'OS/2 boot'   ; OS/2 boot
  DEFPT PQMAGIC,   'PQMagic'     ; PQMagic boot
  DEFPT ONTRACK@,  'Ontrack,?'   ; Ontrack Disk Manager or other
  DEFPT ONTRACK,   'Ontrack'     ; Ontrack Disk Manager
  DEFPT EZDRIVE,   'EZ-Drive'    ; EZ-Drive
  DEFPT SPEEDSTOR, 'SpeedStor'   ; SpeedStor
  DEFPT PTSBOOT,   'PTS boot'    ; PTS-DOS boot
  DEFPT LINUX@,    'Linux,?'     ; Linux or other
  DEFPT LINUX,     'Linux'       ; Linux
  DEFPT LINUXSWP@, 'Lin.swap,?'  ; Linux swap or other
  DEFPT LINUXEXT,  'Linux Ext.'  ; Linux extended
  DEFPT RAID@,     'RAID,?'      ; RAID
  DEFPT QNX,       'QNX'         ; QNX RTOS
  DEFPT SYSV@,     'SystemV,?'   ; Unix System V
  DEFPT BSDBSDI,   'BSD,BSDI'    ; BSD/BSDI
  DEFPT OPENBSD,   'OpenBSD'     ; OpenBSD
  DEFPT NETBSD,    'NetBSD'      ; NetBSD
  DEFPT SOLARIS,   'Solaris'     ; Solaris
  DEFPT BEOS,      'BeOS'        ; BeOS
  DEFPT NEXTSTEP,  'NeXTStep'    ; NeXTStep
  DEFPT NW286@,    'NW286,?'     ; Novell NetWare 286
  DEFPT NETWARE,   'NetWare'     ; Novell NetWare
  DEFPT CPM@,      'CPM,?'       ; CP/M or other
  DEFPT CPM,       'CPM'         ; CP/M
  DEFPT VMWARE,    'VMware'      ; VMware
  DEFPT HIDDEN@,   'hidden,?'    ; various hidden partitions or other
  DEFPT HIDDEN,    'hidden'      ; various hidden partitions
  DEFPT SECURE@,   'secured,?'   ; various secured partitions or other
  DEFPT SECURE,    'secured'     ; various secured partitions
  DEFPT HIBERN@,   'hibern.,?'   ; laptop hibernation save area or other
  DEFPT HIBERN,    'hibern.'     ; laptop hibernation save area
  DEFPT CFGDIAG,   'cfg/diag'    ; configuration/diagnostics (Compaq et al.)

; then define mapping of partition IDs into the table

%macro DEFID 2
    Db PT%2, %1
  %assign IDCOUNT IDCOUNT + 1
%endmacro
%assign IDCOUNT 0

idtable
  DEFID  00h, UNUSED
  DEFID  01h, FAT12
  DEFID  04h, FAT16
  DEFID  05h, EXT
  DEFID  06h, FAT16B
  DEFID  07h, OS2NT@
  DEFID  0ah, OS2BOOT
  DEFID  0bh, FAT32
  DEFID  0ch, FAT32X
  DEFID  0eh, FAT16X
  DEFID  0fh, EXTLBA
  DEFID  10h, OS2BOOT
  DEFID  11h, HIDDEN@
  DEFID  12h, CFGDIAG
  DEFID  14h, HIDDEN@
  DEFID  16h, HIDDEN
  DEFID  17h, HIDDEN@
  DEFID  18h, HIBERN
  DEFID  1bh, HIDDEN
  DEFID  1ch, HIDDEN
  DEFID  1eh, HIDDEN@
  DEFID  3ch, PQMAGIC
  DEFID  42h, DYNEXT@
  DEFID  43h, LINUX@
  DEFID  4dh, QNX
  DEFID  4eh, QNX
  DEFID  4fh, QNX
  DEFID  50h, ONTRACK@
  DEFID  51h, ONTRACK@
  DEFID  52h, CPM@
  DEFID  53h, ONTRACK
  DEFID  54h, ONTRACK
  DEFID  55h, EZDRIVE
  DEFID  61h, SPEEDSTOR
  DEFID  63h, SYSV@
  DEFID  64h, NW286@
  DEFID  65h, NETWARE
  DEFID  66h, NETWARE
  DEFID  67h, NETWARE
  DEFID  68h, NETWARE
  DEFID  69h, NETWARE
  DEFID  81h, LINUX@
  DEFID  82h, LINUXSWP@
  DEFID  83h, LINUX@
  DEFID  84h, HIBERN@
  DEFID  85h, LINUXEXT
  DEFID  86h, RAID@
  DEFID  8ah, LINUX
  DEFID  8eh, LINUX
  DEFID  97h, HIDDEN
  DEFID  9fh, BSDBSDI
  DEFID 0a0h, HIBERN@
  DEFID 0a1h, HIBERN@
  DEFID 0a5h, BSDBSDI
  DEFID 0a6h, OPENBSD
  DEFID 0a7h, NEXTSTEP
  DEFID 0a9h, NETBSD
  DEFID 0b7h, BSDBSDI
  DEFID 0b8h, BSDBSDI
  DEFID 0bbh, PTSBOOT
  DEFID 0beh, SOLARIS
  DEFID 0c0h, SECURE@
  DEFID 0c1h, SECURE
  DEFID 0c4h, SECURE
  DEFID 0c5h, SECURE
  DEFID 0c6h, SECURE@
  DEFID 0d0h, SECURE
  DEFID 0d1h, SECURE
  DEFID 0d4h, SECURE
  DEFID 0d5h, SECURE@
  DEFID 0d6h, SECURE
  DEFID 0d8h, CPM
  DEFID 0dbh, CPM@
  DEFID 0e1h, SPEEDSTOR
  DEFID 0e3h, SPEEDSTOR
  DEFID 0e4h, SPEEDSTOR
  DEFID 0e6h, SPEEDSTOR
  DEFID 0ebh, BEOS
  DEFID 0f1h, SPEEDSTOR
  DEFID 0f3h, SPEEDSTOR
  DEFID 0f4h, SPEEDSTOR
  DEFID 0f6h, SPEEDSTOR
  DEFID 0fch, VMWARE
  DEFID 0fdh, RAID@
  DEFID    0, UNKNOWN    ; search for any other ID falls here

NUMIDS Equ IDCOUNT


; partition types that can be hidden by adding 10h to their IDs

hideable
;    FAT12, FAT16, FAT16B, OS2NT@, FAT32, FAT32X, FAT16X
  Db     1,     4,      6,      7,   0bh,    0ch,    0eh
NHIDEABLE Equ $ - hideable

; (end of partdef.inc)
