; ****************************************************************************
; `data' - initialized data section
;   Written by Michal H. Tyc
;
; This file is part of `BOOTMGR - multi-BOOT ManaGeR'.
;
; Copyright (c) 1997-2006 BTTR Software.  All rights reserved.
;
; This program is free software; you can redistribute it and/or modify it
; under the terms of the `MODIFIED' BSD LICENSE.  Please see `legal.txt'
; for details.
; ****************************************************************************


; Section .data align=2

menutop:   Db '<Floppy>', '<NextHD>'  ; default menu items
mbrbuff:   Dw buffer1                 ; buffer for BIOS MBR operations
filebuff:  Dw buffer2                 ; buffer for DOS file transfers
screenseg: Dw 0b800h                  ; frame buffer segment (color)
editpos:   Dw 0                       ; cursor position in Menu dialog
partpos:   Db 0                       ; cursor row in Partition table dialog

  align 2, Db 0

; Definitions of dialogs: print routine, key handling routine.

partdlg:   Dw partprint, partkeys
assocdlg:  Dw assocprint, assockeys
inputdlg:  Dw inpprint, inpkeys
activedlg: Dw activeprint, activekeys
hidedlg:   Dw hideprint, hidekeys
timedlg:   Dw timprint, timkeys

; Vectors of procedures and quick-help texts for user interface elements.

uiprocs:
  Dw savembr, restorembr, choosedisk, clrform
  Dw installmgr, zapdisk, quitinst
  Dw editpart, selactive, editmenu, editassoc, edithide, settimeout
uihelp:
  Dw savehelp, restorehelp, choosehelp, clearhelp
  Dw installhelp, zaphelp, quithelp
  Dw parthelp, activehelp, menuhelp, assochelp, hidehelp, timeouthelp

; Links for moving between the fields with arrow keys (Up, Down, Left, Right)

uilink:
  Db  7,  1, 12,  4   ; for "Save MBR"     (field #0)
  Db  0,  2, 12,  5   ; for "Restore MBR"  (field #1)
  Db  1,  3, 11,  2   ; for "Change disk"  (field #2)
  Db  2,  3, 11,  6   ; for "Defaults"     (field #3)
  Db  8,  5,  0,  4   ; for "Write MBR"    (field #4)
  Db  4,  6,  1,  5   ; for "Zap disk"     (field #5)
  Db  5,  6,  3,  6   ; for "Quit"         (field #6)
  Db  7,  9,  7,  8   ; for "Hard disk PT" (field #7)
  Db  8,  4,  7,  8   ; for "Active part." (field #8)
  Db  7,  9,  9, 10   ; for "Menu"         (field #9)
  Db  7, 10,  9, 11   ; for "Assoc."       (field #10)
  Db  7, 11, 10, 12   ; for "Hide"         (field #11)
  Db  7, 12, 11,  1   ; for "Timeout"      (field #12)

NBUTTONS Equ 7                   ; number of buttons
NINPUTS  Equ 6                   ; number of input fields
NFIELDS  Equ NINPUTS + NBUTTONS  ; total number of switchable fields

; `Constant' screen objects: size and position.
; Format: box size(height, width), offset(row, col) in frame buffer

statfields:
  Dw SCRCRD(72, 1), SCROFS( 3,  1)  ; title banner
  Dw SCRCRD(62, 2), SCROFS( 3,  4)  ; partition table header
  Dw SCRCRD( 6, 2), SCROFS(69,  4)  ; `active Part.' header
  Dw SCRCRD( 8, 1), SCROFS( 3, 13)  ; `Menu' header
  Dw SCRCRD( 6, 1), SCROFS(15, 13)  ; `Assoc.' header
  Dw SCRCRD( 4, 1), SCROFS(25, 13)  ; `Hide' header
  Dw SCRCRD( 7, 1), SCROFS(33, 13)  ; `Timeout' header

NSTATF Equ 7   ; number of static fields

; Bodies of `constant' user interface elements, sequentially.

ititletext:
  Db 'BOOTMGR Version ', VERSIONDATE, ' - multi-BOOT ManaGeR'  ; title bar
  Db '           BTTR Software'
diskpar:  Db 'Hard dis~k~'  ; partition table header -- disk parameters
.which:   Db '    (of'
.howmany: Db '   ), Size'
.size:    Db '=      , C:H:S'
.chs:     Db '=           , Mode='
.mode:    Db '   '

; partition table header

.part:    Db '#IDType        Size Start-LBAModeStart-C:H:S  End-C:H:S'

  Db 'active', ' ~P~art.'  ; more elements
  Db '~M~enu', 0
  Db '~A~ssoc.'
  Db '~H~ide'
  Db '~T~imeout'

timetext: Db '   sec.'

; Buttons: size - 1, position, text.

buttons:
  Db 11
  Dw SCROFS(51, 13)
  Db ' ~S~ave MBR', 0
;
  Db 11
  Dw SCROFS(51, 15)
  Db '~R~estore MBR'
;
  Db 11
  Dw SCROFS(51, 17)
  Db '~C~hange disk'
;
  Db 11
  Dw SCROFS(51, 19)
  Db ' ~D~efaults', 0
;
  Db 9
  Dw SCROFS(66, 13)
  Db '~W~rite MBR'
;
  Db 9
  Dw SCROFS(66, 15)
  Db '~Z~ap disk', 0
;
  Db 9
  Dw SCROFS(66, 19)
  Db '  ~Q~uit', 0

; Quick-help texts.

guidetext:   Db 'Keys: ~Tab~ ~Shift~+~Tab~ ~', 17, '~ '
             Db '~', 24, '~ ~', 25, '~ ~', 27, '~ ~', 26, '~ '
             Db '~Alt~+(~K P M A H T S R C D W Z Q~)', 0
savehelp:    Db 'Backup the Master Boot Record to a file', 0
restorehelp: Db 'Restore the Master Boot Record from a file', 0
installhelp: Db 'Write partition table, '
             Db 'install BOOTMGR or generic loader', 0
choosehelp:  Db 'Select hard disk to view', 0
clearhelp:   Db 'Discard changes, restore default settings', 0
zaphelp:     Db 'Erase the Master Boot Record and Tracks 0 & 1. ',
             Db '***UNRECOVERABLE!***', 0
quithelp:    Db 'Exit to Operating System', 0
parthelp:    Db '~Space~ Set partition ID  ~PgUp~ ~PgDn~ Move entry up/down',
             Db 0
activehelp:  Db '~Space~ ~Del~ Set active partition for A:/D: boot '
             Db 'and for no BOOTMGR', 0
menuhelp:    Db 'Edit boot menu items  ~F7~ Insert blank  ~F8~ Delete  '
             Db '~PgUp~ ~PgDn~ Move', 0
assochelp:   Db '~1~ ~2~ ~3~ ~4~ Associate partition  '
             Db '~A~ ~D~ Associate disk  ~Space~ Set default', 0
hidehelp:    Db '~1~ ~2~ ~3~ ~4~ Select which partitions to hide '
             Db 'when the item is selected', 0
timeouthelp: Db '~+~ ~-~ ~Space~ Time for OS selection (0 = no limit), '
             Db 'default OS boots then', 0

; File dialog texts and error messages.

fntext:       Db 'File name:', 0
fderrtext:    Db 'Error while accessing '
fdtext:       Db ' i  , hit ~Esc~...', 0
insdsktext:   Db 'Insert disk for drive '
dskletter:    Db ' : then hit ~Space~', 0
copytext:     Db 'Transferring data...', 0
rsttext1:     Db 'Master Bootstrap Loader code (0..1B7h)', 0
              Db 'NT Volume Bytes/reserved area (1B8h..1BDh)', 0
              Db 'Partition Table (1BEh..1FFh)', 0
rstskiptext:  Db '~R~estore  ~S~kip'
RSTSKIPLEN Equ $ - rstskiptext - 4  ; compensate for the 4 tildes
wrongsettext: Db 'Inconsistent settings specified.  ~Esc~ Review', 0
choosetext:   Db 'HD '
.dsk          Db '       ~+~ ~-~ Browse  ~~ Done', 0
insttext:     Db 'Master Bootstrap Loader to install:  '
              Db '~B~OOTMGR  ~G~eneric  ~K~eep existing', 0
instbootmgr:  Db 'Ok to install/update BOOTMGR as configured', 0
instgeneric:  Db 'Ok to install generic Bootstrap Loader', 0
instptable:   Db 'Ok to update Partition Table', 0
esccantext:   Db '~Esc~ Cancel'
ESCCANLEN Equ $ - esccantext - 2  ; compensate for the 2 tildes
instntvol:    Db 'Reserved/NT Volume Bytes:  '
              Db '~~ Keep (recommended)  ~Del~ Clear', 0
quittext:     Db 'Exit now', 0
entertext:    Db '~~'
ENTERLEN Equ $ - entertext - 2  ; compensate for the 2 tildes
setidtext:    Db 'ID (hex):', 0
settmtext:    Db 'New value:', 0
incorrtext:   Db 'Incorrect value.  ~Esc~ Retry', 0
zapwarn:      Db '***WARNING!*** Erasing cannot be undone!  '
              Db '~Del~ Proceed anyway  ~Esc~ Cancel'
zaptext:      Db 'Erasing disk...', 0

; Keyboard codes for the user interface.

keycodes:
;     Bksp  Bktab    Tab  Enter    Esc                         = codes  4..0
  Dw 0e08h, 0f00h, 0f09h, 1c0dh, 011bh
NSPECKEYS Equ ($ - keycodes) / 2
.alts:
; The order below must be reverse of that in uiprocs
; Alt+ T    H    A    M    P    K    Q    Z    W    D    C    R    S = 26..14
  Db 14h, 23h, 1eh, 32h, 19h, 25h, 10h, 2ch, 11h, 20h, 2eh, 13h, 1fh
.curs:
;     F8   F7 PgDn PgUp  Del  Rgt  Lft   Dn   Up                     = 13..5
  Db 42h, 41h, 51h, 49h, 53h, 4dh, 4bh, 50h, 48h
NFUNCKEYS Equ $ - .alts
FIRSTALT  Equ $ - .curs + NSPECKEYS  ; the index of [Alt][S]

; Definitions of partition types.

%include 'partdef.inc'

; Messages printed to stdout via DOS.

nomemtext:   Db 'Not enough memory!', 13, 10, '$'
notdos3text: Db 'DOS 3.30+ required!', 13, 10, '$'
multitext:   Db 'This program may not work properly in multitasking '
             Db 'environments (MS Windows,', 13, 10
             Db 'task managers). Press [Enter] to continue anyway, ',
             Db 'any other key to exit...', '$'
nohdtext:    Db 'No directly accessible hard disks found!', 13, 10, '$'
badvmtext:   Db 'Incompatible video mode!'  ; 13, 10, '$'
crlftext:    Db 13, 10, '$'

; End of the program body. Uninitialized data area.

  Section .bss

  Alignb 2

driveno:   Resb 1           ; current drive number
.hi:       Resb 1           ; highest drive number + 1
nsectors:  Resw 1           ; sectors per track for current HD
vmode:     Resw 1           ; video mode
screensiz: Resw 1           ; screen size in bytes
assocdata: Resb NITEMS * 6
hidedata:  Resb NITEMS * 4
activea:   Resb 4 * 6
partdata:  Resb 4 * 62
buffer1:   Resb 512         ; 1st buffer -- one is chosen for file,
buffer2:   Resb 512         ; 2nd buffer -- one for disk access
parbuffer: Resb 1ah         ; extended disk parameters; moved PT entry
linebuff:  Resb 61          ; string entered from keyboard
activ:     Resb 1           ; active partition index (80h..83h, or -1 if none)
isinst:    Resb 1           ; flag: does current MBR contain BOOTMGR loader?
delay:     Resb 1           ; timeout value (0 = infinite)

; End of data, end of memory used by the program.

enddata:


; (end of data.inc)
