;
; 1. Attrib	A -	Set background and forground color
; 2. Control	O -	Set color of CONTROL characters
; 3. Quote	Q -	Set color of quoted text
; 4. Digit	D -	Set color of numbers
; 5. Char	C -	Set color of chars
; 6. String	S -	Set color of string
; 7. Begin	B -	Set color from start of string
; 8. Word	W -	Set color of words
; 9. Nested	N -	Set color of nested strings
;
include	clib.inc
ifdef __TE__
include	dobj.inc
include	tinfo.inc
include	ctype.inc
include	ini.inc
include	stdlib.inc
include	string.inc

	public	tireadstyle

_DATA	SEGMENT

cp_defaultfile	db 'Styletype.*',0	; *.asm, *.c, ...
cp_typech	db 'aoqdcsbwn',0

_DATA	ENDS

ID_TYPE		= 0
ID_ATTRIB	= 1

ST_ATTRIB	= 1	; attrib	<at> [<char>]
ST_CHAR		= 2	; char		<at> <chars>
ST_WORD		= 3	; word		<at> <words> ...
ST_START	= 4	; start		<at> <string>
ST_NESTED	= 5	; nested	<at> <string1> <string2>
ST_CONTROL	= 6	; control	<at>
ST_STRING	= 7	; string	<at> <string>
ST_QUOTE	= 8	; quote		<at>
ST_NUMBER	= 9	; number	<at>
ST_COUNT	= ST_NUMBER

S_RDST		STRUC
st_section	DB 64 dup(?)
st_label	DB 64 dup(?)
st_sp		DD ?
st_eof		DW ?	; style + SIZE style - 2
S_RDST		ENDS

_TEXT	SEGMENT

tireadlabel PROC
	push	si
	push	di
	lea	si,[bp.st_label]
	invoke	inientryid, ss::si, ID_TYPE
	jz	tireadlabel_end
	les	di,[bp.st_sp]
	cmp	di,[bp.st_eof]
	ja	tireadlabel_end
	mov	bx,ax
	mov	ah,[bx]
	or	ah,20h
	xor	cx,cx
	xchg	cx,bx
    @@:
	mov	al,cp_typech[bx]
	cmp	al,ah
	je	@F
	inc	bx
	or	al,al
	jnz	@B
	jmp	tireadlabel_end
    @@:
	mov	al,bl
	inc	al
	mov	bx,cx
	stosb
	mov	ah,0
	mov	si,ax
	xor	cx,cx
    @@:
	inc	bx
	mov	al,[bx]
	call	islabel
	jnz	@B
	push	si
	mov	si,bx
    tireadlabel_loop:
	lodsb
	cmp	al,' '
	jne	@F
	mov	ax,si
	pop	si
	jmp	tireadlabel_attrib
    @@:
	or	al,al
	jnz	tireadlabel_loop
	pop	si
	push	es
	invoke	inientryid, ss::bx, ID_ATTRIB
	pop	es
	mov	cx,1
	jz	tireadlabel_break
    tireadlabel_attrib:
	mov	bx,ax
	add	ax,2
	push	ax
	mov	ax,[bx]
	or	ax,2020h
	cmp	al,'x'
	jne	tireadlabel_bg
	mov	al,ah
	call	getctype
	and	ah,_HEX or _DIGIT
	jz 	tireadlabel_getat
	sub	al,'0'
	and	ah,_DIGIT
	jnz	@F
	sub	al,39
    @@:	mov	bx,tinfo
	mov	ah,[bx.ti_stat]
	and	ah,0F0h
	or	al,ah
	jmp	tireadlabel_stoat
    tireadlabel_getat:
	push	es
	push	cx
	invoke	xtol, dx::bx
	pop	cx
	pop	es
	jmp	tireadlabel_stoat
    tireadlabel_bg:
	cmp	ah,'x'
	jne	tireadlabel_getat
	call	getctype
	and	ah,_HEX or _DIGIT
	jz 	tireadlabel_getat
	sub	al,'0'
	and	ah,_DIGIT
	jnz	@F
	sub	al,39
    @@:
	shl	al,4
	mov	bx,tinfo
	mov	ah,[bx.ti_stat]
	and	ah,0Fh
	or	al,ah
    tireadlabel_stoat:
	stosb
	pop	bx
    @@:
	mov	ah,[bx]
	inc	bx
	cmp	ah,' '
	je	@B
	dec	bx
	cmp	si,ST_ATTRIB
	je	tireadlabel_char
	mov	si,cx
	inc	si
	mov	ax,bx
	jmp	tireadlabel_start
    tireadlabel_label:
	cmp	si,100
	je	tireadlabel_break
	mov	dx,si
	inc     si
	push	es
	invoke	inientryid, addr [bp.st_label], dx
	pop	es
	jz	tireadlabel_break
    tireadlabel_start:
	mov	bx,si
	mov	cx,[bp.st_eof]
	mov	si,ax
	cmp	byte ptr [si],0
	je	tireadlabel_endcopy
    tireadlabel_copy:
	lodsb
	cmp	di,cx
	jae	tireadlabel_endcopy
	cmp	al,' '
	jne	@F
	mov	al,0
	stosb
	jmp	tireadlabel_copy
    @@:	stosb
	or	al,al
	jnz	tireadlabel_copy
    tireadlabel_endcopy:
	mov	si,bx
	jmp	tireadlabel_label
    tireadlabel_char:
	mov	si,tinfo
	mov	[si.ti_stat],al
	or	ah,ah
	jz	tireadlabel_break
	push	es
	invoke	xtol, ss::bx
	pop	es
	mov	[si.ti_stch],al
	stosb
    tireadlabel_break:
	xor	ax,ax
	cmp	es:[di-1],al
	je	@F
	stosb
    @@:	stosb
	mov	word ptr [bp.st_sp],di
	inc	ax
    tireadlabel_end:
	pop	di
	pop	si
	ret
tireadlabel ENDP

tidosection PROC
	push	si
	push	di
	sub	sp,64
	mov	di,sp
	invoke	memcpy, ss::di, addr [bp.st_section], 64
	xor	si,si
    tidosection_do:
	mov	dx,si
	inc     si
	invoke	inientryid, addr [bp.st_section], dx
	jz	tidosection_end
	mov	di,ax
	mov	al,[di]
	cmp	al,'['
	jne	tidosection_label
	mov	bx,si
	mov	dx,di
	mov	si,di
	inc	si
	lea	di,[bp.st_section]
    @@:
	lodsb
	stosb
	or	al,al
	jz	@F
	cmp	al,']'
	jne	@B
    @@:
	dec	di
	xor	ax,ax
	stosb
	mov	si,bx
	mov	di,dx
	call	tidosection
	mov	dx,sp
	invoke	memcpy, addr [bp.st_section], ss::dx, 64
	jmp	tidosection_do
    tidosection_label:
	lea	ax,[bp.st_label]
	invoke	strcpy, dx::ax, dx::di
	call	tireadlabel
	jmp	tidosection_do
    tidosection_end:
	add	sp,64
	pop	di
	pop	si
	ret
tidosection ENDP

tireadstyle PROC PASCAL
local	rdst:S_RDST
	push	si
	push	di
	push	bp
	lea	bp,rdst
	mov	di,tinfo
	les	ax,[di.ti_style]
	mov	word ptr [bp.st_sp],ax
	mov	word ptr [bp.st_sp+2],es
	mov	di,ax
	add	ax,STYLESIZE-4
	mov	[bp.st_eof],ax
	xor	ax,ax
	cld
	mov	cx,STYLESIZE/2
	rep	stosw
	mov	si,offset cp_defaultfile
	lea	di,[bp.st_section]
	push	ss
	pop	es
	mov	cx,11
	rep	movsb
	mov	si,tinfo
	dec	di
	invoke	strfn,[si.ti_file]	; name || name.ext
	invoke	strcpy,ss::di,dx::ax
	lea	ax,[bp.st_section]
	invoke	inientryid,dx::ax,0
	jnz	tireadstyle_do
	invoke	strext,[si.ti_file]	; *.ext
	jz	@F
	mov	byte ptr [di],'*'
	inc	di
	invoke	strcpy,ss::di,dx::ax
	invoke	inientryid,addr ss:[bp.st_section],0
	jnz	tireadstyle_do
      @@:
	invoke	strcpy,addr ss:[bp.st_section],addr cp_defaultfile
    tireadstyle_do:
	call	tidosection
	les	di,[bp.st_sp]
	xor	ax,ax
	stosw
    tireadstyle_end:
	pop	bp
	pop	di
	pop	si
	ret
tireadstyle ENDP

_TEXT	ENDS
endif
	END
