/*
 * javaserv.c web server with Server Side Includes to generate
 *                     dynamic content, and a Java client side
 *                     chart program to display the results
 *                     See the files in .\web
 *
 */
#include <stdlib.h>
#include <rtos.h>
#include <net.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include <httpd.h>
#include <mem.h>


void RandValue( tcp_Socket *s, stringlist *unused )
{
    char buffer[64];

    sprintf( buffer, "%lu", (rand() * 25L) / RAND_MAX );
    sock_write( s, buffer, strlen( buffer ) );
}

static ssi_type ssi_list[] =
  { { "RandValue", RandValue },
    { NULL, NULL }
    };

/***********************************************************************
 * - the web server calls this proc for each web request               *
 * - it is called in the context of *one* of the HTTPD threads,        *
 *   though which is not known or important                            *
 * - multiple threads may be in the same proc at the same time         *
 ***********************************************************************/
void user_proc( tcp_Socket *s, char *cmd, char *file, char *ext,
    stringlist *cookies )
{
    /* prepare output */
    
    if ( !stricmp( file, "/" )) {
        sock_puts( s, "Content-Type: text/html");
        http_shtml( s, "web", "index","sht", ssi_list, cookies );
    } else if ( !stricmp( ext, "sht" )) {
        sock_puts( s, "Content-Type: text/html");
        http_shtml( s, "web", file, ext, ssi_list, cookies );
    } else {
        sock_puts( s, "Content-Type: application/octet-stream\r\n");
        http_dump( s, "web", file, ext );
    }
}


main()
{
    int i;

    randomize();
    kdebug = 1;
    rt_init(100);
    sock_init();            /* initialize network */

    cputs("starting...\r\n");
#define MAXHTTPD 5
    for ( i = 0 ; i < MAXHTTPD; ++i )
        rt_newthread( httpdthread, (DWORD)&user_proc, 4096, 0, "httpd worker" );
    do {
        /* nothing */
        rt_yield();
    } while ( 1 );
}


