/************************************************************************
 * test 9 - stringlists                                                 *
 *        - shows how to create and use a FIFO string list              *
 *        - creates a paragraph, then changes words in the paragraph    *
 ************************************************************************/
#include <stdio.h>
#include <strlst.h>

void display_list( stringlist *sl )
{
    void *x;
    char *p;

    p = strlst_getfirst( sl, &x, NULL );
    while ( p != NULL ) {
        cprintf("%s ", p );
        p = strlst_getnext( sl, &x, NULL );
    }
    cprintf("\r\n");

}
main()
{
    stringlist *sl;
    char *p;
    void *x, *q;

    rt_init( 100 );

    sl = strlst_new();

    strlst_add( sl, "Hi");
    strlst_add( sl, "there.");
    strlst_add( sl, "How");
    strlst_add( sl, "are");
    strlst_add( sl, "you");
    strlst_add( sl, "today?");

    /* show it */
    display_list( sl );

    /* change it to ... how are y'all today */
    strlst_del( sl, 6 );
    strlst_del( sl, 5 );
    strlst_add( sl, "y'all");
    strlst_add( sl, "now?");

    /* show it */
    display_list( sl );

    /* start at word: How... */
    p = strlst_findfirst( sl, "How", &x, NULL );
    while ( p ) {
        cprintf("%s ", p );
        p = strlst_getnext( sl, &x, NULL );
    }
    cprintf("\r\n");


    /* done, we can free the data */
    strlst_freeall( sl );
}


