/*
 * SNMP Trap example
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <snmp.h>
#include <rtos.h>
#include <net.h>



void single( DWORD remote_ip )
{
    char *community = "public";
    DWORD agent = 0;
    char *entOID = "1.3.6.1";
    char *fromOID = "1.3.6.1.2.1";
    int genTrapType = SNMP_TRAP_WARMSTART; // generic trap type, 1-6 see RFC 1157
    int specTrapType = 0;   // specific trap type, 0 if using genTrapType
    int type = SNMP_OCTETSTR;
    char *value = "foo";

    snmp_trap( remote_ip, community, entOID, fromOID, agent,
        genTrapType, specTrapType,
        type, value, strlen( value ) );

}

void multiple( DWORD remote_ip, int index )
{

#define REPLY_COUNT 2
    char *community = "public";
    DWORD agent = 0;
    char *entOID =      "1.3.6.1";
    char *fromOIDs[] = { "1.3.6.1.4.1.3.2.1",
                         "1.3.6.1.4.1.3.3.2" };
    int genTrapType = SNMP_TRAP_WARMSTART; // generic trap type, 1-6 see RFC 1157
    int specTrapType = 0;   // specific trap type, 0 if using genTrapType
    int types[REPLY_COUNT] = { SNMP_OCTETSTR, SNMP_OCTETSTR };
    char *values[REPLY_COUNT] = {"foo","bar "};
    int valuelens[REPLY_COUNT] = { 3, 4 };

    values[1][3] = '0' + index;

    snmp_traps( remote_ip, community, entOID, REPLY_COUNT, &fromOIDs, agent,
        genTrapType, specTrapType,
        types, values, valuelens );

}

#pragma argsused
int main( int argc, char **argv )
{
    DWORD remote_ip;
    int i;

    rt_init( 100 );
    sock_init();

    remote_ip = resolve("129.97.50.25");     // our snmp trap daemon

    single( remote_ip );

    for (i = 1 ; i < 5 ; ++i ) {
      multiple( remote_ip , i );
    }
}
