/* $XConsortium: scrnintstr.h,v 5.9 89/10/06 14:27:24 keith Exp $ */
/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
#ifndef SCREENINTSTRUCT_H
#define SCREENINTSTRUCT_H

#include "miscstruct.h"
#include "screenint.h"
#include "region.h"
#include "pixmap.h"
#include "gc.h"
#include "colormap.h"
#include "validate.h"

#ifndef WINDOW_DEFINED
#define WINDOW_DEFINED
typedef struct _Window *WindowPtr;
#endif

typedef struct _PixmapFormat {
    unsigned char	depth;
    unsigned char	bitsPerPixel;
    unsigned char	scanlinePad;
    } PixmapFormatRec;
    
typedef struct _Visual {
    unsigned long	vid;
    short		class;
    short		bitsPerRGBValue;
    short		ColormapEntries;
    short		nplanes;/* = log2 (ColormapEntries). This does not
				 * imply that the screen has this many planes.
				 * it may have more or fewer */
    unsigned long	redMask, greenMask, blueMask;
    int			offsetRed, offsetGreen, offsetBlue;
  } VisualRec;

typedef struct _Depth {
    unsigned char	depth;
    short		numVids;
    unsigned long	*vids;    /* block of visual ids for this depth */
  } DepthRec;

struct _Screen {
    int			myNum;	/* index of this instance in Screens[] */
    ATOM		id;
    short		width, height;
    short		mmWidth, mmHeight;
    short		numDepths;
    unsigned char      	rootDepth;
    DepthPtr       	allowedDepths;
    unsigned long      	rootVisual;
    unsigned long	defColormap;
    short		minInstalledCmaps, maxInstalledCmaps;
    char                backingStoreSupport, saveUnderSupport;
    unsigned long	whitePixel, blackPixel;
    unsigned long	rgf;	/* array of flags; she's -- HUNGARIAN */
    GCPtr		GCperDepth[MAXFORMATS+1];
			/* next field is a stipple to use as default in
			   a GC.  we don't build default tiles of all depths
			   because they are likely to be of a color
			   different from the default fg pixel, so
			   we don't win anything by building
			   a standard one.
			*/
    PixmapPtr		PixmapPerDepth[1];
    pointer		devPrivate;
    short       	numVisuals;
    VisualPtr		visuals;
    int			WindowPrivateLen;
    unsigned		*WindowPrivateSizes;
    unsigned		totalWindowSize;
    int			GCPrivateLen;
    unsigned		*GCPrivateSizes;
    unsigned		totalGCSize;

    /* Random screen procedures */

    Bool (* CloseScreen)(int index, ScreenPtr pScreen);
    void (* QueryBestSize)();		/* class, pwidth, pheight */
    Bool (* SaveScreen)(ScreenPtr, int);		/* pScreen, on */
    void (* GetImage)(DrawablePtr pDrawable, unsigned sx, unsigned sy,
		int w, int h, unsigned int format, unsigned long planemask,
		pointer pdestbits);
    void (* GetSpans)(DrawablePtr pDrawable, int wMax, DDXPointPtr ppt,
			int *pwidth, int nspans, unsigned char *pdstbits);
    void (* PointerNonInterestBox)(ScreenPtr, struct _Box *);

    void (* SourceValidate)(DrawablePtr pDrawable, int x, int y, int w, int h);

    /* Window Procedures */

    Bool (* CreateWindow)(WindowPtr pWin);
    Bool (* DestroyWindow)(WindowPtr pWin);
    Bool (* PositionWindow)(WindowPtr pWin, int x, int y);
    Bool (* ChangeWindowAttributes)(WindowPtr pWin, unsigned long mask);
    Bool (* RealizeWindow)(WindowPtr pWin);
    Bool (* UnrealizeWindow)(WindowPtr pWin);
    int  (* ValidateTree)(WindowPtr pParent, WindowPtr pChild, VTKind top);
    void (* WindowExposures)(WindowPtr, RegionPtr, RegionPtr);

    void (* PaintWindowBackground)(WindowPtr pWin, RegionPtr pRgn, int which);
    void (* PaintWindowBorder)(WindowPtr pWin, RegionPtr pRgn, int which);
    void (* CopyWindow)(WindowPtr pWin, DDXPointRec oldPt, RegionPtr pOldRegion);
    void (* ClearToBackground)(WindowPtr pWin, int x, int y,
			    unsigned int w, unsigned int h, Bool sendExpose);

    /* Pixmap procedures */

    PixmapPtr (* CreatePixmap)(ScreenPtr pScreen, int width, int height, int depth);
    Bool (* DestroyPixmap)(PixmapPtr pPixmap);

    /* Backing store procedures */

    void (* SaveDoomedAreas)();		/* pWin, pRegion, dx, dy */
    RegionPtr (* RestoreAreas)();	/* pWin, pRegion */
    void (* ExposeCopy)();		/* pSrc, pDst, pGC, pRegion, */
					/* srcx, srcy, dstx, dsty, plane */
    RegionPtr (* TranslateBackingStore)();/* pWin, dx, dy, pOldClip */
    RegionPtr (* ClearBackingStore)();	/* pWin, x, y, w, h, sendExpose */
    void (* DrawGuarantee)();		/* pWin, pGC, guarantee */
    
    /* Font procedures */

    Bool (* RealizeFont)(ScreenPtr, struct _Font *);
    Bool (* UnrealizeFont)(ScreenPtr, struct _Font *);

    /* Cursor Procedures */
    void (* ConstrainCursor)(ScreenPtr, struct _Box *);
    void (* CursorLimits)(ScreenPtr, struct _Cursor *, BoxPtr, BoxPtr);
    Bool (* DisplayCursor)(ScreenPtr, struct _Cursor *);
    Bool (* RealizeCursor)(ScreenPtr, struct _Cursor *);
    Bool (* UnrealizeCursor)(ScreenPtr, struct _Cursor *);
    void (* RecolorCursor)(ScreenPtr, struct _Cursor *, Bool);
    Bool (* SetCursorPosition)(ScreenPtr, int, int, Bool);

    /* GC procedures */

    Bool (* CreateGC)(GCPtr pGC);

    /* Colormap procedures */

    Bool (* CreateColormap)(struct _ColormapRec *);
    void (* DestroyColormap)(struct _ColormapRec *);
    void (* InstallColormap)(struct _ColormapRec *);
    void (* UninstallColormap)(struct _ColormapRec *);
    int (* ListInstalledColormaps)(ScreenPtr, Colormap *);
    void (* StoreColors)();		/* pmap, ndef, pdef */
    void (* ResolveColor)(u_short *, u_short *, u_short *, struct _Visual *);

    /* Region procedures */

    RegionPtr (* RegionCreate)(struct _Box * rect, int size);
    void (* RegionInit)(RegionPtr pRegion, struct _Box *rect, int size);
    Bool (* RegionCopy)(RegionPtr dstrgn, RegionPtr srcrgn);
    void (* RegionDestroy)(RegionPtr pRegion);
    void (* RegionUninit)(RegionPtr pRegion);
    Bool (* Intersect)(RegionPtr newReg, RegionPtr reg1, RegionPtr reg2);
    Bool (* Union)(RegionPtr newReg, RegionPtr reg1, RegionPtr reg2);
    Bool (* Subtract)(RegionPtr regD, RegionPtr regM, RegionPtr regX);
    Bool (* Inverse)(RegionPtr newReg, RegionPtr reg1, struct _Box * invRect);
    void (* RegionReset)(RegionPtr pRegion, struct _Box *pBox);
    void (* TranslateRegion)(RegionPtr pRegion, int x, int y);
    int (* RectIn)(RegionPtr pRegion, struct _Box *pRect);
    Bool (* PointInRegion)(RegionPtr pRegion, int x, int y, struct _Box *pBox);
    Bool (* RegionNotEmpty)(RegionPtr pRegion);
    void (* RegionEmpty)(RegionPtr pRegion);
    BoxPtr (* RegionExtents)(RegionPtr pRegion);
    Bool (* RegionAppend)(RegionPtr, RegionPtr);
    Bool (* RegionValidate)(RegionPtr pRegion, Bool *pOverlap);
    RegionPtr (* BitmapToRegion)(PixmapPtr);
    RegionPtr (* RectsToRegion)(int nrects, struct _xRectangle *pRects, int ordering);
    void (* SendGraphicsExpose)(struct _Client *client, RegionPtr rgn, unsigned long draw, int major, int minor);

    /* os layer procedures */
    void (* BlockHandler)(int, pointer, pointer, pointer);
    void (* WakeupHandler)(int, pointer, unsigned long, pointer);
    pointer blockData;
    pointer wakeupData;

    /* anybody can get a piece of this array */
    DevUnion	*devPrivates;
};

    Bool mxCloseScreen(int index, ScreenPtr pScreen);
    void mxQueryBestSize();		/* class, pwidth, pheight */
    Bool mxSaveScreen(ScreenPtr, int);		/* pScreen, on */
    void mxGetImage(DrawablePtr pDrawable, unsigned sx, unsigned sy,
		int w, int h, unsigned int format, unsigned long planemask,
		pointer pdestbits);
    void mxPointerNonInterestBox(ScreenPtr, struct _Box *);

    void miSourceValidate(DrawablePtr pDrawable, int x, int y, int w, int h);

    /* Window Procedures */

    Bool mxCreateWindow(WindowPtr pWin);
    Bool mxDestroyWindow(WindowPtr pWin);
    Bool mxPositionWindow(WindowPtr pWin, int x, int y);
    Bool mxChangeWindowAttributes(WindowPtr pWin, unsigned long mask);
    Bool mxRealizeWindow(WindowPtr pWin);
    Bool mxUnrealizeWindow(WindowPtr pWin);
    int  miValidateTree(WindowPtr pParent, WindowPtr pChild, VTKind top);
    void miWindowExposures(WindowPtr, RegionPtr, RegionPtr);

    void mxPaintWindow(WindowPtr pWin, RegionPtr pRgn, int which);
    void mxCopyWindow(WindowPtr pWin, DDXPointRec oldPt, RegionPtr pOldRegion);
    void mxClearToBackground(WindowPtr pWin, int x, int y,
			    unsigned int w, unsigned int h, Bool sendExpose);

    /* Pixmap procedures */

    PixmapPtr mxCreatePixmap(ScreenPtr pScreen, int width, int height, int depth);
    Bool mxDestroyPixmap(PixmapPtr pPixmap);

    /* Backing store procedures */

    /* Font procedures */

    Bool mxRealizeFont(ScreenPtr, struct _Font *);
    Bool mxUnrealizeFont(ScreenPtr, struct _Font *);

    /* Cursor Procedures */
    void mxConstrainCursor(ScreenPtr, struct _Box *);
    void mxCursorLimits(ScreenPtr, struct _Cursor *, BoxPtr, BoxPtr);
    Bool mxDisplayCursor(ScreenPtr, struct _Cursor *);
    Bool mxRealizeCursor(ScreenPtr, struct _Cursor *);
    Bool mxUnrealizeCursor(ScreenPtr, struct _Cursor *);
    void mxRecolorCursor(ScreenPtr, struct _Cursor *, Bool);
    Bool mxSetCursorPosition(ScreenPtr, int, int, Bool);

    /* GC procedures */

    Bool mxCreateGC(GCPtr pGC);

    /* Colormap procedures */

    Bool mxCreateColormap(struct _ColormapRec *);
    void mxDestroyColormap(struct _ColormapRec *);
    void mxInstallColormap(struct _ColormapRec *);
    void mxUninstallColormap(struct _ColormapRec *);
    int mxListInstalledColormaps(ScreenPtr, Colormap *);
    void mxStoreColors();		/* pmap, ndef, pdef */
    void mxResolveColor(u_short *, u_short *, u_short *, struct _Visual *);

    /* Region procedures */

    RegionPtr miRegionCreate(struct _Box * rect, int size);
    void miRegionInit(RegionPtr pRegion, struct _Box *rect, int size);
    Bool miRegionCopy(RegionPtr dstrgn, RegionPtr srcrgn);
    void miRegionDestroy(RegionPtr pRegion);
    void miRegionUninit(RegionPtr pRegion);
    Bool miIntersect(RegionPtr newReg, RegionPtr reg1, RegionPtr reg2);
    Bool miUnion(RegionPtr newReg, RegionPtr reg1, RegionPtr reg2);
    Bool miSubtract(RegionPtr regD, RegionPtr regM, RegionPtr regX);
    Bool miInverse(RegionPtr newReg, RegionPtr reg1, struct _Box * invRect);
    void miRegionReset(RegionPtr pRegion, struct _Box *pBox);
    void miTranslateRegion(RegionPtr pRegion, int x, int y);
    int miRectIn(RegionPtr pRegion, struct _Box *pRect);
    Bool miPointInRegion(RegionPtr pRegion, int x, int y, struct _Box *pBox);
    Bool miRegionNotEmpty(RegionPtr pRegion);
    void miRegionEmpty(RegionPtr pRegion);
    BoxPtr miRegionExtents(RegionPtr pRegion);
    Bool miRegionAppend(RegionPtr, RegionPtr);
    Bool miRegionValidate(RegionPtr pRegion, Bool *pOverlap);
    RegionPtr mxBitmapToRegion(PixmapPtr);
    RegionPtr mxRectsToRegion(int nrects, struct _xRectangle *pRects, int ordering);
    void miSendGraphicsExpose(struct _Client *client, RegionPtr rgn, unsigned long draw, int major, int minor);

typedef struct _Screen ScreenRec;

typedef struct _ScreenInfo {
    int		imageByteOrder;
    int		bitmapScanlineUnit;
    int		bitmapScanlinePad;
    int		bitmapBitOrder;
    int		numPixmapFormats;
    PixmapFormatRec
		formats[MAXFORMATS];
    int		arraySize;
    int		numScreens;
#if MAXSCREENS == 1
    ScreenRec	screen;
#else
    ScreenPtr	screens[MAXSCREENS];
#endif
} ScreenInfo;

extern ScreenInfo screenInfo;

void InitOutput(ScreenInfo *, int, char **);

#endif /* SCREENINTSTRUCT_H */
