	title PGLUE - Packet driver real-mode glue routines

	.286p

	include	shared.inc

;NULL	SEGMENT WORD PUBLIC 'BEGDATA'
;NULL	ENDS
_DATA	SEGMENT PARA PUBLIC 'DATA'
_DATA	ENDS
_TEXT	SEGMENT  para PUBLIC 'CODE'
_TEXT	ENDS

DGROUP	GROUP	_DATA

_DATA	SEGMENT

		align	10h
	PUBLIC	_shared
_shared		real_data	<>	; must be first

n_buf	db	6 dup (0)
nums	db	'0123456789abcdef'

kbd_ack	db	?
		align	2
kbd_count	dw	?

_DATA	ENDS


	ASSUME cs:_TEXT, ds:DGROUP, es:nothing, ss:nothing

_TEXT	SEGMENT

	ASSUME	ds:nothing
	PUBLIC	_kbd_int
_kbd_int	PROC far
	push	ax
	push	bx
	push	dx
	push	ds

	mov	ax,DGROUP
	mov	ds,ax
	ASSUME	ds:DGROUP

	in	al,60h
	; first, check for an ack
	mov	ah,al
	and	ah,0f0h
	cmp	ah,0f0h
	je	ack
	mov	dx,_shared.kbd_end
	mov	bx,dx
	inc	dx
	and	dx,31
	cmp	dx,_shared.kbd_start
	je	buf_full
	mov	_shared.kbd_buff[bx],al
	mov	_shared.kbd_end,dx
	or	_shared.input,1
	jmp	short buf_full
ack:
	mov	kbd_ack,al
buf_full:
	mov	al,20h
	out	20h,al

	pop	ds
	pop	dx
	pop	bx
	pop	ax
	ASSUME	ds: nothing
	iret
_kbd_int	ENDP

	ASSUME	ds:DGROUP
PUBLIC	@kbd_command
@kbd_command	PROC near
	mov	ah,al		; save com
rexmit:
	mov	kbd_count,2000	; time out count
	cli
com_1:
	dec	kbd_count
	jz	com_2		; did we time out?
	in	al,64h
	or	al,2		; is ready bit set?
	jz	com_1
com_2:
	sti
	mov	kbd_ack,0
	mov	al,ah		; command
	out	60h,al

	mov	kbd_count,5000	; wait for ack
com_3:
	dec	kbd_count
	jz	com_4		; did we time out?
	mov	al,kbd_ack
	or	al,al
	jz	com_3
com_4:
	cmp	al,0feh
	je	rexmit
 	xor	ax,ax		; returned bytes = 0
	ret
@kbd_command	ENDP

	PUBLIC	_kbd_country
_kbd_country	PROC near
	push	bp
	mov	bp,sp
	sub	sp,38
	mov	dx,sp
	mov	ax,3800h
	int	21h
	xor	ah,ah
	cmp	al,-1
	jne	kc_1
	mov	ax,bx
kc_1:
	mov	sp,bp
	pop	bp
	ret
_kbd_country	ENDP

;	old_handle_off	dw	?
;	old_handle_seg	dw	?
;	old_handle_mask	dw	?

	PUBLIC	@mouse_init
@mouse_init	PROC near
	mov	cx,ax		; flags
	mov	ax,cs
	mov	es,ax
	ASSUME	es:_TEXT
	or	_shared.flags,0004h
	mov	dx,offset mouse_handle
;	mov	ax,20
	mov	ax,12
	int	33h
;	assume	es:nothing
;	mov	old_handle_mask,cx
;	mov	old_handle_off,dx
;	mov	old_handle_seg,es
	cli
	sub	ax,ax
	mov	_shared.mouse_start,ax
	mov	_shared.mouse_end,ax
	sti
	ret
@mouse_init	ENDP

	PUBLIC	_mouse_shutdown
_mouse_shutdown	PROC near
	and	_shared.flags,(not 0004h)
;	mov	cx,old_handle_mask
;	mov	dx,old_handle_off
;	mov	es,old_handle_seg

	mov	ax,12
	xor	cx,cx
	mov	dx,cx
	mov	es,dx
	int	33h
	xor	ax,ax
	ret
_mouse_shutdown	ENDP

mouse_handle	PROC FAR
	ASSUME	ds:nothing
	push	ds
	mov	dx,DGROUP
	mov	ds,dx
	ASSUME	ds:DGROUP

	mov	dx,di
	mov	cx,_shared.mouse_end
	mov	di,cx
	inc	cx
	and	cx,31
	mov	_shared.mouse_end,cx
	cmp	cx,_shared.mouse_start
	jne	mouse_ok
	inc	cx
	and	cx,31
	mov	_shared.mouse_start,cx
mouse_ok:
	shl	di,3
	mov	word ptr _shared.mouse_buff[di],ax
	mov	word ptr _shared.mouse_buff[di+2],bx
	mov	word ptr _shared.mouse_buff[di+4],si
	mov	word ptr _shared.mouse_buff[di+6],dx
	or	_shared.input,2
	pop	ds
	ASSUME	ds:nothing
	ret
mouse_handle	ENDP

	PUBLIC	@dfputs
; void _fastcall dfputs(cp)
; char *cp;
@dfputs	PROC NEAR
	ASSUME	ds:DGROUP
	push	si
	mov	si,bx
	mov	ah,2
put_loop:
	lodsb
	or	al,al
	jz	put_exit
	mov	dl,al
	int	21h
	jmp	short put_loop
put_exit:
	pop	si
	ret
@dfputs	ENDP

	PUBLIC	@printn
@printn PROC NEAR
	xor	bl,bl
	mov	n_buf+4,bl
	mov	bx,ax
	and	bx,0fh
	mov	bl,nums[bx]
	mov	n_buf+3,bl
	shr	ax,4
	mov	bx,ax
	and	bx,0fh
	mov	bl,nums[bx]
	mov	n_buf+2,bl
	shr	ax,4
	mov	bx,ax
	and	bx,0fh
	mov	bl,nums[bx]
	mov	n_buf+1,bl
	shr	ax,4
	mov	bx,ax
	and	bx,0fh
	mov	bl,nums[bx]
	mov	n_buf,bl
	mov	bx,offset n_buf
	jmp	short @dfputs
@printn	ENDP

	PUBLIC	_err_handler
_err_handler	PROC FAR
	mov	al,3	; FAIL
	iret
_err_handler	ENDP

_TEXT	ENDS
	END
