#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include "shared.h"
#include "funcdef.h"

unsigned char rpc_handle = 0;
volatile struct real_data _far *pshared = 0;

int
glue_open()
{
    short i;
    unsigned short buf[4];

    i = rpc_init("GLUE.EXE");
    if (i < 0)
	return -1;
    rpc_handle = i;
    buf[0] = FUNC_INIT;
    i = rpc_call(rpc_handle, sizeof buf, 2, (char *)buf);
    if (!i)
	return -9;
    /* The buffer is organized like this:
     * (short) word 0:	status
     *		    1:  pad
     *		    2:  offset of shared address
     *		    3:	segment of shared address
     */
    if (buf[0])
	return buf[0];
    /* convert to real address (20 bits) */
    i = get_real_window((buf[3] << 4) + buf[2],
	(sizeof (struct real_data) + 15) & 0xfff0);
    if (!i)
	return -10;
    ((short *)&pshared)[2] = i;

    /* Set the config'd bit */
    pshared->flags |= 0x0001;
    return 0;
}

void
glue_close()
{
    short buf[1];

    buf[0] = FUNC_SHUTDOWN;
    rpc_call(rpc_handle, 0, sizeof buf, buf);
}

void
trap_harderr()
{
    short buf[1];

    buf[0] = FUNC_HARDERR;
    rpc_call(rpc_handle, 0, sizeof buf, buf);
}
