#ifdef __HIGHC__
_packed
#endif
#ifdef __WATCOMC__
#pragma pack(1);
#endif
struct mouse_event {
	unsigned short event_mask;
	unsigned short buttons;
	short xdiff;
	short ydiff;
};

#define KBDBUFSIZE 32
#define MOUSEBUFSIZE 32

struct real_data {
	unsigned short input;
	unsigned short kbd_start;
	unsigned short kbd_end;
	unsigned char kbd_buff[KBDBUFSIZE];
	unsigned short mouse_start;
	unsigned short mouse_end;
	struct mouse_event mouse_buff[MOUSEBUFSIZE];
	unsigned short flags;
#define INITED		0x0001
#define KBD_OPEN	0x0002
#define MOUSE_OPEN	0x0004
};

#ifdef __HIGHC__
extern struct real_data _Far *pshared;
#endif

#ifdef __WATCOMC__
#pragma pack();
extern volatile struct real_data _far *pshared;
#endif

/* function codes */
#define FUNC_INIT	1
#define FUNC_SHUTDOWN	2
#define FUNC_KBD_INIT	3
#define FUNC_KBD_SHUT	4
#define FUNC_KBD_COM	5
#define FUNC_MOUSE_INIT	6
#define FUNC_MOUSE_SHUT	7
#define FUNC_VESA_INIT	8
#define FUNC_HARDERR	9
#define FUNC_KBD_COUNTRY	10
