#include "X.h"
#include "Xmd.h"
#include "misc.h"
#include "pixmapstr.h"
#include "os.h"		/* for malloc.h */

#include "svga.h"
#include "../../mi/mi.h"

#include "servermd.h"

#include "site.h"
#include "svgafuncs.h"
#include "funcs.h"
#include "mxfuncs.h"

PixmapPtr
mxCreatePixmap(pScreen, width, height, depth)
ScreenPtr pScreen;
int width, height, depth;
{
	int size, devWidth;
	PixmapPtr pPixmap;

	devWidth = PixmapBytePad(width, depth);
	size = height * devWidth;
	pPixmap = (PixmapPtr)xalloc(sizeof(PixmapRec) + size);
	if (!pPixmap)
		return (PixmapPtr)NULL;
	pPixmap->drawable.type = DRAWABLE_PIXMAP;
	pPixmap->drawable.class = 0;
	pPixmap->drawable.pScreen = pScreen;
	pPixmap->drawable.depth = (u_char)depth;
	pPixmap->drawable.bitsPerPixel = (u_char)depth;
	pPixmap->drawable.width = width;
	pPixmap->drawable.height = height;
	pPixmap->drawable.serialNumber = NEXT_SERIAL_NUMBER;
	pPixmap->drawable.x = 0;
	pPixmap->drawable.y = 0;
	pPixmap->refcnt = 1;
	pPixmap->devKind = devWidth;
	pPixmap->devPrivate.ptr = (u_char *)(pPixmap + 1);
	memset((char *)pPixmap->devPrivate.ptr, 0, size);
	return pPixmap;
}

Bool
mxDestroyPixmap(pPixmap)
PixmapPtr pPixmap;
{
	if (--pPixmap->refcnt)
		return TRUE;
	Xfree(pPixmap);
	return TRUE;
}
