#include <string.h>
#include "x.h"
#include "svga.h"
#include "mxfuncs.h"
#include "svgafuncs.h"

/* Move bytes according to rop.
 */
void
copybytes(pdst, psrc, n)
u_char *psrc, *pdst;
int	n;			/* number of bytes */
{
	memcpy(pdst, psrc, n);
}

void
andbytes(pdst, psrc, n)
u_char *psrc, *pdst;
int	n;
{
	while (n--)
		*pdst++ &= *psrc++;
}

void
andReversebytes(pdst, psrc, n)
u_char *psrc, *pdst;
int	n;
{
	while (n--)
		*pdst++ = ~*pdst & *psrc++;
}

void
andInvertedbytes(pdst, psrc, n)
u_char *psrc, *pdst;
int	n;
{
	while (n--)
		*pdst++ &= ~*psrc++;
}

void
xorbytes(pdst, psrc, n)
u_char *psrc, *pdst;
int	n;
{
	while (n--)
		*pdst++ ^= *psrc++;
}

void
norbytes(pdst, psrc, n)
u_char *psrc, *pdst;
int	n;
{
	while (n--)
		*pdst++ = ~(*pdst | *psrc++);
}

void
equivbytes(pdst, psrc, n)
u_char *psrc, *pdst;
int	n;
{
	while (n--)
		*pdst++ ^= ~*psrc++;
}

void
orReversebytes(pdst, psrc, n)
u_char *psrc, *pdst;
int	n;
{
	while (n--)
		*pdst++ = ~*pdst | *psrc++;
}

void
orInvertedbytes(pdst, psrc, n)
u_char *psrc, *pdst;
int	n;
{
	while (n--)
		*pdst++ |= ~*psrc++;
}

void
nandbytes(pdst, psrc, n)
u_char *psrc, *pdst;
int	n;
{
	while (n--)
		*pdst++ = ~(*pdst & *psrc++);
}

void
copybyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	if (pmask == 0xff)
		memset(pdst, src, n);
	else
		while (n--)
			*pdst++ = (src & pmask) | (*pdst & ~pmask);
}

void
xorbyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	src &= pmask;
	while (n--)
		*pdst++ ^= src;
}

void
clearbyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	src = src;

	if (pmask == 0xff)
	    memset(pdst, 0, n);
	else
	    while (n--)
		*pdst++ &= ~pmask;
}

void
andbyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	src |= ~pmask;
	while (n--)
		*pdst++ &= src;
}

void
andReversebyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	if (pmask == 0xff)
	    while (n--)
		    *pdst++ = src & ~*pdst;
	else
	    while (n--)
		    *pdst++ = (src & ~*pdst & pmask) | (*pdst & ~pmask);
}

void
andInvertedbyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	andbyte(pdst, ~src, n, pmask);
}

void
noopbyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	pdst = pdst;
	src = src;
	n = n;
	pmask = pmask;
}

void
orbyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	src &= pmask;
	while (n--)
		*pdst++ |= src;
}

void
norbyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	andReversebyte(pdst, ~src, n, pmask);
}

void
equivbyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	src = ~src & pmask;
	while (n--)
		*pdst++ ^= src;
}

void
invertbyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	src = src;
	while (n--)
		*pdst++ ^= pmask;
}

void
orReversebyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	if (pmask == 0xff)
	    while (n--)
		    *pdst++ = src | ~*pdst;
	else
	    while (n--)
		    *pdst++ = ((src | ~*pdst) & pmask) | (*pdst & ~pmask);
}

void
copyInvertedbyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	copybyte(pdst, ~src, n, pmask);
}

void
orInvertedbyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	orbyte(pdst, ~src, n, pmask);
}

void
nandbyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	orReversebyte(pdst, ~src, n, pmask);
}

void
setbyte(pdst, src, n, pmask)
u_char *pdst;
u_char src;
int n;
u_char pmask;
{
	src = src;
	if (pmask == 0xff)
	    memset(pdst, 0xff, n);
	else
	    while (n--)
		*pdst++ |= pmask;
}
