#include <dos.h>
#include "X.h"
#include "scrnintstr.h"
#include "windowstr.h"
#include "svga.h"
#include "../../mi/mistruct.h"
#include "regionstr.h"
#include "gcstruct.h"
#include "../../../os/msdos/msdos.h"
#include "mxfuncs.h"
#include "svgafuncs.h"

RegionPtr
mxCopyArea(pSrcDrawable, pDstDrawable,
	    pGC, xIn, yIn, widthSrc, heightSrc, xOut, yOut)
    DrawablePtr 	pSrcDrawable;
    DrawablePtr 	pDstDrawable;
    GCPtr 			pGC;
    int 			xIn, yIn;
    int 			widthSrc, heightSrc;
    int 			xOut, yOut;
{
    BoxRec 		dstBox, *prect;
    			/* may be a new region, or just a copy */
    RegionPtr 		prgnDst, prgnSrc, prgnNew=0;
    int			y;
    int			dx, dy, i, j, srcx, srcy,
    			xMin, xMax, yMin, yMax;
    unsigned int	*ordering;
    int			depth = pSrcDrawable->depth;
    u_char		iswin = 0;
    Bool revx = 0;	/* True if scrollling right and stationary vertical */
    Bool revy = 0;	/* True if scrolling down */
    u_char	*pm_psrcBase, *pm_pdstBase;	/* pointers for pixmaps */
    int			srcWidth, dstWidth;
    int			srcInc, dstInc;
    Bool		realSrcClip=0;
    WindowPtr		pWin = 0;
    int			alu = pGC->alu;
    /* TODO: figure out if src needs to be used at all (for instance if
     * alu == GXinvert the only dst is used. */
    int			num_rects;
    u_char		*buf = 0;
    svgaPrivGC		*pPriv = (svgaPrivGC *)(pGC->devPrivates[svgaGCPrivateIndex].ptr);
    void (*movebytes)(u_char *, u_char *, int) = pPriv->movebytes;
    void (*movebits)(u_char *, u_char *, int, int, int) = pPriv->movebits;

    srcx = xIn;
    srcy = yIn;

    /* If the destination isn't realized, this is easy */
    if (pDstDrawable->type == DRAWABLE_WINDOW &&
	!((WindowPtr)pDstDrawable)->realized)
    {
	return NULL;
    }

    if (pSrcDrawable->type == DRAWABLE_WINDOW)
    {

	srcx += pSrcDrawable->x;
	srcy += pSrcDrawable->y;
	iswin |= 2;
	srcWidth = svga_width;
	if (pGC->subWindowMode == IncludeInferiors)
	{
	    prgnSrc = NotClippedByChildren((WindowPtr)pSrcDrawable);
	    realSrcClip = 1;
	}
	else
	{
	    prgnSrc = &((WindowPtr)pSrcDrawable)->clipList;
	}
	if (pDstDrawable->type != DRAWABLE_WINDOW ||
	    pDstDrawable == pSrcDrawable)
		pWin = (WindowPtr)pSrcDrawable;
    } else {
	srcWidth = ((PixmapPtr)pSrcDrawable)->devKind;
	pm_psrcBase = ((PixmapPtr)pSrcDrawable)->devPrivate.ptr;
	prgnSrc = 0;
	if (pDstDrawable->type == DRAWABLE_WINDOW)
		pWin = (WindowPtr)pDstDrawable;
    }

    prgnDst = ((svgaPrivGC *)(pGC->devPrivates[svgaGCPrivateIndex].ptr))->pCompositeClip;

    if (pDstDrawable->type == DRAWABLE_WINDOW)
    {
	dx = xOut + pDstDrawable->x;
	dy = yOut + pDstDrawable->y;
	iswin |= 1;
	dstWidth = svga_width;
    }
    else
    {
	dx = xOut;
	dy = yOut;
	dstWidth = ((PixmapPtr)pDstDrawable)->devKind;
	pm_pdstBase = ((PixmapPtr)pDstDrawable)->devPrivate.ptr;
    }

    /* If the dst drawable is a window, we need to translate the dstBox so
     * that we can compare it with the window's clip region later on. */
    dstBox.x1 = dx;
    dstBox.y1 = dy;
    dstBox.x2 = dx  + widthSrc;
    dstBox.y2 = dy  + heightSrc;

    dy -= srcy;
    dx -= srcx;

    if (prgnSrc) {
	prgnNew = 
	    (pDstDrawable->pScreen->RegionCreate)((BoxPtr)0, REGION_NUM_RECTS(prgnSrc));
	(pDstDrawable->pScreen->RegionCopy)(prgnNew, prgnSrc);
	(pDstDrawable->pScreen->TranslateRegion)(prgnNew, dx, dy);
	(pDstDrawable->pScreen->Intersect)(prgnNew, prgnNew, prgnDst);
	prgnDst = prgnNew;
    }
    num_rects = REGION_NUM_RECTS(prgnDst);

    ordering = (unsigned int *)
        ALLOCATE_LOCAL(num_rects * sizeof(unsigned int));
    if(!ordering)
    {
       return NULL;
    }

    /* If not the same drawable then order of move doesn't matter.
       Following assumes that prgnDst->rects are sorted from top
       to bottom and left to right.
    */
    if ((pSrcDrawable != pDstDrawable &&
	((pGC->subWindowMode != IncludeInferiors) ||
	 (pSrcDrawable->type == DRAWABLE_PIXMAP) ||
	 (pDstDrawable->type == DRAWABLE_PIXMAP))))
      for (i=0; i < num_rects; i++)
        ordering[i] = i;
    else { /* within same drawable, must sequence moves carefully! */
      if (dy <= 0) { /* Scroll up or stationary vertical.
                                  Vertical order OK */
        if (dx <= 0) { /* Scroll left or stationary horizontal.
                                  Horizontal order OK as well */
          for (i=0; i < num_rects; i++)
            ordering[i] = i;
        } else { /* scroll right. must reverse horizontal banding of rects. */
	  revx = !dy;
          for (i=0, j=1, xMax=0;
               i < num_rects;
               j=i+1, xMax=i) {
            /* find extent of current horizontal band */
            y=REGION_RECTS(prgnDst)[i].y1; /* band has this y coordinate */
            while ((j < num_rects) &&
                   (REGION_RECTS(prgnDst)[j].y1 == y))
              j++;
            /* reverse the horizontal band in the output ordering */
            for (j-- ; j >= xMax; j--, i++)
              ordering[i] = j;
          }
        }
      }
      else { /* Scroll down. Must reverse vertical banding. */
	revy = TRUE;
        if (dx < 0) { /* Scroll left. Horizontal order OK. */
          for (i=num_rects-1, j=i-1, yMin=i, yMax=0;
              i >= 0;
              j=i-1, yMin=i) {
            /* find extent of current horizontal band */
            y=REGION_RECTS(prgnDst)[i].y1; /* band has this y coordinate */
            while ((j >= 0) &&
                   (REGION_RECTS(prgnDst)[j].y1 == y))
              j--;
            /* reverse the horizontal band in the output ordering */
            for (j++ ; j <= yMin; j++, i--, yMax++)
              ordering[yMax] = j;
          }
        }
        else /* Scroll right or horizontal stationary.
                Reverse horizontal order as well (if stationary, horizontal
                order can be swapped without penalty and this is faster
                to compute). */
          for (i=0, j=num_rects-1;
               i < num_rects;
               i++, j--)
              ordering[i] = j;
      }
    }

    if (iswin) {
	if ((iswin == 3 && pSrcDrawable != pDstDrawable) ||
	    CUR_OVERLAP(pWin->drawable.x, pWin->drawable.y,
		pWin->drawable.x + pWin->drawable.width,
		pWin->drawable.y + pWin->drawable.height))
		    HideCursor();
    }
 
    if (revx || (iswin == 3 && alu != GXcopy)) {
	buf = ALLOCATE_LOCAL(widthSrc);
	if (!buf)
	    goto out;
    }

    if (alu == GXnoop || alu == GXset || alu == GXclear || alu == GXinvert) {
	iswin &= ~2;
	revy = 0;
	revx = 0;
	pm_psrcBase = 0;
    }

    if (revy) {
	srcInc = -srcWidth;
	dstInc = -dstWidth;
    } else {
	srcInc = srcWidth;
	dstInc = dstWidth;
    }
    for(i = 0; i < num_rects; i++) {
        prect = &REGION_RECTS(prgnDst)[ordering[i]];
  	xMin = max(prect->x1, dstBox.x1);
  	xMax = min(prect->x2, dstBox.x2);
  	yMin = max(prect->y1, dstBox.y1);
	yMax = min(prect->y2, dstBox.y2);
	/* is there anything visible here? */
	if(xMax <= xMin || yMax <= yMin)
	    continue;

	xMax -= xMin;
	srcx = xMin-dx;

	if (iswin == 3 && alu == GXcopy) {
	    VGACopy(srcx, yMin-dy, xMin, yMin, xMax, yMax - yMin,
		svga_width, svga_page_shift);
	    continue;
	}

	if (revy)
	    y = yMax - 1;
	else
	    y = yMin;

	/* convert to count */
	yMax -= yMin;

	if (depth == 1) {
	    u_char *ypsrc, *ypdst;
	    ypdst = pm_pdstBase + y * dstWidth;
	    ypsrc = pm_psrcBase + (y-dy) * srcWidth;
	    while (yMax--) {
		(*movebits)(ypdst, ypsrc, xMin, srcx, xMax);
		ypsrc += srcInc;
		ypdst += dstInc;
	    }
	} else if (!iswin) {
	    u_char *ypsrc, *ypdst;

	    ypdst = pm_pdstBase + y * dstWidth + xMin;
	    ypsrc = pm_psrcBase + (y-dy) * srcWidth + srcx;

	    if (buf) {
		if (pm_psrcBase)
		    while (yMax--) {
			memcpy(buf, ypsrc, xMax);
			(*movebytes)(ypdst, buf, xMax);
			ypsrc += srcInc;
			ypdst += dstInc;
		    }
		else
		    while (yMax--) {
			(*movebytes)(ypdst, 0, xMax);
			ypdst += dstInc;
		    }
	    } else if (alu == GXcopy) {
		while (yMax--) {
		    memcpy(ypdst, ypsrc, xMax);
		    ypsrc += srcInc;
		    ypdst += dstInc;
		}
	    } else {
		while (yMax--) {
		    (*movebytes)(ypdst, ypsrc, xMax);
		    ypsrc += srcInc;
		    ypdst += dstInc;
		}
	    }
	} else if (iswin == 1) {	/* Dest is window, src is pixmap. */
	    u_long bytenum;
	    u_char page;
	    u_char *psrc;
	    u_char SVGA_BASED *pdst;

	    bytenum = (u_long)y * svga_width + xMin;
	    page = (u_char)(bytenum >> 16);
	    pdst = vga_mem((u_short)bytenum);

	    psrc = pm_psrcBase + (y-dy) * srcWidth + srcx;

	    if (page != svga_curpage) {
		svga_curpage = page;
		SetPage();
	    }

	    while (yMax--) {
		xMin = xMax;
		y = xMax;
		if ((u_short)pdst + xMin > 0x10000) {
		    xMin = (u_short)-(short)pdst;
		}
		if (alu == GXcopy)
		    vga_memcpy(pdst, psrc, xMin);
		else
		    (*movebytes)(pdst, psrc, xMin);
		y -= xMin;
		if (y) {	/* more left over in next page */
		    svga_curpage++;
		    SetPage();
		    pdst = vga_mem(0);
		    if (alu == GXcopy)
			vga_memcpy(pdst, psrc + xMin, y);
		    else
			(*movebytes)(pdst, psrc + xMin, y);
		    pdst += svga_width - xMin;
		} else {
		    pdst += svga_width;
		}
		psrc += srcWidth;
		if (pdst - vga_mem(0) >= 0x10000) {
		    svga_curpage++;
		    SetPage();
		    pdst = vga_mem((u_short)pdst);
		}
	    }
	} else if (iswin == 2) {
	    u_long bytenum;
	    u_char page;
	    u_char *pdst;
	    u_char SVGA_BASED *psrc;

	    pdst = pm_pdstBase + y * dstWidth + xMin;

	    bytenum = (u_long)(y-dy) * svga_width + srcx;
	    page = (u_char)(bytenum >> 16);
	    psrc = vga_mem((u_short)bytenum);

	    if (page != svga_curpage) {
		svga_curpage = page;
		SetPage();
	    }

	    while (yMax--) {

		y = xMax;	/* X count */
		xMin = xMax;
		if (xMin + (unsigned)(u_short)psrc > 0x10000) {
		    xMin = 0x10000 - (u_short)psrc;
		}
		if (alu == GXcopy)
		    vga_memcpy(pdst, psrc, xMin);
		else
		    (*movebytes)(pdst, psrc, xMin);
		y -= xMin;
		if (y) {	/* more left over in next page */
		    page++;
		    svga_curpage = page;
		    SetPage();
		    psrc = vga_mem(0);
		    if (alu == GXcopy)
			vga_memcpy(pdst + xMin, psrc, y);
		    else
			(*movebytes)(pdst + xMin, psrc, y);
		    psrc += svga_width - xMin;
		} else {
		    psrc += svga_width;
		}
		pdst += dstWidth;
		if (psrc - vga_mem(0) >= 0x10000) {
		    page++;
		    svga_curpage = page;
		    SetPage();
		    psrc -= 0x10000;
		}
	    }
	} else {
	    /* Copying from window to window.  alu is never GXcopy.
	     * Watch out for revy.  Always use buf. */

	    u_long bytenum;
	    u_char spage, dpage;
	    u_char SVGA_BASED *psrc, *pdst, *zp;

	    bytenum = (u_long)(y-dy) * svga_width + srcx;
	    spage = (u_char)(bytenum >> 16);
	    psrc = vga_mem((u_short)bytenum);

	    bytenum = (u_long)y * svga_width + xMin;
	    dpage = (u_char)(bytenum >> 16);
	    pdst = vga_mem((u_short)bytenum);
	    zp = vga_mem(0);

	    while (yMax--) {
		/* Two phases:  Copy from psrc to buf.
				Copy from buf to pdst. */
		if (spage != svga_curpage) {
		    svga_curpage = spage;
		    SetPage();
		}
		if ((unsigned)(u_short)psrc + xMax > 0x10000) {
		    xMin = (u_short)-(short)psrc;
		    vga_memcpy(buf, psrc, xMin);
		    ++svga_curpage;
		    SetPage();
		    vga_memcpy(buf+xMin, zp, xMax - xMin);
		} else
		    vga_memcpy(buf, psrc, xMax);

		/* Copy from buf to pdst */
		if (dpage != svga_curpage) {
		    svga_curpage = dpage;
		    SetPage();
		}
		if ((unsigned)(u_short)pdst + xMax > 0x10000) {
		    xMin = (u_short)-(short)pdst;
		    (*movebytes)(pdst, buf, xMin);
		    ++svga_curpage;
		    SetPage();
		    (*movebytes)(zp, buf + xMin, xMax - xMin);
		} else
		    (*movebytes)(pdst, buf, xMax);

		/* Go to next line */
		if (revy) {
		    if ((u_short)psrc < svga_width) {
			spage--;
			psrc -= svga_width;
			psrc = vga_mem((u_short)psrc);
		    } else
			psrc -= svga_width;
		    if ((u_short)pdst < svga_width) {
			dpage--;
			pdst -= svga_width;
			pdst = vga_mem((u_short)pdst);
		    } else
			pdst -= svga_width;
		} else {
		    if ((u_short)psrc + svga_width > 0x10000) {
			spage++;
			psrc += svga_width;
			psrc = vga_mem((u_short)psrc);
		    } else
			psrc += svga_width;
		    if ((u_short)pdst + svga_width > 0x10000) {
			dpage++;
			pdst += svga_width;
			pdst = vga_mem((u_short)pdst);
		    } else
			pdst += svga_width;
		}
	    }
	}
    }

    if (iswin == 3 && alu == GXcopy)
	SetPage();

out:
    prgnDst = miHandleExposures(pSrcDrawable, pDstDrawable, pGC, xIn, yIn,
		      widthSrc, heightSrc, xOut, yOut, 0L);
    if (prgnNew)
	(*pGC->pScreen->RegionDestroy)(prgnNew);
	
    if(realSrcClip)
	(*pGC->pScreen->RegionDestroy)(prgnSrc);

    DEALLOCATE_LOCAL(ordering);
    return prgnDst;
}

/*
 * Take the plane from SrcDrawable specified by bitPlane and turn it into
 * a bitmap.  Then use this bitmap with fillStyle = FillOpaqueStippled to
 * draw into DstDrawable.
 */
RegionPtr
mxCopyPlane(pSrcDrawable, pDstDrawable,
	    pGC, srcx, srcy, width, height, dstx, dsty, bitPlane)
    DrawablePtr 	pSrcDrawable;
    DrawablePtr		pDstDrawable;
    GCPtr		pGC;
    int 		srcx, srcy;
    int 		width, height;
    int 		dstx, dsty;
    unsigned long	bitPlane;
{
    int			i, j;
    PixmapPtr		bitmap;
    Bool		made_bitmap;
    DDXPointPtr		pptFirst, ppt;
    BoxRec		box;
    int	*pwidthFirst, *pwidth;
    int			oldFillStyle;
    PixmapPtr		oldStipple;
    DDXPointRec		oldPatOrg;
    int			x, y;

    if (!width || !height)
	return 0;

    ppt = pptFirst = (DDXPointPtr)ALLOCATE_LOCAL(height * sizeof(DDXPointRec));
    pwidth = pwidthFirst = (int *)ALLOCATE_LOCAL(height * sizeof(int));
    if(!pptFirst || !pwidthFirst)
    {
printf("CopyPlane: ALLOCATE_LOCAL failed, height=%d\n", height);
       if (pwidthFirst)
	   DEALLOCATE_LOCAL(pwidthFirst);
       if (pptFirst)
	   DEALLOCATE_LOCAL(pptFirst);
       return 0;
    }

    if (pSrcDrawable->depth == 1) {	/* it's already a bitmap */
	bitmap = (PixmapPtr)pSrcDrawable;
	made_bitmap = 0;
    } else {
	u_char *data, *cp, *dp, *bp, mask;

	bitmap = mxCreatePixmap(pDstDrawable->pScreen, width, height, 1);
	if (!bitmap) {
	    made_bitmap = 0;
	    goto out;
	}
	made_bitmap = 1;
	data = xalloc(width * height);
	if (!data) {
printf("CopyPlane: xalloc failed: %dx%d\n", width, height);
	    goto out;
	}

	x = srcx + pSrcDrawable->x;
	y = srcy + pSrcDrawable->y;

	for(i = 0; i < height; i++)
	{
	    ppt->x = x;
	    ppt->y = y + i;
	    ppt++;
	    *pwidth++ = width;
	}
	ppt = pptFirst;
	pwidth = pwidthFirst;
	mxGetSpans(pSrcDrawable, width, pptFirst, pwidthFirst, height, data);
	cp = data;
	bp = (char *)bitmap->devPrivate.ptr;
	for (i = 0; i < height; i++) {
	    mask = 0x80;
	    dp = bp;
	    for (j = 0; j < width; j++) {
		if (*cp & (u_char)bitPlane)
		    *dp |= mask;
		cp++;
		mask >>= 1;
		if (!mask) {
			dp++;
			mask = 0x80;
		}
	    }
	    bp += bitmap->devKind;
	}

	xfree(data);
    }

    oldFillStyle = pGC->fillStyle;
    pGC->fillStyle = FillOpaqueStippled;
    oldStipple = pGC->stipple;
    pGC->stipple = bitmap;
    oldPatOrg = pGC->patOrg;
    pGC->patOrg.x = dstx - srcx;
    pGC->patOrg.y = dsty - srcy;

    x = dstx + pDstDrawable->x;
    y = dsty + pDstDrawable->y;

    box.x1 = x;
    box.x2 = x + width;
    box.y1 = y;
    box.y2 = y + height;

    for(i = 0; i < height; i++)
    {
	ppt->x = x;
	ppt->y = y + i;
	ppt++;
	*pwidth++ = width;
    }
    (*pGC->ops->FillSpans)(pDstDrawable, pGC, height, pptFirst, pwidthFirst,
	    SPANS_SORTED|SPANS_RECT, &box);

    pGC->fillStyle = oldFillStyle;
    pGC->stipple = oldStipple;
    pGC->patOrg = oldPatOrg;
out:
    DEALLOCATE_LOCAL(pwidthFirst);
    DEALLOCATE_LOCAL(pptFirst);
    if (made_bitmap)
	mxDestroyPixmap(bitmap);
    return miHandleExposures(pSrcDrawable, pDstDrawable, pGC, srcx, srcy,
		      width, height, dstx, dsty, 0L);
}
