#include	"X.h"
#include	"keysym.h"

#define KBD_OFFSET	7

typedef struct _KeySymsRec {
    long map;
    KeyCode minKeyCode,
	    maxKeyCode;
    long     mapWidth;
} KeySymsRec, *KeySymsPtr;

KeySymsRec pcKeySyms_Latinam = {
    /*	map	   minKeyCode		maxKC		width */
    0,		1+KBD_OFFSET,	0x80+KBD_OFFSET,	3,
};

/* All these codes have 7 added to them by the keyboard driver */
KeySym PCMap_Latinam[] = {
	XK_Escape,	NoSymbol,	NoSymbol,	/* 0x01 */
	XK_1,		XK_exclam,	NoSymbol,	/* 0x02 */
	XK_2,		XK_quotedbl,	NoSymbol,	/* 0x03 */
	XK_3,		XK_numbersign,	NoSymbol,	/* 0x04 */
	XK_4,		XK_dollar,	NoSymbol,	/* 0x05 */
	XK_5,		XK_percent,	NoSymbol,	/* 0x06 */
	XK_6,		XK_ampersand,	NoSymbol,	/* 0x07 */
	XK_7,		XK_slash,	NoSymbol,	/* 0x08 */
	XK_8,		XK_parenleft,		NoSymbol,	/* 0x09 */
	XK_9,		XK_parenright,	NoSymbol,	/* 0x0a */
	XK_0,		XK_equal,	NoSymbol,	/* 0x0b */
	XK_quoteright,	XK_question,	XK_backslash,	/* 0x0c */
	XK_questiondown,	XK_exclamdown,	NoSymbol,	/* 0x0d */
	XK_BackSpace,	NoSymbol,	NoSymbol,	/* 0x0e */
	XK_Tab,		NoSymbol,	NoSymbol,	/* 0x0f */
	XK_Q,		NoSymbol,	XK_at,/* 0x10 */
	XK_W,		NoSymbol,	NoSymbol,	/* 0x11 */
	XK_E,		NoSymbol,	NoSymbol,	/* 0x12 */
	XK_R,		NoSymbol,	NoSymbol,	/* 0x13 */
	XK_T,		NoSymbol,	NoSymbol,	/* 0x14 */
	XK_Y,		NoSymbol,	NoSymbol,	/* 0x15 */
	XK_U,		NoSymbol,	NoSymbol,	/* 0x16 */
	XK_I,		NoSymbol,	NoSymbol,	/* 0x17 */
	XK_O,		NoSymbol,	NoSymbol,	/* 0x18 */
	XK_P,		NoSymbol,	NoSymbol,	/* 0x19 */
	XK_acute,	XK_diaeresis,	NoSymbol,	/* 0x1a */
	NoSymbol, 	XK_asterisk,	XK_asciitilde,	/* 0x1b */
	XK_Return,	NoSymbol,	NoSymbol,	/* 0x1c */

	XK_Control_L,	NoSymbol,	NoSymbol,	/* 0x1d */
	XK_A,		NoSymbol,	NoSymbol,	/* 0x1e */
	XK_S,		NoSymbol,	NoSymbol,	/* 0x1f */
	XK_D,		NoSymbol,	NoSymbol,	/* 0x20 */
	XK_F,		NoSymbol,	NoSymbol,	/* 0x21 */
	XK_G,		NoSymbol,	NoSymbol,	/* 0x22 */
	XK_H,		NoSymbol,	NoSymbol,	/* 0x23 */
	XK_J,		NoSymbol,	NoSymbol,	/* 0x24 */
	XK_K,		NoSymbol,	NoSymbol,	/* 0x25 */
	XK_L,		NoSymbol,	NoSymbol,	/* 0x26 */
	XK_Ntilde,	NoSymbol,	NoSymbol,	/* 0x27 */
	XK_braceleft,	XK_bracketleft,	XK_asciicircum,	/* 0x28 */
	XK_bar,	XK_degree,	XK_notsign,		/* 0x29 */
	XK_Shift_L,	NoSymbol,	NoSymbol,	/* 0x2a */
	XK_braceright,	XK_bracketright,	XK_quoteleft,	/* 0x2b */

	XK_Z,		NoSymbol,	NoSymbol,	/* 0x2c */
	XK_X,		NoSymbol,	NoSymbol,	/* 0x2d */
	XK_C,		NoSymbol,	NoSymbol,	/* 0x2e */
	XK_V,		NoSymbol,	NoSymbol,	/* 0x2f */
	XK_B,		NoSymbol,	NoSymbol,	/* 0x30 */
	XK_N,		NoSymbol,	NoSymbol,	/* 0x31 */
	XK_M,		NoSymbol,	NoSymbol,	/* 0x32 */
	XK_comma,	XK_semicolon,	NoSymbol,	/* 0x33 */
	XK_period,	XK_colon,	NoSymbol,	/* 0x34 */
	XK_minus,	XK_underscore,	NoSymbol,	/* 0x35 */
	XK_Shift_R,	NoSymbol,	NoSymbol,	/* 0x36 */
	XK_KP_Multiply,	NoSymbol,	NoSymbol,	/* 0x37 */
	XK_Alt_L,	NoSymbol,	NoSymbol,	/* 0x38 */
	XK_space,	NoSymbol,	NoSymbol,	/* 0x39 */
	XK_Caps_Lock,	NoSymbol,	NoSymbol,	/* 0x3a */
	XK_F1,		NoSymbol,	NoSymbol,	/* 0x3b */
	XK_F2,		NoSymbol,	NoSymbol,	/* 0x3c */
	XK_F3,		NoSymbol,	NoSymbol,	/* 0x3d */
	XK_F4,		NoSymbol,	NoSymbol,	/* 0x3e */
	XK_F5,		NoSymbol,	NoSymbol,	/* 0x3f */
	XK_F6,		NoSymbol,	NoSymbol,	/* 0x40 */
	XK_F7,		NoSymbol,	NoSymbol,	/* 0x41 */
	XK_F8,		NoSymbol,	NoSymbol,	/* 0x42 */
	XK_F9,		NoSymbol,	NoSymbol,	/* 0x43 */
	XK_F10,		NoSymbol,	NoSymbol,	/* 0x44 */
	XK_Num_Lock,	NoSymbol,	NoSymbol,	/* 0x45 */
	XK_Pause,	NoSymbol,	NoSymbol,	/* 0x46 */
	XK_KP_7,	XK_Home,	NoSymbol,	/* 0x47 */
	XK_KP_8,	XK_Up,		NoSymbol,	/* 0x48 */
	XK_KP_9,	XK_Prior,	NoSymbol,	/* 0x49 */
	XK_KP_Subtract,	NoSymbol,	NoSymbol,	/* 0x4a */
	XK_KP_4,	XK_Left,	NoSymbol,	/* 0x4b */
	XK_KP_5,	NoSymbol,	NoSymbol,	/* 0x4c */
	XK_KP_6,	XK_Right,	NoSymbol,	/* 0x4d */
	XK_KP_Add,	NoSymbol,	NoSymbol,	/* 0x4e */
	XK_KP_1,	XK_End,		NoSymbol,	/* 0x4f */
	XK_KP_2,	XK_Down,	NoSymbol,	/* 0x50 */
	XK_KP_3,	XK_Next,	NoSymbol,	/* 0x51 */
	XK_KP_0,	XK_Insert,	NoSymbol,	/* 0x52 */
	XK_KP_Decimal,	XK_Delete,	NoSymbol,	/* 0x53 */
	XK_Execute,	NoSymbol,	NoSymbol,	/* 0x54 */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x55 */
	XK_less,	XK_greater,		NoSymbol,	/* 0x56 */
	XK_F11,		NoSymbol,	NoSymbol,	/* 0x57 */	/* 101 keys */
	XK_F12,		NoSymbol,	NoSymbol,	/* 0x58 */	/* 101 keys */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x59 */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x5a */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x5b */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x5c */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x5d */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x5e */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x5f */
	XK_KP_Enter,	NoSymbol,	NoSymbol,	/* 0x60 */
	XK_Control_R,	NoSymbol,	NoSymbol,	/* 0x61 */
	XK_Shift_L,	NoSymbol,	NoSymbol,	/* 0x62 */
	XK_KP_Divide,	NoSymbol,	NoSymbol,	/* 0x63 */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x64 */
	NoSymbol,	XK_Print,	NoSymbol,	/* 0x65 */
	XK_Alt_R,	XK_Mode_switch,	NoSymbol,	/* 0x66 */
	XK_Num_Lock,	NoSymbol,	NoSymbol,	/* 0x67 */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x68 */
	XK_Home,	NoSymbol,	NoSymbol,	/* 0x69 */
	XK_Up,		NoSymbol,	NoSymbol,	/* 0x6a */
	XK_Prior,	NoSymbol,	NoSymbol,	/* 0x6b */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x6c */
	XK_Left,	NoSymbol,	NoSymbol,	/* 0x6d */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x6e */
	XK_Right,	NoSymbol,	NoSymbol,	/* 0x6f */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x70 */
	XK_End,		NoSymbol,	NoSymbol,	/* 0x71 */
	XK_Down,	NoSymbol,	NoSymbol,	/* 0x72 */
	XK_Next,	NoSymbol,	NoSymbol,	/* 0x73 */
	XK_Insert,	NoSymbol,	NoSymbol,	/* 0x74 */
	XK_Delete,	NoSymbol,	NoSymbol,	/* 0x75 */
	XK_Meta_L,	NoSymbol,	NoSymbol,	/* 0x76 */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x77 */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x78 */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x79 */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x7a */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x7b */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x7c */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x7d */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x7e */
	NoSymbol,	NoSymbol,	NoSymbol,	/* 0x7f */
	XK_Shift_R,	NoSymbol,	NoSymbol,	/* 0x80 (fake shift) */
};
