#include <i86.h>
#include "X.h"
#define NEED_EVENTS
#include "Xproto.h"
#include "misc.h"
#include "window.h"
#include "windowstr.h"
#include "dix.h"
#include "scrnintstr.h"
#include "gcstruct.h"
#include "servermd.h"
#include "pixmap.h"
#include "pixmapstr.h"
#include "ega.h"
#include "egafuncs.h"
#include "funcs.h"
#include "mxfuncs.h"

void
InitOutput(pScreenInfo, argc, argv)
ScreenInfo *pScreenInfo;
int argc;
char **argv;
{
	pScreenInfo->imageByteOrder = IMAGE_BYTE_ORDER;
	pScreenInfo->bitmapScanlineUnit = BITMAP_SCANLINE_UNIT;
	pScreenInfo->bitmapScanlinePad = BITMAP_SCANLINE_PAD;
	pScreenInfo->bitmapBitOrder = BITMAP_BIT_ORDER;

	pScreenInfo->numPixmapFormats = 1;
	pScreenInfo->formats[0].depth = 1;
	pScreenInfo->formats[0].bitsPerPixel = 1;
	pScreenInfo->formats[0].scanlinePad = BITMAP_SCANLINE_PAD;
	(void) AddScreen(egainit, argc, argv);
}

mxSaveScreen(pScr, on)
ScreenPtr pScr;
int on;
{
	union REGS regs;

	pScr = pScr;

	regs.h.bl = 0x36;
	if (on == SCREEN_SAVER_OFF)
		regs.w.ax = 0x1200;
	else
		regs.w.ax = 0x1201;
	int386(0x10, &regs, &regs);

#ifdef notdef
	outp(0x3c4, 1);
	if (on == SCREEN_SAVER_OFF)
		outp(0x3c5, inp(0x3c5) & ~0x20);
	else
		outp(0x3c5, inp(0x3c5) | 0x20);
#endif
	return TRUE;
}

void
mxQueryBestSize(kind, pWidth, pHeight)
int kind;
unsigned short *pWidth, *pHeight;
{
	unsigned width, test;

	switch (kind) {
	    case CursorShape:
		*pWidth = 16;
		*pHeight = 16;
		break;
	    case TileShape:
	    case StippleShape:
		width = *pWidth;
		if (width > 0) {
			/* Find the smallest power of two greater than
			 * width. */
			test = 1;
			while (test < width)
				test <<= 1;
			*pWidth = test;
		}
		break;
	}
}
