#include "Xmd.h"
#include "misc.h"
#include "pixmapstr.h"
#include "os.h"		/* for malloc.h */

#include "ega.h"
#include "../../mi/mi.h"

#include "servermd.h"

#include "site.h"
#include "egafuncs.h"
#include "mxfuncs.h"

PixmapPtr
mxCreatePixmap(pScreen, width, height, depth)
ScreenPtr pScreen;
int width, height, depth;
{
	int size, devWidth;
	PixmapPtr pPixmap;

	if (depth != 1)		/* color! */
		return (PixmapPtr)NULL;
	devWidth = PixmapBytePad(width, 1);
	size = height * devWidth;
	pPixmap = (PixmapPtr)xalloc(sizeof(PixmapRec) + size);
	if (!pPixmap)
		return (PixmapPtr)NULL;
	pPixmap->drawable.type = DRAWABLE_PIXMAP;
	pPixmap->drawable.pScreen = pScreen;
	pPixmap->drawable.depth = depth;
	pPixmap->drawable.serialNumber = NEXT_SERIAL_NUMBER;
	pPixmap->drawable.width = width;
	pPixmap->drawable.height = height;
	pPixmap->drawable.x = 0;
	pPixmap->drawable.y = 0;
	pPixmap->refcnt = 1;
	pPixmap->devKind = devWidth;
	pPixmap->devPrivate.ptr = (u_char *)(pPixmap + 1);
	bzero((char *)pPixmap->devPrivate.ptr, size);
	return pPixmap;
}

Bool
mxDestroyPixmap(pPixmap)
PixmapPtr pPixmap;
{
	if (--pPixmap->refcnt)
		return TRUE;
	xfree(pPixmap);
	return TRUE;
}

#ifdef notdef
/* Rotates pixmap pPix by w pixels to the right on the screen. Assumes that
 * words are 8 bits wide, and that the least significant bit appears on the
 * left.
 */
mxXRotatePixmap(pPix, rw)
    PixmapPtr	pPix;
    int rw;
{
    unsigned char	*pw, *pwFinal;
    unsigned char i, t;

    if (pPix == NullPixmap)
        return;

    pw = (long *)pPix->devPrivate;
    rw %= pPix->width;
    if (rw < 0)
	rw += pPix->width;
    pwFinal = pw + pPix->height * (unsigned int)(pPix->devKind);
    while(pw < pwFinal)
    {
	i = 0;
	while (i < (int)pPix->devKind) {
	    t = *pw;
	*pw++ = SCRRIGHT(t, rw) | 
		(SCRLEFT(t, (32-rw)) & endtab[rw]);
	}
    }
}
#endif
