#include "X.h"
#include "Xmd.h"
#include "Xproto.h"
#include "fontstruct.h"
#include "dixfontstr.h"
#include "scrnintstr.h"

#include "ega.h"
#include "mxfuncs.h"

Bool
mxRealizeFont( pscr, pFont)
    ScreenPtr	pscr;
    FontPtr	pFont;
{
    /*
     * pGC->font is now known to be valid
     */
    FontInfoPtr		pfi = pFont->pFI;
    CharInfoPtr		pci;
    int numCols = pfi->lastCol - pfi->firstCol + 1;
    int numRows = pfi->lastRow - pfi->firstRow + 1;
    char *pglyphBase = pFont->pGlyphs;
    char *pglyph;
    int gWidth, gHeight;
    char mask;

    pscr = pscr;

    numCols *= numRows;
    for (pci = pFont->pCI; numCols-- > 0; pci++) {
	gHeight = GLYPHHEIGHTPIXELS(pci);
	gWidth = GLYPHWIDTHPIXELS(pci);
	if ((gWidth & 7) == 0)
	    continue;
	pglyph = pglyphBase + pci->byteOffset;
	mask = 0xff00 >> (gWidth & 7);
	gWidth >>= 3;
	while (gHeight-- > 0) {
		pglyph[gWidth] &= mask;
		pglyph += gWidth+1;
	}
    }
    return (TRUE);
}

Bool
mxUnrealizeFont(pscr, pFont)
ScreenPtr	pscr;
FontPtr		pFont;
{
	pscr = pscr;
	pFont = pFont;
	return TRUE;
}
