	TITLE   mif

	.386p

_BSS	segment dword public use32 'BSS'
_BSS	ends

DGROUP	GROUP _BSS

	ASSUME	cs:_TEXT, ds:DGROUP, es:nothing, ss:nothing

; Title   : Microsoft C language interface to the Logitech mouse driver
; Author  : Roger Armstrong
; Date    : 10-30-85
; System  : Microsoft Macro Assembler
; Version : 1.00

_TEXT	segment	dword public use32 'CODE'

; *******************************************************
; *							*
; *	T H E   I N T E R F A C E   R O U T I N E S	*
; *							*
; *******************************************************


; ****************************************
; *	F U N C T I O N  0  :  F l a g R e s e t	      *
; ****************************************

PUBLIC  FlagReset_
;
;     FlagReset() return the number of mouse buttons
;

FlagReset_      PROC NEAR
;	  Output: AX --> mouse status
;		   0 (FALSE): mouse hardware and software
;			      not installed
;		  -1 (TRUE) : mouse hardware and software
;			      installed
;	
	push	ebx

	xor	ax,ax		; function 0
	int	33h	  ; call mouse driver function 
	or	ax,ax
	movzx	eax,bx
	jnz	good
	xor	eax,eax
good:
	pop	ebx
	ret
FlagReset_	ENDP


; ****************************************
; *	F U N C T I O N  1  :  
; ****************************************

PUBLIC ShowCursor_
;
; ShowCursor();
;

ShowCursor_	PROC NEAR
	mov   ax, 1	; function 1
	int   33h	  ; call mouse driver function 
	ret
ShowCursor_	ENDP       

; ****************************************
; *	F U N C T I O N  2  :  
; ****************************************

PUBLIC msHideCursor_
;
; msHideCursor();
;

msHideCursor_	PROC NEAR
	mov   ax,2	; function 2
	int   33h	  ; call mouse driver function 
	ret
msHideCursor_	ENDP


if	0
; ****************************************
; *	F U N C T I O N  3  :  
; ****************************************

PUBLIC GetPosBut
;
; GetPosBut ( buttonStatus )
; struct {
;    unsigned leftButton   : 1;
;    unsigned rightButton  : 1;
;    unsigned middleButton : 1;
;	} *buttonStatus;
; int *horizontal, *vertical;
;

GetPosBut	PROC NEAR
	push	ebp
	mov	ebp,esp
	push	edi
	push	ebx

	mov	ax, 3	; function 3
	int	33h	  ; call mouse driver function 
	mov	edi, 8[ebp]    ; address of buttonStatus
	mov	[edi], bx  ; buttonStatus = bx
	mov	2[edi],cx	; horizontal
	mov	4[edi],dx	; vertical

	pop	ebx
	pop	edi
	pop	ebp
	ret
GetPosBut	ENDP

endif

; ****************************************
; *	F U N C T I O N  4  :  
; ****************************************

PUBLIC SetCursorPos_
;
; SetCursorPos (horizontal, vertical)
; int horizontal (EAX), vertical (EDX);
;

SetCursorPos_	PROC NEAR
		push	ecx
		mov	ecx,eax		; horizontal
		mov   ax, 4	; function 4
		int   33h	  ; call mouse driver function 
		pop	ecx
		ret
SetCursorPos_	ENDP

if	0

; ****************************************
; *	F U N C T I O N  5  :  
; ****************************************

PUBLIC _GetButPres
;
; GetButPres (button, buttonStatus, buttonPressCount, horizontal, vertical)
; int button, *buttonStatus, *buttonPressCount, *horizontal, *vertical;
;

_GetButPres	PROC FAR
			enter
			mov   bx, 6[bp]    ; bx = button
			mov   ax, 5	; function 5
			int   33h	  ; call mouse driver function 
			les   di, 8[bp]   ; address of buttonStatus
			mov   es:[di], ax  ; buttonStatus = ax
			les   di, 12[bp]   ; address of buttonPressCount
			mov   es:[di], bx  ; buttonPressCount = bx
			les   di, 16[bp]   ; address of horizontal
			mov   es:[di], cx  ; horizontal = cx
			les   di, 20[bp]   ; address of vertical
			mov   es:[di], dx  ; vertical = dx
			leave
_GetButPres	ENDP

; ****************************************
; *	F U N C T I O N  6  :  
; ****************************************

PUBLIC _GetButRel
;
; GetButRel (button, buttonStatus, buttonReleaseCount, horizontal, vertical)
; int button, *buttonStatus, *buttonReleaseCount, *horizontal, *vertical;


_GetButRel	PROC FAR
			enter
			mov   bx, 6[bp]    ; bx = button
			mov   ax, 6	; function 6
			int   33h	  ; call mouse driver function 
			les   di, 8[bp]    ; address of buttonStatus
			mov   es:[di], ax  ; buttonStatus = ax
			les   di, 12[bp]   ; address of buttonReleaseCount
			mov   es:[di], bx  ; buttonReleaseCount = bx
			les   di, 16[bp]   ; address of horizontal
			mov   es:[di], cx  ; horizontal = cx
			les   di, 20[bp]   ; address of vertical
			mov   es:[di], dx  ; vertical = dx
			leave
_GetButRel	ENDP

endif

; ****************************************
; *	F U N C T I O N  7  :  
; ****************************************

PUBLIC SetHorizontalLimits_
;
; SetHorizontalLimits (minPos, maxPos)
; int minPos /* EAX */, maxPos /* EDX */;
;

SetHorizontalLimits_ PROC NEAR
		push	ecx
		mov	ecx,eax		; minPos
		mov   ax, 7	; function 7
		int   33h	  ; call mouse driver function 
		pop	ecx
		ret
SetHorizontalLimits_ ENDP


; ****************************************
; *	F U N C T I O N  8  :  
; ****************************************

PUBLIC SetVerticalLimits_
;
; SetHorizontalLimits (minPos, maxPos)
; int minPos, maxPos;
;

SetVerticalLimits_ PROC NEAR
		push	ecx
		mov	ecx,eax		; minPos
		mov   ax, 8	; function 8
		int   33h	  ; call mouse driver function 
		pop	ecx
		ret
SetVerticalLimits_ ENDP

if 0

; ****************************************
; *	F U N C T I O N  9  :  
; ****************************************

PUBLIC _SetGraphicCursor
;
; typedef struct {
;    unsigned int screenMask[16],
;		 cursorMask[16];
;    int	  hotX,
;		 hotY;
;		} GraphicCursor;
;  
; SetGraphicCursor (cursor)
; GraphicCursor *cursor;
;

_SetGraphicCursor PROC FAR
			enter
			les   di, 6[bp]     ; address of screenMask
			mov   dx, di	; es:dx = address of screenMask
			mov   bx, es:64[di] ; bx = hotX
			mov   cx, es:66[di] ; cx = hotY
			mov   ax, 9	 ; function 9
			int   33h	   ; call mouse driver function 
			leave
_SetGraphicCursor ENDP


; ****************************************
; *	F U N C T I O N  11  : 
; ****************************************

PUBLIC _ReadMotionCounters
;
; ReadMotionCounters ( horizontal, vertical )
; int *horizontal, *vertical;
;

_ReadMotionCounters PROC FAR
			enter
			mov   ax, 11       ; function 11 
			int   33h	  ; call mouse driver function 
			les   di, 6[bp]    ; address of horizontal
			mov   es:[di], cx  ; horizontal = cx
			les   di, 10[bp]   ; address of vertical
			mov   es:[di], dx  ; vertical = dx
			leave
_ReadMotionCounters ENDP

; ****************************************
; *	F U N C T I O N  12  : 
; ****************************************

; SetEventHandler (mask, handler)
; int mask;
; _Far int *handler();

PUBLIC SetEventHandler

SetEventHandler PROC NEAR
	ASSUME	ds:DGROUP
		push	ebp
		mov	ebp,esp
		push	ebx
		push	ds
		push	es

		mov	ax,cs
		or	ax,8
		mov	es,ax
	ASSUME	es:_TEXT
		mov	ax,ds
		mov	es:[save_ds],ax

		mov	eax,12[ebp]		; handler
		mov	event_hand,eax

		mov	ecx,8[ebp]	; mask
		mov	al,rps_handle
		mov	edx,offset rps_buf
		mov	ds:[edx],al
		mov	ds:[edx+2],cx		; mask
		mov	ecx,4
		xor	ebx,ebx
		mov	ah,0e1h
		mov	al,rpc_handle
		int	21h

		pop	es
	assume	es:nothing
		pop	ds
		pop	ebx
		pop	ebp
		ret
SetEventHandler ENDP

mouse_handler	proc far
	assume	ds:nothing
		pushad
		push	ds
		push	es
		push	gs
		push	fs
		cld

		mov	ax,cs:[save_ds]
		mov	ds,ax
	assume	ds:DGROUP
		mov	es,ax
	assume	es:DGROUP

		movzx	ebx,bx
		movzx	ecx,cx
		movzx	edx,dx
		movzx	esi,si

		push	edx			; vert
		push	ecx			; horz
		push	ebx			; button
		push	esi			; condition

		call	[event_hand]
;		mov	eax,event_hand
;		call	eax

		add	esp,16
		pop	fs
		pop	gs
		pop	es
	assume	es:nothing
		pop	ds
	assume	ds:nothing
		popad
		iretd
mouse_handler	endp

PUBLIC ClearEventHandler

ClearEventHandler PROC NEAR
;			mov   word ptr cs:hand_ptr[0], ax
;			mov   word ptr cs:hand_ptr[2], ax
			xor	edx,edx
			xor	ecx,ecx
			mov   ax, 12       ; function 12
			int   33h	  ; call mouse driver function 
			ret
ClearEventHandler ENDP


; ****************************************
; *	F U N C T I O N  13  : 
; ****************************************

PUBLIC _LightPenOn
;
; LightPenOn ();
;

_LightPenOn PROC FAR
			enter
			mov   ax, 13       ; function 13
			int   33h	  ; call mouse driver function 
			leave
_LightPenOn ENDP


; ****************************************
; *	F U N C T I O N  14  :
; ****************************************

PUBLIC _LightPenOff
;
; LightPenOff ();
;

_LightPenOff PROC FAR
			enter
			mov   ax, 14	; function 14
			int   33h	  ; call mouse driver function 
			leave
_LightPenOff ENDP

endif

; ****************************************
; *	F U N C T I O N  15  : 
; ****************************************

PUBLIC SetMickeysPerPixel_
;
; SetMickeysPerPixel (horPix, verPix)
; unsigned int horPix, verPix;
;

SetMickeysPerPixel_ PROC NEAR
			push	ecx
			push	ebx
			mov	ecx,eax		; horPix
			mov	ax,15       ; function 15
			int	33h	  ; call mouse driver function 
			pop	ebx
			pop	ecx
			ret
SetMickeysPerPixel_ ENDP

if 0

; ****************************************
; *	F U N C T I O N  16  : 
; ****************************************

PUBLIC _ConditionalOff
;
; ConditionalOff (left, top, right, bottom)
; int left, top, right, bottom;
;

_ConditionalOff PROC FAR
			enter
			mov   cx,  6[bp]   ; cx = left
			mov   dx,  8[bp]   ; dx = top
			mov   si,  10[bp]  ; si = right
			mov   di,  12[bp]  ; di = bottom
			mov   ax, 16       ; function 16
			int   33h	  ; call mouse driver function 
			leave
_ConditionalOff ENDP			

endif


; ****************************************
; *	F U N C T I O N  19  : 
; ****************************************

PUBLIC SetSpeedThreshold_
;
; SetSpeedThreshold (threshold)
; unsigned int threshold;
;

SetSpeedThreshold_ PROC NEAR
			push	edx
			mov	edx,eax		; threshold
			mov	ax,19	; function 19
			int	33h	   ; call mouse driver function 
			pop	edx
			ret
SetSpeedThreshold_ ENDP

; ****************************************
; *	F U N C T I O N  26  : 
; ****************************************

PUBLIC	SetMouseSensitivity_
;
; SetMouseSensitivity(horz, vert, threshold)
; hort (EAX)   vert (EDX)  threshold (EBX)
;

SetMouseSensitivity_ PROC NEAR
	push	ecx
	mov	ecx,edx			; vert
	mov	edx,ebx			; threshold
	mov	ebx,eax			; hort
	mov	ax,26
	int	33h
	pop	ecx
	ret
SetMouseSensitivity_ ENDP

; ****************************************
; *	F U N C T I O N  29  : 
; ****************************************

if	0

PUBLIC _SetCRTPage
;
; SetCRTPage(page)
; int page;
;

_SetCRTPage PROC FAR
		enter
		mov	bx,6[bp]	; bx = crt page number
		mov	ax,29		; function 29
		int	33h
		leave
_SetCRTPage ENDP
endif

PUBLIC	GetVers_
GetVers_	PROC NEAR
	push	ecx
	push	ebx

	mov	ax,36
	int	33h
	mov	ax,cx
	shl	eax,16
	mov	ax,bx

	pop	ebx
	pop	ecx
	ret
GetVers_	ENDP

_TEXT	ends
	end
