#define FAR _far
#include "c:/os386/aiacode/os386.h"
#include "shared.h"
#include "funcdef.h"

extern struct real_data shared;
extern int	ip_handle;

dump_regs(taskid, status)
unsigned short taskid;
unsigned short status;
{
	int i;
	TSS_386 tss;

	taskid = OS386_Get_Task_ID();
	dfputs("Process faulted ");
	printn(status);
	dfputs("\r\n");
	if (shared.kbdopen)
		kbd_shutdown();
	if (shared.mouseopen)
		mouse_shutdown();
	if (ip_handle)
		pkclose();
	if ((i = OS386_Read_Mem(taskid, OS386_Get_TSS(taskid), 0L,
	    sizeof (tss), &tss)) != R_OK) {
		dfputs("Can't read TSS ");
		printn(i);
		dfputs("\r\n");
		return 1;
	}
	dfputs("eip=");
	printn((u_short)(tss.eip >> 16));
	printn((u_short)tss.eip);
	dfputs("\tcs=");
	printn(tss.cs);
	dfputs("\tds=");
	printn(tss.ds);
	dfputs("\tes=");
	printn(tss.es);
	dfputs("\tfs=");
	printn(tss.fs);
	dfputs("\tgs=");
	printn(tss.gs);
	dfputs("\r\nesi=");
	printn((u_short)(tss.esi >> 16));
	printn((u_short)tss.esi);
	dfputs("\tedi=");
	printn((u_short)(tss.edi >> 16));
	printn((u_short)tss.edi);
	dfputs("\r\neax=");
	printn((u_short)(tss.eax >> 16));
	printn((u_short)tss.eax);
	dfputs("\tebx=");
	printn((u_short)(tss.ebx >> 16));
	printn((u_short)tss.ebx);
	dfputs("\tecx=");
	printn((u_short)(tss.ecx >> 16));
	printn((u_short)tss.ecx);
	dfputs("\tedx=");
	printn((u_short)(tss.edx >> 16));
	printn((u_short)tss.edx);
	dfputs("\r\n");
	return 33;
}

static char nums[] ="0123456789abcdef";
static char n_buf[5];

void _fastcall
printn(n)
unsigned short n;
{
	char *cp = &n_buf[4];
	int i;

	*cp = 0;
	for (i = 0; i < 4; i++) {
		*--cp = nums[n & 15];
		n >>= 4;
	}
	dfputs(cp);
}
