#include <string.h>
#include "pcdefs.h"
#include "config.h"
#include "shared.h"
#include "data.h"
#include "funcdef.h"

struct ip blankip;
u_char myether[DADDLEN];	/* my ethernet hardware address */
u_char etherall[DADDLEN] = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };
struct port *portlist[NPORTS];

/*
*   for each new type of protocol, put an initialization call here.
*   There may be some requirement of order of initialization.
*/
void
protinit()
{
	int	i;

	_fmemcpy(myether, pkshared->myether, DADDLEN);
	memcpy(blankip.d.dest, etherall, DADDLEN);
	memcpy(blankip.d.me, myether, DADDLEN);	/* always from me */
	blankip.d.type = EIP;

	/* ip */
/*
*  create a mask which can determine whether a machine is on the same wire
*  or not.  RFC950
*  Only set the mask if not previously set.
*  This mask may be replaced by a higher level request to set the subnet mask.
*/
	/* smallest header, version 4 */
	blankip.i.versionandhdrlen = 0x40 | sizeof(struct iph) >> 2;
	blankip.i.service = 0;			/* normal service */
	blankip.i.tlen = htons(576);		/* no data yet, maximum size */
	blankip.i.ident = 0;
	blankip.i.frags = 0;		/* not a fragment of a packet */
	blankip.i.ttl = 100;		/* 100 seconds should be enough */
	blankip.i.protocol = PROTUDP;	/* default to UDP */
	blankip.i.check = 0;		/* disable checksums for now */
	/* my return address */
	blankip.i.ipsource = Scon.myip;
	if (!Scon.flags) {
		if (!Scon.broadcast)
			Scon.broadcast = Scon.myip | ~Scon.snetmask;
		switch ((u_char)Scon.myip >> 6) {
		    case 0:			/* class A */
		    case 1:
			nmask = 0x000000ffL;
			break;
		    case 2:			/* class B */
			nmask = 0x0000ffffL;
			break;
		    case 3:			/* class C */
			nmask = 0x00ffffffL;
			break;
		}
	}
	blankip.i.ipdest = Scon.broadcast;
	*ipout = blankip;

	/* portlist */
	for (i = 0; i < NPORTS; i++)
		portlist[i] = 0;		/* no ports open yet */
}
