RAWETHER	EQU	8192
NBPEB		EQU	128	; minumum ebuf allocation
NMBUFS		EQU	(RAWETHER / NBPEB)
NEBUFS		EQU	(RAWETHER / NBPEB / 2)
MTU		EQU	1500
NARPC		EQU	10

ebuf	STRUC
start_addr	dw	?
count		dw	?
ebuf	ENDS

mbuf	STRUC
dptr	dw	?
next	dw	?
len	dw	?
mbuf	ENDS

ether	STRUC
dest	db	6 dup (?)
source	db	6 dup (?)
etype	dw	?
ether	ENDS

acache	STRUC
hrd	db	6 dup (?)
ip	dd	?
tm	dd	?
acache	ENDS

arp	STRUC
d	db	(size ether) dup (?)
hrdt	dw	?
pro	dw	?
hln	db	?
pln	db	?
op	dw	?
sha	db	6 dup (?)
spa	dd	?
tha	db	6 dup (?)
tpa	dd	?
arp	ENDS

packet_info	STRUC
version		dw	?
class		dw	?
pktype		dw	?
ifnum		dw	?
pkname		dd	?
extend		dw	?
packet_info	ENDS

real_data	STRUC
rps_handle	db	?
arpqueued	db	?
prot_ds		dw	?	; Protected mode DS
innet		dw	?
mbfree		dw	?
mbprocess	dw	?
mbnext		dw	?
mb		db	(NMBUFS * size mbuf) dup (?)
eb		db	((NEBUFS + 1) * size ebuf) dup (?)
etherbuff	db	RAWETHER dup (?)
xmitlen		dw	?
xmitbuf		db	(MTU + size ether) dup (?)
xmitarp		db	(size arp) dup (?)
myether		db	6 dup (?)
slip_mode	dw	?
arpc		db	(NARPC * size acache) dup (?)
p		db	(size packet_info) dup (?)
myip		dd	?
real_data	ENDS
