/*
*    data.h
*   Declarations of global variables for TCP/IP libraries
*
****************************************************************************
*                                                                          *
*                                                                          *
*      NCSA Telnet                                                         *
*      by Tim Krauskopf; VT100 by Gaige Paulsen, Tek by Aaron Contorer     *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign; IL  61820                                                *
*                                                                          *
****************************************************************************
*         
*/

#define DLAYTIMEOUT	10
/*
*  how often to poke a TCP connection to keep it alive and make
*  sure other side hasn't crashed. (poke) in 1/18ths sec
*  And, timeout interval
*/
#define POKEINTERVAL 3000
#define WAITTIME 35
#define LASTTIME 4000
#define MAXSEG 1400
#define MSS_SMALL	(512-40)

extern struct conf	Scon;
extern u_char myether[DADDLEN];	/* my ethernet hardware address */
extern u_char etherall[DADDLEN];	/* the broadcast address */
extern u_long ipall;
extern u_long nameserver;
extern u_long nmask;
extern u_short nnipident;		/* ident field of ip */
extern u_short slip_mode;
extern char needtcp;		/* true if tcptick need be called */

extern struct pseudotcp otcps;
extern struct pseudotcp itcps;
extern struct port * portlist[NPORTS]; /* allocate like in UNIX */
extern struct route_st route[NPORTS];	/* our routing table */

union rawether {
	struct ip	ip;
	struct udp	udp;
	struct tcp	tcp;
	struct icmp	icmp;
	u_char data[MTU + sizeof(struct ether)];
};
#define rawip(x) ((x)->ip)
#define rawudp(x) ((x)->udp)
#define rawtcp(x) ((x)->tcp)
#define rawicmp(x) ((x)->icmp)
#define rawdata(x) ((x)->data)

#define ipout ((struct ip _far *)pkshared->xmitbuf)
#define udpout ((struct udp _far *)pkshared->xmitbuf)
#define tcpout ((struct tcp _far *)pkshared->xmitbuf)
#define icmpout ((struct icmp _far *)pkshared->xmitbuf)
#define rawout (pkshared->xmitbuf)

extern struct ip blankip;

#define dfputs(s)
