/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1994 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include <pctcp/types.h>
#include "../defs.h"
#include "funcdef.h"

extern int neterrno;

/* We use the intrinsic version of this function. */
int memcmp(void const _far *, void const _far *, unsigned);

#define	FIRST_VEC	0x20
#define	LAST_VEC	0xE0

int _fastcall
tcp_init(arg, len, buf)
int arg, *len;
void _far *buf;
{
    char _far *vptr;
    unsigned short vector;


    for (vector = FIRST_VEC; vector < LAST_VEC; vector++) {
	vptr = *(char _far * _far *)(unsigned long)(vector << 2) + 3;
	if (!memcmp(vptr, "TCPTSR", 6)) {
	    patch_vec(vector);
	    dfputs("PC/TCP transport layer\r\n");
	    return(0);	/* Success */
	}
    }
    dfputs("PCTCP resident module is not loaded.\r\n");
    neterrno = NETERR_NOTLOADED;
    return -1;
}
