/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1993 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include "../defs.h"
#include <sys/socket.h>

#define ERROR_BASE	35

static int map[] = {
	NETERR_WOULD_BLOCK,	/* 35 = EWOULDBLOCK */
	NETERR_WOULD_BLOCK,	/* 36 = EINPROGRESS */
	NETERR_WOULD_BLOCK,	/* 37 = EALREADY */
	NETERR_BADFD,		/* 38 = ENOTSOCK */
	NETERR_BADARGS,		/* 39 = EDESTADDRREQ */
	NETERR_NOMEM,		/* 40 = EMSGSIZE */
	NETERR_BADARGS,		/* 41 = EPROTOTYPE */
	NETERR_NOSUPPORT,	/* 42 = ENOPROTOOPT */
	NETERR_NOSUPPORT,	/* 43 = EPROTONOSUPPORT */
	NETERR_NOSUPPORT,	/* 44 = ESOCKONOSUPPORT */
	NETERR_NOSUPPORT,	/* 45 = EOPNOTSUPP */
	NETERR_NOSUPPORT,	/* 46 = EPFNOSUPPORT */
	NETERR_NOSUPPORT,	/* 47 = EAFNOSUPPORT */
	NETERR_ADDRINUSE,	/* 48 = EADDRINUSE */
	NETERR_NOSUPPORT,	/* 49 = EADDRNOTAVAIL */
	NETERR_NETUNREACH,	/* 50 = ENETDOWN */
	NETERR_NETUNREACH,	/* 51 = ENETUNREACH */
	NETERR_NETUNREACH,	/* 52 = ENETRESET */
	NETERR_CONNREFUSED,	/* 53 = ECONNABORTED */
	NETERR_CONNREFUSED,	/* 54 = ECONNRESET */
	NETERR_NOMEM,		/* 55 = ENOBUFS */
	NETERR_OTHER+3,		/* 56 = EISCONN */
	NETERR_NOTESTAB,	/* 57 = ENOTCONN */
	NETERR_NOTESTAB,	/* 58 = ESHUTDOWN */
	NETERR_SYSTEM,		/* 59 = ETOOMANYREFS */
	NETERR_TIMEOUT,		/* 60 = ETIMEDOUT */
	NETERR_CONNREFUSED,	/* 61 = ECONNREFUSED */
	NETERR_SYSTEM,		/* 62 = ELOOP */
	NETERR_SYSTEM,		/* 63 = ENAMETOOLONG */
	NETERR_NETUNREACH,	/* 64 = EHOSTDOWN */
	NETERR_NETUNREACH,	/* 65 = EHOSTUNREACH */
	NETERR_NOTLOADED,	/* 66 = ENOTINSTLD */
	NETERR_NOSUPPORT,	/* 67 = EASYNCNOTSUPP */
	NETERR_NOSUPPORT,	/* 68 = ESYNCNOTSUPP */
	NETERR_NOMEM,		/* 69 = ENO_RCB */
};

#define nerrors (sizeof map / sizeof map[0])

int _fastcall
convert_error(err)
int err;
{
    if (err >= ERROR_BASE && err < ERROR_BASE + nerrors) {
	err -= ERROR_BASE;
	return map[err];
    }
    return NETERR_ERRNO;
}
