/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1992 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include "../defs.h"
#include "local.h"

int _fastcall
convert_error()
{
    switch (errno) {
	case TCP_ERR_USR_HANGUP:
	case TCP_ERR_RESET:
	    return NETERR_CONNREFUSED;
	case TCP_ERR_HANGUP:
	case TCP_ERR_NET_ERR:
	case TCP_ERR_IS_CLOSED:
	case TCP_ERR_SHUTDOWN:
	    return NETERR_NOTESTAB;
	case TCP_ERR_TIME_OUT:
	    return NETERR_TIMEOUT;
	case TCP_ERR_FULL:
	    return NETERR_NOMEM;
	case TCP_ERR_BLOCK:
	case EWOULDBLOCK:
	    return NETERR_WOULD_BLOCK;
	case EMSGSIZE:
	    return NETERR_BADARGS;
	case EAFNOSUPPORT:
	    return NETERR_NOSUPPORT;
	default:
	    return NETERR_ERRNO;
    }
}
