/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1995 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include "pcdefs.h"
#include "protocol.h"
#include "funcdef.h"
#include "../defs.h"
#include "../funcs.h"
#include "config.h"
#include "tcp.h"

extern struct tcpport _far *ports[NPORTS];
extern char _near shared_buf[4096];
extern int neterrno;

int _fastcall
tcp_read(fd, len, buf)
int fd, *len;
void _far *buf;
{
    int count;
    struct tcpport _far *p = ports[fd];

    if (fd >= NPORTS || !p ||
      (p->flag & (O_OPEN|O_STREAM)) != (O_OPEN|O_STREAM)) {
	neterrno = NETERR_BADFD;
	return -1;
    }
    if (p->state < SEST) {
	neterrno = NETERR_NOTESTAB;
	return -1;
    }
    count = p->infree - p->inbase;
    if (!count) {
	if (p->flag & O_GOTALL)
	    neterrno = NETERR_NOTESTAB;
	else
	    neterrno = NETERR_WOULD_BLOCK;
	return -1;
    }
    if (count <= *len) {
	memcpy(buf, &p->datain[p->inbase], count);
	p->inbase = 0;
	p->infree = 0;
	/* If the window was < 1/2, then send fast to wake other
	 * side up.
	 */
	if (p->credit < 2048)
		p->wait_tx = 4;
	else {
		if (!p->wait_tx || p->wait_tx > 50)
			p->wait_tx = 50;
		else if (p->wait_tx > 4)
			p->wait_tx -= 4;
	}
	p->credit = WINDOWSIZE;
	*len = count;
	return count;
    }
    memcpy(buf, &p->datain[p->inbase], *len);
    count -= *len;
    p->inbase += *len;
    /* If there is more to read, we will probably read it in the
     * near future, so don't send a window update yet unless
     * the window size has increased from zero.
     */
    if (p->inbase > WINDOWSIZE / 4) {
	    memcpy(p->datain, &p->datain[p->inbase], count);
	    p->infree = count;
	    if (p->credit < 1024 && count < WINDOWSIZE - 1024)
		    p->wait_tx = 4;
	    else {
		    /* count will be < 3072.  The lower count, the
		     * bigger the window size.  If the window size
		     * is big, send faster.  count >> 6 will be between
		     * 0 and 48. */
		    if (!p->wait_tx || p->wait_tx > 25)
			    p->wait_tx = (count >> 6) + 4;
		    else if (p->wait_tx > 3)
			    p->wait_tx -= 3;
	    }
	    p->credit = WINDOWSIZE - count;
	    p->inbase = 0;
    }
    return *len;
}

int _fastcall
tcp_write(fd, len, buf)
int fd, *len;
void _far *buf;
{
    struct tcpport _far *p = ports[fd];

    if (fd >= NPORTS || !p ||
      (p->flag & (O_OPEN|O_STREAM)) != (O_OPEN|O_STREAM)) {
	neterrno = NETERR_BADFD;
	return -1;
    }
    if (p->state < SEST || p->flag & (O_CLOSING|O_CLOSED)) {
	neterrno = NETERR_NOTESTAB;
	return -1;
    }

    *len = min((u_short)*len, WINDOWSIZE - p->outfree);
    if (!*len) {
	neterrno = NETERR_WOULD_BLOCK;
	return -1;
    }
    memcpy(&p->dataout[p->outfree], buf, *len);
    p->outfree += *len;
    if ((int)p->outfree == *len || p->rto < (u_short)(n_clicks() - p->lasttime))
	    transq(p);
    return *len;
}

int _fastcall
tcp_eof(fd, len, buf)
int fd, *len;
void _far *buf;
{
    if (SoClose(fd) < 0)
	return -1;
    return 0;
}

int _fastcall
SoClose(fd)
unsigned fd;
{
    struct tcpport _far *p = ports[fd];

    if (fd >= NPORTS || !p ||
      (p->flag & (O_OPEN|O_STREAM)) != (O_OPEN|O_STREAM)) {
	neterrno = NETERR_BADFD;
	return -1;
    }
    switch (p->state) {
	case SLISTEN:		/* we don't care anymore */
	case SSYNS:
	    p->state = SCLOSED;
	case SCLOSED:
	    p->flag |= O_CLOSED;
	    break;
	case SEST:		/* must initiate close */
	case SCWAIT:		/* other side already closed */
				    /* send FIN */
	    if (!p->outfree) {
		    p->flag |= O_CLOSED;
		    p->outpkt.t.flags = TFIN | TACK;
		    tcpsend(p, 0);
		    if (p->state == SEST)
			    p->state = SFW1; /* wait for ACK of FIN */
		    else
			    p->state = SLAST;
	    } else {
		    p->flag |= O_CLOSING;
	    }
	    break;
	default:
	    neterrno = NETERR_NOTESTAB;
	    return -1;
    }
    return 0;
}

int _fastcall
tcp_drain(fd, len, buf)
int fd, *len;
void _far *buf;
{
    int count;
    struct tcpport _far *p = ports[fd];

    if (fd >= NPORTS || !p ||
      (p->flag & (O_OPEN|O_STREAM)) != (O_OPEN|O_STREAM)) {
	neterrno = NETERR_BADFD;
	return -1;
    }
    if (p->state < SEST) {
	neterrno = NETERR_NOTESTAB;
	return -1;
    }
    count = p->infree - p->inbase;
    if (!count) {
	if (p->flag & O_GOTALL)
	    neterrno = NETERR_NOTESTAB;
	else
	    neterrno = NETERR_WOULD_BLOCK;
	return -1;
    }
    p->inbase = 0;
    p->infree = 0;
    /* If the window was < 1/2, then send fast to wake other
     * side up.
     */
    if (p->credit < 2048)
	    p->wait_tx = 4;
    else {
	    if (!p->wait_tx || p->wait_tx > 50)
		    p->wait_tx = 50;
	    else if (p->wait_tx > 4)
		    p->wait_tx -= 4;
    }
    p->credit = WINDOWSIZE;
    return count;
}
