/*
 * Micro-X -- an X server for DOS
 * Copyright (C) 1992 StarNet Communications Corp.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * StarNet Communications Corp.
 * 550 Lakeside Dr. #3
 * Sunnyvale CA 94086 US
 * http://www.starnet.com
 * x-dos@starnet.com
 */

#include "..\..\net\h\protocol.h"
#include "..\..\net\h\mbuf.h"

struct mouse_event {
	unsigned short event_mask;
	unsigned short buttons;
	short xdiff;
	short ydiff;
};

#define ETHER_MTU 1514
#define KBDBUFSIZE 32
#define MOUSEBUFSIZE 32

#ifdef __HIGHC__
_packed
#endif
#ifdef __WATCOMC__
#pragma pack(1);
#endif
struct real_data {
	unsigned short input;
	unsigned short kbd_start;
	unsigned short kbd_end;
	unsigned char kbd_buff[KBDBUFSIZE];
	unsigned short mouse_start;
	unsigned short mouse_end;
	struct mouse_event mouse_buff[MOUSEBUFSIZE];
	unsigned char kbdopen, mouseopen;
	unsigned char rps_handle;
	unsigned char arpqueued;
	unsigned short prot_ds;		/* protected-mode DS */

	unsigned short innet;
#if defined(__HIGHC__) || defined(__WATCOMC__)
	unsigned short mbfree, mbprocess, mbnext;
#else
	struct mbuf _near *mbfree, _near *mbprocess, _near * _near *mbnext;
#endif
	struct mbuf mb[NMBUFS];
	struct ebuf eb[NEBUFS+1];
	unsigned char etherbuff[RAWETHER];

	/* Xmit stuff */
	unsigned short xmitlen;
	unsigned char xmitbuf[ETHER_MTU];
	struct arp xmitarp;

	/* Misc stuff */
	unsigned char myether[DADDLEN];
	unsigned short slip_mode;
	struct acache arpc[NARPC]; /* cache for hardware addresses */
	struct packet_info p;
	unsigned long myip;

};

#ifdef __HIGHC__
extern struct real_data _Far *pkshared;
#endif
#ifdef __WATCOMC__
extern struct real_data _far *pkshared;
#pragma pack;
#endif
